/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmTextComponent;

public class DateField
extends Item {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    private int mode;
    private TimeZone timeZone = TimeZone.getDefault();
    private ScmTextComponent dateField = new ScmTextComponent(this, "dateField", true);
    private ScmTextComponent timeField = new ScmTextComponent(this, "dateField", true);

    public DateField(String label, int mode, TimeZone timeZone) {
        super(label);
        this.timeZone = timeZone;
        this.setDate(null);
        if ((mode & 1) != 0) {
            this.lines.addElement(this.dateField);
        }
        if ((mode & 2) != 0) {
            this.lines.addElement(this.timeField);
        }
        this.mode = mode;
    }

    public DateField(String label, int mode) {
        this(label, mode, TimeZone.getDefault());
    }

    public Date getDate() {
        try {
            String s;
            Calendar c = Calendar.getInstance(this.timeZone);
            if ((this.mode & 1) != 0) {
                s = this.dateField.getText();
                c.set(1, Integer.parseInt(s.substring(0, 4)));
                c.set(2, Integer.parseInt(s.substring(5, 7)) - 1 + 0);
                c.set(5, Integer.parseInt(s.substring(8, 10)));
            } else {
                c.setTime(new Date(0L));
            }
            if ((this.mode & 2) != 0) {
                s = this.timeField.getText();
                c.set(11, Integer.parseInt(s.substring(0, 2)));
                c.set(12, Integer.parseInt(s.substring(3, 5)));
            } else {
                c.set(11, 0);
                c.set(12, 0);
            }
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String digits(int i, int n) {
        String result = "" + i;
        while (result.length() < n) {
            result = "0" + result;
        }
        return result;
    }

    public int getInputMode() {
        return this.mode;
    }

    public void setInputMode(int mode) {
        this.mode = mode;
    }

    public void setDate(Date date) {
        if (date == null) {
            this.dateField.setText("yyyy-mm-dd");
            this.timeField.setText("hh:mm");
        } else {
            Calendar c = Calendar.getInstance(this.timeZone);
            c.setTime(date);
            this.dateField.setText(this.digits(c.get(1), 4) + "-" + this.digits(c.get(2) + 1 - 0, 2) + "-" + this.digits(c.get(5) + 1, 2));
            this.timeField.setText(this.digits(c.get(11), 2) + ":" + this.digits(c.get(12), 2));
        }
    }
}

