/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.failure.mappers;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.ThrowableToTestFailureMapper;
import org.gradle.api.tasks.testing.TestFailure;

public class OpenTestAssertionFailedMapper
extends TestFailureMapper {
    @Override
    protected List<String> getSupportedClassNames() {
        return Collections.singletonList("org.opentest4j.AssertionFailedError");
    }

    @Override
    public TestFailure map(Throwable throwable, ThrowableToTestFailureMapper rootMapper) throws Exception {
        Object expectedValueWrapper = OpenTestAssertionFailedMapper.invokeMethod(throwable, "getExpected", Object.class);
        Object expectedValue = OpenTestAssertionFailedMapper.invokeMethod(expectedValueWrapper, "getValue", Object.class);
        Object actualValueWrapper = OpenTestAssertionFailedMapper.invokeMethod(throwable, "getActual", Object.class);
        Object actualValue = OpenTestAssertionFailedMapper.invokeMethod(actualValueWrapper, "getValue", Object.class);
        if (expectedValue.getClass().getName().equals("org.opentest4j.FileInfo") || actualValue.getClass().getName().equals("org.opentest4j.FileInfo")) {
            return OpenTestAssertionFailedMapper.mapFileInfoComparisonFailure(throwable, expectedValue, actualValue);
        }
        return OpenTestAssertionFailedMapper.mapStringBasedComparisonFailure(throwable, expectedValueWrapper, actualValueWrapper);
    }

    private static TestFailure mapFileInfoComparisonFailure(Throwable throwable, Object expected, Object actual) throws Exception {
        String expectedPath = OpenTestAssertionFailedMapper.extractValue(expected);
        byte[] expectedContent = OpenTestAssertionFailedMapper.extractContent(expected);
        String actualPath = OpenTestAssertionFailedMapper.extractValue(actual);
        byte[] actualContent = OpenTestAssertionFailedMapper.extractContent(actual);
        return TestFailure.fromFileComparisonFailure((Throwable)throwable, (String)expectedPath, (String)actualPath, (byte[])expectedContent, (byte[])actualContent, null);
    }

    private static TestFailure mapStringBasedComparisonFailure(Throwable throwable, Object expected, Object actual) throws Exception {
        String expectedValue = OpenTestAssertionFailedMapper.extractValue(expected);
        String actualValue = OpenTestAssertionFailedMapper.extractValue(actual);
        return TestFailure.fromTestAssertionFailure((Throwable)throwable, (String)expectedValue, (String)actualValue, null);
    }

    @Nullable
    private static String extractValue(@Nullable Object valueWrapper) throws Exception {
        if (valueWrapper == null) {
            return null;
        }
        if (valueWrapper.getClass().getName().equals("org.opentest4j.FileInfo")) {
            return OpenTestAssertionFailedMapper.invokeMethod(valueWrapper, "getPath", String.class);
        }
        if (valueWrapper.getClass().getName().equals("org.opentest4j.ValueWrapper")) {
            return OpenTestAssertionFailedMapper.invokeMethod(valueWrapper, "getStringRepresentation", String.class);
        }
        if (valueWrapper.getClass().getName().equals("java.lang.String")) {
            return (String)valueWrapper;
        }
        return null;
    }

    @Nullable
    private static byte[] extractContent(@Nullable Object valueWrapper) throws Exception {
        if (valueWrapper == null) {
            return null;
        }
        if (valueWrapper.getClass().getName().equals("org.opentest4j.FileInfo")) {
            return OpenTestAssertionFailedMapper.invokeMethod(valueWrapper, "getContents", byte[].class);
        }
        return null;
    }
}

