/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PANEL_H
#define PANEL_H

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

#define PANEL_X 0
#define PANEL_Y 0

#define PANEL_PICTURE_X 44
#define PANEL_PICTURE_Y 150
#define PANEL_CARAC_WIDTH 64
#define PANEL_CARAC_HEIGHT 32
#define PANEL_MA_X 196
#define PANEL_MA_Y 150
#define PANEL_ST_X 196
#define PANEL_ST_Y 188
#define PANEL_AG_X 196
#define PANEL_AG_Y 227
#define PANEL_AV_X 196
#define PANEL_AV_Y 267
#define PANEL_COST_X 45
#define PANEL_COST_Y 375
#define PANEL_COST_WIDTH 210
#define PANEL_COST_HEIGHT 37
#define PANEL_MISC_X 196
#define PANEL_MISC_Y 310
#define PANEL_MISC_WIDTH 64
#define PANEL_MISC_HEIGHT 60
#define PANEL_NAME_X 30
#define PANEL_NAME_Y 104
#define PANEL_NAME_WIDTH 242
#define PANEL_NAME_HEIGHT 42

#define PANEL_SECONDS_X 188
#define PANEL_SECONDS_Y 548
#define PANEL_SECONDS_WIDTH 33
#define PANEL_SECONDS_HEIGHT 17
    
#define PANEL_MINUTES_X 157
#define PANEL_MINUTES_Y 548
#define PANEL_MINUTES_WIDTH 20
#define PANEL_MINUTES_HEIGHT 17

#define PANEL_HOME_REROLL_X 68 
#define PANEL_HOME_REROLL_Y 505
#define PANEL_HOME_REROLL_WIDTH 26
#define PANEL_HOME_REROLL_HEIGHT 27

#define PANEL_VISITOR_REROLL_X 68
#define PANEL_VISITOR_REROLL_Y 540
#define PANEL_VISITOR_REROLL_WIDTH 26
#define PANEL_VISITOR_REROLL_HEIGHT 27

#define PANEL_HOME_SCORE_X 157
#define PANEL_HOME_SCORE_Y 509
#define PANEL_HOME_SCORE_WIDTH 22
#define PANEL_HOME_SCORE_HEIGHT 30
  
#define PANEL_VISITOR_SCORE_X 197
#define PANEL_VISITOR_SCORE_Y 509 
#define PANEL_VISITOR_SCORE_WIDTH 22
#define PANEL_VISITOR_SCORE_HEIGHT 30

#define PANEL_HOME_TURN_X 39
#define PANEL_HOME_TURN_Y 428

#define PANEL_VISITOR_TURN_X 39 
#define PANEL_VISITOR_TURN_Y 464

#define PANEL_TURN_WIDTH 32
#define PANEL_TURN_HEIGHT 32

#define PANEL_HOME_TURN_INDIC_X 3
#define PANEL_HOME_TURN_INDIC_Y 428

#define PANEL_VISITOR_TURN_INDIC_X 3
#define PANEL_VISITOR_TURN_INDIC_Y 464

#define PANEL_TURN_INDIC_WIDTH 30
#define PANEL_TURN_INDIC_HEIGHT 30

#define PANEL_PLAYER_INFO_X PANEL_NAME_X 
#define PANEL_PLAYER_INFO_Y PANEL_NAME_Y 
#define PANEL_PLAYER_INFO_WIDTH PANEL_NAME_WIDTH
#define PANEL_PLAYER_INFO_HEIGHT PANEL_COST_Y+PANEL_COST_HEIGHT

#define PANEL_WHEELS_X 112
#define PANEL_WHEELS_Y 508
#define PANEL_WHEELS_WIDTH 40
#define PANEL_WHEELS_HEIGHT 58
#define PANEL_WHEELS_FRAMES 13    

#define PANEL_URL_X 0
#define PANEL_URL_Y 574
#define PANEL_URL_WIDTH 220
#define PANEL_URL_HEIGHT 26

#define PANEL_CARAC_FONT 0
#define PANEL_SCORE_FONT 0
#define PANEL_LOWER_FONT 1
#define PANEL_UPPER_FONT 2
#define PANEL_TIME_FONT 3
#define PANEL_REROLL_FONT 4
#define PANEL_SKILLS_FONT 5

#define PANEL_SKILLS_X 43
#define PANEL_SKILLS_Y 310
#define PANEL_SKILLS_WIDTH 140
#define PANEL_SKILLS_HEIGHT 58

#define PANEL_W 300

#define PANEL_FONTS 6

#define DOTDOTDOT_KEYCODE -46

typedef struct{
  char* name;
  char* position;
  SDL_Surface *picture;
  int ma,st,ag,av,cost,xps,number,team;
  std::list<char*>* skills;
  bool visible;
} panel_info_object;

#endif
