/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.cdom.reference.Qualifier;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.StringPClassUtil;

public class QualifyToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "QUALIFY";
    }

    public List<Class<? extends CDOMObject>> getLegalTypes() {
        return Arrays.asList(PCClassLevel.class, Ability.class, Deity.class, Domain.class, Equipment.class, PCClass.class, Race.class, Skill.class, Spell.class, PCTemplate.class, WeaponProf.class);
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (!this.getLegalTypes().contains(obj.getClass())) {
            return new ParseResult.Fail("Cannot use QUALIFY on a " + obj.getClass(), context);
        }
        return super.parseNonEmptyToken(context, (Object)obj, value);
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (value.indexOf("|") == -1) {
            return new ParseResult.Fail(this.getTokenName() + " requires at least two arguments, QualifyType and Key: " + value, context);
        }
        StringTokenizer st = new StringTokenizer(value, "|");
        String firstToken = st.nextToken();
        ReferenceManufacturer rm = context.getManufacturer(firstToken);
        if (rm == null) {
            return new ParseResult.Fail(this.getTokenName() + " unable to generate manufacturer for type: " + value, context);
        }
        while (st.hasMoreTokens()) {
            CDOMSingleRef ref = rm.getReference(st.nextToken());
            context.getObjectContext().addToList(obj, ListKey.QUALIFY, (Object)new Qualifier(rm.getReferenceClass(), ref));
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.QUALIFY);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection quals = changes.getAdded();
        HashMapToList map = new HashMapToList();
        for (Qualifier qual : quals) {
            Class cl = qual.getQualifiedClass();
            String s = StringPClassUtil.getStringFor((Class)cl);
            CDOMSingleRef ref = qual.getQualifiedReference();
            String key = s;
            if (ref instanceof CategorizedCDOMReference) {
                Category cat = ((CategorizedCDOMReference)ref).getCDOMCategory();
                key = key + '=' + cat.getKeyName();
            }
            map.addToListFor((Object)key, (Object)ref);
        }
        TreeSet set = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        TreeSet<String> returnSet = new TreeSet<String>();
        for (String key : map.getKeySet()) {
            set.clear();
            set.addAll(map.getListFor((Object)key));
            StringBuilder sb = new StringBuilder();
            sb.append(key).append("|").append(ReferenceUtilities.joinLstFormat(set, (String)"|"));
            returnSet.add(sb.toString());
        }
        return returnSet.toArray(new String[returnSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

