/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.prof;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.WeaponProf;
import pcgen.core.kit.KitProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ProfToken
extends AbstractTokenWithSeparator<KitProf>
implements CDOMPrimaryToken<KitProf> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    @Override
    public String getTokenName() {
        return "PROF";
    }

    @Override
    public Class<KitProf> getTokenClass() {
        return KitProf.class;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, KitProf obj, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            CDOMSingleRef<WeaponProf> ref = context.getReferenceContext().getCDOMReference(WEAPONPROF_CLASS, tokText);
            obj.addProficiency(ref);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitProf obj) {
        Collection<CDOMSingleRef<WeaponProf>> ref = obj.getProficiencies();
        if (ref == null || ref.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(ref, "|")};
    }
}

