/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier.choose;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.EquipmentModifier;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class EqBuilderSpellToken
implements CDOMSecondaryToken<EquipmentModifier> {
    @Override
    public String getTokenName() {
        return "EQBUILDER.SPELL";
    }

    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    public ParseResult parseToken(LoadContext context, EquipmentModifier obj, String value) {
        String third;
        if (value == null) {
            context.getObjectContext().put((CDOMObject)obj, StringKey.CHOICE_STRING, this.getTokenName());
            return ParseResult.SUCCESS;
        }
        if (value.indexOf(91) != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not contain [] : " + value, context);
        }
        if (value.charAt(0) == '|') {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not start with | : " + value, context);
        }
        if (value.charAt(value.length() - 1) == '|') {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not end with | : " + value, context);
        }
        if (value.indexOf("||") != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments uses double separator || : " + value, context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        if (tok.countTokens() != 3) {
            return new ParseResult.Fail("COUNT:" + this.getTokenName() + " requires three arguments: " + value, context);
        }
        tok.nextToken();
        if (tok.hasMoreTokens()) {
            String second = tok.nextToken();
            try {
                Integer.parseInt(second);
            }
            catch (NumberFormatException nfe) {
                return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " second argument must be an Integer : " + value, context);
            }
        }
        if (tok.hasMoreTokens() && !(third = tok.nextToken()).equals("MAXLEVEL")) {
            try {
                Integer.parseInt(third);
            }
            catch (NumberFormatException nfe) {
                return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " third argument must be an Integer or 'MAXLEVEL': " + value, context);
            }
        }
        if (tok.hasMoreTokens()) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " must have 1 to 3 | delimited arguments: " + value, context);
        }
        StringBuilder sb = new StringBuilder(value.length() + 20);
        sb.append(this.getTokenName()).append('|').append(value);
        context.getObjectContext().put((CDOMObject)obj, StringKey.CHOICE_STRING, sb.toString());
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, EquipmentModifier eqMod) {
        String returnString;
        String chooseString = context.getObjectContext().getString(eqMod, StringKey.CHOICE_STRING);
        if (chooseString == null) {
            return null;
        }
        if (this.getTokenName().equals(chooseString)) {
            returnString = "";
        } else {
            if (chooseString.indexOf(this.getTokenName() + '|') == -1) {
                return null;
            }
            returnString = chooseString.substring(this.getTokenName().length() + 1);
        }
        return new String[]{returnString};
    }

    @Override
    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

