/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.race;

import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SizeAdjustment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;

public class BaseSizeToken
implements PrimitiveToken<Race>,
PrimitiveFilter<Race> {
    private static final Class<Race> RACE_CLASS = Race.class;
    private CDOMSingleRef<SizeAdjustment> size;
    private CDOMReference<Race> allRaces;

    public boolean initialize(LoadContext context, Class<Race> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        this.size = context.getReferenceContext().getCDOMReference(SizeAdjustment.class, value);
        this.allRaces = context.getReferenceContext().getCDOMAllReference(RACE_CLASS);
        return true;
    }

    public String getTokenName() {
        return "BASESIZE";
    }

    public Class<Race> getReferenceClass() {
        return RACE_CLASS;
    }

    public String getLSTformat(boolean useAny) {
        return this.getTokenName() + "=" + this.size.getLSTformat(false);
    }

    public boolean allow(PlayerCharacter pc, Race race) {
        Formula raceSize = race.get(FormulaKey.SIZE);
        return ((SizeAdjustment)this.size.resolvesTo()).getKeyName().equals(raceSize.toString());
    }

    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BaseSizeToken) {
            BaseSizeToken other = (BaseSizeToken)obj;
            return this.size.equals(other.size);
        }
        return false;
    }

    public int hashCode() {
        return this.size == null ? -7 : this.size.hashCode();
    }

    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Race, R> c) {
        return c.convert(this.allRaces, (PrimitiveFilter)this);
    }
}

