/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.cdom.base.BasicClassIdentity;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.NoChoiceManager;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class NoChoiceToken
implements CDOMSecondaryToken<CDOMObject>,
ChooseInformation<String>,
Chooser<String>,
DeferredToken<CDOMObject> {
    private static final ClassIdentity<String> STRING_INFO = BasicClassIdentity.getInstance(String.class);

    public String getTokenName() {
        return "NOCHOICE";
    }

    public String getParentToken() {
        return "CHOOSE";
    }

    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        if (value == null) {
            context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, (Object)this);
            return ParseResult.SUCCESS;
        }
        return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " will ignore arguments: " + value, context);
    }

    public String[] unparse(LoadContext context, CDOMObject cdo) {
        ChooseInformation chooseString = (ChooseInformation)context.getObjectContext().getObject(cdo, ObjectKey.CHOOSE_INFO);
        if (chooseString == null || !chooseString.equals(this)) {
            return null;
        }
        return new String[]{""};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public ClassIdentity<String> getClassIdentity() {
        return STRING_INFO;
    }

    public ChoiceManagerList getChoiceManager(ChooseDriver owner, int cost) {
        return new NoChoiceManager(owner, (ChooseInformation)this, cost);
    }

    public GroupingState getGroupingState() {
        return GroupingState.ALLOWS_NONE;
    }

    public String getLSTformat() {
        return "*NOCHOICE";
    }

    public String getName() {
        return "No Choice";
    }

    public Collection<String> getSet(PlayerCharacter pc) {
        return Collections.singletonList("");
    }

    public String getTitle() {
        return "No Choice Available";
    }

    public String decodeChoice(LoadContext context, String choice) {
        return choice;
    }

    public String encodeChoice(String choice) {
        return choice;
    }

    public Chooser<String> getChoiceActor() {
        return this;
    }

    public void setChoiceActor(Chooser<String> ca) {
    }

    public boolean allow(String choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    public void applyChoice(ChooseDriver owner, String st, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, "");
    }

    private void applyChoice(ChooseDriver owner, PlayerCharacter pc, ChooseSelectionActor<String> ca) {
        ca.applyChoice(owner, (Object)"", pc);
    }

    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, String choice) {
        pc.removeAssoc((Object)owner, this.getListKey(), (Object)"");
        List actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor ca : actors) {
                ca.removeChoice(owner, (Object)"", pc);
            }
        }
    }

    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, String choice) {
        pc.addAssoc((Object)owner, this.getListKey(), (Object)"");
        List actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor ca : actors) {
                this.applyChoice(owner, pc, (ChooseSelectionActor<String>)ca);
            }
        }
    }

    public List<String> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList((Object)owner, this.getListKey());
    }

    private AssociationListKey<String> getListKey() {
        return AssociationListKey.getKeyFor(String.class, (String)"CHOOSE*NOCHOICE");
    }

    public CharSequence composeDisplay(Collection<? extends String> collection) {
        int count;
        StringBuilder sb = new StringBuilder(5);
        int n = count = collection == null ? 0 : collection.size();
        if (count > 1) {
            sb.append(count);
            sb.append("x");
        }
        return sb;
    }

    public boolean process(LoadContext context, CDOMObject obj) {
        ChooseInformation ci = (ChooseInformation)obj.get(ObjectKey.CHOOSE_INFO);
        if (ci == this && !((Boolean)obj.getSafe(ObjectKey.STACKS)).booleanValue()) {
            Logging.errorPrint((String)("CHOOSE:NOCHOICE requires both MULT:YES and STACK:YES, was STACK:NO on " + obj.getClass().getSimpleName() + " " + obj.getKeyName()), (URI)obj.getSourceURI());
            return false;
        }
        return true;
    }

    public Class<CDOMObject> getDeferredTokenClass() {
        return CDOMObject.class;
    }
}

