/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.basekit;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.base.util.NamedFormula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.core.kit.KitGear;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class LookupToken
extends AbstractToken
implements CDOMPrimaryToken<KitGear> {
    public String getTokenName() {
        return "LOOKUP";
    }

    public Class<KitGear> getTokenClass() {
        return KitGear.class;
    }

    public ParseResult parseToken(LoadContext context, KitGear kitGear, String value) {
        ParsingSeparator sep = new ParsingSeparator(value, ',');
        String first = sep.next();
        if (!sep.hasNext()) {
            return new ParseResult.Fail("Token must contain separator ','", context);
        }
        String second = sep.next();
        if (sep.hasNext()) {
            return new ParseResult.Fail("Token cannot have more than one separator ','", context);
        }
        Formula formula = FormulaFactory.getFormulaFor((String)second);
        if (!formula.isValid()) {
            return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + formula.toString(), context);
        }
        kitGear.loadLookup(first, formula);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, KitGear kitGear) {
        Collection lookups = kitGear.getLookups();
        if (lookups == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (NamedFormula nf : lookups) {
            list.add(nf.getName() + "," + nf.getFormula().toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

