/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.internal;

import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.configuration.internal.ExecuteListenerBuildOperationType;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.internal.InternalListener;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.code.UserCodeApplicationId;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;

public class DefaultListenerBuildOperationDecorator
implements ListenerBuildOperationDecorator {
    private static final ImmutableSet<Class<?>> SUPPORTED_INTERFACES = ImmutableSet.of(BuildListener.class, ProjectEvaluationListener.class, TaskExecutionGraphListener.class);
    private static final ImmutableSet<String> UNDECORATED_METHOD_NAMES = ImmutableSet.of((Object)"beforeSettings", (Object)"settingsEvaluated", (Object)"buildFinished");
    private final BuildOperationRunner buildOperationRunner;
    private final UserCodeApplicationContext userCodeApplicationContext;

    public DefaultListenerBuildOperationDecorator(BuildOperationRunner buildOperationRunner, UserCodeApplicationContext userCodeApplicationContext) {
        this.buildOperationRunner = buildOperationRunner;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }

    @Override
    public <T> Action<T> decorate(String registrationPoint, Action<T> action) {
        UserCodeApplicationContext.Application application = this.userCodeApplicationContext.current();
        if (application == null || action instanceof InternalListener) {
            return action;
        }
        Action decorated = application.reapplyLater(action);
        return new BuildOperationEmittingAction(application.getId(), registrationPoint, decorated);
    }

    @Override
    public <T> Closure<T> decorate(String registrationPoint, Closure<T> closure) {
        UserCodeApplicationContext.Application application = this.userCodeApplicationContext.current();
        if (application == null) {
            return closure;
        }
        return new BuildOperationEmittingClosure(application, registrationPoint, closure);
    }

    @Override
    public <T> T decorate(String registrationPoint, Class<T> targetClass, T listener) {
        if (listener instanceof InternalListener || !DefaultListenerBuildOperationDecorator.isSupported(listener)) {
            return listener;
        }
        UserCodeApplicationContext.Application application = this.userCodeApplicationContext.current();
        if (application == null) {
            return listener;
        }
        Class<?> listenerClass = listener.getClass();
        List allInterfaces = ClassUtils.getAllInterfaces(listenerClass);
        BuildOperationEmittingInvocationHandler handler = new BuildOperationEmittingInvocationHandler(application, registrationPoint, listener);
        return targetClass.cast(Proxy.newProxyInstance(listenerClass.getClassLoader(), allInterfaces.toArray(new Class[0]), (InvocationHandler)handler));
    }

    @Override
    public Object decorateUnknownListener(String registrationPoint, Object listener) {
        return this.decorate(registrationPoint, Object.class, listener);
    }

    private static boolean isSupported(Object listener) {
        for (Class i : SUPPORTED_INTERFACES) {
            if (!i.isInstance(listener)) continue;
            return true;
        }
        return false;
    }

    private class BuildOperationEmittingAction<T>
    implements Action<T> {
        private final UserCodeApplicationId applicationId;
        private final String registrationPoint;
        private final Action<T> delegate;

        private BuildOperationEmittingAction(UserCodeApplicationId applicationId, String registrationPoint, Action<T> delegate) {
            this.applicationId = applicationId;
            this.delegate = delegate;
            this.registrationPoint = registrationPoint;
        }

        public void execute(final T arg) {
            DefaultListenerBuildOperationDecorator.this.buildOperationRunner.run((RunnableBuildOperation)new Operation(this.applicationId, this.registrationPoint){

                public void run(BuildOperationContext context) {
                    BuildOperationEmittingAction.this.delegate.execute(arg);
                    context.setResult((Object)ExecuteListenerBuildOperationType.RESULT);
                }
            });
        }
    }

    private class BuildOperationEmittingClosure<T>
    extends Closure<T> {
        private final UserCodeApplicationContext.Application application;
        private final String registrationPoint;
        private final Closure<T> delegate;

        private BuildOperationEmittingClosure(UserCodeApplicationContext.Application application, String registrationPoint, Closure<T> delegate) {
            super(delegate.getOwner(), delegate.getThisObject());
            this.application = application;
            this.delegate = delegate;
            this.registrationPoint = registrationPoint;
        }

        public void doCall(final Object ... args) {
            DefaultListenerBuildOperationDecorator.this.buildOperationRunner.run((RunnableBuildOperation)new Operation(this.application.getId(), this.registrationPoint){

                public void run(BuildOperationContext context) {
                    BuildOperationEmittingClosure.this.application.reapply(() -> {
                        int numClosureArgs = BuildOperationEmittingClosure.this.delegate.getMaximumNumberOfParameters();
                        Object[] finalArgs = numClosureArgs < args.length ? Arrays.copyOf(args, numClosureArgs) : args;
                        BuildOperationEmittingClosure.this.delegate.call(finalArgs);
                        context.setResult((Object)ExecuteListenerBuildOperationType.RESULT);
                    });
                }
            });
        }

        public void setDelegate(Object delegateObject) {
            this.delegate.setDelegate(delegateObject);
        }

        public void setResolveStrategy(int resolveStrategy) {
            this.delegate.setResolveStrategy(resolveStrategy);
        }

        public int getMaximumNumberOfParameters() {
            return this.delegate.getMaximumNumberOfParameters();
        }
    }

    private class BuildOperationEmittingInvocationHandler
    implements InvocationHandler {
        private final UserCodeApplicationContext.Application application;
        private final String registrationPoint;
        private final Object delegate;

        private BuildOperationEmittingInvocationHandler(UserCodeApplicationContext.Application application, String registrationPoint, Object delegate) {
            this.application = application;
            this.registrationPoint = registrationPoint;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("toString") && (args == null || args.length == 0)) {
                return "BuildOperationEmittingBuildListenerInvocationHandler{delegate: " + this.delegate + "}";
            }
            if (methodName.equals("hashCode") && (args == null || args.length == 0)) {
                return this.delegate.hashCode();
            }
            if (methodName.equals("equals") && args.length == 1) {
                return proxy == args[0] || this.isSame(args[0]);
            }
            if (!SUPPORTED_INTERFACES.contains(method.getDeclaringClass()) || UNDECORATED_METHOD_NAMES.contains((Object)methodName)) {
                try {
                    return method.invoke(this.delegate, args);
                }
                catch (InvocationTargetException e) {
                    throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
                }
            }
            DefaultListenerBuildOperationDecorator.this.buildOperationRunner.run((RunnableBuildOperation)new Operation(this.application.getId(), this.registrationPoint){

                public void run(BuildOperationContext context) {
                    BuildOperationEmittingInvocationHandler.this.application.reapply(() -> {
                        try {
                            method.invoke(BuildOperationEmittingInvocationHandler.this.delegate, args);
                            context.setResult((Object)ExecuteListenerBuildOperationType.RESULT);
                        }
                        catch (InvocationTargetException e) {
                            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
                        }
                        catch (Exception e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                    });
                }
            });
            return null;
        }

        private boolean isSame(Object arg) {
            if (Proxy.isProxyClass(arg.getClass())) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(arg);
                if (this.getClass() == invocationHandler.getClass()) {
                    BuildOperationEmittingInvocationHandler cast = (BuildOperationEmittingInvocationHandler)invocationHandler;
                    return cast.delegate.equals(this.delegate);
                }
            }
            return false;
        }
    }

    private static class ExecuteListenerDetails
    implements ExecuteListenerBuildOperationType.Details {
        final UserCodeApplicationId applicationId;
        final String registrationPoint;

        ExecuteListenerDetails(UserCodeApplicationId applicationId, String registrationPoint) {
            this.applicationId = applicationId;
            this.registrationPoint = registrationPoint;
        }

        public long getApplicationId() {
            return this.applicationId.longValue();
        }

        public String getRegistrationPoint() {
            return this.registrationPoint;
        }
    }

    private static abstract class Operation
    implements RunnableBuildOperation {
        private final UserCodeApplicationId applicationId;
        private final String registrationPoint;

        Operation(UserCodeApplicationId applicationId, String registrationPoint) {
            this.applicationId = applicationId;
            this.registrationPoint = registrationPoint;
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Execute " + this.registrationPoint + " listener")).details((Object)new ExecuteListenerDetails(this.applicationId, this.registrationPoint));
        }
    }
}

