/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.sandbox.accessibility;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.dialogs.basics.accessibility.AccessibilityUtils;
import com.jgoodies.dialogs.basics.accessibility.ControlList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public final class AccessibilityChecker {
    private AccessibilityChecker() {
    }

    public static void install() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new CheckHandler(), 1L);
    }

    public static void installIfEnabledBySystemProperty() {
        String property = System.getProperty("AccessibilityChecker");
        if ("enabled".equalsIgnoreCase(property) || "on".equalsIgnoreCase(property)) {
            AccessibilityChecker.install();
        }
    }

    private static void checkAndReport(Container parent) {
        Preconditions.checkNotNull(parent, "The %s must not be null.", "parent");
        List<Component> mnemonicComponents = AccessibilityUtils.visitAndCollectComponents(parent, new MnemonicFilter());
        AccessibilityChecker.reportMnemonicDuplicates(AccessibilityChecker.findDuplicates(mnemonicComponents));
        List<Component> inputComponents = AccessibilityUtils.visitAndCollectComponents(parent, new AccessibilityUtils.DefaultInputElementFilter().and(new NotExcludedFilter()));
        AccessibilityChecker.reportAccessibleInfoProblems(inputComponents);
    }

    private static void reportAccessibleInfoProblems(List<Component> inputElements) {
        HashMap<String, List<Component>> map = new HashMap<String, List<Component>>();
        for (Component c : inputElements) {
            String info = AccessibilityUtils.getAccessibleInfo(c);
            if (Strings.isBlank(info)) {
                System.out.println("Missing accessible info: " + AccessibilityChecker.print(c));
                continue;
            }
            ArrayList<Component> components = (ArrayList<Component>)map.get(info);
            if (components == null) {
                components = new ArrayList<Component>();
                map.put(info, components);
            }
            components.add(c);
        }
        AccessibilityChecker.reportInfoDuplicates(map);
    }

    private static void reportInfoDuplicates(Map<String, List<Component>> infoMap) {
        infoMap.forEach((accessibleInfo, components) -> {
            if (components.size() > 1) {
                System.out.println("Doppelte Accessible Info '" + accessibleInfo + "':");
                for (Component c : components) {
                    if (c instanceof JLabel) {
                        System.out.println("  JLabel: \"" + AccessibilityChecker.print((JLabel)c) + "\" " + c);
                        continue;
                    }
                    if (!(c instanceof AbstractButton)) continue;
                    System.out.println("  Button: \"" + AccessibilityChecker.print((AbstractButton)c) + "\" " + c);
                }
            }
        });
    }

    private static Map<Integer, List<Component>> findDuplicates(List<Component> mnemonicComponents) {
        HashMap<Integer, List<Component>> mnemonicMap = new HashMap<Integer, List<Component>>();
        for (Component child : mnemonicComponents) {
            int mnemonic = 0;
            if (child instanceof JLabel) {
                mnemonic = ((JLabel)child).getDisplayedMnemonic();
            } else if (child instanceof AbstractButton) {
                mnemonic = ((AbstractButton)child).getMnemonic();
            }
            if (mnemonic == 0) continue;
            Integer key = mnemonic;
            ArrayList<Component> components = (ArrayList<Component>)mnemonicMap.get(key);
            if (components == null) {
                components = new ArrayList<Component>();
                mnemonicMap.put(key, components);
            }
            components.add(child);
        }
        return mnemonicMap;
    }

    private static void reportMnemonicDuplicates(Map<Integer, List<Component>> mnemonicMap) {
        mnemonicMap.forEach((mnemonic, components) -> {
            if (components.size() > 1) {
                System.out.println("Mehrfach vergebener Mnemonic '" + (char)mnemonic.intValue() + "':");
                for (Component c : components) {
                    if (c instanceof JLabel) {
                        System.out.println("  JLabel: \"" + AccessibilityChecker.print((JLabel)c) + "\" " + c);
                        continue;
                    }
                    if (!(c instanceof AbstractButton)) continue;
                    System.out.println("  Button: \"" + AccessibilityChecker.print((AbstractButton)c) + "\" " + c);
                }
            }
        });
    }

    private static String print(Component c) {
        if (c instanceof JTextComponent) {
            return AccessibilityChecker.print((JTextComponent)c);
        }
        if (c instanceof JLabel) {
            return AccessibilityChecker.print((JLabel)c);
        }
        if (c instanceof AbstractButton) {
            return AccessibilityChecker.print((AbstractButton)c);
        }
        return c.toString();
    }

    private static String print(JTextComponent c) {
        return "\"" + c.getText() + "\" " + c.toString();
    }

    private static String print(JLabel label) {
        return label.getText();
    }

    private static String print(AbstractButton button) {
        if (Strings.isNotBlank(button.getText())) {
            return button.getText();
        }
        if (Strings.isNotBlank(button.getToolTipText())) {
            return button.getToolTipText();
        }
        if (Strings.isNotBlank(button.getActionCommand())) {
            return button.getActionCommand();
        }
        return button.toString();
    }

    private static final class CheckHandler
    implements AWTEventListener {
        private CheckHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            JRootPane rootPane;
            ComponentEvent ce;
            if (event instanceof ComponentEvent && (ce = (ComponentEvent)event).getID() == 102 && ce.getComponent() instanceof JPanel && (rootPane = SwingUtilities.getRootPane(ce.getComponent())) != null) {
                AccessibilityChecker.checkAndReport(rootPane);
            }
        }
    }

    private static final class MnemonicFilter
    implements Predicate<Component> {
        private MnemonicFilter() {
        }

        @Override
        public boolean test(Component c) {
            return c instanceof JLabel || c instanceof AbstractButton;
        }
    }

    private static final class NotExcludedFilter
    implements Predicate<Component> {
        private NotExcludedFilter() {
        }

        @Override
        public boolean test(Component c) {
            return !ControlList.isExcluded(c);
        }
    }
}

