/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.Disk;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityBase;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;

public final class AnywareRenderer {
    public static final String[] columns = new String[]{Messages.getString("AnywareRenderer.Status"), Messages.getString("AnywareRenderer.Name"), Messages.getString("AnywareRenderer.Size"), Messages.getString("AnywareRenderer.CRC"), Messages.getString("AnywareRenderer.MD5"), Messages.getString("AnywareRenderer.SHA-1"), Messages.getString("AnywareRenderer.Merge"), Messages.getString("AnywareRenderer.DumpStatus")};
    public static final Class<?>[] columnsTypes = new Class[]{Object.class, Object.class, Long.class, String.class, String.class, String.class, String.class, Object.class};
    public static final int[] columnsWidths = new int[]{-3, 256, -12, -10, -34, -42, 100, -3};
    public static final TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new DefaultTableCellRenderer(){
        ImageIcon bullet_green = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/bullet_green.png"));
        ImageIcon bullet_red = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/bullet_red.png"));
        ImageIcon bullet_black = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/bullet_black.png"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                switch (((EntityBase)value).getStatus()) {
                    case OK: {
                        this.setIcon(this.bullet_green);
                        break;
                    }
                    case KO: {
                        this.setIcon(this.bullet_red);
                        break;
                    }
                    default: {
                        this.setIcon(this.bullet_black);
                    }
                }
            }
            this.setText("");
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }, new DefaultTableCellRenderer(){
        ImageIcon rom_small = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/rom_small.png"));
        ImageIcon drive = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/drive.png"));
        ImageIcon sound = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/sound.png"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Rom) {
                this.setIcon(this.rom_small);
            } else if (value instanceof Disk) {
                this.setIcon(this.drive);
            } else if (value instanceof Sample) {
                this.setIcon(this.sound);
            }
            this.setText(value != null ? (value instanceof EntityBase ? ((EntityBase)value).getBaseName() : value.toString()) : null);
            this.setToolTipText(this.getText());
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }, new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(11);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value != null ? (value instanceof Long ? ((Long)value > 0L ? value.toString() : null) : value.toString()) : null);
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }, new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(11);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value != null ? value.toString() : null);
            this.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }, new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(11);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value != null ? value.toString() : null);
            this.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }, new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(11);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value != null ? value.toString() : null);
            this.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }, new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value != null ? value.toString() : null);
            this.setToolTipText(this.getText());
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }, new DefaultTableCellRenderer(){
        ImageIcon verified = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/star.png"));
        ImageIcon good = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/tick.png"));
        ImageIcon baddump = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/delete.png"));
        ImageIcon nodump = new ImageIcon(AnywareRenderer.class.getResource("/jrm/resources/icons/error.png"));
        {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Entity.Status) {
                switch ((Entity.Status)value) {
                    case verified: {
                        this.setIcon(this.verified);
                        break;
                    }
                    case good: {
                        this.setIcon(this.good);
                        break;
                    }
                    case baddump: {
                        this.setIcon(this.baddump);
                        break;
                    }
                    case nodump: {
                        this.setIcon(this.nodump);
                    }
                }
            } else {
                this.setIcon(null);
            }
            this.setToolTipText(value != null ? value.toString() : null);
            this.setText("");
            this.setBackground(AnywareRenderer.getBackground(row, column));
            return this;
        }
    }};

    private static Color getBackground(int row, int col) {
        if (col % 2 == 0) {
            if (row % 2 == 0) {
                return Color.decode("0xDDDDEE");
            }
            return Color.decode("0xEEEEEE");
        }
        if (row % 2 == 0) {
            return Color.decode("0xEEEEFF");
        }
        return Color.decode("0xFFFFFF");
    }

    private AnywareRenderer() {
    }
}

