/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.manager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import jrm.profile.Profile;
import jrm.profile.data.SoftwareList;
import jrm.ui.progress.ProgressHandler;
import jrm.xml.EnhancedXMLStreamWriter;

public class Export {
    public Export(Profile profile, File file, ExportType type, boolean filtered, SoftwareList selection, ProgressHandler progress) {
        EnhancedXMLStreamWriter writer = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            writer = new EnhancedXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(fos, "UTF-8"));
            switch (type) {
                case MAME: {
                    profile.machinelist_list.export(writer, progress, true, filtered);
                    break;
                }
                case DATAFILE: {
                    profile.machinelist_list.export(writer, progress, false, filtered);
                    break;
                }
                case SOFTWARELIST: {
                    profile.machinelist_list.softwarelist_list.export(writer, progress, filtered, selection);
                }
            }
            writer.close();
        }
        catch (IOException | FactoryConfigurationError | XMLStreamException e) {
            JOptionPane.showMessageDialog(null, e, "Exception", 0);
            e.printStackTrace();
        }
    }

    public static enum ExportType {
        MAME,
        DATAFILE,
        SOFTWARELIST;

    }
}

