/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import jrm.compressors.Archive;
import jrm.locale.Messages;
import jrm.profile.data.Entry;
import jrm.profile.fix.actions.EntryAction;
import jrm.ui.progress.ProgressHandler;

public class RenameEntry
extends EntryAction {
    final String newname;

    public RenameEntry(Entry entry) {
        super(entry);
        this.newname = UUID.randomUUID() + "_" + entry.size + ".tmp";
    }

    public RenameEntry(String newname, Entry entry) {
        super(entry);
        this.newname = newname;
    }

    @Override
    public boolean doAction(FileSystem fs, ProgressHandler handler, int i, int max) {
        Path dstpath = null;
        try {
            handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("RenameEntry.Renaming"), this.entry.file, this.newname)));
            Path srcpath = fs.getPath(this.entry.file, new String[0]);
            dstpath = fs.getPath(this.newname, new String[0]);
            if (dstpath.getParent() != null) {
                Files.createDirectories(dstpath.getParent(), new FileAttribute[0]);
            }
            Files.move(srcpath, dstpath, StandardCopyOption.REPLACE_EXISTING);
            this.entry.file = dstpath.toString();
            return true;
        }
        catch (Throwable e) {
            System.err.println("rename " + this.parent.container.file.getName() + "@" + this.entry.file + " to " + this.parent.container.file.getName() + "@" + this.newname + " failed");
            return false;
        }
    }

    @Override
    public boolean doAction(Path target, ProgressHandler handler, int i, int max) {
        Path dstpath = null;
        try {
            dstpath = target.resolve(this.newname);
            handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("RenameEntry.Renaming"), this.entry.file, this.newname)));
            Path srcpath = target.resolve(this.entry.file);
            if (dstpath.getParent() != null) {
                Files.createDirectories(dstpath.getParent(), new FileAttribute[0]);
            }
            Files.move(srcpath, dstpath, StandardCopyOption.REPLACE_EXISTING);
            this.entry.file = dstpath.toString();
            return true;
        }
        catch (Throwable e) {
            System.err.println("rename " + this.parent.container.file.getName() + "@" + this.entry.file + " to " + this.parent.container.file.getName() + "@" + this.newname + " failed");
            return false;
        }
    }

    @Override
    public boolean doAction(Archive archive, ProgressHandler handler, int i, int max) {
        try {
            handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("RenameEntry.Renaming"), this.entry.file, this.newname)));
            if (archive.rename(this.entry.file, this.newname) == 0) {
                this.entry.file = this.newname;
                return true;
            }
        }
        catch (Throwable e) {
            System.err.println("rename " + this.parent.container.file.getName() + "@" + this.entry.file + " to " + this.parent.container.file.getName() + "@" + this.newname + " failed");
        }
        return false;
    }

    public String toString() {
        return String.format(Messages.getString("RenameEntry.Rename"), this.entry, this.newname);
    }
}

