/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import jrm.profile.data.Anyware;
import jrm.profile.data.Disk;
import jrm.profile.data.Entry;
import jrm.profile.data.Rom;
import jrm.profile.data.SoftwareList;
import jrm.profile.data.Systm;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;

public class Software
extends Anyware
implements Serializable {
    public final StringBuffer publisher = new StringBuffer();
    public Supported supported = Supported.yes;
    public String compatibility = null;
    public final List<Part> parts = new ArrayList<Part>();
    public SoftwareList sl = null;

    @Override
    public Software getParent() {
        return this.getParent(Software.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.sl.name + File.separator + this.name;
    }

    @Override
    public String getFullName(String filename) {
        return this.sl.name + File.separator + filename;
    }

    @Override
    public boolean isBios() {
        return false;
    }

    @Override
    public boolean isRomOf() {
        return false;
    }

    @Override
    public Systm.Type getType() {
        return Systm.Type.SOFTWARELIST;
    }

    @Override
    public Systm getSystem() {
        return this.sl;
    }

    public void export(EnhancedXMLStreamWriter writer, Collection<Entry> entries) throws XMLStreamException, IOException {
        writer.writeStartElement("software", new SimpleAttribute("name", this.name), new SimpleAttribute("cloneof", this.cloneof), new SimpleAttribute("supported", this.supported.getXML()));
        writer.writeElement("description", this.description, new SimpleAttribute[0]);
        if (this.year != null && this.year.length() > 0) {
            writer.writeElement("year", this.year, new SimpleAttribute[0]);
        }
        if (this.publisher != null && this.publisher.length() > 0) {
            writer.writeElement("publisher", this.publisher, new SimpleAttribute[0]);
        }
        for (Part part : this.parts) {
            writer.writeStartElement("part", new SimpleAttribute("name", part.name), new SimpleAttribute("interface", part.intrface));
            for (Part.DataArea dataarea : part.dataareas) {
                writer.writeStartElement("dataarea", new SimpleAttribute("name", dataarea.name), new SimpleAttribute("size", dataarea.size), new SimpleAttribute("width", dataarea.databits), new SimpleAttribute("endianness", dataarea.endianness.getXML()));
                for (Rom r : dataarea.roms) {
                    if (entries != null && !entries.contains(r)) continue;
                    r.export(writer, true);
                }
                writer.writeEndElement();
            }
            for (Part.DiskArea diskarea : part.diskareas) {
                writer.writeStartElement("diskarea", new SimpleAttribute("name", diskarea.name));
                for (Disk d : diskarea.disks) {
                    if (entries != null && !entries.contains(d)) continue;
                    d.export(writer, true);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public CharSequence getDescription() {
        return this.description;
    }

    @Override
    Stream<Rom> streamWithDevices(boolean excludeBios, boolean partial, boolean recurse) {
        return this.roms.stream();
    }

    public static class Part
    implements Serializable {
        public String name;
        public String intrface;
        public List<DataArea> dataareas = new ArrayList<DataArea>();
        public List<DiskArea> diskareas = new ArrayList<DiskArea>();

        public static class DiskArea
        implements Serializable {
            public String name;
            public List<Disk> disks = new ArrayList<Disk>();
        }

        public static class DataArea
        implements Serializable {
            public String name;
            public int size;
            public int databits = 8;
            public Endianness endianness = Endianness.little;
            public List<Rom> roms = new ArrayList<Rom>();

            public static enum Endianness implements Serializable
            {
                big,
                little;


                public Endianness getXML() {
                    return this == little ? null : this;
                }
            }
        }
    }

    public static enum Supported implements Serializable
    {
        no,
        partial,
        yes;


        public Supported getXML() {
            return this == yes ? null : this;
        }
    }
}

