/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.torrent.bencoding.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import jrm.io.torrent.bencoding.types.BByteString;
import jrm.io.torrent.bencoding.types.IBencodable;

public class BDictionary
implements IBencodable {
    private final Map<BByteString, IBencodable> dictionary = new LinkedHashMap<BByteString, IBencodable>();
    public byte[] blob;

    public void add(BByteString key, IBencodable value) {
        this.dictionary.put(key, value);
    }

    public Object find(BByteString key) {
        return this.dictionary.get(key);
    }

    @Override
    public String bencodedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("d");
        for (Map.Entry<BByteString, IBencodable> entry : this.dictionary.entrySet()) {
            sb.append(entry.getKey().bencodedString());
            sb.append(entry.getValue().bencodedString());
        }
        sb.append("e");
        return sb.toString();
    }

    @Override
    public byte[] bencode() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add((byte)100);
        for (Map.Entry<BByteString, IBencodable> entry : this.dictionary.entrySet()) {
            byte[] keyBencoded = entry.getKey().bencode();
            byte[] valBencoded = entry.getValue().bencode();
            for (byte b : keyBencoded) {
                bytes.add(b);
            }
            for (byte b : valBencoded) {
                bytes.add(b);
            }
        }
        bytes.add((byte)101);
        byte[] bencoded = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            bencoded[i] = (Byte)bytes.get(i);
        }
        return bencoded;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n[\n");
        for (Map.Entry<BByteString, IBencodable> entry : this.dictionary.entrySet()) {
            sb.append(entry.getKey()).append(" :: ").append(entry.getValue()).append("\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

