/*
 * Decompiled with CFR 0.152.
 */
package jrm.batch;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jrm.io.torrent.Torrent;
import jrm.io.torrent.TorrentFile;
import jrm.io.torrent.TorrentParser;
import jrm.io.torrent.options.TrntChkMode;
import jrm.locale.Messages;
import jrm.misc.HTMLRenderer;
import jrm.misc.UnitRenderer;
import jrm.ui.basic.ResultColUpdater;
import jrm.ui.basic.SDRTableModel;
import jrm.ui.progress.Progress;
import one.util.streamex.StreamEx;
import org.apache.commons.codec.binary.Hex;

public class TorrentChecker
implements UnitRenderer,
HTMLRenderer {
    AtomicInteger processing = new AtomicInteger();
    AtomicInteger current = new AtomicInteger();

    public TorrentChecker(Progress progress, List<SDRTableModel.SrcDstResult> sdrl, TrntChkMode mode, ResultColUpdater updater) throws IOException {
        progress.setInfos(Math.min(Runtime.getRuntime().availableProcessors(), (int)sdrl.stream().filter(sdr -> sdr.selected).count()), true);
        progress.setProgress2("", 0, 1);
        ((StreamEx)StreamEx.of(sdrl).filter(sdr -> sdr.selected)).forEach(sdr -> updater.updateResult(sdrl.indexOf(sdr), ""));
        ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(sdrl).filter(sdr -> sdr.selected)).parallel()).takeWhile(sdr -> !progress.isCancel())).forEach(sdr -> {
            try {
                int row = sdrl.indexOf(sdr);
                updater.updateResult(row, "In progress...");
                String result = this.check(progress, mode, (SDRTableModel.SrcDstResult)sdr);
                updater.updateResult(row, result);
                progress.setProgress(null, -1, null, "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private String check(Progress progress, TrntChkMode mode, SDRTableModel.SrcDstResult sdr) throws IOException {
        String result = "";
        if (sdr.src != null && sdr.dst != null) {
            if (sdr.src.exists() && sdr.dst.exists()) {
                Torrent torrent = TorrentParser.parseTorrent(sdr.src.getAbsolutePath());
                List<TorrentFile> tfiles = torrent.getFileList();
                int total = tfiles.size();
                int ok = 0;
                long missing_bytes = 0L;
                int missing_files = 0;
                if (mode != TrntChkMode.SHA1) {
                    this.processing.addAndGet(total);
                    for (int j = 0; j < total; ++j) {
                        this.current.incrementAndGet();
                        TorrentFile tfile = tfiles.get(j);
                        Path file = sdr.dst.toPath();
                        for (String path : tfile.getFileDirs()) {
                            file = file.resolve(path);
                        }
                        progress.setProgress(this.toHTML(this.toPurple(sdr.src.getAbsolutePath())), -1, null, file.toString());
                        progress.setProgress2(this.current + "/" + this.processing, this.current.get(), this.processing.get());
                        if (Files.exists(file, new LinkOption[0]) && (mode == TrntChkMode.FILENAME || Files.size(file) == tfile.getFileLength())) {
                            ++ok;
                        } else if (mode == TrntChkMode.FILENAME) {
                            ++missing_files;
                        } else {
                            missing_bytes += tfile.getFileLength().longValue();
                        }
                        if (progress.isCancel()) break;
                    }
                    result = mode == TrntChkMode.FILENAME ? String.format(Messages.getString("TorrentChecker.ResultFileName"), (double)ok * 100.0 / (double)total, missing_files) : String.format(Messages.getString("TorrentChecker.ResultFileSize"), (double)ok * 100.0 / (double)total, this.humanReadableByteCount(missing_bytes, false));
                } else {
                    try {
                        long piece_length = torrent.getPieceLength();
                        List<String> pieces = torrent.getPieces();
                        long to_go = piece_length;
                        int piece_cnt = 0;
                        int piece_valid = 0;
                        this.processing.addAndGet(pieces.size());
                        progress.setProgress(sdr.src.getAbsolutePath(), -1, null, "");
                        progress.setProgress2(String.format(Messages.getString("TorrentChecker.PieceProgression"), this.current.get(), this.processing.get()), -1, this.processing.get());
                        ++piece_cnt;
                        boolean valid = true;
                        MessageDigest md = MessageDigest.getInstance("SHA-1");
                        byte[] buffer = new byte[8192];
                        for (TorrentFile tfile : tfiles) {
                            int len;
                            long to_read;
                            BufferedInputStream in = null;
                            Path file = sdr.dst.toPath();
                            for (String path : tfile.getFileDirs()) {
                                file = file.resolve(path);
                            }
                            if (!Files.exists(file, new LinkOption[0]) || Files.size(file) != tfile.getFileLength()) {
                                valid = false;
                            } else {
                                in = new BufferedInputStream(new FileInputStream(file.toFile()));
                            }
                            progress.setProgress(this.toHTML(this.toPurple(sdr.src.getAbsolutePath())), -1, null, file.toString());
                            long flen = tfile.getFileLength();
                            while (flen >= to_go) {
                                if (in != null) {
                                    to_read = to_go;
                                    do {
                                        len = in.read(buffer, 0, (int)(to_read < (long)buffer.length ? to_read : (long)buffer.length));
                                        md.update(buffer, 0, len);
                                    } while ((to_read -= (long)len) > 0L);
                                }
                                flen -= to_go;
                                to_go = (int)piece_length;
                                progress.setProgress2(String.format(Messages.getString("TorrentChecker.PieceProgression"), this.current.get(), this.processing.get()), this.current.get(), this.processing.get());
                                if (valid && Hex.encodeHexString(md.digest()).equalsIgnoreCase(pieces.get(piece_cnt - 1))) {
                                    ++piece_valid;
                                } else {
                                    missing_bytes += piece_length;
                                }
                                md.reset();
                                ++piece_cnt;
                                this.current.incrementAndGet();
                                valid = true;
                                if (flen <= 0L || Files.exists(file, new LinkOption[0]) && Files.size(file) == tfile.getFileLength()) continue;
                                valid = false;
                            }
                            if (in != null) {
                                to_read = flen;
                                do {
                                    len = in.read(buffer, 0, (int)(to_read < (long)buffer.length ? to_read : (long)buffer.length));
                                    md.update(buffer, 0, len);
                                } while ((to_read -= (long)len) > 0L);
                                in.close();
                            }
                            to_go -= flen;
                            if (!progress.isCancel()) continue;
                            break;
                        }
                        progress.setProgress2(String.format(Messages.getString("TorrentChecker.PieceProgression"), this.current.get(), this.processing.get()), this.current.get(), this.processing.get());
                        if (valid && Hex.encodeHexString(md.digest()).equalsIgnoreCase(pieces.get(piece_cnt - 1))) {
                            ++piece_valid;
                        } else {
                            missing_bytes += piece_length - to_go;
                        }
                        System.out.format("piece counted %d, given %d, valid %d, completion=%.02f%%\n", piece_cnt, pieces.size(), piece_valid, (double)piece_valid * 100.0 / (double)piece_cnt);
                        System.out.format("piece len : %d\n", piece_length);
                        System.out.format("last piece len : %d\n", piece_length - to_go);
                        result = String.format(Messages.getString("TorrentChecker.ResultSHA1"), (double)piece_valid * 100.0 / (double)piece_cnt, this.humanReadableByteCount(missing_bytes, false));
                    }
                    catch (Exception ex) {
                        result = ex.getMessage();
                    }
                }
            } else {
                result = sdr.src.exists() ? Messages.getString("TorrentChecker.DstMustExist") : Messages.getString("TorrentChecker.SrcMustExist");
            }
        } else {
            result = sdr.src == null ? Messages.getString("TorrentChecker.SrcNotDefined") : Messages.getString("TorrentChecker.DstNotDefined");
        }
        return result;
    }
}

