#ifndef DOSEMU_UNICODE_SYMBOLS_H
#define DOSEMU_UNICODE_SYMBOLS_H

/* A value that is never valid in unicode */
#ifndef U_VOID
#define U_VOID 0xFFFF
#endif

/* 0xFFFD is the unicode undefined character */

#define U_NULL										0x0000
#define U_START_OF_HEADING								0x0001
#define U_START_OF_TEXT									0x0002
#define U_END_OF_TEXT									0x0003
#define U_END_OF_TRANSMISSION								0x0004
#define U_ENQUIRY									0x0005
#define U_ACKNOWLEDGE									0x0006
#define U_BELL										0x0007
#define U_BACKSPACE									0x0008
#define U_HORIZONTAL_TABULATION								0x0009
#define U_LINE_FEED									0x000A
#define U_VERTICAL_TABULATION								0x000B
#define U_FORM_FEED									0x000C
#define U_CARRIAGE_RETURN								0x000D
#define U_SHIFT_OUT									0x000E
#define U_SHIFT_IN									0x000F
#define U_DATA_LINK_ESCAPE								0x0010
#define U_DEVICE_CONTROL_ONE								0x0011
#define U_DEVICE_CONTROL_TWO								0x0012
#define U_DEVICE_CONTROL_THREE								0x0013
#define U_DEVICE_CONTROL_FOUR								0x0014
#define U_NEGATIVE_ACKNOWLEDGE								0x0015
#define U_SYNCHRONOUS_IDLE								0x0016
#define U_END_OF_TRANSMISSION_BLOCK							0x0017
#define U_CANCEL									0x0018
#define U_END_OF_MEDIUM									0x0019
#define U_SUBSTITUTE									0x001A
#define U_ESCAPE									0x001B
#define U_FILE_SEPARATOR								0x001C
#define U_GROUP_SEPARATOR								0x001D
#define U_RECORD_SEPARATOR								0x001E
#define U_UNIT_SEPARATOR								0x001F
#define U_SPACE										0x0020
#define U_EXCLAMATION_MARK								0x0021
#define U_QUOTATION_MARK								0x0022
#define U_NUMBER_SIGN									0x0023
#define U_DOLLAR_SIGN									0x0024
#define U_PERCENT_SIGN									0x0025
#define U_AMPERSAND									0x0026
#define U_APOSTROPHE									0x0027
#define U_LEFT_PARENTHESIS								0x0028
#define U_RIGHT_PARENTHESIS								0x0029
#define U_ASTERISK									0x002A
#define U_PLUS_SIGN									0x002B
#define U_COMMA										0x002C
#define U_HYPHEN_MINUS									0x002D
#define U_FULL_STOP									0x002E
#define U_PERIOD									0x002E
#define U_SOLIDUS									0x002F
#define U_SLASH										0x002F
#define U_DIGIT_ZERO									0x0030
#define U_DIGIT_ONE									0x0031
#define U_DIGIT_TWO									0x0032
#define U_DIGIT_THREE									0x0033
#define U_DIGIT_FOUR									0x0034
#define U_DIGIT_FIVE									0x0035
#define U_DIGIT_SIX									0x0036
#define U_DIGIT_SEVEN									0x0037
#define U_DIGIT_EIGHT									0x0038
#define U_DIGIT_NINE									0x0039
#define U_COLON										0x003A
#define U_SEMICOLON									0x003B
#define U_LESS_THAN_SIGN								0x003C
#define U_EQUALS_SIGN									0x003D
#define U_GREATER_THAN_SIGN								0x003E
#define U_QUESTION_MARK									0x003F
#define U_COMMERCIAL_AT									0x0040
#define U_LATIN_CAPITAL_LETTER_A							0x0041
#define U_LATIN_CAPITAL_LETTER_B							0x0042
#define U_LATIN_CAPITAL_LETTER_C							0x0043
#define U_LATIN_CAPITAL_LETTER_D							0x0044
#define U_LATIN_CAPITAL_LETTER_E							0x0045
#define U_LATIN_CAPITAL_LETTER_F							0x0046
#define U_LATIN_CAPITAL_LETTER_G							0x0047
#define U_LATIN_CAPITAL_LETTER_H							0x0048
#define U_LATIN_CAPITAL_LETTER_I							0x0049
#define U_LATIN_CAPITAL_LETTER_J							0x004A
#define U_LATIN_CAPITAL_LETTER_K							0x004B
#define U_LATIN_CAPITAL_LETTER_L							0x004C
#define U_LATIN_CAPITAL_LETTER_M							0x004D
#define U_LATIN_CAPITAL_LETTER_N							0x004E
#define U_LATIN_CAPITAL_LETTER_O							0x004F
#define U_LATIN_CAPITAL_LETTER_P							0x0050
#define U_LATIN_CAPITAL_LETTER_Q							0x0051
#define U_LATIN_CAPITAL_LETTER_R							0x0052
#define U_LATIN_CAPITAL_LETTER_S							0x0053
#define U_LATIN_CAPITAL_LETTER_T							0x0054
#define U_LATIN_CAPITAL_LETTER_U							0x0055
#define U_LATIN_CAPITAL_LETTER_V							0x0056
#define U_LATIN_CAPITAL_LETTER_W							0x0057
#define U_LATIN_CAPITAL_LETTER_X							0x0058
#define U_LATIN_CAPITAL_LETTER_Y							0x0059
#define U_LATIN_CAPITAL_LETTER_Z							0x005A
#define U_LEFT_SQUARE_BRACKET								0x005B
#define U_REVERSE_SOLIDUS								0x005C
#define U_BACKSLASH									0x005C
#define U_RIGHT_SQUARE_BRACKET								0x005D
#define U_CIRCUMFLEX_ACCENT								0x005E
#define U_LOW_LINE									0x005F
#define U_GRAVE_ACCENT									0x0060
#define U_LATIN_SMALL_LETTER_A								0x0061
#define U_LATIN_SMALL_LETTER_B								0x0062
#define U_LATIN_SMALL_LETTER_C								0x0063
#define U_LATIN_SMALL_LETTER_D								0x0064
#define U_LATIN_SMALL_LETTER_E								0x0065
#define U_LATIN_SMALL_LETTER_F								0x0066
#define U_LATIN_SMALL_LETTER_G								0x0067
#define U_LATIN_SMALL_LETTER_H								0x0068
#define U_LATIN_SMALL_LETTER_I								0x0069
#define U_LATIN_SMALL_LETTER_J								0x006A
#define U_LATIN_SMALL_LETTER_K								0x006B
#define U_LATIN_SMALL_LETTER_L								0x006C
#define U_LATIN_SMALL_LETTER_M								0x006D
#define U_LATIN_SMALL_LETTER_N								0x006E
#define U_LATIN_SMALL_LETTER_O								0x006F
#define U_LATIN_SMALL_LETTER_P								0x0070
#define U_LATIN_SMALL_LETTER_Q								0x0071
#define U_LATIN_SMALL_LETTER_R								0x0072
#define U_LATIN_SMALL_LETTER_S								0x0073
#define U_LATIN_SMALL_LETTER_T								0x0074
#define U_LATIN_SMALL_LETTER_U								0x0075
#define U_LATIN_SMALL_LETTER_V								0x0076
#define U_LATIN_SMALL_LETTER_W								0x0077
#define U_LATIN_SMALL_LETTER_X								0x0078
#define U_LATIN_SMALL_LETTER_Y								0x0079
#define U_LATIN_SMALL_LETTER_Z								0x007A
#define U_LEFT_CURLY_BRACKET								0x007B
#define U_VERTICAL_LINE									0x007C
#define U_RIGHT_CURLY_BRACKET								0x007D
#define U_TILDE										0x007E
#define U_DELETE									0x007F
#define U_NO_BREAK_SPACE								0x00A0
#define U_INVERTED_EXCLAMATION_MARK							0x00A1
#define U_CENT_SIGN									0x00A2
#define U_POUND_SIGN									0x00A3
#define U_CURRENCY_SIGN									0x00A4
#define U_YEN_SIGN									0x00A5
#define U_BROKEN_BAR									0x00A6
#define U_SECTION_SIGN									0x00A7
#define U_DIAERESIS									0x00A8
#define U_COPYRIGHT_SIGN								0x00A9
#define U_FEMININE_ORDINAL_INDICATOR							0x00AA
#define U_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK					0x00AB
#define U_NOT_SIGN									0x00AC
#define U_SOFT_HYPHEN									0x00AD
#define U_REGISTERED_SIGN								0x00AE
#define U_MACRON									0x00AF
#define U_DEGREE_SIGN									0x00B0
#define U_PLUS_MINUS_SIGN								0x00B1
#define U_SUPERSCRIPT_TWO								0x00B2
#define U_SUPERSCRIPT_THREE								0x00B3
#define U_ACUTE_ACCENT									0x00B4
#define U_MICRO_SIGN									0x00B5
#define U_PILCROW_SIGN									0x00B6
#define U_MIDDLE_DOT									0x00B7
#define U_CEDILLA									0x00B8
#define U_SUPERSCRIPT_ONE								0x00B9
#define U_MASCULINE_ORDINAL_INDICATOR							0x00BA
#define U_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK					0x00BB
#define U_VULGAR_FRACTION_ONE_QUARTER							0x00BC
#define U_VULGAR_FRACTION_ONE_HALF							0x00BD
#define U_VULGAR_FRACTION_THREE_QUARTERS						0x00BE
#define U_INVERTED_QUESTION_MARK							0x00BF
#define U_LATIN_CAPITAL_LETTER_A_WITH_GRAVE						0x00C0
#define U_LATIN_CAPITAL_LETTER_A_WITH_ACUTE						0x00C1
#define U_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX					0x00C2
#define U_LATIN_CAPITAL_LETTER_A_WITH_TILDE						0x00C3
#define U_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS						0x00C4
#define U_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE					0x00C5
#define U_LATIN_CAPITAL_LETTER_AE							0x00C6
#define U_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA						0x00C7
#define U_LATIN_CAPITAL_LETTER_E_WITH_GRAVE						0x00C8
#define U_LATIN_CAPITAL_LETTER_E_WITH_ACUTE						0x00C9
#define U_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX					0x00CA
#define U_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS						0x00CB
#define U_LATIN_CAPITAL_LETTER_I_WITH_GRAVE						0x00CC
#define U_LATIN_CAPITAL_LETTER_I_WITH_ACUTE						0x00CD
#define U_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX					0x00CE
#define U_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS						0x00CF
#define U_LATIN_CAPITAL_LETTER_ETH							0x00D0
#define U_LATIN_CAPITAL_LETTER_N_WITH_TILDE						0x00D1
#define U_LATIN_CAPITAL_LETTER_O_WITH_GRAVE						0x00D2
#define U_LATIN_CAPITAL_LETTER_O_WITH_ACUTE						0x00D3
#define U_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX					0x00D4
#define U_LATIN_CAPITAL_LETTER_O_WITH_TILDE						0x00D5
#define U_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS						0x00D6
#define U_MULTIPLICATION_SIGN								0x00D7
#define U_LATIN_CAPITAL_LETTER_O_WITH_STROKE						0x00D8
#define U_LATIN_CAPITAL_LETTER_U_WITH_GRAVE						0x00D9
#define U_LATIN_CAPITAL_LETTER_U_WITH_ACUTE						0x00DA
#define U_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX					0x00DB
#define U_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS						0x00DC
#define U_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE						0x00DD
#define U_LATIN_CAPITAL_LETTER_THORN							0x00DE
#define U_LATIN_SMALL_LETTER_SHARP_S							0x00DF
#define U_LATIN_SMALL_LETTER_A_WITH_GRAVE						0x00E0
#define U_LATIN_SMALL_LETTER_A_WITH_ACUTE						0x00E1
#define U_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX						0x00E2
#define U_LATIN_SMALL_LETTER_A_WITH_TILDE						0x00E3
#define U_LATIN_SMALL_LETTER_A_WITH_DIAERESIS						0x00E4
#define U_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE						0x00E5
#define U_LATIN_SMALL_LETTER_AE								0x00E6
#define U_LATIN_SMALL_LETTER_C_WITH_CEDILLA						0x00E7
#define U_LATIN_SMALL_LETTER_E_WITH_GRAVE						0x00E8
#define U_LATIN_SMALL_LETTER_E_WITH_ACUTE						0x00E9
#define U_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX						0x00EA
#define U_LATIN_SMALL_LETTER_E_WITH_DIAERESIS						0x00EB
#define U_LATIN_SMALL_LETTER_I_WITH_GRAVE						0x00EC
#define U_LATIN_SMALL_LETTER_I_WITH_ACUTE						0x00ED
#define U_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX						0x00EE
#define U_LATIN_SMALL_LETTER_I_WITH_DIAERESIS						0x00EF
#define U_LATIN_SMALL_LETTER_ETH							0x00F0
#define U_LATIN_SMALL_LETTER_N_WITH_TILDE						0x00F1
#define U_LATIN_SMALL_LETTER_O_WITH_GRAVE						0x00F2
#define U_LATIN_SMALL_LETTER_O_WITH_ACUTE						0x00F3
#define U_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX						0x00F4
#define U_LATIN_SMALL_LETTER_O_WITH_TILDE						0x00F5
#define U_LATIN_SMALL_LETTER_O_WITH_DIAERESIS						0x00F6
#define U_DIVISION_SIGN									0x00F7
#define U_LATIN_SMALL_LETTER_O_WITH_STROKE						0x00F8
#define U_LATIN_SMALL_LETTER_U_WITH_GRAVE						0x00F9
#define U_LATIN_SMALL_LETTER_U_WITH_ACUTE						0x00FA
#define U_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX						0x00FB
#define U_LATIN_SMALL_LETTER_U_WITH_DIAERESIS						0x00FC
#define U_LATIN_SMALL_LETTER_Y_WITH_ACUTE						0x00FD
#define U_LATIN_SMALL_LETTER_THORN							0x00FE
#define U_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS						0x00FF
#define U_LATIN_CAPITAL_LETTER_A_WITH_MACRON						0x0100
#define U_LATIN_SMALL_LETTER_A_WITH_MACRON						0x0101
#define U_LATIN_CAPITAL_LETTER_A_WITH_BREVE						0x0102
#define U_LATIN_SMALL_LETTER_A_WITH_BREVE						0x0103
#define U_LATIN_CAPITAL_LETTER_A_WITH_OGONEK						0x0104
#define U_LATIN_SMALL_LETTER_A_WITH_OGONEK						0x0105
#define U_LATIN_CAPITAL_LETTER_C_WITH_ACUTE						0x0106
#define U_LATIN_SMALL_LETTER_C_WITH_ACUTE						0x0107
#define U_LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX					0x0108
#define U_LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX						0x0109
#define U_LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE						0x010A
#define U_LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE						0x010B
#define U_LATIN_CAPITAL_LETTER_C_WITH_CARON						0x010C
#define U_LATIN_SMALL_LETTER_C_WITH_CARON						0x010D
#define U_LATIN_CAPITAL_LETTER_D_WITH_CARON						0x010E
#define U_LATIN_SMALL_LETTER_D_WITH_CARON						0x010F
#define U_LATIN_CAPITAL_LETTER_D_WITH_STROKE						0x0110
#define U_LATIN_SMALL_LETTER_D_WITH_STROKE						0x0111
#define U_LATIN_CAPITAL_LETTER_E_WITH_MACRON						0x0112
#define U_LATIN_SMALL_LETTER_E_WITH_MACRON						0x0113
#define U_LATIN_CAPITAL_LETTER_E_WITH_BREVE						0x0114
#define U_LATIN_SMALL_LETTER_E_WITH_BREVE						0x0115
#define U_LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE						0x0116
#define U_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE						0x0117
#define U_LATIN_CAPITAL_LETTER_E_WITH_OGONEK						0x0118
#define U_LATIN_SMALL_LETTER_E_WITH_OGONEK						0x0119
#define U_LATIN_CAPITAL_LETTER_E_WITH_CARON						0x011A
#define U_LATIN_SMALL_LETTER_E_WITH_CARON						0x011B
#define U_LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX					0x011C
#define U_LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX						0x011D
#define U_LATIN_CAPITAL_LETTER_G_WITH_BREVE						0x011E
#define U_LATIN_SMALL_LETTER_G_WITH_BREVE						0x011F
#define U_LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE						0x0120
#define U_LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE						0x0121
#define U_LATIN_CAPITAL_LETTER_G_WITH_CEDILLA						0x0122
#define U_LATIN_SMALL_LETTER_G_WITH_CEDILLA						0x0123
#define U_LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX					0x0124
#define U_LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX						0x0125
#define U_LATIN_CAPITAL_LETTER_H_WITH_STROKE						0x0126
#define U_LATIN_SMALL_LETTER_H_WITH_STROKE						0x0127
#define U_LATIN_CAPITAL_LETTER_I_WITH_TILDE						0x0128
#define U_LATIN_SMALL_LETTER_I_WITH_TILDE						0x0129
#define U_LATIN_CAPITAL_LETTER_I_WITH_MACRON						0x012A
#define U_LATIN_SMALL_LETTER_I_WITH_MACRON						0x012B
#define U_LATIN_CAPITAL_LETTER_I_WITH_BREVE						0x012C
#define U_LATIN_SMALL_LETTER_I_WITH_BREVE						0x012D
#define U_LATIN_CAPITAL_LETTER_I_WITH_OGONEK						0x012E
#define U_LATIN_SMALL_LETTER_I_WITH_OGONEK						0x012F
#define U_LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE						0x0130
#define U_LATIN_SMALL_LETTER_DOTLESS_I							0x0131
#define U_LATIN_CAPITAL_LIGATURE_IJ							0x0132
#define U_LATIN_SMALL_LIGATURE_IJ							0x0133
#define U_LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX					0x0134
#define U_LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX						0x0135
#define U_LATIN_CAPITAL_LETTER_K_WITH_CEDILLA						0x0136
#define U_LATIN_SMALL_LETTER_K_WITH_CEDILLA						0x0137
#define U_LATIN_SMALL_LETTER_KRA							0x0138
#define U_LATIN_CAPITAL_LETTER_L_WITH_ACUTE						0x0139
#define U_LATIN_SMALL_LETTER_L_WITH_ACUTE						0x013A
#define U_LATIN_CAPITAL_LETTER_L_WITH_CEDILLA						0x013B
#define U_LATIN_SMALL_LETTER_L_WITH_CEDILLA						0x013C
#define U_LATIN_CAPITAL_LETTER_L_WITH_CARON						0x013D
#define U_LATIN_SMALL_LETTER_L_WITH_CARON						0x013E
#define U_LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT					0x013F
#define U_LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT						0x0140
#define U_LATIN_CAPITAL_LETTER_L_WITH_STROKE						0x0141
#define U_LATIN_SMALL_LETTER_L_WITH_STROKE						0x0142
#define U_LATIN_CAPITAL_LETTER_N_WITH_ACUTE						0x0143
#define U_LATIN_SMALL_LETTER_N_WITH_ACUTE						0x0144
#define U_LATIN_CAPITAL_LETTER_N_WITH_CEDILLA						0x0145
#define U_LATIN_SMALL_LETTER_N_WITH_CEDILLA						0x0146
#define U_LATIN_CAPITAL_LETTER_N_WITH_CARON						0x0147
#define U_LATIN_SMALL_LETTER_N_WITH_CARON						0x0148
#define U_LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE					0x0149
#define U_LATIN_CAPITAL_LETTER_ENG							0x014A
#define U_LATIN_SMALL_LETTER_ENG							0x014B
#define U_LATIN_CAPITAL_LETTER_O_WITH_MACRON						0x014C
#define U_LATIN_SMALL_LETTER_O_WITH_MACRON						0x014D
#define U_LATIN_CAPITAL_LETTER_O_WITH_BREVE						0x014E
#define U_LATIN_SMALL_LETTER_O_WITH_BREVE						0x014F
#define U_LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE					0x0150
#define U_LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE					0x0151
#define U_LATIN_CAPITAL_LIGATURE_OE							0x0152
#define U_LATIN_SMALL_LIGATURE_OE							0x0153
#define U_LATIN_CAPITAL_LETTER_R_WITH_ACUTE						0x0154
#define U_LATIN_SMALL_LETTER_R_WITH_ACUTE						0x0155
#define U_LATIN_CAPITAL_LETTER_R_WITH_CEDILLA						0x0156
#define U_LATIN_SMALL_LETTER_R_WITH_CEDILLA						0x0157
#define U_LATIN_CAPITAL_LETTER_R_WITH_CARON						0x0158
#define U_LATIN_SMALL_LETTER_R_WITH_CARON						0x0159
#define U_LATIN_CAPITAL_LETTER_S_WITH_ACUTE						0x015A
#define U_LATIN_SMALL_LETTER_S_WITH_ACUTE						0x015B
#define U_LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX					0x015C
#define U_LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX						0x015D
#define U_LATIN_CAPITAL_LETTER_S_WITH_CEDILLA						0x015E
#define U_LATIN_SMALL_LETTER_S_WITH_CEDILLA						0x015F
#define U_LATIN_CAPITAL_LETTER_S_WITH_CARON						0x0160
#define U_LATIN_SMALL_LETTER_S_WITH_CARON						0x0161
#define U_LATIN_CAPITAL_LETTER_T_WITH_CEDILLA						0x0162
#define U_LATIN_SMALL_LETTER_T_WITH_CEDILLA						0x0163
#define U_LATIN_CAPITAL_LETTER_T_WITH_CARON						0x0164
#define U_LATIN_SMALL_LETTER_T_WITH_CARON						0x0165
#define U_LATIN_CAPITAL_LETTER_T_WITH_STROKE						0x0166
#define U_LATIN_SMALL_LETTER_T_WITH_STROKE						0x0167
#define U_LATIN_CAPITAL_LETTER_U_WITH_TILDE						0x0168
#define U_LATIN_SMALL_LETTER_U_WITH_TILDE						0x0169
#define U_LATIN_CAPITAL_LETTER_U_WITH_MACRON						0x016A
#define U_LATIN_SMALL_LETTER_U_WITH_MACRON						0x016B
#define U_LATIN_CAPITAL_LETTER_U_WITH_BREVE						0x016C
#define U_LATIN_SMALL_LETTER_U_WITH_BREVE						0x016D
#define U_LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE					0x016E
#define U_LATIN_SMALL_LETTER_U_WITH_RING_ABOVE						0x016F
#define U_LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE					0x0170
#define U_LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE					0x0171
#define U_LATIN_CAPITAL_LETTER_U_WITH_OGONEK						0x0172
#define U_LATIN_SMALL_LETTER_U_WITH_OGONEK						0x0173
#define U_LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX					0x0174
#define U_LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX						0x0175
#define U_LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX					0x0176
#define U_LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX						0x0177
#define U_LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS						0x0178
#define U_LATIN_CAPITAL_LETTER_Z_WITH_ACUTE						0x0179
#define U_LATIN_SMALL_LETTER_Z_WITH_ACUTE						0x017A
#define U_LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE						0x017B
#define U_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE						0x017C
#define U_LATIN_CAPITAL_LETTER_Z_WITH_CARON						0x017D
#define U_LATIN_SMALL_LETTER_Z_WITH_CARON						0x017E
#define U_LATIN_SMALL_LETTER_LONG_S							0x017F
#define U_LATIN_SMALL_LETTER_B_WITH_STROKE						0x0180
#define U_LATIN_CAPITAL_LETTER_B_WITH_HOOK						0x0181
#define U_LATIN_CAPITAL_LETTER_B_WITH_TOPBAR						0x0182
#define U_LATIN_SMALL_LETTER_B_WITH_TOPBAR						0x0183
#define U_LATIN_CAPITAL_LETTER_TONE_SIX							0x0184
#define U_LATIN_SMALL_LETTER_TONE_SIX							0x0185
#define U_LATIN_CAPITAL_LETTER_OPEN_O							0x0186
#define U_LATIN_CAPITAL_LETTER_C_WITH_HOOK						0x0187
#define U_LATIN_SMALL_LETTER_C_WITH_HOOK						0x0188
#define U_LATIN_CAPITAL_LETTER_AFRICAN_D						0x0189
#define U_LATIN_CAPITAL_LETTER_D_WITH_HOOK						0x018A
#define U_LATIN_CAPITAL_LETTER_D_WITH_TOPBAR						0x018B
#define U_LATIN_SMALL_LETTER_D_WITH_TOPBAR						0x018C
#define U_LATIN_SMALL_LETTER_TURNED_DELTA						0x018D
#define U_LATIN_CAPITAL_LETTER_REVERSED_E						0x018E
#define U_LATIN_CAPITAL_LETTER_SCHWA							0x018F
#define U_LATIN_CAPITAL_LETTER_OPEN_E							0x0190
#define U_LATIN_CAPITAL_LETTER_F_WITH_HOOK						0x0191
#define U_LATIN_SMALL_LETTER_F_WITH_HOOK						0x0192
#define U_LATIN_CAPITAL_LETTER_G_WITH_HOOK						0x0193
#define U_LATIN_CAPITAL_LETTER_GAMMA							0x0194
#define U_LATIN_SMALL_LETTER_HV								0x0195
#define U_LATIN_CAPITAL_LETTER_IOTA							0x0196
#define U_LATIN_CAPITAL_LETTER_I_WITH_STROKE						0x0197
#define U_LATIN_CAPITAL_LETTER_K_WITH_HOOK						0x0198
#define U_LATIN_SMALL_LETTER_K_WITH_HOOK						0x0199
#define U_LATIN_SMALL_LETTER_L_WITH_BAR							0x019A
#define U_LATIN_SMALL_LETTER_LAMBDA_WITH_STROKE						0x019B
#define U_LATIN_CAPITAL_LETTER_TURNED_M							0x019C
#define U_LATIN_CAPITAL_LETTER_N_WITH_LEFT_HOOK						0x019D
#define U_LATIN_SMALL_LETTER_N_WITH_LONG_RIGHT_LEG					0x019E
#define U_LATIN_CAPITAL_LETTER_O_WITH_MIDDLE_TILDE					0x019F
#define U_LATIN_CAPITAL_LETTER_O_WITH_HORN						0x01A0
#define U_LATIN_SMALL_LETTER_O_WITH_HORN						0x01A1
#define U_LATIN_CAPITAL_LETTER_OI							0x01A2
#define U_LATIN_SMALL_LETTER_OI								0x01A3
#define U_LATIN_CAPITAL_LETTER_P_WITH_HOOK						0x01A4
#define U_LATIN_SMALL_LETTER_P_WITH_HOOK						0x01A5
#define U_LATIN_LETTER_YR								0x01A6
#define U_LATIN_CAPITAL_LETTER_TONE_TWO							0x01A7
#define U_LATIN_SMALL_LETTER_TONE_TWO							0x01A8
#define U_LATIN_CAPITAL_LETTER_ESH							0x01A9
#define U_LATIN_LETTER_REVERSED_ESH_LOOP						0x01AA
#define U_LATIN_SMALL_LETTER_T_WITH_PALATAL_HOOK					0x01AB
#define U_LATIN_CAPITAL_LETTER_T_WITH_HOOK						0x01AC
#define U_LATIN_SMALL_LETTER_T_WITH_HOOK						0x01AD
#define U_LATIN_CAPITAL_LETTER_T_WITH_RETROFLEX_HOOK					0x01AE
#define U_LATIN_CAPITAL_LETTER_U_WITH_HORN						0x01AF
#define U_LATIN_SMALL_LETTER_U_WITH_HORN						0x01B0
#define U_LATIN_CAPITAL_LETTER_UPSILON							0x01B1
#define U_LATIN_CAPITAL_LETTER_V_WITH_HOOK						0x01B2
#define U_LATIN_CAPITAL_LETTER_Y_WITH_HOOK						0x01B3
#define U_LATIN_SMALL_LETTER_Y_WITH_HOOK						0x01B4
#define U_LATIN_CAPITAL_LETTER_Z_WITH_STROKE						0x01B5
#define U_LATIN_SMALL_LETTER_Z_WITH_STROKE						0x01B6
#define U_LATIN_CAPITAL_LETTER_EZH							0x01B7
#define U_LATIN_CAPITAL_LETTER_EZH_REVERSED						0x01B8
#define U_LATIN_SMALL_LETTER_EZH_REVERSED						0x01B9
#define U_LATIN_SMALL_LETTER_EZH_WITH_TAIL						0x01BA
#define U_LATIN_LETTER_TWO_WITH_STROKE							0x01BB
#define U_LATIN_CAPITAL_LETTER_TONE_FIVE						0x01BC
#define U_LATIN_SMALL_LETTER_TONE_FIVE							0x01BD
#define U_LATIN_LETTER_INVERTED_GLOTTAL_STOP_WITH_STROKE				0x01BE
#define U_LATIN_LETTER_WYNN								0x01BF
#define U_LATIN_LETTER_DENTAL_CLICK							0x01C0
#define U_LATIN_LETTER_LATERAL_CLICK							0x01C1
#define U_LATIN_LETTER_ALVEOLAR_CLICK							0x01C2
#define U_LATIN_LETTER_RETROFLEX_CLICK							0x01C3
#define U_LATIN_CAPITAL_LETTER_DZ_WITH_CARON						0x01C4
#define U_LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z_WITH_CARON				0x01C5
#define U_LATIN_SMALL_LETTER_DZ_WITH_CARON						0x01C6
#define U_LATIN_CAPITAL_LETTER_LJ							0x01C7
#define U_LATIN_CAPITAL_LETTER_L_WITH_SMALL_LETTER_J					0x01C8
#define U_LATIN_SMALL_LETTER_LJ								0x01C9
#define U_LATIN_CAPITAL_LETTER_NJ							0x01CA
#define U_LATIN_CAPITAL_LETTER_N_WITH_SMALL_LETTER_J					0x01CB
#define U_LATIN_SMALL_LETTER_NJ								0x01CC
#define U_LATIN_CAPITAL_LETTER_A_WITH_CARON						0x01CD
#define U_LATIN_SMALL_LETTER_A_WITH_CARON						0x01CE
#define U_LATIN_CAPITAL_LETTER_I_WITH_CARON						0x01CF
#define U_LATIN_SMALL_LETTER_I_WITH_CARON						0x01D0
#define U_LATIN_CAPITAL_LETTER_O_WITH_CARON						0x01D1
#define U_LATIN_SMALL_LETTER_O_WITH_CARON						0x01D2
#define U_LATIN_CAPITAL_LETTER_U_WITH_CARON						0x01D3
#define U_LATIN_SMALL_LETTER_U_WITH_CARON						0x01D4
#define U_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_MACRON				0x01D5
#define U_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_MACRON				0x01D6
#define U_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_ACUTE				0x01D7
#define U_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_ACUTE					0x01D8
#define U_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_CARON				0x01D9
#define U_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_CARON					0x01DA
#define U_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_GRAVE				0x01DB
#define U_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_GRAVE					0x01DC
#define U_LATIN_SMALL_LETTER_TURNED_E							0x01DD
#define U_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS_AND_MACRON				0x01DE
#define U_LATIN_SMALL_LETTER_A_WITH_DIAERESIS_AND_MACRON				0x01DF
#define U_LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON				0x01E0
#define U_LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON				0x01E1
#define U_LATIN_CAPITAL_LETTER_AE_WITH_MACRON						0x01E2
#define U_LATIN_SMALL_LETTER_AE_WITH_MACRON						0x01E3
#define U_LATIN_CAPITAL_LETTER_G_WITH_STROKE						0x01E4
#define U_LATIN_SMALL_LETTER_G_WITH_STROKE						0x01E5
#define U_LATIN_CAPITAL_LETTER_G_WITH_CARON						0x01E6
#define U_LATIN_SMALL_LETTER_G_WITH_CARON						0x01E7
#define U_LATIN_CAPITAL_LETTER_K_WITH_CARON						0x01E8
#define U_LATIN_SMALL_LETTER_K_WITH_CARON						0x01E9
#define U_LATIN_CAPITAL_LETTER_O_WITH_OGONEK						0x01EA
#define U_LATIN_SMALL_LETTER_O_WITH_OGONEK						0x01EB
#define U_LATIN_CAPITAL_LETTER_O_WITH_OGONEK_AND_MACRON					0x01EC
#define U_LATIN_SMALL_LETTER_O_WITH_OGONEK_AND_MACRON					0x01ED
#define U_LATIN_CAPITAL_LETTER_EZH_WITH_CARON						0x01EE
#define U_LATIN_SMALL_LETTER_EZH_WITH_CARON						0x01EF
#define U_LATIN_SMALL_LETTER_J_WITH_CARON						0x01F0
#define U_LATIN_CAPITAL_LETTER_DZ							0x01F1
#define U_LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z					0x01F2
#define U_LATIN_SMALL_LETTER_DZ								0x01F3
#define U_LATIN_CAPITAL_LETTER_G_WITH_ACUTE						0x01F4
#define U_LATIN_SMALL_LETTER_G_WITH_ACUTE						0x01F5
#define U_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE				0x01FA
#define U_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE				0x01FB
#define U_LATIN_CAPITAL_LETTER_AE_WITH_ACUTE						0x01FC
#define U_LATIN_SMALL_LETTER_AE_WITH_ACUTE						0x01FD
#define U_LATIN_CAPITAL_LETTER_O_WITH_STROKE_AND_ACUTE					0x01FE
#define U_LATIN_SMALL_LETTER_O_WITH_STROKE_AND_ACUTE					0x01FF
#define U_LATIN_CAPITAL_LETTER_A_WITH_DOUBLE_GRAVE					0x0200
#define U_LATIN_SMALL_LETTER_A_WITH_DOUBLE_GRAVE					0x0201
#define U_LATIN_CAPITAL_LETTER_A_WITH_INVERTED_BREVE					0x0202
#define U_LATIN_SMALL_LETTER_A_WITH_INVERTED_BREVE					0x0203
#define U_LATIN_CAPITAL_LETTER_E_WITH_DOUBLE_GRAVE					0x0204
#define U_LATIN_SMALL_LETTER_E_WITH_DOUBLE_GRAVE					0x0205
#define U_LATIN_CAPITAL_LETTER_E_WITH_INVERTED_BREVE					0x0206
#define U_LATIN_SMALL_LETTER_E_WITH_INVERTED_BREVE					0x0207
#define U_LATIN_CAPITAL_LETTER_I_WITH_DOUBLE_GRAVE					0x0208
#define U_LATIN_SMALL_LETTER_I_WITH_DOUBLE_GRAVE					0x0209
#define U_LATIN_CAPITAL_LETTER_I_WITH_INVERTED_BREVE					0x020A
#define U_LATIN_SMALL_LETTER_I_WITH_INVERTED_BREVE					0x020B
#define U_LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_GRAVE					0x020C
#define U_LATIN_SMALL_LETTER_O_WITH_DOUBLE_GRAVE					0x020D
#define U_LATIN_CAPITAL_LETTER_O_WITH_INVERTED_BREVE					0x020E
#define U_LATIN_SMALL_LETTER_O_WITH_INVERTED_BREVE					0x020F
#define U_LATIN_CAPITAL_LETTER_R_WITH_DOUBLE_GRAVE					0x0210
#define U_LATIN_SMALL_LETTER_R_WITH_DOUBLE_GRAVE					0x0211
#define U_LATIN_CAPITAL_LETTER_R_WITH_INVERTED_BREVE					0x0212
#define U_LATIN_SMALL_LETTER_R_WITH_INVERTED_BREVE					0x0213
#define U_LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_GRAVE					0x0214
#define U_LATIN_SMALL_LETTER_U_WITH_DOUBLE_GRAVE					0x0215
#define U_LATIN_CAPITAL_LETTER_U_WITH_INVERTED_BREVE					0x0216
#define U_LATIN_SMALL_LETTER_U_WITH_INVERTED_BREVE					0x0217
#define U_LATIN_SMALL_LETTER_TURNED_A							0x0250
#define U_LATIN_SMALL_LETTER_ALPHA							0x0251
#define U_LATIN_SMALL_LETTER_TURNED_ALPHA						0x0252
#define U_LATIN_SMALL_LETTER_B_WITH_HOOK						0x0253
#define U_LATIN_SMALL_LETTER_OPEN_O							0x0254
#define U_LATIN_SMALL_LETTER_C_WITH_CURL						0x0255
#define U_LATIN_SMALL_LETTER_D_WITH_TAIL						0x0256
#define U_LATIN_SMALL_LETTER_D_WITH_HOOK						0x0257
#define U_LATIN_SMALL_LETTER_REVERSED_E							0x0258
#define U_LATIN_SMALL_LETTER_SCHWA							0x0259
#define U_LATIN_SMALL_LETTER_SCHWA_WITH_HOOK						0x025A
#define U_LATIN_SMALL_LETTER_OPEN_E							0x025B
#define U_LATIN_SMALL_LETTER_REVERSED_OPEN_E						0x025C
#define U_LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_HOOK					0x025D
#define U_LATIN_SMALL_LETTER_CLOSED_REVERSED_OPEN_E					0x025E
#define U_LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE					0x025F
#define U_LATIN_SMALL_LETTER_G_WITH_HOOK						0x0260
#define U_LATIN_SMALL_LETTER_SCRIPT_G							0x0261
#define U_LATIN_LETTER_SMALL_CAPITAL_G							0x0262
#define U_LATIN_SMALL_LETTER_GAMMA							0x0263
#define U_LATIN_SMALL_LETTER_RAMS_HORN							0x0264
#define U_LATIN_SMALL_LETTER_TURNED_H							0x0265
#define U_LATIN_SMALL_LETTER_H_WITH_HOOK						0x0266
#define U_LATIN_SMALL_LETTER_HENG_WITH_HOOK						0x0267
#define U_LATIN_SMALL_LETTER_I_WITH_STROKE						0x0268
#define U_LATIN_SMALL_LETTER_IOTA							0x0269
#define U_LATIN_LETTER_SMALL_CAPITAL_I							0x026A
#define U_LATIN_SMALL_LETTER_L_WITH_MIDDLE_TILDE					0x026B
#define U_LATIN_SMALL_LETTER_L_WITH_BELT						0x026C
#define U_LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK					0x026D
#define U_LATIN_SMALL_LETTER_LEZH							0x026E
#define U_LATIN_SMALL_LETTER_TURNED_M							0x026F
#define U_LATIN_SMALL_LETTER_TURNED_M_WITH_LONG_LEG					0x0270
#define U_LATIN_SMALL_LETTER_M_WITH_HOOK						0x0271
#define U_LATIN_SMALL_LETTER_N_WITH_LEFT_HOOK						0x0272
#define U_LATIN_SMALL_LETTER_N_WITH_RETROFLEX_HOOK					0x0273
#define U_LATIN_LETTER_SMALL_CAPITAL_N							0x0274
#define U_LATIN_SMALL_LETTER_BARRED_O							0x0275
#define U_LATIN_LETTER_SMALL_CAPITAL_OE							0x0276
#define U_LATIN_SMALL_LETTER_CLOSED_OMEGA						0x0277
#define U_LATIN_SMALL_LETTER_PHI							0x0278
#define U_LATIN_SMALL_LETTER_TURNED_R							0x0279
#define U_LATIN_SMALL_LETTER_TURNED_R_WITH_LONG_LEG					0x027A
#define U_LATIN_SMALL_LETTER_TURNED_R_WITH_HOOK						0x027B
#define U_LATIN_SMALL_LETTER_R_WITH_LONG_LEG						0x027C
#define U_LATIN_SMALL_LETTER_R_WITH_TAIL						0x027D
#define U_LATIN_SMALL_LETTER_R_WITH_FISHHOOK						0x027E
#define U_LATIN_SMALL_LETTER_REVERSED_R_WITH_FISHHOOK					0x027F
#define U_LATIN_LETTER_SMALL_CAPITAL_R							0x0280
#define U_LATIN_LETTER_SMALL_CAPITAL_INVERTED_R						0x0281
#define U_LATIN_SMALL_LETTER_S_WITH_HOOK						0x0282
#define U_LATIN_SMALL_LETTER_ESH							0x0283
#define U_LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE_AND_HOOK				0x0284
#define U_LATIN_SMALL_LETTER_SQUAT_REVERSED_ESH						0x0285
#define U_LATIN_SMALL_LETTER_ESH_WITH_CURL						0x0286
#define U_LATIN_SMALL_LETTER_TURNED_T							0x0287
#define U_LATIN_SMALL_LETTER_T_WITH_RETROFLEX_HOOK					0x0288
#define U_LATIN_SMALL_LETTER_U_BAR							0x0289
#define U_LATIN_SMALL_LETTER_UPSILON							0x028A
#define U_LATIN_SMALL_LETTER_V_WITH_HOOK						0x028B
#define U_LATIN_SMALL_LETTER_TURNED_V							0x028C
#define U_LATIN_SMALL_LETTER_TURNED_W							0x028D
#define U_LATIN_SMALL_LETTER_TURNED_Y							0x028E
#define U_LATIN_LETTER_SMALL_CAPITAL_Y							0x028F
#define U_LATIN_SMALL_LETTER_Z_WITH_RETROFLEX_HOOK					0x0290
#define U_LATIN_SMALL_LETTER_Z_WITH_CURL						0x0291
#define U_LATIN_SMALL_LETTER_EZH							0x0292
#define U_LATIN_SMALL_LETTER_EZH_WITH_CURL						0x0293
#define U_LATIN_LETTER_GLOTTAL_STOP							0x0294
#define U_LATIN_LETTER_PHARYNGEAL_VOICED_FRICATIVE					0x0295
#define U_LATIN_LETTER_INVERTED_GLOTTAL_STOP						0x0296
#define U_LATIN_LETTER_STRETCHED_C							0x0297
#define U_LATIN_LETTER_BILABIAL_CLICK							0x0298
#define U_LATIN_LETTER_SMALL_CAPITAL_B							0x0299
#define U_LATIN_SMALL_LETTER_CLOSED_OPEN_E						0x029A
#define U_LATIN_LETTER_SMALL_CAPITAL_G_WITH_HOOK					0x029B
#define U_LATIN_LETTER_SMALL_CAPITAL_H							0x029C
#define U_LATIN_SMALL_LETTER_J_WITH_CROSSED_TAIL					0x029D
#define U_LATIN_SMALL_LETTER_TURNED_K							0x029E
#define U_LATIN_LETTER_SMALL_CAPITAL_L							0x029F
#define U_LATIN_SMALL_LETTER_Q_WITH_HOOK						0x02A0
#define U_LATIN_LETTER_GLOTTAL_STOP_WITH_STROKE						0x02A1
#define U_LATIN_LETTER_REVERSED_GLOTTAL_STOP_WITH_STROKE				0x02A2
#define U_LATIN_SMALL_LETTER_DZ_DIGRAPH							0x02A3
#define U_LATIN_SMALL_LETTER_DEZH_DIGRAPH						0x02A4
#define U_LATIN_SMALL_LETTER_DZ_DIGRAPH_WITH_CURL					0x02A5
#define U_LATIN_SMALL_LETTER_TS_DIGRAPH							0x02A6
#define U_LATIN_SMALL_LETTER_TESH_DIGRAPH						0x02A7
#define U_LATIN_SMALL_LETTER_TC_DIGRAPH_WITH_CURL					0x02A8
#define U_MODIFIER_LETTER_SMALL_H							0x02B0
#define U_MODIFIER_LETTER_SMALL_H_WITH_HOOK						0x02B1
#define U_MODIFIER_LETTER_SMALL_J							0x02B2
#define U_MODIFIER_LETTER_SMALL_R							0x02B3
#define U_MODIFIER_LETTER_SMALL_TURNED_R						0x02B4
#define U_MODIFIER_LETTER_SMALL_TURNED_R_WITH_HOOK					0x02B5
#define U_MODIFIER_LETTER_SMALL_CAPITAL_INVERTED_R					0x02B6
#define U_MODIFIER_LETTER_SMALL_W							0x02B7
#define U_MODIFIER_LETTER_SMALL_Y							0x02B8
#define U_MODIFIER_LETTER_PRIME								0x02B9
#define U_MODIFIER_LETTER_DOUBLE_PRIME							0x02BA
#define U_MODIFIER_LETTER_TURNED_COMMA							0x02BB
#define U_MODIFIER_LETTER_APOSTROPHE							0x02BC
#define U_MODIFIER_LETTER_REVERSED_COMMA						0x02BD
#define U_MODIFIER_LETTER_RIGHT_HALF_RING						0x02BE
#define U_MODIFIER_LETTER_LEFT_HALF_RING						0x02BF
#define U_MODIFIER_LETTER_GLOTTAL_STOP							0x02C0
#define U_MODIFIER_LETTER_REVERSED_GLOTTAL_STOP						0x02C1
#define U_MODIFIER_LETTER_LEFT_ARROWHEAD						0x02C2
#define U_MODIFIER_LETTER_RIGHT_ARROWHEAD						0x02C3
#define U_MODIFIER_LETTER_UP_ARROWHEAD							0x02C4
#define U_MODIFIER_LETTER_DOWN_ARROWHEAD						0x02C5
#define U_MODIFIER_LETTER_CIRCUMFLEX_ACCENT						0x02C6
#define U_CARON										0x02C7
#define U_MODIFIER_LETTER_VERTICAL_LINE							0x02C8
#define U_MODIFIER_LETTER_MACRON							0x02C9
#define U_MODIFIER_LETTER_ACUTE_ACCENT							0x02CA
#define U_MODIFIER_LETTER_GRAVE_ACCENT							0x02CB
#define U_MODIFIER_LETTER_LOW_VERTICAL_LINE						0x02CC
#define U_MODIFIER_LETTER_LOW_MACRON							0x02CD
#define U_MODIFIER_LETTER_LOW_GRAVE_ACCENT						0x02CE
#define U_MODIFIER_LETTER_LOW_ACUTE_ACCENT						0x02CF
#define U_MODIFIER_LETTER_TRIANGULAR_COLON						0x02D0
#define U_MODIFIER_LETTER_HALF_TRIANGULAR_COLON						0x02D1
#define U_MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING					0x02D2
#define U_MODIFIER_LETTER_CENTRED_LEFT_HALF_RING					0x02D3
#define U_MODIFIER_LETTER_UP_TACK							0x02D4
#define U_MODIFIER_LETTER_DOWN_TACK							0x02D5
#define U_MODIFIER_LETTER_PLUS_SIGN							0x02D6
#define U_MODIFIER_LETTER_MINUS_SIGN							0x02D7
#define U_BREVE										0x02D8
#define U_DOT_ABOVE									0x02D9
#define U_RING_ABOVE									0x02DA
#define U_OGONEK									0x02DB
#define U_SMALL_TILDE									0x02DC
#define U_DOUBLE_ACUTE_ACCENT								0x02DD
#define U_MODIFIER_LETTER_RHOTIC_HOOK							0x02DE
#define U_MODIFIER_LETTER_SMALL_GAMMA							0x02E0
#define U_MODIFIER_LETTER_SMALL_L							0x02E1
#define U_MODIFIER_LETTER_SMALL_S							0x02E2
#define U_MODIFIER_LETTER_SMALL_X							0x02E3
#define U_MODIFIER_LETTER_SMALL_REVERSED_GLOTTAL_STOP					0x02E4
#define U_MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR						0x02E5
#define U_MODIFIER_LETTER_HIGH_TONE_BAR							0x02E6
#define U_MODIFIER_LETTER_MID_TONE_BAR							0x02E7
#define U_MODIFIER_LETTER_LOW_TONE_BAR							0x02E8
#define U_MODIFIER_LETTER_EXTRA_LOW_TONE_BAR						0x02E9
#define U_COMBINING_GRAVE_ACCENT							0x0300
#define U_COMBINING_ACUTE_ACCENT							0x0301
#define U_COMBINING_CIRCUMFLEX_ACCENT							0x0302
#define U_COMBINING_TILDE								0x0303
#define U_COMBINING_MACRON								0x0304
#define U_COMBINING_OVERLINE								0x0305
#define U_COMBINING_BREVE								0x0306
#define U_COMBINING_DOT_ABOVE								0x0307
#define U_COMBINING_DIAERESIS								0x0308
#define U_COMBINING_HOOK_ABOVE								0x0309
#define U_COMBINING_RING_ABOVE								0x030A
#define U_COMBINING_DOUBLE_ACUTE_ACCENT							0x030B
#define U_COMBINING_CARON								0x030C
#define U_COMBINING_VERTICAL_LINE_ABOVE							0x030D
#define U_COMBINING_DOUBLE_VERTICAL_LINE_ABOVE						0x030E
#define U_COMBINING_DOUBLE_GRAVE_ACCENT							0x030F
#define U_COMBINING_CANDRABINDU								0x0310
#define U_COMBINING_INVERTED_BREVE							0x0311
#define U_COMBINING_TURNED_COMMA_ABOVE							0x0312
#define U_COMBINING_COMMA_ABOVE								0x0313
#define U_COMBINING_REVERSED_COMMA_ABOVE						0x0314
#define U_COMBINING_COMMA_ABOVE_RIGHT							0x0315
#define U_COMBINING_GRAVE_ACCENT_BELOW							0x0316
#define U_COMBINING_ACUTE_ACCENT_BELOW							0x0317
#define U_COMBINING_LEFT_TACK_BELOW							0x0318
#define U_COMBINING_RIGHT_TACK_BELOW							0x0319
#define U_COMBINING_LEFT_ANGLE_ABOVE							0x031A
#define U_COMBINING_HORN								0x031B
#define U_COMBINING_LEFT_HALF_RING_BELOW						0x031C
#define U_COMBINING_UP_TACK_BELOW							0x031D
#define U_COMBINING_DOWN_TACK_BELOW							0x031E
#define U_COMBINING_PLUS_SIGN_BELOW							0x031F
#define U_COMBINING_MINUS_SIGN_BELOW							0x0320
#define U_COMBINING_PALATALIZED_HOOK_BELOW						0x0321
#define U_COMBINING_RETROFLEX_HOOK_BELOW						0x0322
#define U_COMBINING_DOT_BELOW								0x0323
#define U_COMBINING_DIAERESIS_BELOW							0x0324
#define U_COMBINING_RING_BELOW								0x0325
#define U_COMBINING_COMMA_BELOW								0x0326
#define U_COMBINING_CEDILLA								0x0327
#define U_COMBINING_OGONEK								0x0328
#define U_COMBINING_VERTICAL_LINE_BELOW							0x0329
#define U_COMBINING_BRIDGE_BELOW							0x032A
#define U_COMBINING_INVERTED_DOUBLE_ARCH_BELOW						0x032B
#define U_COMBINING_CARON_BELOW								0x032C
#define U_COMBINING_CIRCUMFLEX_ACCENT_BELOW						0x032D
#define U_COMBINING_BREVE_BELOW								0x032E
#define U_COMBINING_INVERTED_BREVE_BELOW						0x032F
#define U_COMBINING_TILDE_BELOW								0x0330
#define U_COMBINING_MACRON_BELOW							0x0331
#define U_COMBINING_LOW_LINE								0x0332
#define U_COMBINING_DOUBLE_LOW_LINE							0x0333
#define U_COMBINING_TILDE_OVERLAY							0x0334
#define U_COMBINING_SHORT_STROKE_OVERLAY						0x0335
#define U_COMBINING_LONG_STROKE_OVERLAY							0x0336
#define U_COMBINING_SHORT_SOLIDUS_OVERLAY						0x0337
#define U_COMBINING_LONG_SOLIDUS_OVERLAY						0x0338
#define U_COMBINING_RIGHT_HALF_RING_BELOW						0x0339
#define U_COMBINING_INVERTED_BRIDGE_BELOW						0x033A
#define U_COMBINING_SQUARE_BELOW							0x033B
#define U_COMBINING_SEAGULL_BELOW							0x033C
#define U_COMBINING_X_ABOVE								0x033D
#define U_COMBINING_VERTICAL_TILDE							0x033E
#define U_COMBINING_DOUBLE_OVERLINE							0x033F
#define U_COMBINING_GRAVE_TONE_MARK							0x0340
#define U_COMBINING_ACUTE_TONE_MARK							0x0341
#define U_COMBINING_GREEK_PERISPOMENI							0x0342
#define U_COMBINING_GREEK_KORONIS							0x0343
#define U_COMBINING_GREEK_DIALYTIKA_TONOS						0x0344
#define U_COMBINING_GREEK_YPOGEGRAMMENI							0x0345
#define U_COMBINING_DOUBLE_TILDE							0x0360
#define U_COMBINING_DOUBLE_INVERTED_BREVE						0x0361
#define U_GREEK_NUMERAL_SIGN								0x0374
#define U_GREEK_LOWER_NUMERAL_SIGN							0x0375
#define U_GREEK_YPOGEGRAMMENI								0x037A
#define U_GREEK_QUESTION_MARK								0x037E
#define U_GREEK_TONOS									0x0384
#define U_GREEK_DIALYTIKA_TONOS								0x0385
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS						0x0386
#define U_GREEK_ANO_TELEIA								0x0387
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS					0x0388
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_TONOS						0x0389
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS						0x038A
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS					0x038C
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS					0x038E
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS						0x038F
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS				0x0390
#define U_GREEK_CAPITAL_LETTER_ALPHA							0x0391
#define U_GREEK_CAPITAL_LETTER_BETA							0x0392
#define U_GREEK_CAPITAL_LETTER_GAMMA							0x0393
#define U_GREEK_CAPITAL_LETTER_DELTA							0x0394
#define U_GREEK_CAPITAL_LETTER_EPSILON							0x0395
#define U_GREEK_CAPITAL_LETTER_ZETA							0x0396
#define U_GREEK_CAPITAL_LETTER_ETA							0x0397
#define U_GREEK_CAPITAL_LETTER_THETA							0x0398
#define U_GREEK_CAPITAL_LETTER_IOTA							0x0399
#define U_GREEK_CAPITAL_LETTER_KAPPA							0x039A
#define U_GREEK_CAPITAL_LETTER_LAMDA							0x039B
#define U_GREEK_CAPITAL_LETTER_MU							0x039C
#define U_GREEK_CAPITAL_LETTER_NU							0x039D
#define U_GREEK_CAPITAL_LETTER_XI							0x039E
#define U_GREEK_CAPITAL_LETTER_OMICRON							0x039F
#define U_GREEK_CAPITAL_LETTER_PI							0x03A0
#define U_GREEK_CAPITAL_LETTER_RHO							0x03A1
#define U_GREEK_CAPITAL_LETTER_SIGMA							0x03A3
#define U_GREEK_CAPITAL_LETTER_TAU							0x03A4
#define U_GREEK_CAPITAL_LETTER_UPSILON							0x03A5
#define U_GREEK_CAPITAL_LETTER_PHI							0x03A6
#define U_GREEK_CAPITAL_LETTER_CHI							0x03A7
#define U_GREEK_CAPITAL_LETTER_PSI							0x03A8
#define U_GREEK_CAPITAL_LETTER_OMEGA							0x03A9
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA					0x03AA
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA					0x03AB
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_TONOS						0x03AC
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_TONOS						0x03AD
#define U_GREEK_SMALL_LETTER_ETA_WITH_TONOS						0x03AE
#define U_GREEK_SMALL_LETTER_IOTA_WITH_TONOS						0x03AF
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS				0x03B0
#define U_GREEK_SMALL_LETTER_ALPHA							0x03B1
#define U_GREEK_SMALL_LETTER_BETA							0x03B2
#define U_GREEK_SMALL_LETTER_GAMMA							0x03B3
#define U_GREEK_SMALL_LETTER_DELTA							0x03B4
#define U_GREEK_SMALL_LETTER_EPSILON							0x03B5
#define U_GREEK_SMALL_LETTER_ZETA							0x03B6
#define U_GREEK_SMALL_LETTER_ETA							0x03B7
#define U_GREEK_SMALL_LETTER_THETA							0x03B8
#define U_GREEK_SMALL_LETTER_IOTA							0x03B9
#define U_GREEK_SMALL_LETTER_KAPPA							0x03BA
#define U_GREEK_SMALL_LETTER_LAMDA							0x03BB
#define U_GREEK_SMALL_LETTER_MU								0x03BC
#define U_GREEK_SMALL_LETTER_NU								0x03BD
#define U_GREEK_SMALL_LETTER_XI								0x03BE
#define U_GREEK_SMALL_LETTER_OMICRON							0x03BF
#define U_GREEK_SMALL_LETTER_PI								0x03C0
#define U_GREEK_SMALL_LETTER_RHO							0x03C1
#define U_GREEK_SMALL_LETTER_FINAL_SIGMA						0x03C2
#define U_GREEK_SMALL_LETTER_SIGMA							0x03C3
#define U_GREEK_SMALL_LETTER_TAU							0x03C4
#define U_GREEK_SMALL_LETTER_UPSILON							0x03C5
#define U_GREEK_SMALL_LETTER_PHI							0x03C6
#define U_GREEK_SMALL_LETTER_CHI							0x03C7
#define U_GREEK_SMALL_LETTER_PSI							0x03C8
#define U_GREEK_SMALL_LETTER_OMEGA							0x03C9
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA					0x03CA
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA					0x03CB
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_TONOS						0x03CC
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_TONOS						0x03CD
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_TONOS						0x03CE
#define U_GREEK_BETA_SYMBOL								0x03D0
#define U_GREEK_THETA_SYMBOL								0x03D1
#define U_GREEK_UPSILON_WITH_HOOK_SYMBOL						0x03D2
#define U_GREEK_UPSILON_WITH_ACUTE_AND_HOOK_SYMBOL					0x03D3
#define U_GREEK_UPSILON_WITH_DIAERESIS_AND_HOOK_SYMBOL					0x03D4
#define U_GREEK_PHI_SYMBOL								0x03D5
#define U_GREEK_PI_SYMBOL								0x03D6
#define U_GREEK_LETTER_STIGMA								0x03DA
#define U_GREEK_LETTER_DIGAMMA								0x03DC
#define U_GREEK_LETTER_KOPPA								0x03DE
#define U_GREEK_LETTER_SAMPI								0x03E0
#define U_COPTIC_CAPITAL_LETTER_SHEI							0x03E2
#define U_COPTIC_SMALL_LETTER_SHEI							0x03E3
#define U_COPTIC_CAPITAL_LETTER_FEI							0x03E4
#define U_COPTIC_SMALL_LETTER_FEI							0x03E5
#define U_COPTIC_CAPITAL_LETTER_KHEI							0x03E6
#define U_COPTIC_SMALL_LETTER_KHEI							0x03E7
#define U_COPTIC_CAPITAL_LETTER_HORI							0x03E8
#define U_COPTIC_SMALL_LETTER_HORI							0x03E9
#define U_COPTIC_CAPITAL_LETTER_GANGIA							0x03EA
#define U_COPTIC_SMALL_LETTER_GANGIA							0x03EB
#define U_COPTIC_CAPITAL_LETTER_SHIMA							0x03EC
#define U_COPTIC_SMALL_LETTER_SHIMA							0x03ED
#define U_COPTIC_CAPITAL_LETTER_DEI							0x03EE
#define U_COPTIC_SMALL_LETTER_DEI							0x03EF
#define U_GREEK_KAPPA_SYMBOL								0x03F0
#define U_GREEK_RHO_SYMBOL								0x03F1
#define U_GREEK_LUNATE_SIGMA_SYMBOL							0x03F2
#define U_GREEK_LETTER_YOT								0x03F3
#define U_CYRILLIC_CAPITAL_LETTER_IO							0x0401
#define U_CYRILLIC_CAPITAL_LETTER_DJE							0x0402
#define U_CYRILLIC_CAPITAL_LETTER_GJE							0x0403
#define U_CYRILLIC_CAPITAL_LETTER_UKRAINIAN_IE						0x0404
#define U_CYRILLIC_CAPITAL_LETTER_DZE							0x0405
#define U_CYRILLIC_CAPITAL_LETTER_BYELORUSSIAN_UKRAINIAN_I				0x0406
#define U_CYRILLIC_CAPITAL_LETTER_YI							0x0407
#define U_CYRILLIC_CAPITAL_LETTER_JE							0x0408
#define U_CYRILLIC_CAPITAL_LETTER_LJE							0x0409
#define U_CYRILLIC_CAPITAL_LETTER_NJE							0x040A
#define U_CYRILLIC_CAPITAL_LETTER_TSHE							0x040B
#define U_CYRILLIC_CAPITAL_LETTER_KJE							0x040C
#define U_CYRILLIC_CAPITAL_LETTER_SHORT_U						0x040E
#define U_CYRILLIC_CAPITAL_LETTER_DZHE							0x040F
#define U_CYRILLIC_CAPITAL_LETTER_A							0x0410
#define U_CYRILLIC_CAPITAL_LETTER_BE							0x0411
#define U_CYRILLIC_CAPITAL_LETTER_VE							0x0412
#define U_CYRILLIC_CAPITAL_LETTER_GHE							0x0413
#define U_CYRILLIC_CAPITAL_LETTER_DE							0x0414
#define U_CYRILLIC_CAPITAL_LETTER_IE							0x0415
#define U_CYRILLIC_CAPITAL_LETTER_ZHE							0x0416
#define U_CYRILLIC_CAPITAL_LETTER_ZE							0x0417
#define U_CYRILLIC_CAPITAL_LETTER_I							0x0418
#define U_CYRILLIC_CAPITAL_LETTER_SHORT_I						0x0419
#define U_CYRILLIC_CAPITAL_LETTER_KA							0x041A
#define U_CYRILLIC_CAPITAL_LETTER_EL							0x041B
#define U_CYRILLIC_CAPITAL_LETTER_EM							0x041C
#define U_CYRILLIC_CAPITAL_LETTER_EN							0x041D
#define U_CYRILLIC_CAPITAL_LETTER_O							0x041E
#define U_CYRILLIC_CAPITAL_LETTER_PE							0x041F
#define U_CYRILLIC_CAPITAL_LETTER_ER							0x0420
#define U_CYRILLIC_CAPITAL_LETTER_ES							0x0421
#define U_CYRILLIC_CAPITAL_LETTER_TE							0x0422
#define U_CYRILLIC_CAPITAL_LETTER_U							0x0423
#define U_CYRILLIC_CAPITAL_LETTER_EF							0x0424
#define U_CYRILLIC_CAPITAL_LETTER_HA							0x0425
#define U_CYRILLIC_CAPITAL_LETTER_TSE							0x0426
#define U_CYRILLIC_CAPITAL_LETTER_CHE							0x0427
#define U_CYRILLIC_CAPITAL_LETTER_SHA							0x0428
#define U_CYRILLIC_CAPITAL_LETTER_SHCHA							0x0429
#define U_CYRILLIC_CAPITAL_LETTER_HARD_SIGN						0x042A
#define U_CYRILLIC_CAPITAL_LETTER_YERU							0x042B
#define U_CYRILLIC_CAPITAL_LETTER_SOFT_SIGN						0x042C
#define U_CYRILLIC_CAPITAL_LETTER_E							0x042D
#define U_CYRILLIC_CAPITAL_LETTER_YU							0x042E
#define U_CYRILLIC_CAPITAL_LETTER_YA							0x042F
#define U_CYRILLIC_SMALL_LETTER_A							0x0430
#define U_CYRILLIC_SMALL_LETTER_BE							0x0431
#define U_CYRILLIC_SMALL_LETTER_VE							0x0432
#define U_CYRILLIC_SMALL_LETTER_GHE							0x0433
#define U_CYRILLIC_SMALL_LETTER_DE							0x0434
#define U_CYRILLIC_SMALL_LETTER_IE							0x0435
#define U_CYRILLIC_SMALL_LETTER_ZHE							0x0436
#define U_CYRILLIC_SMALL_LETTER_ZE							0x0437
#define U_CYRILLIC_SMALL_LETTER_I							0x0438
#define U_CYRILLIC_SMALL_LETTER_SHORT_I							0x0439
#define U_CYRILLIC_SMALL_LETTER_KA							0x043A
#define U_CYRILLIC_SMALL_LETTER_EL							0x043B
#define U_CYRILLIC_SMALL_LETTER_EM							0x043C
#define U_CYRILLIC_SMALL_LETTER_EN							0x043D
#define U_CYRILLIC_SMALL_LETTER_O							0x043E
#define U_CYRILLIC_SMALL_LETTER_PE							0x043F
#define U_CYRILLIC_SMALL_LETTER_ER							0x0440
#define U_CYRILLIC_SMALL_LETTER_ES							0x0441
#define U_CYRILLIC_SMALL_LETTER_TE							0x0442
#define U_CYRILLIC_SMALL_LETTER_U							0x0443
#define U_CYRILLIC_SMALL_LETTER_EF							0x0444
#define U_CYRILLIC_SMALL_LETTER_HA							0x0445
#define U_CYRILLIC_SMALL_LETTER_TSE							0x0446
#define U_CYRILLIC_SMALL_LETTER_CHE							0x0447
#define U_CYRILLIC_SMALL_LETTER_SHA							0x0448
#define U_CYRILLIC_SMALL_LETTER_SHCHA							0x0449
#define U_CYRILLIC_SMALL_LETTER_HARD_SIGN						0x044A
#define U_CYRILLIC_SMALL_LETTER_YERU							0x044B
#define U_CYRILLIC_SMALL_LETTER_SOFT_SIGN						0x044C
#define U_CYRILLIC_SMALL_LETTER_E							0x044D
#define U_CYRILLIC_SMALL_LETTER_YU							0x044E
#define U_CYRILLIC_SMALL_LETTER_YA							0x044F
#define U_CYRILLIC_SMALL_LETTER_IO							0x0451
#define U_CYRILLIC_SMALL_LETTER_DJE							0x0452
#define U_CYRILLIC_SMALL_LETTER_GJE							0x0453
#define U_CYRILLIC_SMALL_LETTER_UKRAINIAN_IE						0x0454
#define U_CYRILLIC_SMALL_LETTER_DZE							0x0455
#define U_CYRILLIC_SMALL_LETTER_BYELORUSSIAN_UKRAINIAN_I				0x0456
#define U_CYRILLIC_SMALL_LETTER_YI							0x0457
#define U_CYRILLIC_SMALL_LETTER_JE							0x0458
#define U_CYRILLIC_SMALL_LETTER_LJE							0x0459
#define U_CYRILLIC_SMALL_LETTER_NJE							0x045A
#define U_CYRILLIC_SMALL_LETTER_TSHE							0x045B
#define U_CYRILLIC_SMALL_LETTER_KJE							0x045C
#define U_CYRILLIC_SMALL_LETTER_SHORT_U							0x045E
#define U_CYRILLIC_SMALL_LETTER_DZHE							0x045F
#define U_CYRILLIC_CAPITAL_LETTER_OMEGA							0x0460
#define U_CYRILLIC_SMALL_LETTER_OMEGA							0x0461
#define U_CYRILLIC_CAPITAL_LETTER_YAT							0x0462
#define U_CYRILLIC_SMALL_LETTER_YAT							0x0463
#define U_CYRILLIC_CAPITAL_LETTER_IOTIFIED_E						0x0464
#define U_CYRILLIC_SMALL_LETTER_IOTIFIED_E						0x0465
#define U_CYRILLIC_CAPITAL_LETTER_LITTLE_YUS						0x0466
#define U_CYRILLIC_SMALL_LETTER_LITTLE_YUS						0x0467
#define U_CYRILLIC_CAPITAL_LETTER_IOTIFIED_LITTLE_YUS					0x0468
#define U_CYRILLIC_SMALL_LETTER_IOTIFIED_LITTLE_YUS					0x0469
#define U_CYRILLIC_CAPITAL_LETTER_BIG_YUS						0x046A
#define U_CYRILLIC_SMALL_LETTER_BIG_YUS							0x046B
#define U_CYRILLIC_CAPITAL_LETTER_IOTIFIED_BIG_YUS					0x046C
#define U_CYRILLIC_SMALL_LETTER_IOTIFIED_BIG_YUS					0x046D
#define U_CYRILLIC_CAPITAL_LETTER_KSI							0x046E
#define U_CYRILLIC_SMALL_LETTER_KSI							0x046F
#define U_CYRILLIC_CAPITAL_LETTER_PSI							0x0470
#define U_CYRILLIC_SMALL_LETTER_PSI							0x0471
#define U_CYRILLIC_CAPITAL_LETTER_FITA							0x0472
#define U_CYRILLIC_SMALL_LETTER_FITA							0x0473
#define U_CYRILLIC_CAPITAL_LETTER_IZHITSA						0x0474
#define U_CYRILLIC_SMALL_LETTER_IZHITSA							0x0475
#define U_CYRILLIC_CAPITAL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT			0x0476
#define U_CYRILLIC_SMALL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT			0x0477
#define U_CYRILLIC_CAPITAL_LETTER_UK							0x0478
#define U_CYRILLIC_SMALL_LETTER_UK							0x0479
#define U_CYRILLIC_CAPITAL_LETTER_ROUND_OMEGA						0x047A
#define U_CYRILLIC_SMALL_LETTER_ROUND_OMEGA						0x047B
#define U_CYRILLIC_CAPITAL_LETTER_OMEGA_WITH_TITLO					0x047C
#define U_CYRILLIC_SMALL_LETTER_OMEGA_WITH_TITLO					0x047D
#define U_CYRILLIC_CAPITAL_LETTER_OT							0x047E
#define U_CYRILLIC_SMALL_LETTER_OT							0x047F
#define U_CYRILLIC_CAPITAL_LETTER_KOPPA							0x0480
#define U_CYRILLIC_SMALL_LETTER_KOPPA							0x0481
#define U_CYRILLIC_THOUSANDS_SIGN							0x0482
#define U_COMBINING_CYRILLIC_TITLO							0x0483
#define U_COMBINING_CYRILLIC_PALATALIZATION						0x0484
#define U_COMBINING_CYRILLIC_DASIA_PNEUMATA						0x0485
#define U_COMBINING_CYRILLIC_PSILI_PNEUMATA						0x0486
#define U_CYRILLIC_CAPITAL_LETTER_GHE_WITH_UPTURN					0x0490
#define U_CYRILLIC_SMALL_LETTER_GHE_WITH_UPTURN						0x0491
#define U_CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE					0x0492
#define U_CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE						0x0493
#define U_CYRILLIC_CAPITAL_LETTER_GHE_WITH_MIDDLE_HOOK					0x0494
#define U_CYRILLIC_SMALL_LETTER_GHE_WITH_MIDDLE_HOOK					0x0495
#define U_CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DESCENDER					0x0496
#define U_CYRILLIC_SMALL_LETTER_ZHE_WITH_DESCENDER					0x0497
#define U_CYRILLIC_CAPITAL_LETTER_ZE_WITH_DESCENDER					0x0498
#define U_CYRILLIC_SMALL_LETTER_ZE_WITH_DESCENDER					0x0499
#define U_CYRILLIC_CAPITAL_LETTER_KA_WITH_DESCENDER					0x049A
#define U_CYRILLIC_SMALL_LETTER_KA_WITH_DESCENDER					0x049B
#define U_CYRILLIC_CAPITAL_LETTER_KA_WITH_VERTICAL_STROKE				0x049C
#define U_CYRILLIC_SMALL_LETTER_KA_WITH_VERTICAL_STROKE					0x049D
#define U_CYRILLIC_CAPITAL_LETTER_KA_WITH_STROKE					0x049E
#define U_CYRILLIC_SMALL_LETTER_KA_WITH_STROKE						0x049F
#define U_CYRILLIC_CAPITAL_LETTER_BASHKIR_KA						0x04A0
#define U_CYRILLIC_SMALL_LETTER_BASHKIR_KA						0x04A1
#define U_CYRILLIC_CAPITAL_LETTER_EN_WITH_DESCENDER					0x04A2
#define U_CYRILLIC_SMALL_LETTER_EN_WITH_DESCENDER					0x04A3
#define U_CYRILLIC_CAPITAL_LIGATURE_EN_GHE						0x04A4
#define U_CYRILLIC_SMALL_LIGATURE_EN_GHE						0x04A5
#define U_CYRILLIC_CAPITAL_LETTER_PE_WITH_MIDDLE_HOOK					0x04A6
#define U_CYRILLIC_SMALL_LETTER_PE_WITH_MIDDLE_HOOK					0x04A7
#define U_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_HA						0x04A8
#define U_CYRILLIC_SMALL_LETTER_ABKHASIAN_HA						0x04A9
#define U_CYRILLIC_CAPITAL_LETTER_ES_WITH_DESCENDER					0x04AA
#define U_CYRILLIC_SMALL_LETTER_ES_WITH_DESCENDER					0x04AB
#define U_CYRILLIC_CAPITAL_LETTER_TE_WITH_DESCENDER					0x04AC
#define U_CYRILLIC_SMALL_LETTER_TE_WITH_DESCENDER					0x04AD
#define U_CYRILLIC_CAPITAL_LETTER_STRAIGHT_U						0x04AE
#define U_CYRILLIC_SMALL_LETTER_STRAIGHT_U						0x04AF
#define U_CYRILLIC_CAPITAL_LETTER_STRAIGHT_U_WITH_STROKE				0x04B0
#define U_CYRILLIC_SMALL_LETTER_STRAIGHT_U_WITH_STROKE					0x04B1
#define U_CYRILLIC_CAPITAL_LETTER_HA_WITH_DESCENDER					0x04B2
#define U_CYRILLIC_SMALL_LETTER_HA_WITH_DESCENDER					0x04B3
#define U_CYRILLIC_CAPITAL_LIGATURE_TE_TSE						0x04B4
#define U_CYRILLIC_SMALL_LIGATURE_TE_TSE						0x04B5
#define U_CYRILLIC_CAPITAL_LETTER_CHE_WITH_DESCENDER					0x04B6
#define U_CYRILLIC_SMALL_LETTER_CHE_WITH_DESCENDER					0x04B7
#define U_CYRILLIC_CAPITAL_LETTER_CHE_WITH_VERTICAL_STROKE				0x04B8
#define U_CYRILLIC_SMALL_LETTER_CHE_WITH_VERTICAL_STROKE				0x04B9
#define U_CYRILLIC_CAPITAL_LETTER_SHHA							0x04BA
#define U_CYRILLIC_SMALL_LETTER_SHHA							0x04BB
#define U_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE						0x04BC
#define U_CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE						0x04BD
#define U_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER				0x04BE
#define U_CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER				0x04BF
#define U_CYRILLIC_LETTER_PALOCHKA							0x04C0
#define U_CYRILLIC_CAPITAL_LETTER_ZHE_WITH_BREVE					0x04C1
#define U_CYRILLIC_SMALL_LETTER_ZHE_WITH_BREVE						0x04C2
#define U_CYRILLIC_CAPITAL_LETTER_KA_WITH_HOOK						0x04C3
#define U_CYRILLIC_SMALL_LETTER_KA_WITH_HOOK						0x04C4
#define U_CYRILLIC_CAPITAL_LETTER_EN_WITH_HOOK						0x04C7
#define U_CYRILLIC_SMALL_LETTER_EN_WITH_HOOK						0x04C8
#define U_CYRILLIC_CAPITAL_LETTER_KHAKASSIAN_CHE					0x04CB
#define U_CYRILLIC_SMALL_LETTER_KHAKASSIAN_CHE						0x04CC
#define U_CYRILLIC_CAPITAL_LETTER_A_WITH_BREVE						0x04D0
#define U_CYRILLIC_SMALL_LETTER_A_WITH_BREVE						0x04D1
#define U_CYRILLIC_CAPITAL_LETTER_A_WITH_DIAERESIS					0x04D2
#define U_CYRILLIC_SMALL_LETTER_A_WITH_DIAERESIS					0x04D3
#define U_CYRILLIC_CAPITAL_LIGATURE_A_IE						0x04D4
#define U_CYRILLIC_SMALL_LIGATURE_A_IE							0x04D5
#define U_CYRILLIC_CAPITAL_LETTER_IE_WITH_BREVE						0x04D6
#define U_CYRILLIC_SMALL_LETTER_IE_WITH_BREVE						0x04D7
#define U_CYRILLIC_CAPITAL_LETTER_SCHWA							0x04D8
#define U_CYRILLIC_SMALL_LETTER_SCHWA							0x04D9
#define U_CYRILLIC_CAPITAL_LETTER_SCHWA_WITH_DIAERESIS					0x04DA
#define U_CYRILLIC_SMALL_LETTER_SCHWA_WITH_DIAERESIS					0x04DB
#define U_CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DIAERESIS					0x04DC
#define U_CYRILLIC_SMALL_LETTER_ZHE_WITH_DIAERESIS					0x04DD
#define U_CYRILLIC_CAPITAL_LETTER_ZE_WITH_DIAERESIS					0x04DE
#define U_CYRILLIC_SMALL_LETTER_ZE_WITH_DIAERESIS					0x04DF
#define U_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_DZE						0x04E0
#define U_CYRILLIC_SMALL_LETTER_ABKHASIAN_DZE						0x04E1
#define U_CYRILLIC_CAPITAL_LETTER_I_WITH_MACRON						0x04E2
#define U_CYRILLIC_SMALL_LETTER_I_WITH_MACRON						0x04E3
#define U_CYRILLIC_CAPITAL_LETTER_I_WITH_DIAERESIS					0x04E4
#define U_CYRILLIC_SMALL_LETTER_I_WITH_DIAERESIS					0x04E5
#define U_CYRILLIC_CAPITAL_LETTER_O_WITH_DIAERESIS					0x04E6
#define U_CYRILLIC_SMALL_LETTER_O_WITH_DIAERESIS					0x04E7
#define U_CYRILLIC_CAPITAL_LETTER_BARRED_O						0x04E8
#define U_CYRILLIC_SMALL_LETTER_BARRED_O						0x04E9
#define U_CYRILLIC_CAPITAL_LETTER_BARRED_O_WITH_DIAERESIS				0x04EA
#define U_CYRILLIC_SMALL_LETTER_BARRED_O_WITH_DIAERESIS					0x04EB
#define U_CYRILLIC_CAPITAL_LETTER_U_WITH_MACRON						0x04EE
#define U_CYRILLIC_SMALL_LETTER_U_WITH_MACRON						0x04EF
#define U_CYRILLIC_CAPITAL_LETTER_U_WITH_DIAERESIS					0x04F0
#define U_CYRILLIC_SMALL_LETTER_U_WITH_DIAERESIS					0x04F1
#define U_CYRILLIC_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE					0x04F2
#define U_CYRILLIC_SMALL_LETTER_U_WITH_DOUBLE_ACUTE					0x04F3
#define U_CYRILLIC_CAPITAL_LETTER_CHE_WITH_DIAERESIS					0x04F4
#define U_CYRILLIC_SMALL_LETTER_CHE_WITH_DIAERESIS					0x04F5
#define U_CYRILLIC_CAPITAL_LETTER_YERU_WITH_DIAERESIS					0x04F8
#define U_CYRILLIC_SMALL_LETTER_YERU_WITH_DIAERESIS					0x04F9
#define U_ARMENIAN_CAPITAL_LETTER_AYB							0x0531
#define U_ARMENIAN_CAPITAL_LETTER_BEN							0x0532
#define U_ARMENIAN_CAPITAL_LETTER_GIM							0x0533
#define U_ARMENIAN_CAPITAL_LETTER_DA							0x0534
#define U_ARMENIAN_CAPITAL_LETTER_ECH							0x0535
#define U_ARMENIAN_CAPITAL_LETTER_ZA							0x0536
#define U_ARMENIAN_CAPITAL_LETTER_EH							0x0537
#define U_ARMENIAN_CAPITAL_LETTER_ET							0x0538
#define U_ARMENIAN_CAPITAL_LETTER_TO							0x0539
#define U_ARMENIAN_CAPITAL_LETTER_ZHE							0x053A
#define U_ARMENIAN_CAPITAL_LETTER_INI							0x053B
#define U_ARMENIAN_CAPITAL_LETTER_LIWN							0x053C
#define U_ARMENIAN_CAPITAL_LETTER_XEH							0x053D
#define U_ARMENIAN_CAPITAL_LETTER_CA							0x053E
#define U_ARMENIAN_CAPITAL_LETTER_KEN							0x053F
#define U_ARMENIAN_CAPITAL_LETTER_HO							0x0540
#define U_ARMENIAN_CAPITAL_LETTER_JA							0x0541
#define U_ARMENIAN_CAPITAL_LETTER_GHAD							0x0542
#define U_ARMENIAN_CAPITAL_LETTER_CHEH							0x0543
#define U_ARMENIAN_CAPITAL_LETTER_MEN							0x0544
#define U_ARMENIAN_CAPITAL_LETTER_YI							0x0545
#define U_ARMENIAN_CAPITAL_LETTER_NOW							0x0546
#define U_ARMENIAN_CAPITAL_LETTER_SHA							0x0547
#define U_ARMENIAN_CAPITAL_LETTER_VO							0x0548
#define U_ARMENIAN_CAPITAL_LETTER_CHA							0x0549
#define U_ARMENIAN_CAPITAL_LETTER_PEH							0x054A
#define U_ARMENIAN_CAPITAL_LETTER_JHEH							0x054B
#define U_ARMENIAN_CAPITAL_LETTER_RA							0x054C
#define U_ARMENIAN_CAPITAL_LETTER_SEH							0x054D
#define U_ARMENIAN_CAPITAL_LETTER_VEW							0x054E
#define U_ARMENIAN_CAPITAL_LETTER_TIWN							0x054F
#define U_ARMENIAN_CAPITAL_LETTER_REH							0x0550
#define U_ARMENIAN_CAPITAL_LETTER_CO							0x0551
#define U_ARMENIAN_CAPITAL_LETTER_YIWN							0x0552
#define U_ARMENIAN_CAPITAL_LETTER_PIWR							0x0553
#define U_ARMENIAN_CAPITAL_LETTER_KEH							0x0554
#define U_ARMENIAN_CAPITAL_LETTER_OH							0x0555
#define U_ARMENIAN_CAPITAL_LETTER_FEH							0x0556
#define U_ARMENIAN_MODIFIER_LETTER_LEFT_HALF_RING					0x0559
#define U_ARMENIAN_APOSTROPHE								0x055A
#define U_ARMENIAN_EMPHASIS_MARK							0x055B
#define U_ARMENIAN_EXCLAMATION_MARK							0x055C
#define U_ARMENIAN_COMMA								0x055D
#define U_ARMENIAN_QUESTION_MARK							0x055E
#define U_ARMENIAN_ABBREVIATION_MARK							0x055F
#define U_ARMENIAN_SMALL_LETTER_AYB							0x0561
#define U_ARMENIAN_SMALL_LETTER_BEN							0x0562
#define U_ARMENIAN_SMALL_LETTER_GIM							0x0563
#define U_ARMENIAN_SMALL_LETTER_DA							0x0564
#define U_ARMENIAN_SMALL_LETTER_ECH							0x0565
#define U_ARMENIAN_SMALL_LETTER_ZA							0x0566
#define U_ARMENIAN_SMALL_LETTER_EH							0x0567
#define U_ARMENIAN_SMALL_LETTER_ET							0x0568
#define U_ARMENIAN_SMALL_LETTER_TO							0x0569
#define U_ARMENIAN_SMALL_LETTER_ZHE							0x056A
#define U_ARMENIAN_SMALL_LETTER_INI							0x056B
#define U_ARMENIAN_SMALL_LETTER_LIWN							0x056C
#define U_ARMENIAN_SMALL_LETTER_XEH							0x056D
#define U_ARMENIAN_SMALL_LETTER_CA							0x056E
#define U_ARMENIAN_SMALL_LETTER_KEN							0x056F
#define U_ARMENIAN_SMALL_LETTER_HO							0x0570
#define U_ARMENIAN_SMALL_LETTER_JA							0x0571
#define U_ARMENIAN_SMALL_LETTER_GHAD							0x0572
#define U_ARMENIAN_SMALL_LETTER_CHEH							0x0573
#define U_ARMENIAN_SMALL_LETTER_MEN							0x0574
#define U_ARMENIAN_SMALL_LETTER_YI							0x0575
#define U_ARMENIAN_SMALL_LETTER_NOW							0x0576
#define U_ARMENIAN_SMALL_LETTER_SHA							0x0577
#define U_ARMENIAN_SMALL_LETTER_VO							0x0578
#define U_ARMENIAN_SMALL_LETTER_CHA							0x0579
#define U_ARMENIAN_SMALL_LETTER_PEH							0x057A
#define U_ARMENIAN_SMALL_LETTER_JHEH							0x057B
#define U_ARMENIAN_SMALL_LETTER_RA							0x057C
#define U_ARMENIAN_SMALL_LETTER_SEH							0x057D
#define U_ARMENIAN_SMALL_LETTER_VEW							0x057E
#define U_ARMENIAN_SMALL_LETTER_TIWN							0x057F
#define U_ARMENIAN_SMALL_LETTER_REH							0x0580
#define U_ARMENIAN_SMALL_LETTER_CO							0x0581
#define U_ARMENIAN_SMALL_LETTER_YIWN							0x0582
#define U_ARMENIAN_SMALL_LETTER_PIWR							0x0583
#define U_ARMENIAN_SMALL_LETTER_KEH							0x0584
#define U_ARMENIAN_SMALL_LETTER_OH							0x0585
#define U_ARMENIAN_SMALL_LETTER_FEH							0x0586
#define U_ARMENIAN_SMALL_LIGATURE_ECH_YIWN						0x0587
#define U_ARMENIAN_FULL_STOP								0x0589
#define U_HEBREW_ACCENT_ETNAHTA								0x0591
#define U_HEBREW_ACCENT_SEGOL								0x0592
#define U_HEBREW_ACCENT_SHALSHELET							0x0593
#define U_HEBREW_ACCENT_ZAQEF_QATAN							0x0594
#define U_HEBREW_ACCENT_ZAQEF_GADOL							0x0595
#define U_HEBREW_ACCENT_TIPEHA								0x0596
#define U_HEBREW_ACCENT_REVIA								0x0597
#define U_HEBREW_ACCENT_ZARQA								0x0598
#define U_HEBREW_ACCENT_PASHTA								0x0599
#define U_HEBREW_ACCENT_YETIV								0x059A
#define U_HEBREW_ACCENT_TEVIR								0x059B
#define U_HEBREW_ACCENT_GERESH								0x059C
#define U_HEBREW_ACCENT_GERESH_MUQDAM							0x059D
#define U_HEBREW_ACCENT_GERSHAYIM							0x059E
#define U_HEBREW_ACCENT_QARNEY_PARA							0x059F
#define U_HEBREW_ACCENT_TELISHA_GEDOLA							0x05A0
#define U_HEBREW_ACCENT_PAZER								0x05A1
#define U_HEBREW_ACCENT_MUNAH								0x05A3
#define U_HEBREW_ACCENT_MAHAPAKH							0x05A4
#define U_HEBREW_ACCENT_MERKHA								0x05A5
#define U_HEBREW_ACCENT_MERKHA_KEFULA							0x05A6
#define U_HEBREW_ACCENT_DARGA								0x05A7
#define U_HEBREW_ACCENT_QADMA								0x05A8
#define U_HEBREW_ACCENT_TELISHA_QETANA							0x05A9
#define U_HEBREW_ACCENT_YERAH_BEN_YOMO							0x05AA
#define U_HEBREW_ACCENT_OLE								0x05AB
#define U_HEBREW_ACCENT_ILUY								0x05AC
#define U_HEBREW_ACCENT_DEHI								0x05AD
#define U_HEBREW_ACCENT_ZINOR								0x05AE
#define U_HEBREW_MARK_MASORA_CIRCLE							0x05AF
#define U_HEBREW_POINT_SHEVA								0x05B0
#define U_HEBREW_POINT_HATAF_SEGOL							0x05B1
#define U_HEBREW_POINT_HATAF_PATAH							0x05B2
#define U_HEBREW_POINT_HATAF_QAMATS							0x05B3
#define U_HEBREW_POINT_HIRIQ								0x05B4
#define U_HEBREW_POINT_TSERE								0x05B5
#define U_HEBREW_POINT_SEGOL								0x05B6
#define U_HEBREW_POINT_PATAH								0x05B7
#define U_HEBREW_POINT_QAMATS								0x05B8
#define U_HEBREW_POINT_HOLAM								0x05B9
#define U_HEBREW_POINT_QUBUTS								0x05BB
#define U_HEBREW_POINT_DAGESH_OR_MAPIQ							0x05BC
#define U_HEBREW_POINT_METEG								0x05BD
#define U_HEBREW_PUNCTUATION_MAQAF							0x05BE
#define U_HEBREW_POINT_RAFE								0x05BF
#define U_HEBREW_PUNCTUATION_PASEQ							0x05C0
#define U_HEBREW_POINT_SHIN_DOT								0x05C1
#define U_HEBREW_POINT_SIN_DOT								0x05C2
#define U_HEBREW_PUNCTUATION_SOF_PASUQ							0x05C3
#define U_HEBREW_MARK_UPPER_DOT								0x05C4
#define U_HEBREW_LETTER_ALEF								0x05D0
#define U_HEBREW_LETTER_BET								0x05D1
#define U_HEBREW_LETTER_GIMEL								0x05D2
#define U_HEBREW_LETTER_DALET								0x05D3
#define U_HEBREW_LETTER_HE								0x05D4
#define U_HEBREW_LETTER_VAV								0x05D5
#define U_HEBREW_LETTER_ZAYIN								0x05D6
#define U_HEBREW_LETTER_HET								0x05D7
#define U_HEBREW_LETTER_TET								0x05D8
#define U_HEBREW_LETTER_YOD								0x05D9
#define U_HEBREW_LETTER_FINAL_KAF							0x05DA
#define U_HEBREW_LETTER_KAF								0x05DB
#define U_HEBREW_LETTER_LAMED								0x05DC
#define U_HEBREW_LETTER_FINAL_MEM							0x05DD
#define U_HEBREW_LETTER_MEM								0x05DE
#define U_HEBREW_LETTER_FINAL_NUN							0x05DF
#define U_HEBREW_LETTER_NUN								0x05E0
#define U_HEBREW_LETTER_SAMEKH								0x05E1
#define U_HEBREW_LETTER_AYIN								0x05E2
#define U_HEBREW_LETTER_FINAL_PE							0x05E3
#define U_HEBREW_LETTER_PE								0x05E4
#define U_HEBREW_LETTER_FINAL_TSADI							0x05E5
#define U_HEBREW_LETTER_TSADI								0x05E6
#define U_HEBREW_LETTER_QOF								0x05E7
#define U_HEBREW_LETTER_RESH								0x05E8
#define U_HEBREW_LETTER_SHIN								0x05E9
#define U_HEBREW_LETTER_TAV								0x05EA
#define U_HEBREW_LIGATURE_YIDDISH_DOUBLE_VAV						0x05F0
#define U_HEBREW_LIGATURE_YIDDISH_VAV_YOD						0x05F1
#define U_HEBREW_LIGATURE_YIDDISH_DOUBLE_YOD						0x05F2
#define U_HEBREW_PUNCTUATION_GERESH							0x05F3
#define U_HEBREW_PUNCTUATION_GERSHAYIM							0x05F4
#define U_ARABIC_COMMA									0x060C
#define U_ARABIC_SEMICOLON								0x061B
#define U_ARABIC_QUESTION_MARK								0x061F
#define U_ARABIC_LETTER_HAMZA								0x0621
#define U_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE						0x0622
#define U_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE						0x0623
#define U_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE						0x0624
#define U_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW						0x0625
#define U_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE						0x0626
#define U_ARABIC_LETTER_ALEF								0x0627
#define U_ARABIC_LETTER_BEH								0x0628
#define U_ARABIC_LETTER_TEH_MARBUTA							0x0629
#define U_ARABIC_LETTER_TEH								0x062A
#define U_ARABIC_LETTER_THEH								0x062B
#define U_ARABIC_LETTER_JEEM								0x062C
#define U_ARABIC_LETTER_HAH								0x062D
#define U_ARABIC_LETTER_KHAH								0x062E
#define U_ARABIC_LETTER_DAL								0x062F
#define U_ARABIC_LETTER_THAL								0x0630
#define U_ARABIC_LETTER_REH								0x0631
#define U_ARABIC_LETTER_ZAIN								0x0632
#define U_ARABIC_LETTER_SEEN								0x0633
#define U_ARABIC_LETTER_SHEEN								0x0634
#define U_ARABIC_LETTER_SAD								0x0635
#define U_ARABIC_LETTER_DAD								0x0636
#define U_ARABIC_LETTER_TAH								0x0637
#define U_ARABIC_LETTER_ZAH								0x0638
#define U_ARABIC_LETTER_AIN								0x0639
#define U_ARABIC_LETTER_GHAIN								0x063A
#define U_ARABIC_TATWEEL								0x0640
#define U_ARABIC_LETTER_FEH								0x0641
#define U_ARABIC_LETTER_QAF								0x0642
#define U_ARABIC_LETTER_KAF								0x0643
#define U_ARABIC_LETTER_LAM								0x0644
#define U_ARABIC_LETTER_MEEM								0x0645
#define U_ARABIC_LETTER_NOON								0x0646
#define U_ARABIC_LETTER_HEH								0x0647
#define U_ARABIC_LETTER_WAW								0x0648
#define U_ARABIC_LETTER_ALEF_MAKSURA							0x0649
#define U_ARABIC_LETTER_YEH								0x064A
#define U_ARABIC_FATHATAN								0x064B
#define U_ARABIC_DAMMATAN								0x064C
#define U_ARABIC_KASRATAN								0x064D
#define U_ARABIC_FATHA									0x064E
#define U_ARABIC_DAMMA									0x064F
#define U_ARABIC_KASRA									0x0650
#define U_ARABIC_SHADDA									0x0651
#define U_ARABIC_SUKUN									0x0652
#define U_ARABIC_INDIC_DIGIT_ZERO							0x0660
#define U_ARABIC_INDIC_DIGIT_ONE							0x0661
#define U_ARABIC_INDIC_DIGIT_TWO							0x0662
#define U_ARABIC_INDIC_DIGIT_THREE							0x0663
#define U_ARABIC_INDIC_DIGIT_FOUR							0x0664
#define U_ARABIC_INDIC_DIGIT_FIVE							0x0665
#define U_ARABIC_INDIC_DIGIT_SIX							0x0666
#define U_ARABIC_INDIC_DIGIT_SEVEN							0x0667
#define U_ARABIC_INDIC_DIGIT_EIGHT							0x0668
#define U_ARABIC_INDIC_DIGIT_NINE							0x0669
#define U_ARABIC_PERCENT_SIGN								0x066A
#define U_ARABIC_DECIMAL_SEPARATOR							0x066B
#define U_ARABIC_THOUSANDS_SEPARATOR							0x066C
#define U_ARABIC_FIVE_POINTED_STAR							0x066D
#define U_ARABIC_LETTER_SUPERSCRIPT_ALEF						0x0670
#define U_ARABIC_LETTER_ALEF_WASLA							0x0671
#define U_ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_ABOVE					0x0672
#define U_ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_BELOW					0x0673
#define U_ARABIC_LETTER_HIGH_HAMZA							0x0674
#define U_ARABIC_LETTER_HIGH_HAMZA_ALEF							0x0675
#define U_ARABIC_LETTER_HIGH_HAMZA_WAW							0x0676
#define U_ARABIC_LETTER_U_WITH_HAMZA_ABOVE						0x0677
#define U_ARABIC_LETTER_HIGH_HAMZA_YEH							0x0678
#define U_ARABIC_LETTER_TTEH								0x0679
#define U_ARABIC_LETTER_TTEHEH								0x067A
#define U_ARABIC_LETTER_BEEH								0x067B
#define U_ARABIC_LETTER_TEH_WITH_RING							0x067C
#define U_ARABIC_LETTER_TEH_WITH_THREE_DOTS_ABOVE_DOWNWARDS				0x067D
#define U_ARABIC_LETTER_PEH								0x067E
#define U_ARABIC_LETTER_TEHEH								0x067F
#define U_ARABIC_LETTER_BEHEH								0x0680
#define U_ARABIC_LETTER_HAH_WITH_HAMZA_ABOVE						0x0681
#define U_ARABIC_LETTER_HAH_WITH_TWO_DOTS_VERTICAL_ABOVE				0x0682
#define U_ARABIC_LETTER_NYEH								0x0683
#define U_ARABIC_LETTER_DYEH								0x0684
#define U_ARABIC_LETTER_HAH_WITH_THREE_DOTS_ABOVE					0x0685
#define U_ARABIC_LETTER_TCHEH								0x0686
#define U_ARABIC_LETTER_TCHEHEH								0x0687
#define U_ARABIC_LETTER_DDAL								0x0688
#define U_ARABIC_LETTER_DAL_WITH_RING							0x0689
#define U_ARABIC_LETTER_DAL_WITH_DOT_BELOW						0x068A
#define U_ARABIC_LETTER_DAL_WITH_DOT_BELOW_AND_SMALL_TAH				0x068B
#define U_ARABIC_LETTER_DAHAL								0x068C
#define U_ARABIC_LETTER_DDAHAL								0x068D
#define U_ARABIC_LETTER_DUL								0x068E
#define U_ARABIC_LETTER_DAL_WITH_THREE_DOTS_ABOVE_DOWNWARDS				0x068F
#define U_ARABIC_LETTER_DAL_WITH_FOUR_DOTS_ABOVE					0x0690
#define U_ARABIC_LETTER_RREH								0x0691
#define U_ARABIC_LETTER_REH_WITH_SMALL_V						0x0692
#define U_ARABIC_LETTER_REH_WITH_RING							0x0693
#define U_ARABIC_LETTER_REH_WITH_DOT_BELOW						0x0694
#define U_ARABIC_LETTER_REH_WITH_SMALL_V_BELOW						0x0695
#define U_ARABIC_LETTER_REH_WITH_DOT_BELOW_AND_DOT_ABOVE				0x0696
#define U_ARABIC_LETTER_REH_WITH_TWO_DOTS_ABOVE						0x0697
#define U_ARABIC_LETTER_JEH								0x0698
#define U_ARABIC_LETTER_REH_WITH_FOUR_DOTS_ABOVE					0x0699
#define U_ARABIC_LETTER_SEEN_WITH_DOT_BELOW_AND_DOT_ABOVE				0x069A
#define U_ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW					0x069B
#define U_ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW_AND_THREE_DOTS_ABOVE			0x069C
#define U_ARABIC_LETTER_SAD_WITH_TWO_DOTS_BELOW						0x069D
#define U_ARABIC_LETTER_SAD_WITH_THREE_DOTS_ABOVE					0x069E
#define U_ARABIC_LETTER_TAH_WITH_THREE_DOTS_ABOVE					0x069F
#define U_ARABIC_LETTER_AIN_WITH_THREE_DOTS_ABOVE					0x06A0
#define U_ARABIC_LETTER_DOTLESS_FEH							0x06A1
#define U_ARABIC_LETTER_FEH_WITH_DOT_MOVED_BELOW					0x06A2
#define U_ARABIC_LETTER_FEH_WITH_DOT_BELOW						0x06A3
#define U_ARABIC_LETTER_VEH								0x06A4
#define U_ARABIC_LETTER_FEH_WITH_THREE_DOTS_BELOW					0x06A5
#define U_ARABIC_LETTER_PEHEH								0x06A6
#define U_ARABIC_LETTER_QAF_WITH_DOT_ABOVE						0x06A7
#define U_ARABIC_LETTER_QAF_WITH_THREE_DOTS_ABOVE					0x06A8
#define U_ARABIC_LETTER_KEHEH								0x06A9
#define U_ARABIC_LETTER_SWASH_KAF							0x06AA
#define U_ARABIC_LETTER_KAF_WITH_RING							0x06AB
#define U_ARABIC_LETTER_KAF_WITH_DOT_ABOVE						0x06AC
#define U_ARABIC_LETTER_NG								0x06AD
#define U_ARABIC_LETTER_KAF_WITH_THREE_DOTS_BELOW					0x06AE
#define U_ARABIC_LETTER_GAF								0x06AF
#define U_ARABIC_LETTER_GAF_WITH_RING							0x06B0
#define U_ARABIC_LETTER_NGOEH								0x06B1
#define U_ARABIC_LETTER_GAF_WITH_TWO_DOTS_BELOW						0x06B2
#define U_ARABIC_LETTER_GUEH								0x06B3
#define U_ARABIC_LETTER_GAF_WITH_THREE_DOTS_ABOVE					0x06B4
#define U_ARABIC_LETTER_LAM_WITH_SMALL_V						0x06B5
#define U_ARABIC_LETTER_LAM_WITH_DOT_ABOVE						0x06B6
#define U_ARABIC_LETTER_LAM_WITH_THREE_DOTS_ABOVE					0x06B7
#define U_ARABIC_LETTER_NOON_GHUNNA							0x06BA
#define U_ARABIC_LETTER_RNOON								0x06BB
#define U_ARABIC_LETTER_NOON_WITH_RING							0x06BC
#define U_ARABIC_LETTER_NOON_WITH_THREE_DOTS_ABOVE					0x06BD
#define U_ARABIC_LETTER_HEH_DOACHASHMEE							0x06BE
#define U_ARABIC_LETTER_HEH_WITH_YEH_ABOVE						0x06C0
#define U_ARABIC_LETTER_HEH_GOAL							0x06C1
#define U_ARABIC_LETTER_HEH_GOAL_WITH_HAMZA_ABOVE					0x06C2
#define U_ARABIC_LETTER_TEH_MARBUTA_GOAL						0x06C3
#define U_ARABIC_LETTER_WAW_WITH_RING							0x06C4
#define U_ARABIC_LETTER_KIRGHIZ_OE							0x06C5
#define U_ARABIC_LETTER_OE								0x06C6
#define U_ARABIC_LETTER_U								0x06C7
#define U_ARABIC_LETTER_YU								0x06C8
#define U_ARABIC_LETTER_KIRGHIZ_YU							0x06C9
#define U_ARABIC_LETTER_WAW_WITH_TWO_DOTS_ABOVE						0x06CA
#define U_ARABIC_LETTER_VE								0x06CB
#define U_ARABIC_LETTER_FARSI_YEH							0x06CC
#define U_ARABIC_LETTER_YEH_WITH_TAIL							0x06CD
#define U_ARABIC_LETTER_YEH_WITH_SMALL_V						0x06CE
#define U_ARABIC_LETTER_E								0x06D0
#define U_ARABIC_LETTER_YEH_WITH_THREE_DOTS_BELOW					0x06D1
#define U_ARABIC_LETTER_YEH_BARREE							0x06D2
#define U_ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE					0x06D3
#define U_ARABIC_FULL_STOP								0x06D4
#define U_ARABIC_LETTER_AE								0x06D5
#define U_ARABIC_SMALL_HIGH_LIGATURE_SAD_WITH_LAM_WITH_ALEF_MAKSURA			0x06D6
#define U_ARABIC_SMALL_HIGH_LIGATURE_QAF_WITH_LAM_WITH_ALEF_MAKSURA			0x06D7
#define U_ARABIC_SMALL_HIGH_MEEM_INITIAL_FORM						0x06D8
#define U_ARABIC_SMALL_HIGH_LAM_ALEF							0x06D9
#define U_ARABIC_SMALL_HIGH_JEEM							0x06DA
#define U_ARABIC_SMALL_HIGH_THREE_DOTS							0x06DB
#define U_ARABIC_SMALL_HIGH_SEEN							0x06DC
#define U_ARABIC_END_OF_AYAH								0x06DD
#define U_ARABIC_START_OF_RUB_EL_HIZB							0x06DE
#define U_ARABIC_SMALL_HIGH_ROUNDED_ZERO						0x06DF
#define U_ARABIC_SMALL_HIGH_UPRIGHT_RECTANGULAR_ZERO					0x06E0
#define U_ARABIC_SMALL_HIGH_DOTLESS_HEAD_OF_KHAH					0x06E1
#define U_ARABIC_SMALL_HIGH_MEEM_ISOLATED_FORM						0x06E2
#define U_ARABIC_SMALL_LOW_SEEN								0x06E3
#define U_ARABIC_SMALL_HIGH_MADDA							0x06E4
#define U_ARABIC_SMALL_WAW								0x06E5
#define U_ARABIC_SMALL_YEH								0x06E6
#define U_ARABIC_SMALL_HIGH_YEH								0x06E7
#define U_ARABIC_SMALL_HIGH_NOON							0x06E8
#define U_ARABIC_PLACE_OF_SAJDAH							0x06E9
#define U_ARABIC_EMPTY_CENTRE_LOW_STOP							0x06EA
#define U_ARABIC_EMPTY_CENTRE_HIGH_STOP							0x06EB
#define U_ARABIC_ROUNDED_HIGH_STOP_WITH_FILLED_CENTRE					0x06EC
#define U_ARABIC_SMALL_LOW_MEEM								0x06ED
#define U_EXTENDED_ARABIC_INDIC_DIGIT_ZERO						0x06F0
#define U_EXTENDED_ARABIC_INDIC_DIGIT_ONE						0x06F1
#define U_EXTENDED_ARABIC_INDIC_DIGIT_TWO						0x06F2
#define U_EXTENDED_ARABIC_INDIC_DIGIT_THREE						0x06F3
#define U_EXTENDED_ARABIC_INDIC_DIGIT_FOUR						0x06F4
#define U_EXTENDED_ARABIC_INDIC_DIGIT_FIVE						0x06F5
#define U_EXTENDED_ARABIC_INDIC_DIGIT_SIX						0x06F6
#define U_EXTENDED_ARABIC_INDIC_DIGIT_SEVEN						0x06F7
#define U_EXTENDED_ARABIC_INDIC_DIGIT_EIGHT						0x06F8
#define U_EXTENDED_ARABIC_INDIC_DIGIT_NINE						0x06F9
#define U_DEVANAGARI_SIGN_CANDRABINDU							0x0901
#define U_DEVANAGARI_SIGN_ANUSVARA							0x0902
#define U_DEVANAGARI_SIGN_VISARGA							0x0903
#define U_DEVANAGARI_LETTER_A								0x0905
#define U_DEVANAGARI_LETTER_AA								0x0906
#define U_DEVANAGARI_LETTER_I								0x0907
#define U_DEVANAGARI_LETTER_II								0x0908
#define U_DEVANAGARI_LETTER_U								0x0909
#define U_DEVANAGARI_LETTER_UU								0x090A
#define U_DEVANAGARI_LETTER_VOCALIC_R							0x090B
#define U_DEVANAGARI_LETTER_VOCALIC_L							0x090C
#define U_DEVANAGARI_LETTER_CANDRA_E							0x090D
#define U_DEVANAGARI_LETTER_SHORT_E							0x090E
#define U_DEVANAGARI_LETTER_E								0x090F
#define U_DEVANAGARI_LETTER_AI								0x0910
#define U_DEVANAGARI_LETTER_CANDRA_O							0x0911
#define U_DEVANAGARI_LETTER_SHORT_O							0x0912
#define U_DEVANAGARI_LETTER_O								0x0913
#define U_DEVANAGARI_LETTER_AU								0x0914
#define U_DEVANAGARI_LETTER_KA								0x0915
#define U_DEVANAGARI_LETTER_KHA								0x0916
#define U_DEVANAGARI_LETTER_GA								0x0917
#define U_DEVANAGARI_LETTER_GHA								0x0918
#define U_DEVANAGARI_LETTER_NGA								0x0919
#define U_DEVANAGARI_LETTER_CA								0x091A
#define U_DEVANAGARI_LETTER_CHA								0x091B
#define U_DEVANAGARI_LETTER_JA								0x091C
#define U_DEVANAGARI_LETTER_JHA								0x091D
#define U_DEVANAGARI_LETTER_NYA								0x091E
#define U_DEVANAGARI_LETTER_TTA								0x091F
#define U_DEVANAGARI_LETTER_TTHA							0x0920
#define U_DEVANAGARI_LETTER_DDA								0x0921
#define U_DEVANAGARI_LETTER_DDHA							0x0922
#define U_DEVANAGARI_LETTER_NNA								0x0923
#define U_DEVANAGARI_LETTER_TA								0x0924
#define U_DEVANAGARI_LETTER_THA								0x0925
#define U_DEVANAGARI_LETTER_DA								0x0926
#define U_DEVANAGARI_LETTER_DHA								0x0927
#define U_DEVANAGARI_LETTER_NA								0x0928
#define U_DEVANAGARI_LETTER_NNNA							0x0929
#define U_DEVANAGARI_LETTER_PA								0x092A
#define U_DEVANAGARI_LETTER_PHA								0x092B
#define U_DEVANAGARI_LETTER_BA								0x092C
#define U_DEVANAGARI_LETTER_BHA								0x092D
#define U_DEVANAGARI_LETTER_MA								0x092E
#define U_DEVANAGARI_LETTER_YA								0x092F
#define U_DEVANAGARI_LETTER_RA								0x0930
#define U_DEVANAGARI_LETTER_RRA								0x0931
#define U_DEVANAGARI_LETTER_LA								0x0932
#define U_DEVANAGARI_LETTER_LLA								0x0933
#define U_DEVANAGARI_LETTER_LLLA							0x0934
#define U_DEVANAGARI_LETTER_VA								0x0935
#define U_DEVANAGARI_LETTER_SHA								0x0936
#define U_DEVANAGARI_LETTER_SSA								0x0937
#define U_DEVANAGARI_LETTER_SA								0x0938
#define U_DEVANAGARI_LETTER_HA								0x0939
#define U_DEVANAGARI_SIGN_NUKTA								0x093C
#define U_DEVANAGARI_SIGN_AVAGRAHA							0x093D
#define U_DEVANAGARI_VOWEL_SIGN_AA							0x093E
#define U_DEVANAGARI_VOWEL_SIGN_I							0x093F
#define U_DEVANAGARI_VOWEL_SIGN_II							0x0940
#define U_DEVANAGARI_VOWEL_SIGN_U							0x0941
#define U_DEVANAGARI_VOWEL_SIGN_UU							0x0942
#define U_DEVANAGARI_VOWEL_SIGN_VOCALIC_R						0x0943
#define U_DEVANAGARI_VOWEL_SIGN_VOCALIC_RR						0x0944
#define U_DEVANAGARI_VOWEL_SIGN_CANDRA_E						0x0945
#define U_DEVANAGARI_VOWEL_SIGN_SHORT_E							0x0946
#define U_DEVANAGARI_VOWEL_SIGN_E							0x0947
#define U_DEVANAGARI_VOWEL_SIGN_AI							0x0948
#define U_DEVANAGARI_VOWEL_SIGN_CANDRA_O						0x0949
#define U_DEVANAGARI_VOWEL_SIGN_SHORT_O							0x094A
#define U_DEVANAGARI_VOWEL_SIGN_O							0x094B
#define U_DEVANAGARI_VOWEL_SIGN_AU							0x094C
#define U_DEVANAGARI_SIGN_VIRAMA							0x094D
#define U_DEVANAGARI_OM									0x0950
#define U_DEVANAGARI_STRESS_SIGN_UDATTA							0x0951
#define U_DEVANAGARI_STRESS_SIGN_ANUDATTA						0x0952
#define U_DEVANAGARI_GRAVE_ACCENT							0x0953
#define U_DEVANAGARI_ACUTE_ACCENT							0x0954
#define U_DEVANAGARI_LETTER_QA								0x0958
#define U_DEVANAGARI_LETTER_KHHA							0x0959
#define U_DEVANAGARI_LETTER_GHHA							0x095A
#define U_DEVANAGARI_LETTER_ZA								0x095B
#define U_DEVANAGARI_LETTER_DDDHA							0x095C
#define U_DEVANAGARI_LETTER_RHA								0x095D
#define U_DEVANAGARI_LETTER_FA								0x095E
#define U_DEVANAGARI_LETTER_YYA								0x095F
#define U_DEVANAGARI_LETTER_VOCALIC_RR							0x0960
#define U_DEVANAGARI_LETTER_VOCALIC_LL							0x0961
#define U_DEVANAGARI_VOWEL_SIGN_VOCALIC_L						0x0962
#define U_DEVANAGARI_VOWEL_SIGN_VOCALIC_LL						0x0963
#define U_DEVANAGARI_DANDA								0x0964
#define U_DEVANAGARI_DOUBLE_DANDA							0x0965
#define U_DEVANAGARI_DIGIT_ZERO								0x0966
#define U_DEVANAGARI_DIGIT_ONE								0x0967
#define U_DEVANAGARI_DIGIT_TWO								0x0968
#define U_DEVANAGARI_DIGIT_THREE							0x0969
#define U_DEVANAGARI_DIGIT_FOUR								0x096A
#define U_DEVANAGARI_DIGIT_FIVE								0x096B
#define U_DEVANAGARI_DIGIT_SIX								0x096C
#define U_DEVANAGARI_DIGIT_SEVEN							0x096D
#define U_DEVANAGARI_DIGIT_EIGHT							0x096E
#define U_DEVANAGARI_DIGIT_NINE								0x096F
#define U_DEVANAGARI_ABBREVIATION_SIGN							0x0970
#define U_BENGALI_SIGN_CANDRABINDU							0x0981
#define U_BENGALI_SIGN_ANUSVARA								0x0982
#define U_BENGALI_SIGN_VISARGA								0x0983
#define U_BENGALI_LETTER_A								0x0985
#define U_BENGALI_LETTER_AA								0x0986
#define U_BENGALI_LETTER_I								0x0987
#define U_BENGALI_LETTER_II								0x0988
#define U_BENGALI_LETTER_U								0x0989
#define U_BENGALI_LETTER_UU								0x098A
#define U_BENGALI_LETTER_VOCALIC_R							0x098B
#define U_BENGALI_LETTER_VOCALIC_L							0x098C
#define U_BENGALI_LETTER_E								0x098F
#define U_BENGALI_LETTER_AI								0x0990
#define U_BENGALI_LETTER_O								0x0993
#define U_BENGALI_LETTER_AU								0x0994
#define U_BENGALI_LETTER_KA								0x0995
#define U_BENGALI_LETTER_KHA								0x0996
#define U_BENGALI_LETTER_GA								0x0997
#define U_BENGALI_LETTER_GHA								0x0998
#define U_BENGALI_LETTER_NGA								0x0999
#define U_BENGALI_LETTER_CA								0x099A
#define U_BENGALI_LETTER_CHA								0x099B
#define U_BENGALI_LETTER_JA								0x099C
#define U_BENGALI_LETTER_JHA								0x099D
#define U_BENGALI_LETTER_NYA								0x099E
#define U_BENGALI_LETTER_TTA								0x099F
#define U_BENGALI_LETTER_TTHA								0x09A0
#define U_BENGALI_LETTER_DDA								0x09A1
#define U_BENGALI_LETTER_DDHA								0x09A2
#define U_BENGALI_LETTER_NNA								0x09A3
#define U_BENGALI_LETTER_TA								0x09A4
#define U_BENGALI_LETTER_THA								0x09A5
#define U_BENGALI_LETTER_DA								0x09A6
#define U_BENGALI_LETTER_DHA								0x09A7
#define U_BENGALI_LETTER_NA								0x09A8
#define U_BENGALI_LETTER_PA								0x09AA
#define U_BENGALI_LETTER_PHA								0x09AB
#define U_BENGALI_LETTER_BA								0x09AC
#define U_BENGALI_LETTER_BHA								0x09AD
#define U_BENGALI_LETTER_MA								0x09AE
#define U_BENGALI_LETTER_YA								0x09AF
#define U_BENGALI_LETTER_RA								0x09B0
#define U_BENGALI_LETTER_LA								0x09B2
#define U_BENGALI_LETTER_SHA								0x09B6
#define U_BENGALI_LETTER_SSA								0x09B7
#define U_BENGALI_LETTER_SA								0x09B8
#define U_BENGALI_LETTER_HA								0x09B9
#define U_BENGALI_SIGN_NUKTA								0x09BC
#define U_BENGALI_VOWEL_SIGN_AA								0x09BE
#define U_BENGALI_VOWEL_SIGN_I								0x09BF
#define U_BENGALI_VOWEL_SIGN_II								0x09C0
#define U_BENGALI_VOWEL_SIGN_U								0x09C1
#define U_BENGALI_VOWEL_SIGN_UU								0x09C2
#define U_BENGALI_VOWEL_SIGN_VOCALIC_R							0x09C3
#define U_BENGALI_VOWEL_SIGN_VOCALIC_RR							0x09C4
#define U_BENGALI_VOWEL_SIGN_E								0x09C7
#define U_BENGALI_VOWEL_SIGN_AI								0x09C8
#define U_BENGALI_VOWEL_SIGN_O								0x09CB
#define U_BENGALI_VOWEL_SIGN_AU								0x09CC
#define U_BENGALI_SIGN_VIRAMA								0x09CD
#define U_BENGALI_AU_LENGTH_MARK							0x09D7
#define U_BENGALI_LETTER_RRA								0x09DC
#define U_BENGALI_LETTER_RHA								0x09DD
#define U_BENGALI_LETTER_YYA								0x09DF
#define U_BENGALI_LETTER_VOCALIC_RR							0x09E0
#define U_BENGALI_LETTER_VOCALIC_LL							0x09E1
#define U_BENGALI_VOWEL_SIGN_VOCALIC_L							0x09E2
#define U_BENGALI_VOWEL_SIGN_VOCALIC_LL							0x09E3
#define U_BENGALI_DIGIT_ZERO								0x09E6
#define U_BENGALI_DIGIT_ONE								0x09E7
#define U_BENGALI_DIGIT_TWO								0x09E8
#define U_BENGALI_DIGIT_THREE								0x09E9
#define U_BENGALI_DIGIT_FOUR								0x09EA
#define U_BENGALI_DIGIT_FIVE								0x09EB
#define U_BENGALI_DIGIT_SIX								0x09EC
#define U_BENGALI_DIGIT_SEVEN								0x09ED
#define U_BENGALI_DIGIT_EIGHT								0x09EE
#define U_BENGALI_DIGIT_NINE								0x09EF
#define U_BENGALI_LETTER_RA_WITH_MIDDLE_DIAGONAL					0x09F0
#define U_BENGALI_LETTER_RA_WITH_LOWER_DIAGONAL						0x09F1
#define U_BENGALI_RUPEE_MARK								0x09F2
#define U_BENGALI_RUPEE_SIGN								0x09F3
#define U_BENGALI_CURRENCY_NUMERATOR_ONE						0x09F4
#define U_BENGALI_CURRENCY_NUMERATOR_TWO						0x09F5
#define U_BENGALI_CURRENCY_NUMERATOR_THREE						0x09F6
#define U_BENGALI_CURRENCY_NUMERATOR_FOUR						0x09F7
#define U_BENGALI_CURRENCY_NUMERATOR_ONE_LESS_THAN_THE_DENOMINATOR			0x09F8
#define U_BENGALI_CURRENCY_DENOMINATOR_SIXTEEN						0x09F9
#define U_BENGALI_ISSHAR								0x09FA
#define U_GURMUKHI_SIGN_BINDI								0x0A02
#define U_GURMUKHI_LETTER_A								0x0A05
#define U_GURMUKHI_LETTER_AA								0x0A06
#define U_GURMUKHI_LETTER_I								0x0A07
#define U_GURMUKHI_LETTER_II								0x0A08
#define U_GURMUKHI_LETTER_U								0x0A09
#define U_GURMUKHI_LETTER_UU								0x0A0A
#define U_GURMUKHI_LETTER_EE								0x0A0F
#define U_GURMUKHI_LETTER_AI								0x0A10
#define U_GURMUKHI_LETTER_OO								0x0A13
#define U_GURMUKHI_LETTER_AU								0x0A14
#define U_GURMUKHI_LETTER_KA								0x0A15
#define U_GURMUKHI_LETTER_KHA								0x0A16
#define U_GURMUKHI_LETTER_GA								0x0A17
#define U_GURMUKHI_LETTER_GHA								0x0A18
#define U_GURMUKHI_LETTER_NGA								0x0A19
#define U_GURMUKHI_LETTER_CA								0x0A1A
#define U_GURMUKHI_LETTER_CHA								0x0A1B
#define U_GURMUKHI_LETTER_JA								0x0A1C
#define U_GURMUKHI_LETTER_JHA								0x0A1D
#define U_GURMUKHI_LETTER_NYA								0x0A1E
#define U_GURMUKHI_LETTER_TTA								0x0A1F
#define U_GURMUKHI_LETTER_TTHA								0x0A20
#define U_GURMUKHI_LETTER_DDA								0x0A21
#define U_GURMUKHI_LETTER_DDHA								0x0A22
#define U_GURMUKHI_LETTER_NNA								0x0A23
#define U_GURMUKHI_LETTER_TA								0x0A24
#define U_GURMUKHI_LETTER_THA								0x0A25
#define U_GURMUKHI_LETTER_DA								0x0A26
#define U_GURMUKHI_LETTER_DHA								0x0A27
#define U_GURMUKHI_LETTER_NA								0x0A28
#define U_GURMUKHI_LETTER_PA								0x0A2A
#define U_GURMUKHI_LETTER_PHA								0x0A2B
#define U_GURMUKHI_LETTER_BA								0x0A2C
#define U_GURMUKHI_LETTER_BHA								0x0A2D
#define U_GURMUKHI_LETTER_MA								0x0A2E
#define U_GURMUKHI_LETTER_YA								0x0A2F
#define U_GURMUKHI_LETTER_RA								0x0A30
#define U_GURMUKHI_LETTER_LA								0x0A32
#define U_GURMUKHI_LETTER_LLA								0x0A33
#define U_GURMUKHI_LETTER_VA								0x0A35
#define U_GURMUKHI_LETTER_SHA								0x0A36
#define U_GURMUKHI_LETTER_SA								0x0A38
#define U_GURMUKHI_LETTER_HA								0x0A39
#define U_GURMUKHI_SIGN_NUKTA								0x0A3C
#define U_GURMUKHI_VOWEL_SIGN_AA							0x0A3E
#define U_GURMUKHI_VOWEL_SIGN_I								0x0A3F
#define U_GURMUKHI_VOWEL_SIGN_II							0x0A40
#define U_GURMUKHI_VOWEL_SIGN_U								0x0A41
#define U_GURMUKHI_VOWEL_SIGN_UU							0x0A42
#define U_GURMUKHI_VOWEL_SIGN_EE							0x0A47
#define U_GURMUKHI_VOWEL_SIGN_AI							0x0A48
#define U_GURMUKHI_VOWEL_SIGN_OO							0x0A4B
#define U_GURMUKHI_VOWEL_SIGN_AU							0x0A4C
#define U_GURMUKHI_SIGN_VIRAMA								0x0A4D
#define U_GURMUKHI_LETTER_KHHA								0x0A59
#define U_GURMUKHI_LETTER_GHHA								0x0A5A
#define U_GURMUKHI_LETTER_ZA								0x0A5B
#define U_GURMUKHI_LETTER_RRA								0x0A5C
#define U_GURMUKHI_LETTER_FA								0x0A5E
#define U_GURMUKHI_DIGIT_ZERO								0x0A66
#define U_GURMUKHI_DIGIT_ONE								0x0A67
#define U_GURMUKHI_DIGIT_TWO								0x0A68
#define U_GURMUKHI_DIGIT_THREE								0x0A69
#define U_GURMUKHI_DIGIT_FOUR								0x0A6A
#define U_GURMUKHI_DIGIT_FIVE								0x0A6B
#define U_GURMUKHI_DIGIT_SIX								0x0A6C
#define U_GURMUKHI_DIGIT_SEVEN								0x0A6D
#define U_GURMUKHI_DIGIT_EIGHT								0x0A6E
#define U_GURMUKHI_DIGIT_NINE								0x0A6F
#define U_GURMUKHI_TIPPI								0x0A70
#define U_GURMUKHI_ADDAK								0x0A71
#define U_GURMUKHI_IRI									0x0A72
#define U_GURMUKHI_URA									0x0A73
#define U_GURMUKHI_EK_ONKAR								0x0A74
#define U_GUJARATI_SIGN_CANDRABINDU							0x0A81
#define U_GUJARATI_SIGN_ANUSVARA							0x0A82
#define U_GUJARATI_SIGN_VISARGA								0x0A83
#define U_GUJARATI_LETTER_A								0x0A85
#define U_GUJARATI_LETTER_AA								0x0A86
#define U_GUJARATI_LETTER_I								0x0A87
#define U_GUJARATI_LETTER_II								0x0A88
#define U_GUJARATI_LETTER_U								0x0A89
#define U_GUJARATI_LETTER_UU								0x0A8A
#define U_GUJARATI_LETTER_VOCALIC_R							0x0A8B
#define U_GUJARATI_VOWEL_CANDRA_E							0x0A8D
#define U_GUJARATI_LETTER_E								0x0A8F
#define U_GUJARATI_LETTER_AI								0x0A90
#define U_GUJARATI_VOWEL_CANDRA_O							0x0A91
#define U_GUJARATI_LETTER_O								0x0A93
#define U_GUJARATI_LETTER_AU								0x0A94
#define U_GUJARATI_LETTER_KA								0x0A95
#define U_GUJARATI_LETTER_KHA								0x0A96
#define U_GUJARATI_LETTER_GA								0x0A97
#define U_GUJARATI_LETTER_GHA								0x0A98
#define U_GUJARATI_LETTER_NGA								0x0A99
#define U_GUJARATI_LETTER_CA								0x0A9A
#define U_GUJARATI_LETTER_CHA								0x0A9B
#define U_GUJARATI_LETTER_JA								0x0A9C
#define U_GUJARATI_LETTER_JHA								0x0A9D
#define U_GUJARATI_LETTER_NYA								0x0A9E
#define U_GUJARATI_LETTER_TTA								0x0A9F
#define U_GUJARATI_LETTER_TTHA								0x0AA0
#define U_GUJARATI_LETTER_DDA								0x0AA1
#define U_GUJARATI_LETTER_DDHA								0x0AA2
#define U_GUJARATI_LETTER_NNA								0x0AA3
#define U_GUJARATI_LETTER_TA								0x0AA4
#define U_GUJARATI_LETTER_THA								0x0AA5
#define U_GUJARATI_LETTER_DA								0x0AA6
#define U_GUJARATI_LETTER_DHA								0x0AA7
#define U_GUJARATI_LETTER_NA								0x0AA8
#define U_GUJARATI_LETTER_PA								0x0AAA
#define U_GUJARATI_LETTER_PHA								0x0AAB
#define U_GUJARATI_LETTER_BA								0x0AAC
#define U_GUJARATI_LETTER_BHA								0x0AAD
#define U_GUJARATI_LETTER_MA								0x0AAE
#define U_GUJARATI_LETTER_YA								0x0AAF
#define U_GUJARATI_LETTER_RA								0x0AB0
#define U_GUJARATI_LETTER_LA								0x0AB2
#define U_GUJARATI_LETTER_LLA								0x0AB3
#define U_GUJARATI_LETTER_VA								0x0AB5
#define U_GUJARATI_LETTER_SHA								0x0AB6
#define U_GUJARATI_LETTER_SSA								0x0AB7
#define U_GUJARATI_LETTER_SA								0x0AB8
#define U_GUJARATI_LETTER_HA								0x0AB9
#define U_GUJARATI_SIGN_NUKTA								0x0ABC
#define U_GUJARATI_SIGN_AVAGRAHA							0x0ABD
#define U_GUJARATI_VOWEL_SIGN_AA							0x0ABE
#define U_GUJARATI_VOWEL_SIGN_I								0x0ABF
#define U_GUJARATI_VOWEL_SIGN_II							0x0AC0
#define U_GUJARATI_VOWEL_SIGN_U								0x0AC1
#define U_GUJARATI_VOWEL_SIGN_UU							0x0AC2
#define U_GUJARATI_VOWEL_SIGN_VOCALIC_R							0x0AC3
#define U_GUJARATI_VOWEL_SIGN_VOCALIC_RR						0x0AC4
#define U_GUJARATI_VOWEL_SIGN_CANDRA_E							0x0AC5
#define U_GUJARATI_VOWEL_SIGN_E								0x0AC7
#define U_GUJARATI_VOWEL_SIGN_AI							0x0AC8
#define U_GUJARATI_VOWEL_SIGN_CANDRA_O							0x0AC9
#define U_GUJARATI_VOWEL_SIGN_O								0x0ACB
#define U_GUJARATI_VOWEL_SIGN_AU							0x0ACC
#define U_GUJARATI_SIGN_VIRAMA								0x0ACD
#define U_GUJARATI_OM									0x0AD0
#define U_GUJARATI_LETTER_VOCALIC_RR							0x0AE0
#define U_GUJARATI_DIGIT_ZERO								0x0AE6
#define U_GUJARATI_DIGIT_ONE								0x0AE7
#define U_GUJARATI_DIGIT_TWO								0x0AE8
#define U_GUJARATI_DIGIT_THREE								0x0AE9
#define U_GUJARATI_DIGIT_FOUR								0x0AEA
#define U_GUJARATI_DIGIT_FIVE								0x0AEB
#define U_GUJARATI_DIGIT_SIX								0x0AEC
#define U_GUJARATI_DIGIT_SEVEN								0x0AED
#define U_GUJARATI_DIGIT_EIGHT								0x0AEE
#define U_GUJARATI_DIGIT_NINE								0x0AEF
#define U_ORIYA_SIGN_CANDRABINDU							0x0B01
#define U_ORIYA_SIGN_ANUSVARA								0x0B02
#define U_ORIYA_SIGN_VISARGA								0x0B03
#define U_ORIYA_LETTER_A								0x0B05
#define U_ORIYA_LETTER_AA								0x0B06
#define U_ORIYA_LETTER_I								0x0B07
#define U_ORIYA_LETTER_II								0x0B08
#define U_ORIYA_LETTER_U								0x0B09
#define U_ORIYA_LETTER_UU								0x0B0A
#define U_ORIYA_LETTER_VOCALIC_R							0x0B0B
#define U_ORIYA_LETTER_VOCALIC_L							0x0B0C
#define U_ORIYA_LETTER_E								0x0B0F
#define U_ORIYA_LETTER_AI								0x0B10
#define U_ORIYA_LETTER_O								0x0B13
#define U_ORIYA_LETTER_AU								0x0B14
#define U_ORIYA_LETTER_KA								0x0B15
#define U_ORIYA_LETTER_KHA								0x0B16
#define U_ORIYA_LETTER_GA								0x0B17
#define U_ORIYA_LETTER_GHA								0x0B18
#define U_ORIYA_LETTER_NGA								0x0B19
#define U_ORIYA_LETTER_CA								0x0B1A
#define U_ORIYA_LETTER_CHA								0x0B1B
#define U_ORIYA_LETTER_JA								0x0B1C
#define U_ORIYA_LETTER_JHA								0x0B1D
#define U_ORIYA_LETTER_NYA								0x0B1E
#define U_ORIYA_LETTER_TTA								0x0B1F
#define U_ORIYA_LETTER_TTHA								0x0B20
#define U_ORIYA_LETTER_DDA								0x0B21
#define U_ORIYA_LETTER_DDHA								0x0B22
#define U_ORIYA_LETTER_NNA								0x0B23
#define U_ORIYA_LETTER_TA								0x0B24
#define U_ORIYA_LETTER_THA								0x0B25
#define U_ORIYA_LETTER_DA								0x0B26
#define U_ORIYA_LETTER_DHA								0x0B27
#define U_ORIYA_LETTER_NA								0x0B28
#define U_ORIYA_LETTER_PA								0x0B2A
#define U_ORIYA_LETTER_PHA								0x0B2B
#define U_ORIYA_LETTER_BA								0x0B2C
#define U_ORIYA_LETTER_BHA								0x0B2D
#define U_ORIYA_LETTER_MA								0x0B2E
#define U_ORIYA_LETTER_YA								0x0B2F
#define U_ORIYA_LETTER_RA								0x0B30
#define U_ORIYA_LETTER_LA								0x0B32
#define U_ORIYA_LETTER_LLA								0x0B33
#define U_ORIYA_LETTER_SHA								0x0B36
#define U_ORIYA_LETTER_SSA								0x0B37
#define U_ORIYA_LETTER_SA								0x0B38
#define U_ORIYA_LETTER_HA								0x0B39
#define U_ORIYA_SIGN_NUKTA								0x0B3C
#define U_ORIYA_SIGN_AVAGRAHA								0x0B3D
#define U_ORIYA_VOWEL_SIGN_AA								0x0B3E
#define U_ORIYA_VOWEL_SIGN_I								0x0B3F
#define U_ORIYA_VOWEL_SIGN_II								0x0B40
#define U_ORIYA_VOWEL_SIGN_U								0x0B41
#define U_ORIYA_VOWEL_SIGN_UU								0x0B42
#define U_ORIYA_VOWEL_SIGN_VOCALIC_R							0x0B43
#define U_ORIYA_VOWEL_SIGN_E								0x0B47
#define U_ORIYA_VOWEL_SIGN_AI								0x0B48
#define U_ORIYA_VOWEL_SIGN_O								0x0B4B
#define U_ORIYA_VOWEL_SIGN_AU								0x0B4C
#define U_ORIYA_SIGN_VIRAMA								0x0B4D
#define U_ORIYA_AI_LENGTH_MARK								0x0B56
#define U_ORIYA_AU_LENGTH_MARK								0x0B57
#define U_ORIYA_LETTER_RRA								0x0B5C
#define U_ORIYA_LETTER_RHA								0x0B5D
#define U_ORIYA_LETTER_YYA								0x0B5F
#define U_ORIYA_LETTER_VOCALIC_RR							0x0B60
#define U_ORIYA_LETTER_VOCALIC_LL							0x0B61
#define U_ORIYA_DIGIT_ZERO								0x0B66
#define U_ORIYA_DIGIT_ONE								0x0B67
#define U_ORIYA_DIGIT_TWO								0x0B68
#define U_ORIYA_DIGIT_THREE								0x0B69
#define U_ORIYA_DIGIT_FOUR								0x0B6A
#define U_ORIYA_DIGIT_FIVE								0x0B6B
#define U_ORIYA_DIGIT_SIX								0x0B6C
#define U_ORIYA_DIGIT_SEVEN								0x0B6D
#define U_ORIYA_DIGIT_EIGHT								0x0B6E
#define U_ORIYA_DIGIT_NINE								0x0B6F
#define U_ORIYA_ISSHAR									0x0B70
#define U_TAMIL_SIGN_ANUSVARA								0x0B82
#define U_TAMIL_SIGN_VISARGA								0x0B83
#define U_TAMIL_LETTER_A								0x0B85
#define U_TAMIL_LETTER_AA								0x0B86
#define U_TAMIL_LETTER_I								0x0B87
#define U_TAMIL_LETTER_II								0x0B88
#define U_TAMIL_LETTER_U								0x0B89
#define U_TAMIL_LETTER_UU								0x0B8A
#define U_TAMIL_LETTER_E								0x0B8E
#define U_TAMIL_LETTER_EE								0x0B8F
#define U_TAMIL_LETTER_AI								0x0B90
#define U_TAMIL_LETTER_O								0x0B92
#define U_TAMIL_LETTER_OO								0x0B93
#define U_TAMIL_LETTER_AU								0x0B94
#define U_TAMIL_LETTER_KA								0x0B95
#define U_TAMIL_LETTER_NGA								0x0B99
#define U_TAMIL_LETTER_CA								0x0B9A
#define U_TAMIL_LETTER_JA								0x0B9C
#define U_TAMIL_LETTER_NYA								0x0B9E
#define U_TAMIL_LETTER_TTA								0x0B9F
#define U_TAMIL_LETTER_NNA								0x0BA3
#define U_TAMIL_LETTER_TA								0x0BA4
#define U_TAMIL_LETTER_NA								0x0BA8
#define U_TAMIL_LETTER_NNNA								0x0BA9
#define U_TAMIL_LETTER_PA								0x0BAA
#define U_TAMIL_LETTER_MA								0x0BAE
#define U_TAMIL_LETTER_YA								0x0BAF
#define U_TAMIL_LETTER_RA								0x0BB0
#define U_TAMIL_LETTER_RRA								0x0BB1
#define U_TAMIL_LETTER_LA								0x0BB2
#define U_TAMIL_LETTER_LLA								0x0BB3
#define U_TAMIL_LETTER_LLLA								0x0BB4
#define U_TAMIL_LETTER_VA								0x0BB5
#define U_TAMIL_LETTER_SSA								0x0BB7
#define U_TAMIL_LETTER_SA								0x0BB8
#define U_TAMIL_LETTER_HA								0x0BB9
#define U_TAMIL_VOWEL_SIGN_AA								0x0BBE
#define U_TAMIL_VOWEL_SIGN_I								0x0BBF
#define U_TAMIL_VOWEL_SIGN_II								0x0BC0
#define U_TAMIL_VOWEL_SIGN_U								0x0BC1
#define U_TAMIL_VOWEL_SIGN_UU								0x0BC2
#define U_TAMIL_VOWEL_SIGN_E								0x0BC6
#define U_TAMIL_VOWEL_SIGN_EE								0x0BC7
#define U_TAMIL_VOWEL_SIGN_AI								0x0BC8
#define U_TAMIL_VOWEL_SIGN_O								0x0BCA
#define U_TAMIL_VOWEL_SIGN_OO								0x0BCB
#define U_TAMIL_VOWEL_SIGN_AU								0x0BCC
#define U_TAMIL_SIGN_VIRAMA								0x0BCD
#define U_TAMIL_AU_LENGTH_MARK								0x0BD7
#define U_TAMIL_DIGIT_ONE								0x0BE7
#define U_TAMIL_DIGIT_TWO								0x0BE8
#define U_TAMIL_DIGIT_THREE								0x0BE9
#define U_TAMIL_DIGIT_FOUR								0x0BEA
#define U_TAMIL_DIGIT_FIVE								0x0BEB
#define U_TAMIL_DIGIT_SIX								0x0BEC
#define U_TAMIL_DIGIT_SEVEN								0x0BED
#define U_TAMIL_DIGIT_EIGHT								0x0BEE
#define U_TAMIL_DIGIT_NINE								0x0BEF
#define U_TAMIL_NUMBER_TEN								0x0BF0
#define U_TAMIL_NUMBER_ONE_HUNDRED							0x0BF1
#define U_TAMIL_NUMBER_ONE_THOUSAND							0x0BF2
#define U_TELUGU_SIGN_CANDRABINDU							0x0C01
#define U_TELUGU_SIGN_ANUSVARA								0x0C02
#define U_TELUGU_SIGN_VISARGA								0x0C03
#define U_TELUGU_LETTER_A								0x0C05
#define U_TELUGU_LETTER_AA								0x0C06
#define U_TELUGU_LETTER_I								0x0C07
#define U_TELUGU_LETTER_II								0x0C08
#define U_TELUGU_LETTER_U								0x0C09
#define U_TELUGU_LETTER_UU								0x0C0A
#define U_TELUGU_LETTER_VOCALIC_R							0x0C0B
#define U_TELUGU_LETTER_VOCALIC_L							0x0C0C
#define U_TELUGU_LETTER_E								0x0C0E
#define U_TELUGU_LETTER_EE								0x0C0F
#define U_TELUGU_LETTER_AI								0x0C10
#define U_TELUGU_LETTER_O								0x0C12
#define U_TELUGU_LETTER_OO								0x0C13
#define U_TELUGU_LETTER_AU								0x0C14
#define U_TELUGU_LETTER_KA								0x0C15
#define U_TELUGU_LETTER_KHA								0x0C16
#define U_TELUGU_LETTER_GA								0x0C17
#define U_TELUGU_LETTER_GHA								0x0C18
#define U_TELUGU_LETTER_NGA								0x0C19
#define U_TELUGU_LETTER_CA								0x0C1A
#define U_TELUGU_LETTER_CHA								0x0C1B
#define U_TELUGU_LETTER_JA								0x0C1C
#define U_TELUGU_LETTER_JHA								0x0C1D
#define U_TELUGU_LETTER_NYA								0x0C1E
#define U_TELUGU_LETTER_TTA								0x0C1F
#define U_TELUGU_LETTER_TTHA								0x0C20
#define U_TELUGU_LETTER_DDA								0x0C21
#define U_TELUGU_LETTER_DDHA								0x0C22
#define U_TELUGU_LETTER_NNA								0x0C23
#define U_TELUGU_LETTER_TA								0x0C24
#define U_TELUGU_LETTER_THA								0x0C25
#define U_TELUGU_LETTER_DA								0x0C26
#define U_TELUGU_LETTER_DHA								0x0C27
#define U_TELUGU_LETTER_NA								0x0C28
#define U_TELUGU_LETTER_PA								0x0C2A
#define U_TELUGU_LETTER_PHA								0x0C2B
#define U_TELUGU_LETTER_BA								0x0C2C
#define U_TELUGU_LETTER_BHA								0x0C2D
#define U_TELUGU_LETTER_MA								0x0C2E
#define U_TELUGU_LETTER_YA								0x0C2F
#define U_TELUGU_LETTER_RA								0x0C30
#define U_TELUGU_LETTER_RRA								0x0C31
#define U_TELUGU_LETTER_LA								0x0C32
#define U_TELUGU_LETTER_LLA								0x0C33
#define U_TELUGU_LETTER_VA								0x0C35
#define U_TELUGU_LETTER_SHA								0x0C36
#define U_TELUGU_LETTER_SSA								0x0C37
#define U_TELUGU_LETTER_SA								0x0C38
#define U_TELUGU_LETTER_HA								0x0C39
#define U_TELUGU_VOWEL_SIGN_AA								0x0C3E
#define U_TELUGU_VOWEL_SIGN_I								0x0C3F
#define U_TELUGU_VOWEL_SIGN_II								0x0C40
#define U_TELUGU_VOWEL_SIGN_U								0x0C41
#define U_TELUGU_VOWEL_SIGN_UU								0x0C42
#define U_TELUGU_VOWEL_SIGN_VOCALIC_R							0x0C43
#define U_TELUGU_VOWEL_SIGN_VOCALIC_RR							0x0C44
#define U_TELUGU_VOWEL_SIGN_E								0x0C46
#define U_TELUGU_VOWEL_SIGN_EE								0x0C47
#define U_TELUGU_VOWEL_SIGN_AI								0x0C48
#define U_TELUGU_VOWEL_SIGN_O								0x0C4A
#define U_TELUGU_VOWEL_SIGN_OO								0x0C4B
#define U_TELUGU_VOWEL_SIGN_AU								0x0C4C
#define U_TELUGU_SIGN_VIRAMA								0x0C4D
#define U_TELUGU_LENGTH_MARK								0x0C55
#define U_TELUGU_AI_LENGTH_MARK								0x0C56
#define U_TELUGU_LETTER_VOCALIC_RR							0x0C60
#define U_TELUGU_LETTER_VOCALIC_LL							0x0C61
#define U_TELUGU_DIGIT_ZERO								0x0C66
#define U_TELUGU_DIGIT_ONE								0x0C67
#define U_TELUGU_DIGIT_TWO								0x0C68
#define U_TELUGU_DIGIT_THREE								0x0C69
#define U_TELUGU_DIGIT_FOUR								0x0C6A
#define U_TELUGU_DIGIT_FIVE								0x0C6B
#define U_TELUGU_DIGIT_SIX								0x0C6C
#define U_TELUGU_DIGIT_SEVEN								0x0C6D
#define U_TELUGU_DIGIT_EIGHT								0x0C6E
#define U_TELUGU_DIGIT_NINE								0x0C6F
#define U_KANNADA_SIGN_ANUSVARA								0x0C82
#define U_KANNADA_SIGN_VISARGA								0x0C83
#define U_KANNADA_LETTER_A								0x0C85
#define U_KANNADA_LETTER_AA								0x0C86
#define U_KANNADA_LETTER_I								0x0C87
#define U_KANNADA_LETTER_II								0x0C88
#define U_KANNADA_LETTER_U								0x0C89
#define U_KANNADA_LETTER_UU								0x0C8A
#define U_KANNADA_LETTER_VOCALIC_R							0x0C8B
#define U_KANNADA_LETTER_VOCALIC_L							0x0C8C
#define U_KANNADA_LETTER_E								0x0C8E
#define U_KANNADA_LETTER_EE								0x0C8F
#define U_KANNADA_LETTER_AI								0x0C90
#define U_KANNADA_LETTER_O								0x0C92
#define U_KANNADA_LETTER_OO								0x0C93
#define U_KANNADA_LETTER_AU								0x0C94
#define U_KANNADA_LETTER_KA								0x0C95
#define U_KANNADA_LETTER_KHA								0x0C96
#define U_KANNADA_LETTER_GA								0x0C97
#define U_KANNADA_LETTER_GHA								0x0C98
#define U_KANNADA_LETTER_NGA								0x0C99
#define U_KANNADA_LETTER_CA								0x0C9A
#define U_KANNADA_LETTER_CHA								0x0C9B
#define U_KANNADA_LETTER_JA								0x0C9C
#define U_KANNADA_LETTER_JHA								0x0C9D
#define U_KANNADA_LETTER_NYA								0x0C9E
#define U_KANNADA_LETTER_TTA								0x0C9F
#define U_KANNADA_LETTER_TTHA								0x0CA0
#define U_KANNADA_LETTER_DDA								0x0CA1
#define U_KANNADA_LETTER_DDHA								0x0CA2
#define U_KANNADA_LETTER_NNA								0x0CA3
#define U_KANNADA_LETTER_TA								0x0CA4
#define U_KANNADA_LETTER_THA								0x0CA5
#define U_KANNADA_LETTER_DA								0x0CA6
#define U_KANNADA_LETTER_DHA								0x0CA7
#define U_KANNADA_LETTER_NA								0x0CA8
#define U_KANNADA_LETTER_PA								0x0CAA
#define U_KANNADA_LETTER_PHA								0x0CAB
#define U_KANNADA_LETTER_BA								0x0CAC
#define U_KANNADA_LETTER_BHA								0x0CAD
#define U_KANNADA_LETTER_MA								0x0CAE
#define U_KANNADA_LETTER_YA								0x0CAF
#define U_KANNADA_LETTER_RA								0x0CB0
#define U_KANNADA_LETTER_RRA								0x0CB1
#define U_KANNADA_LETTER_LA								0x0CB2
#define U_KANNADA_LETTER_LLA								0x0CB3
#define U_KANNADA_LETTER_VA								0x0CB5
#define U_KANNADA_LETTER_SHA								0x0CB6
#define U_KANNADA_LETTER_SSA								0x0CB7
#define U_KANNADA_LETTER_SA								0x0CB8
#define U_KANNADA_LETTER_HA								0x0CB9
#define U_KANNADA_VOWEL_SIGN_AA								0x0CBE
#define U_KANNADA_VOWEL_SIGN_I								0x0CBF
#define U_KANNADA_VOWEL_SIGN_II								0x0CC0
#define U_KANNADA_VOWEL_SIGN_U								0x0CC1
#define U_KANNADA_VOWEL_SIGN_UU								0x0CC2
#define U_KANNADA_VOWEL_SIGN_VOCALIC_R							0x0CC3
#define U_KANNADA_VOWEL_SIGN_VOCALIC_RR							0x0CC4
#define U_KANNADA_VOWEL_SIGN_E								0x0CC6
#define U_KANNADA_VOWEL_SIGN_EE								0x0CC7
#define U_KANNADA_VOWEL_SIGN_AI								0x0CC8
#define U_KANNADA_VOWEL_SIGN_O								0x0CCA
#define U_KANNADA_VOWEL_SIGN_OO								0x0CCB
#define U_KANNADA_VOWEL_SIGN_AU								0x0CCC
#define U_KANNADA_SIGN_VIRAMA								0x0CCD
#define U_KANNADA_LENGTH_MARK								0x0CD5
#define U_KANNADA_AI_LENGTH_MARK							0x0CD6
#define U_KANNADA_LETTER_FA								0x0CDE
#define U_KANNADA_LETTER_VOCALIC_RR							0x0CE0
#define U_KANNADA_LETTER_VOCALIC_LL							0x0CE1
#define U_KANNADA_DIGIT_ZERO								0x0CE6
#define U_KANNADA_DIGIT_ONE								0x0CE7
#define U_KANNADA_DIGIT_TWO								0x0CE8
#define U_KANNADA_DIGIT_THREE								0x0CE9
#define U_KANNADA_DIGIT_FOUR								0x0CEA
#define U_KANNADA_DIGIT_FIVE								0x0CEB
#define U_KANNADA_DIGIT_SIX								0x0CEC
#define U_KANNADA_DIGIT_SEVEN								0x0CED
#define U_KANNADA_DIGIT_EIGHT								0x0CEE
#define U_KANNADA_DIGIT_NINE								0x0CEF
#define U_MALAYALAM_SIGN_ANUSVARA							0x0D02
#define U_MALAYALAM_SIGN_VISARGA							0x0D03
#define U_MALAYALAM_LETTER_A								0x0D05
#define U_MALAYALAM_LETTER_AA								0x0D06
#define U_MALAYALAM_LETTER_I								0x0D07
#define U_MALAYALAM_LETTER_II								0x0D08
#define U_MALAYALAM_LETTER_U								0x0D09
#define U_MALAYALAM_LETTER_UU								0x0D0A
#define U_MALAYALAM_LETTER_VOCALIC_R							0x0D0B
#define U_MALAYALAM_LETTER_VOCALIC_L							0x0D0C
#define U_MALAYALAM_LETTER_E								0x0D0E
#define U_MALAYALAM_LETTER_EE								0x0D0F
#define U_MALAYALAM_LETTER_AI								0x0D10
#define U_MALAYALAM_LETTER_O								0x0D12
#define U_MALAYALAM_LETTER_OO								0x0D13
#define U_MALAYALAM_LETTER_AU								0x0D14
#define U_MALAYALAM_LETTER_KA								0x0D15
#define U_MALAYALAM_LETTER_KHA								0x0D16
#define U_MALAYALAM_LETTER_GA								0x0D17
#define U_MALAYALAM_LETTER_GHA								0x0D18
#define U_MALAYALAM_LETTER_NGA								0x0D19
#define U_MALAYALAM_LETTER_CA								0x0D1A
#define U_MALAYALAM_LETTER_CHA								0x0D1B
#define U_MALAYALAM_LETTER_JA								0x0D1C
#define U_MALAYALAM_LETTER_JHA								0x0D1D
#define U_MALAYALAM_LETTER_NYA								0x0D1E
#define U_MALAYALAM_LETTER_TTA								0x0D1F
#define U_MALAYALAM_LETTER_TTHA								0x0D20
#define U_MALAYALAM_LETTER_DDA								0x0D21
#define U_MALAYALAM_LETTER_DDHA								0x0D22
#define U_MALAYALAM_LETTER_NNA								0x0D23
#define U_MALAYALAM_LETTER_TA								0x0D24
#define U_MALAYALAM_LETTER_THA								0x0D25
#define U_MALAYALAM_LETTER_DA								0x0D26
#define U_MALAYALAM_LETTER_DHA								0x0D27
#define U_MALAYALAM_LETTER_NA								0x0D28
#define U_MALAYALAM_LETTER_PA								0x0D2A
#define U_MALAYALAM_LETTER_PHA								0x0D2B
#define U_MALAYALAM_LETTER_BA								0x0D2C
#define U_MALAYALAM_LETTER_BHA								0x0D2D
#define U_MALAYALAM_LETTER_MA								0x0D2E
#define U_MALAYALAM_LETTER_YA								0x0D2F
#define U_MALAYALAM_LETTER_RA								0x0D30
#define U_MALAYALAM_LETTER_RRA								0x0D31
#define U_MALAYALAM_LETTER_LA								0x0D32
#define U_MALAYALAM_LETTER_LLA								0x0D33
#define U_MALAYALAM_LETTER_LLLA								0x0D34
#define U_MALAYALAM_LETTER_VA								0x0D35
#define U_MALAYALAM_LETTER_SHA								0x0D36
#define U_MALAYALAM_LETTER_SSA								0x0D37
#define U_MALAYALAM_LETTER_SA								0x0D38
#define U_MALAYALAM_LETTER_HA								0x0D39
#define U_MALAYALAM_VOWEL_SIGN_AA							0x0D3E
#define U_MALAYALAM_VOWEL_SIGN_I							0x0D3F
#define U_MALAYALAM_VOWEL_SIGN_II							0x0D40
#define U_MALAYALAM_VOWEL_SIGN_U							0x0D41
#define U_MALAYALAM_VOWEL_SIGN_UU							0x0D42
#define U_MALAYALAM_VOWEL_SIGN_VOCALIC_R						0x0D43
#define U_MALAYALAM_VOWEL_SIGN_E							0x0D46
#define U_MALAYALAM_VOWEL_SIGN_EE							0x0D47
#define U_MALAYALAM_VOWEL_SIGN_AI							0x0D48
#define U_MALAYALAM_VOWEL_SIGN_O							0x0D4A
#define U_MALAYALAM_VOWEL_SIGN_OO							0x0D4B
#define U_MALAYALAM_VOWEL_SIGN_AU							0x0D4C
#define U_MALAYALAM_SIGN_VIRAMA								0x0D4D
#define U_MALAYALAM_AU_LENGTH_MARK							0x0D57
#define U_MALAYALAM_LETTER_VOCALIC_RR							0x0D60
#define U_MALAYALAM_LETTER_VOCALIC_LL							0x0D61
#define U_MALAYALAM_DIGIT_ZERO								0x0D66
#define U_MALAYALAM_DIGIT_ONE								0x0D67
#define U_MALAYALAM_DIGIT_TWO								0x0D68
#define U_MALAYALAM_DIGIT_THREE								0x0D69
#define U_MALAYALAM_DIGIT_FOUR								0x0D6A
#define U_MALAYALAM_DIGIT_FIVE								0x0D6B
#define U_MALAYALAM_DIGIT_SIX								0x0D6C
#define U_MALAYALAM_DIGIT_SEVEN								0x0D6D
#define U_MALAYALAM_DIGIT_EIGHT								0x0D6E
#define U_MALAYALAM_DIGIT_NINE								0x0D6F
#define U_THAI_CHARACTER_KO_KAI								0x0E01
#define U_THAI_CHARACTER_KHO_KHAI							0x0E02
#define U_THAI_CHARACTER_KHO_KHUAT							0x0E03
#define U_THAI_CHARACTER_KHO_KHWAI							0x0E04
#define U_THAI_CHARACTER_KHO_KHON							0x0E05
#define U_THAI_CHARACTER_KHO_RAKHANG							0x0E06
#define U_THAI_CHARACTER_NGO_NGU							0x0E07
#define U_THAI_CHARACTER_CHO_CHAN							0x0E08
#define U_THAI_CHARACTER_CHO_CHING							0x0E09
#define U_THAI_CHARACTER_CHO_CHANG							0x0E0A
#define U_THAI_CHARACTER_SO_SO								0x0E0B
#define U_THAI_CHARACTER_CHO_CHOE							0x0E0C
#define U_THAI_CHARACTER_YO_YING							0x0E0D
#define U_THAI_CHARACTER_DO_CHADA							0x0E0E
#define U_THAI_CHARACTER_TO_PATAK							0x0E0F
#define U_THAI_CHARACTER_THO_THAN							0x0E10
#define U_THAI_CHARACTER_THO_NANGMONTHO							0x0E11
#define U_THAI_CHARACTER_THO_PHUTHAO							0x0E12
#define U_THAI_CHARACTER_NO_NEN								0x0E13
#define U_THAI_CHARACTER_DO_DEK								0x0E14
#define U_THAI_CHARACTER_TO_TAO								0x0E15
#define U_THAI_CHARACTER_THO_THUNG							0x0E16
#define U_THAI_CHARACTER_THO_THAHAN							0x0E17
#define U_THAI_CHARACTER_THO_THONG							0x0E18
#define U_THAI_CHARACTER_NO_NU								0x0E19
#define U_THAI_CHARACTER_BO_BAIMAI							0x0E1A
#define U_THAI_CHARACTER_PO_PLA								0x0E1B
#define U_THAI_CHARACTER_PHO_PHUNG							0x0E1C
#define U_THAI_CHARACTER_FO_FA								0x0E1D
#define U_THAI_CHARACTER_PHO_PHAN							0x0E1E
#define U_THAI_CHARACTER_FO_FAN								0x0E1F
#define U_THAI_CHARACTER_PHO_SAMPHAO							0x0E20
#define U_THAI_CHARACTER_MO_MA								0x0E21
#define U_THAI_CHARACTER_YO_YAK								0x0E22
#define U_THAI_CHARACTER_RO_RUA								0x0E23
#define U_THAI_CHARACTER_RU								0x0E24
#define U_THAI_CHARACTER_LO_LING							0x0E25
#define U_THAI_CHARACTER_LU								0x0E26
#define U_THAI_CHARACTER_WO_WAEN							0x0E27
#define U_THAI_CHARACTER_SO_SALA							0x0E28
#define U_THAI_CHARACTER_SO_RUSI							0x0E29
#define U_THAI_CHARACTER_SO_SUA								0x0E2A
#define U_THAI_CHARACTER_HO_HIP								0x0E2B
#define U_THAI_CHARACTER_LO_CHULA							0x0E2C
#define U_THAI_CHARACTER_O_ANG								0x0E2D
#define U_THAI_CHARACTER_HO_NOKHUK							0x0E2E
#define U_THAI_CHARACTER_PAIYANNOI							0x0E2F
#define U_THAI_CHARACTER_SARA_A								0x0E30
#define U_THAI_CHARACTER_MAI_HAN_AKAT							0x0E31
#define U_THAI_CHARACTER_SARA_AA							0x0E32
#define U_THAI_CHARACTER_SARA_AM							0x0E33
#define U_THAI_CHARACTER_SARA_I								0x0E34
#define U_THAI_CHARACTER_SARA_II							0x0E35
#define U_THAI_CHARACTER_SARA_UE							0x0E36
#define U_THAI_CHARACTER_SARA_UEE							0x0E37
#define U_THAI_CHARACTER_SARA_U								0x0E38
#define U_THAI_CHARACTER_SARA_UU							0x0E39
#define U_THAI_CHARACTER_PHINTHU							0x0E3A
#define U_THAI_CURRENCY_SYMBOL_BAHT							0x0E3F
#define U_THAI_CHARACTER_SARA_E								0x0E40
#define U_THAI_CHARACTER_SARA_AE							0x0E41
#define U_THAI_CHARACTER_SARA_O								0x0E42
#define U_THAI_CHARACTER_SARA_AI_MAIMUAN						0x0E43
#define U_THAI_CHARACTER_SARA_AI_MAIMALAI						0x0E44
#define U_THAI_CHARACTER_LAKKHANGYAO							0x0E45
#define U_THAI_CHARACTER_MAIYAMOK							0x0E46
#define U_THAI_CHARACTER_MAITAIKHU							0x0E47
#define U_THAI_CHARACTER_MAI_EK								0x0E48
#define U_THAI_CHARACTER_MAI_THO							0x0E49
#define U_THAI_CHARACTER_MAI_TRI							0x0E4A
#define U_THAI_CHARACTER_MAI_CHATTAWA							0x0E4B
#define U_THAI_CHARACTER_THANTHAKHAT							0x0E4C
#define U_THAI_CHARACTER_NIKHAHIT							0x0E4D
#define U_THAI_CHARACTER_YAMAKKAN							0x0E4E
#define U_THAI_CHARACTER_FONGMAN							0x0E4F
#define U_THAI_DIGIT_ZERO								0x0E50
#define U_THAI_DIGIT_ONE								0x0E51
#define U_THAI_DIGIT_TWO								0x0E52
#define U_THAI_DIGIT_THREE								0x0E53
#define U_THAI_DIGIT_FOUR								0x0E54
#define U_THAI_DIGIT_FIVE								0x0E55
#define U_THAI_DIGIT_SIX								0x0E56
#define U_THAI_DIGIT_SEVEN								0x0E57
#define U_THAI_DIGIT_EIGHT								0x0E58
#define U_THAI_DIGIT_NINE								0x0E59
#define U_THAI_CHARACTER_ANGKHANKHU							0x0E5A
#define U_THAI_CHARACTER_KHOMUT								0x0E5B
#define U_LAO_LETTER_KO									0x0E81
#define U_LAO_LETTER_KHO_SUNG								0x0E82
#define U_LAO_LETTER_KHO_TAM								0x0E84
#define U_LAO_LETTER_NGO								0x0E87
#define U_LAO_LETTER_CO									0x0E88
#define U_LAO_LETTER_SO_TAM								0x0E8A
#define U_LAO_LETTER_NYO								0x0E8D
#define U_LAO_LETTER_DO									0x0E94
#define U_LAO_LETTER_TO									0x0E95
#define U_LAO_LETTER_THO_SUNG								0x0E96
#define U_LAO_LETTER_THO_TAM								0x0E97
#define U_LAO_LETTER_NO									0x0E99
#define U_LAO_LETTER_BO									0x0E9A
#define U_LAO_LETTER_PO									0x0E9B
#define U_LAO_LETTER_PHO_SUNG								0x0E9C
#define U_LAO_LETTER_FO_TAM								0x0E9D
#define U_LAO_LETTER_PHO_TAM								0x0E9E
#define U_LAO_LETTER_FO_SUNG								0x0E9F
#define U_LAO_LETTER_MO									0x0EA1
#define U_LAO_LETTER_YO									0x0EA2
#define U_LAO_LETTER_LO_LING								0x0EA3
#define U_LAO_LETTER_LO_LOOT								0x0EA5
#define U_LAO_LETTER_WO									0x0EA7
#define U_LAO_LETTER_SO_SUNG								0x0EAA
#define U_LAO_LETTER_HO_SUNG								0x0EAB
#define U_LAO_LETTER_O									0x0EAD
#define U_LAO_LETTER_HO_TAM								0x0EAE
#define U_LAO_ELLIPSIS									0x0EAF
#define U_LAO_VOWEL_SIGN_A								0x0EB0
#define U_LAO_VOWEL_SIGN_MAI_KAN							0x0EB1
#define U_LAO_VOWEL_SIGN_AA								0x0EB2
#define U_LAO_VOWEL_SIGN_AM								0x0EB3
#define U_LAO_VOWEL_SIGN_I								0x0EB4
#define U_LAO_VOWEL_SIGN_II								0x0EB5
#define U_LAO_VOWEL_SIGN_Y								0x0EB6
#define U_LAO_VOWEL_SIGN_YY								0x0EB7
#define U_LAO_VOWEL_SIGN_U								0x0EB8
#define U_LAO_VOWEL_SIGN_UU								0x0EB9
#define U_LAO_VOWEL_SIGN_MAI_KON							0x0EBB
#define U_LAO_SEMIVOWEL_SIGN_LO								0x0EBC
#define U_LAO_SEMIVOWEL_SIGN_NYO							0x0EBD
#define U_LAO_VOWEL_SIGN_E								0x0EC0
#define U_LAO_VOWEL_SIGN_EI								0x0EC1
#define U_LAO_VOWEL_SIGN_O								0x0EC2
#define U_LAO_VOWEL_SIGN_AY								0x0EC3
#define U_LAO_VOWEL_SIGN_AI								0x0EC4
#define U_LAO_KO_LA									0x0EC6
#define U_LAO_TONE_MAI_EK								0x0EC8
#define U_LAO_TONE_MAI_THO								0x0EC9
#define U_LAO_TONE_MAI_TI								0x0ECA
#define U_LAO_TONE_MAI_CATAWA								0x0ECB
#define U_LAO_CANCELLATION_MARK								0x0ECC
#define U_LAO_NIGGAHITA									0x0ECD
#define U_LAO_DIGIT_ZERO								0x0ED0
#define U_LAO_DIGIT_ONE									0x0ED1
#define U_LAO_DIGIT_TWO									0x0ED2
#define U_LAO_DIGIT_THREE								0x0ED3
#define U_LAO_DIGIT_FOUR								0x0ED4
#define U_LAO_DIGIT_FIVE								0x0ED5
#define U_LAO_DIGIT_SIX									0x0ED6
#define U_LAO_DIGIT_SEVEN								0x0ED7
#define U_LAO_DIGIT_EIGHT								0x0ED8
#define U_LAO_DIGIT_NINE								0x0ED9
#define U_LAO_HO_NO									0x0EDC
#define U_LAO_HO_MO									0x0EDD
#define U_TIBETAN_SYLLABLE_OM								0x0F00
#define U_TIBETAN_MARK_GTER_YIG_MGO_TRUNCATED_A						0x0F01
#define U_TIBETAN_MARK_GTER_YIG_MGO_UM_RNAM_BCAD_MA					0x0F02
#define U_TIBETAN_MARK_GTER_YIG_MGO_UM_GTER_TSHEG_MA					0x0F03
#define U_TIBETAN_MARK_INITIAL_YIG_MGO_MDUN_MA						0x0F04
#define U_TIBETAN_MARK_CLOSING_YIG_MGO_SGAB_MA						0x0F05
#define U_TIBETAN_MARK_CARET_YIG_MGO_PHUR_SHAD_MA					0x0F06
#define U_TIBETAN_MARK_YIG_MGO_TSHEG_SHAD_MA						0x0F07
#define U_TIBETAN_MARK_SBRUL_SHAD							0x0F08
#define U_TIBETAN_MARK_BSKUR_YIG_MGO							0x0F09
#define U_TIBETAN_MARK_BKA_ SHOG_YIG_MGO						0x0F0A
#define U_TIBETAN_MARK_INTERSYLLABIC_TSHEG						0x0F0B
#define U_TIBETAN_MARK_DELIMITER_TSHEG_BSTAR						0x0F0C
#define U_TIBETAN_MARK_SHAD								0x0F0D
#define U_TIBETAN_MARK_NYIS_SHAD							0x0F0E
#define U_TIBETAN_MARK_TSHEG_SHAD							0x0F0F
#define U_TIBETAN_MARK_NYIS_TSHEG_SHAD							0x0F10
#define U_TIBETAN_MARK_RIN_CHEN_SPUNGS_SHAD						0x0F11
#define U_TIBETAN_MARK_RGYA_GRAM_SHAD							0x0F12
#define U_TIBETAN_MARK_CARET_DZUD_RTAGS_ME_LONG_CAN					0x0F13
#define U_TIBETAN_MARK_GTER_TSHEG							0x0F14
#define U_TIBETAN_LOGOTYPE_SIGN_CHAD_RTAGS						0x0F15
#define U_TIBETAN_LOGOTYPE_SIGN_LHAG_RTAGS						0x0F16
#define U_TIBETAN_ASTROLOGICAL_SIGN_SGRA_GCAN_CHAR_RTAGS				0x0F17
#define U_TIBETAN_ASTROLOGICAL_SIGN_KHYUD_PA						0x0F18
#define U_TIBETAN_ASTROLOGICAL_SIGN_SDONG_TSHUGS					0x0F19
#define U_TIBETAN_SIGN_RDEL_DKAR_GCIG							0x0F1A
#define U_TIBETAN_SIGN_RDEL_DKAR_GNYIS							0x0F1B
#define U_TIBETAN_SIGN_RDEL_DKAR_GSUM							0x0F1C
#define U_TIBETAN_SIGN_RDEL_NAG_GCIG							0x0F1D
#define U_TIBETAN_SIGN_RDEL_NAG_GNYIS							0x0F1E
#define U_TIBETAN_SIGN_RDEL_DKAR_RDEL_NAG						0x0F1F
#define U_TIBETAN_DIGIT_ZERO								0x0F20
#define U_TIBETAN_DIGIT_ONE								0x0F21
#define U_TIBETAN_DIGIT_TWO								0x0F22
#define U_TIBETAN_DIGIT_THREE								0x0F23
#define U_TIBETAN_DIGIT_FOUR								0x0F24
#define U_TIBETAN_DIGIT_FIVE								0x0F25
#define U_TIBETAN_DIGIT_SIX								0x0F26
#define U_TIBETAN_DIGIT_SEVEN								0x0F27
#define U_TIBETAN_DIGIT_EIGHT								0x0F28
#define U_TIBETAN_DIGIT_NINE								0x0F29
#define U_TIBETAN_DIGIT_HALF_ONE							0x0F2A
#define U_TIBETAN_DIGIT_HALF_TWO							0x0F2B
#define U_TIBETAN_DIGIT_HALF_THREE							0x0F2C
#define U_TIBETAN_DIGIT_HALF_FOUR							0x0F2D
#define U_TIBETAN_DIGIT_HALF_FIVE							0x0F2E
#define U_TIBETAN_DIGIT_HALF_SIX							0x0F2F
#define U_TIBETAN_DIGIT_HALF_SEVEN							0x0F30
#define U_TIBETAN_DIGIT_HALF_EIGHT							0x0F31
#define U_TIBETAN_DIGIT_HALF_NINE							0x0F32
#define U_TIBETAN_DIGIT_HALF_ZERO							0x0F33
#define U_TIBETAN_MARK_BSDUS_RTAGS							0x0F34
#define U_TIBETAN_MARK_NGAS_BZUNG_NYI_ZLA						0x0F35
#define U_TIBETAN_MARK_CARET_DZUD_RTAGS_BZHI_MIG_CAN					0x0F36
#define U_TIBETAN_MARK_NGAS_BZUNG_SGOR_RTAGS						0x0F37
#define U_TIBETAN_MARK_CHE_MGO								0x0F38
#define U_TIBETAN_MARK_TSA_PHRU								0x0F39
#define U_TIBETAN_MARK_GUG_RTAGS_GYON							0x0F3A
#define U_TIBETAN_MARK_GUG_RTAGS_GYAS							0x0F3B
#define U_TIBETAN_MARK_ANG_KHANG_GYON							0x0F3C
#define U_TIBETAN_MARK_ANG_KHANG_GYAS							0x0F3D
#define U_TIBETAN_SIGN_YAR_TSHES							0x0F3E
#define U_TIBETAN_SIGN_MAR_TSHES							0x0F3F
#define U_TIBETAN_LETTER_KA								0x0F40
#define U_TIBETAN_LETTER_KHA								0x0F41
#define U_TIBETAN_LETTER_GA								0x0F42
#define U_TIBETAN_LETTER_GHA								0x0F43
#define U_TIBETAN_LETTER_NGA								0x0F44
#define U_TIBETAN_LETTER_CA								0x0F45
#define U_TIBETAN_LETTER_CHA								0x0F46
#define U_TIBETAN_LETTER_JA								0x0F47
#define U_TIBETAN_LETTER_NYA								0x0F49
#define U_TIBETAN_LETTER_TTA								0x0F4A
#define U_TIBETAN_LETTER_TTHA								0x0F4B
#define U_TIBETAN_LETTER_DDA								0x0F4C
#define U_TIBETAN_LETTER_DDHA								0x0F4D
#define U_TIBETAN_LETTER_NNA								0x0F4E
#define U_TIBETAN_LETTER_TA								0x0F4F
#define U_TIBETAN_LETTER_THA								0x0F50
#define U_TIBETAN_LETTER_DA								0x0F51
#define U_TIBETAN_LETTER_DHA								0x0F52
#define U_TIBETAN_LETTER_NA								0x0F53
#define U_TIBETAN_LETTER_PA								0x0F54
#define U_TIBETAN_LETTER_PHA								0x0F55
#define U_TIBETAN_LETTER_BA								0x0F56
#define U_TIBETAN_LETTER_BHA								0x0F57
#define U_TIBETAN_LETTER_MA								0x0F58
#define U_TIBETAN_LETTER_TSA								0x0F59
#define U_TIBETAN_LETTER_TSHA								0x0F5A
#define U_TIBETAN_LETTER_DZA								0x0F5B
#define U_TIBETAN_LETTER_DZHA								0x0F5C
#define U_TIBETAN_LETTER_WA								0x0F5D
#define U_TIBETAN_LETTER_ZHA								0x0F5E
#define U_TIBETAN_LETTER_ZA								0x0F5F
#define U_TIBETAN_LETTER_DASH_A								0x0F60
#define U_TIBETAN_LETTER_YA								0x0F61
#define U_TIBETAN_LETTER_RA								0x0F62
#define U_TIBETAN_LETTER_LA								0x0F63
#define U_TIBETAN_LETTER_SHA								0x0F64
#define U_TIBETAN_LETTER_SSA								0x0F65
#define U_TIBETAN_LETTER_SA								0x0F66
#define U_TIBETAN_LETTER_HA								0x0F67
#define U_TIBETAN_LETTER_A								0x0F68
#define U_TIBETAN_LETTER_KSSA								0x0F69
#define U_TIBETAN_VOWEL_SIGN_AA								0x0F71
#define U_TIBETAN_VOWEL_SIGN_I								0x0F72
#define U_TIBETAN_VOWEL_SIGN_II								0x0F73
#define U_TIBETAN_VOWEL_SIGN_U								0x0F74
#define U_TIBETAN_VOWEL_SIGN_UU								0x0F75
#define U_TIBETAN_VOWEL_SIGN_VOCALIC_R							0x0F76
#define U_TIBETAN_VOWEL_SIGN_VOCALIC_RR							0x0F77
#define U_TIBETAN_VOWEL_SIGN_VOCALIC_L							0x0F78
#define U_TIBETAN_VOWEL_SIGN_VOCALIC_LL							0x0F79
#define U_TIBETAN_VOWEL_SIGN_E								0x0F7A
#define U_TIBETAN_VOWEL_SIGN_EE								0x0F7B
#define U_TIBETAN_VOWEL_SIGN_O								0x0F7C
#define U_TIBETAN_VOWEL_SIGN_OO								0x0F7D
#define U_TIBETAN_SIGN_RJES_SU_NGA_RO							0x0F7E
#define U_TIBETAN_SIGN_RNAM_BCAD							0x0F7F
#define U_TIBETAN_VOWEL_SIGN_REVERSED_I							0x0F80
#define U_TIBETAN_VOWEL_SIGN_REVERSED_II						0x0F81
#define U_TIBETAN_SIGN_NYI_ZLA_NAA_DA							0x0F82
#define U_TIBETAN_SIGN_SNA_LDAN								0x0F83
#define U_TIBETAN_MARK_HALANTA								0x0F84
#define U_TIBETAN_MARK_PALUTA								0x0F85
#define U_TIBETAN_SIGN_LCI_RTAGS							0x0F86
#define U_TIBETAN_SIGN_YANG_RTAGS							0x0F87
#define U_TIBETAN_SIGN_LCE_TSA_CAN							0x0F88
#define U_TIBETAN_SIGN_MCHU_CAN								0x0F89
#define U_TIBETAN_SIGN_GRU_CAN_RGYINGS							0x0F8A
#define U_TIBETAN_SIGN_GRU_MED_RGYINGS							0x0F8B
#define U_TIBETAN_SUBJOINED_LETTER_KA							0x0F90
#define U_TIBETAN_SUBJOINED_LETTER_KHA							0x0F91
#define U_TIBETAN_SUBJOINED_LETTER_GA							0x0F92
#define U_TIBETAN_SUBJOINED_LETTER_GHA							0x0F93
#define U_TIBETAN_SUBJOINED_LETTER_NGA							0x0F94
#define U_TIBETAN_SUBJOINED_LETTER_CA							0x0F95
#define U_TIBETAN_SUBJOINED_LETTER_JA							0x0F97
#define U_TIBETAN_SUBJOINED_LETTER_NYA							0x0F99
#define U_TIBETAN_SUBJOINED_LETTER_TTA							0x0F9A
#define U_TIBETAN_SUBJOINED_LETTER_TTHA							0x0F9B
#define U_TIBETAN_SUBJOINED_LETTER_DDA							0x0F9C
#define U_TIBETAN_SUBJOINED_LETTER_DDHA							0x0F9D
#define U_TIBETAN_SUBJOINED_LETTER_NNA							0x0F9E
#define U_TIBETAN_SUBJOINED_LETTER_TA							0x0F9F
#define U_TIBETAN_SUBJOINED_LETTER_THA							0x0FA0
#define U_TIBETAN_SUBJOINED_LETTER_DA							0x0FA1
#define U_TIBETAN_SUBJOINED_LETTER_DHA							0x0FA2
#define U_TIBETAN_SUBJOINED_LETTER_NA							0x0FA3
#define U_TIBETAN_SUBJOINED_LETTER_PA							0x0FA4
#define U_TIBETAN_SUBJOINED_LETTER_PHA							0x0FA5
#define U_TIBETAN_SUBJOINED_LETTER_BA							0x0FA6
#define U_TIBETAN_SUBJOINED_LETTER_BHA							0x0FA7
#define U_TIBETAN_SUBJOINED_LETTER_MA							0x0FA8
#define U_TIBETAN_SUBJOINED_LETTER_TSA							0x0FA9
#define U_TIBETAN_SUBJOINED_LETTER_TSHA							0x0FAA
#define U_TIBETAN_SUBJOINED_LETTER_DZA							0x0FAB
#define U_TIBETAN_SUBJOINED_LETTER_DZHA							0x0FAC
#define U_TIBETAN_SUBJOINED_LETTER_WA							0x0FAD
#define U_TIBETAN_SUBJOINED_LETTER_YA							0x0FB1
#define U_TIBETAN_SUBJOINED_LETTER_RA							0x0FB2
#define U_TIBETAN_SUBJOINED_LETTER_LA							0x0FB3
#define U_TIBETAN_SUBJOINED_LETTER_SHA							0x0FB4
#define U_TIBETAN_SUBJOINED_LETTER_SSA							0x0FB5
#define U_TIBETAN_SUBJOINED_LETTER_SA							0x0FB6
#define U_TIBETAN_SUBJOINED_LETTER_HA							0x0FB7
#define U_TIBETAN_SUBJOINED_LETTER_KSSA							0x0FB9
#define U_GEORGIAN_CAPITAL_LETTER_AN							0x10A0
#define U_GEORGIAN_CAPITAL_LETTER_BAN							0x10A1
#define U_GEORGIAN_CAPITAL_LETTER_GAN							0x10A2
#define U_GEORGIAN_CAPITAL_LETTER_DON							0x10A3
#define U_GEORGIAN_CAPITAL_LETTER_EN							0x10A4
#define U_GEORGIAN_CAPITAL_LETTER_VIN							0x10A5
#define U_GEORGIAN_CAPITAL_LETTER_ZEN							0x10A6
#define U_GEORGIAN_CAPITAL_LETTER_TAN							0x10A7
#define U_GEORGIAN_CAPITAL_LETTER_IN							0x10A8
#define U_GEORGIAN_CAPITAL_LETTER_KAN							0x10A9
#define U_GEORGIAN_CAPITAL_LETTER_LAS							0x10AA
#define U_GEORGIAN_CAPITAL_LETTER_MAN							0x10AB
#define U_GEORGIAN_CAPITAL_LETTER_NAR							0x10AC
#define U_GEORGIAN_CAPITAL_LETTER_ON							0x10AD
#define U_GEORGIAN_CAPITAL_LETTER_PAR							0x10AE
#define U_GEORGIAN_CAPITAL_LETTER_ZHAR							0x10AF
#define U_GEORGIAN_CAPITAL_LETTER_RAE							0x10B0
#define U_GEORGIAN_CAPITAL_LETTER_SAN							0x10B1
#define U_GEORGIAN_CAPITAL_LETTER_TAR							0x10B2
#define U_GEORGIAN_CAPITAL_LETTER_UN							0x10B3
#define U_GEORGIAN_CAPITAL_LETTER_PHAR							0x10B4
#define U_GEORGIAN_CAPITAL_LETTER_KHAR							0x10B5
#define U_GEORGIAN_CAPITAL_LETTER_GHAN							0x10B6
#define U_GEORGIAN_CAPITAL_LETTER_QAR							0x10B7
#define U_GEORGIAN_CAPITAL_LETTER_SHIN							0x10B8
#define U_GEORGIAN_CAPITAL_LETTER_CHIN							0x10B9
#define U_GEORGIAN_CAPITAL_LETTER_CAN							0x10BA
#define U_GEORGIAN_CAPITAL_LETTER_JIL							0x10BB
#define U_GEORGIAN_CAPITAL_LETTER_CIL							0x10BC
#define U_GEORGIAN_CAPITAL_LETTER_CHAR							0x10BD
#define U_GEORGIAN_CAPITAL_LETTER_XAN							0x10BE
#define U_GEORGIAN_CAPITAL_LETTER_JHAN							0x10BF
#define U_GEORGIAN_CAPITAL_LETTER_HAE							0x10C0
#define U_GEORGIAN_CAPITAL_LETTER_HE							0x10C1
#define U_GEORGIAN_CAPITAL_LETTER_HIE							0x10C2
#define U_GEORGIAN_CAPITAL_LETTER_WE							0x10C3
#define U_GEORGIAN_CAPITAL_LETTER_HAR							0x10C4
#define U_GEORGIAN_CAPITAL_LETTER_HOE							0x10C5
#define U_GEORGIAN_LETTER_AN								0x10D0
#define U_GEORGIAN_LETTER_BAN								0x10D1
#define U_GEORGIAN_LETTER_GAN								0x10D2
#define U_GEORGIAN_LETTER_DON								0x10D3
#define U_GEORGIAN_LETTER_EN								0x10D4
#define U_GEORGIAN_LETTER_VIN								0x10D5
#define U_GEORGIAN_LETTER_ZEN								0x10D6
#define U_GEORGIAN_LETTER_TAN								0x10D7
#define U_GEORGIAN_LETTER_IN								0x10D8
#define U_GEORGIAN_LETTER_KAN								0x10D9
#define U_GEORGIAN_LETTER_LAS								0x10DA
#define U_GEORGIAN_LETTER_MAN								0x10DB
#define U_GEORGIAN_LETTER_NAR								0x10DC
#define U_GEORGIAN_LETTER_ON								0x10DD
#define U_GEORGIAN_LETTER_PAR								0x10DE
#define U_GEORGIAN_LETTER_ZHAR								0x10DF
#define U_GEORGIAN_LETTER_RAE								0x10E0
#define U_GEORGIAN_LETTER_SAN								0x10E1
#define U_GEORGIAN_LETTER_TAR								0x10E2
#define U_GEORGIAN_LETTER_UN								0x10E3
#define U_GEORGIAN_LETTER_PHAR								0x10E4
#define U_GEORGIAN_LETTER_KHAR								0x10E5
#define U_GEORGIAN_LETTER_GHAN								0x10E6
#define U_GEORGIAN_LETTER_QAR								0x10E7
#define U_GEORGIAN_LETTER_SHIN								0x10E8
#define U_GEORGIAN_LETTER_CHIN								0x10E9
#define U_GEORGIAN_LETTER_CAN								0x10EA
#define U_GEORGIAN_LETTER_JIL								0x10EB
#define U_GEORGIAN_LETTER_CIL								0x10EC
#define U_GEORGIAN_LETTER_CHAR								0x10ED
#define U_GEORGIAN_LETTER_XAN								0x10EE
#define U_GEORGIAN_LETTER_JHAN								0x10EF
#define U_GEORGIAN_LETTER_HAE								0x10F0
#define U_GEORGIAN_LETTER_HE								0x10F1
#define U_GEORGIAN_LETTER_HIE								0x10F2
#define U_GEORGIAN_LETTER_WE								0x10F3
#define U_GEORGIAN_LETTER_HAR								0x10F4
#define U_GEORGIAN_LETTER_HOE								0x10F5
#define U_GEORGIAN_LETTER_FI								0x10F6
#define U_GEORGIAN_PARAGRAPH_SEPARATOR							0x10FB
#define U_HANGUL_CHOSEONG_KIYEOK							0x1100
#define U_HANGUL_CHOSEONG_SSANGKIYEOK							0x1101
#define U_HANGUL_CHOSEONG_NIEUN								0x1102
#define U_HANGUL_CHOSEONG_TIKEUT							0x1103
#define U_HANGUL_CHOSEONG_SSANGTIKEUT							0x1104
#define U_HANGUL_CHOSEONG_RIEUL								0x1105
#define U_HANGUL_CHOSEONG_MIEUM								0x1106
#define U_HANGUL_CHOSEONG_PIEUP								0x1107
#define U_HANGUL_CHOSEONG_SSANGPIEUP							0x1108
#define U_HANGUL_CHOSEONG_SIOS								0x1109
#define U_HANGUL_CHOSEONG_SSANGSIOS							0x110A
#define U_HANGUL_CHOSEONG_IEUNG								0x110B
#define U_HANGUL_CHOSEONG_CIEUC								0x110C
#define U_HANGUL_CHOSEONG_SSANGCIEUC							0x110D
#define U_HANGUL_CHOSEONG_CHIEUCH							0x110E
#define U_HANGUL_CHOSEONG_KHIEUKH							0x110F
#define U_HANGUL_CHOSEONG_THIEUTH							0x1110
#define U_HANGUL_CHOSEONG_PHIEUPH							0x1111
#define U_HANGUL_CHOSEONG_HIEUH								0x1112
#define U_HANGUL_CHOSEONG_NIEUN_KIYEOK							0x1113
#define U_HANGUL_CHOSEONG_SSANGNIEUN							0x1114
#define U_HANGUL_CHOSEONG_NIEUN_TIKEUT							0x1115
#define U_HANGUL_CHOSEONG_NIEUN_PIEUP							0x1116
#define U_HANGUL_CHOSEONG_TIKEUT_KIYEOK							0x1117
#define U_HANGUL_CHOSEONG_RIEUL_NIEUN							0x1118
#define U_HANGUL_CHOSEONG_SSANGRIEUL							0x1119
#define U_HANGUL_CHOSEONG_RIEUL_HIEUH							0x111A
#define U_HANGUL_CHOSEONG_KAPYEOUNRIEUL							0x111B
#define U_HANGUL_CHOSEONG_MIEUM_PIEUP							0x111C
#define U_HANGUL_CHOSEONG_KAPYEOUNMIEUM							0x111D
#define U_HANGUL_CHOSEONG_PIEUP_KIYEOK							0x111E
#define U_HANGUL_CHOSEONG_PIEUP_NIEUN							0x111F
#define U_HANGUL_CHOSEONG_PIEUP_TIKEUT							0x1120
#define U_HANGUL_CHOSEONG_PIEUP_SIOS							0x1121
#define U_HANGUL_CHOSEONG_PIEUP_SIOS_KIYEOK						0x1122
#define U_HANGUL_CHOSEONG_PIEUP_SIOS_TIKEUT						0x1123
#define U_HANGUL_CHOSEONG_PIEUP_SIOS_PIEUP						0x1124
#define U_HANGUL_CHOSEONG_PIEUP_SSANGSIOS						0x1125
#define U_HANGUL_CHOSEONG_PIEUP_SIOS_CIEUC						0x1126
#define U_HANGUL_CHOSEONG_PIEUP_CIEUC							0x1127
#define U_HANGUL_CHOSEONG_PIEUP_CHIEUCH							0x1128
#define U_HANGUL_CHOSEONG_PIEUP_THIEUTH							0x1129
#define U_HANGUL_CHOSEONG_PIEUP_PHIEUPH							0x112A
#define U_HANGUL_CHOSEONG_KAPYEOUNPIEUP							0x112B
#define U_HANGUL_CHOSEONG_KAPYEOUNSSANGPIEUP						0x112C
#define U_HANGUL_CHOSEONG_SIOS_KIYEOK							0x112D
#define U_HANGUL_CHOSEONG_SIOS_NIEUN							0x112E
#define U_HANGUL_CHOSEONG_SIOS_TIKEUT							0x112F
#define U_HANGUL_CHOSEONG_SIOS_RIEUL							0x1130
#define U_HANGUL_CHOSEONG_SIOS_MIEUM							0x1131
#define U_HANGUL_CHOSEONG_SIOS_PIEUP							0x1132
#define U_HANGUL_CHOSEONG_SIOS_PIEUP_KIYEOK						0x1133
#define U_HANGUL_CHOSEONG_SIOS_SSANGSIOS						0x1134
#define U_HANGUL_CHOSEONG_SIOS_IEUNG							0x1135
#define U_HANGUL_CHOSEONG_SIOS_CIEUC							0x1136
#define U_HANGUL_CHOSEONG_SIOS_CHIEUCH							0x1137
#define U_HANGUL_CHOSEONG_SIOS_KHIEUKH							0x1138
#define U_HANGUL_CHOSEONG_SIOS_THIEUTH							0x1139
#define U_HANGUL_CHOSEONG_SIOS_PHIEUPH							0x113A
#define U_HANGUL_CHOSEONG_SIOS_HIEUH							0x113B
#define U_HANGUL_CHOSEONG_CHITUEUMSIOS							0x113C
#define U_HANGUL_CHOSEONG_CHITUEUMSSANGSIOS						0x113D
#define U_HANGUL_CHOSEONG_CEONGCHIEUMSIOS						0x113E
#define U_HANGUL_CHOSEONG_CEONGCHIEUMSSANGSIOS						0x113F
#define U_HANGUL_CHOSEONG_PANSIOS							0x1140
#define U_HANGUL_CHOSEONG_IEUNG_KIYEOK							0x1141
#define U_HANGUL_CHOSEONG_IEUNG_TIKEUT							0x1142
#define U_HANGUL_CHOSEONG_IEUNG_MIEUM							0x1143
#define U_HANGUL_CHOSEONG_IEUNG_PIEUP							0x1144
#define U_HANGUL_CHOSEONG_IEUNG_SIOS							0x1145
#define U_HANGUL_CHOSEONG_IEUNG_PANSIOS							0x1146
#define U_HANGUL_CHOSEONG_SSANGIEUNG							0x1147
#define U_HANGUL_CHOSEONG_IEUNG_CIEUC							0x1148
#define U_HANGUL_CHOSEONG_IEUNG_CHIEUCH							0x1149
#define U_HANGUL_CHOSEONG_IEUNG_THIEUTH							0x114A
#define U_HANGUL_CHOSEONG_IEUNG_PHIEUPH							0x114B
#define U_HANGUL_CHOSEONG_YESIEUNG							0x114C
#define U_HANGUL_CHOSEONG_CIEUC_IEUNG							0x114D
#define U_HANGUL_CHOSEONG_CHITUEUMCIEUC							0x114E
#define U_HANGUL_CHOSEONG_CHITUEUMSSANGCIEUC						0x114F
#define U_HANGUL_CHOSEONG_CEONGCHIEUMCIEUC						0x1150
#define U_HANGUL_CHOSEONG_CEONGCHIEUMSSANGCIEUC						0x1151
#define U_HANGUL_CHOSEONG_CHIEUCH_KHIEUKH						0x1152
#define U_HANGUL_CHOSEONG_CHIEUCH_HIEUH							0x1153
#define U_HANGUL_CHOSEONG_CHITUEUMCHIEUCH						0x1154
#define U_HANGUL_CHOSEONG_CEONGCHIEUMCHIEUCH						0x1155
#define U_HANGUL_CHOSEONG_PHIEUPH_PIEUP							0x1156
#define U_HANGUL_CHOSEONG_KAPYEOUNPHIEUPH						0x1157
#define U_HANGUL_CHOSEONG_SSANGHIEUH							0x1158
#define U_HANGUL_CHOSEONG_YEORINHIEUH							0x1159
#define U_HANGUL_CHOSEONG_FILLER							0x115F
#define U_HANGUL_JUNGSEONG_FILLER							0x1160
#define U_HANGUL_JUNGSEONG_A								0x1161
#define U_HANGUL_JUNGSEONG_AE								0x1162
#define U_HANGUL_JUNGSEONG_YA								0x1163
#define U_HANGUL_JUNGSEONG_YAE								0x1164
#define U_HANGUL_JUNGSEONG_EO								0x1165
#define U_HANGUL_JUNGSEONG_E								0x1166
#define U_HANGUL_JUNGSEONG_YEO								0x1167
#define U_HANGUL_JUNGSEONG_YE								0x1168
#define U_HANGUL_JUNGSEONG_O								0x1169
#define U_HANGUL_JUNGSEONG_WA								0x116A
#define U_HANGUL_JUNGSEONG_WAE								0x116B
#define U_HANGUL_JUNGSEONG_OE								0x116C
#define U_HANGUL_JUNGSEONG_YO								0x116D
#define U_HANGUL_JUNGSEONG_U								0x116E
#define U_HANGUL_JUNGSEONG_WEO								0x116F
#define U_HANGUL_JUNGSEONG_WE								0x1170
#define U_HANGUL_JUNGSEONG_WI								0x1171
#define U_HANGUL_JUNGSEONG_YU								0x1172
#define U_HANGUL_JUNGSEONG_EU								0x1173
#define U_HANGUL_JUNGSEONG_YI								0x1174
#define U_HANGUL_JUNGSEONG_I								0x1175
#define U_HANGUL_JUNGSEONG_A_O								0x1176
#define U_HANGUL_JUNGSEONG_A_U								0x1177
#define U_HANGUL_JUNGSEONG_YA_O								0x1178
#define U_HANGUL_JUNGSEONG_YA_YO							0x1179
#define U_HANGUL_JUNGSEONG_EO_O								0x117A
#define U_HANGUL_JUNGSEONG_EO_U								0x117B
#define U_HANGUL_JUNGSEONG_EO_EU							0x117C
#define U_HANGUL_JUNGSEONG_YEO_O							0x117D
#define U_HANGUL_JUNGSEONG_YEO_U							0x117E
#define U_HANGUL_JUNGSEONG_O_EO								0x117F
#define U_HANGUL_JUNGSEONG_O_E								0x1180
#define U_HANGUL_JUNGSEONG_O_YE								0x1181
#define U_HANGUL_JUNGSEONG_O_O								0x1182
#define U_HANGUL_JUNGSEONG_O_U								0x1183
#define U_HANGUL_JUNGSEONG_YO_YA							0x1184
#define U_HANGUL_JUNGSEONG_YO_YAE							0x1185
#define U_HANGUL_JUNGSEONG_YO_YEO							0x1186
#define U_HANGUL_JUNGSEONG_YO_O								0x1187
#define U_HANGUL_JUNGSEONG_YO_I								0x1188
#define U_HANGUL_JUNGSEONG_U_A								0x1189
#define U_HANGUL_JUNGSEONG_U_AE								0x118A
#define U_HANGUL_JUNGSEONG_U_EO_EU							0x118B
#define U_HANGUL_JUNGSEONG_U_YE								0x118C
#define U_HANGUL_JUNGSEONG_U_U								0x118D
#define U_HANGUL_JUNGSEONG_YU_A								0x118E
#define U_HANGUL_JUNGSEONG_YU_EO							0x118F
#define U_HANGUL_JUNGSEONG_YU_E								0x1190
#define U_HANGUL_JUNGSEONG_YU_YEO							0x1191
#define U_HANGUL_JUNGSEONG_YU_YE							0x1192
#define U_HANGUL_JUNGSEONG_YU_U								0x1193
#define U_HANGUL_JUNGSEONG_YU_I								0x1194
#define U_HANGUL_JUNGSEONG_EU_U								0x1195
#define U_HANGUL_JUNGSEONG_EU_EU							0x1196
#define U_HANGUL_JUNGSEONG_YI_U								0x1197
#define U_HANGUL_JUNGSEONG_I_A								0x1198
#define U_HANGUL_JUNGSEONG_I_YA								0x1199
#define U_HANGUL_JUNGSEONG_I_O								0x119A
#define U_HANGUL_JUNGSEONG_I_U								0x119B
#define U_HANGUL_JUNGSEONG_I_EU								0x119C
#define U_HANGUL_JUNGSEONG_I_ARAEA							0x119D
#define U_HANGUL_JUNGSEONG_ARAEA							0x119E
#define U_HANGUL_JUNGSEONG_ARAEA_EO							0x119F
#define U_HANGUL_JUNGSEONG_ARAEA_U							0x11A0
#define U_HANGUL_JUNGSEONG_ARAEA_I							0x11A1
#define U_HANGUL_JUNGSEONG_SSANGARAEA							0x11A2
#define U_HANGUL_JONGSEONG_KIYEOK							0x11A8
#define U_HANGUL_JONGSEONG_SSANGKIYEOK							0x11A9
#define U_HANGUL_JONGSEONG_KIYEOK_SIOS							0x11AA
#define U_HANGUL_JONGSEONG_NIEUN							0x11AB
#define U_HANGUL_JONGSEONG_NIEUN_CIEUC							0x11AC
#define U_HANGUL_JONGSEONG_NIEUN_HIEUH							0x11AD
#define U_HANGUL_JONGSEONG_TIKEUT							0x11AE
#define U_HANGUL_JONGSEONG_RIEUL							0x11AF
#define U_HANGUL_JONGSEONG_RIEUL_KIYEOK							0x11B0
#define U_HANGUL_JONGSEONG_RIEUL_MIEUM							0x11B1
#define U_HANGUL_JONGSEONG_RIEUL_PIEUP							0x11B2
#define U_HANGUL_JONGSEONG_RIEUL_SIOS							0x11B3
#define U_HANGUL_JONGSEONG_RIEUL_THIEUTH						0x11B4
#define U_HANGUL_JONGSEONG_RIEUL_PHIEUPH						0x11B5
#define U_HANGUL_JONGSEONG_RIEUL_HIEUH							0x11B6
#define U_HANGUL_JONGSEONG_MIEUM							0x11B7
#define U_HANGUL_JONGSEONG_PIEUP							0x11B8
#define U_HANGUL_JONGSEONG_PIEUP_SIOS							0x11B9
#define U_HANGUL_JONGSEONG_SIOS								0x11BA
#define U_HANGUL_JONGSEONG_SSANGSIOS							0x11BB
#define U_HANGUL_JONGSEONG_IEUNG							0x11BC
#define U_HANGUL_JONGSEONG_CIEUC							0x11BD
#define U_HANGUL_JONGSEONG_CHIEUCH							0x11BE
#define U_HANGUL_JONGSEONG_KHIEUKH							0x11BF
#define U_HANGUL_JONGSEONG_THIEUTH							0x11C0
#define U_HANGUL_JONGSEONG_PHIEUPH							0x11C1
#define U_HANGUL_JONGSEONG_HIEUH							0x11C2
#define U_HANGUL_JONGSEONG_KIYEOK_RIEUL							0x11C3
#define U_HANGUL_JONGSEONG_KIYEOK_SIOS_KIYEOK						0x11C4
#define U_HANGUL_JONGSEONG_NIEUN_KIYEOK							0x11C5
#define U_HANGUL_JONGSEONG_NIEUN_TIKEUT							0x11C6
#define U_HANGUL_JONGSEONG_NIEUN_SIOS							0x11C7
#define U_HANGUL_JONGSEONG_NIEUN_PANSIOS						0x11C8
#define U_HANGUL_JONGSEONG_NIEUN_THIEUTH						0x11C9
#define U_HANGUL_JONGSEONG_TIKEUT_KIYEOK						0x11CA
#define U_HANGUL_JONGSEONG_TIKEUT_RIEUL							0x11CB
#define U_HANGUL_JONGSEONG_RIEUL_KIYEOK_SIOS						0x11CC
#define U_HANGUL_JONGSEONG_RIEUL_NIEUN							0x11CD
#define U_HANGUL_JONGSEONG_RIEUL_TIKEUT							0x11CE
#define U_HANGUL_JONGSEONG_RIEUL_TIKEUT_HIEUH						0x11CF
#define U_HANGUL_JONGSEONG_SSANGRIEUL							0x11D0
#define U_HANGUL_JONGSEONG_RIEUL_MIEUM_KIYEOK						0x11D1
#define U_HANGUL_JONGSEONG_RIEUL_MIEUM_SIOS						0x11D2
#define U_HANGUL_JONGSEONG_RIEUL_PIEUP_SIOS						0x11D3
#define U_HANGUL_JONGSEONG_RIEUL_PIEUP_HIEUH						0x11D4
#define U_HANGUL_JONGSEONG_RIEUL_KAPYEOUNPIEUP						0x11D5
#define U_HANGUL_JONGSEONG_RIEUL_SSANGSIOS						0x11D6
#define U_HANGUL_JONGSEONG_RIEUL_PANSIOS						0x11D7
#define U_HANGUL_JONGSEONG_RIEUL_KHIEUKH						0x11D8
#define U_HANGUL_JONGSEONG_RIEUL_YEORINHIEUH						0x11D9
#define U_HANGUL_JONGSEONG_MIEUM_KIYEOK							0x11DA
#define U_HANGUL_JONGSEONG_MIEUM_RIEUL							0x11DB
#define U_HANGUL_JONGSEONG_MIEUM_PIEUP							0x11DC
#define U_HANGUL_JONGSEONG_MIEUM_SIOS							0x11DD
#define U_HANGUL_JONGSEONG_MIEUM_SSANGSIOS						0x11DE
#define U_HANGUL_JONGSEONG_MIEUM_PANSIOS						0x11DF
#define U_HANGUL_JONGSEONG_MIEUM_CHIEUCH						0x11E0
#define U_HANGUL_JONGSEONG_MIEUM_HIEUH							0x11E1
#define U_HANGUL_JONGSEONG_KAPYEOUNMIEUM						0x11E2
#define U_HANGUL_JONGSEONG_PIEUP_RIEUL							0x11E3
#define U_HANGUL_JONGSEONG_PIEUP_PHIEUPH						0x11E4
#define U_HANGUL_JONGSEONG_PIEUP_HIEUH							0x11E5
#define U_HANGUL_JONGSEONG_KAPYEOUNPIEUP						0x11E6
#define U_HANGUL_JONGSEONG_SIOS_KIYEOK							0x11E7
#define U_HANGUL_JONGSEONG_SIOS_TIKEUT							0x11E8
#define U_HANGUL_JONGSEONG_SIOS_RIEUL							0x11E9
#define U_HANGUL_JONGSEONG_SIOS_PIEUP							0x11EA
#define U_HANGUL_JONGSEONG_PANSIOS							0x11EB
#define U_HANGUL_JONGSEONG_IEUNG_KIYEOK							0x11EC
#define U_HANGUL_JONGSEONG_IEUNG_SSANGKIYEOK						0x11ED
#define U_HANGUL_JONGSEONG_SSANGIEUNG							0x11EE
#define U_HANGUL_JONGSEONG_IEUNG_KHIEUKH						0x11EF
#define U_HANGUL_JONGSEONG_YESIEUNG							0x11F0
#define U_HANGUL_JONGSEONG_YESIEUNG_SIOS						0x11F1
#define U_HANGUL_JONGSEONG_YESIEUNG_PANSIOS						0x11F2
#define U_HANGUL_JONGSEONG_PHIEUPH_PIEUP						0x11F3
#define U_HANGUL_JONGSEONG_KAPYEOUNPHIEUPH						0x11F4
#define U_HANGUL_JONGSEONG_HIEUH_NIEUN							0x11F5
#define U_HANGUL_JONGSEONG_HIEUH_RIEUL							0x11F6
#define U_HANGUL_JONGSEONG_HIEUH_MIEUM							0x11F7
#define U_HANGUL_JONGSEONG_HIEUH_PIEUP							0x11F8
#define U_HANGUL_JONGSEONG_YEORINHIEUH							0x11F9
#define U_LATIN_CAPITAL_LETTER_A_WITH_RING_BELOW					0x1E00
#define U_LATIN_SMALL_LETTER_A_WITH_RING_BELOW						0x1E01
#define U_LATIN_CAPITAL_LETTER_B_WITH_DOT_ABOVE						0x1E02
#define U_LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE						0x1E03
#define U_LATIN_CAPITAL_LETTER_B_WITH_DOT_BELOW						0x1E04
#define U_LATIN_SMALL_LETTER_B_WITH_DOT_BELOW						0x1E05
#define U_LATIN_CAPITAL_LETTER_B_WITH_LINE_BELOW					0x1E06
#define U_LATIN_SMALL_LETTER_B_WITH_LINE_BELOW						0x1E07
#define U_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA_AND_ACUTE					0x1E08
#define U_LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE					0x1E09
#define U_LATIN_CAPITAL_LETTER_D_WITH_DOT_ABOVE						0x1E0A
#define U_LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE						0x1E0B
#define U_LATIN_CAPITAL_LETTER_D_WITH_DOT_BELOW						0x1E0C
#define U_LATIN_SMALL_LETTER_D_WITH_DOT_BELOW						0x1E0D
#define U_LATIN_CAPITAL_LETTER_D_WITH_LINE_BELOW					0x1E0E
#define U_LATIN_SMALL_LETTER_D_WITH_LINE_BELOW						0x1E0F
#define U_LATIN_CAPITAL_LETTER_D_WITH_CEDILLA						0x1E10
#define U_LATIN_SMALL_LETTER_D_WITH_CEDILLA						0x1E11
#define U_LATIN_CAPITAL_LETTER_D_WITH_CIRCUMFLEX_BELOW					0x1E12
#define U_LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW					0x1E13
#define U_LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_GRAVE					0x1E14
#define U_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE					0x1E15
#define U_LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_ACUTE					0x1E16
#define U_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE					0x1E17
#define U_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_BELOW					0x1E18
#define U_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW					0x1E19
#define U_LATIN_CAPITAL_LETTER_E_WITH_TILDE_BELOW					0x1E1A
#define U_LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW						0x1E1B
#define U_LATIN_CAPITAL_LETTER_E_WITH_CEDILLA_AND_BREVE					0x1E1C
#define U_LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE					0x1E1D
#define U_LATIN_CAPITAL_LETTER_F_WITH_DOT_ABOVE						0x1E1E
#define U_LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE						0x1E1F
#define U_LATIN_CAPITAL_LETTER_G_WITH_MACRON						0x1E20
#define U_LATIN_SMALL_LETTER_G_WITH_MACRON						0x1E21
#define U_LATIN_CAPITAL_LETTER_H_WITH_DOT_ABOVE						0x1E22
#define U_LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE						0x1E23
#define U_LATIN_CAPITAL_LETTER_H_WITH_DOT_BELOW						0x1E24
#define U_LATIN_SMALL_LETTER_H_WITH_DOT_BELOW						0x1E25
#define U_LATIN_CAPITAL_LETTER_H_WITH_DIAERESIS						0x1E26
#define U_LATIN_SMALL_LETTER_H_WITH_DIAERESIS						0x1E27
#define U_LATIN_CAPITAL_LETTER_H_WITH_CEDILLA						0x1E28
#define U_LATIN_SMALL_LETTER_H_WITH_CEDILLA						0x1E29
#define U_LATIN_CAPITAL_LETTER_H_WITH_BREVE_BELOW					0x1E2A
#define U_LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW						0x1E2B
#define U_LATIN_CAPITAL_LETTER_I_WITH_TILDE_BELOW					0x1E2C
#define U_LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW						0x1E2D
#define U_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS_AND_ACUTE				0x1E2E
#define U_LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE					0x1E2F
#define U_LATIN_CAPITAL_LETTER_K_WITH_ACUTE						0x1E30
#define U_LATIN_SMALL_LETTER_K_WITH_ACUTE						0x1E31
#define U_LATIN_CAPITAL_LETTER_K_WITH_DOT_BELOW						0x1E32
#define U_LATIN_SMALL_LETTER_K_WITH_DOT_BELOW						0x1E33
#define U_LATIN_CAPITAL_LETTER_K_WITH_LINE_BELOW					0x1E34
#define U_LATIN_SMALL_LETTER_K_WITH_LINE_BELOW						0x1E35
#define U_LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW						0x1E36
#define U_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW						0x1E37
#define U_LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW_AND_MACRON				0x1E38
#define U_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON				0x1E39
#define U_LATIN_CAPITAL_LETTER_L_WITH_LINE_BELOW					0x1E3A
#define U_LATIN_SMALL_LETTER_L_WITH_LINE_BELOW						0x1E3B
#define U_LATIN_CAPITAL_LETTER_L_WITH_CIRCUMFLEX_BELOW					0x1E3C
#define U_LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW					0x1E3D
#define U_LATIN_CAPITAL_LETTER_M_WITH_ACUTE						0x1E3E
#define U_LATIN_SMALL_LETTER_M_WITH_ACUTE						0x1E3F
#define U_LATIN_CAPITAL_LETTER_M_WITH_DOT_ABOVE						0x1E40
#define U_LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE						0x1E41
#define U_LATIN_CAPITAL_LETTER_M_WITH_DOT_BELOW						0x1E42
#define U_LATIN_SMALL_LETTER_M_WITH_DOT_BELOW						0x1E43
#define U_LATIN_CAPITAL_LETTER_N_WITH_DOT_ABOVE						0x1E44
#define U_LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE						0x1E45
#define U_LATIN_CAPITAL_LETTER_N_WITH_DOT_BELOW						0x1E46
#define U_LATIN_SMALL_LETTER_N_WITH_DOT_BELOW						0x1E47
#define U_LATIN_CAPITAL_LETTER_N_WITH_LINE_BELOW					0x1E48
#define U_LATIN_SMALL_LETTER_N_WITH_LINE_BELOW						0x1E49
#define U_LATIN_CAPITAL_LETTER_N_WITH_CIRCUMFLEX_BELOW					0x1E4A
#define U_LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW					0x1E4B
#define U_LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_ACUTE					0x1E4C
#define U_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE					0x1E4D
#define U_LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_DIAERESIS				0x1E4E
#define U_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS					0x1E4F
#define U_LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_GRAVE					0x1E50
#define U_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE					0x1E51
#define U_LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_ACUTE					0x1E52
#define U_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE					0x1E53
#define U_LATIN_CAPITAL_LETTER_P_WITH_ACUTE						0x1E54
#define U_LATIN_SMALL_LETTER_P_WITH_ACUTE						0x1E55
#define U_LATIN_CAPITAL_LETTER_P_WITH_DOT_ABOVE						0x1E56
#define U_LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE						0x1E57
#define U_LATIN_CAPITAL_LETTER_R_WITH_DOT_ABOVE						0x1E58
#define U_LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE						0x1E59
#define U_LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW						0x1E5A
#define U_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW						0x1E5B
#define U_LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW_AND_MACRON				0x1E5C
#define U_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON				0x1E5D
#define U_LATIN_CAPITAL_LETTER_R_WITH_LINE_BELOW					0x1E5E
#define U_LATIN_SMALL_LETTER_R_WITH_LINE_BELOW						0x1E5F
#define U_LATIN_CAPITAL_LETTER_S_WITH_DOT_ABOVE						0x1E60
#define U_LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE						0x1E61
#define U_LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW						0x1E62
#define U_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW						0x1E63
#define U_LATIN_CAPITAL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE				0x1E64
#define U_LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE					0x1E65
#define U_LATIN_CAPITAL_LETTER_S_WITH_CARON_AND_DOT_ABOVE				0x1E66
#define U_LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE					0x1E67
#define U_LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE				0x1E68
#define U_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE				0x1E69
#define U_LATIN_CAPITAL_LETTER_T_WITH_DOT_ABOVE						0x1E6A
#define U_LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE						0x1E6B
#define U_LATIN_CAPITAL_LETTER_T_WITH_DOT_BELOW						0x1E6C
#define U_LATIN_SMALL_LETTER_T_WITH_DOT_BELOW						0x1E6D
#define U_LATIN_CAPITAL_LETTER_T_WITH_LINE_BELOW					0x1E6E
#define U_LATIN_SMALL_LETTER_T_WITH_LINE_BELOW						0x1E6F
#define U_LATIN_CAPITAL_LETTER_T_WITH_CIRCUMFLEX_BELOW					0x1E70
#define U_LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW					0x1E71
#define U_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_BELOW					0x1E72
#define U_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW					0x1E73
#define U_LATIN_CAPITAL_LETTER_U_WITH_TILDE_BELOW					0x1E74
#define U_LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW						0x1E75
#define U_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX_BELOW					0x1E76
#define U_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW					0x1E77
#define U_LATIN_CAPITAL_LETTER_U_WITH_TILDE_AND_ACUTE					0x1E78
#define U_LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE					0x1E79
#define U_LATIN_CAPITAL_LETTER_U_WITH_MACRON_AND_DIAERESIS				0x1E7A
#define U_LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS				0x1E7B
#define U_LATIN_CAPITAL_LETTER_V_WITH_TILDE						0x1E7C
#define U_LATIN_SMALL_LETTER_V_WITH_TILDE						0x1E7D
#define U_LATIN_CAPITAL_LETTER_V_WITH_DOT_BELOW						0x1E7E
#define U_LATIN_SMALL_LETTER_V_WITH_DOT_BELOW						0x1E7F
#define U_LATIN_CAPITAL_LETTER_W_WITH_GRAVE						0x1E80
#define U_LATIN_SMALL_LETTER_W_WITH_GRAVE						0x1E81
#define U_LATIN_CAPITAL_LETTER_W_WITH_ACUTE						0x1E82
#define U_LATIN_SMALL_LETTER_W_WITH_ACUTE						0x1E83
#define U_LATIN_CAPITAL_LETTER_W_WITH_DIAERESIS						0x1E84
#define U_LATIN_SMALL_LETTER_W_WITH_DIAERESIS						0x1E85
#define U_LATIN_CAPITAL_LETTER_W_WITH_DOT_ABOVE						0x1E86
#define U_LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE						0x1E87
#define U_LATIN_CAPITAL_LETTER_W_WITH_DOT_BELOW						0x1E88
#define U_LATIN_SMALL_LETTER_W_WITH_DOT_BELOW						0x1E89
#define U_LATIN_CAPITAL_LETTER_X_WITH_DOT_ABOVE						0x1E8A
#define U_LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE						0x1E8B
#define U_LATIN_CAPITAL_LETTER_X_WITH_DIAERESIS						0x1E8C
#define U_LATIN_SMALL_LETTER_X_WITH_DIAERESIS						0x1E8D
#define U_LATIN_CAPITAL_LETTER_Y_WITH_DOT_ABOVE						0x1E8E
#define U_LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE						0x1E8F
#define U_LATIN_CAPITAL_LETTER_Z_WITH_CIRCUMFLEX					0x1E90
#define U_LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX						0x1E91
#define U_LATIN_CAPITAL_LETTER_Z_WITH_DOT_BELOW						0x1E92
#define U_LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW						0x1E93
#define U_LATIN_CAPITAL_LETTER_Z_WITH_LINE_BELOW					0x1E94
#define U_LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW						0x1E95
#define U_LATIN_SMALL_LETTER_H_WITH_LINE_BELOW						0x1E96
#define U_LATIN_SMALL_LETTER_T_WITH_DIAERESIS						0x1E97
#define U_LATIN_SMALL_LETTER_W_WITH_RING_ABOVE						0x1E98
#define U_LATIN_SMALL_LETTER_Y_WITH_RING_ABOVE						0x1E99
#define U_LATIN_SMALL_LETTER_A_WITH_RIGHT_HALF_RING					0x1E9A
#define U_LATIN_SMALL_LETTER_LONG_S_WITH_DOT_ABOVE					0x1E9B
#define U_LATIN_CAPITAL_LETTER_A_WITH_DOT_BELOW						0x1EA0
#define U_LATIN_SMALL_LETTER_A_WITH_DOT_BELOW						0x1EA1
#define U_LATIN_CAPITAL_LETTER_A_WITH_HOOK_ABOVE					0x1EA2
#define U_LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE						0x1EA3
#define U_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE				0x1EA4
#define U_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE				0x1EA5
#define U_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE				0x1EA6
#define U_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE				0x1EA7
#define U_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE				0x1EA8
#define U_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE				0x1EA9
#define U_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE				0x1EAA
#define U_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE				0x1EAB
#define U_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW				0x1EAC
#define U_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW				0x1EAD
#define U_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_ACUTE					0x1EAE
#define U_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE					0x1EAF
#define U_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_GRAVE					0x1EB0
#define U_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE					0x1EB1
#define U_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE				0x1EB2
#define U_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE				0x1EB3
#define U_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_TILDE					0x1EB4
#define U_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE					0x1EB5
#define U_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_DOT_BELOW				0x1EB6
#define U_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW					0x1EB7
#define U_LATIN_CAPITAL_LETTER_E_WITH_DOT_BELOW						0x1EB8
#define U_LATIN_SMALL_LETTER_E_WITH_DOT_BELOW						0x1EB9
#define U_LATIN_CAPITAL_LETTER_E_WITH_HOOK_ABOVE					0x1EBA
#define U_LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE						0x1EBB
#define U_LATIN_CAPITAL_LETTER_E_WITH_TILDE						0x1EBC
#define U_LATIN_SMALL_LETTER_E_WITH_TILDE						0x1EBD
#define U_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE				0x1EBE
#define U_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE				0x1EBF
#define U_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE				0x1EC0
#define U_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE				0x1EC1
#define U_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE				0x1EC2
#define U_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE				0x1EC3
#define U_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE				0x1EC4
#define U_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE				0x1EC5
#define U_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW				0x1EC6
#define U_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW				0x1EC7
#define U_LATIN_CAPITAL_LETTER_I_WITH_HOOK_ABOVE					0x1EC8
#define U_LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE						0x1EC9
#define U_LATIN_CAPITAL_LETTER_I_WITH_DOT_BELOW						0x1ECA
#define U_LATIN_SMALL_LETTER_I_WITH_DOT_BELOW						0x1ECB
#define U_LATIN_CAPITAL_LETTER_O_WITH_DOT_BELOW						0x1ECC
#define U_LATIN_SMALL_LETTER_O_WITH_DOT_BELOW						0x1ECD
#define U_LATIN_CAPITAL_LETTER_O_WITH_HOOK_ABOVE					0x1ECE
#define U_LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE						0x1ECF
#define U_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE				0x1ED0
#define U_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE				0x1ED1
#define U_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE				0x1ED2
#define U_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE				0x1ED3
#define U_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE				0x1ED4
#define U_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE				0x1ED5
#define U_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE				0x1ED6
#define U_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE				0x1ED7
#define U_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW				0x1ED8
#define U_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW				0x1ED9
#define U_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_ACUTE					0x1EDA
#define U_LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE					0x1EDB
#define U_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_GRAVE					0x1EDC
#define U_LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE					0x1EDD
#define U_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE				0x1EDE
#define U_LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE					0x1EDF
#define U_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_TILDE					0x1EE0
#define U_LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE					0x1EE1
#define U_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_DOT_BELOW				0x1EE2
#define U_LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW					0x1EE3
#define U_LATIN_CAPITAL_LETTER_U_WITH_DOT_BELOW						0x1EE4
#define U_LATIN_SMALL_LETTER_U_WITH_DOT_BELOW						0x1EE5
#define U_LATIN_CAPITAL_LETTER_U_WITH_HOOK_ABOVE					0x1EE6
#define U_LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE						0x1EE7
#define U_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_ACUTE					0x1EE8
#define U_LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE					0x1EE9
#define U_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_GRAVE					0x1EEA
#define U_LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE					0x1EEB
#define U_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE				0x1EEC
#define U_LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE					0x1EED
#define U_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_TILDE					0x1EEE
#define U_LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE					0x1EEF
#define U_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_DOT_BELOW				0x1EF0
#define U_LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW					0x1EF1
#define U_LATIN_CAPITAL_LETTER_Y_WITH_GRAVE						0x1EF2
#define U_LATIN_SMALL_LETTER_Y_WITH_GRAVE						0x1EF3
#define U_LATIN_CAPITAL_LETTER_Y_WITH_DOT_BELOW						0x1EF4
#define U_LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW						0x1EF5
#define U_LATIN_CAPITAL_LETTER_Y_WITH_HOOK_ABOVE					0x1EF6
#define U_LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE						0x1EF7
#define U_LATIN_CAPITAL_LETTER_Y_WITH_TILDE						0x1EF8
#define U_LATIN_SMALL_LETTER_Y_WITH_TILDE						0x1EF9
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI						0x1F00
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA						0x1F01
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA					0x1F02
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA					0x1F03
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA					0x1F04
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA					0x1F05
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI				0x1F06
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI				0x1F07
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI						0x1F08
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA						0x1F09
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA				0x1F0A
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA				0x1F0B
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA				0x1F0C
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA				0x1F0D
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI				0x1F0E
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI				0x1F0F
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_PSILI						0x1F10
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_DASIA						0x1F11
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_VARIA				0x1F12
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_VARIA				0x1F13
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_OXIA				0x1F14
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_OXIA				0x1F15
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI					0x1F18
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA					0x1F19
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_VARIA				0x1F1A
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_VARIA				0x1F1B
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_OXIA				0x1F1C
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_OXIA				0x1F1D
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI						0x1F20
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA						0x1F21
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA					0x1F22
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA					0x1F23
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA					0x1F24
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA					0x1F25
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI				0x1F26
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI				0x1F27
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI						0x1F28
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA						0x1F29
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA					0x1F2A
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA					0x1F2B
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA					0x1F2C
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA					0x1F2D
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI				0x1F2E
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI				0x1F2F
#define U_GREEK_SMALL_LETTER_IOTA_WITH_PSILI						0x1F30
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DASIA						0x1F31
#define U_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA					0x1F32
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA					0x1F33
#define U_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA					0x1F34
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA					0x1F35
#define U_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI				0x1F36
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI				0x1F37
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI						0x1F38
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA						0x1F39
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_VARIA				0x1F3A
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_VARIA				0x1F3B
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_OXIA					0x1F3C
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_OXIA					0x1F3D
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI				0x1F3E
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI				0x1F3F
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_PSILI						0x1F40
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_DASIA						0x1F41
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_VARIA				0x1F42
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_VARIA				0x1F43
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_OXIA				0x1F44
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_OXIA				0x1F45
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI					0x1F48
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA					0x1F49
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_VARIA				0x1F4A
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_VARIA				0x1F4B
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_OXIA				0x1F4C
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_OXIA				0x1F4D
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI						0x1F50
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA						0x1F51
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA				0x1F52
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA				0x1F53
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA				0x1F54
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA				0x1F55
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_PERISPOMENI				0x1F56
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI				0x1F57
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA					0x1F59
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_VARIA				0x1F5B
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_OXIA				0x1F5D
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI			0x1F5F
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI						0x1F60
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA						0x1F61
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA					0x1F62
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA					0x1F63
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA					0x1F64
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA					0x1F65
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI				0x1F66
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI				0x1F67
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI						0x1F68
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA						0x1F69
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA				0x1F6A
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA				0x1F6B
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA				0x1F6C
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA				0x1F6D
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI				0x1F6E
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI				0x1F6F
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_VARIA						0x1F70
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_OXIA						0x1F71
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_VARIA						0x1F72
#define U_GREEK_SMALL_LETTER_EPSILON_WITH_OXIA						0x1F73
#define U_GREEK_SMALL_LETTER_ETA_WITH_VARIA						0x1F74
#define U_GREEK_SMALL_LETTER_ETA_WITH_OXIA						0x1F75
#define U_GREEK_SMALL_LETTER_IOTA_WITH_VARIA						0x1F76
#define U_GREEK_SMALL_LETTER_IOTA_WITH_OXIA						0x1F77
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_VARIA						0x1F78
#define U_GREEK_SMALL_LETTER_OMICRON_WITH_OXIA						0x1F79
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_VARIA						0x1F7A
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_OXIA						0x1F7B
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_VARIA						0x1F7C
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_OXIA						0x1F7D
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_YPOGEGRAMMENI				0x1F80
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_YPOGEGRAMMENI				0x1F81
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI		0x1F82
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI		0x1F83
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI		0x1F84
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI		0x1F85
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI		0x1F86
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI		0x1F87
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PROSGEGRAMMENI			0x1F88
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PROSGEGRAMMENI			0x1F89
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI		0x1F8A
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI		0x1F8B
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI		0x1F8C
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI		0x1F8D
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F8E
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F8F
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_YPOGEGRAMMENI				0x1F90
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_YPOGEGRAMMENI				0x1F91
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI			0x1F92
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI			0x1F93
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI			0x1F94
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI			0x1F95
#define U_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI		0x1F96
#define U_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI		0x1F97
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PROSGEGRAMMENI			0x1F98
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PROSGEGRAMMENI			0x1F99
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI		0x1F9A
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI		0x1F9B
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI		0x1F9C
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI		0x1F9D
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F9E
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F9F
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_YPOGEGRAMMENI				0x1FA0
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_YPOGEGRAMMENI				0x1FA1
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI		0x1FA2
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI		0x1FA3
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI		0x1FA4
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI		0x1FA5
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI		0x1FA6
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI		0x1FA7
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PROSGEGRAMMENI			0x1FA8
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PROSGEGRAMMENI			0x1FA9
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI		0x1FAA
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI		0x1FAB
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI		0x1FAC
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI		0x1FAD
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1FAE
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1FAF
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_VRACHY						0x1FB0
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_MACRON						0x1FB1
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_YPOGEGRAMMENI				0x1FB2
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_YPOGEGRAMMENI					0x1FB3
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_YPOGEGRAMMENI				0x1FB4
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI					0x1FB6
#define U_GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI			0x1FB7
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_VRACHY					0x1FB8
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_MACRON					0x1FB9
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_VARIA						0x1FBA
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_OXIA						0x1FBB
#define U_GREEK_CAPITAL_LETTER_ALPHA_WITH_PROSGEGRAMMENI				0x1FBC
#define U_GREEK_KORONIS									0x1FBD
#define U_GREEK_PROSGEGRAMMENI								0x1FBE
#define U_GREEK_PSILI									0x1FBF
#define U_GREEK_PERISPOMENI								0x1FC0
#define U_GREEK_DIALYTIKA_AND_PERISPOMENI						0x1FC1
#define U_GREEK_SMALL_LETTER_ETA_WITH_VARIA_AND_YPOGEGRAMMENI				0x1FC2
#define U_GREEK_SMALL_LETTER_ETA_WITH_YPOGEGRAMMENI					0x1FC3
#define U_GREEK_SMALL_LETTER_ETA_WITH_OXIA_AND_YPOGEGRAMMENI				0x1FC4
#define U_GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI					0x1FC6
#define U_GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI			0x1FC7
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_VARIA					0x1FC8
#define U_GREEK_CAPITAL_LETTER_EPSILON_WITH_OXIA					0x1FC9
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_VARIA						0x1FCA
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_OXIA						0x1FCB
#define U_GREEK_CAPITAL_LETTER_ETA_WITH_PROSGEGRAMMENI					0x1FCC
#define U_GREEK_PSILI_AND_VARIA								0x1FCD
#define U_GREEK_PSILI_AND_OXIA								0x1FCE
#define U_GREEK_PSILI_AND_PERISPOMENI							0x1FCF
#define U_GREEK_SMALL_LETTER_IOTA_WITH_VRACHY						0x1FD0
#define U_GREEK_SMALL_LETTER_IOTA_WITH_MACRON						0x1FD1
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_VARIA				0x1FD2
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_OXIA				0x1FD3
#define U_GREEK_SMALL_LETTER_IOTA_WITH_PERISPOMENI					0x1FD6
#define U_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_PERISPOMENI			0x1FD7
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_VRACHY						0x1FD8
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_MACRON						0x1FD9
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_VARIA						0x1FDA
#define U_GREEK_CAPITAL_LETTER_IOTA_WITH_OXIA						0x1FDB
#define U_GREEK_DASIA_AND_VARIA								0x1FDD
#define U_GREEK_DASIA_AND_OXIA								0x1FDE
#define U_GREEK_DASIA_AND_PERISPOMENI							0x1FDF
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_VRACHY					0x1FE0
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_MACRON					0x1FE1
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_VARIA				0x1FE2
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_OXIA				0x1FE3
#define U_GREEK_SMALL_LETTER_RHO_WITH_PSILI						0x1FE4
#define U_GREEK_SMALL_LETTER_RHO_WITH_DASIA						0x1FE5
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_PERISPOMENI					0x1FE6
#define U_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_PERISPOMENI			0x1FE7
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_VRACHY					0x1FE8
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_MACRON					0x1FE9
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_VARIA					0x1FEA
#define U_GREEK_CAPITAL_LETTER_UPSILON_WITH_OXIA					0x1FEB
#define U_GREEK_CAPITAL_LETTER_RHO_WITH_DASIA						0x1FEC
#define U_GREEK_DIALYTIKA_AND_VARIA							0x1FED
#define U_GREEK_DIALYTIKA_AND_OXIA							0x1FEE
#define U_GREEK_VARIA									0x1FEF
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_VARIA_AND_YPOGEGRAMMENI				0x1FF2
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_YPOGEGRAMMENI					0x1FF3
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_OXIA_AND_YPOGEGRAMMENI				0x1FF4
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI					0x1FF6
#define U_GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI			0x1FF7
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_VARIA					0x1FF8
#define U_GREEK_CAPITAL_LETTER_OMICRON_WITH_OXIA					0x1FF9
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_VARIA						0x1FFA
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_OXIA						0x1FFB
#define U_GREEK_CAPITAL_LETTER_OMEGA_WITH_PROSGEGRAMMENI				0x1FFC
#define U_GREEK_OXIA									0x1FFD
#define U_GREEK_DASIA									0x1FFE
#define U_EN_QUAD									0x2000
#define U_EM_QUAD									0x2001
#define U_EN_SPACE									0x2002
#define U_EM_SPACE									0x2003
#define U_THREE_PER_EM_SPACE								0x2004
#define U_FOUR_PER_EM_SPACE								0x2005
#define U_SIX_PER_EM_SPACE								0x2006
#define U_FIGURE_SPACE									0x2007
#define U_PUNCTUATION_SPACE								0x2008
#define U_THIN_SPACE									0x2009
#define U_HAIR_SPACE									0x200A
#define U_ZERO_WIDTH_SPACE								0x200B
#define U_ZERO_WIDTH_NON_JOINER								0x200C
#define U_ZERO_WIDTH_JOINER								0x200D
#define U_LEFT_TO_RIGHT_MARK								0x200E
#define U_RIGHT_TO_LEFT_MARK								0x200F
#define U_HYPHEN									0x2010
#define U_NON_BREAKING_HYPHEN								0x2011
#define U_FIGURE_DASH									0x2012
#define U_EN_DASH									0x2013
#define U_EM_DASH									0x2014
#define U_HORIZONTAL_BAR								0x2015
#define U_DOUBLE_VERTICAL_LINE								0x2016
#define U_DOUBLE_LOW_LINE								0x2017
#define U_LEFT_SINGLE_QUOTATION_MARK							0x2018
#define U_RIGHT_SINGLE_QUOTATION_MARK							0x2019
#define U_SINGLE_LOW_NINE_QUOTATION_MARK						0x201A
#define U_SINGLE_HIGH_REVERSED_NINE_QUOTATION_MARK					0x201B
#define U_LEFT_DOUBLE_QUOTATION_MARK							0x201C
#define U_RIGHT_DOUBLE_QUOTATION_MARK							0x201D
#define U_DOUBLE_LOW_NINE_QUOTATION_MARK						0x201E
#define U_DOUBLE_HIGH_REVERSED_NINE_QUOTATION_MARK					0x201F
#define U_DAGGER									0x2020
#define U_DOUBLE_DAGGER									0x2021
#define U_BULLET									0x2022
#define U_TRIANGULAR_BULLET								0x2023
#define U_ONE_DOT_LEADER								0x2024
#define U_TWO_DOT_LEADER								0x2025
#define U_HORIZONTAL_ELLIPSIS								0x2026
#define U_HYPHENATION_POINT								0x2027
#define U_LINE_SEPARATOR								0x2028
#define U_PARAGRAPH_SEPARATOR								0x2029
#define U_LEFT_TO_RIGHT_EMBEDDING							0x202A
#define U_RIGHT_TO_LEFT_EMBEDDING							0x202B
#define U_POP_DIRECTIONAL_FORMATTING							0x202C
#define U_LEFT_TO_RIGHT_OVERRIDE							0x202D
#define U_RIGHT_TO_LEFT_OVERRIDE							0x202E
#define U_PER_MILLE_SIGN								0x2030
#define U_PER_TEN_THOUSAND_SIGN								0x2031
#define U_PRIME										0x2032
#define U_DOUBLE_PRIME									0x2033
#define U_TRIPLE_PRIME									0x2034
#define U_REVERSED_PRIME								0x2035
#define U_REVERSED_DOUBLE_PRIME								0x2036
#define U_REVERSED_TRIPLE_PRIME								0x2037
#define U_CARET										0x2038
#define U_SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK					0x2039
#define U_SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK					0x203A
#define U_REFERENCE_MARK								0x203B
#define U_DOUBLE_EXCLAMATION_MARK							0x203C
#define U_INTERROBANG									0x203D
#define U_OVERLINE									0x203E
#define U_UNDERTIE									0x203F
#define U_CHARACTER_TIE									0x2040
#define U_CARET_INSERTION_POINT								0x2041
#define U_ASTERISM									0x2042
#define U_HYPHEN_BULLET									0x2043
#define U_FRACTION_SLASH								0x2044
#define U_LEFT_SQUARE_BRACKET_WITH_QUILL						0x2045
#define U_RIGHT_SQUARE_BRACKET_WITH_QUILL						0x2046
#define U_INHIBIT_SYMMETRIC_SWAPPING							0x206A
#define U_ACTIVATE_SYMMETRIC_SWAPPING							0x206B
#define U_INHIBIT_ARABIC_FORM_SHAPING							0x206C
#define U_ACTIVATE_ARABIC_FORM_SHAPING							0x206D
#define U_NATIONAL_DIGIT_SHAPES								0x206E
#define U_NOMINAL_DIGIT_SHAPES								0x206F
#define U_SUPERSCRIPT_ZERO								0x2070
#define U_SUPERSCRIPT_FOUR								0x2074
#define U_SUPERSCRIPT_FIVE								0x2075
#define U_SUPERSCRIPT_SIX								0x2076
#define U_SUPERSCRIPT_SEVEN								0x2077
#define U_SUPERSCRIPT_EIGHT								0x2078
#define U_SUPERSCRIPT_NINE								0x2079
#define U_SUPERSCRIPT_PLUS_SIGN								0x207A
#define U_SUPERSCRIPT_MINUS								0x207B
#define U_SUPERSCRIPT_EQUALS_SIGN							0x207C
#define U_SUPERSCRIPT_LEFT_PARENTHESIS							0x207D
#define U_SUPERSCRIPT_RIGHT_PARENTHESIS							0x207E
#define U_SUPERSCRIPT_LATIN_SMALL_LETTER_N						0x207F
#define U_SUBSCRIPT_ZERO								0x2080
#define U_SUBSCRIPT_ONE									0x2081
#define U_SUBSCRIPT_TWO									0x2082
#define U_SUBSCRIPT_THREE								0x2083
#define U_SUBSCRIPT_FOUR								0x2084
#define U_SUBSCRIPT_FIVE								0x2085
#define U_SUBSCRIPT_SIX									0x2086
#define U_SUBSCRIPT_SEVEN								0x2087
#define U_SUBSCRIPT_EIGHT								0x2088
#define U_SUBSCRIPT_NINE								0x2089
#define U_SUBSCRIPT_PLUS_SIGN								0x208A
#define U_SUBSCRIPT_MINUS								0x208B
#define U_SUBSCRIPT_EQUALS_SIGN								0x208C
#define U_SUBSCRIPT_LEFT_PARENTHESIS							0x208D
#define U_SUBSCRIPT_RIGHT_PARENTHESIS							0x208E
#define U_EURO_CURRENCY_SIGN								0x20A0
#define U_COLON_SIGN									0x20A1
#define U_CRUZEIRO_SIGN									0x20A2
#define U_FRENCH_FRANC_SIGN								0x20A3
#define U_LIRA_SIGN									0x20A4
#define U_MILL_SIGN									0x20A5
#define U_NAIRA_SIGN									0x20A6
#define U_PESETA_SIGN									0x20A7
#define U_RUPEE_SIGN									0x20A8
#define U_WON_SIGN									0x20A9
#define U_NEW_SHEQEL_SIGN								0x20AA
#define U_DONG_SIGN									0x20AB
#define U_EURO_SIGN									0x20AC
#define U_COMBINING_LEFT_HARPOON_ABOVE							0x20D0
#define U_COMBINING_RIGHT_HARPOON_ABOVE							0x20D1
#define U_COMBINING_LONG_VERTICAL_LINE_OVERLAY						0x20D2
#define U_COMBINING_SHORT_VERTICAL_LINE_OVERLAY						0x20D3
#define U_COMBINING_ANTICLOCKWISE_ARROW_ABOVE						0x20D4
#define U_COMBINING_CLOCKWISE_ARROW_ABOVE						0x20D5
#define U_COMBINING_LEFT_ARROW_ABOVE							0x20D6
#define U_COMBINING_RIGHT_ARROW_ABOVE							0x20D7
#define U_COMBINING_RING_OVERLAY							0x20D8
#define U_COMBINING_CLOCKWISE_RING_OVERLAY						0x20D9
#define U_COMBINING_ANTICLOCKWISE_RING_OVERLAY						0x20DA
#define U_COMBINING_THREE_DOTS_ABOVE							0x20DB
#define U_COMBINING_FOUR_DOTS_ABOVE							0x20DC
#define U_COMBINING_ENCLOSING_CIRCLE							0x20DD
#define U_COMBINING_ENCLOSING_SQUARE							0x20DE
#define U_COMBINING_ENCLOSING_DIAMOND							0x20DF
#define U_COMBINING_ENCLOSING_CIRCLE_BACKSLASH						0x20E0
#define U_COMBINING_LEFT_RIGHT_ARROW_ABOVE						0x20E1
#define U_ACCOUNT_OF									0x2100
#define U_ADDRESSED_TO_THE_SUBJECT							0x2101
#define U_DOUBLE_STRUCK_CAPITAL_C							0x2102
#define U_DEGREE_CELSIUS								0x2103
#define U_CENTRE_LINE_SYMBOL								0x2104
#define U_CARE_OF									0x2105
#define U_CADA_UNA									0x2106
#define U_EULER_CONSTANT								0x2107
#define U_SCRUPLE									0x2108
#define U_DEGREE_FAHRENHEIT								0x2109
#define U_SCRIPT_SMALL_G								0x210A
#define U_SCRIPT_CAPITAL_H								0x210B
#define U_BLACK_LETTER_CAPITAL_H							0x210C
#define U_DOUBLE_STRUCK_CAPITAL_H							0x210D
#define U_PLANCK_CONSTANT								0x210E
#define U_PLANCK_CONSTANT_OVER_TWO_PI							0x210F
#define U_SCRIPT_CAPITAL_I								0x2110
#define U_BLACK_LETTER_CAPITAL_I							0x2111
#define U_SCRIPT_CAPITAL_L								0x2112
#define U_SCRIPT_SMALL_L								0x2113
#define U_L_B_BAR_SYMBOL								0x2114
#define U_DOUBLE_STRUCK_CAPITAL_N							0x2115
#define U_NUMERO_SIGN									0x2116
#define U_SOUND_RECORDING_COPYRIGHT							0x2117
#define U_SCRIPT_CAPITAL_P								0x2118
#define U_DOUBLE_STRUCK_CAPITAL_P							0x2119
#define U_DOUBLE_STRUCK_CAPITAL_Q							0x211A
#define U_SCRIPT_CAPITAL_R								0x211B
#define U_BLACK_LETTER_CAPITAL_R							0x211C
#define U_DOUBLE_STRUCK_CAPITAL_R							0x211D
#define U_PRESCRIPTION_TAKE								0x211E
#define U_RESPONSE									0x211F
#define U_SERVICE_MARK									0x2120
#define U_TELEPHONE_SIGN								0x2121
#define U_TRADE_MARK_SIGN								0x2122
#define U_VERSICLE									0x2123
#define U_DOUBLE_STRUCK_CAPITAL_Z							0x2124
#define U_OUNCE_SIGN									0x2125
#define U_OHM_SIGN									0x2126
#define U_INVERTED_OHM_SIGN								0x2127
#define U_BLACK_LETTER_CAPITAL_Z							0x2128
#define U_TURNED_GREEK_SMALL_LETTER_IOTA						0x2129
#define U_KELVIN_SIGN									0x212A
#define U_ANGSTROM_SIGN									0x212B
#define U_SCRIPT_CAPITAL_B								0x212C
#define U_BLACK_LETTER_CAPITAL_C							0x212D
#define U_ESTIMATED_SYMBOL								0x212E
#define U_SCRIPT_SMALL_E								0x212F
#define U_SCRIPT_CAPITAL_E								0x2130
#define U_SCRIPT_CAPITAL_F								0x2131
#define U_TURNED_CAPITAL_F								0x2132
#define U_SCRIPT_CAPITAL_M								0x2133
#define U_SCRIPT_SMALL_O								0x2134
#define U_ALEF_SYMBOL									0x2135
#define U_BET_SYMBOL									0x2136
#define U_GIMEL_SYMBOL									0x2137
#define U_DALET_SYMBOL									0x2138
#define U_VULGAR_FRACTION_ONE_THIRD							0x2153
#define U_VULGAR_FRACTION_TWO_THIRDS							0x2154
#define U_VULGAR_FRACTION_ONE_FIFTH							0x2155
#define U_VULGAR_FRACTION_TWO_FIFTHS							0x2156
#define U_VULGAR_FRACTION_THREE_FIFTHS							0x2157
#define U_VULGAR_FRACTION_FOUR_FIFTHS							0x2158
#define U_VULGAR_FRACTION_ONE_SIXTH							0x2159
#define U_VULGAR_FRACTION_FIVE_SIXTHS							0x215A
#define U_VULGAR_FRACTION_ONE_EIGHTH							0x215B
#define U_VULGAR_FRACTION_THREE_EIGHTHS							0x215C
#define U_VULGAR_FRACTION_FIVE_EIGHTHS							0x215D
#define U_VULGAR_FRACTION_SEVEN_EIGHTHS							0x215E
#define U_FRACTION_NUMERATOR_ONE							0x215F
#define U_ROMAN_NUMERAL_ONE								0x2160
#define U_ROMAN_NUMERAL_TWO								0x2161
#define U_ROMAN_NUMERAL_THREE								0x2162
#define U_ROMAN_NUMERAL_FOUR								0x2163
#define U_ROMAN_NUMERAL_FIVE								0x2164
#define U_ROMAN_NUMERAL_SIX								0x2165
#define U_ROMAN_NUMERAL_SEVEN								0x2166
#define U_ROMAN_NUMERAL_EIGHT								0x2167
#define U_ROMAN_NUMERAL_NINE								0x2168
#define U_ROMAN_NUMERAL_TEN								0x2169
#define U_ROMAN_NUMERAL_ELEVEN								0x216A
#define U_ROMAN_NUMERAL_TWELVE								0x216B
#define U_ROMAN_NUMERAL_FIFTY								0x216C
#define U_ROMAN_NUMERAL_ONE_HUNDRED							0x216D
#define U_ROMAN_NUMERAL_FIVE_HUNDRED							0x216E
#define U_ROMAN_NUMERAL_ONE_THOUSAND							0x216F
#define U_SMALL_ROMAN_NUMERAL_ONE							0x2170
#define U_SMALL_ROMAN_NUMERAL_TWO							0x2171
#define U_SMALL_ROMAN_NUMERAL_THREE							0x2172
#define U_SMALL_ROMAN_NUMERAL_FOUR							0x2173
#define U_SMALL_ROMAN_NUMERAL_FIVE							0x2174
#define U_SMALL_ROMAN_NUMERAL_SIX							0x2175
#define U_SMALL_ROMAN_NUMERAL_SEVEN							0x2176
#define U_SMALL_ROMAN_NUMERAL_EIGHT							0x2177
#define U_SMALL_ROMAN_NUMERAL_NINE							0x2178
#define U_SMALL_ROMAN_NUMERAL_TEN							0x2179
#define U_SMALL_ROMAN_NUMERAL_ELEVEN							0x217A
#define U_SMALL_ROMAN_NUMERAL_TWELVE							0x217B
#define U_SMALL_ROMAN_NUMERAL_FIFTY							0x217C
#define U_SMALL_ROMAN_NUMERAL_ONE_HUNDRED						0x217D
#define U_SMALL_ROMAN_NUMERAL_FIVE_HUNDRED						0x217E
#define U_SMALL_ROMAN_NUMERAL_ONE_THOUSAND						0x217F
#define U_ROMAN_NUMERAL_ONE_THOUSAND_C_D						0x2180
#define U_ROMAN_NUMERAL_FIVE_THOUSAND							0x2181
#define U_ROMAN_NUMERAL_TEN_THOUSAND							0x2182
#define U_LEFTWARDS_ARROW								0x2190
#define U_UPWARDS_ARROW									0x2191
#define U_RIGHTWARDS_ARROW								0x2192
#define U_DOWNWARDS_ARROW								0x2193
#define U_LEFT_RIGHT_ARROW								0x2194
#define U_UP_DOWN_ARROW									0x2195
#define U_NORTH_WEST_ARROW								0x2196
#define U_NORTH_EAST_ARROW								0x2197
#define U_SOUTH_EAST_ARROW								0x2198
#define U_SOUTH_WEST_ARROW								0x2199
#define U_LEFTWARDS_ARROW_WITH_STROKE							0x219A
#define U_RIGHTWARDS_ARROW_WITH_STROKE							0x219B
#define U_LEFTWARDS_WAVE_ARROW								0x219C
#define U_RIGHTWARDS_WAVE_ARROW								0x219D
#define U_LEFTWARDS_TWO_HEADED_ARROW							0x219E
#define U_UPWARDS_TWO_HEADED_ARROW							0x219F
#define U_RIGHTWARDS_TWO_HEADED_ARROW							0x21A0
#define U_DOWNWARDS_TWO_HEADED_ARROW							0x21A1
#define U_LEFTWARDS_ARROW_WITH_TAIL							0x21A2
#define U_RIGHTWARDS_ARROW_WITH_TAIL							0x21A3
#define U_LEFTWARDS_ARROW_FROM_BAR							0x21A4
#define U_UPWARDS_ARROW_FROM_BAR							0x21A5
#define U_RIGHTWARDS_ARROW_FROM_BAR							0x21A6
#define U_DOWNWARDS_ARROW_FROM_BAR							0x21A7
#define U_UP_DOWN_ARROW_WITH_BASE							0x21A8
#define U_LEFTWARDS_ARROW_WITH_HOOK							0x21A9
#define U_RIGHTWARDS_ARROW_WITH_HOOK							0x21AA
#define U_LEFTWARDS_ARROW_WITH_LOOP							0x21AB
#define U_RIGHTWARDS_ARROW_WITH_LOOP							0x21AC
#define U_LEFT_RIGHT_WAVE_ARROW								0x21AD
#define U_LEFT_RIGHT_ARROW_WITH_STROKE							0x21AE
#define U_DOWNWARDS_ZIGZAG_ARROW							0x21AF
#define U_UPWARDS_ARROW_WITH_TIP_LEFTWARDS						0x21B0
#define U_UPWARDS_ARROW_WITH_TIP_RIGHTWARDS						0x21B1
#define U_DOWNWARDS_ARROW_WITH_TIP_LEFTWARDS						0x21B2
#define U_DOWNWARDS_ARROW_WITH_TIP_RIGHTWARDS						0x21B3
#define U_RIGHTWARDS_ARROW_WITH_CORNER_DOWNWARDS					0x21B4
#define U_DOWNWARDS_ARROW_WITH_CORNER_LEFTWARDS						0x21B5
#define U_ANTICLOCKWISE_TOP_SEMICIRCLE_ARROW						0x21B6
#define U_CLOCKWISE_TOP_SEMICIRCLE_ARROW						0x21B7
#define U_NORTH_WEST_ARROW_TO_LONG_BAR							0x21B8
#define U_LEFTWARDS_ARROW_TO_BAR_OVER_RIGHTWARDS_ARROW_TO_BAR				0x21B9
#define U_ANTICLOCKWISE_OPEN_CIRCLE_ARROW						0x21BA
#define U_CLOCKWISE_OPEN_CIRCLE_ARROW							0x21BB
#define U_LEFTWARDS_HARPOON_WITH_BARB_UPWARDS						0x21BC
#define U_LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS						0x21BD
#define U_UPWARDS_HARPOON_WITH_BARB_RIGHTWARDS						0x21BE
#define U_UPWARDS_HARPOON_WITH_BARB_LEFTWARDS						0x21BF
#define U_RIGHTWARDS_HARPOON_WITH_BARB_UPWARDS						0x21C0
#define U_RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS					0x21C1
#define U_DOWNWARDS_HARPOON_WITH_BARB_RIGHTWARDS					0x21C2
#define U_DOWNWARDS_HARPOON_WITH_BARB_LEFTWARDS						0x21C3
#define U_RIGHTWARDS_ARROW_OVER_LEFTWARDS_ARROW						0x21C4
#define U_UPWARDS_ARROW_LEFTWARDS_OF_DOWNWARDS_ARROW					0x21C5
#define U_LEFTWARDS_ARROW_OVER_RIGHTWARDS_ARROW						0x21C6
#define U_LEFTWARDS_PAIRED_ARROWS							0x21C7
#define U_UPWARDS_PAIRED_ARROWS								0x21C8
#define U_RIGHTWARDS_PAIRED_ARROWS							0x21C9
#define U_DOWNWARDS_PAIRED_ARROWS							0x21CA
#define U_LEFTWARDS_HARPOON_OVER_RIGHTWARDS_HARPOON					0x21CB
#define U_RIGHTWARDS_HARPOON_OVER_LEFTWARDS_HARPOON					0x21CC
#define U_LEFTWARDS_DOUBLE_ARROW_WITH_STROKE						0x21CD
#define U_LEFT_RIGHT_DOUBLE_ARROW_WITH_STROKE						0x21CE
#define U_RIGHTWARDS_DOUBLE_ARROW_WITH_STROKE						0x21CF
#define U_LEFTWARDS_DOUBLE_ARROW							0x21D0
#define U_UPWARDS_DOUBLE_ARROW								0x21D1
#define U_RIGHTWARDS_DOUBLE_ARROW							0x21D2
#define U_DOWNWARDS_DOUBLE_ARROW							0x21D3
#define U_LEFT_RIGHT_DOUBLE_ARROW							0x21D4
#define U_UP_DOWN_DOUBLE_ARROW								0x21D5
#define U_NORTH_WEST_DOUBLE_ARROW							0x21D6
#define U_NORTH_EAST_DOUBLE_ARROW							0x21D7
#define U_SOUTH_EAST_DOUBLE_ARROW							0x21D8
#define U_SOUTH_WEST_DOUBLE_ARROW							0x21D9
#define U_LEFTWARDS_TRIPLE_ARROW							0x21DA
#define U_RIGHTWARDS_TRIPLE_ARROW							0x21DB
#define U_LEFTWARDS_SQUIGGLE_ARROW							0x21DC
#define U_RIGHTWARDS_SQUIGGLE_ARROW							0x21DD
#define U_UPWARDS_ARROW_WITH_DOUBLE_STROKE						0x21DE
#define U_DOWNWARDS_ARROW_WITH_DOUBLE_STROKE						0x21DF
#define U_LEFTWARDS_DASHED_ARROW							0x21E0
#define U_UPWARDS_DASHED_ARROW								0x21E1
#define U_RIGHTWARDS_DASHED_ARROW							0x21E2
#define U_DOWNWARDS_DASHED_ARROW							0x21E3
#define U_LEFTWARDS_ARROW_TO_BAR							0x21E4
#define U_RIGHTWARDS_ARROW_TO_BAR							0x21E5
#define U_LEFTWARDS_WHITE_ARROW								0x21E6
#define U_UPWARDS_WHITE_ARROW								0x21E7
#define U_RIGHTWARDS_WHITE_ARROW							0x21E8
#define U_DOWNWARDS_WHITE_ARROW								0x21E9
#define U_UPWARDS_WHITE_ARROW_FROM_BAR							0x21EA
#define U_FOR_ALL									0x2200
#define U_COMPLEMENT									0x2201
#define U_PARTIAL_DIFFERENTIAL								0x2202
#define U_THERE_EXISTS									0x2203
#define U_THERE_DOES_NOT_EXIST								0x2204
#define U_EMPTY_SET									0x2205
#define U_INCREMENT									0x2206
#define U_NABLA										0x2207
#define U_ELEMENT_OF									0x2208
#define U_NOT_AN_ELEMENT_OF								0x2209
#define U_SMALL_ELEMENT_OF								0x220A
#define U_CONTAINS_AS_MEMBER								0x220B
#define U_DOES_NOT_CONTAIN_AS_MEMBER							0x220C
#define U_SMALL_CONTAINS_AS_MEMBER							0x220D
#define U_END_OF_PROOF									0x220E
#define U_N_ARY_PRODUCT									0x220F
#define U_N_ARY_COPRODUCT								0x2210
#define U_N_ARY_SUMMATION								0x2211
#define U_MINUS_SIGN									0x2212
#define U_MINUS_OR_PLUS_SIGN								0x2213
#define U_DOT_PLUS									0x2214
#define U_DIVISION_SLASH								0x2215
#define U_SET_MINUS									0x2216
#define U_ASTERISK_OPERATOR								0x2217
#define U_RING_OPERATOR									0x2218
#define U_BULLET_OPERATOR								0x2219
#define U_SQUARE_ROOT									0x221A
#define U_CUBE_ROOT									0x221B
#define U_FOURTH_ROOT									0x221C
#define U_PROPORTIONAL_TO								0x221D
#define U_INFINITY									0x221E
#define U_RIGHT_ANGLE									0x221F
#define U_ANGLE										0x2220
#define U_MEASURED_ANGLE								0x2221
#define U_SPHERICAL_ANGLE								0x2222
#define U_DIVIDES									0x2223
#define U_DOES_NOT_DIVIDE								0x2224
#define U_PARALLEL_TO									0x2225
#define U_NOT_PARALLEL_TO								0x2226
#define U_LOGICAL_AND									0x2227
#define U_LOGICAL_OR									0x2228
#define U_INTERSECTION									0x2229
#define U_UNION										0x222A
#define U_INTEGRAL									0x222B
#define U_DOUBLE_INTEGRAL								0x222C
#define U_TRIPLE_INTEGRAL								0x222D
#define U_CONTOUR_INTEGRAL								0x222E
#define U_SURFACE_INTEGRAL								0x222F
#define U_VOLUME_INTEGRAL								0x2230
#define U_CLOCKWISE_INTEGRAL								0x2231
#define U_CLOCKWISE_CONTOUR_INTEGRAL							0x2232
#define U_ANTICLOCKWISE_CONTOUR_INTEGRAL						0x2233
#define U_THEREFORE									0x2234
#define U_BECAUSE									0x2235
#define U_RATIO										0x2236
#define U_PROPORTION									0x2237
#define U_DOT_MINUS									0x2238
#define U_EXCESS									0x2239
#define U_GEOMETRIC_PROPORTION								0x223A
#define U_HOMOTHETIC									0x223B
#define U_TILDE_OPERATOR								0x223C
#define U_REVERSED_TILDE								0x223D
#define U_INVERTED_LAZY_S								0x223E
#define U_SINE_WAVE									0x223F
#define U_WREATH_PRODUCT								0x2240
#define U_NOT_TILDE									0x2241
#define U_MINUS_TILDE									0x2242
#define U_ASYMPTOTICALLY_EQUAL_TO							0x2243
#define U_NOT_ASYMPTOTICALLY_EQUAL_TO							0x2244
#define U_APPROXIMATELY_EQUAL_TO							0x2245
#define U_APPROXIMATELY_BUT_NOT_ACTUALLY_EQUAL_TO					0x2246
#define U_NEITHER_APPROXIMATELY_NOR_ACTUALLY_EQUAL_TO					0x2247
#define U_ALMOST_EQUAL_TO								0x2248
#define U_NOT_ALMOST_EQUAL_TO								0x2249
#define U_ALMOST_EQUAL_OR_EQUAL_TO							0x224A
#define U_TRIPLE_TILDE									0x224B
#define U_ALL_EQUAL_TO									0x224C
#define U_EQUIVALENT_TO									0x224D
#define U_GEOMETRICALLY_EQUIVALENT_TO							0x224E
#define U_DIFFERENCE_BETWEEN								0x224F
#define U_APPROACHES_THE_LIMIT								0x2250
#define U_GEOMETRICALLY_EQUAL_TO							0x2251
#define U_APPROXIMATELY_EQUAL_TO_OR_THE_IMAGE_OF					0x2252
#define U_IMAGE_OF_OR_APPROXIMATELY_EQUAL_TO						0x2253
#define U_COLON_EQUALS									0x2254
#define U_EQUALS_COLON									0x2255
#define U_RING_IN_EQUAL_TO								0x2256
#define U_RING_EQUAL_TO									0x2257
#define U_CORRESPONDS_TO								0x2258
#define U_ESTIMATES									0x2259
#define U_EQUIANGULAR_TO								0x225A
#define U_STAR_EQUALS									0x225B
#define U_DELTA_EQUAL_TO								0x225C
#define U_EQUAL_TO_BY_DEFINITION							0x225D
#define U_MEASURED_BY									0x225E
#define U_QUESTIONED_EQUAL_TO								0x225F
#define U_NOT_EQUAL_TO									0x2260
#define U_IDENTICAL_TO									0x2261
#define U_NOT_IDENTICAL_TO								0x2262
#define U_STRICTLY_EQUIVALENT_TO							0x2263
#define U_LESS_THAN_OR_EQUAL_TO								0x2264
#define U_GREATER_THAN_OR_EQUAL_TO							0x2265
#define U_LESS_THAN_OVER_EQUAL_TO							0x2266
#define U_GREATER_THAN_OVER_EQUAL_TO							0x2267
#define U_LESS_THAN_BUT_NOT_EQUAL_TO							0x2268
#define U_GREATER_THAN_BUT_NOT_EQUAL_TO							0x2269
#define U_MUCH_LESS_THAN								0x226A
#define U_MUCH_GREATER_THAN								0x226B
#define U_BETWEEN									0x226C
#define U_NOT_EQUIVALENT_TO								0x226D
#define U_NOT_LESS_THAN									0x226E
#define U_NOT_GREATER_THAN								0x226F
#define U_NEITHER_LESS_THAN_NOR_EQUAL_TO						0x2270
#define U_NEITHER_GREATER_THAN_NOR_EQUAL_TO						0x2271
#define U_LESS_THAN_OR_EQUIVALENT_TO							0x2272
#define U_GREATER_THAN_OR_EQUIVALENT_TO							0x2273
#define U_NEITHER_LESS_THAN_NOR_EQUIVALENT_TO						0x2274
#define U_NEITHER_GREATER_THAN_NOR_EQUIVALENT_TO					0x2275
#define U_LESS_THAN_OR_GREATER_THAN							0x2276
#define U_GREATER_THAN_OR_LESS_THAN							0x2277
#define U_NEITHER_LESS_THAN_NOR_GREATER_THAN						0x2278
#define U_NEITHER_GREATER_THAN_NOR_LESS_THAN						0x2279
#define U_PRECEDES									0x227A
#define U_SUCCEEDS									0x227B
#define U_PRECEDES_OR_EQUAL_TO								0x227C
#define U_SUCCEEDS_OR_EQUAL_TO								0x227D
#define U_PRECEDES_OR_EQUIVALENT_TO							0x227E
#define U_SUCCEEDS_OR_EQUIVALENT_TO							0x227F
#define U_DOES_NOT_PRECEDE								0x2280
#define U_DOES_NOT_SUCCEED								0x2281
#define U_SUBSET_OF									0x2282
#define U_SUPERSET_OF									0x2283
#define U_NOT_A_SUBSET_OF								0x2284
#define U_NOT_A_SUPERSET_OF								0x2285
#define U_SUBSET_OF_OR_EQUAL_TO								0x2286
#define U_SUPERSET_OF_OR_EQUAL_TO							0x2287
#define U_NEITHER_A_SUBSET_OF_NOR_EQUAL_TO						0x2288
#define U_NEITHER_A_SUPERSET_OF_NOR_EQUAL_TO						0x2289
#define U_SUBSET_OF_WITH_NOT_EQUAL_TO							0x228A
#define U_SUPERSET_OF_WITH_NOT_EQUAL_TO							0x228B
#define U_MULTISET									0x228C
#define U_MULTISET_MULTIPLICATION							0x228D
#define U_MULTISET_UNION								0x228E
#define U_SQUARE_IMAGE_OF								0x228F
#define U_SQUARE_ORIGINAL_OF								0x2290
#define U_SQUARE_IMAGE_OF_OR_EQUAL_TO							0x2291
#define U_SQUARE_ORIGINAL_OF_OR_EQUAL_TO						0x2292
#define U_SQUARE_CAP									0x2293
#define U_SQUARE_CUP									0x2294
#define U_CIRCLED_PLUS									0x2295
#define U_CIRCLED_MINUS									0x2296
#define U_CIRCLED_TIMES									0x2297
#define U_CIRCLED_DIVISION_SLASH							0x2298
#define U_CIRCLED_DOT_OPERATOR								0x2299
#define U_CIRCLED_RING_OPERATOR								0x229A
#define U_CIRCLED_ASTERISK_OPERATOR							0x229B
#define U_CIRCLED_EQUALS								0x229C
#define U_CIRCLED_DASH									0x229D
#define U_SQUARED_PLUS									0x229E
#define U_SQUARED_MINUS									0x229F
#define U_SQUARED_TIMES									0x22A0
#define U_SQUARED_DOT_OPERATOR								0x22A1
#define U_RIGHT_TACK									0x22A2
#define U_LEFT_TACK									0x22A3
#define U_DOWN_TACK									0x22A4
#define U_UP_TACK									0x22A5
#define U_ASSERTION									0x22A6
#define U_MODELS									0x22A7
#define U_TRUE										0x22A8
#define U_FORCES									0x22A9
#define U_TRIPLE_VERTICAL_BAR_RIGHT_TURNSTILE						0x22AA
#define U_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE					0x22AB
#define U_DOES_NOT_PROVE								0x22AC
#define U_NOT_TRUE									0x22AD
#define U_DOES_NOT_FORCE								0x22AE
#define U_NEGATED_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE				0x22AF
#define U_PRECEDES_UNDER_RELATION							0x22B0
#define U_SUCCEEDS_UNDER_RELATION							0x22B1
#define U_NORMAL_SUBGROUP_OF								0x22B2
#define U_CONTAINS_AS_NORMAL_SUBGROUP							0x22B3
#define U_NORMAL_SUBGROUP_OF_OR_EQUAL_TO						0x22B4
#define U_CONTAINS_AS_NORMAL_SUBGROUP_OR_EQUAL_TO					0x22B5
#define U_ORIGINAL_OF									0x22B6
#define U_IMAGE_OF									0x22B7
#define U_MULTIMAP									0x22B8
#define U_HERMITIAN_CONJUGATE_MATRIX							0x22B9
#define U_INTERCALATE									0x22BA
#define U_XOR										0x22BB
#define U_NAND										0x22BC
#define U_NOR										0x22BD
#define U_RIGHT_ANGLE_WITH_ARC								0x22BE
#define U_RIGHT_TRIANGLE								0x22BF
#define U_N_ARY_LOGICAL_AND								0x22C0
#define U_N_ARY_LOGICAL_OR								0x22C1
#define U_N_ARY_INTERSECTION								0x22C2
#define U_N_ARY_UNION									0x22C3
#define U_DIAMOND_OPERATOR								0x22C4
#define U_DOT_OPERATOR									0x22C5
#define U_STAR_OPERATOR									0x22C6
#define U_DIVISION_TIMES								0x22C7
#define U_BOWTIE									0x22C8
#define U_LEFT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT						0x22C9
#define U_RIGHT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT					0x22CA
#define U_LEFT_SEMIDIRECT_PRODUCT							0x22CB
#define U_RIGHT_SEMIDIRECT_PRODUCT							0x22CC
#define U_REVERSED_TILDE_EQUALS								0x22CD
#define U_CURLY_LOGICAL_OR								0x22CE
#define U_CURLY_LOGICAL_AND								0x22CF
#define U_DOUBLE_SUBSET									0x22D0
#define U_DOUBLE_SUPERSET								0x22D1
#define U_DOUBLE_INTERSECTION								0x22D2
#define U_DOUBLE_UNION									0x22D3
#define U_PITCHFORK									0x22D4
#define U_EQUAL_AND_PARALLEL_TO								0x22D5
#define U_LESS_THAN_WITH_DOT								0x22D6
#define U_GREATER_THAN_WITH_DOT								0x22D7
#define U_VERY_MUCH_LESS_THAN								0x22D8
#define U_VERY_MUCH_GREATER_THAN							0x22D9
#define U_LESS_THAN_EQUAL_TO_OR_GREATER_THAN						0x22DA
#define U_GREATER_THAN_EQUAL_TO_OR_LESS_THAN						0x22DB
#define U_EQUAL_TO_OR_LESS_THAN								0x22DC
#define U_EQUAL_TO_OR_GREATER_THAN							0x22DD
#define U_EQUAL_TO_OR_PRECEDES								0x22DE
#define U_EQUAL_TO_OR_SUCCEEDS								0x22DF
#define U_DOES_NOT_PRECEDE_OR_EQUAL							0x22E0
#define U_DOES_NOT_SUCCEED_OR_EQUAL							0x22E1
#define U_NOT_SQUARE_IMAGE_OF_OR_EQUAL_TO						0x22E2
#define U_NOT_SQUARE_ORIGINAL_OF_OR_EQUAL_TO						0x22E3
#define U_SQUARE_IMAGE_OF_OR_NOT_EQUAL_TO						0x22E4
#define U_SQUARE_ORIGINAL_OF_OR_NOT_EQUAL_TO						0x22E5
#define U_LESS_THAN_BUT_NOT_EQUIVALENT_TO						0x22E6
#define U_GREATER_THAN_BUT_NOT_EQUIVALENT_TO						0x22E7
#define U_PRECEDES_BUT_NOT_EQUIVALENT_TO						0x22E8
#define U_SUCCEEDS_BUT_NOT_EQUIVALENT_TO						0x22E9
#define U_NOT_NORMAL_SUBGROUP_OF							0x22EA
#define U_DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP						0x22EB
#define U_NOT_NORMAL_SUBGROUP_OF_OR_EQUAL_TO						0x22EC
#define U_DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP_OR_EQUAL					0x22ED
#define U_VERTICAL_ELLIPSIS								0x22EE
#define U_MIDLINE_HORIZONTAL_ELLIPSIS							0x22EF
#define U_UP_RIGHT_DIAGONAL_ELLIPSIS							0x22F0
#define U_DOWN_RIGHT_DIAGONAL_ELLIPSIS							0x22F1
#define U_DIAMETER_SIGN									0x2300
#define U_HOUSE										0x2302
#define U_UP_ARROWHEAD									0x2303
#define U_DOWN_ARROWHEAD								0x2304
#define U_PROJECTIVE									0x2305
#define U_PERSPECTIVE									0x2306
#define U_WAVY_LINE									0x2307
#define U_LEFT_CEILING									0x2308
#define U_RIGHT_CEILING									0x2309
#define U_LEFT_FLOOR									0x230A
#define U_RIGHT_FLOOR									0x230B
#define U_BOTTOM_RIGHT_CROP								0x230C
#define U_BOTTOM_LEFT_CROP								0x230D
#define U_TOP_RIGHT_CROP								0x230E
#define U_TOP_LEFT_CROP									0x230F
#define U_REVERSED_NOT_SIGN								0x2310
#define U_SQUARE_LOZENGE								0x2311
#define U_ARC										0x2312
#define U_SEGMENT									0x2313
#define U_SECTOR									0x2314
#define U_TELEPHONE_RECORDER								0x2315
#define U_POSITION_INDICATOR								0x2316
#define U_VIEWDATA_SQUARE								0x2317
#define U_PLACE_OF_INTEREST_SIGN							0x2318
#define U_TURNED_NOT_SIGN								0x2319
#define U_WATCH										0x231A
#define U_HOURGLASS									0x231B
#define U_TOP_LEFT_CORNER								0x231C
#define U_TOP_RIGHT_CORNER								0x231D
#define U_BOTTOM_LEFT_CORNER								0x231E
#define U_BOTTOM_RIGHT_CORNER								0x231F
#define U_TOP_HALF_INTEGRAL								0x2320
#define U_BOTTOM_HALF_INTEGRAL								0x2321
#define U_FROWN										0x2322
#define U_SMILE										0x2323
#define U_UP_ARROWHEAD_BETWEEN_TWO_HORIZONTAL_BARS					0x2324
#define U_OPTION_KEY									0x2325
#define U_ERASE_TO_THE_RIGHT								0x2326
#define U_X_IN_A_RECTANGLE_BOX								0x2327
#define U_KEYBOARD									0x2328
#define U_LEFT_POINTING_ANGLE_BRACKET							0x2329
#define U_RIGHT_POINTING_ANGLE_BRACKET							0x232A
#define U_ERASE_TO_THE_LEFT								0x232B
#define U_BENZENE_RING									0x232C
#define U_CYLINDRICITY									0x232D
#define U_ALL_AROUND_PROFILE								0x232E
#define U_SYMMETRY									0x232F
#define U_TOTAL_RUNOUT									0x2330
#define U_DIMENSION_ORIGIN								0x2331
#define U_CONICAL_TAPER									0x2332
#define U_SLOPE										0x2333
#define U_COUNTERBORE									0x2334
#define U_COUNTERSINK									0x2335
#define U_APL_FUNCTIONAL_SYMBOL_I_BEAM							0x2336
#define U_APL_FUNCTIONAL_SYMBOL_SQUISH_QUAD						0x2337
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_EQUAL						0x2338
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_DIVIDE						0x2339
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_DIAMOND						0x233A
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_JOT						0x233B
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_CIRCLE						0x233C
#define U_APL_FUNCTIONAL_SYMBOL_CIRCLE_STILE						0x233D
#define U_APL_FUNCTIONAL_SYMBOL_CIRCLE_JOT						0x233E
#define U_APL_FUNCTIONAL_SYMBOL_SLASH_BAR						0x233F
#define U_APL_FUNCTIONAL_SYMBOL_BACKSLASH_BAR						0x2340
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_SLASH						0x2341
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_BACKSLASH						0x2342
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_LESS_THAN						0x2343
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_GREATER_THAN					0x2344
#define U_APL_FUNCTIONAL_SYMBOL_LEFTWARDS_VANE						0x2345
#define U_APL_FUNCTIONAL_SYMBOL_RIGHTWARDS_VANE						0x2346
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_LEFTWARDS_ARROW					0x2347
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_RIGHTWARDS_ARROW					0x2348
#define U_APL_FUNCTIONAL_SYMBOL_CIRCLE_BACKSLASH					0x2349
#define U_APL_FUNCTIONAL_SYMBOL_DOWN_TACK_UNDERBAR					0x234A
#define U_APL_FUNCTIONAL_SYMBOL_DELTA_STILE						0x234B
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_DOWN_CARET						0x234C
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_DELTA						0x234D
#define U_APL_FUNCTIONAL_SYMBOL_DOWN_TACK_JOT						0x234E
#define U_APL_FUNCTIONAL_SYMBOL_UPWARDS_VANE						0x234F
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_UPWARDS_ARROW					0x2350
#define U_APL_FUNCTIONAL_SYMBOL_UP_TACK_OVERBAR						0x2351
#define U_APL_FUNCTIONAL_SYMBOL_DEL_STILE						0x2352
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_UP_CARET						0x2353
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_DEL						0x2354
#define U_APL_FUNCTIONAL_SYMBOL_UP_TACK_JOT						0x2355
#define U_APL_FUNCTIONAL_SYMBOL_DOWNWARDS_VANE						0x2356
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_DOWNWARDS_ARROW					0x2357
#define U_APL_FUNCTIONAL_SYMBOL_QUOTE_UNDERBAR						0x2358
#define U_APL_FUNCTIONAL_SYMBOL_DELTA_UNDERBAR						0x2359
#define U_APL_FUNCTIONAL_SYMBOL_DIAMOND_UNDERBAR					0x235A
#define U_APL_FUNCTIONAL_SYMBOL_JOT_UNDERBAR						0x235B
#define U_APL_FUNCTIONAL_SYMBOL_CIRCLE_UNDERBAR						0x235C
#define U_APL_FUNCTIONAL_SYMBOL_UP_SHOE_JOT						0x235D
#define U_APL_FUNCTIONAL_SYMBOL_QUOTE_QUAD						0x235E
#define U_APL_FUNCTIONAL_SYMBOL_CIRCLE_STAR						0x235F
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_COLON						0x2360
#define U_APL_FUNCTIONAL_SYMBOL_UP_TACK_DIAERESIS					0x2361
#define U_APL_FUNCTIONAL_SYMBOL_DEL_DIAERESIS						0x2362
#define U_APL_FUNCTIONAL_SYMBOL_STAR_DIAERESIS						0x2363
#define U_APL_FUNCTIONAL_SYMBOL_JOT_DIAERESIS						0x2364
#define U_APL_FUNCTIONAL_SYMBOL_CIRCLE_DIAERESIS					0x2365
#define U_APL_FUNCTIONAL_SYMBOL_DOWN_SHOE_STILE						0x2366
#define U_APL_FUNCTIONAL_SYMBOL_LEFT_SHOE_STILE						0x2367
#define U_APL_FUNCTIONAL_SYMBOL_TILDE_DIAERESIS						0x2368
#define U_APL_FUNCTIONAL_SYMBOL_GREATER_THAN_DIAERESIS					0x2369
#define U_APL_FUNCTIONAL_SYMBOL_COMMA_BAR						0x236A
#define U_APL_FUNCTIONAL_SYMBOL_DEL_TILDE						0x236B
#define U_APL_FUNCTIONAL_SYMBOL_ZILDE							0x236C
#define U_APL_FUNCTIONAL_SYMBOL_STILE_TILDE						0x236D
#define U_APL_FUNCTIONAL_SYMBOL_SEMICOLON_UNDERBAR					0x236E
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_NOT_EQUAL						0x236F
#define U_APL_FUNCTIONAL_SYMBOL_QUAD_QUESTION						0x2370
#define U_APL_FUNCTIONAL_SYMBOL_DOWN_CARET_TILDE					0x2371
#define U_APL_FUNCTIONAL_SYMBOL_UP_CARET_TILDE						0x2372
#define U_APL_FUNCTIONAL_SYMBOL_IOTA							0x2373
#define U_APL_FUNCTIONAL_SYMBOL_RHO							0x2374
#define U_APL_FUNCTIONAL_SYMBOL_OMEGA							0x2375
#define U_APL_FUNCTIONAL_SYMBOL_ALPHA_UNDERBAR						0x2376
#define U_APL_FUNCTIONAL_SYMBOL_EPSILON_UNDERBAR					0x2377
#define U_APL_FUNCTIONAL_SYMBOL_IOTA_UNDERBAR						0x2378
#define U_APL_FUNCTIONAL_SYMBOL_OMEGA_UNDERBAR						0x2379
#define U_APL_FUNCTIONAL_SYMBOL_ALPHA							0x237A
#define U_SYMBOL_FOR_NULL								0x2400
#define U_SYMBOL_FOR_START_OF_HEADING							0x2401
#define U_SYMBOL_FOR_START_OF_TEXT							0x2402
#define U_SYMBOL_FOR_END_OF_TEXT							0x2403
#define U_SYMBOL_FOR_END_OF_TRANSMISSION						0x2404
#define U_SYMBOL_FOR_ENQUIRY								0x2405
#define U_SYMBOL_FOR_ACKNOWLEDGE							0x2406
#define U_SYMBOL_FOR_BELL								0x2407
#define U_SYMBOL_FOR_BACKSPACE								0x2408
#define U_SYMBOL_FOR_HORIZONTAL_TABULATION						0x2409
#define U_SYMBOL_FOR_LINE_FEED								0x240A
#define U_SYMBOL_FOR_VERTICAL_TABULATION						0x240B
#define U_SYMBOL_FOR_FORM_FEED								0x240C
#define U_SYMBOL_FOR_CARRIAGE_RETURN							0x240D
#define U_SYMBOL_FOR_SHIFT_OUT								0x240E
#define U_SYMBOL_FOR_SHIFT_IN								0x240F
#define U_SYMBOL_FOR_DATA_LINK_ESCAPE							0x2410
#define U_SYMBOL_FOR_DEVICE_CONTROL_ONE							0x2411
#define U_SYMBOL_FOR_DEVICE_CONTROL_TWO							0x2412
#define U_SYMBOL_FOR_DEVICE_CONTROL_THREE						0x2413
#define U_SYMBOL_FOR_DEVICE_CONTROL_FOUR						0x2414
#define U_SYMBOL_FOR_NEGATIVE_ACKNOWLEDGE						0x2415
#define U_SYMBOL_FOR_SYNCHRONOUS_IDLE							0x2416
#define U_SYMBOL_FOR_END_OF_TRANSMISSION_BLOCK						0x2417
#define U_SYMBOL_FOR_CANCEL								0x2418
#define U_SYMBOL_FOR_END_OF_MEDIUM							0x2419
#define U_SYMBOL_FOR_SUBSTITUTE								0x241A
#define U_SYMBOL_FOR_ESCAPE								0x241B
#define U_SYMBOL_FOR_FILE_SEPARATOR							0x241C
#define U_SYMBOL_FOR_GROUP_SEPARATOR							0x241D
#define U_SYMBOL_FOR_RECORD_SEPARATOR							0x241E
#define U_SYMBOL_FOR_UNIT_SEPARATOR							0x241F
#define U_SYMBOL_FOR_SPACE								0x2420
#define U_SYMBOL_FOR_DELETE								0x2421
#define U_BLANK_SYMBOL									0x2422
#define U_OPEN_BOX									0x2423
#define U_SYMBOL_FOR_NEWLINE								0x2424
#define U_OCR_HOOK									0x2440
#define U_OCR_CHAIR									0x2441
#define U_OCR_FORK									0x2442
#define U_OCR_INVERTED_FORK								0x2443
#define U_OCR_BELT_BUCKLE								0x2444
#define U_OCR_BOW_TIE									0x2445
#define U_OCR_BRANCH_BANK_IDENTIFICATION						0x2446
#define U_OCR_AMOUNT_OF_CHECK								0x2447
#define U_OCR_DASH									0x2448
#define U_OCR_CUSTOMER_ACCOUNT_NUMBER							0x2449
#define U_OCR_DOUBLE_BACKSLASH								0x244A
#define U_CIRCLED_DIGIT_ONE								0x2460
#define U_CIRCLED_DIGIT_TWO								0x2461
#define U_CIRCLED_DIGIT_THREE								0x2462
#define U_CIRCLED_DIGIT_FOUR								0x2463
#define U_CIRCLED_DIGIT_FIVE								0x2464
#define U_CIRCLED_DIGIT_SIX								0x2465
#define U_CIRCLED_DIGIT_SEVEN								0x2466
#define U_CIRCLED_DIGIT_EIGHT								0x2467
#define U_CIRCLED_DIGIT_NINE								0x2468
#define U_CIRCLED_NUMBER_TEN								0x2469
#define U_CIRCLED_NUMBER_ELEVEN								0x246A
#define U_CIRCLED_NUMBER_TWELVE								0x246B
#define U_CIRCLED_NUMBER_THIRTEEN							0x246C
#define U_CIRCLED_NUMBER_FOURTEEN							0x246D
#define U_CIRCLED_NUMBER_FIFTEEN							0x246E
#define U_CIRCLED_NUMBER_SIXTEEN							0x246F
#define U_CIRCLED_NUMBER_SEVENTEEN							0x2470
#define U_CIRCLED_NUMBER_EIGHTEEN							0x2471
#define U_CIRCLED_NUMBER_NINETEEN							0x2472
#define U_CIRCLED_NUMBER_TWENTY								0x2473
#define U_PARENTHESIZED_DIGIT_ONE							0x2474
#define U_PARENTHESIZED_DIGIT_TWO							0x2475
#define U_PARENTHESIZED_DIGIT_THREE							0x2476
#define U_PARENTHESIZED_DIGIT_FOUR							0x2477
#define U_PARENTHESIZED_DIGIT_FIVE							0x2478
#define U_PARENTHESIZED_DIGIT_SIX							0x2479
#define U_PARENTHESIZED_DIGIT_SEVEN							0x247A
#define U_PARENTHESIZED_DIGIT_EIGHT							0x247B
#define U_PARENTHESIZED_DIGIT_NINE							0x247C
#define U_PARENTHESIZED_NUMBER_TEN							0x247D
#define U_PARENTHESIZED_NUMBER_ELEVEN							0x247E
#define U_PARENTHESIZED_NUMBER_TWELVE							0x247F
#define U_PARENTHESIZED_NUMBER_THIRTEEN							0x2480
#define U_PARENTHESIZED_NUMBER_FOURTEEN							0x2481
#define U_PARENTHESIZED_NUMBER_FIFTEEN							0x2482
#define U_PARENTHESIZED_NUMBER_SIXTEEN							0x2483
#define U_PARENTHESIZED_NUMBER_SEVENTEEN						0x2484
#define U_PARENTHESIZED_NUMBER_EIGHTEEN							0x2485
#define U_PARENTHESIZED_NUMBER_NINETEEN							0x2486
#define U_PARENTHESIZED_NUMBER_TWENTY							0x2487
#define U_DIGIT_ONE_FULL_STOP								0x2488
#define U_DIGIT_TWO_FULL_STOP								0x2489
#define U_DIGIT_THREE_FULL_STOP								0x248A
#define U_DIGIT_FOUR_FULL_STOP								0x248B
#define U_DIGIT_FIVE_FULL_STOP								0x248C
#define U_DIGIT_SIX_FULL_STOP								0x248D
#define U_DIGIT_SEVEN_FULL_STOP								0x248E
#define U_DIGIT_EIGHT_FULL_STOP								0x248F
#define U_DIGIT_NINE_FULL_STOP								0x2490
#define U_NUMBER_TEN_FULL_STOP								0x2491
#define U_NUMBER_ELEVEN_FULL_STOP							0x2492
#define U_NUMBER_TWELVE_FULL_STOP							0x2493
#define U_NUMBER_THIRTEEN_FULL_STOP							0x2494
#define U_NUMBER_FOURTEEN_FULL_STOP							0x2495
#define U_NUMBER_FIFTEEN_FULL_STOP							0x2496
#define U_NUMBER_SIXTEEN_FULL_STOP							0x2497
#define U_NUMBER_SEVENTEEN_FULL_STOP							0x2498
#define U_NUMBER_EIGHTEEN_FULL_STOP							0x2499
#define U_NUMBER_NINETEEN_FULL_STOP							0x249A
#define U_NUMBER_TWENTY_FULL_STOP							0x249B
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_A						0x249C
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_B						0x249D
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_C						0x249E
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_D						0x249F
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_E						0x24A0
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_F						0x24A1
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_G						0x24A2
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_H						0x24A3
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_I						0x24A4
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_J						0x24A5
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_K						0x24A6
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_L						0x24A7
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_M						0x24A8
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_N						0x24A9
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_O						0x24AA
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_P						0x24AB
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_Q						0x24AC
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_R						0x24AD
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_S						0x24AE
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_T						0x24AF
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_U						0x24B0
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_V						0x24B1
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_W						0x24B2
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_X						0x24B3
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_Y						0x24B4
#define U_PARENTHESIZED_LATIN_SMALL_LETTER_Z						0x24B5
#define U_CIRCLED_LATIN_CAPITAL_LETTER_A						0x24B6
#define U_CIRCLED_LATIN_CAPITAL_LETTER_B						0x24B7
#define U_CIRCLED_LATIN_CAPITAL_LETTER_C						0x24B8
#define U_CIRCLED_LATIN_CAPITAL_LETTER_D						0x24B9
#define U_CIRCLED_LATIN_CAPITAL_LETTER_E						0x24BA
#define U_CIRCLED_LATIN_CAPITAL_LETTER_F						0x24BB
#define U_CIRCLED_LATIN_CAPITAL_LETTER_G						0x24BC
#define U_CIRCLED_LATIN_CAPITAL_LETTER_H						0x24BD
#define U_CIRCLED_LATIN_CAPITAL_LETTER_I						0x24BE
#define U_CIRCLED_LATIN_CAPITAL_LETTER_J						0x24BF
#define U_CIRCLED_LATIN_CAPITAL_LETTER_K						0x24C0
#define U_CIRCLED_LATIN_CAPITAL_LETTER_L						0x24C1
#define U_CIRCLED_LATIN_CAPITAL_LETTER_M						0x24C2
#define U_CIRCLED_LATIN_CAPITAL_LETTER_N						0x24C3
#define U_CIRCLED_LATIN_CAPITAL_LETTER_O						0x24C4
#define U_CIRCLED_LATIN_CAPITAL_LETTER_P						0x24C5
#define U_CIRCLED_LATIN_CAPITAL_LETTER_Q						0x24C6
#define U_CIRCLED_LATIN_CAPITAL_LETTER_R						0x24C7
#define U_CIRCLED_LATIN_CAPITAL_LETTER_S						0x24C8
#define U_CIRCLED_LATIN_CAPITAL_LETTER_T						0x24C9
#define U_CIRCLED_LATIN_CAPITAL_LETTER_U						0x24CA
#define U_CIRCLED_LATIN_CAPITAL_LETTER_V						0x24CB
#define U_CIRCLED_LATIN_CAPITAL_LETTER_W						0x24CC
#define U_CIRCLED_LATIN_CAPITAL_LETTER_X						0x24CD
#define U_CIRCLED_LATIN_CAPITAL_LETTER_Y						0x24CE
#define U_CIRCLED_LATIN_CAPITAL_LETTER_Z						0x24CF
#define U_CIRCLED_LATIN_SMALL_LETTER_A							0x24D0
#define U_CIRCLED_LATIN_SMALL_LETTER_B							0x24D1
#define U_CIRCLED_LATIN_SMALL_LETTER_C							0x24D2
#define U_CIRCLED_LATIN_SMALL_LETTER_D							0x24D3
#define U_CIRCLED_LATIN_SMALL_LETTER_E							0x24D4
#define U_CIRCLED_LATIN_SMALL_LETTER_F							0x24D5
#define U_CIRCLED_LATIN_SMALL_LETTER_G							0x24D6
#define U_CIRCLED_LATIN_SMALL_LETTER_H							0x24D7
#define U_CIRCLED_LATIN_SMALL_LETTER_I							0x24D8
#define U_CIRCLED_LATIN_SMALL_LETTER_J							0x24D9
#define U_CIRCLED_LATIN_SMALL_LETTER_K							0x24DA
#define U_CIRCLED_LATIN_SMALL_LETTER_L							0x24DB
#define U_CIRCLED_LATIN_SMALL_LETTER_M							0x24DC
#define U_CIRCLED_LATIN_SMALL_LETTER_N							0x24DD
#define U_CIRCLED_LATIN_SMALL_LETTER_O							0x24DE
#define U_CIRCLED_LATIN_SMALL_LETTER_P							0x24DF
#define U_CIRCLED_LATIN_SMALL_LETTER_Q							0x24E0
#define U_CIRCLED_LATIN_SMALL_LETTER_R							0x24E1
#define U_CIRCLED_LATIN_SMALL_LETTER_S							0x24E2
#define U_CIRCLED_LATIN_SMALL_LETTER_T							0x24E3
#define U_CIRCLED_LATIN_SMALL_LETTER_U							0x24E4
#define U_CIRCLED_LATIN_SMALL_LETTER_V							0x24E5
#define U_CIRCLED_LATIN_SMALL_LETTER_W							0x24E6
#define U_CIRCLED_LATIN_SMALL_LETTER_X							0x24E7
#define U_CIRCLED_LATIN_SMALL_LETTER_Y							0x24E8
#define U_CIRCLED_LATIN_SMALL_LETTER_Z							0x24E9
#define U_CIRCLED_DIGIT_ZERO								0x24EA
#define U_BOX_DRAWINGS_LIGHT_HORIZONTAL							0x2500
#define U_BOX_DRAWINGS_HEAVY_HORIZONTAL							0x2501
#define U_BOX_DRAWINGS_LIGHT_VERTICAL							0x2502
#define U_BOX_DRAWINGS_HEAVY_VERTICAL							0x2503
#define U_BOX_DRAWINGS_LIGHT_TRIPLE_DASH_HORIZONTAL					0x2504
#define U_BOX_DRAWINGS_HEAVY_TRIPLE_DASH_HORIZONTAL					0x2505
#define U_BOX_DRAWINGS_LIGHT_TRIPLE_DASH_VERTICAL					0x2506
#define U_BOX_DRAWINGS_HEAVY_TRIPLE_DASH_VERTICAL					0x2507
#define U_BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_HORIZONTAL					0x2508
#define U_BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_HORIZONTAL					0x2509
#define U_BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_VERTICAL					0x250A
#define U_BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_VERTICAL					0x250B
#define U_BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT						0x250C
#define U_BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_HEAVY					0x250D
#define U_BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_LIGHT					0x250E
#define U_BOX_DRAWINGS_HEAVY_DOWN_AND_RIGHT						0x250F
#define U_BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT						0x2510
#define U_BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_HEAVY					0x2511
#define U_BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_LIGHT					0x2512
#define U_BOX_DRAWINGS_HEAVY_DOWN_AND_LEFT						0x2513
#define U_BOX_DRAWINGS_LIGHT_UP_AND_RIGHT						0x2514
#define U_BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_HEAVY						0x2515
#define U_BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_LIGHT						0x2516
#define U_BOX_DRAWINGS_HEAVY_UP_AND_RIGHT						0x2517
#define U_BOX_DRAWINGS_LIGHT_UP_AND_LEFT						0x2518
#define U_BOX_DRAWINGS_UP_LIGHT_AND_LEFT_HEAVY						0x2519
#define U_BOX_DRAWINGS_UP_HEAVY_AND_LEFT_LIGHT						0x251A
#define U_BOX_DRAWINGS_HEAVY_UP_AND_LEFT						0x251B
#define U_BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT						0x251C
#define U_BOX_DRAWINGS_VERTICAL_LIGHT_AND_RIGHT_HEAVY					0x251D
#define U_BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_DOWN_LIGHT					0x251E
#define U_BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_UP_LIGHT					0x251F
#define U_BOX_DRAWINGS_VERTICAL_HEAVY_AND_RIGHT_LIGHT					0x2520
#define U_BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_UP_HEAVY					0x2521
#define U_BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_DOWN_HEAVY					0x2522
#define U_BOX_DRAWINGS_HEAVY_VERTICAL_AND_RIGHT						0x2523
#define U_BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT						0x2524
#define U_BOX_DRAWINGS_VERTICAL_LIGHT_AND_LEFT_HEAVY					0x2525
#define U_BOX_DRAWINGS_UP_HEAVY_AND_LEFT_DOWN_LIGHT					0x2526
#define U_BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_UP_LIGHT					0x2527
#define U_BOX_DRAWINGS_VERTICAL_HEAVY_AND_LEFT_LIGHT					0x2528
#define U_BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_UP_HEAVY					0x2529
#define U_BOX_DRAWINGS_UP_LIGHT_AND_LEFT_DOWN_HEAVY					0x252A
#define U_BOX_DRAWINGS_HEAVY_VERTICAL_AND_LEFT						0x252B
#define U_BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL					0x252C
#define U_BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_DOWN_LIGHT					0x252D
#define U_BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_DOWN_LIGHT					0x252E
#define U_BOX_DRAWINGS_DOWN_LIGHT_AND_HORIZONTAL_HEAVY					0x252F
#define U_BOX_DRAWINGS_DOWN_HEAVY_AND_HORIZONTAL_LIGHT					0x2530
#define U_BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_DOWN_HEAVY					0x2531
#define U_BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_DOWN_HEAVY					0x2532
#define U_BOX_DRAWINGS_HEAVY_DOWN_AND_HORIZONTAL					0x2533
#define U_BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL						0x2534
#define U_BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_UP_LIGHT					0x2535
#define U_BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_UP_LIGHT					0x2536
#define U_BOX_DRAWINGS_UP_LIGHT_AND_HORIZONTAL_HEAVY					0x2537
#define U_BOX_DRAWINGS_UP_HEAVY_AND_HORIZONTAL_LIGHT					0x2538
#define U_BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_UP_HEAVY					0x2539
#define U_BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_UP_HEAVY					0x253A
#define U_BOX_DRAWINGS_HEAVY_UP_AND_HORIZONTAL						0x253B
#define U_BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL					0x253C
#define U_BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_VERTICAL_LIGHT				0x253D
#define U_BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_VERTICAL_LIGHT				0x253E
#define U_BOX_DRAWINGS_VERTICAL_LIGHT_AND_HORIZONTAL_HEAVY				0x253F
#define U_BOX_DRAWINGS_UP_HEAVY_AND_DOWN_HORIZONTAL_LIGHT				0x2540
#define U_BOX_DRAWINGS_DOWN_HEAVY_AND_UP_HORIZONTAL_LIGHT				0x2541
#define U_BOX_DRAWINGS_VERTICAL_HEAVY_AND_HORIZONTAL_LIGHT				0x2542
#define U_BOX_DRAWINGS_LEFT_UP_HEAVY_AND_RIGHT_DOWN_LIGHT				0x2543
#define U_BOX_DRAWINGS_RIGHT_UP_HEAVY_AND_LEFT_DOWN_LIGHT				0x2544
#define U_BOX_DRAWINGS_LEFT_DOWN_HEAVY_AND_RIGHT_UP_LIGHT				0x2545
#define U_BOX_DRAWINGS_RIGHT_DOWN_HEAVY_AND_LEFT_UP_LIGHT				0x2546
#define U_BOX_DRAWINGS_DOWN_LIGHT_AND_UP_HORIZONTAL_HEAVY				0x2547
#define U_BOX_DRAWINGS_UP_LIGHT_AND_DOWN_HORIZONTAL_HEAVY				0x2548
#define U_BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_VERTICAL_HEAVY				0x2549
#define U_BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_VERTICAL_HEAVY				0x254A
#define U_BOX_DRAWINGS_HEAVY_VERTICAL_AND_HORIZONTAL					0x254B
#define U_BOX_DRAWINGS_LIGHT_DOUBLE_DASH_HORIZONTAL					0x254C
#define U_BOX_DRAWINGS_HEAVY_DOUBLE_DASH_HORIZONTAL					0x254D
#define U_BOX_DRAWINGS_LIGHT_DOUBLE_DASH_VERTICAL					0x254E
#define U_BOX_DRAWINGS_HEAVY_DOUBLE_DASH_VERTICAL					0x254F
#define U_BOX_DRAWINGS_DOUBLE_HORIZONTAL						0x2550
#define U_BOX_DRAWINGS_DOUBLE_VERTICAL							0x2551
#define U_BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE					0x2552
#define U_BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE					0x2553
#define U_BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT						0x2554
#define U_BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE					0x2555
#define U_BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE					0x2556
#define U_BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT						0x2557
#define U_BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE					0x2558
#define U_BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE					0x2559
#define U_BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT						0x255A
#define U_BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE					0x255B
#define U_BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE					0x255C
#define U_BOX_DRAWINGS_DOUBLE_UP_AND_LEFT						0x255D
#define U_BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE					0x255E
#define U_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE					0x255F
#define U_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT					0x2560
#define U_BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE					0x2561
#define U_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE					0x2562
#define U_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT						0x2563
#define U_BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE				0x2564
#define U_BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE				0x2565
#define U_BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL					0x2566
#define U_BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE					0x2567
#define U_BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE					0x2568
#define U_BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL						0x2569
#define U_BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE				0x256A
#define U_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE				0x256B
#define U_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL					0x256C
#define U_BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_RIGHT						0x256D
#define U_BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_LEFT						0x256E
#define U_BOX_DRAWINGS_LIGHT_ARC_UP_AND_LEFT						0x256F
#define U_BOX_DRAWINGS_LIGHT_ARC_UP_AND_RIGHT						0x2570
#define U_BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_RIGHT_TO_LOWER_LEFT				0x2571
#define U_BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_LEFT_TO_LOWER_RIGHT				0x2572
#define U_BOX_DRAWINGS_LIGHT_DIAGONAL_CROSS						0x2573
#define U_BOX_DRAWINGS_LIGHT_LEFT							0x2574
#define U_BOX_DRAWINGS_LIGHT_UP								0x2575
#define U_BOX_DRAWINGS_LIGHT_RIGHT							0x2576
#define U_BOX_DRAWINGS_LIGHT_DOWN							0x2577
#define U_BOX_DRAWINGS_HEAVY_LEFT							0x2578
#define U_BOX_DRAWINGS_HEAVY_UP								0x2579
#define U_BOX_DRAWINGS_HEAVY_RIGHT							0x257A
#define U_BOX_DRAWINGS_HEAVY_DOWN							0x257B
#define U_BOX_DRAWINGS_LIGHT_LEFT_AND_HEAVY_RIGHT					0x257C
#define U_BOX_DRAWINGS_LIGHT_UP_AND_HEAVY_DOWN						0x257D
#define U_BOX_DRAWINGS_HEAVY_LEFT_AND_LIGHT_RIGHT					0x257E
#define U_BOX_DRAWINGS_HEAVY_UP_AND_LIGHT_DOWN						0x257F
#define U_UPPER_HALF_BLOCK								0x2580
#define U_LOWER_ONE_EIGHTH_BLOCK							0x2581
#define U_LOWER_ONE_QUARTER_BLOCK							0x2582
#define U_LOWER_THREE_EIGHTHS_BLOCK							0x2583
#define U_LOWER_HALF_BLOCK								0x2584
#define U_LOWER_FIVE_EIGHTHS_BLOCK							0x2585
#define U_LOWER_THREE_QUARTERS_BLOCK							0x2586
#define U_LOWER_SEVEN_EIGHTHS_BLOCK							0x2587
#define U_FULL_BLOCK									0x2588
#define U_LEFT_SEVEN_EIGHTHS_BLOCK							0x2589
#define U_LEFT_THREE_QUARTERS_BLOCK							0x258A
#define U_LEFT_FIVE_EIGHTHS_BLOCK							0x258B
#define U_LEFT_HALF_BLOCK								0x258C
#define U_LEFT_THREE_EIGHTHS_BLOCK							0x258D
#define U_LEFT_ONE_QUARTER_BLOCK							0x258E
#define U_LEFT_ONE_EIGHTH_BLOCK								0x258F
#define U_RIGHT_HALF_BLOCK								0x2590
#define U_LIGHT_SHADE									0x2591
#define U_MEDIUM_SHADE									0x2592
#define U_DARK_SHADE									0x2593
#define U_UPPER_ONE_EIGHTH_BLOCK							0x2594
#define U_RIGHT_ONE_EIGHTH_BLOCK							0x2595
#define U_BLACK_SQUARE									0x25A0
#define U_WHITE_SQUARE									0x25A1
#define U_WHITE_SQUARE_WITH_ROUNDED_CORNERS						0x25A2
#define U_WHITE_SQUARE_CONTAINING_BLACK_SMALL_SQUARE					0x25A3
#define U_SQUARE_WITH_HORIZONTAL_FILL							0x25A4
#define U_SQUARE_WITH_VERTICAL_FILL							0x25A5
#define U_SQUARE_WITH_ORTHOGONAL_CROSSHATCH_FILL					0x25A6
#define U_SQUARE_WITH_UPPER_LEFT_TO_LOWER_RIGHT_FILL					0x25A7
#define U_SQUARE_WITH_UPPER_RIGHT_TO_LOWER_LEFT_FILL					0x25A8
#define U_SQUARE_WITH_DIAGONAL_CROSSHATCH_FILL						0x25A9
#define U_BLACK_SMALL_SQUARE								0x25AA
#define U_WHITE_SMALL_SQUARE								0x25AB
#define U_BLACK_RECTANGLE								0x25AC
#define U_WHITE_RECTANGLE								0x25AD
#define U_BLACK_VERTICAL_RECTANGLE							0x25AE
#define U_WHITE_VERTICAL_RECTANGLE							0x25AF
#define U_BLACK_PARALLELOGRAM								0x25B0
#define U_WHITE_PARALLELOGRAM								0x25B1
#define U_BLACK_UP_POINTING_TRIANGLE							0x25B2
#define U_WHITE_UP_POINTING_TRIANGLE							0x25B3
#define U_BLACK_UP_POINTING_SMALL_TRIANGLE						0x25B4
#define U_WHITE_UP_POINTING_SMALL_TRIANGLE						0x25B5
#define U_BLACK_RIGHT_POINTING_TRIANGLE							0x25B6
#define U_WHITE_RIGHT_POINTING_TRIANGLE							0x25B7
#define U_BLACK_RIGHT_POINTING_SMALL_TRIANGLE						0x25B8
#define U_WHITE_RIGHT_POINTING_SMALL_TRIANGLE						0x25B9
#define U_BLACK_RIGHT_POINTING_POINTER							0x25BA
#define U_WHITE_RIGHT_POINTING_POINTER							0x25BB
#define U_BLACK_DOWN_POINTING_TRIANGLE							0x25BC
#define U_WHITE_DOWN_POINTING_TRIANGLE							0x25BD
#define U_BLACK_DOWN_POINTING_SMALL_TRIANGLE						0x25BE
#define U_WHITE_DOWN_POINTING_SMALL_TRIANGLE						0x25BF
#define U_BLACK_LEFT_POINTING_TRIANGLE							0x25C0
#define U_WHITE_LEFT_POINTING_TRIANGLE							0x25C1
#define U_BLACK_LEFT_POINTING_SMALL_TRIANGLE						0x25C2
#define U_WHITE_LEFT_POINTING_SMALL_TRIANGLE						0x25C3
#define U_BLACK_LEFT_POINTING_POINTER							0x25C4
#define U_WHITE_LEFT_POINTING_POINTER							0x25C5
#define U_BLACK_DIAMOND									0x25C6
#define U_WHITE_DIAMOND									0x25C7
#define U_WHITE_DIAMOND_CONTAINING_BLACK_SMALL_DIAMOND					0x25C8
#define U_FISHEYE									0x25C9
#define U_LOZENGE									0x25CA
#define U_WHITE_CIRCLE									0x25CB
#define U_DOTTED_CIRCLE									0x25CC
#define U_CIRCLE_WITH_VERTICAL_FILL							0x25CD
#define U_BULLSEYE									0x25CE
#define U_BLACK_CIRCLE									0x25CF
#define U_CIRCLE_WITH_LEFT_HALF_BLACK							0x25D0
#define U_CIRCLE_WITH_RIGHT_HALF_BLACK							0x25D1
#define U_CIRCLE_WITH_LOWER_HALF_BLACK							0x25D2
#define U_CIRCLE_WITH_UPPER_HALF_BLACK							0x25D3
#define U_CIRCLE_WITH_UPPER_RIGHT_QUADRANT_BLACK					0x25D4
#define U_CIRCLE_WITH_ALL_BUT_UPPER_LEFT_QUADRANT_BLACK					0x25D5
#define U_LEFT_HALF_BLACK_CIRCLE							0x25D6
#define U_RIGHT_HALF_BLACK_CIRCLE							0x25D7
#define U_INVERSE_BULLET								0x25D8
#define U_INVERSE_WHITE_CIRCLE								0x25D9
#define U_UPPER_HALF_INVERSE_WHITE_CIRCLE						0x25DA
#define U_LOWER_HALF_INVERSE_WHITE_CIRCLE						0x25DB
#define U_UPPER_LEFT_QUADRANT_CIRCULAR_ARC						0x25DC
#define U_UPPER_RIGHT_QUADRANT_CIRCULAR_ARC						0x25DD
#define U_LOWER_RIGHT_QUADRANT_CIRCULAR_ARC						0x25DE
#define U_LOWER_LEFT_QUADRANT_CIRCULAR_ARC						0x25DF
#define U_UPPER_HALF_CIRCLE								0x25E0
#define U_LOWER_HALF_CIRCLE								0x25E1
#define U_BLACK_LOWER_RIGHT_TRIANGLE							0x25E2
#define U_BLACK_LOWER_LEFT_TRIANGLE							0x25E3
#define U_BLACK_UPPER_LEFT_TRIANGLE							0x25E4
#define U_BLACK_UPPER_RIGHT_TRIANGLE							0x25E5
#define U_WHITE_BULLET									0x25E6
#define U_SQUARE_WITH_LEFT_HALF_BLACK							0x25E7
#define U_SQUARE_WITH_RIGHT_HALF_BLACK							0x25E8
#define U_SQUARE_WITH_UPPER_LEFT_DIAGONAL_HALF_BLACK					0x25E9
#define U_SQUARE_WITH_LOWER_RIGHT_DIAGONAL_HALF_BLACK					0x25EA
#define U_WHITE_SQUARE_WITH_VERTICAL_BISECTING_LINE					0x25EB
#define U_WHITE_UP_POINTING_TRIANGLE_WITH_DOT						0x25EC
#define U_UP_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK					0x25ED
#define U_UP_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK					0x25EE
#define U_LARGE_CIRCLE									0x25EF
#define U_BLACK_SUN_WITH_RAYS								0x2600
#define U_CLOUD										0x2601
#define U_UMBRELLA									0x2602
#define U_SNOWMAN									0x2603
#define U_COMET										0x2604
#define U_BLACK_STAR									0x2605
#define U_WHITE_STAR									0x2606
#define U_LIGHTNING									0x2607
#define U_THUNDERSTORM									0x2608
#define U_SUN										0x2609
#define U_ASCENDING_NODE								0x260A
#define U_DESCENDING_NODE								0x260B
#define U_CONJUNCTION									0x260C
#define U_OPPOSITION									0x260D
#define U_BLACK_TELEPHONE								0x260E
#define U_WHITE_TELEPHONE								0x260F
#define U_BALLOT_BOX									0x2610
#define U_BALLOT_BOX_WITH_CHECK								0x2611
#define U_BALLOT_BOX_WITH_X								0x2612
#define U_SALTIRE									0x2613
#define U_BLACK_LEFT_POINTING_INDEX							0x261A
#define U_BLACK_RIGHT_POINTING_INDEX							0x261B
#define U_WHITE_LEFT_POINTING_INDEX							0x261C
#define U_WHITE_UP_POINTING_INDEX							0x261D
#define U_WHITE_RIGHT_POINTING_INDEX							0x261E
#define U_WHITE_DOWN_POINTING_INDEX							0x261F
#define U_SKULL_AND_CROSSBONES								0x2620
#define U_CAUTION_SIGN									0x2621
#define U_RADIOACTIVE_SIGN								0x2622
#define U_BIOHAZARD_SIGN								0x2623
#define U_CADUCEUS									0x2624
#define U_ANKH										0x2625
#define U_ORTHODOX_CROSS								0x2626
#define U_CHI_RHO									0x2627
#define U_CROSS_OF_LORRAINE								0x2628
#define U_CROSS_OF_JERUSALEM								0x2629
#define U_STAR_AND_CRESCENT								0x262A
#define U_FARSI_SYMBOL									0x262B
#define U_ADI_SHAKTI									0x262C
#define U_HAMMER_AND_SICKLE								0x262D
#define U_PEACE_SYMBOL									0x262E
#define U_YIN_YANG									0x262F
#define U_TRIGRAM_FOR_HEAVEN								0x2630
#define U_TRIGRAM_FOR_LAKE								0x2631
#define U_TRIGRAM_FOR_FIRE								0x2632
#define U_TRIGRAM_FOR_THUNDER								0x2633
#define U_TRIGRAM_FOR_WIND								0x2634
#define U_TRIGRAM_FOR_WATER								0x2635
#define U_TRIGRAM_FOR_MOUNTAIN								0x2636
#define U_TRIGRAM_FOR_EARTH								0x2637
#define U_WHEEL_OF_DHARMA								0x2638
#define U_WHITE_FROWNING_FACE								0x2639
#define U_WHITE_SMILING_FACE								0x263A
#define U_BLACK_SMILING_FACE								0x263B
#define U_WHITE_SUN_WITH_RAYS								0x263C
#define U_FIRST_QUARTER_MOON								0x263D
#define U_LAST_QUARTER_MOON								0x263E
#define U_MERCURY									0x263F
#define U_FEMALE_SIGN									0x2640
#define U_EARTH										0x2641
#define U_MALE_SIGN									0x2642
#define U_JUPITER									0x2643
#define U_SATURN									0x2644
#define U_URANUS									0x2645
#define U_NEPTUNE									0x2646
#define U_PLUTO										0x2647
#define U_ARIES										0x2648
#define U_TAURUS									0x2649
#define U_GEMINI									0x264A
#define U_CANCER									0x264B
#define U_LEO										0x264C
#define U_VIRGO										0x264D
#define U_LIBRA										0x264E
#define U_SCORPIUS									0x264F
#define U_SAGITTARIUS									0x2650
#define U_CAPRICORN									0x2651
#define U_AQUARIUS									0x2652
#define U_PISCES									0x2653
#define U_WHITE_CHESS_KING								0x2654
#define U_WHITE_CHESS_QUEEN								0x2655
#define U_WHITE_CHESS_ROOK								0x2656
#define U_WHITE_CHESS_BISHOP								0x2657
#define U_WHITE_CHESS_KNIGHT								0x2658
#define U_WHITE_CHESS_PAWN								0x2659
#define U_BLACK_CHESS_KING								0x265A
#define U_BLACK_CHESS_QUEEN								0x265B
#define U_BLACK_CHESS_ROOK								0x265C
#define U_BLACK_CHESS_BISHOP								0x265D
#define U_BLACK_CHESS_KNIGHT								0x265E
#define U_BLACK_CHESS_PAWN								0x265F
#define U_BLACK_SPADE_SUIT								0x2660
#define U_WHITE_HEART_SUIT								0x2661
#define U_WHITE_DIAMOND_SUIT								0x2662
#define U_BLACK_CLUB_SUIT								0x2663
#define U_WHITE_SPADE_SUIT								0x2664
#define U_BLACK_HEART_SUIT								0x2665
#define U_BLACK_DIAMOND_SUIT								0x2666
#define U_WHITE_CLUB_SUIT								0x2667
#define U_HOT_SPRINGS									0x2668
#define U_QUARTER_NOTE									0x2669
#define U_EIGHTH_NOTE									0x266A
#define U_BEAMED_EIGHTH_NOTES								0x266B
#define U_BEAMED_SIXTEENTH_NOTES							0x266C
#define U_MUSIC_FLAT_SIGN								0x266D
#define U_MUSIC_NATURAL_SIGN								0x266E
#define U_MUSIC_SHARP_SIGN								0x266F
#define U_UPPER_BLADE_SCISSORS								0x2701
#define U_BLACK_SCISSORS								0x2702
#define U_LOWER_BLADE_SCISSORS								0x2703
#define U_WHITE_SCISSORS								0x2704
#define U_TELEPHONE_LOCATION_SIGN							0x2706
#define U_TAPE_DRIVE									0x2707
#define U_AIRPLANE									0x2708
#define U_ENVELOPE									0x2709
#define U_VICTORY_HAND									0x270C
#define U_WRITING_HAND									0x270D
#define U_LOWER_RIGHT_PENCIL								0x270E
#define U_PENCIL									0x270F
#define U_UPPER_RIGHT_PENCIL								0x2710
#define U_WHITE_NIB									0x2711
#define U_BLACK_NIB									0x2712
#define U_CHECK_MARK									0x2713
#define U_HEAVY_CHECK_MARK								0x2714
#define U_MULTIPLICATION_X								0x2715
#define U_HEAVY_MULTIPLICATION_X							0x2716
#define U_BALLOT_X									0x2717
#define U_HEAVY_BALLOT_X								0x2718
#define U_OUTLINED_GREEK_CROSS								0x2719
#define U_HEAVY_GREEK_CROSS								0x271A
#define U_OPEN_CENTRE_CROSS								0x271B
#define U_HEAVY_OPEN_CENTRE_CROSS							0x271C
#define U_LATIN_CROSS									0x271D
#define U_SHADOWED_WHITE_LATIN_CROSS							0x271E
#define U_OUTLINED_LATIN_CROSS								0x271F
#define U_MALTESE_CROSS									0x2720
#define U_STAR_OF_DAVID									0x2721
#define U_FOUR_TEARDROP_SPOKED_ASTERISK							0x2722
#define U_FOUR_BALLOON_SPOKED_ASTERISK							0x2723
#define U_HEAVY_FOUR_BALLOON_SPOKED_ASTERISK						0x2724
#define U_FOUR_CLUB_SPOKED_ASTERISK							0x2725
#define U_BLACK_FOUR_POINTED_STAR							0x2726
#define U_WHITE_FOUR_POINTED_STAR							0x2727
#define U_STRESS_OUTLINED_WHITE_STAR							0x2729
#define U_CIRCLED_WHITE_STAR								0x272A
#define U_OPEN_CENTRE_BLACK_STAR							0x272B
#define U_BLACK_CENTRE_WHITE_STAR							0x272C
#define U_OUTLINED_BLACK_STAR								0x272D
#define U_HEAVY_OUTLINED_BLACK_STAR							0x272E
#define U_PINWHEEL_STAR									0x272F
#define U_SHADOWED_WHITE_STAR								0x2730
#define U_HEAVY_ASTERISK								0x2731
#define U_OPEN_CENTRE_ASTERISK								0x2732
#define U_EIGHT_SPOKED_ASTERISK								0x2733
#define U_EIGHT_POINTED_BLACK_STAR							0x2734
#define U_EIGHT_POINTED_PINWHEEL_STAR							0x2735
#define U_SIX_POINTED_BLACK_STAR							0x2736
#define U_EIGHT_POINTED_RECTILINEAR_BLACK_STAR						0x2737
#define U_HEAVY_EIGHT_POINTED_RECTILINEAR_BLACK_STAR					0x2738
#define U_TWELVE_POINTED_BLACK_STAR							0x2739
#define U_SIXTEEN_POINTED_ASTERISK							0x273A
#define U_TEARDROP_SPOKED_ASTERISK							0x273B
#define U_OPEN_CENTRE_TEARDROP_SPOKED_ASTERISK						0x273C
#define U_HEAVY_TEARDROP_SPOKED_ASTERISK						0x273D
#define U_SIX_PETALLED_BLACK_AND_WHITE_FLORETTE						0x273E
#define U_BLACK_FLORETTE								0x273F
#define U_WHITE_FLORETTE								0x2740
#define U_EIGHT_PETALLED_OUTLINED_BLACK_FLORETTE					0x2741
#define U_CIRCLED_OPEN_CENTRE_EIGHT_POINTED_STAR					0x2742
#define U_HEAVY_TEARDROP_SPOKED_PINWHEEL_ASTERISK					0x2743
#define U_SNOWFLAKE									0x2744
#define U_TIGHT_TRIFOLIATE_SNOWFLAKE							0x2745
#define U_HEAVY_CHEVRON_SNOWFLAKE							0x2746
#define U_SPARKLE									0x2747
#define U_HEAVY_SPARKLE									0x2748
#define U_BALLOON_SPOKED_ASTERISK							0x2749
#define U_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK					0x274A
#define U_HEAVY_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK				0x274B
#define U_SHADOWED_WHITE_CIRCLE								0x274D
#define U_LOWER_RIGHT_DROP_SHADOWED_WHITE_SQUARE					0x274F
#define U_UPPER_RIGHT_DROP_SHADOWED_WHITE_SQUARE					0x2750
#define U_LOWER_RIGHT_SHADOWED_WHITE_SQUARE						0x2751
#define U_UPPER_RIGHT_SHADOWED_WHITE_SQUARE						0x2752
#define U_BLACK_DIAMOND_MINUS_WHITE_X							0x2756
#define U_LIGHT_VERTICAL_BAR								0x2758
#define U_MEDIUM_VERTICAL_BAR								0x2759
#define U_HEAVY_VERTICAL_BAR								0x275A
#define U_HEAVY_SINGLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT				0x275B
#define U_HEAVY_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT					0x275C
#define U_HEAVY_DOUBLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT				0x275D
#define U_HEAVY_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT					0x275E
#define U_CURVED_STEM_PARAGRAPH_SIGN_ORNAMENT						0x2761
#define U_HEAVY_EXCLAMATION_MARK_ORNAMENT						0x2762
#define U_HEAVY_HEART_EXCLAMATION_MARK_ORNAMENT						0x2763
#define U_HEAVY_BLACK_HEART								0x2764
#define U_ROTATED_HEAVY_BLACK_HEART_BULLET						0x2765
#define U_FLORAL_HEART									0x2766
#define U_ROTATED_FLORAL_HEART_BULLET							0x2767
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_ONE						0x2776
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_TWO						0x2777
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_THREE						0x2778
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_FOUR						0x2779
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_FIVE						0x277A
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_SIX						0x277B
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_SEVEN						0x277C
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_EIGHT						0x277D
#define U_DINGBAT_NEGATIVE_CIRCLED_DIGIT_NINE						0x277E
#define U_DINGBAT_NEGATIVE_CIRCLED_NUMBER_TEN						0x277F
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_ONE						0x2780
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_TWO						0x2781
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_THREE					0x2782
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FOUR						0x2783
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FIVE						0x2784
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SIX						0x2785
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SEVEN					0x2786
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_EIGHT					0x2787
#define U_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_NINE						0x2788
#define U_DINGBAT_CIRCLED_SANS_SERIF_NUMBER_TEN						0x2789
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_ONE					0x278A
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_TWO					0x278B
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_THREE				0x278C
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FOUR				0x278D
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FIVE				0x278E
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SIX					0x278F
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SEVEN				0x2790
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_EIGHT				0x2791
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_NINE				0x2792
#define U_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_NUMBER_TEN				0x2793
#define U_HEAVY_WIDE_HEADED_RIGHTWARDS_ARROW						0x2794
#define U_HEAVY_SOUTH_EAST_ARROW							0x2798
#define U_HEAVY_RIGHTWARDS_ARROW							0x2799
#define U_HEAVY_NORTH_EAST_ARROW							0x279A
#define U_DRAFTING_POINT_RIGHTWARDS_ARROW						0x279B
#define U_HEAVY_ROUND_TIPPED_RIGHTWARDS_ARROW						0x279C
#define U_TRIANGLE_HEADED_RIGHTWARDS_ARROW						0x279D
#define U_HEAVY_TRIANGLE_HEADED_RIGHTWARDS_ARROW					0x279E
#define U_DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW					0x279F
#define U_HEAVY_DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW					0x27A0
#define U_BLACK_RIGHTWARDS_ARROW							0x27A1
#define U_THREE_D_TOP_LIGHTED_RIGHTWARDS_ARROWHEAD					0x27A2
#define U_THREE_D_BOTTOM_LIGHTED_RIGHTWARDS_ARROWHEAD					0x27A3
#define U_BLACK_RIGHTWARDS_ARROWHEAD							0x27A4
#define U_HEAVY_BLACK_CURVED_DOWNWARDS_AND_RIGHTWARDS_ARROW				0x27A5
#define U_HEAVY_BLACK_CURVED_UPWARDS_AND_RIGHTWARDS_ARROW				0x27A6
#define U_SQUAT_BLACK_RIGHTWARDS_ARROW							0x27A7
#define U_HEAVY_CONCAVE_POINTED_BLACK_RIGHTWARDS_ARROW					0x27A8
#define U_RIGHT_SHADED_WHITE_RIGHTWARDS_ARROW						0x27A9
#define U_LEFT_SHADED_WHITE_RIGHTWARDS_ARROW						0x27AA
#define U_BACK_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW					0x27AB
#define U_FRONT_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW					0x27AC
#define U_HEAVY_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW				0x27AD
#define U_HEAVY_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW				0x27AE
#define U_NOTCHED_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW				0x27AF
#define U_NOTCHED_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW				0x27B1
#define U_CIRCLED_HEAVY_WHITE_RIGHTWARDS_ARROW						0x27B2
#define U_WHITE_FEATHERED_RIGHTWARDS_ARROW						0x27B3
#define U_BLACK_FEATHERED_SOUTH_EAST_ARROW						0x27B4
#define U_BLACK_FEATHERED_RIGHTWARDS_ARROW						0x27B5
#define U_BLACK_FEATHERED_NORTH_EAST_ARROW						0x27B6
#define U_HEAVY_BLACK_FEATHERED_SOUTH_EAST_ARROW					0x27B7
#define U_HEAVY_BLACK_FEATHERED_RIGHTWARDS_ARROW					0x27B8
#define U_HEAVY_BLACK_FEATHERED_NORTH_EAST_ARROW					0x27B9
#define U_TEARDROP_BARBED_RIGHTWARDS_ARROW						0x27BA
#define U_HEAVY_TEARDROP_SHANKED_RIGHTWARDS_ARROW					0x27BB
#define U_WEDGE_TAILED_RIGHTWARDS_ARROW							0x27BC
#define U_HEAVY_WEDGE_TAILED_RIGHTWARDS_ARROW						0x27BD
#define U_OPEN_OUTLINED_RIGHTWARDS_ARROW						0x27BE
#define U_IDEOGRAPHIC_SPACE								0x3000
#define U_IDEOGRAPHIC_COMMA								0x3001
#define U_IDEOGRAPHIC_FULL_STOP								0x3002
#define U_DITTO_MARK									0x3003
#define U_JAPANESE_INDUSTRIAL_STANDARD_SYMBOL						0x3004
#define U_IDEOGRAPHIC_ITERATION_MARK							0x3005
#define U_IDEOGRAPHIC_CLOSING_MARK							0x3006
#define U_IDEOGRAPHIC_NUMBER_ZERO							0x3007
#define U_LEFT_ANGLE_BRACKET								0x3008
#define U_RIGHT_ANGLE_BRACKET								0x3009
#define U_LEFT_DOUBLE_ANGLE_BRACKET							0x300A
#define U_RIGHT_DOUBLE_ANGLE_BRACKET							0x300B
#define U_LEFT_CORNER_BRACKET								0x300C
#define U_RIGHT_CORNER_BRACKET								0x300D
#define U_LEFT_WHITE_CORNER_BRACKET							0x300E
#define U_RIGHT_WHITE_CORNER_BRACKET							0x300F
#define U_LEFT_BLACK_LENTICULAR_BRACKET							0x3010
#define U_RIGHT_BLACK_LENTICULAR_BRACKET						0x3011
#define U_POSTAL_MARK									0x3012
#define U_GETA_MARK									0x3013
#define U_LEFT_TORTOISE_SHELL_BRACKET							0x3014
#define U_RIGHT_TORTOISE_SHELL_BRACKET							0x3015
#define U_LEFT_WHITE_LENTICULAR_BRACKET							0x3016
#define U_RIGHT_WHITE_LENTICULAR_BRACKET						0x3017
#define U_LEFT_WHITE_TORTOISE_SHELL_BRACKET						0x3018
#define U_RIGHT_WHITE_TORTOISE_SHELL_BRACKET						0x3019
#define U_LEFT_WHITE_SQUARE_BRACKET							0x301A
#define U_RIGHT_WHITE_SQUARE_BRACKET							0x301B
#define U_WAVE_DASH									0x301C
#define U_REVERSED_DOUBLE_PRIME_QUOTATION_MARK						0x301D
#define U_DOUBLE_PRIME_QUOTATION_MARK							0x301E
#define U_LOW_DOUBLE_PRIME_QUOTATION_MARK						0x301F
#define U_POSTAL_MARK_FACE								0x3020
#define U_HANGZHOU_NUMERAL_ONE								0x3021
#define U_HANGZHOU_NUMERAL_TWO								0x3022
#define U_HANGZHOU_NUMERAL_THREE							0x3023
#define U_HANGZHOU_NUMERAL_FOUR								0x3024
#define U_HANGZHOU_NUMERAL_FIVE								0x3025
#define U_HANGZHOU_NUMERAL_SIX								0x3026
#define U_HANGZHOU_NUMERAL_SEVEN							0x3027
#define U_HANGZHOU_NUMERAL_EIGHT							0x3028
#define U_HANGZHOU_NUMERAL_NINE								0x3029
#define U_IDEOGRAPHIC_LEVEL_TONE_MARK							0x302A
#define U_IDEOGRAPHIC_RISING_TONE_MARK							0x302B
#define U_IDEOGRAPHIC_DEPARTING_TONE_MARK						0x302C
#define U_IDEOGRAPHIC_ENTERING_TONE_MARK						0x302D
#define U_HANGUL_SINGLE_DOT_TONE_MARK							0x302E
#define U_HANGUL_DOUBLE_DOT_TONE_MARK							0x302F
#define U_WAVY_DASH									0x3030
#define U_VERTICAL_KANA_REPEAT_MARK							0x3031
#define U_VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK					0x3032
#define U_VERTICAL_KANA_REPEAT_MARK_UPPER_HALF						0x3033
#define U_VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK_UPPER_HALF			0x3034
#define U_VERTICAL_KANA_REPEAT_MARK_LOWER_HALF						0x3035
#define U_CIRCLED_POSTAL_MARK								0x3036
#define U_IDEOGRAPHIC_TELEGRAPH_LINE_FEED_SEPARATOR_SYMBOL				0x3037
#define U_IDEOGRAPHIC_HALF_FILL_SPACE							0x303F
#define U_HIRAGANA_LETTER_SMALL_A							0x3041
#define U_HIRAGANA_LETTER_A								0x3042
#define U_HIRAGANA_LETTER_SMALL_I							0x3043
#define U_HIRAGANA_LETTER_I								0x3044
#define U_HIRAGANA_LETTER_SMALL_U							0x3045
#define U_HIRAGANA_LETTER_U								0x3046
#define U_HIRAGANA_LETTER_SMALL_E							0x3047
#define U_HIRAGANA_LETTER_E								0x3048
#define U_HIRAGANA_LETTER_SMALL_O							0x3049
#define U_HIRAGANA_LETTER_O								0x304A
#define U_HIRAGANA_LETTER_KA								0x304B
#define U_HIRAGANA_LETTER_GA								0x304C
#define U_HIRAGANA_LETTER_KI								0x304D
#define U_HIRAGANA_LETTER_GI								0x304E
#define U_HIRAGANA_LETTER_KU								0x304F
#define U_HIRAGANA_LETTER_GU								0x3050
#define U_HIRAGANA_LETTER_KE								0x3051
#define U_HIRAGANA_LETTER_GE								0x3052
#define U_HIRAGANA_LETTER_KO								0x3053
#define U_HIRAGANA_LETTER_GO								0x3054
#define U_HIRAGANA_LETTER_SA								0x3055
#define U_HIRAGANA_LETTER_ZA								0x3056
#define U_HIRAGANA_LETTER_SI								0x3057
#define U_HIRAGANA_LETTER_ZI								0x3058
#define U_HIRAGANA_LETTER_SU								0x3059
#define U_HIRAGANA_LETTER_ZU								0x305A
#define U_HIRAGANA_LETTER_SE								0x305B
#define U_HIRAGANA_LETTER_ZE								0x305C
#define U_HIRAGANA_LETTER_SO								0x305D
#define U_HIRAGANA_LETTER_ZO								0x305E
#define U_HIRAGANA_LETTER_TA								0x305F
#define U_HIRAGANA_LETTER_DA								0x3060
#define U_HIRAGANA_LETTER_TI								0x3061
#define U_HIRAGANA_LETTER_DI								0x3062
#define U_HIRAGANA_LETTER_SMALL_TU							0x3063
#define U_HIRAGANA_LETTER_TU								0x3064
#define U_HIRAGANA_LETTER_DU								0x3065
#define U_HIRAGANA_LETTER_TE								0x3066
#define U_HIRAGANA_LETTER_DE								0x3067
#define U_HIRAGANA_LETTER_TO								0x3068
#define U_HIRAGANA_LETTER_DO								0x3069
#define U_HIRAGANA_LETTER_NA								0x306A
#define U_HIRAGANA_LETTER_NI								0x306B
#define U_HIRAGANA_LETTER_NU								0x306C
#define U_HIRAGANA_LETTER_NE								0x306D
#define U_HIRAGANA_LETTER_NO								0x306E
#define U_HIRAGANA_LETTER_HA								0x306F
#define U_HIRAGANA_LETTER_BA								0x3070
#define U_HIRAGANA_LETTER_PA								0x3071
#define U_HIRAGANA_LETTER_HI								0x3072
#define U_HIRAGANA_LETTER_BI								0x3073
#define U_HIRAGANA_LETTER_PI								0x3074
#define U_HIRAGANA_LETTER_HU								0x3075
#define U_HIRAGANA_LETTER_BU								0x3076
#define U_HIRAGANA_LETTER_PU								0x3077
#define U_HIRAGANA_LETTER_HE								0x3078
#define U_HIRAGANA_LETTER_BE								0x3079
#define U_HIRAGANA_LETTER_PE								0x307A
#define U_HIRAGANA_LETTER_HO								0x307B
#define U_HIRAGANA_LETTER_BO								0x307C
#define U_HIRAGANA_LETTER_PO								0x307D
#define U_HIRAGANA_LETTER_MA								0x307E
#define U_HIRAGANA_LETTER_MI								0x307F
#define U_HIRAGANA_LETTER_MU								0x3080
#define U_HIRAGANA_LETTER_ME								0x3081
#define U_HIRAGANA_LETTER_MO								0x3082
#define U_HIRAGANA_LETTER_SMALL_YA							0x3083
#define U_HIRAGANA_LETTER_YA								0x3084
#define U_HIRAGANA_LETTER_SMALL_YU							0x3085
#define U_HIRAGANA_LETTER_YU								0x3086
#define U_HIRAGANA_LETTER_SMALL_YO							0x3087
#define U_HIRAGANA_LETTER_YO								0x3088
#define U_HIRAGANA_LETTER_RA								0x3089
#define U_HIRAGANA_LETTER_RI								0x308A
#define U_HIRAGANA_LETTER_RU								0x308B
#define U_HIRAGANA_LETTER_RE								0x308C
#define U_HIRAGANA_LETTER_RO								0x308D
#define U_HIRAGANA_LETTER_SMALL_WA							0x308E
#define U_HIRAGANA_LETTER_WA								0x308F
#define U_HIRAGANA_LETTER_WI								0x3090
#define U_HIRAGANA_LETTER_WE								0x3091
#define U_HIRAGANA_LETTER_WO								0x3092
#define U_HIRAGANA_LETTER_N								0x3093
#define U_HIRAGANA_LETTER_VU								0x3094
#define U_COMBINING_KATAKANA_HIRAGANA_VOICED_SOUND_MARK					0x3099
#define U_COMBINING_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK				0x309A
#define U_KATAKANA_HIRAGANA_VOICED_SOUND_MARK						0x309B
#define U_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK					0x309C
#define U_HIRAGANA_ITERATION_MARK							0x309D
#define U_HIRAGANA_VOICED_ITERATION_MARK						0x309E
#define U_KATAKANA_LETTER_SMALL_A							0x30A1
#define U_KATAKANA_LETTER_A								0x30A2
#define U_KATAKANA_LETTER_SMALL_I							0x30A3
#define U_KATAKANA_LETTER_I								0x30A4
#define U_KATAKANA_LETTER_SMALL_U							0x30A5
#define U_KATAKANA_LETTER_U								0x30A6
#define U_KATAKANA_LETTER_SMALL_E							0x30A7
#define U_KATAKANA_LETTER_E								0x30A8
#define U_KATAKANA_LETTER_SMALL_O							0x30A9
#define U_KATAKANA_LETTER_O								0x30AA
#define U_KATAKANA_LETTER_KA								0x30AB
#define U_KATAKANA_LETTER_GA								0x30AC
#define U_KATAKANA_LETTER_KI								0x30AD
#define U_KATAKANA_LETTER_GI								0x30AE
#define U_KATAKANA_LETTER_KU								0x30AF
#define U_KATAKANA_LETTER_GU								0x30B0
#define U_KATAKANA_LETTER_KE								0x30B1
#define U_KATAKANA_LETTER_GE								0x30B2
#define U_KATAKANA_LETTER_KO								0x30B3
#define U_KATAKANA_LETTER_GO								0x30B4
#define U_KATAKANA_LETTER_SA								0x30B5
#define U_KATAKANA_LETTER_ZA								0x30B6
#define U_KATAKANA_LETTER_SI								0x30B7
#define U_KATAKANA_LETTER_ZI								0x30B8
#define U_KATAKANA_LETTER_SU								0x30B9
#define U_KATAKANA_LETTER_ZU								0x30BA
#define U_KATAKANA_LETTER_SE								0x30BB
#define U_KATAKANA_LETTER_ZE								0x30BC
#define U_KATAKANA_LETTER_SO								0x30BD
#define U_KATAKANA_LETTER_ZO								0x30BE
#define U_KATAKANA_LETTER_TA								0x30BF
#define U_KATAKANA_LETTER_DA								0x30C0
#define U_KATAKANA_LETTER_TI								0x30C1
#define U_KATAKANA_LETTER_DI								0x30C2
#define U_KATAKANA_LETTER_SMALL_TU							0x30C3
#define U_KATAKANA_LETTER_TU								0x30C4
#define U_KATAKANA_LETTER_DU								0x30C5
#define U_KATAKANA_LETTER_TE								0x30C6
#define U_KATAKANA_LETTER_DE								0x30C7
#define U_KATAKANA_LETTER_TO								0x30C8
#define U_KATAKANA_LETTER_DO								0x30C9
#define U_KATAKANA_LETTER_NA								0x30CA
#define U_KATAKANA_LETTER_NI								0x30CB
#define U_KATAKANA_LETTER_NU								0x30CC
#define U_KATAKANA_LETTER_NE								0x30CD
#define U_KATAKANA_LETTER_NO								0x30CE
#define U_KATAKANA_LETTER_HA								0x30CF
#define U_KATAKANA_LETTER_BA								0x30D0
#define U_KATAKANA_LETTER_PA								0x30D1
#define U_KATAKANA_LETTER_HI								0x30D2
#define U_KATAKANA_LETTER_BI								0x30D3
#define U_KATAKANA_LETTER_PI								0x30D4
#define U_KATAKANA_LETTER_HU								0x30D5
#define U_KATAKANA_LETTER_BU								0x30D6
#define U_KATAKANA_LETTER_PU								0x30D7
#define U_KATAKANA_LETTER_HE								0x30D8
#define U_KATAKANA_LETTER_BE								0x30D9
#define U_KATAKANA_LETTER_PE								0x30DA
#define U_KATAKANA_LETTER_HO								0x30DB
#define U_KATAKANA_LETTER_BO								0x30DC
#define U_KATAKANA_LETTER_PO								0x30DD
#define U_KATAKANA_LETTER_MA								0x30DE
#define U_KATAKANA_LETTER_MI								0x30DF
#define U_KATAKANA_LETTER_MU								0x30E0
#define U_KATAKANA_LETTER_ME								0x30E1
#define U_KATAKANA_LETTER_MO								0x30E2
#define U_KATAKANA_LETTER_SMALL_YA							0x30E3
#define U_KATAKANA_LETTER_YA								0x30E4
#define U_KATAKANA_LETTER_SMALL_YU							0x30E5
#define U_KATAKANA_LETTER_YU								0x30E6
#define U_KATAKANA_LETTER_SMALL_YO							0x30E7
#define U_KATAKANA_LETTER_YO								0x30E8
#define U_KATAKANA_LETTER_RA								0x30E9
#define U_KATAKANA_LETTER_RI								0x30EA
#define U_KATAKANA_LETTER_RU								0x30EB
#define U_KATAKANA_LETTER_RE								0x30EC
#define U_KATAKANA_LETTER_RO								0x30ED
#define U_KATAKANA_LETTER_SMALL_WA							0x30EE
#define U_KATAKANA_LETTER_WA								0x30EF
#define U_KATAKANA_LETTER_WI								0x30F0
#define U_KATAKANA_LETTER_WE								0x30F1
#define U_KATAKANA_LETTER_WO								0x30F2
#define U_KATAKANA_LETTER_N								0x30F3
#define U_KATAKANA_LETTER_VU								0x30F4
#define U_KATAKANA_LETTER_SMALL_KA							0x30F5
#define U_KATAKANA_LETTER_SMALL_KE							0x30F6
#define U_KATAKANA_LETTER_VA								0x30F7
#define U_KATAKANA_LETTER_VI								0x30F8
#define U_KATAKANA_LETTER_VE								0x30F9
#define U_KATAKANA_LETTER_VO								0x30FA
#define U_KATAKANA_MIDDLE_DOT								0x30FB
#define U_KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK					0x30FC
#define U_KATAKANA_ITERATION_MARK							0x30FD
#define U_KATAKANA_VOICED_ITERATION_MARK						0x30FE
#define U_BOPOMOFO_LETTER_B								0x3105
#define U_BOPOMOFO_LETTER_P								0x3106
#define U_BOPOMOFO_LETTER_M								0x3107
#define U_BOPOMOFO_LETTER_F								0x3108
#define U_BOPOMOFO_LETTER_D								0x3109
#define U_BOPOMOFO_LETTER_T								0x310A
#define U_BOPOMOFO_LETTER_N								0x310B
#define U_BOPOMOFO_LETTER_L								0x310C
#define U_BOPOMOFO_LETTER_G								0x310D
#define U_BOPOMOFO_LETTER_K								0x310E
#define U_BOPOMOFO_LETTER_H								0x310F
#define U_BOPOMOFO_LETTER_J								0x3110
#define U_BOPOMOFO_LETTER_Q								0x3111
#define U_BOPOMOFO_LETTER_X								0x3112
#define U_BOPOMOFO_LETTER_ZH								0x3113
#define U_BOPOMOFO_LETTER_CH								0x3114
#define U_BOPOMOFO_LETTER_SH								0x3115
#define U_BOPOMOFO_LETTER_R								0x3116
#define U_BOPOMOFO_LETTER_Z								0x3117
#define U_BOPOMOFO_LETTER_C								0x3118
#define U_BOPOMOFO_LETTER_S								0x3119
#define U_BOPOMOFO_LETTER_A								0x311A
#define U_BOPOMOFO_LETTER_O								0x311B
#define U_BOPOMOFO_LETTER_E								0x311C
#define U_BOPOMOFO_LETTER_EH								0x311D
#define U_BOPOMOFO_LETTER_AI								0x311E
#define U_BOPOMOFO_LETTER_EI								0x311F
#define U_BOPOMOFO_LETTER_AU								0x3120
#define U_BOPOMOFO_LETTER_OU								0x3121
#define U_BOPOMOFO_LETTER_AN								0x3122
#define U_BOPOMOFO_LETTER_EN								0x3123
#define U_BOPOMOFO_LETTER_ANG								0x3124
#define U_BOPOMOFO_LETTER_ENG								0x3125
#define U_BOPOMOFO_LETTER_ER								0x3126
#define U_BOPOMOFO_LETTER_I								0x3127
#define U_BOPOMOFO_LETTER_U								0x3128
#define U_BOPOMOFO_LETTER_IU								0x3129
#define U_BOPOMOFO_LETTER_V								0x312A
#define U_BOPOMOFO_LETTER_NG								0x312B
#define U_BOPOMOFO_LETTER_GN								0x312C
#define U_HANGUL_LETTER_KIYEOK								0x3131
#define U_HANGUL_LETTER_SSANGKIYEOK							0x3132
#define U_HANGUL_LETTER_KIYEOK_SIOS							0x3133
#define U_HANGUL_LETTER_NIEUN								0x3134
#define U_HANGUL_LETTER_NIEUN_CIEUC							0x3135
#define U_HANGUL_LETTER_NIEUN_HIEUH							0x3136
#define U_HANGUL_LETTER_TIKEUT								0x3137
#define U_HANGUL_LETTER_SSANGTIKEUT							0x3138
#define U_HANGUL_LETTER_RIEUL								0x3139
#define U_HANGUL_LETTER_RIEUL_KIYEOK							0x313A
#define U_HANGUL_LETTER_RIEUL_MIEUM							0x313B
#define U_HANGUL_LETTER_RIEUL_PIEUP							0x313C
#define U_HANGUL_LETTER_RIEUL_SIOS							0x313D
#define U_HANGUL_LETTER_RIEUL_THIEUTH							0x313E
#define U_HANGUL_LETTER_RIEUL_PHIEUPH							0x313F
#define U_HANGUL_LETTER_RIEUL_HIEUH							0x3140
#define U_HANGUL_LETTER_MIEUM								0x3141
#define U_HANGUL_LETTER_PIEUP								0x3142
#define U_HANGUL_LETTER_SSANGPIEUP							0x3143
#define U_HANGUL_LETTER_PIEUP_SIOS							0x3144
#define U_HANGUL_LETTER_SIOS								0x3145
#define U_HANGUL_LETTER_SSANGSIOS							0x3146
#define U_HANGUL_LETTER_IEUNG								0x3147
#define U_HANGUL_LETTER_CIEUC								0x3148
#define U_HANGUL_LETTER_SSANGCIEUC							0x3149
#define U_HANGUL_LETTER_CHIEUCH								0x314A
#define U_HANGUL_LETTER_KHIEUKH								0x314B
#define U_HANGUL_LETTER_THIEUTH								0x314C
#define U_HANGUL_LETTER_PHIEUPH								0x314D
#define U_HANGUL_LETTER_HIEUH								0x314E
#define U_HANGUL_LETTER_A								0x314F
#define U_HANGUL_LETTER_AE								0x3150
#define U_HANGUL_LETTER_YA								0x3151
#define U_HANGUL_LETTER_YAE								0x3152
#define U_HANGUL_LETTER_EO								0x3153
#define U_HANGUL_LETTER_E								0x3154
#define U_HANGUL_LETTER_YEO								0x3155
#define U_HANGUL_LETTER_YE								0x3156
#define U_HANGUL_LETTER_O								0x3157
#define U_HANGUL_LETTER_WA								0x3158
#define U_HANGUL_LETTER_WAE								0x3159
#define U_HANGUL_LETTER_OE								0x315A
#define U_HANGUL_LETTER_YO								0x315B
#define U_HANGUL_LETTER_U								0x315C
#define U_HANGUL_LETTER_WEO								0x315D
#define U_HANGUL_LETTER_WE								0x315E
#define U_HANGUL_LETTER_WI								0x315F
#define U_HANGUL_LETTER_YU								0x3160
#define U_HANGUL_LETTER_EU								0x3161
#define U_HANGUL_LETTER_YI								0x3162
#define U_HANGUL_LETTER_I								0x3163
#define U_HANGUL_FILLER									0x3164
#define U_HANGUL_LETTER_SSANGNIEUN							0x3165
#define U_HANGUL_LETTER_NIEUN_TIKEUT							0x3166
#define U_HANGUL_LETTER_NIEUN_SIOS							0x3167
#define U_HANGUL_LETTER_NIEUN_PANSIOS							0x3168
#define U_HANGUL_LETTER_RIEUL_KIYEOK_SIOS						0x3169
#define U_HANGUL_LETTER_RIEUL_TIKEUT							0x316A
#define U_HANGUL_LETTER_RIEUL_PIEUP_SIOS						0x316B
#define U_HANGUL_LETTER_RIEUL_PANSIOS							0x316C
#define U_HANGUL_LETTER_RIEUL_YEORINHIEUH						0x316D
#define U_HANGUL_LETTER_MIEUM_PIEUP							0x316E
#define U_HANGUL_LETTER_MIEUM_SIOS							0x316F
#define U_HANGUL_LETTER_MIEUM_PANSIOS							0x3170
#define U_HANGUL_LETTER_KAPYEOUNMIEUM							0x3171
#define U_HANGUL_LETTER_PIEUP_KIYEOK							0x3172
#define U_HANGUL_LETTER_PIEUP_TIKEUT							0x3173
#define U_HANGUL_LETTER_PIEUP_SIOS_KIYEOK						0x3174
#define U_HANGUL_LETTER_PIEUP_SIOS_TIKEUT						0x3175
#define U_HANGUL_LETTER_PIEUP_CIEUC							0x3176
#define U_HANGUL_LETTER_PIEUP_THIEUTH							0x3177
#define U_HANGUL_LETTER_KAPYEOUNPIEUP							0x3178
#define U_HANGUL_LETTER_KAPYEOUNSSANGPIEUP						0x3179
#define U_HANGUL_LETTER_SIOS_KIYEOK							0x317A
#define U_HANGUL_LETTER_SIOS_NIEUN							0x317B
#define U_HANGUL_LETTER_SIOS_TIKEUT							0x317C
#define U_HANGUL_LETTER_SIOS_PIEUP							0x317D
#define U_HANGUL_LETTER_SIOS_CIEUC							0x317E
#define U_HANGUL_LETTER_PANSIOS								0x317F
#define U_HANGUL_LETTER_SSANGIEUNG							0x3180
#define U_HANGUL_LETTER_YESIEUNG							0x3181
#define U_HANGUL_LETTER_YESIEUNG_SIOS							0x3182
#define U_HANGUL_LETTER_YESIEUNG_PANSIOS						0x3183
#define U_HANGUL_LETTER_KAPYEOUNPHIEUPH							0x3184
#define U_HANGUL_LETTER_SSANGHIEUH							0x3185
#define U_HANGUL_LETTER_YEORINHIEUH							0x3186
#define U_HANGUL_LETTER_YO_YA								0x3187
#define U_HANGUL_LETTER_YO_YAE								0x3188
#define U_HANGUL_LETTER_YO_I								0x3189
#define U_HANGUL_LETTER_YU_YEO								0x318A
#define U_HANGUL_LETTER_YU_YE								0x318B
#define U_HANGUL_LETTER_YU_I								0x318C
#define U_HANGUL_LETTER_ARAEA								0x318D
#define U_HANGUL_LETTER_ARAEAE								0x318E
#define U_IDEOGRAPHIC_ANNOTATION_LINKING_MARK						0x3190
#define U_IDEOGRAPHIC_ANNOTATION_REVERSE_MARK						0x3191
#define U_IDEOGRAPHIC_ANNOTATION_ONE_MARK						0x3192
#define U_IDEOGRAPHIC_ANNOTATION_TWO_MARK						0x3193
#define U_IDEOGRAPHIC_ANNOTATION_THREE_MARK						0x3194
#define U_IDEOGRAPHIC_ANNOTATION_FOUR_MARK						0x3195
#define U_IDEOGRAPHIC_ANNOTATION_TOP_MARK						0x3196
#define U_IDEOGRAPHIC_ANNOTATION_MIDDLE_MARK						0x3197
#define U_IDEOGRAPHIC_ANNOTATION_BOTTOM_MARK						0x3198
#define U_IDEOGRAPHIC_ANNOTATION_FIRST_MARK						0x3199
#define U_IDEOGRAPHIC_ANNOTATION_SECOND_MARK						0x319A
#define U_IDEOGRAPHIC_ANNOTATION_THIRD_MARK						0x319B
#define U_IDEOGRAPHIC_ANNOTATION_FOURTH_MARK						0x319C
#define U_IDEOGRAPHIC_ANNOTATION_HEAVEN_MARK						0x319D
#define U_IDEOGRAPHIC_ANNOTATION_EARTH_MARK						0x319E
#define U_IDEOGRAPHIC_ANNOTATION_MAN_MARK						0x319F
#define U_PARENTHESIZED_HANGUL_KIYEOK							0x3200
#define U_PARENTHESIZED_HANGUL_NIEUN							0x3201
#define U_PARENTHESIZED_HANGUL_TIKEUT							0x3202
#define U_PARENTHESIZED_HANGUL_RIEUL							0x3203
#define U_PARENTHESIZED_HANGUL_MIEUM							0x3204
#define U_PARENTHESIZED_HANGUL_PIEUP							0x3205
#define U_PARENTHESIZED_HANGUL_SIOS							0x3206
#define U_PARENTHESIZED_HANGUL_IEUNG							0x3207
#define U_PARENTHESIZED_HANGUL_CIEUC							0x3208
#define U_PARENTHESIZED_HANGUL_CHIEUCH							0x3209
#define U_PARENTHESIZED_HANGUL_KHIEUKH							0x320A
#define U_PARENTHESIZED_HANGUL_THIEUTH							0x320B
#define U_PARENTHESIZED_HANGUL_PHIEUPH							0x320C
#define U_PARENTHESIZED_HANGUL_HIEUH							0x320D
#define U_PARENTHESIZED_HANGUL_KIYEOK_A							0x320E
#define U_PARENTHESIZED_HANGUL_NIEUN_A							0x320F
#define U_PARENTHESIZED_HANGUL_TIKEUT_A							0x3210
#define U_PARENTHESIZED_HANGUL_RIEUL_A							0x3211
#define U_PARENTHESIZED_HANGUL_MIEUM_A							0x3212
#define U_PARENTHESIZED_HANGUL_PIEUP_A							0x3213
#define U_PARENTHESIZED_HANGUL_SIOS_A							0x3214
#define U_PARENTHESIZED_HANGUL_IEUNG_A							0x3215
#define U_PARENTHESIZED_HANGUL_CIEUC_A							0x3216
#define U_PARENTHESIZED_HANGUL_CHIEUCH_A						0x3217
#define U_PARENTHESIZED_HANGUL_KHIEUKH_A						0x3218
#define U_PARENTHESIZED_HANGUL_THIEUTH_A						0x3219
#define U_PARENTHESIZED_HANGUL_PHIEUPH_A						0x321A
#define U_PARENTHESIZED_HANGUL_HIEUH_A							0x321B
#define U_PARENTHESIZED_HANGUL_CIEUC_U							0x321C
#define U_PARENTHESIZED_IDEOGRAPH_ONE							0x3220
#define U_PARENTHESIZED_IDEOGRAPH_TWO							0x3221
#define U_PARENTHESIZED_IDEOGRAPH_THREE							0x3222
#define U_PARENTHESIZED_IDEOGRAPH_FOUR							0x3223
#define U_PARENTHESIZED_IDEOGRAPH_FIVE							0x3224
#define U_PARENTHESIZED_IDEOGRAPH_SIX							0x3225
#define U_PARENTHESIZED_IDEOGRAPH_SEVEN							0x3226
#define U_PARENTHESIZED_IDEOGRAPH_EIGHT							0x3227
#define U_PARENTHESIZED_IDEOGRAPH_NINE							0x3228
#define U_PARENTHESIZED_IDEOGRAPH_TEN							0x3229
#define U_PARENTHESIZED_IDEOGRAPH_MOON							0x322A
#define U_PARENTHESIZED_IDEOGRAPH_FIRE							0x322B
#define U_PARENTHESIZED_IDEOGRAPH_WATER							0x322C
#define U_PARENTHESIZED_IDEOGRAPH_WOOD							0x322D
#define U_PARENTHESIZED_IDEOGRAPH_METAL							0x322E
#define U_PARENTHESIZED_IDEOGRAPH_EARTH							0x322F
#define U_PARENTHESIZED_IDEOGRAPH_SUN							0x3230
#define U_PARENTHESIZED_IDEOGRAPH_STOCK							0x3231
#define U_PARENTHESIZED_IDEOGRAPH_HAVE							0x3232
#define U_PARENTHESIZED_IDEOGRAPH_SOCIETY						0x3233
#define U_PARENTHESIZED_IDEOGRAPH_NAME							0x3234
#define U_PARENTHESIZED_IDEOGRAPH_SPECIAL						0x3235
#define U_PARENTHESIZED_IDEOGRAPH_FINANCIAL						0x3236
#define U_PARENTHESIZED_IDEOGRAPH_CONGRATULATION					0x3237
#define U_PARENTHESIZED_IDEOGRAPH_LABOR							0x3238
#define U_PARENTHESIZED_IDEOGRAPH_REPRESENT						0x3239
#define U_PARENTHESIZED_IDEOGRAPH_CALL							0x323A
#define U_PARENTHESIZED_IDEOGRAPH_STUDY							0x323B
#define U_PARENTHESIZED_IDEOGRAPH_SUPERVISE						0x323C
#define U_PARENTHESIZED_IDEOGRAPH_ENTERPRISE						0x323D
#define U_PARENTHESIZED_IDEOGRAPH_RESOURCE						0x323E
#define U_PARENTHESIZED_IDEOGRAPH_ALLIANCE						0x323F
#define U_PARENTHESIZED_IDEOGRAPH_FESTIVAL						0x3240
#define U_PARENTHESIZED_IDEOGRAPH_REST							0x3241
#define U_PARENTHESIZED_IDEOGRAPH_SELF							0x3242
#define U_PARENTHESIZED_IDEOGRAPH_REACH							0x3243
#define U_CIRCLED_HANGUL_KIYEOK								0x3260
#define U_CIRCLED_HANGUL_NIEUN								0x3261
#define U_CIRCLED_HANGUL_TIKEUT								0x3262
#define U_CIRCLED_HANGUL_RIEUL								0x3263
#define U_CIRCLED_HANGUL_MIEUM								0x3264
#define U_CIRCLED_HANGUL_PIEUP								0x3265
#define U_CIRCLED_HANGUL_SIOS								0x3266
#define U_CIRCLED_HANGUL_IEUNG								0x3267
#define U_CIRCLED_HANGUL_CIEUC								0x3268
#define U_CIRCLED_HANGUL_CHIEUCH							0x3269
#define U_CIRCLED_HANGUL_KHIEUKH							0x326A
#define U_CIRCLED_HANGUL_THIEUTH							0x326B
#define U_CIRCLED_HANGUL_PHIEUPH							0x326C
#define U_CIRCLED_HANGUL_HIEUH								0x326D
#define U_CIRCLED_HANGUL_KIYEOK_A							0x326E
#define U_CIRCLED_HANGUL_NIEUN_A							0x326F
#define U_CIRCLED_HANGUL_TIKEUT_A							0x3270
#define U_CIRCLED_HANGUL_RIEUL_A							0x3271
#define U_CIRCLED_HANGUL_MIEUM_A							0x3272
#define U_CIRCLED_HANGUL_PIEUP_A							0x3273
#define U_CIRCLED_HANGUL_SIOS_A								0x3274
#define U_CIRCLED_HANGUL_IEUNG_A							0x3275
#define U_CIRCLED_HANGUL_CIEUC_A							0x3276
#define U_CIRCLED_HANGUL_CHIEUCH_A							0x3277
#define U_CIRCLED_HANGUL_KHIEUKH_A							0x3278
#define U_CIRCLED_HANGUL_THIEUTH_A							0x3279
#define U_CIRCLED_HANGUL_PHIEUPH_A							0x327A
#define U_CIRCLED_HANGUL_HIEUH_A							0x327B
#define U_KOREAN_STANDARD_SYMBOL							0x327F
#define U_CIRCLED_IDEOGRAPH_ONE								0x3280
#define U_CIRCLED_IDEOGRAPH_TWO								0x3281
#define U_CIRCLED_IDEOGRAPH_THREE							0x3282
#define U_CIRCLED_IDEOGRAPH_FOUR							0x3283
#define U_CIRCLED_IDEOGRAPH_FIVE							0x3284
#define U_CIRCLED_IDEOGRAPH_SIX								0x3285
#define U_CIRCLED_IDEOGRAPH_SEVEN							0x3286
#define U_CIRCLED_IDEOGRAPH_EIGHT							0x3287
#define U_CIRCLED_IDEOGRAPH_NINE							0x3288
#define U_CIRCLED_IDEOGRAPH_TEN								0x3289
#define U_CIRCLED_IDEOGRAPH_MOON							0x328A
#define U_CIRCLED_IDEOGRAPH_FIRE							0x328B
#define U_CIRCLED_IDEOGRAPH_WATER							0x328C
#define U_CIRCLED_IDEOGRAPH_WOOD							0x328D
#define U_CIRCLED_IDEOGRAPH_METAL							0x328E
#define U_CIRCLED_IDEOGRAPH_EARTH							0x328F
#define U_CIRCLED_IDEOGRAPH_SUN								0x3290
#define U_CIRCLED_IDEOGRAPH_STOCK							0x3291
#define U_CIRCLED_IDEOGRAPH_HAVE							0x3292
#define U_CIRCLED_IDEOGRAPH_SOCIETY							0x3293
#define U_CIRCLED_IDEOGRAPH_NAME							0x3294
#define U_CIRCLED_IDEOGRAPH_SPECIAL							0x3295
#define U_CIRCLED_IDEOGRAPH_FINANCIAL							0x3296
#define U_CIRCLED_IDEOGRAPH_CONGRATULATION						0x3297
#define U_CIRCLED_IDEOGRAPH_LABOR							0x3298
#define U_CIRCLED_IDEOGRAPH_SECRET							0x3299
#define U_CIRCLED_IDEOGRAPH_MALE							0x329A
#define U_CIRCLED_IDEOGRAPH_FEMALE							0x329B
#define U_CIRCLED_IDEOGRAPH_SUITABLE							0x329C
#define U_CIRCLED_IDEOGRAPH_EXCELLENT							0x329D
#define U_CIRCLED_IDEOGRAPH_PRINT							0x329E
#define U_CIRCLED_IDEOGRAPH_ATTENTION							0x329F
#define U_CIRCLED_IDEOGRAPH_ITEM							0x32A0
#define U_CIRCLED_IDEOGRAPH_REST							0x32A1
#define U_CIRCLED_IDEOGRAPH_COPY							0x32A2
#define U_CIRCLED_IDEOGRAPH_CORRECT							0x32A3
#define U_CIRCLED_IDEOGRAPH_HIGH							0x32A4
#define U_CIRCLED_IDEOGRAPH_CENTRE							0x32A5
#define U_CIRCLED_IDEOGRAPH_LOW								0x32A6
#define U_CIRCLED_IDEOGRAPH_LEFT							0x32A7
#define U_CIRCLED_IDEOGRAPH_RIGHT							0x32A8
#define U_CIRCLED_IDEOGRAPH_MEDICINE							0x32A9
#define U_CIRCLED_IDEOGRAPH_RELIGION							0x32AA
#define U_CIRCLED_IDEOGRAPH_STUDY							0x32AB
#define U_CIRCLED_IDEOGRAPH_SUPERVISE							0x32AC
#define U_CIRCLED_IDEOGRAPH_ENTERPRISE							0x32AD
#define U_CIRCLED_IDEOGRAPH_RESOURCE							0x32AE
#define U_CIRCLED_IDEOGRAPH_ALLIANCE							0x32AF
#define U_CIRCLED_IDEOGRAPH_NIGHT							0x32B0
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JANUARY					0x32C0
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_FEBRUARY					0x32C1
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MARCH					0x32C2
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_APRIL					0x32C3
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MAY						0x32C4
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JUNE						0x32C5
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JULY						0x32C6
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_AUGUST					0x32C7
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_SEPTEMBER					0x32C8
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_OCTOBER					0x32C9
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_NOVEMBER					0x32CA
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DECEMBER					0x32CB
#define U_CIRCLED_KATAKANA_A								0x32D0
#define U_CIRCLED_KATAKANA_I								0x32D1
#define U_CIRCLED_KATAKANA_U								0x32D2
#define U_CIRCLED_KATAKANA_E								0x32D3
#define U_CIRCLED_KATAKANA_O								0x32D4
#define U_CIRCLED_KATAKANA_KA								0x32D5
#define U_CIRCLED_KATAKANA_KI								0x32D6
#define U_CIRCLED_KATAKANA_KU								0x32D7
#define U_CIRCLED_KATAKANA_KE								0x32D8
#define U_CIRCLED_KATAKANA_KO								0x32D9
#define U_CIRCLED_KATAKANA_SA								0x32DA
#define U_CIRCLED_KATAKANA_SI								0x32DB
#define U_CIRCLED_KATAKANA_SU								0x32DC
#define U_CIRCLED_KATAKANA_SE								0x32DD
#define U_CIRCLED_KATAKANA_SO								0x32DE
#define U_CIRCLED_KATAKANA_TA								0x32DF
#define U_CIRCLED_KATAKANA_TI								0x32E0
#define U_CIRCLED_KATAKANA_TU								0x32E1
#define U_CIRCLED_KATAKANA_TE								0x32E2
#define U_CIRCLED_KATAKANA_TO								0x32E3
#define U_CIRCLED_KATAKANA_NA								0x32E4
#define U_CIRCLED_KATAKANA_NI								0x32E5
#define U_CIRCLED_KATAKANA_NU								0x32E6
#define U_CIRCLED_KATAKANA_NE								0x32E7
#define U_CIRCLED_KATAKANA_NO								0x32E8
#define U_CIRCLED_KATAKANA_HA								0x32E9
#define U_CIRCLED_KATAKANA_HI								0x32EA
#define U_CIRCLED_KATAKANA_HU								0x32EB
#define U_CIRCLED_KATAKANA_HE								0x32EC
#define U_CIRCLED_KATAKANA_HO								0x32ED
#define U_CIRCLED_KATAKANA_MA								0x32EE
#define U_CIRCLED_KATAKANA_MI								0x32EF
#define U_CIRCLED_KATAKANA_MU								0x32F0
#define U_CIRCLED_KATAKANA_ME								0x32F1
#define U_CIRCLED_KATAKANA_MO								0x32F2
#define U_CIRCLED_KATAKANA_YA								0x32F3
#define U_CIRCLED_KATAKANA_YU								0x32F4
#define U_CIRCLED_KATAKANA_YO								0x32F5
#define U_CIRCLED_KATAKANA_RA								0x32F6
#define U_CIRCLED_KATAKANA_RI								0x32F7
#define U_CIRCLED_KATAKANA_RU								0x32F8
#define U_CIRCLED_KATAKANA_RE								0x32F9
#define U_CIRCLED_KATAKANA_RO								0x32FA
#define U_CIRCLED_KATAKANA_WA								0x32FB
#define U_CIRCLED_KATAKANA_WI								0x32FC
#define U_CIRCLED_KATAKANA_WE								0x32FD
#define U_CIRCLED_KATAKANA_WO								0x32FE
#define U_SQUARE_APAATO									0x3300
#define U_SQUARE_ARUHUA									0x3301
#define U_SQUARE_ANPEA									0x3302
#define U_SQUARE_AARU									0x3303
#define U_SQUARE_ININGU									0x3304
#define U_SQUARE_INTI									0x3305
#define U_SQUARE_UON									0x3306
#define U_SQUARE_ESUKUUDO								0x3307
#define U_SQUARE_EEKAA									0x3308
#define U_SQUARE_ONSU									0x3309
#define U_SQUARE_OOMU									0x330A
#define U_SQUARE_KAIRI									0x330B
#define U_SQUARE_KARATTO								0x330C
#define U_SQUARE_KARORII								0x330D
#define U_SQUARE_GARON									0x330E
#define U_SQUARE_GANMA									0x330F
#define U_SQUARE_GIGA									0x3310
#define U_SQUARE_GINII									0x3311
#define U_SQUARE_KYURII									0x3312
#define U_SQUARE_GIRUDAA								0x3313
#define U_SQUARE_KIRO									0x3314
#define U_SQUARE_KIROGURAMU								0x3315
#define U_SQUARE_KIROMEETORU								0x3316
#define U_SQUARE_KIROWATTO								0x3317
#define U_SQUARE_GURAMU									0x3318
#define U_SQUARE_GURAMUTON								0x3319
#define U_SQUARE_KURUZEIRO								0x331A
#define U_SQUARE_KUROONE								0x331B
#define U_SQUARE_KEESU									0x331C
#define U_SQUARE_KORUNA									0x331D
#define U_SQUARE_KOOPO									0x331E
#define U_SQUARE_SAIKURU								0x331F
#define U_SQUARE_SANTIIMU								0x3320
#define U_SQUARE_SIRINGU								0x3321
#define U_SQUARE_SENTI									0x3322
#define U_SQUARE_SENTO									0x3323
#define U_SQUARE_DAASU									0x3324
#define U_SQUARE_DESI									0x3325
#define U_SQUARE_DORU									0x3326
#define U_SQUARE_TON									0x3327
#define U_SQUARE_NANO									0x3328
#define U_SQUARE_NOTTO									0x3329
#define U_SQUARE_HAITU									0x332A
#define U_SQUARE_PAASENTO								0x332B
#define U_SQUARE_PAATU									0x332C
#define U_SQUARE_BAARERU								0x332D
#define U_SQUARE_PIASUTORU								0x332E
#define U_SQUARE_PIKURU									0x332F
#define U_SQUARE_PIKO									0x3330
#define U_SQUARE_BIRU									0x3331
#define U_SQUARE_HUARADDO								0x3332
#define U_SQUARE_HUIITO									0x3333
#define U_SQUARE_BUSSYERU								0x3334
#define U_SQUARE_HURAN									0x3335
#define U_SQUARE_HEKUTAARU								0x3336
#define U_SQUARE_PESO									0x3337
#define U_SQUARE_PENIHI									0x3338
#define U_SQUARE_HERUTU									0x3339
#define U_SQUARE_PENSU									0x333A
#define U_SQUARE_PEEZI									0x333B
#define U_SQUARE_BEETA									0x333C
#define U_SQUARE_POINTO									0x333D
#define U_SQUARE_BORUTO									0x333E
#define U_SQUARE_HON									0x333F
#define U_SQUARE_PONDO									0x3340
#define U_SQUARE_HOORU									0x3341
#define U_SQUARE_HOON									0x3342
#define U_SQUARE_MAIKURO								0x3343
#define U_SQUARE_MAIRU									0x3344
#define U_SQUARE_MAHHA									0x3345
#define U_SQUARE_MARUKU									0x3346
#define U_SQUARE_MANSYON								0x3347
#define U_SQUARE_MIKURON								0x3348
#define U_SQUARE_MIRI									0x3349
#define U_SQUARE_MIRIBAARU								0x334A
#define U_SQUARE_MEGA									0x334B
#define U_SQUARE_MEGATON								0x334C
#define U_SQUARE_MEETORU								0x334D
#define U_SQUARE_YAADO									0x334E
#define U_SQUARE_YAARU									0x334F
#define U_SQUARE_YUAN									0x3350
#define U_SQUARE_RITTORU								0x3351
#define U_SQUARE_RIRA									0x3352
#define U_SQUARE_RUPII									0x3353
#define U_SQUARE_RUUBURU								0x3354
#define U_SQUARE_REMU									0x3355
#define U_SQUARE_RENTOGEN								0x3356
#define U_SQUARE_WATTO									0x3357
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ZERO					0x3358
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ONE					0x3359
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWO					0x335A
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THREE					0x335B
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOUR					0x335C
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIVE					0x335D
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIX					0x335E
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVEN					0x335F
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHT					0x3360
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINE					0x3361
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TEN					0x3362
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ELEVEN					0x3363
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWELVE					0x3364
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THIRTEEN				0x3365
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOURTEEN				0x3366
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIFTEEN					0x3367
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIXTEEN					0x3368
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVENTEEN				0x3369
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHTEEN				0x336A
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINETEEN				0x336B
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY					0x336C
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_ONE				0x336D
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_TWO				0x336E
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_THREE				0x336F
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_FOUR				0x3370
#define U_SQUARE_HPA									0x3371
#define U_SQUARE_DA									0x3372
#define U_SQUARE_AU									0x3373
#define U_SQUARE_BAR									0x3374
#define U_SQUARE_OV									0x3375
#define U_SQUARE_PC									0x3376
#define U_SQUARE_ERA_NAME_HEISEI							0x337B
#define U_SQUARE_ERA_NAME_SYOUWA							0x337C
#define U_SQUARE_ERA_NAME_TAISYOU							0x337D
#define U_SQUARE_ERA_NAME_MEIZI								0x337E
#define U_SQUARE_CORPORATION								0x337F
#define U_SQUARE_PA_AMPS								0x3380
#define U_SQUARE_NA									0x3381
#define U_SQUARE_MU_A									0x3382
#define U_SQUARE_MA									0x3383
#define U_SQUARE_KA									0x3384
#define U_SQUARE_KB									0x3385
#define U_SQUARE_MB									0x3386
#define U_SQUARE_GB									0x3387
#define U_SQUARE_CAL									0x3388
#define U_SQUARE_KCAL									0x3389
#define U_SQUARE_PF									0x338A
#define U_SQUARE_NF									0x338B
#define U_SQUARE_MU_F									0x338C
#define U_SQUARE_MU_G									0x338D
#define U_SQUARE_MG									0x338E
#define U_SQUARE_KG									0x338F
#define U_SQUARE_HZ									0x3390
#define U_SQUARE_KHZ									0x3391
#define U_SQUARE_MHZ									0x3392
#define U_SQUARE_GHZ									0x3393
#define U_SQUARE_THZ									0x3394
#define U_SQUARE_MU_L									0x3395
#define U_SQUARE_ML									0x3396
#define U_SQUARE_DL									0x3397
#define U_SQUARE_KL									0x3398
#define U_SQUARE_FM									0x3399
#define U_SQUARE_NM									0x339A
#define U_SQUARE_MU_M									0x339B
#define U_SQUARE_MM									0x339C
#define U_SQUARE_CM									0x339D
#define U_SQUARE_KM									0x339E
#define U_SQUARE_MM_SQUARED								0x339F
#define U_SQUARE_CM_SQUARED								0x33A0
#define U_SQUARE_M_SQUARED								0x33A1
#define U_SQUARE_KM_SQUARED								0x33A2
#define U_SQUARE_MM_CUBED								0x33A3
#define U_SQUARE_CM_CUBED								0x33A4
#define U_SQUARE_M_CUBED								0x33A5
#define U_SQUARE_KM_CUBED								0x33A6
#define U_SQUARE_M_OVER_S								0x33A7
#define U_SQUARE_M_OVER_S_SQUARED							0x33A8
#define U_SQUARE_PA									0x33A9
#define U_SQUARE_KPA									0x33AA
#define U_SQUARE_MPA									0x33AB
#define U_SQUARE_GPA									0x33AC
#define U_SQUARE_RAD									0x33AD
#define U_SQUARE_RAD_OVER_S								0x33AE
#define U_SQUARE_RAD_OVER_S_SQUARED							0x33AF
#define U_SQUARE_PS									0x33B0
#define U_SQUARE_NS									0x33B1
#define U_SQUARE_MU_S									0x33B2
#define U_SQUARE_MS									0x33B3
#define U_SQUARE_PV									0x33B4
#define U_SQUARE_NV									0x33B5
#define U_SQUARE_MU_V									0x33B6
#define U_SQUARE_MV									0x33B7
#define U_SQUARE_KV									0x33B8
#define U_SQUARE_MV_MEGA								0x33B9
#define U_SQUARE_PW									0x33BA
#define U_SQUARE_NW									0x33BB
#define U_SQUARE_MU_W									0x33BC
#define U_SQUARE_MW									0x33BD
#define U_SQUARE_KW									0x33BE
#define U_SQUARE_MW_MEGA								0x33BF
#define U_SQUARE_K_OHM									0x33C0
#define U_SQUARE_M_OHM									0x33C1
#define U_SQUARE_AM									0x33C2
#define U_SQUARE_BQ									0x33C3
#define U_SQUARE_CC									0x33C4
#define U_SQUARE_CD									0x33C5
#define U_SQUARE_C_OVER_KG								0x33C6
#define U_SQUARE_CO									0x33C7
#define U_SQUARE_DB									0x33C8
#define U_SQUARE_GY									0x33C9
#define U_SQUARE_HA									0x33CA
#define U_SQUARE_HP									0x33CB
#define U_SQUARE_IN									0x33CC
#define U_SQUARE_KK									0x33CD
#define U_SQUARE_KM_CAPITAL								0x33CE
#define U_SQUARE_KT									0x33CF
#define U_SQUARE_LM									0x33D0
#define U_SQUARE_LN									0x33D1
#define U_SQUARE_LOG									0x33D2
#define U_SQUARE_LX									0x33D3
#define U_SQUARE_MB_SMALL								0x33D4
#define U_SQUARE_MIL									0x33D5
#define U_SQUARE_MOL									0x33D6
#define U_SQUARE_PH									0x33D7
#define U_SQUARE_PM									0x33D8
#define U_SQUARE_PPM									0x33D9
#define U_SQUARE_PR									0x33DA
#define U_SQUARE_SR									0x33DB
#define U_SQUARE_SV									0x33DC
#define U_SQUARE_WB									0x33DD
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ONE					0x33E0
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWO					0x33E1
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THREE					0x33E2
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOUR					0x33E3
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIVE					0x33E4
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIX					0x33E5
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVEN					0x33E6
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHT					0x33E7
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINE					0x33E8
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TEN					0x33E9
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ELEVEN					0x33EA
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWELVE					0x33EB
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTEEN					0x33EC
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOURTEEN					0x33ED
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIFTEEN					0x33EE
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIXTEEN					0x33EF
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVENTEEN				0x33F0
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHTEEN					0x33F1
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINETEEN					0x33F2
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY					0x33F3
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_ONE				0x33F4
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_TWO				0x33F5
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_THREE				0x33F6
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FOUR				0x33F7
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FIVE				0x33F8
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SIX				0x33F9
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SEVEN				0x33FA
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_EIGHT				0x33FB
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_NINE				0x33FC
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY					0x33FD
#define U_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY_ONE				0x33FE

#if 0
#define U_CJK_Ideograph_First								0x4E00
#define U_CJK_Ideograph_Last								0x9FA5
#define U_Hangul_Syllable_First								0xAC00
#define U_Hangul_Syllable_Last								0xD7A3
#define U_Unassigned_High_Surrogate_First						0xD800
#define U_Unassigned High Surrogate_Last						0xDB7F
#define U_Private_Use_High_Surrogate_First						0xDB80
#define U_Private_Use_High_Surrogate_Last						0xDBFF
#define U_Low_Surrogate_First								0xDC00
#define U_Low_Surrogate_Last								0xDFFF
#define U_Private_Use_First								0xE000
#define U_Private_Use_Last								0xF8FF
#define U_CJK_Compatibility_Ideograph_First						0xF900
#define U_CJK_Compatibility_Ideograph_Last						0xFA2D

#endif

#define U_LATIN_SMALL_LIGATURE_FF							0xFB00
#define U_LATIN_SMALL_LIGATURE_FI							0xFB01
#define U_LATIN_SMALL_LIGATURE_FL							0xFB02
#define U_LATIN_SMALL_LIGATURE_FFI							0xFB03
#define U_LATIN_SMALL_LIGATURE_FFL							0xFB04
#define U_LATIN_SMALL_LIGATURE_LONG_S_T							0xFB05
#define U_LATIN_SMALL_LIGATURE_ST							0xFB06
#define U_ARMENIAN_SMALL_LIGATURE_MEN_NOW						0xFB13
#define U_ARMENIAN_SMALL_LIGATURE_MEN_ECH						0xFB14
#define U_ARMENIAN_SMALL_LIGATURE_MEN_INI						0xFB15
#define U_ARMENIAN_SMALL_LIGATURE_VEW_NOW						0xFB16
#define U_ARMENIAN_SMALL_LIGATURE_MEN_XEH						0xFB17
#define U_HEBREW_POINT_JUDEO_SPANISH_VARIKA						0xFB1E
#define U_HEBREW_LIGATURE_YIDDISH_YOD_YOD_PATAH						0xFB1F
#define U_HEBREW_LETTER_ALTERNATIVE_AYIN						0xFB20
#define U_HEBREW_LETTER_WIDE_ALEF							0xFB21
#define U_HEBREW_LETTER_WIDE_DALET							0xFB22
#define U_HEBREW_LETTER_WIDE_HE								0xFB23
#define U_HEBREW_LETTER_WIDE_KAF							0xFB24
#define U_HEBREW_LETTER_WIDE_LAMED							0xFB25
#define U_HEBREW_LETTER_WIDE_FINAL_MEM							0xFB26
#define U_HEBREW_LETTER_WIDE_RESH							0xFB27
#define U_HEBREW_LETTER_WIDE_TAV							0xFB28
#define U_HEBREW_LETTER_ALTERNATIVE_PLUS_SIGN						0xFB29
#define U_HEBREW_LETTER_SHIN_WITH_SHIN_DOT						0xFB2A
#define U_HEBREW_LETTER_SHIN_WITH_SIN_DOT						0xFB2B
#define U_HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SHIN_DOT					0xFB2C
#define U_HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SIN_DOT					0xFB2D
#define U_HEBREW_LETTER_ALEF_WITH_PATAH							0xFB2E
#define U_HEBREW_LETTER_ALEF_WITH_QAMATS						0xFB2F
#define U_HEBREW_LETTER_ALEF_WITH_MAPIQ							0xFB30
#define U_HEBREW_LETTER_BET_WITH_DAGESH							0xFB31
#define U_HEBREW_LETTER_GIMEL_WITH_DAGESH						0xFB32
#define U_HEBREW_LETTER_DALET_WITH_DAGESH						0xFB33
#define U_HEBREW_LETTER_HE_WITH_MAPIQ							0xFB34
#define U_HEBREW_LETTER_VAV_WITH_DAGESH							0xFB35
#define U_HEBREW_LETTER_ZAYIN_WITH_DAGESH						0xFB36
#define U_HEBREW_LETTER_TET_WITH_DAGESH							0xFB38
#define U_HEBREW_LETTER_YOD_WITH_DAGESH							0xFB39
#define U_HEBREW_LETTER_FINAL_KAF_WITH_DAGESH						0xFB3A
#define U_HEBREW_LETTER_KAF_WITH_DAGESH							0xFB3B
#define U_HEBREW_LETTER_LAMED_WITH_DAGESH						0xFB3C
#define U_HEBREW_LETTER_MEM_WITH_DAGESH							0xFB3E
#define U_HEBREW_LETTER_NUN_WITH_DAGESH							0xFB40
#define U_HEBREW_LETTER_SAMEKH_WITH_DAGESH						0xFB41
#define U_HEBREW_LETTER_FINAL_PE_WITH_DAGESH						0xFB43
#define U_HEBREW_LETTER_PE_WITH_DAGESH							0xFB44
#define U_HEBREW_LETTER_TSADI_WITH_DAGESH						0xFB46
#define U_HEBREW_LETTER_QOF_WITH_DAGESH							0xFB47
#define U_HEBREW_LETTER_RESH_WITH_DAGESH						0xFB48
#define U_HEBREW_LETTER_SHIN_WITH_DAGESH						0xFB49
#define U_HEBREW_LETTER_TAV_WITH_DAGESH							0xFB4A
#define U_HEBREW_LETTER_VAV_WITH_HOLAM							0xFB4B
#define U_HEBREW_LETTER_BET_WITH_RAFE							0xFB4C
#define U_HEBREW_LETTER_KAF_WITH_RAFE							0xFB4D
#define U_HEBREW_LETTER_PE_WITH_RAFE							0xFB4E
#define U_HEBREW_LIGATURE_ALEF_LAMED							0xFB4F
#define U_ARABIC_LETTER_ALEF_WASLA_ISOLATED_FORM					0xFB50
#define U_ARABIC_LETTER_ALEF_WASLA_FINAL_FORM						0xFB51
#define U_ARABIC_LETTER_BEEH_ISOLATED_FORM						0xFB52
#define U_ARABIC_LETTER_BEEH_FINAL_FORM							0xFB53
#define U_ARABIC_LETTER_BEEH_INITIAL_FORM						0xFB54
#define U_ARABIC_LETTER_BEEH_MEDIAL_FORM						0xFB55
#define U_ARABIC_LETTER_PEH_ISOLATED_FORM						0xFB56
#define U_ARABIC_LETTER_PEH_FINAL_FORM							0xFB57
#define U_ARABIC_LETTER_PEH_INITIAL_FORM						0xFB58
#define U_ARABIC_LETTER_PEH_MEDIAL_FORM							0xFB59
#define U_ARABIC_LETTER_BEHEH_ISOLATED_FORM						0xFB5A
#define U_ARABIC_LETTER_BEHEH_FINAL_FORM						0xFB5B
#define U_ARABIC_LETTER_BEHEH_INITIAL_FORM						0xFB5C
#define U_ARABIC_LETTER_BEHEH_MEDIAL_FORM						0xFB5D
#define U_ARABIC_LETTER_TTEHEH_ISOLATED_FORM						0xFB5E
#define U_ARABIC_LETTER_TTEHEH_FINAL_FORM						0xFB5F
#define U_ARABIC_LETTER_TTEHEH_INITIAL_FORM						0xFB60
#define U_ARABIC_LETTER_TTEHEH_MEDIAL_FORM						0xFB61
#define U_ARABIC_LETTER_TEHEH_ISOLATED_FORM						0xFB62
#define U_ARABIC_LETTER_TEHEH_FINAL_FORM						0xFB63
#define U_ARABIC_LETTER_TEHEH_INITIAL_FORM						0xFB64
#define U_ARABIC_LETTER_TEHEH_MEDIAL_FORM						0xFB65
#define U_ARABIC_LETTER_TTEH_ISOLATED_FORM						0xFB66
#define U_ARABIC_LETTER_TTEH_FINAL_FORM							0xFB67
#define U_ARABIC_LETTER_TTEH_INITIAL_FORM						0xFB68
#define U_ARABIC_LETTER_TTEH_MEDIAL_FORM						0xFB69
#define U_ARABIC_LETTER_VEH_ISOLATED_FORM						0xFB6A
#define U_ARABIC_LETTER_VEH_FINAL_FORM							0xFB6B
#define U_ARABIC_LETTER_VEH_INITIAL_FORM						0xFB6C
#define U_ARABIC_LETTER_VEH_MEDIAL_FORM							0xFB6D
#define U_ARABIC_LETTER_PEHEH_ISOLATED_FORM						0xFB6E
#define U_ARABIC_LETTER_PEHEH_FINAL_FORM						0xFB6F
#define U_ARABIC_LETTER_PEHEH_INITIAL_FORM						0xFB70
#define U_ARABIC_LETTER_PEHEH_MEDIAL_FORM						0xFB71
#define U_ARABIC_LETTER_DYEH_ISOLATED_FORM						0xFB72
#define U_ARABIC_LETTER_DYEH_FINAL_FORM							0xFB73
#define U_ARABIC_LETTER_DYEH_INITIAL_FORM						0xFB74
#define U_ARABIC_LETTER_DYEH_MEDIAL_FORM						0xFB75
#define U_ARABIC_LETTER_NYEH_ISOLATED_FORM						0xFB76
#define U_ARABIC_LETTER_NYEH_FINAL_FORM							0xFB77
#define U_ARABIC_LETTER_NYEH_INITIAL_FORM						0xFB78
#define U_ARABIC_LETTER_NYEH_MEDIAL_FORM						0xFB79
#define U_ARABIC_LETTER_TCHEH_ISOLATED_FORM						0xFB7A
#define U_ARABIC_LETTER_TCHEH_FINAL_FORM						0xFB7B
#define U_ARABIC_LETTER_TCHEH_INITIAL_FORM						0xFB7C
#define U_ARABIC_LETTER_TCHEH_MEDIAL_FORM						0xFB7D
#define U_ARABIC_LETTER_TCHEHEH_ISOLATED_FORM						0xFB7E
#define U_ARABIC_LETTER_TCHEHEH_FINAL_FORM						0xFB7F
#define U_ARABIC_LETTER_TCHEHEH_INITIAL_FORM						0xFB80
#define U_ARABIC_LETTER_TCHEHEH_MEDIAL_FORM						0xFB81
#define U_ARABIC_LETTER_DDAHAL_ISOLATED_FORM						0xFB82
#define U_ARABIC_LETTER_DDAHAL_FINAL_FORM						0xFB83
#define U_ARABIC_LETTER_DAHAL_ISOLATED_FORM						0xFB84
#define U_ARABIC_LETTER_DAHAL_FINAL_FORM						0xFB85
#define U_ARABIC_LETTER_DUL_ISOLATED_FORM						0xFB86
#define U_ARABIC_LETTER_DUL_FINAL_FORM							0xFB87
#define U_ARABIC_LETTER_DDAL_ISOLATED_FORM						0xFB88
#define U_ARABIC_LETTER_DDAL_FINAL_FORM							0xFB89
#define U_ARABIC_LETTER_JEH_ISOLATED_FORM						0xFB8A
#define U_ARABIC_LETTER_JEH_FINAL_FORM							0xFB8B
#define U_ARABIC_LETTER_RREH_ISOLATED_FORM						0xFB8C
#define U_ARABIC_LETTER_RREH_FINAL_FORM							0xFB8D
#define U_ARABIC_LETTER_KEHEH_ISOLATED_FORM						0xFB8E
#define U_ARABIC_LETTER_KEHEH_FINAL_FORM						0xFB8F
#define U_ARABIC_LETTER_KEHEH_INITIAL_FORM						0xFB90
#define U_ARABIC_LETTER_KEHEH_MEDIAL_FORM						0xFB91
#define U_ARABIC_LETTER_GAF_ISOLATED_FORM						0xFB92
#define U_ARABIC_LETTER_GAF_FINAL_FORM							0xFB93
#define U_ARABIC_LETTER_GAF_INITIAL_FORM						0xFB94
#define U_ARABIC_LETTER_GAF_MEDIAL_FORM							0xFB95
#define U_ARABIC_LETTER_GUEH_ISOLATED_FORM						0xFB96
#define U_ARABIC_LETTER_GUEH_FINAL_FORM							0xFB97
#define U_ARABIC_LETTER_GUEH_INITIAL_FORM						0xFB98
#define U_ARABIC_LETTER_GUEH_MEDIAL_FORM						0xFB99
#define U_ARABIC_LETTER_NGOEH_ISOLATED_FORM						0xFB9A
#define U_ARABIC_LETTER_NGOEH_FINAL_FORM						0xFB9B
#define U_ARABIC_LETTER_NGOEH_INITIAL_FORM						0xFB9C
#define U_ARABIC_LETTER_NGOEH_MEDIAL_FORM						0xFB9D
#define U_ARABIC_LETTER_NOON_GHUNNA_ISOLATED_FORM					0xFB9E
#define U_ARABIC_LETTER_NOON_GHUNNA_FINAL_FORM						0xFB9F
#define U_ARABIC_LETTER_RNOON_ISOLATED_FORM						0xFBA0
#define U_ARABIC_LETTER_RNOON_FINAL_FORM						0xFBA1
#define U_ARABIC_LETTER_RNOON_INITIAL_FORM						0xFBA2
#define U_ARABIC_LETTER_RNOON_MEDIAL_FORM						0xFBA3
#define U_ARABIC_LETTER_HEH_WITH_YEH_ABOVE_ISOLATED_FORM				0xFBA4
#define U_ARABIC_LETTER_HEH_WITH_YEH_ABOVE_FINAL_FORM					0xFBA5
#define U_ARABIC_LETTER_HEH_GOAL_ISOLATED_FORM						0xFBA6
#define U_ARABIC_LETTER_HEH_GOAL_FINAL_FORM						0xFBA7
#define U_ARABIC_LETTER_HEH_GOAL_INITIAL_FORM						0xFBA8
#define U_ARABIC_LETTER_HEH_GOAL_MEDIAL_FORM						0xFBA9
#define U_ARABIC_LETTER_HEH_DOACHASHMEE_ISOLATED_FORM					0xFBAA
#define U_ARABIC_LETTER_HEH_DOACHASHMEE_FINAL_FORM					0xFBAB
#define U_ARABIC_LETTER_HEH_DOACHASHMEE_INITIAL_FORM					0xFBAC
#define U_ARABIC_LETTER_HEH_DOACHASHMEE_MEDIAL_FORM					0xFBAD
#define U_ARABIC_LETTER_YEH_BARREE_ISOLATED_FORM					0xFBAE
#define U_ARABIC_LETTER_YEH_BARREE_FINAL_FORM						0xFBAF
#define U_ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_ISOLATED_FORM			0xFBB0
#define U_ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_FINAL_FORM				0xFBB1
#define U_ARABIC_LETTER_NG_ISOLATED_FORM						0xFBD3
#define U_ARABIC_LETTER_NG_FINAL_FORM							0xFBD4
#define U_ARABIC_LETTER_NG_INITIAL_FORM							0xFBD5
#define U_ARABIC_LETTER_NG_MEDIAL_FORM							0xFBD6
#define U_ARABIC_LETTER_U_ISOLATED_FORM							0xFBD7
#define U_ARABIC_LETTER_U_FINAL_FORM							0xFBD8
#define U_ARABIC_LETTER_OE_ISOLATED_FORM						0xFBD9
#define U_ARABIC_LETTER_OE_FINAL_FORM							0xFBDA
#define U_ARABIC_LETTER_YU_ISOLATED_FORM						0xFBDB
#define U_ARABIC_LETTER_YU_FINAL_FORM							0xFBDC
#define U_ARABIC_LETTER_U_WITH_HAMZA_ABOVE_ISOLATED_FORM				0xFBDD
#define U_ARABIC_LETTER_VE_ISOLATED_FORM						0xFBDE
#define U_ARABIC_LETTER_VE_FINAL_FORM							0xFBDF
#define U_ARABIC_LETTER_KIRGHIZ_OE_ISOLATED_FORM					0xFBE0
#define U_ARABIC_LETTER_KIRGHIZ_OE_FINAL_FORM						0xFBE1
#define U_ARABIC_LETTER_KIRGHIZ_YU_ISOLATED_FORM					0xFBE2
#define U_ARABIC_LETTER_KIRGHIZ_YU_FINAL_FORM						0xFBE3
#define U_ARABIC_LETTER_E_ISOLATED_FORM							0xFBE4
#define U_ARABIC_LETTER_E_FINAL_FORM							0xFBE5
#define U_ARABIC_LETTER_E_INITIAL_FORM							0xFBE6
#define U_ARABIC_LETTER_E_MEDIAL_FORM							0xFBE7
#define U_ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_INITIAL_FORM			0xFBE8
#define U_ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_MEDIAL_FORM			0xFBE9
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_ISOLATED_FORM			0xFBEA
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_FINAL_FORM			0xFBEB
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_ISOLATED_FORM			0xFBEC
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_FINAL_FORM			0xFBED
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_ISOLATED_FORM			0xFBEE
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_FINAL_FORM			0xFBEF
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_ISOLATED_FORM			0xFBF0
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_FINAL_FORM			0xFBF1
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_ISOLATED_FORM			0xFBF2
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_FINAL_FORM			0xFBF3
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_ISOLATED_FORM			0xFBF4
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_FINAL_FORM			0xFBF5
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_ISOLATED_FORM			0xFBF6
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_FINAL_FORM			0xFBF7
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_INITIAL_FORM			0xFBF8
#define U_ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFBF9
#define U_ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM	0xFBFA
#define U_ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_INITIAL_FORM	0xFBFB
#define U_ARABIC_LETTER_FARSI_YEH_ISOLATED_FORM						0xFBFC
#define U_ARABIC_LETTER_FARSI_YEH_FINAL_FORM						0xFBFD
#define U_ARABIC_LETTER_FARSI_YEH_INITIAL_FORM						0xFBFE
#define U_ARABIC_LETTER_FARSI_YEH_MEDIAL_FORM						0xFBFF
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_ISOLATED_FORM			0xFC00
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_ISOLATED_FORM			0xFC01
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_ISOLATED_FORM			0xFC02
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM		0xFC03
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_ISOLATED_FORM			0xFC04
#define U_ARABIC_LIGATURE_BEH_WITH_JEEM_ISOLATED_FORM					0xFC05
#define U_ARABIC_LIGATURE_BEH_WITH_HAH_ISOLATED_FORM					0xFC06
#define U_ARABIC_LIGATURE_BEH_WITH_KHAH_ISOLATED_FORM					0xFC07
#define U_ARABIC_LIGATURE_BEH_WITH_MEEM_ISOLATED_FORM					0xFC08
#define U_ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC09
#define U_ARABIC_LIGATURE_BEH_WITH_YEH_ISOLATED_FORM					0xFC0A
#define U_ARABIC_LIGATURE_TEH_WITH_JEEM_ISOLATED_FORM					0xFC0B
#define U_ARABIC_LIGATURE_TEH_WITH_HAH_ISOLATED_FORM					0xFC0C
#define U_ARABIC_LIGATURE_TEH_WITH_KHAH_ISOLATED_FORM					0xFC0D
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_ISOLATED_FORM					0xFC0E
#define U_ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC0F
#define U_ARABIC_LIGATURE_TEH_WITH_YEH_ISOLATED_FORM					0xFC10
#define U_ARABIC_LIGATURE_THEH_WITH_JEEM_ISOLATED_FORM					0xFC11
#define U_ARABIC_LIGATURE_THEH_WITH_MEEM_ISOLATED_FORM					0xFC12
#define U_ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC13
#define U_ARABIC_LIGATURE_THEH_WITH_YEH_ISOLATED_FORM					0xFC14
#define U_ARABIC_LIGATURE_JEEM_WITH_HAH_ISOLATED_FORM					0xFC15
#define U_ARABIC_LIGATURE_JEEM_WITH_MEEM_ISOLATED_FORM					0xFC16
#define U_ARABIC_LIGATURE_HAH_WITH_JEEM_ISOLATED_FORM					0xFC17
#define U_ARABIC_LIGATURE_HAH_WITH_MEEM_ISOLATED_FORM					0xFC18
#define U_ARABIC_LIGATURE_KHAH_WITH_JEEM_ISOLATED_FORM					0xFC19
#define U_ARABIC_LIGATURE_KHAH_WITH_HAH_ISOLATED_FORM					0xFC1A
#define U_ARABIC_LIGATURE_KHAH_WITH_MEEM_ISOLATED_FORM					0xFC1B
#define U_ARABIC_LIGATURE_SEEN_WITH_JEEM_ISOLATED_FORM					0xFC1C
#define U_ARABIC_LIGATURE_SEEN_WITH_HAH_ISOLATED_FORM					0xFC1D
#define U_ARABIC_LIGATURE_SEEN_WITH_KHAH_ISOLATED_FORM					0xFC1E
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_ISOLATED_FORM					0xFC1F
#define U_ARABIC_LIGATURE_SAD_WITH_HAH_ISOLATED_FORM					0xFC20
#define U_ARABIC_LIGATURE_SAD_WITH_MEEM_ISOLATED_FORM					0xFC21
#define U_ARABIC_LIGATURE_DAD_WITH_JEEM_ISOLATED_FORM					0xFC22
#define U_ARABIC_LIGATURE_DAD_WITH_HAH_ISOLATED_FORM					0xFC23
#define U_ARABIC_LIGATURE_DAD_WITH_KHAH_ISOLATED_FORM					0xFC24
#define U_ARABIC_LIGATURE_DAD_WITH_MEEM_ISOLATED_FORM					0xFC25
#define U_ARABIC_LIGATURE_TAH_WITH_HAH_ISOLATED_FORM					0xFC26
#define U_ARABIC_LIGATURE_TAH_WITH_MEEM_ISOLATED_FORM					0xFC27
#define U_ARABIC_LIGATURE_ZAH_WITH_MEEM_ISOLATED_FORM					0xFC28
#define U_ARABIC_LIGATURE_AIN_WITH_JEEM_ISOLATED_FORM					0xFC29
#define U_ARABIC_LIGATURE_AIN_WITH_MEEM_ISOLATED_FORM					0xFC2A
#define U_ARABIC_LIGATURE_GHAIN_WITH_JEEM_ISOLATED_FORM					0xFC2B
#define U_ARABIC_LIGATURE_GHAIN_WITH_MEEM_ISOLATED_FORM					0xFC2C
#define U_ARABIC_LIGATURE_FEH_WITH_JEEM_ISOLATED_FORM					0xFC2D
#define U_ARABIC_LIGATURE_FEH_WITH_HAH_ISOLATED_FORM					0xFC2E
#define U_ARABIC_LIGATURE_FEH_WITH_KHAH_ISOLATED_FORM					0xFC2F
#define U_ARABIC_LIGATURE_FEH_WITH_MEEM_ISOLATED_FORM					0xFC30
#define U_ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC31
#define U_ARABIC_LIGATURE_FEH_WITH_YEH_ISOLATED_FORM					0xFC32
#define U_ARABIC_LIGATURE_QAF_WITH_HAH_ISOLATED_FORM					0xFC33
#define U_ARABIC_LIGATURE_QAF_WITH_MEEM_ISOLATED_FORM					0xFC34
#define U_ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC35
#define U_ARABIC_LIGATURE_QAF_WITH_YEH_ISOLATED_FORM					0xFC36
#define U_ARABIC_LIGATURE_KAF_WITH_ALEF_ISOLATED_FORM					0xFC37
#define U_ARABIC_LIGATURE_KAF_WITH_JEEM_ISOLATED_FORM					0xFC38
#define U_ARABIC_LIGATURE_KAF_WITH_HAH_ISOLATED_FORM					0xFC39
#define U_ARABIC_LIGATURE_KAF_WITH_KHAH_ISOLATED_FORM					0xFC3A
#define U_ARABIC_LIGATURE_KAF_WITH_LAM_ISOLATED_FORM					0xFC3B
#define U_ARABIC_LIGATURE_KAF_WITH_MEEM_ISOLATED_FORM					0xFC3C
#define U_ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC3D
#define U_ARABIC_LIGATURE_KAF_WITH_YEH_ISOLATED_FORM					0xFC3E
#define U_ARABIC_LIGATURE_LAM_WITH_JEEM_ISOLATED_FORM					0xFC3F
#define U_ARABIC_LIGATURE_LAM_WITH_HAH_ISOLATED_FORM					0xFC40
#define U_ARABIC_LIGATURE_LAM_WITH_KHAH_ISOLATED_FORM					0xFC41
#define U_ARABIC_LIGATURE_LAM_WITH_MEEM_ISOLATED_FORM					0xFC42
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC43
#define U_ARABIC_LIGATURE_LAM_WITH_YEH_ISOLATED_FORM					0xFC44
#define U_ARABIC_LIGATURE_MEEM_WITH_JEEM_ISOLATED_FORM					0xFC45
#define U_ARABIC_LIGATURE_MEEM_WITH_HAH_ISOLATED_FORM					0xFC46
#define U_ARABIC_LIGATURE_MEEM_WITH_KHAH_ISOLATED_FORM					0xFC47
#define U_ARABIC_LIGATURE_MEEM_WITH_MEEM_ISOLATED_FORM					0xFC48
#define U_ARABIC_LIGATURE_MEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC49
#define U_ARABIC_LIGATURE_MEEM_WITH_YEH_ISOLATED_FORM					0xFC4A
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_ISOLATED_FORM					0xFC4B
#define U_ARABIC_LIGATURE_NOON_WITH_HAH_ISOLATED_FORM					0xFC4C
#define U_ARABIC_LIGATURE_NOON_WITH_KHAH_ISOLATED_FORM					0xFC4D
#define U_ARABIC_LIGATURE_NOON_WITH_MEEM_ISOLATED_FORM					0xFC4E
#define U_ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC4F
#define U_ARABIC_LIGATURE_NOON_WITH_YEH_ISOLATED_FORM					0xFC50
#define U_ARABIC_LIGATURE_HEH_WITH_JEEM_ISOLATED_FORM					0xFC51
#define U_ARABIC_LIGATURE_HEH_WITH_MEEM_ISOLATED_FORM					0xFC52
#define U_ARABIC_LIGATURE_HEH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC53
#define U_ARABIC_LIGATURE_HEH_WITH_YEH_ISOLATED_FORM					0xFC54
#define U_ARABIC_LIGATURE_YEH_WITH_JEEM_ISOLATED_FORM					0xFC55
#define U_ARABIC_LIGATURE_YEH_WITH_HAH_ISOLATED_FORM					0xFC56
#define U_ARABIC_LIGATURE_YEH_WITH_KHAH_ISOLATED_FORM					0xFC57
#define U_ARABIC_LIGATURE_YEH_WITH_MEEM_ISOLATED_FORM					0xFC58
#define U_ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFC59
#define U_ARABIC_LIGATURE_YEH_WITH_YEH_ISOLATED_FORM					0xFC5A
#define U_ARABIC_LIGATURE_THAL_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM			0xFC5B
#define U_ARABIC_LIGATURE_REH_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM			0xFC5C
#define U_ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM		0xFC5D
#define U_ARABIC_LIGATURE_SHADDA_WITH_DAMMATAN_ISOLATED_FORM				0xFC5E
#define U_ARABIC_LIGATURE_SHADDA_WITH_KASRATAN_ISOLATED_FORM				0xFC5F
#define U_ARABIC_LIGATURE_SHADDA_WITH_FATHA_ISOLATED_FORM				0xFC60
#define U_ARABIC_LIGATURE_SHADDA_WITH_DAMMA_ISOLATED_FORM				0xFC61
#define U_ARABIC_LIGATURE_SHADDA_WITH_KASRA_ISOLATED_FORM				0xFC62
#define U_ARABIC_LIGATURE_SHADDA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM			0xFC63
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_REH_FINAL_FORM			0xFC64
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ZAIN_FINAL_FORM			0xFC65
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_FINAL_FORM			0xFC66
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_NOON_FINAL_FORM			0xFC67
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM		0xFC68
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_FINAL_FORM			0xFC69
#define U_ARABIC_LIGATURE_BEH_WITH_REH_FINAL_FORM					0xFC6A
#define U_ARABIC_LIGATURE_BEH_WITH_ZAIN_FINAL_FORM					0xFC6B
#define U_ARABIC_LIGATURE_BEH_WITH_MEEM_FINAL_FORM					0xFC6C
#define U_ARABIC_LIGATURE_BEH_WITH_NOON_FINAL_FORM					0xFC6D
#define U_ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC6E
#define U_ARABIC_LIGATURE_BEH_WITH_YEH_FINAL_FORM					0xFC6F
#define U_ARABIC_LIGATURE_TEH_WITH_REH_FINAL_FORM					0xFC70
#define U_ARABIC_LIGATURE_TEH_WITH_ZAIN_FINAL_FORM					0xFC71
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_FINAL_FORM					0xFC72
#define U_ARABIC_LIGATURE_TEH_WITH_NOON_FINAL_FORM					0xFC73
#define U_ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC74
#define U_ARABIC_LIGATURE_TEH_WITH_YEH_FINAL_FORM					0xFC75
#define U_ARABIC_LIGATURE_THEH_WITH_REH_FINAL_FORM					0xFC76
#define U_ARABIC_LIGATURE_THEH_WITH_ZAIN_FINAL_FORM					0xFC77
#define U_ARABIC_LIGATURE_THEH_WITH_MEEM_FINAL_FORM					0xFC78
#define U_ARABIC_LIGATURE_THEH_WITH_NOON_FINAL_FORM					0xFC79
#define U_ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC7A
#define U_ARABIC_LIGATURE_THEH_WITH_YEH_FINAL_FORM					0xFC7B
#define U_ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC7C
#define U_ARABIC_LIGATURE_FEH_WITH_YEH_FINAL_FORM					0xFC7D
#define U_ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC7E
#define U_ARABIC_LIGATURE_QAF_WITH_YEH_FINAL_FORM					0xFC7F
#define U_ARABIC_LIGATURE_KAF_WITH_ALEF_FINAL_FORM					0xFC80
#define U_ARABIC_LIGATURE_KAF_WITH_LAM_FINAL_FORM					0xFC81
#define U_ARABIC_LIGATURE_KAF_WITH_MEEM_FINAL_FORM					0xFC82
#define U_ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC83
#define U_ARABIC_LIGATURE_KAF_WITH_YEH_FINAL_FORM					0xFC84
#define U_ARABIC_LIGATURE_LAM_WITH_MEEM_FINAL_FORM					0xFC85
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC86
#define U_ARABIC_LIGATURE_LAM_WITH_YEH_FINAL_FORM					0xFC87
#define U_ARABIC_LIGATURE_MEEM_WITH_ALEF_FINAL_FORM					0xFC88
#define U_ARABIC_LIGATURE_MEEM_WITH_MEEM_FINAL_FORM					0xFC89
#define U_ARABIC_LIGATURE_NOON_WITH_REH_FINAL_FORM					0xFC8A
#define U_ARABIC_LIGATURE_NOON_WITH_ZAIN_FINAL_FORM					0xFC8B
#define U_ARABIC_LIGATURE_NOON_WITH_MEEM_FINAL_FORM					0xFC8C
#define U_ARABIC_LIGATURE_NOON_WITH_NOON_FINAL_FORM					0xFC8D
#define U_ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC8E
#define U_ARABIC_LIGATURE_NOON_WITH_YEH_FINAL_FORM					0xFC8F
#define U_ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_FINAL_FORM			0xFC90
#define U_ARABIC_LIGATURE_YEH_WITH_REH_FINAL_FORM					0xFC91
#define U_ARABIC_LIGATURE_YEH_WITH_ZAIN_FINAL_FORM					0xFC92
#define U_ARABIC_LIGATURE_YEH_WITH_MEEM_FINAL_FORM					0xFC93
#define U_ARABIC_LIGATURE_YEH_WITH_NOON_FINAL_FORM					0xFC94
#define U_ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFC95
#define U_ARABIC_LIGATURE_YEH_WITH_YEH_FINAL_FORM					0xFC96
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_INITIAL_FORM			0xFC97
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_INITIAL_FORM			0xFC98
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_KHAH_INITIAL_FORM			0xFC99
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_INITIAL_FORM			0xFC9A
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_INITIAL_FORM			0xFC9B
#define U_ARABIC_LIGATURE_BEH_WITH_JEEM_INITIAL_FORM					0xFC9C
#define U_ARABIC_LIGATURE_BEH_WITH_HAH_INITIAL_FORM					0xFC9D
#define U_ARABIC_LIGATURE_BEH_WITH_KHAH_INITIAL_FORM					0xFC9E
#define U_ARABIC_LIGATURE_BEH_WITH_MEEM_INITIAL_FORM					0xFC9F
#define U_ARABIC_LIGATURE_BEH_WITH_HEH_INITIAL_FORM					0xFCA0
#define U_ARABIC_LIGATURE_TEH_WITH_JEEM_INITIAL_FORM					0xFCA1
#define U_ARABIC_LIGATURE_TEH_WITH_HAH_INITIAL_FORM					0xFCA2
#define U_ARABIC_LIGATURE_TEH_WITH_KHAH_INITIAL_FORM					0xFCA3
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_INITIAL_FORM					0xFCA4
#define U_ARABIC_LIGATURE_TEH_WITH_HEH_INITIAL_FORM					0xFCA5
#define U_ARABIC_LIGATURE_THEH_WITH_MEEM_INITIAL_FORM					0xFCA6
#define U_ARABIC_LIGATURE_JEEM_WITH_HAH_INITIAL_FORM					0xFCA7
#define U_ARABIC_LIGATURE_JEEM_WITH_MEEM_INITIAL_FORM					0xFCA8
#define U_ARABIC_LIGATURE_HAH_WITH_JEEM_INITIAL_FORM					0xFCA9
#define U_ARABIC_LIGATURE_HAH_WITH_MEEM_INITIAL_FORM					0xFCAA
#define U_ARABIC_LIGATURE_KHAH_WITH_JEEM_INITIAL_FORM					0xFCAB
#define U_ARABIC_LIGATURE_KHAH_WITH_MEEM_INITIAL_FORM					0xFCAC
#define U_ARABIC_LIGATURE_SEEN_WITH_JEEM_INITIAL_FORM					0xFCAD
#define U_ARABIC_LIGATURE_SEEN_WITH_HAH_INITIAL_FORM					0xFCAE
#define U_ARABIC_LIGATURE_SEEN_WITH_KHAH_INITIAL_FORM					0xFCAF
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_INITIAL_FORM					0xFCB0
#define U_ARABIC_LIGATURE_SAD_WITH_HAH_INITIAL_FORM					0xFCB1
#define U_ARABIC_LIGATURE_SAD_WITH_KHAH_INITIAL_FORM					0xFCB2
#define U_ARABIC_LIGATURE_SAD_WITH_MEEM_INITIAL_FORM					0xFCB3
#define U_ARABIC_LIGATURE_DAD_WITH_JEEM_INITIAL_FORM					0xFCB4
#define U_ARABIC_LIGATURE_DAD_WITH_HAH_INITIAL_FORM					0xFCB5
#define U_ARABIC_LIGATURE_DAD_WITH_KHAH_INITIAL_FORM					0xFCB6
#define U_ARABIC_LIGATURE_DAD_WITH_MEEM_INITIAL_FORM					0xFCB7
#define U_ARABIC_LIGATURE_TAH_WITH_HAH_INITIAL_FORM					0xFCB8
#define U_ARABIC_LIGATURE_ZAH_WITH_MEEM_INITIAL_FORM					0xFCB9
#define U_ARABIC_LIGATURE_AIN_WITH_JEEM_INITIAL_FORM					0xFCBA
#define U_ARABIC_LIGATURE_AIN_WITH_MEEM_INITIAL_FORM					0xFCBB
#define U_ARABIC_LIGATURE_GHAIN_WITH_JEEM_INITIAL_FORM					0xFCBC
#define U_ARABIC_LIGATURE_GHAIN_WITH_MEEM_INITIAL_FORM					0xFCBD
#define U_ARABIC_LIGATURE_FEH_WITH_JEEM_INITIAL_FORM					0xFCBE
#define U_ARABIC_LIGATURE_FEH_WITH_HAH_INITIAL_FORM					0xFCBF
#define U_ARABIC_LIGATURE_FEH_WITH_KHAH_INITIAL_FORM					0xFCC0
#define U_ARABIC_LIGATURE_FEH_WITH_MEEM_INITIAL_FORM					0xFCC1
#define U_ARABIC_LIGATURE_QAF_WITH_HAH_INITIAL_FORM					0xFCC2
#define U_ARABIC_LIGATURE_QAF_WITH_MEEM_INITIAL_FORM					0xFCC3
#define U_ARABIC_LIGATURE_KAF_WITH_JEEM_INITIAL_FORM					0xFCC4
#define U_ARABIC_LIGATURE_KAF_WITH_HAH_INITIAL_FORM					0xFCC5
#define U_ARABIC_LIGATURE_KAF_WITH_KHAH_INITIAL_FORM					0xFCC6
#define U_ARABIC_LIGATURE_KAF_WITH_LAM_INITIAL_FORM					0xFCC7
#define U_ARABIC_LIGATURE_KAF_WITH_MEEM_INITIAL_FORM					0xFCC8
#define U_ARABIC_LIGATURE_LAM_WITH_JEEM_INITIAL_FORM					0xFCC9
#define U_ARABIC_LIGATURE_LAM_WITH_HAH_INITIAL_FORM					0xFCCA
#define U_ARABIC_LIGATURE_LAM_WITH_KHAH_INITIAL_FORM					0xFCCB
#define U_ARABIC_LIGATURE_LAM_WITH_MEEM_INITIAL_FORM					0xFCCC
#define U_ARABIC_LIGATURE_LAM_WITH_HEH_INITIAL_FORM					0xFCCD
#define U_ARABIC_LIGATURE_MEEM_WITH_JEEM_INITIAL_FORM					0xFCCE
#define U_ARABIC_LIGATURE_MEEM_WITH_HAH_INITIAL_FORM					0xFCCF
#define U_ARABIC_LIGATURE_MEEM_WITH_KHAH_INITIAL_FORM					0xFCD0
#define U_ARABIC_LIGATURE_MEEM_WITH_MEEM_INITIAL_FORM					0xFCD1
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_INITIAL_FORM					0xFCD2
#define U_ARABIC_LIGATURE_NOON_WITH_HAH_INITIAL_FORM					0xFCD3
#define U_ARABIC_LIGATURE_NOON_WITH_KHAH_INITIAL_FORM					0xFCD4
#define U_ARABIC_LIGATURE_NOON_WITH_MEEM_INITIAL_FORM					0xFCD5
#define U_ARABIC_LIGATURE_NOON_WITH_HEH_INITIAL_FORM					0xFCD6
#define U_ARABIC_LIGATURE_HEH_WITH_JEEM_INITIAL_FORM					0xFCD7
#define U_ARABIC_LIGATURE_HEH_WITH_MEEM_INITIAL_FORM					0xFCD8
#define U_ARABIC_LIGATURE_HEH_WITH_SUPERSCRIPT_ALEF_INITIAL_FORM			0xFCD9
#define U_ARABIC_LIGATURE_YEH_WITH_JEEM_INITIAL_FORM					0xFCDA
#define U_ARABIC_LIGATURE_YEH_WITH_HAH_INITIAL_FORM					0xFCDB
#define U_ARABIC_LIGATURE_YEH_WITH_KHAH_INITIAL_FORM					0xFCDC
#define U_ARABIC_LIGATURE_YEH_WITH_MEEM_INITIAL_FORM					0xFCDD
#define U_ARABIC_LIGATURE_YEH_WITH_HEH_INITIAL_FORM					0xFCDE
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_MEDIAL_FORM			0xFCDF
#define U_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_MEDIAL_FORM			0xFCE0
#define U_ARABIC_LIGATURE_BEH_WITH_MEEM_MEDIAL_FORM					0xFCE1
#define U_ARABIC_LIGATURE_BEH_WITH_HEH_MEDIAL_FORM					0xFCE2
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_MEDIAL_FORM					0xFCE3
#define U_ARABIC_LIGATURE_TEH_WITH_HEH_MEDIAL_FORM					0xFCE4
#define U_ARABIC_LIGATURE_THEH_WITH_MEEM_MEDIAL_FORM					0xFCE5
#define U_ARABIC_LIGATURE_THEH_WITH_HEH_MEDIAL_FORM					0xFCE6
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_MEDIAL_FORM					0xFCE7
#define U_ARABIC_LIGATURE_SEEN_WITH_HEH_MEDIAL_FORM					0xFCE8
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_MEDIAL_FORM					0xFCE9
#define U_ARABIC_LIGATURE_SHEEN_WITH_HEH_MEDIAL_FORM					0xFCEA
#define U_ARABIC_LIGATURE_KAF_WITH_LAM_MEDIAL_FORM					0xFCEB
#define U_ARABIC_LIGATURE_KAF_WITH_MEEM_MEDIAL_FORM					0xFCEC
#define U_ARABIC_LIGATURE_LAM_WITH_MEEM_MEDIAL_FORM					0xFCED
#define U_ARABIC_LIGATURE_NOON_WITH_MEEM_MEDIAL_FORM					0xFCEE
#define U_ARABIC_LIGATURE_NOON_WITH_HEH_MEDIAL_FORM					0xFCEF
#define U_ARABIC_LIGATURE_YEH_WITH_MEEM_MEDIAL_FORM					0xFCF0
#define U_ARABIC_LIGATURE_YEH_WITH_HEH_MEDIAL_FORM					0xFCF1
#define U_ARABIC_LIGATURE_SHADDA_WITH_FATHA_MEDIAL_FORM					0xFCF2
#define U_ARABIC_LIGATURE_SHADDA_WITH_DAMMA_MEDIAL_FORM					0xFCF3
#define U_ARABIC_LIGATURE_SHADDA_WITH_KASRA_MEDIAL_FORM					0xFCF4
#define U_ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFCF5
#define U_ARABIC_LIGATURE_TAH_WITH_YEH_ISOLATED_FORM					0xFCF6
#define U_ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFCF7
#define U_ARABIC_LIGATURE_AIN_WITH_YEH_ISOLATED_FORM					0xFCF8
#define U_ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFCF9
#define U_ARABIC_LIGATURE_GHAIN_WITH_YEH_ISOLATED_FORM					0xFCFA
#define U_ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFCFB
#define U_ARABIC_LIGATURE_SEEN_WITH_YEH_ISOLATED_FORM					0xFCFC
#define U_ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFCFD
#define U_ARABIC_LIGATURE_SHEEN_WITH_YEH_ISOLATED_FORM					0xFCFE
#define U_ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFCFF
#define U_ARABIC_LIGATURE_HAH_WITH_YEH_ISOLATED_FORM					0xFD00
#define U_ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFD01
#define U_ARABIC_LIGATURE_JEEM_WITH_YEH_ISOLATED_FORM					0xFD02
#define U_ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFD03
#define U_ARABIC_LIGATURE_KHAH_WITH_YEH_ISOLATED_FORM					0xFD04
#define U_ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFD05
#define U_ARABIC_LIGATURE_SAD_WITH_YEH_ISOLATED_FORM					0xFD06
#define U_ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_ISOLATED_FORM				0xFD07
#define U_ARABIC_LIGATURE_DAD_WITH_YEH_ISOLATED_FORM					0xFD08
#define U_ARABIC_LIGATURE_SHEEN_WITH_JEEM_ISOLATED_FORM					0xFD09
#define U_ARABIC_LIGATURE_SHEEN_WITH_HAH_ISOLATED_FORM					0xFD0A
#define U_ARABIC_LIGATURE_SHEEN_WITH_KHAH_ISOLATED_FORM					0xFD0B
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_ISOLATED_FORM					0xFD0C
#define U_ARABIC_LIGATURE_SHEEN_WITH_REH_ISOLATED_FORM					0xFD0D
#define U_ARABIC_LIGATURE_SEEN_WITH_REH_ISOLATED_FORM					0xFD0E
#define U_ARABIC_LIGATURE_SAD_WITH_REH_ISOLATED_FORM					0xFD0F
#define U_ARABIC_LIGATURE_DAD_WITH_REH_ISOLATED_FORM					0xFD10
#define U_ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD11
#define U_ARABIC_LIGATURE_TAH_WITH_YEH_FINAL_FORM					0xFD12
#define U_ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD13
#define U_ARABIC_LIGATURE_AIN_WITH_YEH_FINAL_FORM					0xFD14
#define U_ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD15
#define U_ARABIC_LIGATURE_GHAIN_WITH_YEH_FINAL_FORM					0xFD16
#define U_ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD17
#define U_ARABIC_LIGATURE_SEEN_WITH_YEH_FINAL_FORM					0xFD18
#define U_ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD19
#define U_ARABIC_LIGATURE_SHEEN_WITH_YEH_FINAL_FORM					0xFD1A
#define U_ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD1B
#define U_ARABIC_LIGATURE_HAH_WITH_YEH_FINAL_FORM					0xFD1C
#define U_ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD1D
#define U_ARABIC_LIGATURE_JEEM_WITH_YEH_FINAL_FORM					0xFD1E
#define U_ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD1F
#define U_ARABIC_LIGATURE_KHAH_WITH_YEH_FINAL_FORM					0xFD20
#define U_ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD21
#define U_ARABIC_LIGATURE_SAD_WITH_YEH_FINAL_FORM					0xFD22
#define U_ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_FINAL_FORM				0xFD23
#define U_ARABIC_LIGATURE_DAD_WITH_YEH_FINAL_FORM					0xFD24
#define U_ARABIC_LIGATURE_SHEEN_WITH_JEEM_FINAL_FORM					0xFD25
#define U_ARABIC_LIGATURE_SHEEN_WITH_HAH_FINAL_FORM					0xFD26
#define U_ARABIC_LIGATURE_SHEEN_WITH_KHAH_FINAL_FORM					0xFD27
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_FINAL_FORM					0xFD28
#define U_ARABIC_LIGATURE_SHEEN_WITH_REH_FINAL_FORM					0xFD29
#define U_ARABIC_LIGATURE_SEEN_WITH_REH_FINAL_FORM					0xFD2A
#define U_ARABIC_LIGATURE_SAD_WITH_REH_FINAL_FORM					0xFD2B
#define U_ARABIC_LIGATURE_DAD_WITH_REH_FINAL_FORM					0xFD2C
#define U_ARABIC_LIGATURE_SHEEN_WITH_JEEM_INITIAL_FORM					0xFD2D
#define U_ARABIC_LIGATURE_SHEEN_WITH_HAH_INITIAL_FORM					0xFD2E
#define U_ARABIC_LIGATURE_SHEEN_WITH_KHAH_INITIAL_FORM					0xFD2F
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_INITIAL_FORM					0xFD30
#define U_ARABIC_LIGATURE_SEEN_WITH_HEH_INITIAL_FORM					0xFD31
#define U_ARABIC_LIGATURE_SHEEN_WITH_HEH_INITIAL_FORM					0xFD32
#define U_ARABIC_LIGATURE_TAH_WITH_MEEM_INITIAL_FORM					0xFD33
#define U_ARABIC_LIGATURE_SEEN_WITH_JEEM_MEDIAL_FORM					0xFD34
#define U_ARABIC_LIGATURE_SEEN_WITH_HAH_MEDIAL_FORM					0xFD35
#define U_ARABIC_LIGATURE_SEEN_WITH_KHAH_MEDIAL_FORM					0xFD36
#define U_ARABIC_LIGATURE_SHEEN_WITH_JEEM_MEDIAL_FORM					0xFD37
#define U_ARABIC_LIGATURE_SHEEN_WITH_HAH_MEDIAL_FORM					0xFD38
#define U_ARABIC_LIGATURE_SHEEN_WITH_KHAH_MEDIAL_FORM					0xFD39
#define U_ARABIC_LIGATURE_TAH_WITH_MEEM_MEDIAL_FORM					0xFD3A
#define U_ARABIC_LIGATURE_ZAH_WITH_MEEM_MEDIAL_FORM					0xFD3B
#define U_ARABIC_LIGATURE_ALEF_WITH_FATHATAN_FINAL_FORM					0xFD3C
#define U_ARABIC_LIGATURE_ALEF_WITH_FATHATAN_ISOLATED_FORM				0xFD3D
#define U_ORNATE_LEFT_PARENTHESIS							0xFD3E
#define U_ORNATE_RIGHT_PARENTHESIS							0xFD3F
#define U_ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_MEEM_INITIAL_FORM				0xFD50
#define U_ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_FINAL_FORM				0xFD51
#define U_ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_INITIAL_FORM				0xFD52
#define U_ARABIC_LIGATURE_TEH_WITH_HAH_WITH_MEEM_INITIAL_FORM				0xFD53
#define U_ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM				0xFD54
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM				0xFD55
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_HAH_INITIAL_FORM				0xFD56
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_KHAH_INITIAL_FORM				0xFD57
#define U_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_FINAL_FORM				0xFD58
#define U_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_INITIAL_FORM				0xFD59
#define U_ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFD5A
#define U_ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD5B
#define U_ARABIC_LIGATURE_SEEN_WITH_HAH_WITH_JEEM_INITIAL_FORM				0xFD5C
#define U_ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_HAH_INITIAL_FORM				0xFD5D
#define U_ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD5E
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_FINAL_FORM				0xFD5F
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_INITIAL_FORM				0xFD60
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_JEEM_INITIAL_FORM				0xFD61
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFD62
#define U_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM				0xFD63
#define U_ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_FINAL_FORM				0xFD64
#define U_ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_INITIAL_FORM				0xFD65
#define U_ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFD66
#define U_ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_FINAL_FORM				0xFD67
#define U_ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_INITIAL_FORM				0xFD68
#define U_ARABIC_LIGATURE_SHEEN_WITH_JEEM_WITH_YEH_FINAL_FORM				0xFD69
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_FINAL_FORM				0xFD6A
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_INITIAL_FORM			0xFD6B
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFD6C
#define U_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM			0xFD6D
#define U_ARABIC_LIGATURE_DAD_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD6E
#define U_ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_FINAL_FORM				0xFD6F
#define U_ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_INITIAL_FORM				0xFD70
#define U_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_FINAL_FORM				0xFD71
#define U_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_INITIAL_FORM				0xFD72
#define U_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_MEEM_INITIAL_FORM				0xFD73
#define U_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFD74
#define U_ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_FINAL_FORM				0xFD75
#define U_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFD76
#define U_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_INITIAL_FORM				0xFD77
#define U_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD78
#define U_ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFD79
#define U_ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFD7A
#define U_ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD7B
#define U_ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_FINAL_FORM				0xFD7C
#define U_ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM				0xFD7D
#define U_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_FINAL_FORM				0xFD7E
#define U_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFD7F
#define U_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_FINAL_FORM				0xFD80
#define U_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_YEH_FINAL_FORM				0xFD81
#define U_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD82
#define U_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_INITIAL_FORM				0xFD83
#define U_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_FINAL_FORM				0xFD84
#define U_ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_FINAL_FORM				0xFD85
#define U_ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_INITIAL_FORM				0xFD86
#define U_ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_FINAL_FORM				0xFD87
#define U_ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_INITIAL_FORM				0xFD88
#define U_ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_JEEM_INITIAL_FORM				0xFD89
#define U_ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_MEEM_INITIAL_FORM				0xFD8A
#define U_ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_YEH_FINAL_FORM				0xFD8B
#define U_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_HAH_INITIAL_FORM				0xFD8C
#define U_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_MEEM_INITIAL_FORM				0xFD8D
#define U_ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_JEEM_INITIAL_FORM				0xFD8E
#define U_ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_MEEM_INITIAL_FORM				0xFD8F
#define U_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_KHAH_INITIAL_FORM				0xFD92
#define U_ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM				0xFD93
#define U_ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM				0xFD94
#define U_ARABIC_LIGATURE_NOON_WITH_HAH_WITH_MEEM_INITIAL_FORM				0xFD95
#define U_ARABIC_LIGATURE_NOON_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD96
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_FINAL_FORM				0xFD97
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_INITIAL_FORM				0xFD98
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD99
#define U_ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFD9A
#define U_ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFD9B
#define U_ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFD9C
#define U_ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM				0xFD9D
#define U_ARABIC_LIGATURE_BEH_WITH_KHAH_WITH_YEH_FINAL_FORM				0xFD9E
#define U_ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_YEH_FINAL_FORM				0xFD9F
#define U_ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFDA0
#define U_ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_YEH_FINAL_FORM				0xFDA1
#define U_ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM			0xFDA2
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDA3
#define U_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFDA4
#define U_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDA5
#define U_ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM			0xFDA6
#define U_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM			0xFDA7
#define U_ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM			0xFDA8
#define U_ARABIC_LIGATURE_SAD_WITH_HAH_WITH_YEH_FINAL_FORM				0xFDA9
#define U_ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_YEH_FINAL_FORM				0xFDAA
#define U_ARABIC_LIGATURE_DAD_WITH_HAH_WITH_YEH_FINAL_FORM				0xFDAB
#define U_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_YEH_FINAL_FORM				0xFDAC
#define U_ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDAD
#define U_ARABIC_LIGATURE_YEH_WITH_HAH_WITH_YEH_FINAL_FORM				0xFDAE
#define U_ARABIC_LIGATURE_YEH_WITH_JEEM_WITH_YEH_FINAL_FORM				0xFDAF
#define U_ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDB0
#define U_ARABIC_LIGATURE_MEEM_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDB1
#define U_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDB2
#define U_ARABIC_LIGATURE_NOON_WITH_HAH_WITH_YEH_FINAL_FORM				0xFDB3
#define U_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_INITIAL_FORM				0xFDB4
#define U_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_INITIAL_FORM				0xFDB5
#define U_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDB6
#define U_ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDB7
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_INITIAL_FORM				0xFDB8
#define U_ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_YEH_FINAL_FORM				0xFDB9
#define U_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_INITIAL_FORM				0xFDBA
#define U_ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_FINAL_FORM				0xFDBB
#define U_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_FINAL_FORM				0xFDBC
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_FINAL_FORM				0xFDBD
#define U_ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_YEH_FINAL_FORM				0xFDBE
#define U_ARABIC_LIGATURE_HAH_WITH_JEEM_WITH_YEH_FINAL_FORM				0xFDBF
#define U_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_YEH_FINAL_FORM				0xFDC0
#define U_ARABIC_LIGATURE_FEH_WITH_MEEM_WITH_YEH_FINAL_FORM				0xFDC1
#define U_ARABIC_LIGATURE_BEH_WITH_HAH_WITH_YEH_FINAL_FORM				0xFDC2
#define U_ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_INITIAL_FORM				0xFDC3
#define U_ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_INITIAL_FORM				0xFDC4
#define U_ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_INITIAL_FORM				0xFDC5
#define U_ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_YEH_FINAL_FORM				0xFDC6
#define U_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_YEH_FINAL_FORM				0xFDC7
#define U_ARABIC_LIGATURE_SALLA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM			0xFDF0
#define U_ARABIC_LIGATURE_QALA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM			0xFDF1
#define U_ARABIC_LIGATURE_ALLAH_ISOLATED_FORM						0xFDF2
#define U_ARABIC_LIGATURE_AKBAR_ISOLATED_FORM						0xFDF3
#define U_ARABIC_LIGATURE_MOHAMMAD_ISOLATED_FORM					0xFDF4
#define U_ARABIC_LIGATURE_SALAM_ISOLATED_FORM						0xFDF5
#define U_ARABIC_LIGATURE_RASOUL_ISOLATED_FORM						0xFDF6
#define U_ARABIC_LIGATURE_ALAYHE_ISOLATED_FORM						0xFDF7
#define U_ARABIC_LIGATURE_WASALLAM_ISOLATED_FORM					0xFDF8
#define U_ARABIC_LIGATURE_SALLA_ISOLATED_FORM						0xFDF9
#define U_ARABIC_LIGATURE_SALLALLAHOU_ALAYHE_WASALLAM					0xFDFA
#define U_ARABIC_LIGATURE_JALLAJALALOUHOU						0xFDFB
#define U_COMBINING_LIGATURE_LEFT_HALF							0xFE20
#define U_COMBINING_LIGATURE_RIGHT_HALF							0xFE21
#define U_COMBINING_DOUBLE_TILDE_LEFT_HALF						0xFE22
#define U_COMBINING_DOUBLE_TILDE_RIGHT_HALF						0xFE23
#define U_PRESENTATION_FORM_FOR_VERTICAL_TWO_DOT_LEADER					0xFE30
#define U_PRESENTATION_FORM_FOR_VERTICAL_EM_DASH					0xFE31
#define U_PRESENTATION_FORM_FOR_VERTICAL_EN_DASH					0xFE32
#define U_PRESENTATION_FORM_FOR_VERTICAL_LOW_LINE					0xFE33
#define U_PRESENTATION_FORM_FOR_VERTICAL_WAVY_LOW_LINE					0xFE34
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_PARENTHESIS				0xFE35
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_PARENTHESIS				0xFE36
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_CURLY_BRACKET				0xFE37
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CURLY_BRACKET				0xFE38
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_TORTOISE_SHELL_BRACKET			0xFE39
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_TORTOISE_SHELL_BRACKET			0xFE3A
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_BLACK_LENTICULAR_BRACKET			0xFE3B
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_BLACK_LENTICULAR_BRACKET			0xFE3C
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_DOUBLE_ANGLE_BRACKET			0xFE3D
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_DOUBLE_ANGLE_BRACKET			0xFE3E
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_ANGLE_BRACKET				0xFE3F
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_ANGLE_BRACKET				0xFE40
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_CORNER_BRACKET				0xFE41
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CORNER_BRACKET				0xFE42
#define U_PRESENTATION_FORM_FOR_VERTICAL_LEFT_WHITE_CORNER_BRACKET			0xFE43
#define U_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_WHITE_CORNER_BRACKET			0xFE44
#define U_DASHED_OVERLINE								0xFE49
#define U_CENTRELINE_OVERLINE								0xFE4A
#define U_WAVY_OVERLINE									0xFE4B
#define U_DOUBLE_WAVY_OVERLINE								0xFE4C
#define U_DASHED_LOW_LINE								0xFE4D
#define U_CENTRELINE_LOW_LINE								0xFE4E
#define U_WAVY_LOW_LINE									0xFE4F
#define U_SMALL_COMMA									0xFE50
#define U_SMALL_IDEOGRAPHIC_COMMA							0xFE51
#define U_SMALL_FULL_STOP								0xFE52
#define U_SMALL_SEMICOLON								0xFE54
#define U_SMALL_COLON									0xFE55
#define U_SMALL_QUESTION_MARK								0xFE56
#define U_SMALL_EXCLAMATION_MARK							0xFE57
#define U_SMALL_EM_DASH									0xFE58
#define U_SMALL_LEFT_PARENTHESIS							0xFE59
#define U_SMALL_RIGHT_PARENTHESIS							0xFE5A
#define U_SMALL_LEFT_CURLY_BRACKET							0xFE5B
#define U_SMALL_RIGHT_CURLY_BRACKET							0xFE5C
#define U_SMALL_LEFT_TORTOISE_SHELL_BRACKET						0xFE5D
#define U_SMALL_RIGHT_TORTOISE_SHELL_BRACKET						0xFE5E
#define U_SMALL_NUMBER_SIGN								0xFE5F
#define U_SMALL_AMPERSAND								0xFE60
#define U_SMALL_ASTERISK								0xFE61
#define U_SMALL_PLUS_SIGN								0xFE62
#define U_SMALL_HYPHEN_MINUS								0xFE63
#define U_SMALL_LESS_THAN_SIGN								0xFE64
#define U_SMALL_GREATER_THAN_SIGN							0xFE65
#define U_SMALL_EQUALS_SIGN								0xFE66
#define U_SMALL_REVERSE_SOLIDUS								0xFE68
#define U_SMALL_DOLLAR_SIGN								0xFE69
#define U_SMALL_PERCENT_SIGN								0xFE6A
#define U_SMALL_COMMERCIAL_AT								0xFE6B
#define U_ARABIC_FATHATAN_ISOLATED_FORM							0xFE70
#define U_ARABIC_TATWEEL_WITH_FATHATAN_ABOVE						0xFE71
#define U_ARABIC_DAMMATAN_ISOLATED_FORM							0xFE72
#define U_ARABIC_KASRATAN_ISOLATED_FORM							0xFE74
#define U_ARABIC_FATHA_ISOLATED_FORM							0xFE76
#define U_ARABIC_FATHA_MEDIAL_FORM							0xFE77
#define U_ARABIC_DAMMA_ISOLATED_FORM							0xFE78
#define U_ARABIC_DAMMA_MEDIAL_FORM							0xFE79
#define U_ARABIC_KASRA_ISOLATED_FORM							0xFE7A
#define U_ARABIC_KASRA_MEDIAL_FORM							0xFE7B
#define U_ARABIC_SHADDA_ISOLATED_FORM							0xFE7C
#define U_ARABIC_SHADDA_MEDIAL_FORM							0xFE7D
#define U_ARABIC_SUKUN_ISOLATED_FORM							0xFE7E
#define U_ARABIC_SUKUN_MEDIAL_FORM							0xFE7F
#define U_ARABIC_LETTER_HAMZA_ISOLATED_FORM						0xFE80
#define U_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM				0xFE81
#define U_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_FINAL_FORM				0xFE82
#define U_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM				0xFE83
#define U_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM				0xFE84
#define U_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_ISOLATED_FORM				0xFE85
#define U_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_FINAL_FORM					0xFE86
#define U_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM				0xFE87
#define U_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_FINAL_FORM				0xFE88
#define U_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_ISOLATED_FORM				0xFE89
#define U_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_FINAL_FORM					0xFE8A
#define U_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_INITIAL_FORM				0xFE8B
#define U_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_MEDIAL_FORM				0xFE8C
#define U_ARABIC_LETTER_ALEF_ISOLATED_FORM						0xFE8D
#define U_ARABIC_LETTER_ALEF_FINAL_FORM							0xFE8E
#define U_ARABIC_LETTER_BEH_ISOLATED_FORM						0xFE8F
#define U_ARABIC_LETTER_BEH_FINAL_FORM							0xFE90
#define U_ARABIC_LETTER_BEH_INITIAL_FORM						0xFE91
#define U_ARABIC_LETTER_BEH_MEDIAL_FORM							0xFE92
#define U_ARABIC_LETTER_TEH_MARBUTA_ISOLATED_FORM					0xFE93
#define U_ARABIC_LETTER_TEH_MARBUTA_FINAL_FORM						0xFE94
#define U_ARABIC_LETTER_TEH_ISOLATED_FORM						0xFE95
#define U_ARABIC_LETTER_TEH_FINAL_FORM							0xFE96
#define U_ARABIC_LETTER_TEH_INITIAL_FORM						0xFE97
#define U_ARABIC_LETTER_TEH_MEDIAL_FORM							0xFE98
#define U_ARABIC_LETTER_THEH_ISOLATED_FORM						0xFE99
#define U_ARABIC_LETTER_THEH_FINAL_FORM							0xFE9A
#define U_ARABIC_LETTER_THEH_INITIAL_FORM						0xFE9B
#define U_ARABIC_LETTER_THEH_MEDIAL_FORM						0xFE9C
#define U_ARABIC_LETTER_JEEM_ISOLATED_FORM						0xFE9D
#define U_ARABIC_LETTER_JEEM_FINAL_FORM							0xFE9E
#define U_ARABIC_LETTER_JEEM_INITIAL_FORM						0xFE9F
#define U_ARABIC_LETTER_JEEM_MEDIAL_FORM						0xFEA0
#define U_ARABIC_LETTER_HAH_ISOLATED_FORM						0xFEA1
#define U_ARABIC_LETTER_HAH_FINAL_FORM							0xFEA2
#define U_ARABIC_LETTER_HAH_INITIAL_FORM						0xFEA3
#define U_ARABIC_LETTER_HAH_MEDIAL_FORM							0xFEA4
#define U_ARABIC_LETTER_KHAH_ISOLATED_FORM						0xFEA5
#define U_ARABIC_LETTER_KHAH_FINAL_FORM							0xFEA6
#define U_ARABIC_LETTER_KHAH_INITIAL_FORM						0xFEA7
#define U_ARABIC_LETTER_KHAH_MEDIAL_FORM						0xFEA8
#define U_ARABIC_LETTER_DAL_ISOLATED_FORM						0xFEA9
#define U_ARABIC_LETTER_DAL_FINAL_FORM							0xFEAA
#define U_ARABIC_LETTER_THAL_ISOLATED_FORM						0xFEAB
#define U_ARABIC_LETTER_THAL_FINAL_FORM							0xFEAC
#define U_ARABIC_LETTER_REH_ISOLATED_FORM						0xFEAD
#define U_ARABIC_LETTER_REH_FINAL_FORM							0xFEAE
#define U_ARABIC_LETTER_ZAIN_ISOLATED_FORM						0xFEAF
#define U_ARABIC_LETTER_ZAIN_FINAL_FORM							0xFEB0
#define U_ARABIC_LETTER_SEEN_ISOLATED_FORM						0xFEB1
#define U_ARABIC_LETTER_SEEN_FINAL_FORM							0xFEB2
#define U_ARABIC_LETTER_SEEN_INITIAL_FORM						0xFEB3
#define U_ARABIC_LETTER_SEEN_MEDIAL_FORM						0xFEB4
#define U_ARABIC_LETTER_SHEEN_ISOLATED_FORM						0xFEB5
#define U_ARABIC_LETTER_SHEEN_FINAL_FORM						0xFEB6
#define U_ARABIC_LETTER_SHEEN_INITIAL_FORM						0xFEB7
#define U_ARABIC_LETTER_SHEEN_MEDIAL_FORM						0xFEB8
#define U_ARABIC_LETTER_SAD_ISOLATED_FORM						0xFEB9
#define U_ARABIC_LETTER_SAD_FINAL_FORM							0xFEBA
#define U_ARABIC_LETTER_SAD_INITIAL_FORM						0xFEBB
#define U_ARABIC_LETTER_SAD_MEDIAL_FORM							0xFEBC
#define U_ARABIC_LETTER_DAD_ISOLATED_FORM						0xFEBD
#define U_ARABIC_LETTER_DAD_FINAL_FORM							0xFEBE
#define U_ARABIC_LETTER_DAD_INITIAL_FORM						0xFEBF
#define U_ARABIC_LETTER_DAD_MEDIAL_FORM							0xFEC0
#define U_ARABIC_LETTER_TAH_ISOLATED_FORM						0xFEC1
#define U_ARABIC_LETTER_TAH_FINAL_FORM							0xFEC2
#define U_ARABIC_LETTER_TAH_INITIAL_FORM						0xFEC3
#define U_ARABIC_LETTER_TAH_MEDIAL_FORM							0xFEC4
#define U_ARABIC_LETTER_ZAH_ISOLATED_FORM						0xFEC5
#define U_ARABIC_LETTER_ZAH_FINAL_FORM							0xFEC6
#define U_ARABIC_LETTER_ZAH_INITIAL_FORM						0xFEC7
#define U_ARABIC_LETTER_ZAH_MEDIAL_FORM							0xFEC8
#define U_ARABIC_LETTER_AIN_ISOLATED_FORM						0xFEC9
#define U_ARABIC_LETTER_AIN_FINAL_FORM							0xFECA
#define U_ARABIC_LETTER_AIN_INITIAL_FORM						0xFECB
#define U_ARABIC_LETTER_AIN_MEDIAL_FORM							0xFECC
#define U_ARABIC_LETTER_GHAIN_ISOLATED_FORM						0xFECD
#define U_ARABIC_LETTER_GHAIN_FINAL_FORM						0xFECE
#define U_ARABIC_LETTER_GHAIN_INITIAL_FORM						0xFECF
#define U_ARABIC_LETTER_GHAIN_MEDIAL_FORM						0xFED0
#define U_ARABIC_LETTER_FEH_ISOLATED_FORM						0xFED1
#define U_ARABIC_LETTER_FEH_FINAL_FORM							0xFED2
#define U_ARABIC_LETTER_FEH_INITIAL_FORM						0xFED3
#define U_ARABIC_LETTER_FEH_MEDIAL_FORM							0xFED4
#define U_ARABIC_LETTER_QAF_ISOLATED_FORM						0xFED5
#define U_ARABIC_LETTER_QAF_FINAL_FORM							0xFED6
#define U_ARABIC_LETTER_QAF_INITIAL_FORM						0xFED7
#define U_ARABIC_LETTER_QAF_MEDIAL_FORM							0xFED8
#define U_ARABIC_LETTER_KAF_ISOLATED_FORM						0xFED9
#define U_ARABIC_LETTER_KAF_FINAL_FORM							0xFEDA
#define U_ARABIC_LETTER_KAF_INITIAL_FORM						0xFEDB
#define U_ARABIC_LETTER_KAF_MEDIAL_FORM							0xFEDC
#define U_ARABIC_LETTER_LAM_ISOLATED_FORM						0xFEDD
#define U_ARABIC_LETTER_LAM_FINAL_FORM							0xFEDE
#define U_ARABIC_LETTER_LAM_INITIAL_FORM						0xFEDF
#define U_ARABIC_LETTER_LAM_MEDIAL_FORM							0xFEE0
#define U_ARABIC_LETTER_MEEM_ISOLATED_FORM						0xFEE1
#define U_ARABIC_LETTER_MEEM_FINAL_FORM							0xFEE2
#define U_ARABIC_LETTER_MEEM_INITIAL_FORM						0xFEE3
#define U_ARABIC_LETTER_MEEM_MEDIAL_FORM						0xFEE4
#define U_ARABIC_LETTER_NOON_ISOLATED_FORM						0xFEE5
#define U_ARABIC_LETTER_NOON_FINAL_FORM							0xFEE6
#define U_ARABIC_LETTER_NOON_INITIAL_FORM						0xFEE7
#define U_ARABIC_LETTER_NOON_MEDIAL_FORM						0xFEE8
#define U_ARABIC_LETTER_HEH_ISOLATED_FORM						0xFEE9
#define U_ARABIC_LETTER_HEH_FINAL_FORM							0xFEEA
#define U_ARABIC_LETTER_HEH_INITIAL_FORM						0xFEEB
#define U_ARABIC_LETTER_HEH_MEDIAL_FORM							0xFEEC
#define U_ARABIC_LETTER_WAW_ISOLATED_FORM						0xFEED
#define U_ARABIC_LETTER_WAW_FINAL_FORM							0xFEEE
#define U_ARABIC_LETTER_ALEF_MAKSURA_ISOLATED_FORM					0xFEEF
#define U_ARABIC_LETTER_ALEF_MAKSURA_FINAL_FORM						0xFEF0
#define U_ARABIC_LETTER_YEH_ISOLATED_FORM						0xFEF1
#define U_ARABIC_LETTER_YEH_FINAL_FORM							0xFEF2
#define U_ARABIC_LETTER_YEH_INITIAL_FORM						0xFEF3
#define U_ARABIC_LETTER_YEH_MEDIAL_FORM							0xFEF4
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM			0xFEF5
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_FINAL_FORM			0xFEF6
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM			0xFEF7
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM			0xFEF8
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM			0xFEF9
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_FINAL_FORM			0xFEFA
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_ISOLATED_FORM					0xFEFB
#define U_ARABIC_LIGATURE_LAM_WITH_ALEF_FINAL_FORM					0xFEFC
#define U_ZERO_WIDTH_NO_BREAK_SPACE							0xFEFF
#define U_FULLWIDTH_EXCLAMATION_MARK							0xFF01
#define U_FULLWIDTH_QUOTATION_MARK							0xFF02
#define U_FULLWIDTH_NUMBER_SIGN								0xFF03
#define U_FULLWIDTH_DOLLAR_SIGN								0xFF04
#define U_FULLWIDTH_PERCENT_SIGN							0xFF05
#define U_FULLWIDTH_AMPERSAND								0xFF06
#define U_FULLWIDTH_APOSTROPHE								0xFF07
#define U_FULLWIDTH_LEFT_PARENTHESIS							0xFF08
#define U_FULLWIDTH_RIGHT_PARENTHESIS							0xFF09
#define U_FULLWIDTH_ASTERISK								0xFF0A
#define U_FULLWIDTH_PLUS_SIGN								0xFF0B
#define U_FULLWIDTH_COMMA								0xFF0C
#define U_FULLWIDTH_HYPHEN_MINUS							0xFF0D
#define U_FULLWIDTH_FULL_STOP								0xFF0E
#define U_FULLWIDTH_SOLIDUS								0xFF0F
#define U_FULLWIDTH_DIGIT_ZERO								0xFF10
#define U_FULLWIDTH_DIGIT_ONE								0xFF11
#define U_FULLWIDTH_DIGIT_TWO								0xFF12
#define U_FULLWIDTH_DIGIT_THREE								0xFF13
#define U_FULLWIDTH_DIGIT_FOUR								0xFF14
#define U_FULLWIDTH_DIGIT_FIVE								0xFF15
#define U_FULLWIDTH_DIGIT_SIX								0xFF16
#define U_FULLWIDTH_DIGIT_SEVEN								0xFF17
#define U_FULLWIDTH_DIGIT_EIGHT								0xFF18
#define U_FULLWIDTH_DIGIT_NINE								0xFF19
#define U_FULLWIDTH_COLON								0xFF1A
#define U_FULLWIDTH_SEMICOLON								0xFF1B
#define U_FULLWIDTH_LESS_THAN_SIGN							0xFF1C
#define U_FULLWIDTH_EQUALS_SIGN								0xFF1D
#define U_FULLWIDTH_GREATER_THAN_SIGN							0xFF1E
#define U_FULLWIDTH_QUESTION_MARK							0xFF1F
#define U_FULLWIDTH_COMMERCIAL_AT							0xFF20
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_A						0xFF21
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_B						0xFF22
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_C						0xFF23
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_D						0xFF24
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_E						0xFF25
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_F						0xFF26
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_G						0xFF27
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_H						0xFF28
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_I						0xFF29
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_J						0xFF2A
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_K						0xFF2B
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_L						0xFF2C
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_M						0xFF2D
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_N						0xFF2E
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_O						0xFF2F
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_P						0xFF30
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_Q						0xFF31
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_R						0xFF32
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_S						0xFF33
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_T						0xFF34
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_U						0xFF35
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_V						0xFF36
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_W						0xFF37
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_X						0xFF38
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_Y						0xFF39
#define U_FULLWIDTH_LATIN_CAPITAL_LETTER_Z						0xFF3A
#define U_FULLWIDTH_LEFT_SQUARE_BRACKET							0xFF3B
#define U_FULLWIDTH_REVERSE_SOLIDUS							0xFF3C
#define U_FULLWIDTH_RIGHT_SQUARE_BRACKET						0xFF3D
#define U_FULLWIDTH_CIRCUMFLEX_ACCENT							0xFF3E
#define U_FULLWIDTH_LOW_LINE								0xFF3F
#define U_FULLWIDTH_GRAVE_ACCENT							0xFF40
#define U_FULLWIDTH_LATIN_SMALL_LETTER_A						0xFF41
#define U_FULLWIDTH_LATIN_SMALL_LETTER_B						0xFF42
#define U_FULLWIDTH_LATIN_SMALL_LETTER_C						0xFF43
#define U_FULLWIDTH_LATIN_SMALL_LETTER_D						0xFF44
#define U_FULLWIDTH_LATIN_SMALL_LETTER_E						0xFF45
#define U_FULLWIDTH_LATIN_SMALL_LETTER_F						0xFF46
#define U_FULLWIDTH_LATIN_SMALL_LETTER_G						0xFF47
#define U_FULLWIDTH_LATIN_SMALL_LETTER_H						0xFF48
#define U_FULLWIDTH_LATIN_SMALL_LETTER_I						0xFF49
#define U_FULLWIDTH_LATIN_SMALL_LETTER_J						0xFF4A
#define U_FULLWIDTH_LATIN_SMALL_LETTER_K						0xFF4B
#define U_FULLWIDTH_LATIN_SMALL_LETTER_L						0xFF4C
#define U_FULLWIDTH_LATIN_SMALL_LETTER_M						0xFF4D
#define U_FULLWIDTH_LATIN_SMALL_LETTER_N						0xFF4E
#define U_FULLWIDTH_LATIN_SMALL_LETTER_O						0xFF4F
#define U_FULLWIDTH_LATIN_SMALL_LETTER_P						0xFF50
#define U_FULLWIDTH_LATIN_SMALL_LETTER_Q						0xFF51
#define U_FULLWIDTH_LATIN_SMALL_LETTER_R						0xFF52
#define U_FULLWIDTH_LATIN_SMALL_LETTER_S						0xFF53
#define U_FULLWIDTH_LATIN_SMALL_LETTER_T						0xFF54
#define U_FULLWIDTH_LATIN_SMALL_LETTER_U						0xFF55
#define U_FULLWIDTH_LATIN_SMALL_LETTER_V						0xFF56
#define U_FULLWIDTH_LATIN_SMALL_LETTER_W						0xFF57
#define U_FULLWIDTH_LATIN_SMALL_LETTER_X						0xFF58
#define U_FULLWIDTH_LATIN_SMALL_LETTER_Y						0xFF59
#define U_FULLWIDTH_LATIN_SMALL_LETTER_Z						0xFF5A
#define U_FULLWIDTH_LEFT_CURLY_BRACKET							0xFF5B
#define U_FULLWIDTH_VERTICAL_LINE							0xFF5C
#define U_FULLWIDTH_RIGHT_CURLY_BRACKET							0xFF5D
#define U_FULLWIDTH_TILDE								0xFF5E
#define U_HALFWIDTH_IDEOGRAPHIC_FULL_STOP						0xFF61
#define U_HALFWIDTH_LEFT_CORNER_BRACKET							0xFF62
#define U_HALFWIDTH_RIGHT_CORNER_BRACKET						0xFF63
#define U_HALFWIDTH_IDEOGRAPHIC_COMMA							0xFF64
#define U_HALFWIDTH_KATAKANA_MIDDLE_DOT							0xFF65
#define U_HALFWIDTH_KATAKANA_LETTER_WO							0xFF66
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_A						0xFF67
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_I						0xFF68
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_U						0xFF69
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_E						0xFF6A
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_O						0xFF6B
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_YA						0xFF6C
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_YU						0xFF6D
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_YO						0xFF6E
#define U_HALFWIDTH_KATAKANA_LETTER_SMALL_TU						0xFF6F
#define U_HALFWIDTH_KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK				0xFF70
#define U_HALFWIDTH_KATAKANA_LETTER_A							0xFF71
#define U_HALFWIDTH_KATAKANA_LETTER_I							0xFF72
#define U_HALFWIDTH_KATAKANA_LETTER_U							0xFF73
#define U_HALFWIDTH_KATAKANA_LETTER_E							0xFF74
#define U_HALFWIDTH_KATAKANA_LETTER_O							0xFF75
#define U_HALFWIDTH_KATAKANA_LETTER_KA							0xFF76
#define U_HALFWIDTH_KATAKANA_LETTER_KI							0xFF77
#define U_HALFWIDTH_KATAKANA_LETTER_KU							0xFF78
#define U_HALFWIDTH_KATAKANA_LETTER_KE							0xFF79
#define U_HALFWIDTH_KATAKANA_LETTER_KO							0xFF7A
#define U_HALFWIDTH_KATAKANA_LETTER_SA							0xFF7B
#define U_HALFWIDTH_KATAKANA_LETTER_SI							0xFF7C
#define U_HALFWIDTH_KATAKANA_LETTER_SU							0xFF7D
#define U_HALFWIDTH_KATAKANA_LETTER_SE							0xFF7E
#define U_HALFWIDTH_KATAKANA_LETTER_SO							0xFF7F
#define U_HALFWIDTH_KATAKANA_LETTER_TA							0xFF80
#define U_HALFWIDTH_KATAKANA_LETTER_TI							0xFF81
#define U_HALFWIDTH_KATAKANA_LETTER_TU							0xFF82
#define U_HALFWIDTH_KATAKANA_LETTER_TE							0xFF83
#define U_HALFWIDTH_KATAKANA_LETTER_TO							0xFF84
#define U_HALFWIDTH_KATAKANA_LETTER_NA							0xFF85
#define U_HALFWIDTH_KATAKANA_LETTER_NI							0xFF86
#define U_HALFWIDTH_KATAKANA_LETTER_NU							0xFF87
#define U_HALFWIDTH_KATAKANA_LETTER_NE							0xFF88
#define U_HALFWIDTH_KATAKANA_LETTER_NO							0xFF89
#define U_HALFWIDTH_KATAKANA_LETTER_HA							0xFF8A
#define U_HALFWIDTH_KATAKANA_LETTER_HI							0xFF8B
#define U_HALFWIDTH_KATAKANA_LETTER_HU							0xFF8C
#define U_HALFWIDTH_KATAKANA_LETTER_HE							0xFF8D
#define U_HALFWIDTH_KATAKANA_LETTER_HO							0xFF8E
#define U_HALFWIDTH_KATAKANA_LETTER_MA							0xFF8F
#define U_HALFWIDTH_KATAKANA_LETTER_MI							0xFF90
#define U_HALFWIDTH_KATAKANA_LETTER_MU							0xFF91
#define U_HALFWIDTH_KATAKANA_LETTER_ME							0xFF92
#define U_HALFWIDTH_KATAKANA_LETTER_MO							0xFF93
#define U_HALFWIDTH_KATAKANA_LETTER_YA							0xFF94
#define U_HALFWIDTH_KATAKANA_LETTER_YU							0xFF95
#define U_HALFWIDTH_KATAKANA_LETTER_YO							0xFF96
#define U_HALFWIDTH_KATAKANA_LETTER_RA							0xFF97
#define U_HALFWIDTH_KATAKANA_LETTER_RI							0xFF98
#define U_HALFWIDTH_KATAKANA_LETTER_RU							0xFF99
#define U_HALFWIDTH_KATAKANA_LETTER_RE							0xFF9A
#define U_HALFWIDTH_KATAKANA_LETTER_RO							0xFF9B
#define U_HALFWIDTH_KATAKANA_LETTER_WA							0xFF9C
#define U_HALFWIDTH_KATAKANA_LETTER_N							0xFF9D
#define U_HALFWIDTH_KATAKANA_VOICED_SOUND_MARK						0xFF9E
#define U_HALFWIDTH_KATAKANA_SEMI_VOICED_SOUND_MARK					0xFF9F
#define U_HALFWIDTH_HANGUL_FILLER							0xFFA0
#define U_HALFWIDTH_HANGUL_LETTER_KIYEOK						0xFFA1
#define U_HALFWIDTH_HANGUL_LETTER_SSANGKIYEOK						0xFFA2
#define U_HALFWIDTH_HANGUL_LETTER_KIYEOK_SIOS						0xFFA3
#define U_HALFWIDTH_HANGUL_LETTER_NIEUN							0xFFA4
#define U_HALFWIDTH_HANGUL_LETTER_NIEUN_CIEUC						0xFFA5
#define U_HALFWIDTH_HANGUL_LETTER_NIEUN_HIEUH						0xFFA6
#define U_HALFWIDTH_HANGUL_LETTER_TIKEUT						0xFFA7
#define U_HALFWIDTH_HANGUL_LETTER_SSANGTIKEUT						0xFFA8
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL							0xFFA9
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL_KIYEOK						0xFFAA
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL_MIEUM						0xFFAB
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL_PIEUP						0xFFAC
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL_SIOS						0xFFAD
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL_THIEUTH						0xFFAE
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL_PHIEUPH						0xFFAF
#define U_HALFWIDTH_HANGUL_LETTER_RIEUL_HIEUH						0xFFB0
#define U_HALFWIDTH_HANGUL_LETTER_MIEUM							0xFFB1
#define U_HALFWIDTH_HANGUL_LETTER_PIEUP							0xFFB2
#define U_HALFWIDTH_HANGUL_LETTER_SSANGPIEUP						0xFFB3
#define U_HALFWIDTH_HANGUL_LETTER_PIEUP_SIOS						0xFFB4
#define U_HALFWIDTH_HANGUL_LETTER_SIOS							0xFFB5
#define U_HALFWIDTH_HANGUL_LETTER_SSANGSIOS						0xFFB6
#define U_HALFWIDTH_HANGUL_LETTER_IEUNG							0xFFB7
#define U_HALFWIDTH_HANGUL_LETTER_CIEUC							0xFFB8
#define U_HALFWIDTH_HANGUL_LETTER_SSANGCIEUC						0xFFB9
#define U_HALFWIDTH_HANGUL_LETTER_CHIEUCH						0xFFBA
#define U_HALFWIDTH_HANGUL_LETTER_KHIEUKH						0xFFBB
#define U_HALFWIDTH_HANGUL_LETTER_THIEUTH						0xFFBC
#define U_HALFWIDTH_HANGUL_LETTER_PHIEUPH						0xFFBD
#define U_HALFWIDTH_HANGUL_LETTER_HIEUH							0xFFBE
#define U_HALFWIDTH_HANGUL_LETTER_A							0xFFC2
#define U_HALFWIDTH_HANGUL_LETTER_AE							0xFFC3
#define U_HALFWIDTH_HANGUL_LETTER_YA							0xFFC4
#define U_HALFWIDTH_HANGUL_LETTER_YAE							0xFFC5
#define U_HALFWIDTH_HANGUL_LETTER_EO							0xFFC6
#define U_HALFWIDTH_HANGUL_LETTER_E							0xFFC7
#define U_HALFWIDTH_HANGUL_LETTER_YEO							0xFFCA
#define U_HALFWIDTH_HANGUL_LETTER_YE							0xFFCB
#define U_HALFWIDTH_HANGUL_LETTER_O							0xFFCC
#define U_HALFWIDTH_HANGUL_LETTER_WA							0xFFCD
#define U_HALFWIDTH_HANGUL_LETTER_WAE							0xFFCE
#define U_HALFWIDTH_HANGUL_LETTER_OE							0xFFCF
#define U_HALFWIDTH_HANGUL_LETTER_YO							0xFFD2
#define U_HALFWIDTH_HANGUL_LETTER_U							0xFFD3
#define U_HALFWIDTH_HANGUL_LETTER_WEO							0xFFD4
#define U_HALFWIDTH_HANGUL_LETTER_WE							0xFFD5
#define U_HALFWIDTH_HANGUL_LETTER_WI							0xFFD6
#define U_HALFWIDTH_HANGUL_LETTER_YU							0xFFD7
#define U_HALFWIDTH_HANGUL_LETTER_EU							0xFFDA
#define U_HALFWIDTH_HANGUL_LETTER_YI							0xFFDB
#define U_HALFWIDTH_HANGUL_LETTER_I							0xFFDC
#define U_FULLWIDTH_CENT_SIGN								0xFFE0
#define U_FULLWIDTH_POUND_SIGN								0xFFE1
#define U_FULLWIDTH_NOT_SIGN								0xFFE2
#define U_FULLWIDTH_MACRON								0xFFE3
#define U_FULLWIDTH_BROKEN_BAR								0xFFE4
#define U_FULLWIDTH_YEN_SIGN								0xFFE5
#define U_FULLWIDTH_WON_SIGN								0xFFE6
#define U_HALFWIDTH_FORMS_LIGHT_VERTICAL						0xFFE8
#define U_HALFWIDTH_LEFTWARDS_ARROW							0xFFE9
#define U_HALFWIDTH_UPWARDS_ARROW							0xFFEA
#define U_HALFWIDTH_RIGHTWARDS_ARROW							0xFFEB
#define U_HALFWIDTH_DOWNWARDS_ARROW							0xFFEC
#define U_HALFWIDTH_BLACK_SQUARE							0xFFED
#define U_HALFWIDTH_WHITE_CIRCLE							0xFFEE
#define U_OBJECT_REPLACEMENT_CHARACTER							0xFFFC
#define U_REPLACEMENT_CHARACTER								0xFFFD

#endif /* DOSEMU_UNICODE_SYMBOLS_H */
