/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.PrintWriter;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.HitData;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.WeaponType;
import megamek.common.preference.PreferenceManager;

public class QuadMech
extends Mech {
    private static final long serialVersionUID = 7183093787457804717L;
    public static final String[] LOCATION_NAMES = new String[]{"Head", "Center Torso", "Right Torso", "Left Torso", "Front Right Leg", "Front Left Leg", "Rear Right Leg", "Rear Left Leg"};
    public static final String[] LOCATION_ABBRS = new String[]{"HD", "CT", "RT", "LT", "FRL", "FLL", "RRL", "RLL"};
    private static final int[] NUM_OF_SLOTS = new int[]{6, 12, 12, 12, 6, 6, 6, 6};

    public QuadMech(String string, String string2) {
        this(Mech.getGyroTypeForString(string), Mech.getCockpitTypeForString(string2));
    }

    public QuadMech() {
        this(0, 0);
    }

    public QuadMech(int n, int n2) {
        super(n, n2);
        this.movementMode = 2;
        this.setCritical(4, 0, new CriticalSlot(0, 11));
        this.setCritical(4, 1, new CriticalSlot(0, 12));
        this.setCritical(4, 2, new CriticalSlot(0, 13));
        this.setCritical(4, 3, new CriticalSlot(0, 14));
        this.setCritical(5, 0, new CriticalSlot(0, 11));
        this.setCritical(5, 1, new CriticalSlot(0, 12));
        this.setCritical(5, 2, new CriticalSlot(0, 13));
        this.setCritical(5, 3, new CriticalSlot(0, 14));
    }

    public boolean cannotStandUpFromHullDown() {
        int n = 0;
        if (this.isLocationBad(5)) {
            ++n;
        }
        if (this.isLocationBad(4)) {
            ++n;
        }
        if (this.isLocationBad(7)) {
            ++n;
        }
        if (this.isLocationBad(6)) {
            ++n;
        }
        return n >= 3;
    }

    public int getWalkMP(boolean bl, boolean bl2) {
        int n;
        int n2 = this.getOriginalWalkMP();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.locations(); ++n) {
            if (!this.locationIsLeg(n)) continue;
            if (!this.isLocationBad(n)) {
                if (this.legHasHipCrit(n)) {
                    ++n4;
                    if (this.game == null || !this.game.getOptions().booleanOption("tacops_leg_damage")) continue;
                }
                n5 += this.countLegActuatorCrits(n);
                continue;
            }
            ++n3;
        }
        if (n3 > 0) {
            n2 = n3 == 1 ? --n2 : (n3 == 2 ? 1 : 0);
        }
        if (n2 > 0) {
            if (n4 > 0) {
                if (this.game != null && this.game.getOptions().booleanOption("tacops_leg_damage")) {
                    n2 -= 2 * n4;
                } else {
                    for (n = 0; n < n4; ++n) {
                        n2 = (int)Math.ceil((double)n2 / 2.0);
                    }
                }
            }
            n2 -= n5;
        }
        if (this.hasModularArmor()) {
            --n2;
        }
        if (!bl2) {
            n2 = this.game != null && this.game.getOptions().booleanOption("tacops_heat") ? (this.heat < 30 ? (n2 -= this.heat / 5) : (this.heat >= 49 ? (n2 -= 9) : (this.heat >= 43 ? (n2 -= 8) : (this.heat >= 37 ? (n2 -= 7) : (this.heat >= 31 ? (n2 -= 6) : (n2 -= 5)))))) : (n2 -= this.heat / 5);
            if (this.heat >= 9 && this.hasTSM()) {
                n2 += 2;
            }
        }
        if (null != this.game && (n = this.game.getPlanetaryConditions().getMovementMods(this)) != 0) {
            n2 = Math.max(n2 + n, 0);
        }
        if (bl) {
            n2 = this.applyGravityEffectsOnMP(n2);
        }
        n2 = Math.max(0, n2);
        return n2;
    }

    public int getRunMP(boolean bl, boolean bl2) {
        if (this.countBadLegs() <= 1) {
            return super.getRunMP(bl, bl2);
        }
        return this.getWalkMP(bl, bl2);
    }

    public int getRunMPwithoutMASC(boolean bl, boolean bl2) {
        if (this.countBadLegs() <= 1) {
            return super.getRunMPwithoutMASC(bl, bl2);
        }
        return this.getWalkMP(bl, bl2);
    }

    public boolean canChangeSecondaryFacing() {
        return false;
    }

    public boolean locationIsLeg(int n) {
        return n == 6 || n == 7 || n == 4 || n == 5;
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.getType() instanceof WeaponType && mounted.getType().hasFlag(0x1000000000L)) {
            return 0;
        }
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n5, 4);
        this.initializeInternal(n5, 5);
        this.initializeInternal(n5, 6);
        this.initializeInternal(n5, 7);
    }

    public boolean needsRollToStand() {
        return this.countBadLegs() != 0;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int[] nArray = new int[4];
        int n = 0;
        nArray = new int[]{6, 7, 4, 5};
        n = this.countBadLegs();
        if (n == 0) {
            pilotingRollData.addModifier(-2, "Quad bonus");
        }
        if (this.hasFunctionalLegAES()) {
            pilotingRollData.addModifier(-2, "AES bonus");
        }
        boolean bl = false;
        for (int n2 : nArray) {
            if (this.isLocationBad(n2)) {
                if (n != 2 || bl) continue;
                pilotingRollData.addModifier(5, "2 legs destroyed");
                bl = true;
                continue;
            }
            if (this.getBadCriticals(0, 11, n2) > 0) {
                pilotingRollData.addModifier(2, this.getLocationName(n2) + " Hip Actuator destroyed");
                if (!this.game.getOptions().booleanOption("tacops_leg_damage")) continue;
            }
            if (this.getBadCriticals(0, 12, n2) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n2) + " Upper Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 13, n2) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n2) + " Lower Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 14, n2) <= 0) continue;
            pilotingRollData.addModifier(1, this.getLocationName(n2) + " Foot Actuator destroyed");
        }
        return super.addEntityBonuses(pilotingRollData);
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    protected String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public static int restrictScore(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }

    protected double getArmActuatorCost() {
        return 0.0;
    }

    protected double getLegActuatorCost() {
        return this.weight * 150.0f * 4.0f + this.weight * 80.0f * 4.0f + this.weight * 120.0f * 4.0f;
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        Object object;
        int n5 = -1;
        if (n3 != -1 && n4 != 0 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            return new HitData(n3, n2 == 1, true);
        }
        if (this.game.getOptions().booleanOption("tacops_advanced_mech_hit_locations") && (n == 0 || n == 6)) {
            n5 = Compute.d6(2);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, false));
                            return object;
                        }
                        return this.tac(n, n2, 1, false);
                    }
                    case 3: {
                        return new HitData(7);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(3);
                    }
                    case 7: {
                        return new HitData(1);
                    }
                    case 8: {
                        return new HitData(2);
                    }
                    case 9: 
                    case 10: {
                        return new HitData(4);
                    }
                    case 11: {
                        return new HitData(6);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 0, false));
                            return object;
                        }
                        return this.tac(n, n2, 0, false);
                    }
                }
            } else if (n2 == 1) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, true));
                            return object;
                        }
                        return this.tac(n, n2, 1, true);
                    }
                    case 3: {
                        return new HitData(5, true);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(7, true);
                    }
                    case 6: {
                        return new HitData(3, true);
                    }
                    case 7: {
                        return new HitData(1, true);
                    }
                    case 8: {
                        return new HitData(2, true);
                    }
                    case 9: 
                    case 10: {
                        return new HitData(6, true);
                    }
                    case 11: {
                        return new HitData(4, true);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 0, true));
                            return object;
                        }
                        return this.tac(n, n2, 0, true);
                    }
                }
            } else if (n2 == 2) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 3, false));
                            return object;
                        }
                        return this.tac(n, n2, 3, false);
                    }
                    case 3: {
                        return new HitData(4);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(2);
                    }
                    case 7: {
                        return new HitData(3);
                    }
                    case 8: {
                        return new HitData(1);
                    }
                    case 9: 
                    case 10: {
                        return new HitData(7);
                    }
                    case 11: {
                        return new HitData(6);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 0, false));
                            return object;
                        }
                        return this.tac(n, n2, 0, false);
                    }
                }
            } else if (n2 == 3) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 2, false));
                            return object;
                        }
                        return this.tac(n, n2, 2, false);
                    }
                    case 3: {
                        return new HitData(5);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(1);
                    }
                    case 7: {
                        return new HitData(2);
                    }
                    case 8: {
                        return new HitData(3);
                    }
                    case 9: 
                    case 10: {
                        return new HitData(6);
                    }
                    case 11: {
                        return new HitData(7);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 0, false));
                            return object;
                        }
                        return this.tac(n, n2, 0, false);
                    }
                }
            }
        }
        if (n == 1) {
            n5 = Compute.d6();
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 1: {
                        return new HitData(5);
                    }
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(2);
                    }
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0, true);
                    }
                }
            } else if (n2 == 1) {
                switch (n5) {
                    case 1: {
                        return new HitData(7, true);
                    }
                    case 2: {
                        return new HitData(3, true);
                    }
                    case 3: {
                        return new HitData(1, true);
                    }
                    case 4: {
                        return new HitData(2, true);
                    }
                    case 5: {
                        return new HitData(6, true);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0, true);
                    }
                }
            } else if (n2 == 2) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(5);
                    }
                    case 5: {
                        return new HitData(7);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            } else if (n2 == 3) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(2);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(4);
                    }
                    case 5: {
                        return new HitData(6);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
        } else if (n == 2) {
            boolean bl;
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            boolean bl2 = bl = n5 <= 3;
            if (n2 == 0) {
                if (bl) {
                    return new HitData(5);
                }
                return new HitData(4);
            }
            if (n2 == 1) {
                if (bl) {
                    return new HitData(7);
                }
                return new HitData(6);
            }
            if (n2 == 2) {
                if (bl) {
                    return new HitData(7);
                }
                return new HitData(5);
            }
            if (n2 == 3) {
                if (bl) {
                    return new HitData(4);
                }
                return new HitData(6);
            }
        } else if (n == 3 || n == 7) {
            Object object2;
            int n6 = n == 7 ? 0 : 1;
            n5 = Compute.d6(2);
            try {
                object2 = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object2 != null) {
                    ((PrintWriter)object2).print(n);
                    ((PrintWriter)object2).print("\t");
                    ((PrintWriter)object2).print(n2);
                    ((PrintWriter)object2).print("\t");
                    ((PrintWriter)object2).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 2: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object2 = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object2).setUndoneLocation(new HitData(0, false, n6));
                        return object2;
                    }
                    return new HitData(0, false, n6);
                }
                case 3: {
                    return new HitData(2, false, n6);
                }
                case 4: {
                    return new HitData(1, true, n6);
                }
                case 5: {
                    return new HitData(2, true, n6);
                }
                case 6: {
                    return new HitData(2, false, n6);
                }
                case 7: {
                    return new HitData(1, false, n6);
                }
                case 8: {
                    return new HitData(3, false, n6);
                }
                case 9: {
                    return new HitData(3, true, n6);
                }
                case 10: {
                    return new HitData(1, true, n6);
                }
                case 11: {
                    return new HitData(3, false, n6);
                }
                case 12: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object2 = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object2).setUndoneLocation(new HitData(0, false, n6));
                        return object2;
                    }
                    return new HitData(0, false, n6);
                }
            }
        }
        return super.rollHitLocation(n, n2, n3, n4);
    }

    public boolean removePartialCoverHits(int n, int n2, int n3) {
        if ((n2 & 0xC) == 12 && (n == 1 || n == 0)) {
            return true;
        }
        if (n3 == 0) {
            if ((n2 & 2) != 0 && (n == 5 || n == 7)) {
                return true;
            }
            if ((n2 & 1) != 0 && (n == 4 || n == 6)) {
                return true;
            }
            if ((n2 & 8) != 0 && n == 3) {
                return true;
            }
            if ((n2 & 4) != 0 && n == 2) {
                return true;
            }
        } else {
            if ((n2 & 1) != 0 && (n == 5 || n == 7)) {
                return true;
            }
            if ((n2 & 2) != 0 && (n == 4 || n == 6)) {
                return true;
            }
            if ((n2 & 4) != 0 && n == 3) {
                return true;
            }
            if ((n2 & 8) != 0 && n == 2) {
                return true;
            }
        }
        return false;
    }

    public boolean hasFunctionalLegAES() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getLocation() != 7 && mounted.getLocation() != 6 && mounted.getLocation() != 5 && mounted.getLocation() != 4) continue;
            if (((MiscType)mounted.getType()).hasFlag(0x40000000000L) && !mounted.isDestroyed() && !mounted.isBreached() && !mounted.isMissing()) {
                if (mounted.getLocation() == 7) {
                    bl4 = true;
                    continue;
                }
                if (mounted.getLocation() == 6) {
                    bl3 = true;
                    continue;
                }
                if (mounted.getLocation() == 4) {
                    bl = true;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (!((MiscType)mounted.getType()).hasFlag(0x40000000000L)) continue;
            return false;
        }
        return bl2 && bl && bl3 && bl4;
    }

    public boolean canGoHullDown() {
        if (this.game.getOptions().booleanOption("tacops_hull_down")) {
            int[] nArray = new int[]{4, 5, 7, 6};
            int n = 0;
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (!this.isLocationBad(nArray[i]) && !this.isLocationDoomed(nArray[i])) continue;
                ++n;
            }
            return n < 2;
        }
        return false;
    }

    public boolean isArm(int n) {
        return false;
    }
}

