/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.charabia.jsmoothgen.application.ExeCompiler;

public class CompilationDialog
extends JDialog
implements ExeCompiler.StepListener {
    private ExeCompiler m_compiler;
    private boolean m_result = false;
    private boolean m_canceled = false;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton m_cancelbutton;
    private JProgressBar m_progress;
    private JTextArea m_state;

    public CompilationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.m_progress = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.m_state = new JTextArea(10, 60);
        this.m_state.setLineWrap(true);
        this.m_cancelbutton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CompilationDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Progress");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        this.getContentPane().add((Component)this.m_progress, gridBagConstraints);
        this.m_state.setEditable(false);
        this.jScrollPane1.setViewportView(this.m_state);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.m_cancelbutton.setText("Cancel");
        this.m_cancelbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompilationDialog.this.cancelbuttonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)this.m_cancelbutton, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 319) / 2, (screenSize.height - 158) / 2, 319, 158);
    }

    private void cancelbuttonActionPerformed(ActionEvent evt) {
        this.m_result = false;
        this.m_canceled = true;
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void setCompiler(ExeCompiler comp) {
        this.m_compiler = comp;
        comp.addListener(this);
        this.m_progress.setMaximum(100);
        this.m_progress.setMinimum(0);
        this.m_state.setText("");
    }

    public void compile(Runnable r) {
        Thread t = new Thread(r);
        t.start();
        this.setModal(true);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new CompilationDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public void complete() {
        if (!this.m_canceled) {
            this.m_result = true;
            this.setNewState(100, "Done");
            this.m_cancelbutton.setText("Done");
            this.m_cancelbutton.grabFocus();
        }
    }

    public void failed() {
        if (!this.m_canceled) {
            this.m_result = false;
            StringBuffer buf = new StringBuffer();
            buf.append("Compilation failed!\n");
            Vector v = this.m_compiler.getErrors();
            for (int i = 0; i < v.size(); ++i) {
                buf.append("\n- ");
                buf.append(v.get(i).toString());
            }
            buf.append("\n");
            this.setNewState(100, buf.toString());
        }
    }

    public void setNewState(int percentComplete, String state) {
        this.m_progress.setValue(percentComplete);
        this.m_state.append(state + "\n");
    }

    public boolean getResult() {
        return this.m_result;
    }
}

