/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.daemon.CompileServiceImpl;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon$WhenMappings;
import org.jetbrains.kotlin.daemon.LogStream;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinCompileDaemon;", "", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "loadVersionFromResource", "", "main", "", "args", "", "([Ljava/lang/String;)V", "daemon"})
public final class KotlinCompileDaemon {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy log$delegate;
    public static final KotlinCompileDaemon INSTANCE;

    /*
     * WARNING - void declaration
     */
    static {
        byte[] byArray;
        String string;
        void logPath;
        String cfg;
        Pair pair;
        String string2;
        KotlinCompileDaemon kotlinCompileDaemon;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinCompileDaemon.class), "log", "getLog()Ljava/util/logging/Logger;"))};
        INSTANCE = kotlinCompileDaemon = new KotlinCompileDaemon();
        String string3 = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss-SSS").format(new Date());
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"SimpleDateFormat(\"yyyy-M\u2026m-ss-SSS\").format(Date())");
        String logTime = string3;
        String string4 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_LOG_PATH_PROPERTY());
        if (string4 != null && (string4 = DaemonParamsKt.trimQuotes(string4)) != null) {
            String it = string2 = string4;
            pair = new Pair((Object)it, (Object)new File(it).isFile());
        } else {
            pair = new Pair((Object)"%t", (Object)false);
        }
        Pair pair2 = pair;
        String string5 = (String)pair2.component1();
        boolean fileIsGiven = (Boolean)pair2.component2();
        string2 = cfg = "handlers = java.util.logging.FileHandler\njava.util.logging.FileHandler.level     = ALL\njava.util.logging.FileHandler.formatter = java.util.logging.SimpleFormatter\njava.util.logging.FileHandler.encoding  = UTF-8\n" + "java.util.logging.FileHandler.limit     = " + (fileIsGiven ? 0 : 0x100000) + '\n' + "java.util.logging.FileHandler.count     = " + (fileIsGiven ? 1 : 3) + '\n' + "java.util.logging.FileHandler.append    = " + fileIsGiven + '\n' + "java.util.logging.FileHandler.pattern   = " + (String)(fileIsGiven ? logPath : (String)logPath + File.separator + DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + '.' + logTime + ".%u%g.log") + '\n' + "java.util.logging.SimpleFormatter.format = %1$tF %1$tT.%1$tL [%3$s] %4$s: %5$s%n\n";
        LogManager logManager = LogManager.getLogManager();
        Charset charset = Charsets.UTF_8;
        String string6 = string = string2;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string6.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        logManager.readConfiguration(byteArrayInputStream);
        log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);
    }

    public final Logger getLog() {
        Lazy lazy = log$delegate;
        KotlinCompileDaemon kotlinCompileDaemon = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Logger)lazy.getValue();
    }

    private final String loadVersionFromResource() {
        Object object;
        ClassLoader classLoader = KotlinCompileDaemon.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            classLoader = null;
        }
        if ((object = (URLClassLoader)classLoader) != null && (object = ((URLClassLoader)object).findResource("META-INF/MANIFEST.MF")) != null) {
            Object object2;
            Object it = object2 = object;
            try {
                String string = new Manifest(((URL)it).openStream()).getMainAttributes().getValue("Implementation-Version");
                if (string == null) {
                    string = null;
                }
                return string;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        NetworkUtilsKt.ensureServerHostnameIsSetUp();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkExpressionValueIsNotNull((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
        List<String> jvmArguments = runtimeMXBean.getInputArguments();
        Logger logger = INSTANCE.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin compiler daemon version ");
        String string = INSTANCE.loadVersionFromResource();
        if (string == null) {
            string = "<unknown>";
        }
        logger.info(stringBuilder.append(string).toString());
        Logger logger2 = INSTANCE.getLog();
        StringBuilder stringBuilder2 = new StringBuilder().append("daemon JVM args: ");
        List<String> list2 = jvmArguments;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"jvmArguments");
        logger2.info(stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).toString());
        INSTANCE.getLog().info("daemon args: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        UtilKt.setIdeaIoUseFallback();
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null);
        try {
            void registry;
            String[] stringArray = new String[]{};
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl3, bl2, bl);
            Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), new OptionsGroup[]{compilerId, daemonOptions}, DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            if (CollectionsKt.any(filteredArgs)) {
                String helpLine = "usage: <daemon> <compilerId options> <daemon options>";
                INSTANCE.getLog().info(helpLine);
                System.out.println((Object)helpLine);
                throw (Throwable)new IllegalArgumentException("Unknown arguments: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            INSTANCE.getLog().info("starting daemon");
            Pair<Registry, Integer> pair = NetworkUtilsKt.findPortAndCreateRegistry(DaemonParamsKt.getCOMPILE_DAEMON_FIND_PORT_ATTEMPTS(), DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_START(), DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_END());
            Registry helpLine = (Registry)pair.component1();
            int port = ((Number)pair.component2()).intValue();
            CompilerSelector compilerSelector2 = new CompilerSelector(){
                static final /* synthetic */ KProperty[] $$delegatedProperties;
                private final Lazy jvm$delegate;
                private final Lazy js$delegate;
                private final Lazy metadata$delegate;

                static {
                    $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(main.compilerSelector.1.class), "jvm", "getJvm()Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(main.compilerSelector.1.class), "js", "getJs()Lorg/jetbrains/kotlin/cli/js/K2JSCompiler;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(main.compilerSelector.1.class), "metadata", "getMetadata()Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler;"))};
                }

                private final K2JVMCompiler getJvm() {
                    Lazy lazy = this.jvm$delegate;
                    main.compilerSelector.1 var2_2 = this;
                    KProperty kProperty = $$delegatedProperties[0];
                    return (K2JVMCompiler)lazy.getValue();
                }

                private final K2JSCompiler getJs() {
                    Lazy lazy = this.js$delegate;
                    main.compilerSelector.1 var2_2 = this;
                    KProperty kProperty = $$delegatedProperties[1];
                    return (K2JSCompiler)lazy.getValue();
                }

                private final K2MetadataCompiler getMetadata() {
                    Lazy lazy = this.metadata$delegate;
                    main.compilerSelector.1 var2_2 = this;
                    KProperty kProperty = $$delegatedProperties[2];
                    return (K2MetadataCompiler)lazy.getValue();
                }

                @NotNull
                public CLICompiler<?> get(@NotNull CompileService.TargetPlatform targetPlatform) {
                    CLICompiler cLICompiler;
                    Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
                    switch (KotlinCompileDaemon$WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
                        case 1: {
                            cLICompiler = this.getJvm();
                            break;
                        }
                        case 2: {
                            cLICompiler = this.getJs();
                            break;
                        }
                        case 3: {
                            cLICompiler = this.getMetadata();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return cLICompiler;
                }
                {
                    this.jvm$delegate = LazyKt.lazy((Function0)main.compilerSelector.jvm.2.INSTANCE);
                    this.js$delegate = LazyKt.lazy((Function0)main.compilerSelector.js.2.INSTANCE);
                    this.metadata$delegate = LazyKt.lazy((Function0)main.compilerSelector.metadata.2.INSTANCE);
                }
            };
            Timer timer = new Timer(true);
            CompileServiceImpl compilerService2 = new CompileServiceImpl((Registry)registry, compilerSelector2, compilerId, daemonOptions, daemonJVMOptions, port, timer, (Function0<Unit>)((Function0)new Function0<Unit>(daemonOptions, timer){
                final /* synthetic */ DaemonOptions $daemonOptions;
                final /* synthetic */ Timer $timer;

                public final void invoke() {
                    if (this.$daemonOptions.getForceShutdownTimeoutMilliseconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_MS()) {
                        Timer timer = this.$timer;
                        long l = this.$daemonOptions.getForceShutdownTimeoutMilliseconds();
                        TimerTask timerTask = new TimerTask(){

                            public void run() {
                                TimerTask $receiver = this;
                                $receiver.cancel();
                                KotlinCompileDaemon.INSTANCE.getLog().info("force JVM shutdown");
                                System.exit(0);
                            }
                        };
                        timer.schedule(timerTask, l);
                    } else {
                        this.$timer.cancel();
                    }
                }
                {
                    this.$daemonOptions = daemonOptions;
                    this.$timer = timer;
                    super(0);
                }
            }));
            String string2 = DaemonParamsKt.getCOMPILE_DAEMON_IS_READY_MESSAGE();
            System.out.println((Object)string2);
            INSTANCE.getLog().info("daemon is listening on port: " + port);
            System.out.close();
            System.err.close();
            System.setErr(new PrintStream(new LogStream("stderr")));
            System.setOut(new PrintStream(new LogStream("stdout")));
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            e.printStackTrace(System.err);
            INSTANCE.getLog().log(Level.INFO, "Exception: ", e);
            throw (Throwable)e;
        }
    }

    private KotlinCompileDaemon() {
    }
}

