/************* COPYRIGHT AND CONFIDENTIALITY INFORMATION ********************
**                                                                         **
** Copyright (c) 2010 technicolor                                          **
** All Rights Reserved                                                     **
**                                                                         **
** This program contains proprietary information which is a trade          **
** secret of technicolor and/or its affiliates and also is protected as    **
** an unpublished work under applicable Copyright laws. Recipient is       **
** to retain this program in confidence and is not permitted to use or     **
** make copies thereof other than as permitted in a written agreement      **
** with technicolor, UNLESS OTHERWISE EXPRESSLY ALLOWED BY APPLICABLE LAWS.**
**                                                                         **
****************************************************************************/

/** \file
 * Multimedia switch connection types.
 *
 * \version v1.0
 *
 *************************************************************************/
#ifndef  MMCONN_TYPES_INC
#define  MMCONN_TYPES_INC

/*########################################################################
#                                                                       #
#  HEADER (INCLUDE) SECTION                                             #
#                                                                       #
########################################################################*/

/*########################################################################
#                                                                       #
#  MACROS/DEFINES                                                       #
#                                                                       #
########################################################################*/


/*########################################################################
#                                                                       #
#  TYPES                                                                #
#                                                                       #
########################################################################*/

/**
 * Handle that represents a multimedia switch connection instance.
 *
 * All communication with a multimedia switch connection will happen using this handle.
 *
 * \since v1.0
 */
typedef struct MmConn            *MmConnHndl;

/**
 * Handle that represents a multimedia switch kernel connection instance.
 *
 * All communication with a multimedia switch kernel connection instance will happen using this handle.
 *
 * \since v1.0
 */
typedef struct MmConnKrnl        *MmConnKrnlHndl;

/**
 * Handle that represents a multicast connection instance.
 *
 * All communication with a multicast connection instance will happen using this handle.
 *
 * \since v1.0
 */
typedef struct MmConnMulticast   *MmConnMulticastHndl;

/**
 * Handle that represents a multimedia switch kernel connection instance.
 *
 * All communication with a multimedia switch kernel connection instance will happen using this handle.
 *
 * \since v1.0
 */
typedef struct MmConnTone        *MmConnToneHndl;

/**
 * Handle that represents a multimedia switch relay connection instance.
 *
 * All communication with a multimedia switch relay connection instance will happen using this handle.
 *
 * \since v1.0
 */
typedef struct MmConnRelay       *MmConnRelayHndl;

/**
 * Handle that represents a multimedia switch rtcp connection instance.
 *
 * All communication with a multimedia switch rtcp connection instance will happen using this handle.
 *
 * \since v1.0
 */
typedef struct MmConnRtcp        *MmConnRtcpHndl;

/**
 * Handle that represents a multimedia switch user connection instance.
 *
 * All communication with a multimedia switch user connection instance will happen using this handle.
 *
 * \since v1.0
 */
typedef struct MmConnUsr         *MmConnUsrHndl;

#endif   /* ----- #ifndef MMCONN_TYPES_INC  ----- */
