/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/        

#ifndef __WAN_H_INCLUDED
#define __WAN_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:55:16   */

#include "access_macros.h"
#include "packing.h"

/*****************************************************************************************/
/* WAN Interface                                                                         */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define WAN_WAN_TOP_WAN_MISC_OFFSET 	( 0x00000000 )
#define WAN_WAN_TOP_WAN_MISC_ADDRESS	( WAN_WAN_TOP_OFFSET + WAN_WAN_TOP_WAN_MISC_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* WAN_CFG                                                                               */
/* Holds configuration registers of the WAN block interface                              */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_R2_RESERVED_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_R2_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_NTR_SYNC_PERIOD_SEL_DATA_VALUE              ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_NTR_SYNC_PERIOD_SEL_DATA_VALUE_RESET_VALUE  ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_R1_RESERVED_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_R1_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_WAN_DEBUG_SEL_DATA_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_WAN_DEBUG_SEL_DATA_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_EPON_DEBUG_SEL_DATA_VALUE                   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_EPON_DEBUG_SEL_DATA_VALUE_RESET_VALUE       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_R0_RESERVED_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_R0_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_OE_DISABLED_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_OE_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_OE_ENABLED_VALUE                      ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_MEM_REB_ASSERT_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_MEM_REB_DEASSERT_VALUE                      ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_MEM_REB_DEASSERT_VALUE_RESET_VALUE          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_INVERT_DONT_INVERT_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_INVERT_DONT_INVERT_VALUE_RESET_VALUE  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_INVERT_INVERT_VALUE                   ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_MODE_DATA_VALUE                       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_LASER_MODE_DATA_VALUE_RESET_VALUE           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_WAN_INTERFACE_SELECT_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_WAN_INTERFACE_SELECT_DATA_VALUE_RESET_VALUE ( 0x0 )


#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_OFFSET ( 0x00000000 )

#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_WAN_CFG_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_WAN_CFG_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_WAN_CFG_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_WAN_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r2                  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ntr_sync_period_sel */
	uint32_t ntr_sync_period_sel 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1                  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* WAN_DEBUG_SEL */
	uint32_t wan_debug_sel       	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EPON_DEBUG_SEL */
	uint32_t epon_debug_sel      	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0                  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* laser_oe */
	uint32_t laser_oe            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MEM_REB */
	uint32_t mem_reb             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* laser_invert */
	uint32_t laser_invert        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* laser_mode */
	uint32_t laser_mode          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* wan_interface_select */
	uint32_t wan_interface_select	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_WAN_CFG ;
#else
typedef struct
{	uint32_t wan_interface_select	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* wan_interface_select */
	uint32_t laser_mode          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* laser_mode */
	uint32_t laser_invert        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* laser_invert */
	uint32_t mem_reb             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MEM_REB */
	uint32_t laser_oe            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* laser_oe */
	uint32_t r0                  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t epon_debug_sel      	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EPON_DEBUG_SEL */
	uint32_t wan_debug_sel       	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* WAN_DEBUG_SEL */
	uint32_t r1                  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ntr_sync_period_sel 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ntr_sync_period_sel */
	uint32_t r2                  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_WAN_CFG ;
#endif

/*****************************************************************************************/
/* SATA_CFG                                                                              */
/* Holds SATA Serdes related Configurations                                              */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_R0_RESERVED_VALUE                                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_R0_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX1_PWRDWN_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX1_PWRDWN_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX1_PWRDWN_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RX1_PWRDWN_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RX1_PWRDWN_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RX1_PWRDWN_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_OOB1_DISABLED_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_OOB1_DISABLED_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_OOB1_ENABLED_VALUE                            ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_R1_RESERVED_VALUE                                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_R1_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_TX1_DISABLED_VALUE                            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_TX1_DISABLED_VALUE_RESET_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_TX1_ENABLED_VALUE                             ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_RX1_DISABLED_VALUE                            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_RX1_DISABLED_VALUE_RESET_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RSTB_RX1_ENABLED_VALUE                             ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_R2_RESERVED_VALUE                                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_R2_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SATA_MD_EN_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SATA_MD_EN_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SATA_MD_EN_ENABLED_VALUE_RESET_VALUE               ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX0_20B_FIFO_ON_DISABLED_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX0_20B_FIFO_ON_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX0_20B_FIFO_ON_ENABLED_VALUE                      ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_TX_ENABLE_DISABLED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_TX_ENABLE_DISABLED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_TX_ENABLE_ENABLED_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_TX_DATA_RATE_GEN0_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_TX_DATA_RATE_GEN2_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_TX_DATA_RATE_GEN2_VALUE_RESET_VALUE         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_TX_DATA_RATE_GEN3_VALUE                     ( 0x2 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_RX_DATA_RATE_GEN0_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_RX_DATA_RATE_GEN2_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_RX_DATA_RATE_GEN2_VALUE_RESET_VALUE         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SAPIS0_RX_DATA_RATE_GEN3_VALUE                     ( 0x2 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SATA_EXT_REF_AVAIL_DISABLED_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SATA_EXT_REF_AVAIL_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SATA_EXT_REF_AVAIL_ENABLED_VALUE                   ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_EXT_PLL_BYPASS_MODE_EN0_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_EXT_PLL_BYPASS_MODE_EN0_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_EXT_PLL_BYPASS_MODE_EN0_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_PARTIAL_MODE_EN0_DISABLED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_PARTIAL_MODE_EN0_DISABLED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_PARTIAL_MODE_EN0_ENABLED_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SLUMBER_MODE_EN0_DISABLED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SLUMBER_MODE_EN0_DISABLED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_SLUMBER_MODE_EN0_ENABLED_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX0_PWRDWN_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX0_PWRDWN_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_TX0_PWRDWN_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RX0_PWRDWN_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RX0_PWRDWN_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RX0_PWRDWN_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_AEQ0_FREEZE_DISABLED_VALUE                         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_AEQ0_FREEZE_DISABLED_VALUE_RESET_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_AEQ0_FREEZE_ENABLED_VALUE                          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_AEQ0_ENABLE_DISABLED_VALUE                         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_AEQ0_ENABLE_DISABLED_VALUE_RESET_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_AEQ0_ENABLE_ENABLED_VALUE                          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_REFOUT_EN_DISABLED_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_REFOUT_EN_DISABLED_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_REFOUT_EN_ENABLED_VALUE                            ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_INT_REF_EN_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_INT_REF_EN_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_INT_REF_EN_ENABLED_VALUE_RESET_VALUE               ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RECALIBRATE_DISABLED_VALUE                         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RECALIBRATE_DISABLED_VALUE_RESET_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_RECALIBRATE_ENABLED_VALUE                          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_COMMA_ADJ_EN0_DISABLED_VALUE                       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_COMMA_ADJ_EN0_DISABLED_VALUE_RESET_VALUE           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_COMMA_ADJ_EN0_ENABLED_VALUE                        ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_OFFSET ( 0x00000004 )

#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_SATA_CFG_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_SATA_CFG_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_SATA_CFG_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_SATA_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0                     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx1_pwrdwn */
	uint32_t tx1_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx1_pwrdwn */
	uint32_t rx1_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rstb_oob1 */
	uint32_t rstb_oob1              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1                     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rstb_tx1 */
	uint32_t rstb_tx1               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rstb_rx1 */
	uint32_t rstb_rx1               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2                     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sata_md_en */
	uint32_t sata_md_en             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx0_20b_fifo_on */
	uint32_t tx0_20b_fifo_on        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_tx_enable */
	uint32_t sapis0_tx_enable       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_tx_data_rate */
	uint32_t sapis0_tx_data_rate    	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_rx_data_rate */
	uint32_t sapis0_rx_data_rate    	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sata_ext_ref_avail */
	uint32_t sata_ext_ref_avail     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ext_pll_bypass */
	uint32_t ext_pll_bypass_mode_en0	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* partial_mode_en0 */
	uint32_t partial_mode_en0       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* slumber_mode_en0 */
	uint32_t slumber_mode_en0       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx0_pwrdwn */
	uint32_t tx0_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx0_pwrdwn */
	uint32_t rx0_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aeq0_freeze */
	uint32_t aeq0_freeze            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aeq0_enable */
	uint32_t aeq0_enable            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* refout_en */
	uint32_t refout_en              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* int_ref_en */
	uint32_t int_ref_en             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* recalibrate */
	uint32_t recalibrate            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* comma_adj_en0 */
	uint32_t comma_adj_en0          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_SATA_CFG ;
#else
typedef struct
{	uint32_t comma_adj_en0          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* comma_adj_en0 */
	uint32_t recalibrate            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* recalibrate */
	uint32_t int_ref_en             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* int_ref_en */
	uint32_t refout_en              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* refout_en */
	uint32_t aeq0_enable            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aeq0_enable */
	uint32_t aeq0_freeze            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aeq0_freeze */
	uint32_t rx0_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx0_pwrdwn */
	uint32_t tx0_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx0_pwrdwn */
	uint32_t slumber_mode_en0       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* slumber_mode_en0 */
	uint32_t partial_mode_en0       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* partial_mode_en0 */
	uint32_t ext_pll_bypass_mode_en0	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ext_pll_bypass */
	uint32_t sata_ext_ref_avail     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sata_ext_ref_avail */
	uint32_t sapis0_rx_data_rate    	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_rx_data_rate */
	uint32_t sapis0_tx_data_rate    	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_tx_data_rate */
	uint32_t sapis0_tx_enable       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_tx_enable */
	uint32_t tx0_20b_fifo_on        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx0_20b_fifo_on */
	uint32_t sata_md_en             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sata_md_en */
	uint32_t r2                     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rstb_rx1               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rstb_rx1 */
	uint32_t rstb_tx1               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rstb_tx1 */
	uint32_t r1                     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rstb_oob1              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rstb_oob1 */
	uint32_t rx1_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx1_pwrdwn */
	uint32_t tx1_pwrdwn             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx1_pwrdwn */
	uint32_t r0                     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_SATA_CFG ;
#endif

/*****************************************************************************************/
/* SATA_STAT                                                                             */
/* This registers holds status indications of the SATA Serdes                            */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_R1_RESERVED_VALUE                                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_R1_RESERVED_VALUE_RESET_VALUE                               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SATA_PLL_LOCK_DISABLED_VALUE                                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SATA_PLL_LOCK_DISABLED_VALUE_RESET_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SATA_PLL_LOCK_ENABLED_VALUE                                 ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_DIG_DISABLED_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_DIG_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_DIG_ENABLED_VALUE                 ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_ANA_DISABLED_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_ANA_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_ANA_ENABLED_VALUE                 ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_ANA_RC_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_ANA_RC_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_SIGNAL_LEVEL_VALID_ANA_RC_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_TXLOCK_CDR_DISABLED_VALUE                            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_TXLOCK_CDR_DISABLED_VALUE_RESET_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_TXLOCK_CDR_ENABLED_VALUE                             ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_RXLOCK_CDR_DISABLED_VALUE                            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_RXLOCK_CDR_DISABLED_VALUE_RESET_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_RXLOCK_CDR_ENABLED_VALUE                             ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_RX_ERROR_DISABLED_VALUE                              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_RX_ERROR_DISABLED_VALUE_RESET_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_RX_ERROR_ENABLED_VALUE                               ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_K28_5_DETECT_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_K28_5_DETECT_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_K28_5_DETECT_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_COMWAKE_DETECT_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_COMWAKE_DETECT_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_COMWAKE_DETECT_ENABLED_VALUE                         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_COMRESET_DETECT_DISABLED_VALUE                       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_COMRESET_DETECT_DISABLED_VALUE_RESET_VALUE           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_SAPIS0_COMRESET_DETECT_ENABLED_VALUE                        ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_OFFSET ( 0x00000008 )

#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_SATA_STAT_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_SATA_STAT_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_SATA_STAT_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_SATA_STAT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1                              	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sata_pll_lock */
	uint32_t sata_pll_lock                   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_signal_level_valid_dig */
	uint32_t sapis0_signal_level_valid_dig   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_signal_level_valid_ana */
	uint32_t sapis0_signal_level_valid_ana   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_signal_level_valid_ana_rc */
	uint32_t sapis0_signal_level_valid_ana_rc	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_txlock_cdr */
	uint32_t sapis0_txlock_cdr               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_rxlock_cdr */
	uint32_t sapis0_rxlock_cdr               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_rx_error */
	uint32_t sapis0_rx_error                 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_k28_5_detect */
	uint32_t sapis0_k28_5_detect             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_comwake_detect */
	uint32_t sapis0_comwake_detect           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_comreset_detect */
	uint32_t sapis0_comreset_detect          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_SATA_STAT ;
#else
typedef struct
{	uint32_t sapis0_comreset_detect          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_comreset_detect */
	uint32_t sapis0_comwake_detect           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_comwake_detect */
	uint32_t sapis0_k28_5_detect             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_k28_5_detect */
	uint32_t sapis0_rx_error                 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_rx_error */
	uint32_t sapis0_rxlock_cdr               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_rxlock_cdr */
	uint32_t sapis0_txlock_cdr               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_txlock_cdr */
	uint32_t sapis0_signal_level_valid_ana_rc	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_signal_level_valid_ana_rc */
	uint32_t sapis0_signal_level_valid_ana   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_signal_level_valid_ana */
	uint32_t sapis0_signal_level_valid_dig   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sapis0_signal_level_valid_dig */
	uint32_t sata_pll_lock                   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sata_pll_lock */
	uint32_t r1                              	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_SATA_STAT ;
#endif

/*****************************************************************************************/
/* PCS_CFG                                                                               */
/* Holds PCS related Configurations                                                      */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_R0_RESERVED_VALUE                                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_R0_RESERVED_VALUE_RESET_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FX100_SERDES_DEF_DISABLED_VALUE                   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FX100_SERDES_DEF_DISABLED_VALUE_RESET_VALUE       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FX100_SERDES_DEF_ENABLED_VALUE                    ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FX100_FULLDPLX_DEF_DISABLED_VALUE                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FX100_FULLDPLX_DEF_DISABLED_VALUE_RESET_VALUE     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FX100_FULLDPLX_DEF_ENABLED_VALUE                  ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_AUTODET_FX100_DEF_DISABLED_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_AUTODET_FX100_DEF_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_AUTODET_FX100_DEF_ENABLED_VALUE                   ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIBER_AUTOPWRDN_DEF_DISABLED_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIBER_AUTOPWRDN_DEF_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIBER_AUTOPWRDN_DEF_ENABLED_VALUE                 ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_DISABLE_TX_CRS_DEF_DISABLED_VALUE                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_DISABLE_TX_CRS_DEF_DISABLED_VALUE_RESET_VALUE     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_DISABLE_TX_CRS_DEF_ENABLED_VALUE                  ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_INVERT_SD_DEF_DISABLED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_INVERT_SD_DEF_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_INVERT_SD_DEF_ENABLED_VALUE                       ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_SD_ENABLE_DEF_DISABLED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_SD_ENABLE_DEF_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_SD_ENABLE_DEF_ENABLED_VALUE                       ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_INVERT_EXT_PHY_CRS_DEF_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_INVERT_EXT_PHY_CRS_DEF_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_INVERT_EXT_PHY_CRS_DEF_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_EXT_PHY_CRS_DEF_DISABLED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_EXT_PHY_CRS_DEF_DISABLED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_EXT_PHY_CRS_DEF_ENABLED_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_PARALLEL_DETECT_DEF_DISABLED_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_PARALLEL_DETECT_DEF_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_PARALLEL_DETECT_DEF_ENABLED_VALUE                 ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_AUTODET_DEF_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_AUTODET_DEF_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_AUTODET_DEF_ENABLED_VALUE                         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIFO_ELASTICITY_DEF_DISABLED_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIFO_ELASTICITY_DEF_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIFO_ELASTICITY_DEF_ENABLED_VALUE                 ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FREQLOCK_TX_DEF_DISABLED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FREQLOCK_TX_DEF_DISABLED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FREQLOCK_TX_DEF_ENABLED_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_CLK125_DISABLE_DEF_DISABLED_VALUE                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_CLK125_DISABLE_DEF_DISABLED_VALUE_RESET_VALUE     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_CLK125_DISABLE_DEF_ENABLED_VALUE                  ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIBER_DEF_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIBER_DEF_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_FIBER_DEF_ENABLED_VALUE                           ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_TBI_DEF_DISABLED_VALUE                            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_TBI_DEF_DISABLED_VALUE_RESET_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_TBI_DEF_ENABLED_VALUE                             ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADV_FDX_DEF_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADV_FDX_DEF_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADV_FDX_DEF_ENABLED_VALUE                         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADV_HDX_DEF_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADV_HDX_DEF_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADV_HDX_DEF_ENABLED_VALUE                         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_PAUSE_DEF_DISABLED_VALUE                          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_PAUSE_DEF_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_PAUSE_DEF_ENABLED_VALUE                           ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_OFFSET ( 0x0000000C )

#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_PCS_CFG_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_PCS_CFG_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_PCS_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0                    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fx100_serdes_def */
	uint32_t fx100_serdes_def      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fx100_fulldplx_def */
	uint32_t fx100_fulldplx_def    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* autodet_fx100_def */
	uint32_t autodet_fx100_def     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_autopwrdn_def */
	uint32_t fiber_autopwrdn_def   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* disable_tx_crs_def */
	uint32_t disable_tx_crs_def    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* invert_sd_def */
	uint32_t invert_sd_def         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sd_enable_def */
	uint32_t sd_enable_def         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* invert_ext_phy_crs_def */
	uint32_t invert_ext_phy_crs_def	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ext_phy_crs_def */
	uint32_t ext_phy_crs_def       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* parallel_detect_def */
	uint32_t parallel_detect_def   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* autodet_def */
	uint32_t autodet_def           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fifo_elasticity_def */
	uint32_t fifo_elasticity_def   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* freqlock_tx_def */
	uint32_t freqlock_tx_def       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* clk125_disable_def */
	uint32_t clk125_disable_def    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_def */
	uint32_t fiber_def             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tbi_def */
	uint32_t tbi_def               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* adv_fdx_def */
	uint32_t adv_fdx_def           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* adv_hdx_def */
	uint32_t adv_hdx_def           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_def */
	uint32_t pause_def             	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_PCS_CFG ;
#else
typedef struct
{	uint32_t pause_def             	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_def */
	uint32_t adv_hdx_def           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* adv_hdx_def */
	uint32_t adv_fdx_def           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* adv_fdx_def */
	uint32_t tbi_def               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tbi_def */
	uint32_t fiber_def             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_def */
	uint32_t clk125_disable_def    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* clk125_disable_def */
	uint32_t freqlock_tx_def       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* freqlock_tx_def */
	uint32_t fifo_elasticity_def   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fifo_elasticity_def */
	uint32_t autodet_def           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* autodet_def */
	uint32_t parallel_detect_def   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* parallel_detect_def */
	uint32_t ext_phy_crs_def       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ext_phy_crs_def */
	uint32_t invert_ext_phy_crs_def	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* invert_ext_phy_crs_def */
	uint32_t sd_enable_def         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sd_enable_def */
	uint32_t invert_sd_def         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* invert_sd_def */
	uint32_t disable_tx_crs_def    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* disable_tx_crs_def */
	uint32_t fiber_autopwrdn_def   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_autopwrdn_def */
	uint32_t autodet_fx100_def     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* autodet_fx100_def */
	uint32_t fx100_fulldplx_def    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fx100_fulldplx_def */
	uint32_t fx100_serdes_def      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fx100_serdes_def */
	uint32_t r0                    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_PCS_CFG ;
#endif

/*****************************************************************************************/
/* PCS_STAT                                                                              */
/* This registers holds status indications of the PCS                                    */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_MR_LP_ADV_ABILITY_DATA_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_MR_LP_ADV_ABILITY_DATA_VALUE_RESET_VALUE    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_R1_RESERVED_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_R1_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_MR_PAGE_RX_DISABLED_VALUE                   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_MR_PAGE_RX_DISABLED_VALUE_RESET_VALUE       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_MR_PAGE_RX_ENABLED_VALUE                    ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FIBER_TXACT_DISABLED_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FIBER_TXACT_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FIBER_TXACT_ENABLED_VALUE                   ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FIBER_RXACT_DISABLED_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FIBER_RXACT_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FIBER_RXACT_ENABLED_VALUE                   ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_AUTONEG_COMPLETE_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_AUTONEG_COMPLETE_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_AUTONEG_COMPLETE_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FX100_MODE_DISABLED_VALUE                   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FX100_MODE_DISABLED_VALUE_RESET_VALUE       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_FX100_MODE_ENABLED_VALUE                    ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SGMII_MODE_DISABLED_VALUE                   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SGMII_MODE_ENABLED_VALUE                    ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SGMII_MODE_ENABLED_VALUE_RESET_VALUE        ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SPEED_1000_DISABLED_VALUE                   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SPEED_1000_ENABLED_VALUE                    ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SPEED_1000_ENABLED_VALUE_RESET_VALUE        ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SPEED_100_DISABLED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SPEED_100_DISABLED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_SPEED_100_ENABLED_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_DUPLEX_STATUS_DISABLED_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_DUPLEX_STATUS_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_DUPLEX_STATUS_ENABLED_VALUE                 ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_LINK_STATUS_DISABLED_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_LINK_STATUS_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_LINK_STATUS_ENABLED_VALUE                   ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_PAUSE_TX_DISABLED_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_PAUSE_TX_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_PAUSE_TX_ENABLED_VALUE                      ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_PAUSE_RX_DISABLED_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_PAUSE_RX_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_PAUSE_RX_ENABLED_VALUE                      ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_OFFSET ( 0x00000010 )

#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_PCS_STAT_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_PCS_STAT_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_PCS_STAT_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_PCS_STAT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* mr_lp_adv_ability */
	uint32_t mr_lp_adv_ability	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1               	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mr_page_rx */
	uint32_t mr_page_rx       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_txact */
	uint32_t fiber_txact      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_rxact */
	uint32_t fiber_rxact      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* autoneg_complete */
	uint32_t autoneg_complete 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fx100_mode */
	uint32_t fx100_mode       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sgmii_mode */
	uint32_t sgmii_mode       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* speed_1000 */
	uint32_t speed_1000       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* speed_100 */
	uint32_t speed_100        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* duplex_status */
	uint32_t duplex_status    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* link_status */
	uint32_t link_status      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_tx */
	uint32_t pause_tx         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_rx */
	uint32_t pause_rx         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_PCS_STAT ;
#else
typedef struct
{	uint32_t pause_rx         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_rx */
	uint32_t pause_tx         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_tx */
	uint32_t link_status      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* link_status */
	uint32_t duplex_status    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* duplex_status */
	uint32_t speed_100        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* speed_100 */
	uint32_t speed_1000       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* speed_1000 */
	uint32_t sgmii_mode       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sgmii_mode */
	uint32_t fx100_mode       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fx100_mode */
	uint32_t autoneg_complete 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* autoneg_complete */
	uint32_t fiber_rxact      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_rxact */
	uint32_t fiber_txact      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fiber_txact */
	uint32_t mr_page_rx       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mr_page_rx */
	uint32_t r1               	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t mr_lp_adv_ability	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mr_lp_adv_ability */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_PCS_STAT ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_SW_RESET                                                                 */
/* GPON Gearbox Soft Reset Register                                                      */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_R0_RESERVED_VALUE                       ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_R0_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXPG_RESET_DISABLED_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXPG_RESET_DISABLED_VALUE_RESET_VALUE   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXPG_RESET_ENABLED_VALUE                ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXBEN_RESET_DISABLED_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXBEN_RESET_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXBEN_RESET_ENABLED_VALUE               ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXFIFO_RESET_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXFIFO_RESET_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_TXFIFO_RESET_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_RXFIFO_RESET_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_RXFIFO_RESET_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_RXFIFO_RESET_ENABLED_VALUE              ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_OFFSET ( 0x00000014 )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0          	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXPG_RESET */
	uint32_t txpg_reset  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXBEN_RESET */
	uint32_t txben_reset 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXFIFO_RESET */
	uint32_t txfifo_reset	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RXFIFO_RESET */
	uint32_t rxfifo_reset	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET ;
#else
typedef struct
{	uint32_t rxfifo_reset	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RXFIFO_RESET */
	uint32_t txfifo_reset	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXFIFO_RESET */
	uint32_t txben_reset 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXBEN_RESET */
	uint32_t txpg_reset  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXPG_RESET */
	uint32_t r0          	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_FIFO_CFG_0                                                               */
/* GPON Gearbox FIFO Configuration Register 0                                            */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_R0_RESERVED_VALUE                                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_R0_RESERVED_VALUE_RESET_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_TXFIFO_DRIFTED_DISABLED_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_TXFIFO_DRIFTED_DISABLED_VALUE_RESET_VALUE   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_TXFIFO_DRIFTED_ENABLED_VALUE                ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_POINTER_DISTANCE_MAX_DATA_VALUE                ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_POINTER_DISTANCE_MAX_DATA_VALUE_RESET_VALUE    ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_POINTER_DISTANCE_MIN_DATA_VALUE                ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_POINTER_DISTANCE_MIN_DATA_VALUE_RESET_VALUE    ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_LOOPBACK_RX_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_LOOPBACK_RX_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_LOOPBACK_RX_ENABLED_VALUE                         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_TXFIFO_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_TXFIFO_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_TXFIFO_COLLISION_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_WR_PTR_ADV_DISABLED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_WR_PTR_ADV_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_WR_PTR_ADV_ENABLED_VALUE                       ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_WR_PTR_DLY_DISABLED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_WR_PTR_DLY_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_WR_PTR_DLY_ENABLED_VALUE                       ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_BIT_INV_DISABLED_VALUE                         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_BIT_INV_DISABLED_VALUE_RESET_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_BIT_INV_ENABLED_VALUE                          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_20BIT_ORDER_DISABLED_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_20BIT_ORDER_ENABLED_VALUE                      ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_20BIT_ORDER_ENABLED_VALUE_RESET_VALUE          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_8BIT_ORDER_DISABLED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_8BIT_ORDER_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_8BIT_ORDER_ENABLED_VALUE                       ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_GEN2_DISABLED_VALUE                            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_GEN2_DISABLED_VALUE_RESET_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_TX_GEN2_ENABLED_VALUE                             ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_R1_RESERVED_VALUE                                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_R1_RESERVED_VALUE_RESET_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_RXFIFO_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_RXFIFO_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_CLEAR_RXFIFO_COLLISION_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_RD_PTR_ADV_DISABLED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_RD_PTR_ADV_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_RD_PTR_ADV_ENABLED_VALUE                       ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_RD_PTR_DLY_DISABLED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_RD_PTR_DLY_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_RD_PTR_DLY_ENABLED_VALUE                       ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_BIT_INV_DISABLED_VALUE                         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_BIT_INV_DISABLED_VALUE_RESET_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_BIT_INV_ENABLED_VALUE                          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_16BIT_ORDER_DISABLED_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_16BIT_ORDER_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_16BIT_ORDER_ENABLED_VALUE                      ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_20BIT_ORDER_DISABLED_VALUE                     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_20BIT_ORDER_ENABLED_VALUE                      ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_20BIT_ORDER_ENABLED_VALUE_RESET_VALUE          ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_GEN2_DISABLED_VALUE                            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_GEN2_DISABLED_VALUE_RESET_VALUE                ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_RX_GEN2_ENABLED_VALUE                             ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_OFFSET ( 0x00000018 )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0                     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_TXFIFO_DRIFTED */
	uint32_t clear_txfifo_drifted   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_POINTER_DISTANCE_MAX */
	uint32_t tx_pointer_distance_max	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_POINTER_DISTANCE_MIN */
	uint32_t tx_pointer_distance_min	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOOPBACK_RX */
	uint32_t loopback_rx            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_TXFIFO_COLLISION */
	uint32_t clear_txfifo_collision 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_WR_PTR_ADV */
	uint32_t tx_wr_ptr_adv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_WR_PTR_DLY */
	uint32_t tx_wr_ptr_dly          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_BIT_INV */
	uint32_t tx_bit_inv             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_20BIT_ORDER */
	uint32_t tx_20bit_order         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_8BIT_ORDER */
	uint32_t tx_8bit_order          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_GEN2 */
	uint32_t tx_gen2                	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1                     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_RXFIFO_COLLISION */
	uint32_t clear_rxfifo_collision 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_RD_PTR_ADV */
	uint32_t rx_rd_ptr_adv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_RD_PTR_DLY */
	uint32_t rx_rd_ptr_dly          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_BIT_INV */
	uint32_t rx_bit_inv             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_16BIT_ORDER */
	uint32_t rx_16bit_order         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_20BIT_ORDER */
	uint32_t rx_20bit_order         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_GEN2 */
	uint32_t rx_gen2                	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0 ;
#else
typedef struct
{	uint32_t rx_gen2                	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_GEN2 */
	uint32_t rx_20bit_order         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_20BIT_ORDER */
	uint32_t rx_16bit_order         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_16BIT_ORDER */
	uint32_t rx_bit_inv             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_BIT_INV */
	uint32_t rx_rd_ptr_dly          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_RD_PTR_DLY */
	uint32_t rx_rd_ptr_adv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_RD_PTR_ADV */
	uint32_t clear_rxfifo_collision 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_RXFIFO_COLLISION */
	uint32_t r1                     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t tx_gen2                	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_GEN2 */
	uint32_t tx_8bit_order          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_8BIT_ORDER */
	uint32_t tx_20bit_order         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_20BIT_ORDER */
	uint32_t tx_bit_inv             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_BIT_INV */
	uint32_t tx_wr_ptr_dly          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_WR_PTR_DLY */
	uint32_t tx_wr_ptr_adv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_WR_PTR_ADV */
	uint32_t clear_txfifo_collision 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_TXFIFO_COLLISION */
	uint32_t loopback_rx            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOOPBACK_RX */
	uint32_t tx_pointer_distance_min	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_POINTER_DISTANCE_MIN */
	uint32_t tx_pointer_distance_max	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_POINTER_DISTANCE_MAX */
	uint32_t clear_txfifo_drifted   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_TXFIFO_DRIFTED */
	uint32_t r0                     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0 ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_FIFO_CFG_1                                                               */
/* GPON Gearbox FIFO Configuration Register 1                                            */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R0_RESERVED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R0_RESERVED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_TX_RD_POINTER_DATA_VALUE             ( 0x1C )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_TX_RD_POINTER_DATA_VALUE_RESET_VALUE ( 0x1C )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R3_RESERVED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R3_RESERVED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_TX_WR_POINTER_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_TX_WR_POINTER_DATA_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R1_RESERVED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R1_RESERVED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_RX_RD_POINTER_DATA_VALUE             ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_RX_RD_POINTER_DATA_VALUE_RESET_VALUE ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R2_RESERVED_VALUE                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_R2_RESERVED_VALUE_RESET_VALUE        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_RX_WR_POINTER_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_RX_WR_POINTER_DATA_VALUE_RESET_VALUE ( 0x0 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_OFFSET ( 0x0000001C )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0           	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_RD_POINTER */
	uint32_t tx_rd_pointer	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r3           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_WR_POINTER */
	uint32_t tx_wr_pointer	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_RD_POINTER */
	uint32_t rx_rd_pointer	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_WR_POINTER */
	uint32_t rx_wr_pointer	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1 ;
#else
typedef struct
{	uint32_t rx_wr_pointer	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_WR_POINTER */
	uint32_t r2           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rx_rd_pointer	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_RD_POINTER */
	uint32_t r1           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t tx_wr_pointer	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_WR_POINTER */
	uint32_t r3           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t tx_rd_pointer	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_RD_POINTER */
	uint32_t r0           	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1 ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_FIFO_CFG_2                                                               */
/* GPON Gearbox FIFO Configuration Register 2                                            */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_R0_RESERVED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_R0_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN2_RD_POINTER_DATA_VALUE             ( 0xE )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN2_RD_POINTER_DATA_VALUE_RESET_VALUE ( 0xE )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_R3_RESERVED_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_R3_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN2_WR_POINTER_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN2_WR_POINTER_DATA_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN1_RD_POINTER_DATA_VALUE             ( 0xC )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN1_RD_POINTER_DATA_VALUE_RESET_VALUE ( 0xC )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN1_WR_POINTER_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_BEN1_WR_POINTER_DATA_VALUE_RESET_VALUE ( 0x0 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_OFFSET ( 0x00000020 )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0             	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN2_RD_POINTER */
	uint32_t ben2_rd_pointer	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r3             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN2_WR_POINTER */
	uint32_t ben2_wr_pointer	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN1_RD_POINTER */
	uint32_t ben1_rd_pointer	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN1_WR_POINTER */
	uint32_t ben1_wr_pointer	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2 ;
#else
typedef struct
{	uint32_t ben1_wr_pointer	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN1_WR_POINTER */
	uint32_t ben1_rd_pointer	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN1_RD_POINTER */
	uint32_t ben2_wr_pointer	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN2_WR_POINTER */
	uint32_t r3             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ben2_rd_pointer	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN2_RD_POINTER */
	uint32_t r0             	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2 ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_FIFO_STATUS                                                              */
/* GPON Gearbox FIFO Status Register                                                     */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_R1_RESERVED_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_R1_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_TXFIFO_DRIFTED_DISABLED_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_TXFIFO_DRIFTED_DISABLED_VALUE_RESET_VALUE   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_TXFIFO_DRIFTED_ENABLED_VALUE                ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_TXFIFO_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_TXFIFO_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_TXFIFO_COLLISION_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_RXFIFO_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_RXFIFO_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_RXFIFO_COLLISION_ENABLED_VALUE              ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_OFFSET ( 0x00000024 )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXFIFO_DRIFTED */
	uint32_t txfifo_drifted  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXFIFO_COLLISION */
	uint32_t txfifo_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RXFIFO_COLLISION */
	uint32_t rxfifo_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS ;
#else
typedef struct
{	uint32_t rxfifo_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RXFIFO_COLLISION */
	uint32_t txfifo_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXFIFO_COLLISION */
	uint32_t txfifo_drifted  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXFIFO_DRIFTED */
	uint32_t r1              	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_PATTERN_CFG1                                                             */
/* GPON Gearbox Pattern Generator Configuration Register 1                               */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_FILLER_DATA_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_FILLER_DATA_VALUE_RESET_VALUE  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_PAYLOAD_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_PAYLOAD_DATA_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_HEADER_DATA_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_HEADER_DATA_VALUE_RESET_VALUE  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_R0_RESERVED_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_R0_RESERVED_VALUE_RESET_VALUE  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_PG_MODE_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_PG_MODE_DATA_VALUE_RESET_VALUE ( 0x0 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_OFFSET ( 0x00000028 )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FILLER */
	uint32_t filler 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PAYLOAD */
	uint32_t payload	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEADER */
	uint32_t header 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PG_MODE */
	uint32_t pg_mode	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1 ;
#else
typedef struct
{	uint32_t pg_mode	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PG_MODE */
	uint32_t r0     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t header 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEADER */
	uint32_t payload	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PAYLOAD */
	uint32_t filler 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FILLER */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1 ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_PATTERN_CFG2                                                             */
/* GPON Gearbox Pattern Generator Configuration Register 2                               */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_R0_RESERVED_VALUE                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_R0_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_GAP_SIZE_DATA_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_GAP_SIZE_DATA_VALUE_RESET_VALUE   ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_BURST_SIZE_DATA_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_BURST_SIZE_DATA_VALUE_RESET_VALUE ( 0x0 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_OFFSET ( 0x0000002C )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GAP_SIZE */
	uint32_t gap_size  	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BURST_SIZE */
	uint32_t burst_size	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2 ;
#else
typedef struct
{	uint32_t burst_size	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BURST_SIZE */
	uint32_t gap_size  	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GAP_SIZE */
	uint32_t r0        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2 ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_BURST_CFG                                                                */
/* GPON Gearbox Burst Pattern Generator Register                                         */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R3_RESERVED_VALUE                                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R3_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_BEN_FIFO2_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_BEN_FIFO2_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_BEN_FIFO2_COLLISION_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_BEN_FIFO1_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_BEN_FIFO1_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_BEN_FIFO1_COLLISION_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_CAPTURE_WINDOW_DISABLED_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_CAPTURE_WINDOW_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_CLEAR_CAPTURE_WINDOW_ENABLED_VALUE                   ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_SINGLE_CAPTURE_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_SINGLE_CAPTURE_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_SINGLE_CAPTURE_ENABLED_VALUE                         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R2_RESERVED_VALUE                                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R2_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_START_BIT_DATA_VALUE                             ( 0xB )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_START_BIT_DATA_VALUE_RESET_VALUE                 ( 0xB )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R1_RESERVED_VALUE                                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R1_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_FINE_ADJUST_DATA_VALUE                           ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_FINE_ADJUST_DATA_VALUE_RESET_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R4_RESERVED_VALUE                                    ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_R4_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_RD_PTR_ADV_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_RD_PTR_ADV_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_RD_PTR_ADV_ENABLED_VALUE                         ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_RD_PTR_DLY_DISABLED_VALUE                        ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_RD_PTR_DLY_DISABLED_VALUE_RESET_VALUE            ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_BEN_RD_PTR_DLY_ENABLED_VALUE                         ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_OFFSET ( 0x00000030 )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r3                       	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_BEN_FIFO2_COLLISION */
	uint32_t clear_ben_fifo2_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_BEN_FIFO1_COLLISION */
	uint32_t clear_ben_fifo1_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_CAPTURE_WINDOW */
	uint32_t clear_capture_window     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SINGLE_CAPTURE */
	uint32_t single_capture           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2                       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_START_BIT */
	uint32_t ben_start_bit            	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1                       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_FINE_ADJUST */
	uint32_t ben_fine_adjust          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r4                       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_RD_PTR_ADV */
	uint32_t ben_rd_ptr_adv           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_RD_PTR_DLY */
	uint32_t ben_rd_ptr_dly           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG ;
#else
typedef struct
{	uint32_t ben_rd_ptr_dly           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_RD_PTR_DLY */
	uint32_t ben_rd_ptr_adv           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_RD_PTR_ADV */
	uint32_t r4                       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ben_fine_adjust          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_FINE_ADJUST */
	uint32_t r1                       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ben_start_bit            	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_START_BIT */
	uint32_t r2                       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t single_capture           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SINGLE_CAPTURE */
	uint32_t clear_capture_window     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_CAPTURE_WINDOW */
	uint32_t clear_ben_fifo1_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_BEN_FIFO1_COLLISION */
	uint32_t clear_ben_fifo2_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CLEAR_BEN_FIFO2_COLLISION */
	uint32_t r3                       	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG ;
#endif

/*****************************************************************************************/
/* GPON_GEARBOX_BURST_STATUS                                                             */
/* GPON Gearbox Burst Pattern Capture Status Register                                    */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_CAPTURE_UPDATED_DISABLED_VALUE                 ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_CAPTURE_UPDATED_DISABLED_VALUE_RESET_VALUE     ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_CAPTURE_UPDATED_ENABLED_VALUE                  ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_BEN_FIFO2_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_BEN_FIFO2_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_BEN_FIFO2_COLLISION_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_BEN_FIFO1_COLLISION_DISABLED_VALUE             ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_BEN_FIFO1_COLLISION_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_BEN_FIFO1_COLLISION_ENABLED_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_R1_RESERVED_VALUE                              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_R1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_CAPTURE_WINDOW_DATA_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_CAPTURE_WINDOW_DATA_VALUE_RESET_VALUE          ( 0x0 )


#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_OFFSET ( 0x00000034 )

#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* CAPTURE_UPDATED */
	uint32_t capture_updated    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_FIFO2_COLLISION */
	uint32_t ben_fifo2_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_FIFO1_COLLISION */
	uint32_t ben_fifo1_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1                 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE_WINDOW */
	uint32_t capture_window     	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS ;
#else
typedef struct
{	uint32_t capture_window     	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE_WINDOW */
	uint32_t r1                 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ben_fifo1_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_FIFO1_COLLISION */
	uint32_t ben_fifo2_collision	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BEN_FIFO2_COLLISION */
	uint32_t capture_updated    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE_UPDATED */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS ;
#endif

/*****************************************************************************************/
/* EARLY_TXEN_CFG                                                                        */
/* Holds configuration registers of the Early TXEN for PMD                               */
/*****************************************************************************************/

#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_HOLD_TIME_DATA_VALUE                               ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_HOLD_TIME_DATA_VALUE_RESET_VALUE                   ( 0x3 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_SETUP_TIME_DATA_VALUE                              ( 0x18 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_SETUP_TIME_DATA_VALUE_RESET_VALUE                  ( 0x18 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_TOFF_TIME_DATA_VALUE                               ( 0x18 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_TOFF_TIME_DATA_VALUE_RESET_VALUE                   ( 0x18 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_R0_RESERVED_VALUE                                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_R0_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_OUTPUT_TXEN_POLARITY_ACTIVE_LOW_VALUE              ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_OUTPUT_TXEN_POLARITY_ACTIVE_HIGH_VALUE             ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_OUTPUT_TXEN_POLARITY_ACTIVE_HIGH_VALUE_RESET_VALUE ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_INPUT_TXEN_POLARITY_ACTIVE_LOW_VALUE               ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_INPUT_TXEN_POLARITY_ACTIVE_HIGH_VALUE              ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_INPUT_TXEN_POLARITY_ACTIVE_HIGH_VALUE_RESET_VALUE  ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_EARLY_TXEN_BYPASS_NO_BYPASS_VALUE                  ( 0x0 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_EARLY_TXEN_BYPASS_BYPASS_VALUE                     ( 0x1 )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_EARLY_TXEN_BYPASS_BYPASS_VALUE_RESET_VALUE         ( 0x1 )


#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_OFFSET ( 0x00000038 )

#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_ADDRESS   	( WAN_WAN_TOP_WAN_MISC_ADDRESS + WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_OFFSET )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_READ( r ) 	READ_32( ( WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_ADDRESS ), (r) )
#define WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_WRITE( v )	WRITE_32( ( WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* HOLD_TIME */
	uint32_t hold_time           	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SETUP_TIME */
	uint32_t setup_time          	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TOFF_TIME */
	uint32_t toff_time           	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0                  	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* OUTPUT_TXEN_POLARITY */
	uint32_t output_txen_polarity	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* INPUT_TXEN_POLARITY */
	uint32_t input_txen_polarity 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EARLY_TXEN_BYPASS */
	uint32_t early_txen_bypass   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG ;
#else
typedef struct
{	uint32_t early_txen_bypass   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EARLY_TXEN_BYPASS */
	uint32_t input_txen_polarity 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* INPUT_TXEN_POLARITY */
	uint32_t output_txen_polarity	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* OUTPUT_TXEN_POLARITY */
	uint32_t r0                  	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t toff_time           	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TOFF_TIME */
	uint32_t setup_time          	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SETUP_TIME */
	uint32_t hold_time           	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HOLD_TIME */
}
__PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG ;
#endif

typedef struct
{
	/* WAN_CFG */
	WAN_WAN_TOP_WAN_MISC_WAN_CFG wan_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SATA_CFG */
	WAN_WAN_TOP_WAN_MISC_SATA_CFG sata_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SATA_STAT */
	WAN_WAN_TOP_WAN_MISC_SATA_STAT sata_stat __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCS_CFG */
	WAN_WAN_TOP_WAN_MISC_PCS_CFG pcs_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCS_STAT */
	WAN_WAN_TOP_WAN_MISC_PCS_STAT pcs_stat __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_SW_RESET */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_SW_RESET gpon_gearbox_sw_reset __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_FIFO_CFG_0 */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_0 gpon_gearbox_fifo_cfg_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_FIFO_CFG_1 */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_1 gpon_gearbox_fifo_cfg_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_FIFO_CFG_2 */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_CFG_2 gpon_gearbox_fifo_cfg_2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_FIFO_STATUS */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_FIFO_STATUS gpon_gearbox_fifo_status __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_PATTERN_CFG1 */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG1 gpon_gearbox_pattern_cfg1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_PATTERN_CFG2 */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_PATTERN_CFG2 gpon_gearbox_pattern_cfg2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_BURST_CFG */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_CFG gpon_gearbox_burst_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_GEARBOX_BURST_STATUS */
	WAN_WAN_TOP_WAN_MISC_GPON_GEARBOX_BURST_STATUS gpon_gearbox_burst_status __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EARLY_TXEN_CFG */
	WAN_WAN_TOP_WAN_MISC_EARLY_TXEN_CFG early_txen_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP_WAN_MISC ;

typedef struct
{
	/* wan_misc function */
	WAN_WAN_TOP_WAN_MISC wan_misc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
WAN_WAN_TOP ;

typedef struct
{
	/* WAN_TOP */
	WAN_WAN_TOP wan_top __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
WAN_FOR_ALL ;
#endif /* WAN_H_INCLUDED */

