/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __MS1588_H_INCLUDED
#define __MS1588_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:55:05   */

#include "access_macros.h"
#include "packing.h"

/*****************************************************************************************/
/* This module is the HW implementation for 1588 master and slave using IPCLOCK core or  */
/* AMD2 for the slave and a custom implementation for the master.                        */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define MS1588_MASTER_REGS_OFFSET 	( 0x00000000 )
#define MS1588_MASTER_REGS_ADDRESS	( MS1588_MASTER_OFFSET + MS1588_MASTER_REGS_OFFSET )

#define MS1588_LOCAL_TS_REGS_OFFSET 	( 0x00000000 )
#define MS1588_LOCAL_TS_REGS_ADDRESS	( MS1588_LOCAL_TS_OFFSET + MS1588_LOCAL_TS_REGS_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* Master_configurations                                                                 */
/* General Master configurations                                                         */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_CFG_R2_RESERVED_VALUE                     ( 0x0 )
#define MS1588_MASTER_REGS_M_CFG_R2_RESERVED_VALUE_RESET_VALUE         ( 0x0 )
#define MS1588_MASTER_REGS_M_CFG_TSFIFOTH_MIN_VALUE_VALUE              ( 0x1 )
#define MS1588_MASTER_REGS_M_CFG_TSFIFOTH_DEFAULT_VALUE                ( 0x8 )
#define MS1588_MASTER_REGS_M_CFG_TSFIFOTH_DEFAULT_VALUE_RESET_VALUE    ( 0x8 )
#define MS1588_MASTER_REGS_M_CFG_TSFIFOTH_MAX_VALUE_VALUE              ( 0x64 )
#define MS1588_MASTER_REGS_M_CFG_R1_RESERVED_VALUE                     ( 0x0 )
#define MS1588_MASTER_REGS_M_CFG_R1_RESERVED_VALUE_RESET_VALUE         ( 0x0 )
#define MS1588_MASTER_REGS_M_CFG_TXSTRBSEL_TXSTRBSEL_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_CFG_TXSTRBSEL_TXSTRBSEL_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_CFG_OFFSET ( 0x00000000 )

#define MS1588_MASTER_REGS_M_CFG_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_CFG_OFFSET )
#define MS1588_MASTER_REGS_M_CFG_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_CFG_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_CFG_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2       	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFOTH */
	uint32_t tsfifoth 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXSTRBSEL */
	uint32_t txstrbsel	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CFG ;
#else
typedef struct
{	uint32_t txstrbsel	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TXSTRBSEL */
	uint32_t r1       	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t tsfifoth 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFOTH */
	uint32_t r2       	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CFG ;
#endif

/*****************************************************************************************/
/* Master_reset_commands                                                                 */
/* SW reset command register                                                             */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_RST_R1_RESERVED_VALUE                  ( 0x0 )
#define MS1588_MASTER_REGS_M_RST_R1_RESERVED_VALUE_RESET_VALUE      ( 0x0 )
#define MS1588_MASTER_REGS_M_RST_TSFIFORST_NO_USE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_RST_TSFIFORST_NO_USE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_RST_TSFIFORST_RST_VALUE                ( 0x1 )
#define MS1588_MASTER_REGS_M_RST_SNRST_NO_USE_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_RST_SNRST_NO_USE_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_RST_SNRST_RST_VALUE                    ( 0x1 )


#define MS1588_MASTER_REGS_M_RST_OFFSET ( 0x00000004 )

#define MS1588_MASTER_REGS_M_RST_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_RST_OFFSET )
#define MS1588_MASTER_REGS_M_RST_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_RST_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_RST_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_RST_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFORST */
	uint32_t tsfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SNRST */
	uint32_t snrst    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_RST ;
#else
typedef struct
{	uint32_t snrst    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SNRST */
	uint32_t tsfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFORST */
	uint32_t r1       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_RST ;
#endif

/*****************************************************************************************/
/* Master_tasnmit_FIFO_POP_command                                                       */
/* Transmit FIFO POP command                                                             */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TSPOPCMD_R1_RESERVED_VALUE                     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSPOPCMD_R1_RESERVED_VALUE_RESET_VALUE         ( 0x0 )
#define MS1588_MASTER_REGS_M_TSPOPCMD_TSFIFOPOP_TSFIFOPOP_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TSPOPCMD_TSFIFOPOP_TSFIFOPOP_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_TSPOPCMD_OFFSET ( 0x00000008 )

#define MS1588_MASTER_REGS_M_TSPOPCMD_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TSPOPCMD_OFFSET )
#define MS1588_MASTER_REGS_M_TSPOPCMD_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TSPOPCMD_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TSPOPCMD_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TSPOPCMD_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1       	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFOPOP */
	uint32_t tsfifopop	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSPOPCMD ;
#else
typedef struct
{	uint32_t tsfifopop	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFOPOP */
	uint32_t r1       	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSPOPCMD ;
#endif

/*****************************************************************************************/
/* Master_transmit_TS_VALID                                                              */
/* The register holds an indication whether the TSDATA registers hold a valid TS.  It al */
/* so holds the serial number from the TS FIFO (for debug purposes).                     */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TSVALID_TSVALID_TSVALID_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TSVALID_TSVALID_TSVALID_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_TSVALID_R1_RESERVED_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSVALID_R1_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSVALID_SN_SN_VALUE                       ( 0x0 )
#define MS1588_MASTER_REGS_M_TSVALID_SN_SN_VALUE_RESET_VALUE           ( 0x0 )


#define MS1588_MASTER_REGS_M_TSVALID_OFFSET ( 0x0000000C )

#define MS1588_MASTER_REGS_M_TSVALID_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TSVALID_OFFSET )
#define MS1588_MASTER_REGS_M_TSVALID_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TSVALID_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TSVALID_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TSVALID_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TSVALID */
	uint32_t tsvalid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SN */
	uint32_t sn     	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSVALID ;
#else
typedef struct
{	uint32_t sn     	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SN */
	uint32_t r1     	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t tsvalid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSVALID */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSVALID ;
#endif

/*****************************************************************************************/
/* Master_transmit_TS_DATA_H                                                             */
/* Contains the high bits [63:32] of the TS. This register is valid only after a SW pop  */
/* command if the TS valid is asserted.                                                  */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TSDATAH_TSDATAH_TSDATAH_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TSDATAH_TSDATAH_TSDATAH_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_TSDATAH_OFFSET ( 0x00000010 )

#define MS1588_MASTER_REGS_M_TSDATAH_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TSDATAH_OFFSET )
#define MS1588_MASTER_REGS_M_TSDATAH_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TSDATAH_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TSDATAH_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TSDATAH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TSDATAH */
	uint32_t tsdatah	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSDATAH ;
#else
typedef struct
{	uint32_t tsdatah	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSDATAH */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSDATAH ;
#endif

/*****************************************************************************************/
/* Master_transmit_TS_DATA_L                                                             */
/* Contains the low bits [31:0] of the TS. This register is valid only after a SW pop co */
/* mmand if the TS valid is asserted.                                                    */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TSDATAL_TSDATAL_TSDATAL_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TSDATAL_TSDATAL_TSDATAL_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_TSDATAL_OFFSET ( 0x00000014 )

#define MS1588_MASTER_REGS_M_TSDATAL_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TSDATAL_OFFSET )
#define MS1588_MASTER_REGS_M_TSDATAL_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TSDATAL_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TSDATAL_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TSDATAL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TSDATAL */
	uint32_t tsdatal	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSDATAL ;
#else
typedef struct
{	uint32_t tsdatal	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSDATAL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSDATAL ;
#endif

/*****************************************************************************************/
/* Master_transmit_TS_FIFO_status                                                        */
/* This register hold the status of the TS FIFO.                                         */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TSSTS_R5_RESERVED_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R5_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_WRPTR_WRPTR_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_WRPTR_WRPTR_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R4_RESERVED_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R4_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_RDPTR_RDPTR_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_RDPTR_RDPTR_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R3_RESERVED_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R3_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_NUMOFTS_NUMOFTS_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_NUMOFTS_NUMOFTS_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R2_RESERVED_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R2_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_FULL_FULL_VALUE                   ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_FULL_FULL_VALUE_RESET_VALUE       ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R1_RESERVED_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_R1_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TSSTS_EMPTY_EMPTY_VALUE                 ( 0x1 )
#define MS1588_MASTER_REGS_M_TSSTS_EMPTY_EMPTY_VALUE_RESET_VALUE     ( 0x1 )


#define MS1588_MASTER_REGS_M_TSSTS_OFFSET ( 0x00000018 )

#define MS1588_MASTER_REGS_M_TSSTS_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TSSTS_OFFSET )
#define MS1588_MASTER_REGS_M_TSSTS_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TSSTS_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TSSTS_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TSSTS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r5     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* WRPTR */
	uint32_t wrptr  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r4     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RDPTR */
	uint32_t rdptr  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NUMOFTS */
	uint32_t numofts	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FULL */
	uint32_t full   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMPTY */
	uint32_t empty  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSSTS ;
#else
typedef struct
{	uint32_t empty  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMPTY */
	uint32_t r1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t full   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FULL */
	uint32_t r2     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t numofts	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NUMOFTS */
	uint32_t r3     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t rdptr  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RDPTR */
	uint32_t r4     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wrptr  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* WRPTR */
	uint32_t r5     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TSSTS ;
#endif

/*****************************************************************************************/
/* Master_capture_configurations                                                         */
/* Capture configurations.                                                               */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_CAPTURECFG_R2_RESERVED_VALUE                    ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_R2_RESERVED_VALUE_RESET_VALUE        ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_EDGESEL_NO_CAPTURE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_EDGESEL_NO_CAPTURE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_EDGESEL_RISING_EDGE_VALUE            ( 0x1 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_EDGESEL_FALLING_EDGE_VALUE           ( 0x2 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_EDGESEL_BOTH_EDGES_VALUE             ( 0x3 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_R1_RESERVED_VALUE                    ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_R1_RESERVED_VALUE_RESET_VALUE        ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_SRCSEL_NO_CAPTURE_VALUE              ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_SRCSEL_NO_CAPTURE_VALUE_RESET_VALUE  ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_SRCSEL_EXT_VALUE                     ( 0x1 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_SRCSEL_OPPS_VALUE                    ( 0x2 )
#define MS1588_MASTER_REGS_M_CAPTURECFG_SRCSEL_GPON_FRAME_VALUE              ( 0x3 )


#define MS1588_MASTER_REGS_M_CAPTURECFG_OFFSET ( 0x0000001C )

#define MS1588_MASTER_REGS_M_CAPTURECFG_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_CAPTURECFG_OFFSET )
#define MS1588_MASTER_REGS_M_CAPTURECFG_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_CAPTURECFG_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_CAPTURECFG_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_CAPTURECFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EDGESEL */
	uint32_t edgesel	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRCSEL */
	uint32_t srcsel 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CAPTURECFG ;
#else
typedef struct
{	uint32_t srcsel 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRCSEL */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t edgesel	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EDGESEL */
	uint32_t r2     	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CAPTURECFG ;
#endif

/*****************************************************************************************/
/* Master_capture_reg_H                                                                  */
/* The higher bits [63:32] of the capture register. This register is valid when a captur */
/* e event has occurred and the capture interrupt was asserted.                          */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_CAPTUREREGH_CAPTUREREGH_CAPTUREREGH_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTUREREGH_CAPTUREREGH_CAPTUREREGH_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_CAPTUREREGH_OFFSET ( 0x00000020 )

#define MS1588_MASTER_REGS_M_CAPTUREREGH_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_CAPTUREREGH_OFFSET )
#define MS1588_MASTER_REGS_M_CAPTUREREGH_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_CAPTUREREGH_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_CAPTUREREGH_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_CAPTUREREGH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* CAPTUREREGH */
	uint32_t captureregh	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CAPTUREREGH ;
#else
typedef struct
{	uint32_t captureregh	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREREGH */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CAPTUREREGH ;
#endif

/*****************************************************************************************/
/* Master_capture_reg_L                                                                  */
/* The lower bits [31:0] of the capture register. This register is valid when a capture  */
/* event has occurred and the capture interrupt was asserted.                            */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_CAPTUREREGL_CAPTUREREGL_CAPTUREREGL_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_CAPTUREREGL_CAPTUREREGL_CAPTUREREGL_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_CAPTUREREGL_OFFSET ( 0x00000024 )

#define MS1588_MASTER_REGS_M_CAPTUREREGL_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_CAPTUREREGL_OFFSET )
#define MS1588_MASTER_REGS_M_CAPTUREREGL_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_CAPTUREREGL_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_CAPTUREREGL_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_CAPTUREREGL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* CAPTUREREGL */
	uint32_t captureregl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CAPTUREREGL ;
#else
typedef struct
{	uint32_t captureregl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREREGL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_CAPTUREREGL ;
#endif

/*****************************************************************************************/
/* Master_ToD_read_command                                                               */
/* ToD SW read command                                                                   */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TODRDCMD_R1_RESERVED_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_TODRDCMD_R1_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_TODRDCMD_TODRDCMD_NO_USE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TODRDCMD_TODRDCMD_NO_USE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_TODRDCMD_TODRDCMD_TODRDCMD_VALUE           ( 0x1 )


#define MS1588_MASTER_REGS_M_TODRDCMD_OFFSET ( 0x00000028 )

#define MS1588_MASTER_REGS_M_TODRDCMD_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TODRDCMD_OFFSET )
#define MS1588_MASTER_REGS_M_TODRDCMD_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TODRDCMD_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TODRDCMD_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TODRDCMD_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TODRDCMD */
	uint32_t todrdcmd	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TODRDCMD ;
#else
typedef struct
{	uint32_t todrdcmd	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TODRDCMD */
	uint32_t r1      	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TODRDCMD ;
#endif

/*****************************************************************************************/
/* Msater_TOD_reg_H                                                                      */
/* The higher bits [63:32] of the ToD. This register is valid immediately after a SW ToD */
/*  read command.                                                                        */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TODREGH_TODREGH_TODREGH_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TODREGH_TODREGH_TODREGH_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_TODREGH_OFFSET ( 0x0000002C )

#define MS1588_MASTER_REGS_M_TODREGH_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TODREGH_OFFSET )
#define MS1588_MASTER_REGS_M_TODREGH_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TODREGH_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TODREGH_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TODREGH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TODREGH */
	uint32_t todregh	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TODREGH ;
#else
typedef struct
{	uint32_t todregh	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TODREGH */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TODREGH ;
#endif

/*****************************************************************************************/
/* Master_TOD_reg_L                                                                      */
/* The lower bits [31:0] of the ToD. This register is valid immediately after a SW ToD r */
/* ead command.                                                                          */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_TODREGL_TODREGL_TODREGL_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_TODREGL_TODREGL_TODREGL_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_TODREGL_OFFSET ( 0x00000030 )

#define MS1588_MASTER_REGS_M_TODREGL_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_TODREGL_OFFSET )
#define MS1588_MASTER_REGS_M_TODREGL_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_TODREGL_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_TODREGL_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_TODREGL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TODREGL */
	uint32_t todregl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TODREGL ;
#else
typedef struct
{	uint32_t todregl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TODREGL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_TODREGL ;
#endif

/*****************************************************************************************/
/* Master_alarm_control                                                                  */
/* Alarm control                                                                         */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_ALARMCTRL_R1_RESERVED_VALUE                     ( 0x0 )
#define MS1588_MASTER_REGS_M_ALARMCTRL_R1_RESERVED_VALUE_RESET_VALUE         ( 0x0 )
#define MS1588_MASTER_REGS_M_ALARMCTRL_ALARMCTRL_ALARMCTRL_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ALARMCTRL_ALARMCTRL_ALARMCTRL_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_ALARMCTRL_OFFSET ( 0x00000034 )

#define MS1588_MASTER_REGS_M_ALARMCTRL_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_ALARMCTRL_OFFSET )
#define MS1588_MASTER_REGS_M_ALARMCTRL_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_ALARMCTRL_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_ALARMCTRL_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_ALARMCTRL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMCTRL */
	uint32_t alarmctrl	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMCTRL ;
#else
typedef struct
{	uint32_t alarmctrl	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMCTRL */
	uint32_t r1       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMCTRL ;
#endif

/*****************************************************************************************/
/* Master_alarm_assert_H                                                                 */
/* The higher bits [63:32] of the alarm assertion register. When the IEEE1588 RTC is equ */
/* al or greater than the value programmed in this register the Alarm signal is asserted */
/*  and the maskable interrupt AlarmAssert is set.  This register should be configured w */
/* hile the M_ALARMCTRL is disabled. First M_ALARMASSERTH should be configured to 0xFFFF */
/* FFFF, then the M_ALARMASSERTL should be configured to the desired value and then M_AL */
/* ARMASSERTH should be configured to the desired value.                                 */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_ALARMASSERTH_ALARMASSERTH_ALARMASSERTH_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ALARMASSERTH_ALARMASSERTH_ALARMASSERTH_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_ALARMASSERTH_OFFSET ( 0x00000038 )

#define MS1588_MASTER_REGS_M_ALARMASSERTH_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_ALARMASSERTH_OFFSET )
#define MS1588_MASTER_REGS_M_ALARMASSERTH_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_ALARMASSERTH_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_ALARMASSERTH_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_ALARMASSERTH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ALARMASSERTH */
	uint32_t alarmasserth	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMASSERTH ;
#else
typedef struct
{	uint32_t alarmasserth	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERTH */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMASSERTH ;
#endif

/*****************************************************************************************/
/* Master_alarm_assert_L                                                                 */
/* The lower bits [31:0] of the alarm assertion register. When the IEEE1588 RTC equals o */
/* r greater than the value programmed in this register, the Alarm signal is asserted. T */
/* he maskable interrupt AlarmAssert is set.  This register should be configured while t */
/* he M_ALARMCTRL is disabled. First M_ALARMASSERTH should be configured to 0xFFFFFFFF,  */
/* then the M_ALARMASSERTL should be configured to the desired value and then M_ALARMASS */
/* ERTH should be configured to the desired value.                                       */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_ALARMASSERTL_ALARMASSERTL_ALARMASSERTL_VALUE             ( 0x1 )
#define MS1588_MASTER_REGS_M_ALARMASSERTL_ALARMASSERTL_ALARMASSERTL_VALUE_RESET_VALUE ( 0x1 )


#define MS1588_MASTER_REGS_M_ALARMASSERTL_OFFSET ( 0x0000003C )

#define MS1588_MASTER_REGS_M_ALARMASSERTL_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_ALARMASSERTL_OFFSET )
#define MS1588_MASTER_REGS_M_ALARMASSERTL_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_ALARMASSERTL_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_ALARMASSERTL_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_ALARMASSERTL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ALARMASSERTL */
	uint32_t alarmassertl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMASSERTL ;
#else
typedef struct
{	uint32_t alarmassertl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERTL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMASSERTL ;
#endif

/*****************************************************************************************/
/* Master_alarm_duration                                                                 */
/* This register defines the time duration from the alarm assertion to negation (It is d */
/* efined according to the ToD frequency). The maskable interrupt AlarmNeg is set.       */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_ALARMDURATION_ALARMDURATION_ALARMDURATION_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ALARMDURATION_ALARMDURATION_ALARMDURATION_VALUE_RESET_VALUE ( 0x0 )


#define MS1588_MASTER_REGS_M_ALARMDURATION_OFFSET ( 0x00000040 )

#define MS1588_MASTER_REGS_M_ALARMDURATION_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_ALARMDURATION_OFFSET )
#define MS1588_MASTER_REGS_M_ALARMDURATION_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_ALARMDURATION_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_ALARMDURATION_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_ALARMDURATION_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ALARMDURATION */
	uint32_t alarmduration	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMDURATION ;
#else
typedef struct
{	uint32_t alarmduration	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMDURATION */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ALARMDURATION ;
#endif

/*****************************************************************************************/
/* Master_interrupt_status_register                                                      */
/* Interrupt Status Register                                                             */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_ISR_R1_RESERVED_VALUE                         ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_R1_RESERVED_VALUE_RESET_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_ALARMNEGATE_ALARMNEGATE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_ALARMNEGATE_ALARMNEGATE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_ALARMASSERT_ALARMASSERT_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_ALARMASSERT_ALARMASSERT_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_CAPTUREOVF_CAPTUREOVF_VALUE               ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_CAPTUREOVF_CAPTUREOVF_VALUE_RESET_VALUE   ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_CAPTURE_CAPTURE_VALUE                     ( 0x1 )
#define MS1588_MASTER_REGS_M_ISR_CAPTURE_CAPTURE_VALUE_RESET_VALUE         ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_TSFIFO_TSFIFO_VALUE                       ( 0x0 )
#define MS1588_MASTER_REGS_M_ISR_TSFIFO_TSFIFO_VALUE_RESET_VALUE           ( 0x0 )


#define MS1588_MASTER_REGS_M_ISR_OFFSET ( 0x00000044 )

#define MS1588_MASTER_REGS_M_ISR_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_ISR_OFFSET )
#define MS1588_MASTER_REGS_M_ISR_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_ISR_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_ISR_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_ISR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1         	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMNEGATE */
	uint32_t alarmnegate	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERT */
	uint32_t alarmassert	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREOVF */
	uint32_t captureovf 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE */
	uint32_t capture    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFO */
	uint32_t tsfifo     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ISR ;
#else
typedef struct
{	uint32_t tsfifo     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFO */
	uint32_t capture    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE */
	uint32_t captureovf 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREOVF */
	uint32_t alarmassert	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERT */
	uint32_t alarmnegate	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMNEGATE */
	uint32_t r1         	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ISR ;
#endif

/*****************************************************************************************/
/* Master_interrupt_enable_register                                                      */
/* Interrupt Enable register.                                                            */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_IER_R1_RESERVED_VALUE                     ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_R1_RESERVED_VALUE_RESET_VALUE         ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_ALARMNEGATE_DISABLE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_ALARMNEGATE_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_ALARMNEGATE_ENABLE_VALUE              ( 0x1 )
#define MS1588_MASTER_REGS_M_IER_ALARMASSERT_DISABLE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_ALARMASSERT_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_ALARMASSERT_ENABLE_VALUE              ( 0x1 )
#define MS1588_MASTER_REGS_M_IER_CAPTUREOVF_DISABLE_VALUE              ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_CAPTUREOVF_DISABLE_VALUE_RESET_VALUE  ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_CAPTUREOVF_ENABLE_VALUE               ( 0x1 )
#define MS1588_MASTER_REGS_M_IER_CAPTURE_DISABLE_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_CAPTURE_DISABLE_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_CAPTURE_ENABLE_VALUE                  ( 0x1 )
#define MS1588_MASTER_REGS_M_IER_TSFIFO_DISABLE_VALUE                  ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_TSFIFO_DISABLE_VALUE_RESET_VALUE      ( 0x0 )
#define MS1588_MASTER_REGS_M_IER_TSFIFO_ENABLE_VALUE                   ( 0x1 )


#define MS1588_MASTER_REGS_M_IER_OFFSET ( 0x00000048 )

#define MS1588_MASTER_REGS_M_IER_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_IER_OFFSET )
#define MS1588_MASTER_REGS_M_IER_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_IER_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_IER_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_IER_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1         	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMNEGATE */
	uint32_t alarmnegate	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERT */
	uint32_t alarmassert	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREOVF */
	uint32_t captureovf 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE */
	uint32_t capture    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFO */
	uint32_t tsfifo     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_IER ;
#else
typedef struct
{	uint32_t tsfifo     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFO */
	uint32_t capture    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE */
	uint32_t captureovf 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREOVF */
	uint32_t alarmassert	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERT */
	uint32_t alarmnegate	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMNEGATE */
	uint32_t r1         	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_IER ;
#endif

/*****************************************************************************************/
/* Master_interrupt_test_register                                                        */
/* Interrupt Test register.                                                              */
/*****************************************************************************************/

#define MS1588_MASTER_REGS_M_ITR_R1_RESERVED_VALUE                     ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_R1_RESERVED_VALUE_RESET_VALUE         ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_ALARMNEGATE_DISABLE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_ALARMNEGATE_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_ALARMNEGATE_ENABLE_VALUE              ( 0x1 )
#define MS1588_MASTER_REGS_M_ITR_ALARMASSERT_DISABLE_VALUE             ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_ALARMASSERT_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_ALARMASSERT_ENABLE_VALUE              ( 0x1 )
#define MS1588_MASTER_REGS_M_ITR_CAPTUREOVF_DISABLE_VALUE              ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_CAPTUREOVF_DISABLE_VALUE_RESET_VALUE  ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_CAPTUREOVF_ENABLE_VALUE               ( 0x1 )
#define MS1588_MASTER_REGS_M_ITR_CAPTURE_DISABLE_VALUE                 ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_CAPTURE_DISABLE_VALUE_RESET_VALUE     ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_CAPTURE_ENABLE_VALUE                  ( 0x1 )
#define MS1588_MASTER_REGS_M_ITR_TSFIFO_DISABLE_VALUE                  ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_TSFIFO_DISABLE_VALUE_RESET_VALUE      ( 0x0 )
#define MS1588_MASTER_REGS_M_ITR_TSFIFO_ENABLE_VALUE                   ( 0x1 )


#define MS1588_MASTER_REGS_M_ITR_OFFSET ( 0x0000004C )

#define MS1588_MASTER_REGS_M_ITR_ADDRESS   	( MS1588_MASTER_REGS_ADDRESS + MS1588_MASTER_REGS_M_ITR_OFFSET )
#define MS1588_MASTER_REGS_M_ITR_READ( r ) 	READ_32( ( MS1588_MASTER_REGS_M_ITR_ADDRESS ), (r) )
#define MS1588_MASTER_REGS_M_ITR_WRITE( v )	WRITE_32( ( MS1588_MASTER_REGS_M_ITR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1         	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMNEGATE */
	uint32_t alarmnegate	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERT */
	uint32_t alarmassert	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREOVF */
	uint32_t captureovf 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE */
	uint32_t capture    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFO */
	uint32_t tsfifo     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ITR ;
#else
typedef struct
{	uint32_t tsfifo     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TSFIFO */
	uint32_t capture    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTURE */
	uint32_t captureovf 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAPTUREOVF */
	uint32_t alarmassert	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMASSERT */
	uint32_t alarmnegate	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALARMNEGATE */
	uint32_t r1         	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS_M_ITR ;
#endif

/*****************************************************************************************/
/* LOCAL_TS                                                                              */
/* A counter in the TM clock domain which compensate for the time point in which the pac */
/* ket is received at the MAC until it is stamped by the network processor.              */
/*****************************************************************************************/

#define MS1588_LOCAL_TS_REGS_LOCALTS_R2_RESERVED_VALUE                ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_R2_RESERVED_VALUE_RESET_VALUE    ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_LOCALTSRST_RST_VALUE             ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_LOCALTSRST_RST_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_R1_RESERVED_VALUE                ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_R1_RESERVED_VALUE_RESET_VALUE    ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_DIVFACTOR_DIV8_VALUE             ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_DIVFACTOR_DIV8_VALUE_RESET_VALUE ( 0x0 )
#define MS1588_LOCAL_TS_REGS_LOCALTS_DIVFACTOR_DIV16_VALUE            ( 0x1 )


#define MS1588_LOCAL_TS_REGS_LOCALTS_OFFSET ( 0x00000000 )

#define MS1588_LOCAL_TS_REGS_LOCALTS_ADDRESS   	( MS1588_LOCAL_TS_REGS_ADDRESS + MS1588_LOCAL_TS_REGS_LOCALTS_OFFSET )
#define MS1588_LOCAL_TS_REGS_LOCALTS_READ( r ) 	READ_32( ( MS1588_LOCAL_TS_REGS_LOCALTS_ADDRESS ), (r) )
#define MS1588_LOCAL_TS_REGS_LOCALTS_WRITE( v )	WRITE_32( ( MS1588_LOCAL_TS_REGS_LOCALTS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2        	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Local_TS_reset */
	uint32_t localtsrst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1        	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Division_factor */
	uint32_t divfactor 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_LOCAL_TS_REGS_LOCALTS ;
#else
typedef struct
{	uint32_t divfactor 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Division_factor */
	uint32_t r1        	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t localtsrst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Local_TS_reset */
	uint32_t r2        	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
MS1588_LOCAL_TS_REGS_LOCALTS ;
#endif

typedef struct
{
	/* Master_configurations */
	MS1588_MASTER_REGS_M_CFG m_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_reset_commands */
	MS1588_MASTER_REGS_M_RST m_rst __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_tasnmit_FIFO_POP_command */
	MS1588_MASTER_REGS_M_TSPOPCMD m_tspopcmd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_transmit_TS_VALID */
	MS1588_MASTER_REGS_M_TSVALID m_tsvalid __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_transmit_TS_DATA_H */
	MS1588_MASTER_REGS_M_TSDATAH m_tsdatah __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_transmit_TS_DATA_L */
	MS1588_MASTER_REGS_M_TSDATAL m_tsdatal __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_transmit_TS_FIFO_status */
	MS1588_MASTER_REGS_M_TSSTS m_tssts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_capture_configurations */
	MS1588_MASTER_REGS_M_CAPTURECFG m_capturecfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_capture_reg_H */
	MS1588_MASTER_REGS_M_CAPTUREREGH m_captureregh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_capture_reg_L */
	MS1588_MASTER_REGS_M_CAPTUREREGL m_captureregl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_ToD_read_command */
	MS1588_MASTER_REGS_M_TODRDCMD m_todrdcmd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Msater_TOD_reg_H */
	MS1588_MASTER_REGS_M_TODREGH m_todregh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_TOD_reg_L */
	MS1588_MASTER_REGS_M_TODREGL m_todregl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_alarm_control */
	MS1588_MASTER_REGS_M_ALARMCTRL m_alarmctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_alarm_assert_H */
	MS1588_MASTER_REGS_M_ALARMASSERTH m_alarmasserth __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_alarm_assert_L */
	MS1588_MASTER_REGS_M_ALARMASSERTL m_alarmassertl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_alarm_duration */
	MS1588_MASTER_REGS_M_ALARMDURATION m_alarmduration __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_interrupt_status_register */
	MS1588_MASTER_REGS_M_ISR m_isr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_interrupt_enable_register */
	MS1588_MASTER_REGS_M_IER m_ier __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Master_interrupt_test_register */
	MS1588_MASTER_REGS_M_ITR m_itr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER_REGS ;

typedef struct
{
	/* LOCAL_TS */
	MS1588_LOCAL_TS_REGS_LOCALTS localts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
MS1588_LOCAL_TS_REGS ;

typedef struct
{
	/* regs function */
	MS1588_MASTER_REGS regs __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
MS1588_MASTER ;

typedef struct
{
	/* regs function */
	MS1588_LOCAL_TS_REGS regs __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
MS1588_LOCAL_TS ;

typedef struct
{
	/* MASTER */
	MS1588_MASTER master __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 432 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOCAL_TS */
	MS1588_LOCAL_TS local_ts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
MS1588_FOR_ALL ;
#endif /* MS1588_H_INCLUDED */

