/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __IH_H_INCLUDED
#define __IH_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:54:43   */

#include "access_macros.h"
#include "packing.h"
#include "rdp_map.h"

/*****************************************************************************************/
/* Lilac Ingres Handler. Ingres Handler in Lilac is responsible for incoming ingres traf */
/* fic pre-processing. It includes re-used accelerators from Ginger: Parser & Look-up en */
/* gine. The main features of IH (Ingres Handler) are as following: (1) Runner proccessi */
/* ng offload (Parsing, Lookup engine), (2) Ingres QoS, (3) Target Memory decision: DDR  */
/* or SRAM, (4) Runner load balancing                                                    */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define IH_REGS_LOOKUP_CONFIGURATION_OFFSET 	( 0x00000000 )
#define IH_REGS_LOOKUP_CONFIGURATION_ADDRESS	( IH_REGS_OFFSET + IH_REGS_LOOKUP_CONFIGURATION_OFFSET )

#define IH_REGS_PARSER_CORE_CONFIGURATION_OFFSET 	( 0x00000400 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS	( IH_REGS_OFFSET + IH_REGS_PARSER_CORE_CONFIGURATION_OFFSET )

#define IH_REGS_GENERAL_CONFIGURATION_OFFSET 	( 0x00000800 )
#define IH_REGS_GENERAL_CONFIGURATION_ADDRESS	( IH_REGS_OFFSET + IH_REGS_GENERAL_CONFIGURATION_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* LKUP_TBL0_LUT_CFG                                                                     */
/* Look-up table 0:  Configuration of LUT: table params + main flag                      */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_RESERVED_RESERVED_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_RESERVED_RESERVED_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_OFFSET ( 0x00000000 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t reserved     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t reserved     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_LUT_CFG                                                                     */
/* Look-up table 1:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_OFFSET ( 0x00000004 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_LUT_CFG                                                                     */
/* Look-up table 2:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_OFFSET ( 0x00000008 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_LUT_CFG                                                                     */
/* Look-up table 3:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_OFFSET ( 0x0000000C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_LUT_CFG                                                                     */
/* Look-up table 4:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_OFFSET ( 0x00000010 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_LUT_CFG                                                                     */
/* Look-up table 5:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_OFFSET ( 0x00000014 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_LUT_CFG                                                                     */
/* Look-up table 6:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_OFFSET ( 0x00000018 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_LUT_CFG                                                                     */
/* Look-up table 7:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_OFFSET ( 0x0000001C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_LUT_CFG                                                                     */
/* Look-up table 8:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_OFFSET ( 0x00000020 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_LUT_CFG                                                                     */
/* Look-up table 9:  Configuration of LUT: table params + main flags                     */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_FIVE_TUPLE_EN_FIVE_TUPLE_EN_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_AGING_EN_AGING_EN_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_AGING_EN_AGING_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_SA_SEARCH_EN_SA_SEARCH_EN_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_1_STEP_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_2_STEPS_VALUE                             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_4_STEPS_VALUE                             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_8_STEPS_VALUE                             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_16_STEPS_VALUE                            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_32_STEPS_VALUE                            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_64_STEPS_VALUE                            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_128_STEPS_VALUE                           ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_256_STEPS_VALUE                           ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_512_STEPS_VALUE                           ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_MAX_1K_STEPS_VALUE                            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_32_ENTRIES_VALUE_RESET_VALUE           ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_64_ENTRIES_VALUE                       ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_128_ENTRIES_VALUE                      ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_256_ENTRIES_VALUE                      ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_512_ENTRIES_VALUE                      ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_1K_ENTRIES_VALUE                       ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_2K_ENTRIES_VALUE                       ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_TABLE_SIZE_MAX_4K_ENTRIES_VALUE                       ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_R2_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_R2_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_OFFSET ( 0x00000024 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG ;
#else
typedef struct
{	uint32_t base_address 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t table_size   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t sa_search_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sa_search_en */
	uint32_t aging_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* aging_en */
	uint32_t five_tuple_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* five_tuple_en */
	uint32_t reserved1    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_CAM_CFG                                                                     */
/* Look-up table 0: CAM configurations (base addr + cam extention enable)                */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_OFFSET ( 0x00000028 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_CAM_CFG                                                                     */
/* Look-up table 1: CAM configurations (base CAM addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_OFFSET ( 0x0000002C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_CAM_CFG                                                                     */
/* Look-up table 2: CAM configurations (base addr + cam extention enable)                */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_OFFSET ( 0x00000030 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_CAM_CFG                                                                     */
/* Look-up table 3: CAM configurations (CAM base addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_OFFSET ( 0x00000034 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_CAM_CFG                                                                     */
/* Look-up table 4: CAM configurations (CAM base addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_OFFSET ( 0x00000038 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_CAM_CFG                                                                     */
/* Look-up table 5: CAM configurations (CAM base addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_OFFSET ( 0x0000003C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_CAM_CFG                                                                     */
/* Look-up table 6: CAM configurations (CAM base addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_OFFSET ( 0x00000040 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_CAM_CFG                                                                     */
/* Look-up table 7: CAM configurations (CAM base addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_OFFSET ( 0x00000044 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_CAM_CFG                                                                     */
/* Look-up table 8: CAM configurations (CAM base addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_OFFSET ( 0x00000048 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_CAM_CFG                                                                     */
/* Look-up table 9: CAM configurations (CAM base addr + CAM extention enable)            */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_R1_RESERVED_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_R1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_OFFSET ( 0x0000004C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_LUT_CNXT_CFG                                                                */
/* Look-up table 0: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_OFFSET ( 0x00000050 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_LUT_CNXT_CFG                                                                */
/* Look-up table 1: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_OFFSET ( 0x00000054 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_LUT_CNXT_CFG                                                                */
/* Look-up table 2: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_OFFSET ( 0x00000058 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_LUT_CNXT_CFG                                                                */
/* Look-up table 3: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_OFFSET ( 0x0000005C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_LUT_CNXT_CFG                                                                */
/* Look-up table 4: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_OFFSET ( 0x00000060 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_LUT_CNXT_CFG                                                                */
/* Look-up table 5: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_OFFSET ( 0x00000064 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_LUT_CNXT_CFG                                                                */
/* Look-up table 6: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_RESREVED_RESERVED_VALUE                               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_RESREVED_RESERVED_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_OFFSET ( 0x00000068 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
	uint32_t resreved       	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved       	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_LUT_CNXT_CFG                                                                */
/* Look-up table 7: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_OFFSET ( 0x0000006C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_LUT_CNXT_CFG                                                                */
/* Look-up table 8: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_OFFSET ( 0x00000070 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_LUT_CNXT_CFG                                                                */
/* Look-up table 9: LUT Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE                              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_ONE_BYTE_ENTRY_SIZE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_TWO_BYTES_ENTRY_SIZE_VALUE            ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_FOUR_BYTES_ENTRY_SIZE_VALUE           ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_CNXT_ENTRY_SIZE_INTERNAL_ENTRY_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_OFFSET ( 0x00000074 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t r1             	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cnxt_entry_size	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_entry_size */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_LUT_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_CAM_CNXT_CFG                                                                */
/* Look-up table 0: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_OFFSET ( 0x0000007C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_CAM_CNXT_CFG                                                                */
/* Look-up table 1: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_OFFSET ( 0x00000080 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_CAM_CNXT_CFG                                                                */
/* Look-up table 2: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_OFFSET ( 0x00000084 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_CAM_CNXT_CFG                                                                */
/* Look-up table 3: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_OFFSET ( 0x00000088 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_CAM_CNXT_CFG                                                                */
/* Look-up table 4: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_OFFSET ( 0x0000008C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_CAM_CNXT_CFG                                                                */
/* Look-up table 5: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_OFFSET ( 0x00000090 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_CAM_CNXT_CFG                                                                */
/* Look-up table 6: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_OFFSET ( 0x00000094 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_CAM_CNXT_CFG                                                                */
/* Look-up table 7: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_OFFSET ( 0x00000098 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_CAM_CNXT_CFG                                                                */
/* Look-up table 8: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_OFFSET ( 0x0000009C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_CAM_CNXT_CFG                                                                */
/* Look-up table 9: CAM Context Table configurations (base addr + entry context size)    */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_OFFSET ( 0x00000100 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t resreved1   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_CAM_CNXT_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_KEY_CFG                                                                     */
/* Look-up table 0: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port/GEM flow ID/WAN (tak */
/* en from Ingres Header Descriptor) to LSB of the search key.                           */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_OFFSET ( 0x00000104 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_KEY_P0_MASKL                                                                */
/* Look-up table 0: MAsk on bits [31:0] of Part 0    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_OFFSET ( 0x00000108 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_KEY_P0_MASKH                                                                */
/* Look-up table 0: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_RESERVED_RSV_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_RESERVED_RSV_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_MASKH_MASKH_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_OFFSET ( 0x0000010C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_KEY_P1_MASKL                                                                */
/* Look-up table 0: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_OFFSET ( 0x00000110 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_KEY_P1_MASKH                                                                */
/* Look-up table 0: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_RESERVED_RSV_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_RESERVED_RSV_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_MASKH_MASKH_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_OFFSET ( 0x00000114 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_KEY_CFG                                                                     */
/* Look-up table 1: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_OFFSET ( 0x00000118 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_KEY_P0_MASKL                                                                */
/* Look-up table 0: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_OFFSET ( 0x0000011C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_KEY_P0_MASKH                                                                */
/* Look-up table 0: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_RESERVED_RSV_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_RESERVED_RSV_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_MASKH_MASKH_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_OFFSET ( 0x00000120 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_KEY_P1_MASKL                                                                */
/* Look-up table 1: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_OFFSET ( 0x00000124 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_KEY_P1_MASKH                                                                */
/* Look-up table 1: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_RESERVED_RSV_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_RESERVED_RSV_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_MASKH_MASKH_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_OFFSET ( 0x00000128 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_KEY_CFG                                                                     */
/* Look-up table 2: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_OFFSET ( 0x0000012C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_KEY_P0_MASKL                                                                */
/* Look-up table 0: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_OFFSET ( 0x00000130 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_KEY_P0_MASKH                                                                */
/* Look-up table 2: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_RESERVED_RSV_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_RESERVED_RSV_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_MASKH_MASKH_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_OFFSET ( 0x00000134 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_KEY_P1_MASKL                                                                */
/* Look-up table 1: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_OFFSET ( 0x00000138 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_KEY_P1_MASKH                                                                */
/* Look-up table 3: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_RESERVED_RSV_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_RESERVED_RSV_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_MASKH_MASKH_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_OFFSET ( 0x0000013C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_KEY_CFG                                                                     */
/* Look-up table 2: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_OFFSET ( 0x00000140 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_KEY_P0_MASKL                                                                */
/* Look-up table 3: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_OFFSET ( 0x00000144 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_KEY_P0_MASKH                                                                */
/* Look-up table 2: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_RESERVED_RSV_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_RESERVED_RSV_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_MASKH_MASKH_VALUE              ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_OFFSET ( 0x00000148 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_KEY_P1_MASKL                                                                */
/* Look-up table 1: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_OFFSET ( 0x0000014C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_KEY_P1_MASKH                                                                */
/* Look-up table 3: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_OFFSET ( 0x00000150 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_KEY_CFG                                                                     */
/* Look-up table 4: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_OFFSET ( 0x00000154 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_KEY_P0_MASKL                                                                */
/* Look-up table 4: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_OFFSET ( 0x00000158 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_KEY_P0_MASKH                                                                */
/* Look-up table 4: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_OFFSET ( 0x0000015C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_KEY_P1_MASKL                                                                */
/* Look-up table 4: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_OFFSET ( 0x00000160 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_KEY_P1_MASKH                                                                */
/* Look-up table 4: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_OFFSET ( 0x00000164 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_KEY_CFG                                                                     */
/* Look-up table 5: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_OFFSET ( 0x00000168 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_KEY_P0_MASKL                                                                */
/* Look-up table 4: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_OFFSET ( 0x0000016C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_KEY_P0_MASKH                                                                */
/* Look-up table 5: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_OFFSET ( 0x00000170 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_KEY_P1_MASKL                                                                */
/* Look-up table 5: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_OFFSET ( 0x00000174 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_KEY_P1_MASKH                                                                */
/* Look-up table 5: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_OFFSET ( 0x00000178 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_KEY_CFG                                                                     */
/* Look-up table 6: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_OFFSET ( 0x0000017C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_KEY_P0_MASKL                                                                */
/* Look-up table 6: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_OFFSET ( 0x00000180 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_KEY_P0_MASKH                                                                */
/* Look-up table 6: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_OFFSET ( 0x00000184 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_KEY_P1_MASKL                                                                */
/* Look-up table 6: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_OFFSET ( 0x00000188 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_KEY_P1_MASKH                                                                */
/* Look-up table 6: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_OFFSET ( 0x0000018C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_KEY_CFG                                                                     */
/* Look-up table 7: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_OFFSET ( 0x00000190 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_KEY_P0_MASKL                                                                */
/* Look-up table 7: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_OFFSET ( 0x00000194 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_KEY_P0_MASKH                                                                */
/* Look-up table 7: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_OFFSET ( 0x00000198 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_KEY_P1_MASKL                                                                */
/* Look-up table 7: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_OFFSET ( 0x0000019C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_KEY_P1_MASKH                                                                */
/* Look-up table 7: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_OFFSET ( 0x00000200 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_KEY_CFG                                                                     */
/* Look-up table 8: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_OFFSET ( 0x00000204 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_KEY_P0_MASKL                                                                */
/* Look-up table 8: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_OFFSET ( 0x00000208 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_KEY_P0_MASKH                                                                */
/* Look-up table 8: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_OFFSET ( 0x0000020C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_KEY_P1_MASKL                                                                */
/* Look-up table 8: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_OFFSET ( 0x00000210 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_KEY_P1_MASKH                                                                */
/* Look-up table 8: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_OFFSET ( 0x00000214 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_KEY_CFG                                                                     */
/* Look-up table 9: Search key configuration parameters.    Key is based on two parts, e */
/* ach part includes 60-bit that generated on Parser Results (64 byte) array. The genera */
/* tion of each part requries start_offset (from which word start collect 60 bit) and sh */
/* ift_rotate paramter (in order to get flexibilty on variety of search key generation). */
/*   Each part has its own mask (mask low on 32 low bits and mask high on 28 high bits), */
/*  then two parts are ORed.  There is an option to add source port (taken from Ingres H */
/* eader Descriptor) to 5 MSB of the search key.                                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_RESREVED1_RESREVED_VALUE                  ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_KEY_EXT_NO_EXT_VALUE                      ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_KEY_EXT_NO_EXT_VALUE_RESET_VALUE          ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_KEY_EXT_SP_ADD_EN_VALUE                   ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_KEY_EXT_GEMFID_ADD_EN_VALUE               ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_KEY_EXT_WAN_ADD_EN_VALUE                  ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P1_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P1_RESERVED_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_4_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_8_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_12_VALUE            ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_16_VALUE            ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_20_VALUE            ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_24_VALUE            ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_28_VALUE            ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_32_VALUE            ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_36_VALUE            ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_40_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_44_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_48_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_52_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_56_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_SHIFT_OFFSET_P0_SHIFT_60_VALUE            ( 0xF )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_0_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_0_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_1_VALUE             ( 0x1 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_2_VALUE             ( 0x2 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_3_VALUE             ( 0x3 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_4_VALUE             ( 0x4 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_5_VALUE             ( 0x5 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_6_VALUE             ( 0x6 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_7_VALUE             ( 0x7 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_8_VALUE             ( 0x8 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_9_VALUE             ( 0x9 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_10_VALUE            ( 0xA )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_11_VALUE            ( 0xB )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_12_VALUE            ( 0xC )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_13_VALUE            ( 0xD )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_START_14_VALUE            ( 0xE )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_START_OFFSET_P0_RESERVED_VALUE            ( 0xF )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_OFFSET ( 0x00000218 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG ;
#else
typedef struct
{	uint32_t start_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p0 */
	uint32_t shift_offset_p0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p0 */
	uint32_t start_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* start_offset_p1 */
	uint32_t shift_offset_p1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* shift_offset_p1 */
	uint32_t key_ext        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* KEY_EXT */
	uint32_t resreved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_CFG ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_KEY_P0_MASKL                                                                */
/* Look-up table 9: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_OFFSET ( 0x0000021C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_KEY_P0_MASKH                                                                */
/* Look-up table 9: Mask on bits [59:32] of Part 0    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_OFFSET ( 0x00000220 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P0_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_KEY_P1_MASKL                                                                */
/* Look-up table 9: Mask on bits [31:0] of Part 1    Key is based on two parts, each par */
/* t includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has i */
/* ts own mask that represnted by two registers: MASKL and MASKH                         */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_MASKL_MASKL_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_MASKL_MASKL_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_OFFSET ( 0x00000224 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASKL */
	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL ;
#else
typedef struct
{	uint32_t maskl	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKL */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKL ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_KEY_P1_MASKH                                                                */
/* Look-up table 9: Mask on bits [59:32] of Part 1    Key is based on two parts, each pa */
/* rt includes 60-bit that generated on Parser Results (64 byte) array.   Each Part has  */
/* its own mask that represnted by two registers: MASKL and MASKH                        */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_RESERVED_RESERVED_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_MASKH_MASKH_VALUE                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_MASKH_MASKH_VALUE_RESET_VALUE       ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_OFFSET ( 0x00000228 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH ;
#else
typedef struct
{	uint32_t maskh   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASKH */
	uint32_t reserved	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_KEY_P1_MASKH ;
#endif

/*****************************************************************************************/
/* LKUP_TBL0_GL_MASK                                                                     */
/* Look-up table 0: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_OFFSET ( 0x0000022C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL0_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL1_GL_MASK                                                                     */
/* Look-up table 1: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_OFFSET ( 0x00000230 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL1_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL2_GL_MASK                                                                     */
/* Look-up table 2: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_OFFSET ( 0x00000234 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL2_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL3_GL_MASK                                                                     */
/* Look-up table 3: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_OFFSET ( 0x00000238 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL3_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL4_GL_MASK                                                                     */
/* Look-up table 4: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_OFFSET ( 0x0000023C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL4_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL5_GL_MASK                                                                     */
/* Look-up table 5: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_OFFSET ( 0x00000240 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL5_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL6_GL_MASK                                                                     */
/* Look-up table 6: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_OFFSET ( 0x00000244 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL6_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL7_GL_MASK                                                                     */
/* Look-up table 7: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_OFFSET ( 0x00000248 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL7_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL8_GL_MASK                                                                     */
/* Look-up table 8: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_OFFSET ( 0x0000024C )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL8_GL_MASK ;
#endif

/*****************************************************************************************/
/* LKUP_TBL9_GL_MASK                                                                     */
/* Look-up table 9: Global Mask on 60-bits    Global Mask is applied in two cases:    (1 */
/* ) On general key generation, the global mask is ANDed with final result of key (after */
/*  choosing start offset, shift offsets and ORing of two parts of the key).     (2) On  */
/* comparison between HASH result to LUT entry that done by look-up engine.    Each Glob */
/* al Mask is represnted by one register in bibble (4-bit) resolution, i.e. value of glo */
/* bal_mask register = 0x13 means that the 60-bit key will be masked with following: 0xF */
/* 00FF                                                                                  */
/*****************************************************************************************/

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_R1_RESERVED_VALUE                                   ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_R1_RESERVED_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE             ( 0x0 )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_MASK_NIBBLE_CODE_MASK_NIBBLE_CODE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_OFFSET ( 0x00000250 )

#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_ADDRESS   	( IH_REGS_LOOKUP_CONFIGURATION_ADDRESS + IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_OFFSET )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_READ( r ) 	READ_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_ADDRESS ), (r) )
#define IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_WRITE( v )	WRITE_32( ( IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK ;
#else
typedef struct
{	uint32_t mask_nibble_code	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK_NIBBLE_CODE */
	uint32_t r1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_LOOKUP_CONFIGURATION_LKUP_TBL9_GL_MASK ;
#endif

/*****************************************************************************************/
/* DA_FILT0_VAL_L                                                                        */
/* Config DA filter 31:0                                                                 */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_OFFSET ( 0x00000000 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT0_MASK_L                                                                       */
/* Config DA Filter mask 15:0                                                            */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT0_MASK_L_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT0_MASK_L_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_OFFSET ( 0x00000004 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_MASK_L */
	uint32_t da_filt0_mask_l	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L ;
#else
typedef struct
{	uint32_t da_filt0_mask_l	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MASK_L */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L ;
#endif

/*****************************************************************************************/
/* DA_FILT0_CFG_H                                                                        */
/* DA Filter0 Value & Mask highest bits 15:0                                             */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_DA_FILT_MASK_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_DA_FILT_MASK_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_DA_FILT_VAL_MSB_FILTER_CONFIG_VALUE              ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_DA_FILT_VAL_MSB_FILTER_CONFIG_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_OFFSET ( 0x00000008 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_MASK_MSB */
	uint32_t da_filt_mask_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_VAL_MSB */
	uint32_t da_filt_val_msb 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H ;
#else
typedef struct
{	uint32_t da_filt_val_msb 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_VAL_MSB */
	uint32_t da_filt_mask_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MASK_MSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT0_CFG_H ;
#endif

/*****************************************************************************************/
/* PARSER_CFG                                                                            */
/* Parser Configuration                                                                  */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_RESERVED1_RESERVED_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_EXCEPTION_EN_0_DEFAULT_VALUE              ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_EXCEPTION_EN_0_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_PPP_CODE_1_IPV6_DEFAULT_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_PPP_CODE_1_IPV6_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_EXCEPTION_EN_RESET_VALUE                  ( 0xF )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_EXCEPTION_EN_RESET_VALUE_RESET_VALUE      ( 0xF )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_TCP_FLAGS_FILT_RESET_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_TCP_FLAGS_FILT_RESET_VALUE_RESET_VALUE    ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_OFFSET ( 0x0000000C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RESERVED */
	uint32_t reserved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exception_en_0 */
	uint32_t exception_en_0 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ppp_code_1_ipv6 */
	uint32_t ppp_code_1_ipv6	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EXCEPTION_EN */
	uint32_t exception_en   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCP_FLAGS_TCP_FILTER */
	uint32_t tcp_flags_filt 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG ;
#else
typedef struct
{	uint32_t tcp_flags_filt 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCP_FLAGS_TCP_FILTER */
	uint32_t exception_en   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EXCEPTION_EN */
	uint32_t ppp_code_1_ipv6	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ppp_code_1_ipv6 */
	uint32_t exception_en_0 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exception_en_0 */
	uint32_t reserved1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESERVED */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_PARSER_CFG ;
#endif

/*****************************************************************************************/
/* QTAG_Ethertype                                                                        */
/* Ethertype values to identify the presence of VLAN QTAG                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0_RESET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_OFFSET ( 0x00000010 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Ethertyp_for_Qtag_1 */
	uint32_t ethtype_qtag_1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ethertyp_for_Qtag_0 */
	uint32_t ethtype_qtag_0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE ;
#else
typedef struct
{	uint32_t ethtype_qtag_0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ethertyp_for_Qtag_0 */
	uint32_t ethtype_qtag_1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ethertyp_for_Qtag_1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE ;
#endif

/*****************************************************************************************/
/* QTAG_Nesting                                                                          */
/* Qtag Nesting config                                                                   */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED1_RESET_VALUE                 ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED1_RESET_VALUE_RESET_VALUE     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG5_NEST_DISABLED_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG5_NEST_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG4_NEST_DISABLED_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG4_NEST_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG3_NEST_DISABLED_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG3_NEST_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG2_NEST_RESET_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG2_NEST_RESET_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG1_NEST_DISABLED_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG1_NEST_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG0_NEST_DISABLED_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG0_NEST_DISABLED_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_OFFSET ( 0x00000014 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1 	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_5_Nesting_Config */
	uint32_t qtag5_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_4_Nesting_Config */
	uint32_t qtag4_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_3_Nesting_Config */
	uint32_t qtag3_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_2_Nesting_Config */
	uint32_t qtag2_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_1_Nesting_Config */
	uint32_t qtag1_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_0_Nesting_Config */
	uint32_t qtag0_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST ;
#else
typedef struct
{	uint32_t qtag0_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_0_Nesting_Config */
	uint32_t qtag1_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_1_Nesting_Config */
	uint32_t qtag2_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_2_Nesting_Config */
	uint32_t qtag3_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_3_Nesting_Config */
	uint32_t qtag4_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_4_Nesting_Config */
	uint32_t qtag5_nest	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* QTAG_5_Nesting_Config */
	uint32_t reserved1 	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_QTAG_NEST ;
#endif

/*****************************************************************************************/
/* Snap_organization_code                                                                */
/* Identifies SNAP tunneling organization code                                           */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED1_RESET_VALUE                 ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED1_RESET_VALUE_RESET_VALUE     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_DISABLED_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_DISABLED_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_ENABLED_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_DISABLED_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_ENABLED_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE_RESET_VALUE_RESET_VALUE          ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_OFFSET ( 0x00000018 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t reserved1 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* 802.1Q_ehternet_encapsulation */
	uint32_t en_8021q  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RFC1042_ethernet_encapsulation_enable */
	uint32_t en_rfc1042	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Organization_Code */
	uint32_t code      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE ;
#else
typedef struct
{	uint32_t code      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Organization_Code */
	uint32_t en_rfc1042	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RFC1042_ethernet_encapsulation_enable */
	uint32_t en_8021q  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* 802.1Q_ehternet_encapsulation */
	uint32_t reserved1 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE ;
#endif

/*****************************************************************************************/
/* User_Ethertype_configurtion_0_1                                                       */
/* Configures user Ethertype values                                                      */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0_RESET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_OFFSET ( 0x0000001C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* User_Ethertype_1 */
	uint32_t ethype_1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_0 */
	uint32_t ethype_0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1 ;
#else
typedef struct
{	uint32_t ethype_0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_0 */
	uint32_t ethype_1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1 ;
#endif

/*****************************************************************************************/
/* User_Ethertype_configurtion_2_3                                                       */
/* Configures user Ethertype values                                                      */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2_RESET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_OFFSET ( 0x00000020 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* User_Ethertype_3 */
	uint32_t ethype_3	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_2 */
	uint32_t ethype_2	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3 ;
#else
typedef struct
{	uint32_t ethype_2	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_2 */
	uint32_t ethype_3	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_3 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3 ;
#endif

/*****************************************************************************************/
/* User_Ethertype_Configuration                                                          */
/* Configure protocol and enables user Ethertype                                         */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RSV_RESET_VALUE                               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RSV_RESET_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN_RESET_VALUE                   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN_RESET_VALUE_RESET_VALUE       ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3_RESER_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3_RESER_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2_RESER_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2_RESER_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1_RESER_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1_RESER_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0_RESER_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0_RESER_VALUE_RESET_VALUE   ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_OFFSET ( 0x00000024 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* User_Ethertype_2_L3_Offset */
	uint32_t ethtype_user_offset_3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_2_L3_Offset */
	uint32_t ethtype_user_offset_2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_1_L3_Offset */
	uint32_t ethtype_user_offset_1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_0_L3_Offset */
	uint32_t ethtype_user_offset_0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
	uint32_t rsv                  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_Enable */
	uint32_t ethtype_user_en      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_3 */
	uint32_t ethtype_user_prot_3  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_2 */
	uint32_t ethtype_user_prot_2  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_1 */
	uint32_t ethtype_user_prot_1  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_0_protocol */
	uint32_t ethtype_user_prot_0  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG ;
#else
typedef struct
{	uint32_t ethtype_user_prot_0  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_0_protocol */
	uint32_t ethtype_user_prot_1  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_1 */
	uint32_t ethtype_user_prot_2  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_2 */
	uint32_t ethtype_user_prot_3  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_3 */
	uint32_t ethtype_user_en      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_Enable */
	uint32_t rsv                  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
	uint32_t ethtype_user_offset_0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_0_L3_Offset */
	uint32_t ethtype_user_offset_1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_1_L3_Offset */
	uint32_t ethtype_user_offset_2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_2_L3_Offset */
	uint32_t ethtype_user_offset_3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Ethertype_2_L3_Offset */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG ;
#endif

/*****************************************************************************************/
/* VID_Configuration_0_1                                                                 */
/* Config VID Filter 0 & 1                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_RESET_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED_0_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_RESET_VALUE_RESET_VALUE      ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_OFFSET ( 0x00000028 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* VID_1_Enable */
	uint32_t vid_1_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_1 */
	uint32_t vid_1     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_0_Enable */
	uint32_t vid_0_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_0 */
	uint32_t vid_0     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1 ;
#else
typedef struct
{	uint32_t vid_0     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_0 */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_0_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_0_Enable */
	uint32_t vid_1     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_1 */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_1_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_1_Enable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_0_1 ;
#endif

/*****************************************************************************************/
/* VID_Configuration_2_3                                                                 */
/* Config VID Filter 2 & 3                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_RESET_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED_0_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_RESET_VALUE_RESET_VALUE      ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_OFFSET ( 0x0000002C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* VID_3_Enable */
	uint32_t vid_3_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_3 */
	uint32_t vid_3     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_2_Enable */
	uint32_t vid_2_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_2 */
	uint32_t vid_2     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3 ;
#else
typedef struct
{	uint32_t vid_2     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_2 */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_2_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_2_Enable */
	uint32_t vid_3     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_3 */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_3_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_3_Enable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_2_3 ;
#endif

/*****************************************************************************************/
/* VID_Configuration_4_5                                                                 */
/* Config VID Filter 4 & 5                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_RESET_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED_0_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_RESET_VALUE_RESET_VALUE      ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_OFFSET ( 0x00000030 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* VID_5_Enable */
	uint32_t vid_5_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_5 */
	uint32_t vid_5     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_4_Enable */
	uint32_t vid_4_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_4 */
	uint32_t vid_4     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5 ;
#else
typedef struct
{	uint32_t vid_4     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_4 */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_4_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_4_Enable */
	uint32_t vid_5     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_5 */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_5_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_5_Enable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_4_5 ;
#endif

/*****************************************************************************************/
/* VID_Configuration_6_7                                                                 */
/* Config VID Filter 6 & 7                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_RESET_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED_0_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_RESET_VALUE_RESET_VALUE      ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_OFFSET ( 0x00000034 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* VID_7_Enable */
	uint32_t vid_7_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_7 */
	uint32_t vid_7     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_6_Enable */
	uint32_t vid_6_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_6 */
	uint32_t vid_6     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7 ;
#else
typedef struct
{	uint32_t vid_6     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_6 */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_6_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_6_Enable */
	uint32_t vid_7     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_7 */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_7_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_7_Enable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_6_7 ;
#endif

/*****************************************************************************************/
/* VID_Configuration_8_9                                                                 */
/* Config VID Filter 8 & 9                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_9_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_9_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_9_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_RESERVED_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_RESERVED_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_9_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_9_RESET_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_8_EN_RESET_VALUE               ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_8_EN_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_8_EN_ENABLE_VALUE              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_RESERVED_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_RESERVED_0_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_8_RESET_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_VID_8_RESET_VALUE_RESET_VALUE      ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_OFFSET ( 0x00000038 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* VID_9_Enable */
	uint32_t vid_9_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_9 */
	uint32_t vid_9     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_8_Enable */
	uint32_t vid_8_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_8 */
	uint32_t vid_8     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9 ;
#else
typedef struct
{	uint32_t vid_8     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_8 */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_8_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_8_Enable */
	uint32_t vid_9     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_9 */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_9_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_9_Enable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_8_9 ;
#endif

/*****************************************************************************************/
/* VID_Configuration_10_11                                                               */
/* Config VID Filter 10 & 11                                                             */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_11_EN_RESET_VALUE              ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_11_EN_RESET_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_11_EN_ENABLE_VALUE             ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_RESERVED_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_RESERVED_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_11_RESET_VALUE                 ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_11_RESET_VALUE_RESET_VALUE     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_10_EN_RESET_VALUE              ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_10_EN_RESET_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_10_EN_ENABLE_VALUE             ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_RESERVED_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_RESERVED_0_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_10_RESET_VALUE                 ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_VID_10_RESET_VALUE_RESET_VALUE     ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_OFFSET ( 0x0000003C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* VID_11_Enable */
	uint32_t vid_11_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_11 */
	uint32_t vid_11    	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_10_Enable */
	uint32_t vid_10_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_10 */
	uint32_t vid_10    	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11 ;
#else
typedef struct
{	uint32_t vid_10    	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_10 */
	uint32_t reserved_0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_10_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_10_Enable */
	uint32_t vid_11    	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_11 */
	uint32_t reserved_1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t vid_11_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VID_11_Enable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_VID_10_11 ;
#endif

/*****************************************************************************************/
/* User_defined_IP_Protocl                                                               */
/* IP Protocols to be matched to IP Protocol field and to be indicated in the output sum */
/* mary word                                                                             */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0_RESET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_OFFSET ( 0x00000040 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* USER__IP_protocol_3 */
	uint32_t user_ip_prot_3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USER_IP_protocol_2 */
	uint32_t user_ip_prot_2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USER_IP_protocol_1 */
	uint32_t user_ip_prot_1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USER_IP_protocol_0 */
	uint32_t user_ip_prot_0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT ;
#else
typedef struct
{	uint32_t user_ip_prot_0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USER_IP_protocol_0 */
	uint32_t user_ip_prot_1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USER_IP_protocol_1 */
	uint32_t user_ip_prot_2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USER_IP_protocol_2 */
	uint32_t user_ip_prot_3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USER__IP_protocol_3 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_USER_IP_PROT ;
#endif

/*****************************************************************************************/
/* PPP_IP_Protocol_Code                                                                  */
/* PPP Protocol Code to indicate L3 is IP                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1_RESET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0_RESET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_OFFSET ( 0x00000044 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PPP_Protocol_Code_1 */
	uint32_t ppp_code_1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PPP_Protocol_Code_0 */
	uint32_t ppp_code_0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE ;
#else
typedef struct
{	uint32_t ppp_code_0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PPP_Protocol_Code_0 */
	uint32_t ppp_code_1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PPP_Protocol_Code_1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE ;
#endif

/*****************************************************************************************/
/* IP_FILTER0_CFG                                                                        */
/* Config the IP Address filtering.   Notice that the enable bit is located in the IP_FI */
/* LTERS_CFG[4]                                                                          */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_OFFSET ( 0x00000048 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address */
	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG ;
#else
typedef struct
{	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTER1_CFG                                                                        */
/* Config the IP Address filtering.   Notice that the enable bit is located in the IP_FI */
/* LTERS_CFG[5]                                                                          */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_OFFSET ( 0x0000004C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address */
	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG ;
#else
typedef struct
{	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTER2_CFG                                                                        */
/* Config the IP Address filtering.   Notice that the enable bit is located in the IP_FI */
/* LTERS_CFG[6]                                                                          */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_OFFSET ( 0x00000050 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address */
	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG ;
#else
typedef struct
{	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTER3_CFG                                                                        */
/* Config the IP Address filtering.   Notice that the enable bit is located in the IP_FI */
/* LTERS_CFG[7]                                                                          */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_IP_ADDRESS_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_OFFSET ( 0x00000054 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address */
	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG ;
#else
typedef struct
{	uint32_t ip_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_CFG ;
#endif

/*****************************************************************************************/
/* DA_FILT1_VAL_L                                                                        */
/* Config DA filter1 31:0                                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_OFFSET ( 0x00000058 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT1_MASK_L                                                                       */
/* Config DA Filter1 mask 31:0                                                           */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT0_MASK_L_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT0_MASK_L_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_OFFSET ( 0x0000005C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_MASK_L */
	uint32_t da_filt0_mask_l	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L ;
#else
typedef struct
{	uint32_t da_filt0_mask_l	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MASK_L */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L ;
#endif

/*****************************************************************************************/
/* DA_FILT1_CFG_H                                                                        */
/* DA Filter1 Value & Mask highest bits 15:0                                             */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_DA_FILT_MASK_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_DA_FILT_MASK_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_DA_FILT_VAL_MSB_FILTER_CONFIG_VALUE              ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_DA_FILT_VAL_MSB_FILTER_CONFIG_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_OFFSET ( 0x00000060 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_MASK_MSB */
	uint32_t da_filt_mask_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_VAL_MSB */
	uint32_t da_filt_val_msb 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H ;
#else
typedef struct
{	uint32_t da_filt_val_msb 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_VAL_MSB */
	uint32_t da_filt_mask_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MASK_MSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT1_CFG_H ;
#endif

/*****************************************************************************************/
/* DA_FILT2_VAL_L                                                                        */
/* Config DA filter2 31:0                                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_OFFSET ( 0x00000064 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT2_VAL_H                                                                        */
/* Config DA filter2 47:32                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RSV_FILTER_CONFIG_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RSV_FILTER_CONFIG_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_OFFSET ( 0x00000068 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H ;
#else
typedef struct
{	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H ;
#endif

/*****************************************************************************************/
/* DA_FILT3_VAL_L                                                                        */
/* Config DA filter3 31:0                                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_OFFSET ( 0x0000006C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT3_VAL_H                                                                        */
/* Config DA filter3 47:32                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RSV_FILTER_CONFIG_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RSV_FILTER_CONFIG_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_OFFSET ( 0x00000070 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H ;
#else
typedef struct
{	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H ;
#endif

/*****************************************************************************************/
/* DA_FILT4_VAL_L                                                                        */
/* Config DA filter4 31:0                                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_OFFSET ( 0x00000074 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT4_VAL_H                                                                        */
/* Config DA Filter4 47:32                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RSV_FILTER_CONFIG_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RSV_FILTER_CONFIG_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_OFFSET ( 0x00000078 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H ;
#else
typedef struct
{	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H ;
#endif

/*****************************************************************************************/
/* DA_FILT5_VAL_L                                                                        */
/* Config DA filter5 31:0                                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_OFFSET ( 0x0000007C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT5_VAL_H                                                                        */
/* Config DA Filter5 47:32                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RSV_FILTER_CONFIG_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RSV_FILTER_CONFIG_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_OFFSET ( 0x00000080 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H ;
#else
typedef struct
{	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H ;
#endif

/*****************************************************************************************/
/* DA_FILT_VALID_CFG                                                                     */
/* Valid configuration of all DA filters: there is a dedicated bit per each DA filter th */
/* at says if the current DA filter is valid or not. Used for on-the-fly DA filter value */
/*  (mask) modifications, since the DA filter parameters are not assigned on single SW r */
/* egister.                                                                              */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_RSV_FILTER_CONFIG_VALUE                    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_RSV_FILTER_CONFIG_VALUE_RESET_VALUE        ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT7_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT7_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT7_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT6_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT6_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT6_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT5_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT5_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT5_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT4_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT4_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT4_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT3_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT3_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT3_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT2_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT2_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT2_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT1_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT1_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT1_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT0_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT0_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_DA_FILT0_VALID_VALID_VALUE                 ( 0x1 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_OFFSET ( 0x00000084 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv           	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT7_VALID */
	uint32_t da_filt7_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT6_VALID */
	uint32_t da_filt6_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT5_VALID */
	uint32_t da_filt5_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT4_VALID */
	uint32_t da_filt4_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT3_VALID */
	uint32_t da_filt3_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT2_VALID */
	uint32_t da_filt2_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT1_VALID */
	uint32_t da_filt1_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT0_VALID */
	uint32_t da_filt0_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG ;
#else
typedef struct
{	uint32_t da_filt0_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT0_VALID */
	uint32_t da_filt1_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT1_VALID */
	uint32_t da_filt2_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT2_VALID */
	uint32_t da_filt3_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT3_VALID */
	uint32_t da_filt4_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT4_VALID */
	uint32_t da_filt5_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT5_VALID */
	uint32_t da_filt6_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT6_VALID */
	uint32_t da_filt7_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT7_VALID */
	uint32_t rsv           	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTER0_MASK_CFG                                                                   */
/* Config the IP Address masking.   Notice that the enable bit is located in the IP_FILT */
/* ERS_CFG[4]                                                                            */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_OFFSET ( 0x00000088 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address_mask */
	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG ;
#else
typedef struct
{	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address_mask */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTER1_MASK_CFG                                                                   */
/* Config the IP Address masking.   Notice that the enable bit is located in the IP_FILT */
/* ERS_CFG[5]                                                                            */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_OFFSET ( 0x0000008C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address_mask */
	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG ;
#else
typedef struct
{	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address_mask */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTER2_MASK_CFG                                                                   */
/* Config the IP Address masking.   Notice that the enable bit is located in the IP_FILT */
/* ERS_CFG[6]                                                                            */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_OFFSET ( 0x00000090 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address_mask */
	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG ;
#else
typedef struct
{	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address_mask */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER2_MASK_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTER3_MASK_CFG                                                                   */
/* Config the IP Address masking.   Notice that the enable bit is located in the IP_FILT */
/* ERS_CFG[7]                                                                            */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_IP_ADDRESS_MASK_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_OFFSET ( 0x00000094 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IP_address_mask */
	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG ;
#else
typedef struct
{	uint32_t ip_address_mask	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_address_mask */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTER3_MASK_CFG ;
#endif

/*****************************************************************************************/
/* IP_FILTERS_CFG                                                                        */
/* IP Address Filters (0..3) configurations:    (1) SIP or DIP selection config per each */
/*  filter  (1) Valid bit per each filter                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RSV_NON_VALID_VALUE                          ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RSV_NON_VALID_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RSV_VALID_VALUE                              ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_SIP_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_SIP_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_DIP_VALUE                  ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_SIP_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_SIP_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_DIP_VALUE                  ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_SIP_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_SIP_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_DIP_VALUE                  ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_SIP_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_SIP_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_DIP_VALUE                  ( 0x1 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_OFFSET ( 0x00000098 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv              	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER3_VALID */
	uint32_t ip_filter3_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER2_VALID */
	uint32_t ip_filter2_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER1_VALID */
	uint32_t ip_filter1_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER0_VALID */
	uint32_t ip_filter0_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER3_DIP_EN */
	uint32_t ip_filter3_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER2_DIP_EN */
	uint32_t ip_filter2_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER1_DIP_EN */
	uint32_t ip_filter1_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER0_DIP_EN */
	uint32_t ip_filter0_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG ;
#else
typedef struct
{	uint32_t ip_filter0_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER0_DIP_EN */
	uint32_t ip_filter1_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER1_DIP_EN */
	uint32_t ip_filter2_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER2_DIP_EN */
	uint32_t ip_filter3_dip_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER3_DIP_EN */
	uint32_t ip_filter0_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER0_VALID */
	uint32_t ip_filter1_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER1_VALID */
	uint32_t ip_filter2_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER2_VALID */
	uint32_t ip_filter3_valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IP_FILTER3_VALID */
	uint32_t rsv              	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG ;
#endif

/*****************************************************************************************/
/* GRE_PROTOCOL_CFG                                                                      */
/* GRE Protocol                                                                          */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RSV_NON_VALID_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RSV_NON_VALID_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RSV_VALID_VALUE                         ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL_PROTOCOL_VALUE             ( 0x880B )
#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL_PROTOCOL_VALUE_RESET_VALUE ( 0x880B )


#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_OFFSET ( 0x0000009C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv         	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GRE_PROTOCOL */
	uint32_t gre_protocol	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG ;
#else
typedef struct
{	uint32_t gre_protocol	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GRE_PROTOCOL */
	uint32_t rsv         	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R0                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 0 that stores convetion code for the follow */
/* ing DSCP values: 0x0..0x7.    Used for conversion in case of IP untagged packet    Th */
/* e coding of each field is done in the following way:  TCI converted field should matc */
/* h DSCP index (from 0 to 63). This index is applied by the following equation: registe */
/* r_index*8+octet(or field) index                                                       */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_OFFSET ( 0x00000100 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R0 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R1                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 1 that stores convetion code for the follow */
/* ing DSCP values: 0x8..0xf.    Used for conversion in case of IP untagged packet    Th */
/* e coding of each field is done in the following way:  TCI converted field should matc */
/* h DSCP index (from 0 to 63). This index is applied by the following equation: registe */
/* r_index*8+octet(or field) index                                                       */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_OFFSET ( 0x00000104 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R1 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R2                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 2 that stores convetion code for the follow */
/* ing DSCP values: 0x10..0x17.    Used for conversion in case of IP untagged packet     */
/* The coding of each field is done in the following way:  TCI converted field should ma */
/* tch DSCP index (from 0 to 63). This index is applied by the following equation: regis */
/* ter_index*8+octet(or field) index                                                     */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_OFFSET ( 0x00000108 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R2 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R3                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 3 that stores convetion code for the follow */
/* ing DSCP values: 0x18..0x1f.    Used for conversion in case of IP untagged packet     */
/* The coding of each field is done in the following way:  TCI converted field should ma */
/* tch DSCP index (from 0 to 63). This index is applied by the following equation: regis */
/* ter_index*8+octet(or field) index                                                     */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_OFFSET ( 0x0000010C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R3 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R4                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 4 that stores conversion code for the follo */
/* wing DSCP values: 0x20..0x27.    Used for conversion in case of IP untagged packet    */
/*  The coding of each field is done in the following way:  TCI converted field should m */
/* atch DSCP index (from 0 to 63). This index is applied by the following equation: regi */
/* ster_index*8+octet(or field) index                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_OFFSET ( 0x00000110 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R4 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R5                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 5 that stores conversion code for the follo */
/* wing DSCP values: 0x28..0x2f.    Used for conversion in case of IP untagged packet    */
/*  The coding of each field is done in the following way:  TCI converted field should m */
/* atch DSCP index (from 0 to 63). This index is applied by the following equation: regi */
/* ster_index*8+octet(or field) index                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_OFFSET ( 0x00000114 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R5 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R6                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 6 that stores conversion code for the follo */
/* wing DSCP values: 0x30..0x37.    Used for conversion in case of IP untagged packet    */
/*  The coding of each field is done in the following way:  TCI converted field should m */
/* atch DSCP index (from 0 to 63). This index is applied by the following equation: regi */
/* ster_index*8+octet(or field) index                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_OFFSET ( 0x00000118 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R6 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL0_R7                                                                      */
/* DSCP to TCI Conversion Table 0.  Register 7 that stores conversion code for the follo */
/* wing DSCP values: 0x3c..0x3f.    Used for conversion in case of IP untagged packet    */
/*    The coding of each field is done in the following way:  TCI converted field should */
/*  match DSCP index (from 0 to 63). This index is applied by the following equation: re */
/* gister_index*8+octet(or field) index                                                  */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_OFFSET ( 0x0000011C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL0_R7 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R0                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 0 that stores convetion code for the follow */
/* ing DSCP values: 0x0..0x7.    Used for conversion in case of IP untagged packet    Th */
/* e coding of each field is done in the following way:  TCI converted field should matc */
/* h DSCP index (from 0 to 63). This index is applied by the following equation: registe */
/* r_index*8+octet(or field) index                                                       */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_OFFSET ( 0x00000120 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R0 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R1                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 1 that stores convetion code for the follow */
/* ing DSCP values: 0x8..0xf.    Used for conversion in case of IP untagged packet    Th */
/* e coding of each field is done in the following way:  TCI converted field should matc */
/* h DSCP index (from 0 to 63). This index is applied by the following equation: registe */
/* r_index*8+octet(or field) index                                                       */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_OFFSET ( 0x00000124 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R1 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R2                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 2 that stores convetion code for the follow */
/* ing DSCP values: 0x10..0x17.    Used for conversion in case of IP untagged packet     */
/* The coding of each field is done in the following way:  TCI converted field should ma */
/* tch DSCP index (from 0 to 63). This index is applied by the following equation: regis */
/* ter_index*8+octet(or field) index                                                     */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_OFFSET ( 0x00000128 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R2 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R3                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 3 that stores convetion code for the follow */
/* ing DSCP values: 0x18..0x1f.    Used for conversion in case of IP untagged packet     */
/* The coding of each field is done in the following way:  TCI converted field should ma */
/* tch DSCP index (from 0 to 63). This index is applied by the following equation: regis */
/* ter_index*8+octet(or field) index                                                     */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_OFFSET ( 0x0000012C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R3 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R4                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 4 that stores conversion code for the follo */
/* wing DSCP values: 0x20..0x27.    Used for conversion in case of IP untagged packet    */
/*  The coding of each field is done in the following way:  TCI converted field should m */
/* atch DSCP index (from 0 to 63). This index is applied by the following equation: regi */
/* ster_index*8+octet(or field) index                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_OFFSET ( 0x00000130 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R4 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R5                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 5 that stores conversion code for the follo */
/* wing DSCP values: 0x28..0x2f.    Used for conversion in case of IP untagged packet    */
/*  The coding of each field is done in the following way:  TCI converted field should m */
/* atch DSCP index (from 0 to 63). This index is applied by the following equation: regi */
/* ster_index*8+octet(or field) index                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_OFFSET ( 0x00000134 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R5 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R6                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 6 that stores conversion code for the follo */
/* wing DSCP values: 0x30..0x37.    Used for conversion in case of IP untagged packet    */
/*  The coding of each field is done in the following way:  TCI converted field should m */
/* atch DSCP index (from 0 to 63). This index is applied by the following equation: regi */
/* ster_index*8+octet(or field) index                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_OFFSET ( 0x00000138 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R6 ;
#endif

/*****************************************************************************************/
/* DSCP2TCI_TBL1_R7                                                                      */
/* DSCP to TCI Conversion Table 1.  Register 7 that stores conversion code for the follo */
/* wing DSCP values: 0x3c..0x3f.    Used for conversion in case of IP untagged packet    */
/*  The coding of each field is done in the following way:  TCI converted field should m */
/* atch DSCP index (from 0 to 63). This index is applied by the following equation: regi */
/* ster_index*8+octet(or field) index                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV8_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV8_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O7_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O7_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV7_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV7_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O6_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O6_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV6_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV6_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O5_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O5_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV5_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV5_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O4_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O4_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV4_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV4_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O3_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O3_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV3_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV3_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O2_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O2_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV2_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O1_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O1_TCI_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV1_RSV_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_RSV1_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O0_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_DSCP_O0_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_OFFSET ( 0x0000013C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv8 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7 ;
#else
typedef struct
{	uint32_t dscp_o0	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O0 */
	uint32_t rsv1   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dscp_o1	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O1 */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t dscp_o2	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O2 */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t dscp_o3	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O3 */
	uint32_t rsv4   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
	uint32_t dscp_o4	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O4 */
	uint32_t rsv5   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv5 */
	uint32_t dscp_o5	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O5 */
	uint32_t rsv6   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv6 */
	uint32_t dscp_o6	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O6 */
	uint32_t rsv7   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv7 */
	uint32_t dscp_o7	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSCP_O7 */
	uint32_t rsv8   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv8 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP2TCI_TBL1_R7 ;
#endif

/*****************************************************************************************/
/* DEFAULT_TCI_TBL0                                                                      */
/* Default TCI Table 0.  Used for conversion in case of non-IP untagged packet           */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_RSV_RSV_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_RSV_RSV_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_DEFAULT_TCI_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_DEFAULT_TCI_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_OFFSET ( 0x00000140 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DEFAULT_TCI */
	uint32_t default_tci	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0 ;
#else
typedef struct
{	uint32_t default_tci	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DEFAULT_TCI */
	uint32_t rsv        	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL0 ;
#endif

/*****************************************************************************************/
/* DEFAULT_TCI_TBL1                                                                      */
/* Default TCI Table 1.  Used for conversion in case of non-IP untagged packet           */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_RSV_RSV_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_RSV_RSV_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_DEFAULT_TCI_TCI_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_DEFAULT_TCI_TCI_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_OFFSET ( 0x00000144 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DEFAULT_TCI */
	uint32_t default_tci	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1 ;
#else
typedef struct
{	uint32_t default_tci	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DEFAULT_TCI */
	uint32_t rsv        	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DEFAULT_TCI_TBL1 ;
#endif

/*****************************************************************************************/
/* DSCP_TBL_VALID_CFG                                                                    */
/* Valid configuration of DSCP Tables                                                    */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_RSV_FILTER_CONFIG_VALUE                ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_RSV_FILTER_CONFIG_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_TBL1_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_TBL1_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_TBL1_VALID_VALID_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_TBL0_VALID_NON_VALID_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_TBL0_VALID_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_TBL0_VALID_VALID_VALUE                 ( 0x1 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_OFFSET ( 0x00000148 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TBL1_VALID */
	uint32_t tbl1_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TBL0_VALID */
	uint32_t tbl0_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG ;
#else
typedef struct
{	uint32_t tbl0_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TBL0_VALID */
	uint32_t tbl1_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TBL1_VALID */
	uint32_t rsv       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DSCP_TBL_VALID_CFG ;
#endif

/*****************************************************************************************/
/* DA_FILT6_VAL_L                                                                        */
/* Config DA filter6 31:0                                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_OFFSET ( 0x0000014C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT6_VAL_H                                                                        */
/* Config DA Filter6 47:32                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RSV_FILTER_CONFIG_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RSV_FILTER_CONFIG_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_OFFSET ( 0x00000150 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H ;
#else
typedef struct
{	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H ;
#endif

/*****************************************************************************************/
/* DA_FILT7_VAL_L                                                                        */
/* Config DA filter7 31:0                                                                */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_OFFSET ( 0x00000154 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DA_FILT_LSB */
	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L ;
#else
typedef struct
{	uint32_t da_filt_lsb	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_LSB */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L ;
#endif

/*****************************************************************************************/
/* DA_FILT7_VAL_H                                                                        */
/* Config DA Filter7 47:32                                                               */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RSV_FILTER_CONFIG_VALUE                     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RSV_FILTER_CONFIG_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB_FILTER_CONFIG_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_OFFSET ( 0x00000158 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H ;
#else
typedef struct
{	uint32_t da_filt_msb	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DA_FILT_MSB */
	uint32_t rsv        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H ;
#endif

/*****************************************************************************************/
/* IPV6_HDR_EXT_FLTR_MASK_CFG                                                            */
/* IPV6 Header Extension Filter Mask register                                            */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RSV_FILTER_CONFIG_VALUE                 ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RSV_FILTER_CONFIG_VALUE_RESET_VALUE     ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_MASK_VALUE                  ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_MASK_VALUE_RESET_VALUE      ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_UNMASK_VALUE                ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_MASK_VALUE                   ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_MASK_VALUE_RESET_VALUE       ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_UNMASK_VALUE                 ( 0x1 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_MASK_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_MASK_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_UNMASK_VALUE           ( 0x1 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_OFFSET ( 0x0000015C )

#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv             	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dest_opt_eh */
	uint32_t dest_opt_eh     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* routing_eh */
	uint32_t routing_eh      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hop_by_hop_match */
	uint32_t hop_by_hop_match	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG ;
#else
typedef struct
{	uint32_t hop_by_hop_match	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hop_by_hop_match */
	uint32_t routing_eh      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* routing_eh */
	uint32_t dest_opt_eh     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dest_opt_eh */
	uint32_t rsv             	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG ;
#endif

/*****************************************************************************************/
/* ENG                                                                                   */
/* Engineering Configuration reserved for Broadlight use                                 */
/*****************************************************************************************/

#define IH_REGS_PARSER_CORE_CONFIGURATION_ENG_CFG_RESET_VALUE             ( 0x0 )
#define IH_REGS_PARSER_CORE_CONFIGURATION_ENG_CFG_RESET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_PARSER_CORE_CONFIGURATION_ENG_OFFSET ( 0x00000160 )

#define IH_REGS_PARSER_CORE_CONFIGURATION_ENG_ADDRESS   	( IH_REGS_PARSER_CORE_CONFIGURATION_ADDRESS + IH_REGS_PARSER_CORE_CONFIGURATION_ENG_OFFSET )
#define IH_REGS_PARSER_CORE_CONFIGURATION_ENG_READ( r ) 	READ_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_ENG_ADDRESS ), (r) )
#define IH_REGS_PARSER_CORE_CONFIGURATION_ENG_WRITE( v )	WRITE_32( ( IH_REGS_PARSER_CORE_CONFIGURATION_ENG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* CFG */
	uint32_t cfg	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_ENG ;
#else
typedef struct
{	uint32_t cfg	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CFG */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_PARSER_CORE_CONFIGURATION_ENG ;
#endif

/*****************************************************************************************/
/* SP2IQ_MAP_CFG                                                                         */
/* Source Port mapping to IH Ingress Queue num, says per physical port to which IQ it be */
/* longs (from 0 to 7)                                                                   */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_RNRB_IQ_MAP_MAP_VALUE_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_RNRB_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_RNRA_IQ_MAP_MAP_VALUE_VALUE             ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_RNRA_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_GPON_IQ_MAP_MAP_VALUE_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_GPON_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH4_IQ_MAP_MAP_VALUE_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH4_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH3_IQ_MAP_MAP_VALUE_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH3_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH2_IQ_MAP_MAP_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH2_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH1_IQ_MAP_MAP_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH1_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH0_IQ_MAP_MAP_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ETH0_IQ_MAP_MAP_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_OFFSET ( 0x00000000 )

#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RNRB_IQ_MAP */
	uint32_t rnrb_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_IQ_MAP */
	uint32_t rnra_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_IQ_MAP */
	uint32_t gpon_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_IQ_MAP */
	uint32_t eth4_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_IQ_MAP */
	uint32_t eth3_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_IQ_MAP */
	uint32_t eth2_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_IQ_MAP */
	uint32_t eth1_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_IQ_MAP */
	uint32_t eth0_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG ;
#else
typedef struct
{	uint32_t eth0_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_IQ_MAP */
	uint32_t eth1_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_IQ_MAP */
	uint32_t eth2_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_IQ_MAP */
	uint32_t eth3_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_IQ_MAP */
	uint32_t eth4_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_IQ_MAP */
	uint32_t gpon_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_IQ_MAP */
	uint32_t rnra_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_IQ_MAP */
	uint32_t rnrb_iq_map	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_IQ_MAP */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_SP2IQ_MAP_CFG ;
#endif

/*****************************************************************************************/
/* IQ_BASE_CFG                                                                           */
/* Base location of each Ingres Queue in 16-entry IQ array.  Note: this configuration sh */
/* ould be aligned with configuration of IQ size.    Default configuration of IQ array:  */
/*    IQ#  Port   Num of Ingres Buffers  ==================================  0  : Eth0 : */
/*     2   1  : Eth1 :    2   2  : Eth2 :    2   3  : Eth3 :    2   4  : Eth4 :    2  5  */
/*  : GPON :    4  6  : RNRA :    1  7  : RNRB :    1                                    */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ7_BASE_BASE_VALUE_VALUE             ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ7_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ6_BASE_BASE_VALUE_VALUE             ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ6_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ5_BASE_BASE_VALUE_VALUE             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ5_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ4_BASE_BASE_VALUE_VALUE             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ4_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ3_BASE_BASE_VALUE_VALUE             ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ3_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ2_BASE_BASE_VALUE_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ2_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ1_BASE_BASE_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ1_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ0_BASE_BASE_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_IQ0_BASE_BASE_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_OFFSET ( 0x00000004 )

#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IQ7_BASE */
	uint32_t iq7_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_BASE */
	uint32_t iq6_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_BASE */
	uint32_t iq5_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_BASE */
	uint32_t iq4_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_BASE */
	uint32_t iq3_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_BASE */
	uint32_t iq2_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_BASE */
	uint32_t iq1_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_BASE */
	uint32_t iq0_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG ;
#else
typedef struct
{	uint32_t iq0_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_BASE */
	uint32_t iq1_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_BASE */
	uint32_t iq2_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_BASE */
	uint32_t iq3_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_BASE */
	uint32_t iq4_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_BASE */
	uint32_t iq5_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_BASE */
	uint32_t iq6_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_BASE */
	uint32_t iq7_base	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ7_BASE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQ_BASE_CFG ;
#endif

/*****************************************************************************************/
/* IQ_SIZE_CFG                                                                           */
/* Size (= num of ingress buffers) per each Ingres Queue in 16-entry IQ array.    Note:  */
/* this configuration should be aligned with configuration of IQ base.  Total num of ent */
/* eties should be <= 16  Note: value 0x0 means that number of entries is sixteen!!    D */
/* efault configuration of IQ array:    IQ#  Port   Num of Ingres Buffers  ============= */
/* =====================  0  : Eth0 :    2   1  : Eth1 :    2   2  : Eth2 :    2   3  :  */
/* Eth3 :    2   4  : Eth4 :    2  5  : GPON :    4  6  : RNRA :    1  7  : RNRB :    1  */
/*                                                                                       */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ7_SIZE_SIZE_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ7_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ6_SIZE_SIZE_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ6_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ5_SIZE_SIZE_VALUE_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ5_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ4_SIZE_SIZE_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ4_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ3_SIZE_SIZE_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ3_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ2_SIZE_SIZE_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ2_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ1_SIZE_SIZE_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ1_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ0_SIZE_SIZE_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_IQ0_SIZE_SIZE_VALUE_VALUE_RESET_VALUE ( 0x2 )


#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_OFFSET ( 0x00000008 )

#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IQ7_SIZE */
	uint32_t iq7_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_SIZE */
	uint32_t iq6_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_SIZE */
	uint32_t iq5_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_SIZE */
	uint32_t iq4_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_SIZE */
	uint32_t iq3_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_SIZE */
	uint32_t iq2_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_SIZE */
	uint32_t iq1_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_SIZE */
	uint32_t iq0_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG ;
#else
typedef struct
{	uint32_t iq0_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_SIZE */
	uint32_t iq1_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_SIZE */
	uint32_t iq2_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_SIZE */
	uint32_t iq3_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_SIZE */
	uint32_t iq4_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_SIZE */
	uint32_t iq5_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_SIZE */
	uint32_t iq6_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_SIZE */
	uint32_t iq7_size	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ7_SIZE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQ_SIZE_CFG ;
#endif

/*****************************************************************************************/
/* IQL_PRIOR_CFG                                                                         */
/* Priority of each Ingres Queues [3...0].    Note: this configuration defined by one ho */
/* t (8 bits max)    Default configuration of IQ array:    IQ#  Port   Priority  ======= */
/* ===========================  0  : Eth0 :    8b010   1  : Eth1 :    8b010   2  : Eth2  */
/* :    8b010   3  : Eth3 :    8b010   4  : Eth4 :    8b010  5  : GPON :    8b100  6  :  */
/* RNRA :    8b001  7  : RNRB :    8b001                                                 */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ3_PRIOR_PRIOR_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ3_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ2_PRIOR_PRIOR_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ2_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ1_PRIOR_PRIOR_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ1_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ0_PRIOR_PRIOR_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_IQ0_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x2 )


#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_OFFSET ( 0x0000000C )

#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IQ3_PRIOR */
	uint32_t iq3_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_PRIOR */
	uint32_t iq2_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_PRIOR */
	uint32_t iq1_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_PRIOR */
	uint32_t iq0_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG ;
#else
typedef struct
{	uint32_t iq0_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_PRIOR */
	uint32_t iq1_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_PRIOR */
	uint32_t iq2_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_PRIOR */
	uint32_t iq3_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_PRIOR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQL_PRIOR_CFG ;
#endif

/*****************************************************************************************/
/* IQH_PRIOR_CFG                                                                         */
/* Priority of each Ingres Queues [7...4].    Note: this configuration defined by one ho */
/* t (8 bits max)    Default configuration of IQ array:    IQ#  Port   Priority  ======= */
/* ===========================  0  : Eth0 :    8b010   1  : Eth1 :    8b010   2  : Eth2  */
/* :    8b010   3  : Eth3 :    8b010   4  : Eth4 :    8b010  5  : GPON :    8b100  6  :  */
/* RNRA :    8b001  7  : RNRB :    8b001                                                 */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ7_PRIOR_PRIOR_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ7_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ6_PRIOR_PRIOR_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ6_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ5_PRIOR_PRIOR_VALUE_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ5_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ4_PRIOR_PRIOR_VALUE_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_IQ4_PRIOR_PRIOR_VALUE_VALUE_RESET_VALUE ( 0x2 )


#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_OFFSET ( 0x00000010 )

#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IQ7_PRIOR */
	uint32_t iq7_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_PRIOR */
	uint32_t iq6_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_PRIOR */
	uint32_t iq5_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_PRIOR */
	uint32_t iq4_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG ;
#else
typedef struct
{	uint32_t iq4_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_PRIOR */
	uint32_t iq5_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_PRIOR */
	uint32_t iq6_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_PRIOR */
	uint32_t iq7_prior	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ7_PRIOR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQH_PRIOR_CFG ;
#endif

/*****************************************************************************************/
/* PHL_OFFSET_CFG                                                                        */
/* Packet Header offset per Ingres Physical port in byte resolution    Note: this config */
/* uration says where the Header of packet is started. This configuration is used both b */
/* y Parser and by Egress Queue DMA. The motivation: store room in the beginning of Runn */
/* er Buffer for FW    Default configuration of Packet Header offset is 0x0.             */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV4_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV4_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH3_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH3_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV3_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV3_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH2_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH2_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV2_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV2_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH1_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH1_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV1_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_RSV1_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH0_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ETH0_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_OFFSET ( 0x00000014 )

#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV4 */
	uint32_t rsv4          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_PH_OFFSET */
	uint32_t eth3_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t rsv3          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_PH_OFFSET */
	uint32_t eth2_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t rsv2          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_PH_OFFSET */
	uint32_t eth1_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_PH_OFFSET */
	uint32_t eth0_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG ;
#else
typedef struct
{	uint32_t eth0_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_PH_OFFSET */
	uint32_t rsv1          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t eth1_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_PH_OFFSET */
	uint32_t rsv2          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t eth2_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_PH_OFFSET */
	uint32_t rsv3          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t eth3_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_PH_OFFSET */
	uint32_t rsv4          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV4 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_PHL_OFFSET_CFG ;
#endif

/*****************************************************************************************/
/* PHH_OFFSET_CFG                                                                        */
/* Packet Header offset per Ingres Physical port in byte resolution    Note: this config */
/* uration says where the Header of packet is started. This configuration is used both b */
/* y Parser and by Egress Queue DMA. The motivation: store room in the beginning of Runn */
/* er Buffer for FW    Default configuration of Packet Header offset is 0x0.             */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV4_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV4_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RNRB_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RNRB_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV3_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV3_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RNRA_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RNRA_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV2_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV2_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_GPON_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_GPON_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV1_RSV_VALUE                                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_RSV1_RSV_VALUE_RESET_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_ETH4_PH_OFFSET_PH_OFFSET_VALUE_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_ETH4_PH_OFFSET_PH_OFFSET_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_OFFSET ( 0x00000018 )

#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV4 */
	uint32_t rsv4          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_PH_OFFSET */
	uint32_t rnrb_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t rsv3          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_PH_OFFSET */
	uint32_t rnra_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t rsv2          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_PH_OFFSET */
	uint32_t gpon_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_PH_OFFSET */
	uint32_t eth4_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG ;
#else
typedef struct
{	uint32_t eth4_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_PH_OFFSET */
	uint32_t rsv1          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t gpon_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_PH_OFFSET */
	uint32_t rsv2          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t rnra_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_PH_OFFSET */
	uint32_t rsv3          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t rnrb_ph_offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_PH_OFFSET */
	uint32_t rsv4          	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV4 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_PHH_OFFSET_CFG ;
#endif

/*****************************************************************************************/
/* IQ_WEIGHT_CFG                                                                         */
/* Weight Arbiration of each Ingres Queue     Note: this configuration has a meaning oly */
/*  for two or more  queus with the same priority     Default configuration of IQ array: */
/*     IQ#  Port   Weight  ==================================  0  : Eth0 :    1   1  : E */
/* th1 :    1   2  : Eth2 :    1   3  : Eth3 :    1   4  : Eth4 :    1  5  : GPON :    1 */
/*   6  : RNRA :    1  7  : RNRB :    1                                                  */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ7_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ7_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ6_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ6_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ5_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ5_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ4_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ4_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ3_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ3_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ2_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ2_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ1_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ1_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ0_WEIGHT_WEIGHT_VALUE_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_IQ0_WEIGHT_WEIGHT_VALUE_VALUE_RESET_VALUE ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_OFFSET ( 0x00000020 )

#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IQ7_WEIGHT */
	uint32_t iq7_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_WEIGHT */
	uint32_t iq6_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_WEIGHT */
	uint32_t iq5_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_WEIGHT */
	uint32_t iq4_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_WEIGHT */
	uint32_t iq3_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_WEIGHT */
	uint32_t iq2_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_WEIGHT */
	uint32_t iq1_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_WEIGHT */
	uint32_t iq0_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG ;
#else
typedef struct
{	uint32_t iq0_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_WEIGHT */
	uint32_t iq1_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_WEIGHT */
	uint32_t iq2_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_WEIGHT */
	uint32_t iq3_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_WEIGHT */
	uint32_t iq4_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_WEIGHT */
	uint32_t iq5_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_WEIGHT */
	uint32_t iq6_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_WEIGHT */
	uint32_t iq7_weight	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ7_WEIGHT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQ_WEIGHT_CFG ;
#endif

/*****************************************************************************************/
/* IQL_CNGS_THRS_CFG                                                                     */
/* Ingres  congestion threshold of Low Ingres Queues[ 3...0].     When the number of tot */
/* al Runner Buffers (eigher Runner A or Runner B) reachs the defined threshold per queu */
/* e  - Ingres Handler stops serving this queue till one of two events will occur:  (1)  */
/* num of Runner buffers is decreased down to threshold  (2) one of BBH clients that ass */
/* igned to the queue will get Service Enable message initiated in appropriate MAC (by r */
/* eaching predefined threshold in Data FIFO).    Note: this configuration should be ali */
/* gned with a threshold of max runner buffers (per each Runner)    Default configuratio */
/* n of IQ array (always allow servecing, do not stop on ingress congestion):    IQ#  Po */
/* rt   Priority  ==================================  0  : Eth0 :   32   1  : Eth1 :   3 */
/* 2    2  : Eth2 :   32    3  : Eth3 :   32    4  : Eth4 :   32   5  : GPON :   32   6  */
/*  : RNRA :   32   7  : RNRB :   32                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV4_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV4_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ3_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ3_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV3_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV3_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ2_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ2_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV2_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV2_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ1_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ1_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV1_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_RSV1_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ0_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_IQ0_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )


#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_OFFSET ( 0x00000024 )

#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV4 */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_CNGS_THRS */
	uint32_t iq3_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_CNGS_THRS */
	uint32_t iq2_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_CNGS_THRS */
	uint32_t iq1_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_CNGS_THRS */
	uint32_t iq0_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG ;
#else
typedef struct
{	uint32_t iq0_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ0_CNGS_THRS */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t iq1_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ1_CNGS_THRS */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t iq2_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ2_CNGS_THRS */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t iq3_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ3_CNGS_THRS */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV4 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQL_CNGS_THRS_CFG ;
#endif

/*****************************************************************************************/
/* IQH_CNGS_THRS_CFG                                                                     */
/* Ingres  congestion threshold of Low Ingres Queues[ 7...4].     When the number of tot */
/* al Runner Buffers (eigher Runner A or Runner B) reachs the defined threshold per queu */
/* e  - Ingres Handler stops serving this queue till one of two events will occur:  (1)  */
/* num of Runner buffers is decreased down to threshold  (2) one of BBH clients that ass */
/* igned to the queue will get Service Enable message initiated in appropriate MAC (by r */
/* eaching predefined threshold in Data FIFO).    Note: this configuration should be ali */
/* gned with a threshold of max runner buffers (per each Runner)    Default configuratio */
/* n of IQ array (always allow servecing, do not stop on ingress congestion):    IQ#  Po */
/* rt   Priority  ==================================  0  : Eth0 :   32   1  : Eth1 :   3 */
/* 2    2  : Eth2 :   32    3  : Eth3 :   32    4  : Eth4 :   32   5  : GPON :   32   6  */
/*  : RNRA :   32   7  : RNRB :   32                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV4_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV4_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ7_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ7_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV3_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV3_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ6_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ6_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV2_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV2_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ5_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ5_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV1_RSV_VALUE                                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_RSV1_RSV_VALUE_RESET_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ4_CNGS_THRS_CNGS_THRS_VALUE_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_IQ4_CNGS_THRS_CNGS_THRS_VALUE_VALUE_RESET_VALUE ( 0x40 )


#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_OFFSET ( 0x00000028 )

#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV4 */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ7_CNGS_THRS */
	uint32_t iq7_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_CNGS_THRS */
	uint32_t iq6_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_CNGS_THRS */
	uint32_t iq5_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_CNGS_THRS */
	uint32_t iq4_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG ;
#else
typedef struct
{	uint32_t iq4_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ4_CNGS_THRS */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t iq5_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ5_CNGS_THRS */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
	uint32_t iq6_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ6_CNGS_THRS */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV3 */
	uint32_t iq7_cngs_thrs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IQ7_CNGS_THRS */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV4 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IQH_CNGS_THRS_CFG ;
#endif

/*****************************************************************************************/
/* RNRA_RB_BASE                                                                          */
/* Base Address of Runner Buffers sending for Runner A     The major part of Runner Buff */
/* ers are managed by Ingres Handler per Runner.  The number of Runner Buffers is define */
/* d per Runner, max number of managed buffers is 64; default is 32    However there are */
/*  assigned Runner Buffers managed by Runner itself (FW pipe), the number of assigned n */
/* on-managed Runner Buffer is up to FW control(up to 4 RIBs)  The base address of assig */
/* ned buffers is different from the common managed buffers.    Each Runner Buffer has o */
/* ffset of 0x32 according to its on number.     Note: Default configuration of base add */
/* ress is 0x0.                                                                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_RNRA_ASIGNED_RB_BASE_BASE_ADDRESS_OFFSET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_RNRA_ASIGNED_RB_BASE_BASE_ADDRESS_OFFSET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_RNRA_COMMON_RB_BASE_BASE_ADDRESS_OFFSET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_RNRA_COMMON_RB_BASE_BASE_ADDRESS_OFFSET_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_OFFSET ( 0x00000030 )

#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RNRA_ASIGNED_RB_BASE */
	uint32_t rnra_asigned_rb_base	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_COMMON_RB_BASE */
	uint32_t rnra_common_rb_base 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE ;
#else
typedef struct
{	uint32_t rnra_common_rb_base 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_COMMON_RB_BASE */
	uint32_t rnra_asigned_rb_base	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_ASIGNED_RB_BASE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRA_RB_BASE ;
#endif

/*****************************************************************************************/
/* RNRB_RB_BASE                                                                          */
/* Base Address of Runner Buffers sending for Runner B     The major part of Runner Buff */
/* ers are managed by Ingres Handler per Runner.  The number of Runner Buffers is define */
/* d per Runner, max number of managed buffers is 64; default is 32    However there are */
/*  assigned Runner Buffers managed by Runner itself (FW pipe), the number of assigned n */
/* on-managed Runner Buffer is up to FW control(up to 4 RIBs)  The base address of assig */
/* ned buffers is different from the common managed buffers.    Each Runner Buffer has o */
/* ffset of 0x32 according to its on number.     Note: Default configuration of base add */
/* ress is 0x0.                                                                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_RNRB_ASIGNED_RB_BASE_BASE_ADDRESS_OFFSET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_RNRB_ASIGNED_RB_BASE_BASE_ADDRESS_OFFSET_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_RNRB_COMMON_RB_BASE_BASE_ADDRESS_OFFSET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_RNRB_COMMON_RB_BASE_BASE_ADDRESS_OFFSET_VALUE_RESET_VALUE  ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_OFFSET ( 0x00000034 )

#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RNRB_ASIGNED_RB_BASE */
	uint32_t rnrb_asigned_rb_base	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_COMMON_RB_BASE */
	uint32_t rnrb_common_rb_base 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE ;
#else
typedef struct
{	uint32_t rnrb_common_rb_base 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_COMMON_RB_BASE */
	uint32_t rnrb_asigned_rb_base	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_ASIGNED_RB_BASE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRB_RB_BASE ;
#endif

/*****************************************************************************************/
/* RNRA_IHRSP_ADDR                                                                       */
/* Address of IH response for Runner A     The content of IH Response is defined in chap */
/* ter 3.1.3.15 in strpublicLilacArchTMIHmicro_archLilac_IH_LLD_v0.5.doc                 */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_RSV_RSV_VALUE                                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_RSV_RSV_VALUE_RESET_VALUE                        ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_RNRA_IHRSP_ADDR_ADDRESS_OFFSET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_RNRA_IHRSP_ADDR_ADDRESS_OFFSET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_OFFSET ( 0x00000038 )

#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv            	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_IHRSP_ADDR */
	uint32_t rnra_ihrsp_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR ;
#else
typedef struct
{	uint32_t rnra_ihrsp_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_IHRSP_ADDR */
	uint32_t rsv            	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRA_IHRSP_ADDR ;
#endif

/*****************************************************************************************/
/* RNRB_IHRSP_ADDR                                                                       */
/* Address of IH response for Runner B     The content of IH Response is defined in chap */
/* ter 3.1.3.15 in strpublicLilacArchTMIHmicro_archLilac_IH_LLD_v0.5.doc                 */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_RSV_RSV_VALUE                                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_RSV_RSV_VALUE_RESET_VALUE                        ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_RNRB_IHRSP_ADDR_ADDRESS_OFFSET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_RNRB_IHRSP_ADDR_ADDRESS_OFFSET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_OFFSET ( 0x0000003C )

#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv            	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_IHRSP_ADDR */
	uint32_t rnrb_ihrsp_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR ;
#else
typedef struct
{	uint32_t rnrb_ihrsp_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_IHRSP_ADDR */
	uint32_t rsv            	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRB_IHRSP_ADDR ;
#endif

/*****************************************************************************************/
/* RNRA_CNGS_RPT_ADDR                                                                    */
/* Address of IH congestion report for Runner A     IH sends the total number of the Run */
/* ner when the congestion state is changed.    Default address is 0x0                   */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_RSV_RSV_VALUE                                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_RSV_RSV_VALUE_RESET_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_RNRA_CNGS_RPT_ADDR_ADDRESS_OFFSET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_RNRA_CNGS_RPT_ADDR_ADDRESS_OFFSET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_OFFSET ( 0x00000040 )

#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv               	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_CNGS_RPT_ADDR */
	uint32_t rnra_cngs_rpt_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR ;
#else
typedef struct
{	uint32_t rnra_cngs_rpt_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_CNGS_RPT_ADDR */
	uint32_t rsv               	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRA_CNGS_RPT_ADDR ;
#endif

/*****************************************************************************************/
/* RNRB_CNGS_RPT_ADDR                                                                    */
/* Address of IH congestion report for Runner B     IH sends the total number of the Run */
/* ner when the congestion state is changed.    Default address is 0x0                   */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_RSV_RSV_VALUE                                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_RSV_RSV_VALUE_RESET_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_RNRB_CNGS_RPT_ADDR_ADDRESS_OFFSET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_RNRB_CNGS_RPT_ADDR_ADDRESS_OFFSET_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_OFFSET ( 0x00000044 )

#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv               	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_CNGS_RPT_ADDR */
	uint32_t rnrb_cngs_rpt_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR ;
#else
typedef struct
{	uint32_t rnrb_cngs_rpt_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_CNGS_RPT_ADDR */
	uint32_t rsv               	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNRB_CNGS_RPT_ADDR ;
#endif

/*****************************************************************************************/
/* RNR_CNGS_RPT_CFG                                                                      */
/* Enable of sending Congestion Report per each Runner.    IH sends the total number of  */
/* the Runner when the congestion state is changed. The sending of this report is upon t */
/* o enabled per Runner.    Default address is 0x0 (not to send report)                  */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RSV_RSV_VALUE                                        ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RSV_RSV_VALUE_RESET_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RNRB_CNGS_RPT_EN_DIS_CNGS_RPT_SEND_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RNRB_CNGS_RPT_EN_DIS_CNGS_RPT_SEND_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RNRB_CNGS_RPT_EN_EN_CNGS_RPT_SEND_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RNRA_CNGS_RPT_EN_DIS_CNGS_RPT_SEND_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RNRA_CNGS_RPT_EN_DIS_CNGS_RPT_SEND_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_RNRA_CNGS_RPT_EN_EN_CNGS_RPT_SEND_VALUE              ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_OFFSET ( 0x00000048 )

#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv             	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_CNGS_RPT_EN */
	uint32_t rnrb_cngs_rpt_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_CNGS_RPT_EN */
	uint32_t rnra_cngs_rpt_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG ;
#else
typedef struct
{	uint32_t rnra_cngs_rpt_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_CNGS_RPT_EN */
	uint32_t rnrb_cngs_rpt_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_CNGS_RPT_EN */
	uint32_t rsv             	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RNR_CNGS_RPT_CFG ;
#endif

/*****************************************************************************************/
/* RADDR0_CFG                                                                            */
/* Route Addres configuration of following ports: Eth0, Eth1, Eth2, Eth3.    Used for br */
/* oadbus access for the following ports: for sending responses, message and data.       */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV4_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV4_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH3_RADDR_ROUTE_ADDRESS_VALUE             ( 0x48 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH3_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x48 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV3_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV3_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH2_RADDR_ROUTE_ADDRESS_VALUE             ( 0x54 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH2_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x54 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV2_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV2_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH1_RADDR_ROUTE_ADDRESS_VALUE             ( 0x4C )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH1_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x4C )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV1_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_RSV1_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH0_RADDR_ROUTE_ADDRESS_VALUE             ( 0x5C )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ETH0_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x5C )


#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_OFFSET ( 0x0000004C )

#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV4 */
	uint32_t rsv4      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_RADDR */
	uint32_t eth3_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_RADDR */
	uint32_t eth2_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_RADDR */
	uint32_t eth1_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_RADDR */
	uint32_t eth0_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG ;
#else
typedef struct
{	uint32_t eth0_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_RADDR */
	uint32_t rsv1      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t eth1_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_RADDR */
	uint32_t rsv2      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t eth2_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_RADDR */
	uint32_t rsv3      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t eth3_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_RADDR */
	uint32_t rsv4      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV4 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RADDR0_CFG ;
#endif

/*****************************************************************************************/
/* RADDR1_CFG                                                                            */
/* Route Addres configuration of following ports: Eth4, GPON, Runner A, Runner B    Used */
/*  for broadbus access for the following ports: for sending responses, message and data */
/* .                                                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV4_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV4_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RNRB_RADDR_ROUTE_ADDRESS_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RNRB_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV3_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV3_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RNRA_RADDR_ROUTE_ADDRESS_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RNRA_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV2_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV2_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_GPON_RADDR_ROUTE_ADDRESS_VALUE             ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_GPON_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV1_RSV_VALUE                             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_RSV1_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_ETH4_RADDR_ROUTE_ADDRESS_VALUE             ( 0x50 )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_ETH4_RADDR_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x50 )


#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_OFFSET ( 0x00000050 )

#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV4 */
	uint32_t rsv4      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_RADDR */
	uint32_t rnrb_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_RADDR */
	uint32_t rnra_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_RADDR */
	uint32_t gpon_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_RADDR */
	uint32_t eth4_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG ;
#else
typedef struct
{	uint32_t eth4_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_RADDR */
	uint32_t rsv1      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t gpon_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_RADDR */
	uint32_t rsv2      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rnra_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_RADDR */
	uint32_t rsv3      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rnrb_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_RADDR */
	uint32_t rsv4      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV4 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RADDR1_CFG ;
#endif

/*****************************************************************************************/
/* RBPM_BAT_CFG                                                                          */
/* Runner Buffer Allocation Threshold (per Runner)    IH manages pool of common Runner B */
/* uffers per each Runner. The maximal number of buffers is defined by the following opt */
/* ions:  0x0 - 16 max buffers  0x1 - 24 max buffers  0x2 - 32 max buffers  0x3 - 48 max */
/*  buffers  0x4 - 64 max buffers    Default is 0x0 (32 buffers)                         */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RSV2_RSV_VALUE                        ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RSV2_RSV_VALUE_RESET_VALUE            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRB_BPM_BAT_MAX_16_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRB_BPM_BAT_MAX_24_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRB_BPM_BAT_MAX_32_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRB_BPM_BAT_MAX_32_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRB_BPM_BAT_MAX_48_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRB_BPM_BAT_MAX_64_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RSV1_RSV_VALUE                        ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RSV1_RSV_VALUE_RESET_VALUE            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRA_BPM_BAT_MAX_16_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRA_BPM_BAT_MAX_24_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRA_BPM_BAT_MAX_32_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRA_BPM_BAT_MAX_32_VALUE_RESET_VALUE ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRA_BPM_BAT_MAX_48_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_RNRA_BPM_BAT_MAX_64_VALUE             ( 0x4 )


#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_OFFSET ( 0x00000054 )

#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2        	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_BPM_BAT */
	uint32_t rnrb_bpm_bat	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_BPM_BAT */
	uint32_t rnra_bpm_bat	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG ;
#else
typedef struct
{	uint32_t rnra_bpm_bat	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_BPM_BAT */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rnrb_bpm_bat	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_BPM_BAT */
	uint32_t rsv2        	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RBPM_BAT_CFG ;
#endif

/*****************************************************************************************/
/* RBPM_BAC_STAT                                                                         */
/* Runner Buffer Allocated Counter (per Runner) - represents the status of allocated buf */
/* fers at moment of read access to register    Background:  IH manages pool of common R */
/* unner Buffers per each Runner. The maximal number of buffers is defined by the follow */
/* ing options:  0x0 - 16 max buffers  0x1 - 24 max buffers  0x2 - 32 max buffers  0x3 - */
/*  48 max buffers  0x4 - 64 max buffers    Default is 0x0 (no buffers)                  */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_RSV2_RSV_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_RSV2_RSV_VALUE_RESET_VALUE         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_RNRB_BPM_BAC_BAC_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_RNRB_BPM_BAC_BAC_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_RNRA_BPM_BAC_BAC_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_RNRA_BPM_BAC_BAC_VALUE_RESET_VALUE ( 0x0 )


#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_OFFSET ( 0x00000058 )

#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv2 */
	uint32_t rsv2        	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_BPM_BAC */
	uint32_t rnrb_bpm_bac	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_BPM_BAC */
	uint32_t rnra_bpm_bac	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT ;
#else
typedef struct
{	uint32_t rnra_bpm_bac	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_BPM_BAC */
	uint32_t rnrb_bpm_bac	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_BPM_BAC */
	uint32_t rsv2        	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_RBPM_BAC_STAT ;
#endif

/*****************************************************************************************/
/* TRGT_MTRX_ETH0_SP_CFG                                                                 */
/* Target matrix configuration for Source Port Eth0    Used for decision on Target memor */
/* y and Local switch as function of extracted destination port that can be as following */
/* :  - Eth0  - Eth1  - Eth2  - Eth3  - Eth4  - GPON  - PCIe  - Multicast (MC)  - CPU  - */
/*  Always DDR (relevant for local switch info)  - Always SRAM(relevant for local switch */
/*  info)                                                                                */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_RSV2_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_RSV2_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SPARE_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE1_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SRAM_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_DDR_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE_RESET_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_MC_LS_CFG_TRUE_VALUE                             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_CPU_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE0_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_GPON_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH4_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH3_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH2_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH1_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH0_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_RSV1_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_RSV1_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_SPARE_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE1_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_MC_TM_CFG_SRAM_TARGET_MEMORY_VALUE               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_CPU_TM_CFG_SRAM_TARGET_MEMORY_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_PCIE0_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_GPON_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH4_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH3_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH2_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH1_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_DP_ETH0_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_OFFSET ( 0x0000005C )

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG ;
#else
typedef struct
{	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH0_SP_CFG ;
#endif

/*****************************************************************************************/
/* TRGT_MTRX_ETH1_SP_CFG                                                                 */
/* Target matrix configuration for Source Port Eth1    Used for decision on Target memor */
/* y and Local switch as function of extracted destination port that can be as following */
/* :  - Eth0  - Eth1  - Eth2  - Eth3  - Eth4  - GPON  - PCIe0/1  - Multicast (MC)  - CPU */
/*   - Always DDR (relevant for local switch info)  - Always SRAM(relevant for local swi */
/* tch info)  -Spare                                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_RSV2_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_RSV2_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SPARE_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE1_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SRAM_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_DDR_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE_RESET_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_MC_LS_CFG_TRUE_VALUE                             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_CPU_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE0_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_GPON_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH4_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH3_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH2_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH1_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH0_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_RSV1_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_RSV1_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_SPARE_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE1_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_MC_TM_CFG_SRAM_TARGET_MEMORY_VALUE               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_CPU_TM_CFG_SRAM_TARGET_MEMORY_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_PCIE0_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_GPON_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH4_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH3_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH2_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH1_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_DP_ETH0_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_OFFSET ( 0x00000060 )

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG ;
#else
typedef struct
{	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH1_SP_CFG ;
#endif

/*****************************************************************************************/
/* TRGT_MTRX_ETH2_SP_CFG                                                                 */
/* Target matrix configuration for Source Port Eth2    Used for decision on Target memor */
/* y and Local switch as function of extracted destination port that can be as following */
/* :  - Eth0  - Eth1  - Eth2  - Eth3  - Eth4  - GPON  - PCIe0/1  - Multicast (MC)  - CPU */
/*   - Always DDR (relevant for local switch info)  - Always SRAM(relevant for local swi */
/* tch info)  -Spare                                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_RSV2_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_RSV2_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SPARE_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE1_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SRAM_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_DDR_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE_RESET_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_MC_LS_CFG_TRUE_VALUE                             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_CPU_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE0_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_GPON_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH4_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH3_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH2_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH1_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH0_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_RSV1_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_RSV1_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_SPARE_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE1_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_MC_TM_CFG_SRAM_TARGET_MEMORY_VALUE               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_CPU_TM_CFG_SRAM_TARGET_MEMORY_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_PCIE0_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_GPON_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH4_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH3_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH2_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH1_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_DP_ETH0_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_OFFSET ( 0x00000064 )

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG ;
#else
typedef struct
{	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH2_SP_CFG ;
#endif

/*****************************************************************************************/
/* TRGT_MTRX_ETH3_SP_CFG                                                                 */
/* Target matrix configuration for Source Port Eth3    Used for decision on Target memor */
/* y and Local switch as function of extracted destination port that can be as following */
/* :  - Eth0  - Eth1  - Eth2  - Eth3  - Eth4  - GPON  - PCIe0/1  - Multicast (MC)  - CPU */
/*   - Always DDR (relevant for local switch info)  - Always SRAM(relevant for local swi */
/* tch info)  -Spare                                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_RSV2_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_RSV2_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SPARE_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE1_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SRAM_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_DDR_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE_RESET_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_MC_LS_CFG_TRUE_VALUE                             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_CPU_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE0_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_GPON_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH4_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH3_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH2_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH1_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH0_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_RSV1_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_RSV1_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_SPARE_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE1_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_MC_TM_CFG_SRAM_TARGET_MEMORY_VALUE               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_CPU_TM_CFG_SRAM_TARGET_MEMORY_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_PCIE0_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_GPON_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH4_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH3_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH2_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH1_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_DP_ETH0_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_OFFSET ( 0x00000068 )

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG ;
#else
typedef struct
{	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH3_SP_CFG ;
#endif

/*****************************************************************************************/
/* TRGT_MTRX_ETH4_SP_CFG                                                                 */
/* Target matrix configuration for Source Port Eth4    Used for decision on Target memor */
/* y and Local switch as function of extracted destination port that can be as following */
/* :  - Eth0  - Eth1  - Eth2  - Eth3  - Eth4  - GPON  - PCIe0/1  - Multicast (MC)  - CPU */
/*   - Always DDR (relevant for local switch info)  - Always SRAM(relevant for local swi */
/* tch info)  -Spare                                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_RSV2_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_RSV2_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SPARE_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE1_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SRAM_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_DDR_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE_RESET_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_MC_LS_CFG_TRUE_VALUE                             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_CPU_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE0_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_GPON_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH4_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH3_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH2_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH1_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH0_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_RSV1_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_RSV1_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_SPARE_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE1_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_MC_TM_CFG_SRAM_TARGET_MEMORY_VALUE               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_CPU_TM_CFG_SRAM_TARGET_MEMORY_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_PCIE0_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_GPON_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH4_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH3_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH2_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH1_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_DP_ETH0_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_OFFSET ( 0x0000006C )

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG ;
#else
typedef struct
{	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_ETH4_SP_CFG ;
#endif

/*****************************************************************************************/
/* TRGT_MTRX_GPON_SP_CFG                                                                 */
/* Target matrix configuration for Source Port GPON    Used for decision on Target memor */
/* y and Local switch as function of extracted destination port that can be as following */
/* :  - Eth0  - Eth1  - Eth2  - Eth3  - Eth4  - GPON  - PCIe0/1  - Multicast (MC)  - CPU */
/*   - Always DDR (relevant for local switch info)  - Always SRAM(relevant for local swi */
/* tch info)  -Spare                                                                     */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_RSV2_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_RSV2_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SPARE_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SPARE_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE1_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE1_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SRAM_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SRAM_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_DDR_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_DDR_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_MC_LS_CFG_FALSE_VALUE_RESET_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_MC_LS_CFG_TRUE_VALUE                             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_CPU_LS_CFG_FALSE_VALUE_RESET_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_CPU_LS_CFG_TRUE_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE0_LS_CFG_FALSE_VALUE_RESET_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE0_LS_CFG_TRUE_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_GPON_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_GPON_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH4_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH4_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH3_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH3_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH2_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH2_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH1_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH1_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH0_LS_CFG_FALSE_VALUE_RESET_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH0_LS_CFG_TRUE_VALUE                           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_RSV1_RSV_VALUE                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_RSV1_RSV_VALUE_RESET_VALUE                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SPARE_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_SPARE_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE1_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE                ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_MC_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_MC_TM_CFG_SRAM_TARGET_MEMORY_VALUE               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_CPU_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_CPU_TM_CFG_SRAM_TARGET_MEMORY_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_PCIE0_TM_CFG_SRAM_TARGET_MEMORY_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_GPON_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_GPON_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH4_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH4_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH3_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH3_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH2_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH2_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH1_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH1_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH0_TM_CFG_DDR_TARGET_MEMORY_VALUE_RESET_VALUE  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_DP_ETH0_TM_CFG_SRAM_TARGET_MEMORY_VALUE             ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_OFFSET ( 0x00000070 )

#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG ;
#else
typedef struct
{	uint32_t dp_eth0_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_TM_CFG */
	uint32_t dp_eth1_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_TM_CFG */
	uint32_t dp_eth2_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_TM_CFG */
	uint32_t dp_eth3_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_TM_CFG */
	uint32_t dp_eth4_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_TM_CFG */
	uint32_t dp_gpon_tm_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_TM_CFG */
	uint32_t dp_pcie0_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_TM_CFG */
	uint32_t dp_cpu_tm_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_TM_CFG */
	uint32_t dp_mc_tm_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_TM_CFG */
	uint32_t dp_pcie1_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_TM_CFG */
	uint32_t dp_spare_tm_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_TM_CFG */
	uint32_t rsv1           	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t dp_eth0_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH0_LS_CFG */
	uint32_t dp_eth1_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH1_LS_CFG */
	uint32_t dp_eth2_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH2_LS_CFG */
	uint32_t dp_eth3_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH3_LS_CFG */
	uint32_t dp_eth4_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_ETH4_LS_CFG */
	uint32_t dp_gpon_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_GPON_LS_CFG */
	uint32_t dp_pcie0_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE0_LS_CFG */
	uint32_t dp_cpu_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_CPU_LS_CFG */
	uint32_t dp_mc_ls_cfg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_MC_LS_CFG */
	uint32_t dp_ddr_ls_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_DDR_LS_CFG */
	uint32_t dp_sram_ls_cfg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SRAM_LS_CFG */
	uint32_t dp_pcie1_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_PCIE1_LS_CFG */
	uint32_t dp_spare_ls_cfg	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DP_SPARE_LS_CFG */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_TRGT_MTRX_GPON_SP_CFG ;
#endif

/*****************************************************************************************/
/* IH_MISC_CFG                                                                           */
/* Ingres handler Miscellenous Control:    - Look-up enable in Direct Mode  - Serail Num */
/* ber stamping enable for Short Packets                                                 */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_RSV_RSV_VALUE                                                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_RSV_RSV_VALUE_RESET_VALUE                                          ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_NVAL_CAM_SEARCH_EN_DIS_SEARCH_IN_CAM_AFTER_INVAL_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_NVAL_CAM_SEARCH_EN_DIS_SEARCH_IN_CAM_AFTER_INVAL_VALUE_RESET_VALUE ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_NVAL_CAM_SEARCH_EN_EN_SEARCH_IN_CAM_AFTER_INVAL_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_CNGS_DSCRD_DIS_CNGS_DISCARD_EN_VALUE                               ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_CNGS_DSCRD_DIS_CNGS_DISCARD_EN_VALUE_RESET_VALUE                   ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_CNGS_DSCRD_DIS_CNGS_DISCARD_DIS_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_HLENGTH_MIN_TRSH_HLENGTH_MIN_TRSH_VAL_VALUE                        ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_HLENGTH_MIN_TRSH_HLENGTH_MIN_TRSH_VAL_VALUE_RESET_VALUE            ( 0x40 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_SN_STAMP_DM_PKT_DIS_STAMPING_SN_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_SN_STAMP_DM_PKT_DIS_STAMPING_SN_VALUE_RESET_VALUE                  ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_SN_STAMP_DM_PKT_EN_STAMPING_SN_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_LUT_EN_DIRECT_MODE_DISABLE_LOOKUP_VALUE                            ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_LUT_EN_DIRECT_MODE_ENABLE_LOOKUP_VALUE                             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_LUT_EN_DIRECT_MODE_ENABLE_LOOKUP_VALUE_RESET_VALUE                 ( 0x1 )


#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_OFFSET ( 0x00000074 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv               	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NVAL_CAM_SEARCH_EN */
	uint32_t nval_cam_search_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNGS_DSCRD_DIS */
	uint32_t cngs_dscrd_dis    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HLENGTH_MIN_TRSH */
	uint32_t hlength_min_trsh  	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SN_STAMP_DM_PKT */
	uint32_t sn_stamp_dm_pkt   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LUT_EN_DIRECT_MODE */
	uint32_t lut_en_direct_mode	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG ;
#else
typedef struct
{	uint32_t lut_en_direct_mode	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LUT_EN_DIRECT_MODE */
	uint32_t sn_stamp_dm_pkt   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SN_STAMP_DM_PKT */
	uint32_t hlength_min_trsh  	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HLENGTH_MIN_TRSH */
	uint32_t cngs_dscrd_dis    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNGS_DSCRD_DIS */
	uint32_t nval_cam_search_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NVAL_CAM_SEARCH_EN */
	uint32_t rsv               	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_MISC_CFG ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY0                                                                         */
/* IH Class - Key0 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_OFFSET ( 0x00000078 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY0 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY1                                                                         */
/* IH Class - Key1 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_OFFSET ( 0x0000007C )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY1 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY2                                                                         */
/* IH Class - Key2 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_OFFSET ( 0x00000080 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY2 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY3                                                                         */
/* IH Class - Key3 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_OFFSET ( 0x00000084 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY3 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY4                                                                         */
/* IH Class - Key4 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_OFFSET ( 0x00000088 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY4 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY5                                                                         */
/* IH Class - Key5 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_OFFSET ( 0x0000008C )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY5 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY6                                                                         */
/* IH Class - Key6 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_OFFSET ( 0x00000090 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY6 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY7                                                                         */
/* IH Class - Key7 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_OFFSET ( 0x00000094 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY7 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY8                                                                         */
/* IH Class - Key8 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_OFFSET ( 0x00000098 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY8 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY9                                                                         */
/* IH Class - Key9 configuration    Note: used for IH class identification by Parser Cla */
/* ssifier, based on the Parser Summary Word comparison. Per each class there is a KEY c */
/* onfiguration and MASK that applied on the Parser Sumary word. If the match based on K */
/* EY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header De */
/* scriptor upon to override enable bit. The priority is always to lower Class ID (for e */
/* xample: if Class 3, 4 and 15 has match - Class 3 is choosen.                          */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_OFFSET ( 0x0000009C )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY9 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY10                                                                        */
/* IH Class - Key10 configuration    Note: used for IH class identification by Parser Cl */
/* assifier, based on the Parser Summary Word comparison. Per each class there is a KEY  */
/* configuration and MASK that applied on the Parser Sumary word. If the match based on  */
/* KEY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header D */
/* escriptor upon to override enable bit. The priority is always to lower Class ID (for  */
/* example: if Class 3, 4 and 15 has match - Class 3 is choosen.                         */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_OFFSET ( 0x00000100 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY10 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY11                                                                        */
/* IH Class - Key11 configuration    Note: used for IH class identification by Parser Cl */
/* assifier, based on the Parser Summary Word comparison. Per each class there is a KEY  */
/* configuration and MASK that applied on the Parser Sumary word. If the match based on  */
/* KEY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header D */
/* escriptor upon to override enable bit. The priority is always to lower Class ID (for  */
/* example: if Class 3, 4 and 15 has match - Class 3 is choosen.                         */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_OFFSET ( 0x00000104 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY11 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY12                                                                        */
/* IH Class - Key12 configuration    Note: used for IH class identification by Parser Cl */
/* assifier, based on the Parser Summary Word comparison. Per each class there is a KEY  */
/* configuration and MASK that applied on the Parser Sumary word. If the match based on  */
/* KEY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header D */
/* escriptor upon to override enable bit. The priority is always to lower Class ID (for  */
/* example: if Class 3, 4 and 15 has match - Class 3 is choosen.                         */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_OFFSET ( 0x00000108 )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY12 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY13                                                                        */
/* IH Class - Key13 configuration    Note: used for IH class identification by Parser Cl */
/* assifier, based on the Parser Summary Word comparison. Per each class there is a KEY  */
/* configuration and MASK that applied on the Parser Sumary word. If the match based on  */
/* KEY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header D */
/* escriptor upon to override enable bit. The priority is always to lower Class ID (for  */
/* example: if Class 3, 4 and 15 has match - Class 3 is choosen.                         */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_DA_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_DA_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_DA_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_DA_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_DA_FILTER4_MATCH_VALUE             ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_DA_FILTER5_MATCH_VALUE             ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_RSV1_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE                         ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_DA_FLTR_RSV2_VALUE_RESET_VALUE             ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_TCP_VALUE                               ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_UDP_VALUE                               ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_IGMP_VALUE                              ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_ICMP_VALUE                              ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_ICMPV6_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_ESP_VALUE                               ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_GRE_VALUE                               ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_RSV1_VALUE                              ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_IPV6_VALUE                              ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_AH_VALUE                                ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_NOT_PARSED_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L4_NOT_PARSED_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L3_NONE_VALUE                              ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L3_IPV4_VALUE                              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L3_IPV6_VALUE                              ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE                       ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L3_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_UNKNOWN_VALUE                           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_PPPOE_DISCOVERY_VALUE                   ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_PPPOE_SESSION_VALUE                     ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_IPV4OE_VALUE                            ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_IPV6OE_VALUE                            ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_USER0_VALUE                             ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_USER1_VALUE                             ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_USER2_VALUE                             ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_USER3_VALUE                             ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_ARP_VALUE                               ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_TYPE1588_VALUE                          ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_TYPE8021X_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE                     ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_IH_CLASS_KEY_L2_TYPE8011AGCFM_VALUE_RESET_VALUE         ( 0xF )


#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_OFFSET ( 0x0000010C )

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_ADDRESS   	( IH_REGS_GENERAL_CONFIGURATION_ADDRESS + IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_OFFSET )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_READ( r ) 	READ_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_ADDRESS ), (r) )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_WRITE( v )	WRITE_32( ( IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_CLASS_KEY_ERR */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13 ;
#else
typedef struct
{	uint32_t ih_class_key_l2        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L2 */
	uint32_t ih_class_key_l3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L3 */
	uint32_t ih_class_key_l4        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_L4 */
	uint32_t ih_class_key_da_fltr   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_FLTR */
	uint32_t ih_class_key_da_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_DA_ANYHIT */
	uint32_t ih_class_key_mc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_MC_FLTR */
	uint32_t ih_class_key_bc_fltr   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_BC_FLTR */
	uint32_t ih_class_key_vid_fltr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_FLTR */
	uint32_t ih_class_key_vid_anyhit	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_VID_ANYHIT */
	uint32_t ih_class_key_ip_fltr   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_FLTR */
	uint32_t ih_class_key_ip_anyhit 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_IP_ANYHIT */
	uint32_t ih_class_key_wan_fltr  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_WAN_FLTR */
	uint32_t ih_class_key_5tpl_fltr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_5TPL_FLTR */
	uint32_t ih_class_key_sp        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_SP */
	uint32_t ih_class_key_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_CLASS_KEY_ERR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY13 ;
#endif

/*****************************************************************************************/
/* IH_CLASS_KEY14                                                                        */
/* IH Class - Key14 configuration    Note: used for IH class identification by Parser Cl */
/* assifier, based on the Parser Summary Word comparison. Per each class there is a KEY  */
/* configuration and MASK that applied on the Parser Sumary word. If the match based on  */
/* KEY & MASK is OK, Classifier may override IH class provided by BBH/Runner in Header D */
/* escriptor upon to override enable bit. The priority is always to lower Class ID (for  */
/* example: if Class 3, 4 and 15 has match - Class 3 is choosen.                         */
/*****************************************************************************************/

#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_ERR_NO_ERROR_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_ERR_ERROR_VALUE                            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_ERR_ERROR_VALUE_RESET_VALUE                ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_ETH0_PORT_VALUE                         ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_ETH1_PORT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_ETH2_PORT_VALUE                         ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_ETH3_PORT_VALUE                         ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_ETH4_PORT_VALUE                         ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_GPON_PORT_VALUE                         ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_RNRA_PORT_VALUE                         ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_PCIE0_PORT_VALUE                        ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_PCIE1_PORT_VALUE                        ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_RNRB_PORT_VALUE                         ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE                       ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_SP_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x1F )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_5TPL_FLTR_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_5TPL_FLTR_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_WAN_FLTR_NO_HIT_VALUE                      ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE                         ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_WAN_FLTR_HIT_VALUE_RESET_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_ANYHIT_HIT_VALUE_RESET_VALUE            ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_FLTR_IP_FILTER0_MATCH_VALUE             ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_FLTR_IP_FILTER1_MATCH_VALUE             ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_FLTR_IP_FILTER2_MATCH_VALUE             ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE             ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_IP_FLTR_IP_FILTER3_MATCH_VALUE_RESET_VALUE ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_ANYHIT_NO_HIT_VALUE                    ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE                       ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_ANYHIT_HIT_VALUE_RESET_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER0_MATCH_VALUE           ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER1_MATCH_VALUE           ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER2_MATCH_VALUE           ( 0x2 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER3_MATCH_VALUE           ( 0x3 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER4_MATCH_VALUE           ( 0x4 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER5_MATCH_VALUE           ( 0x5 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER6_MATCH_VALUE           ( 0x6 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER7_MATCH_VALUE           ( 0x7 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER8_MATCH_VALUE           ( 0x8 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER9_MATCH_VALUE           ( 0x9 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER10_MATCH_VALUE          ( 0xA )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_VID_FILTER11_MATCH_VALUE          ( 0xB )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_RSV1_VALUE                        ( 0xC )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_RSV2_VALUE                        ( 0xD )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_RSV3_VALUE                        ( 0xE )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE                        ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_VID_FLTR_RSV4_VALUE_RESET_VALUE            ( 0xF )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_BC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_BC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_BC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_MC_FLTR_NO_HIT_VALUE                       ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_MC_FLTR_HIT_VALUE                          ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_MC_FLTR_HIT_VALUE_RESET_VALUE              ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_DA_ANYHIT_NO_HIT_VALUE                     ( 0x0 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_DA_ANYHIT_HIT_VALUE                        ( 0x1 )
#define IH_REGS_GENERAL_CONFIGURATION_IH_CLASS_KEY14_IH_CLASS_KEY_DA_ANYHIT_HIT_V