/*
 * si3050.h -- SI3050 ALSA SoC Audio Codec driver interface
 *
 * Copyright (C) 2011 DSPG (DSP Group).
 *
 * Based on wm8968.h:
 *  Copyright 2009 Guennadi Liakhovetski <g.liakhovetski@gmx.de>
 *
 * Adapted to SI3050 FXO chip
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __SND_ASoC_SI3050_H__
#define __SND_ASoC_SI3050_H__

#include <sound/soc.h>
#include <sound/soc-dai.h>
#include <linux/ioctl.h> /* needed for the _IOW etc stuff used later */
#include <linux/spi/spi.h>


/*****************************************************************************/

/* Note: The chip can support only TDM slave configuration. It needs the clocks to be fed externally.
 *
 *  The chip also supports 8-bit Linear-PCM and ALaw/uLaw-companded-PCM.
 */
#define SI3050_FORMATS	(SNDRV_PCM_FMTBIT_S8  | SNDRV_PCM_FMTBIT_S16_LE )



#define SI3050_IOC_RESET _IOW(SPI_IOC_MAGIC, 5, __u32)

/* Clock divider Id's:
 * only for divideres which produce clocks that are
 * sourced-out by the chip (not for Internal-clocks dividers)
 */
enum si3050_clk_id {
	SI3050_OPCLKDIV,
	SI3050_BCLKDIV,
};

enum si3050_sysclk_src {
	SI3050_PLL,     /* Use PLL */
	SI3050_MCLK     /* Bypass PLL - use MCLK directly */
};

#define SI3050_SPIDEV_MAJOR	154 	/* assigned */
#define N_SPI_MINORS		32  	/* ... up to 256 */

#define SPI_MODE_MASK	(SPI_CPHA | SPI_CPOL | SPI_CS_HIGH |		\
			 SPI_LSB_FIRST | SPI_3WIRE | SPI_LOOP |		\
			 SPI_NO_CS | SPI_READY)

struct si3050_spidev_data {
	dev_t			devt;
	spinlock_t		spi_lock;
	struct spi_device	*spi;
	struct list_head	device_entry;
	struct mutex		buf_lock;
	unsigned		users;
	u8			*buffer;
};

struct si3050_platform_data {
	unsigned int reset;
	unsigned int id;
};


int  si3050_spidev_probe(struct spi_device *spi);
int  si3050_spidev_remove(struct spi_device *spi);
int  si3050_spidev_init(void);
void si3050_spidev_exit(void);
void si3050_reset(unsigned int gpio);
#endif	/* __SND_ASoC_SI3050_H__ */

