/*
 * drivers/media/video/ov2643_regs.h
 *
 * Register definitions for the OV2643 CameraChip.
 *
 * Copyright (C) 2011 DSPG.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

#ifndef OV2643_REGS_H
#define OV2643_REGS_H

/*
 * System Control Registers
 */
#define OV2643_AGC_H                           0x3000
#define OV2643_AGC_L                           0x3001
#define OV2643_AEC_H                           0x3002
#define OV2643_AEC_L                           0x3003
#define OV2643_AECL                            0x3004
#define OV2643_RED                             0x3005
#define OV2643_GREEN                           0x3006
#define OV2643_BLUE                            0x3007
#define OV2643_PIDH                            0x000A
#define OV2643_PIDL                            0x000B
#define OV2643_SCCB_ID                         0x300C
#define OV2643_PCLK                            0x300D
#define OV2643_PCLK_HREFQUAL_OUT               (1 << 5)
#define OV2643_PCLK_REVERSE                    (1 << 4)
#define OV2643_PCLK_DIVBY4                     (1 << 1)
#define OV2643_PCLK_DIVBY2                     1

#define OV2643_PLL_1                           0x300E
#define OV2643_PLL_1_RXPLL_MASK                        0x3F

#define OV2643_PLL_2                           0x300F
#define OV2643_PLL_2_FREQDIV_MASK              (0x3 << 6)
#define OV2643_PLL_2_FREQDIV_1                 (0x0 << 6)
#define OV2643_PLL_2_FREQDIV_1_5               (0x1 << 6)
#define OV2643_PLL_2_FREQDIV_2                 (0x2 << 6)
#define OV2643_PLL_2_FREQDIV_3                 (0x3 << 6)

#define OV2643_PLL_2_BIT8DIV_MASK              (0x3 << 4)
#define OV2643_PLL_2_BIT8DIV_1                 (0x0 << 4)
#define OV2643_PLL_2_BIT8DIV_1_2               (0x1 << 4)
#define OV2643_PLL_2_BIT8DIV_4                 (0x2 << 4)
#define OV2643_PLL_2_BIT8DIV_5                 (0x3 << 4)
#define OV2643_PLL_2_BYPASS                    (1 << 3)

#define OV2643_PLL_2_INDIV_MASK                        0x3
#define OV2643_PLL_2_INDIV_1                   0x0
#define OV2643_PLL_2_INDIV_1_5                 0x1
#define OV2643_PLL_2_INDIV_2                   0x2
#define OV2643_PLL_2_INDIV_3                   0x3

#define OV2643_PLL_3                           0x3010
#define OV2643_PLL_3_DVPDIV_MASK               (0x3 << 6)
#define OV2643_PLL_3_DVPDIV_1                  (0x0 << 6)
#define OV2643_PLL_3_DVPDIV_2                  (0x1 << 6)
#define OV2643_PLL_3_DVPDIV_8                  (0x2 << 6)
#define OV2643_PLL_3_DVPDIV_16                 (0x3 << 6)

#define OV2643_PLL_3_LANEDIV2LANES             (1 << 5)
#define OV2643_PLL_3_SENSORDIV2                        (1 << 4)

#define OV2643_PLL_3_SCALEDIV_MASK             0xF

#define OV2643_CLK                             0x3011
#define OV2643_CLK_DFREQDBL                    (1 << 7)
#define OV2643_CLK_SLAVEMODE                   (1 << 6)
#define OV2643_CLK_DIV_MASK                    0x3F

#define OV2643_SYS                             0x12
#define OV2643_SYS_SRST                                (1 << 7)
#define OV2643_SYS_BASERES_MASK                        (0x7 << 4)
#define OV2643_SYS_BASERES_QXGA                        (0x0 << 4)
#define OV2643_SYS_BASERES_XGA                 (0x1 << 4)
#define OV2643_SYS_BASERES_SXGA                        (0x7 << 4)

#define OV2643_AUTO_1                          0x3013
#define OV2643_AUTO_1_FASTAEC                  (1 << 7)
#define OV2643_AUTO_1_AECBIGSTEPS              (1 << 6)
#define OV2643_AUTO_1_BANDINGFILTEREN          (1 << 5)
#define OV2643_AUTO_1_AUTOBANDINGFILTER                (1 << 4)
#define OV2643_AUTO_1_EXTRBRIGHTEXPEN          (1 << 3)
#define OV2643_AUTO_1_AGCEN                    (1 << 2)
#define OV2643_AUTO_1_AECEN                    1

#define OV2643_AUTO_2                          0x3014
#define OV2643_AUTO_2_MANBANDING50             (1 << 7)
#define OV2643_AUTO_2_AUTOBANDINGDETEN         (1 << 6)
#define OV2643_AUTO_2_AGCADDLT1F               (1 << 5)
#define OV2643_AUTO_2_FREEZEAECAGC             (1 << 4)
#define OV2643_AUTO_2_NIGHTMODEEN              (1 << 3)
#define OV2643_AUTO_2_BANDINGSMOOTHSW          (1 << 2)
#define OV2643_AUTO_2_MANEXTRBRIGHTEXPEN       (1 << 1)
#define OV2643_AUTO_2_BANDINGFILTEREN          1

#define OV2643_AUTO_3                          0x3015
#define OV2643_AUTO_3_DUMMYFC_MASK             (0x7 << 4)
#define OV2643_AUTO_3_DUMMYFC_NONE             (0x0 << 4)
#define OV2643_AUTO_3_DUMMYFC_1FRAME           (0x1 << 4)
#define OV2643_AUTO_3_DUMMYFC_2FRAME           (0x2 << 4)
#define OV2643_AUTO_3_DUMMYFC_3FRAME           (0x3 << 4)
#define OV2643_AUTO_3_DUMMYFC_7FRAME           (0x7 << 4)

#define OV2643_AUTO_3_AGCGAINCEIL_MASK         0x7
#define OV2643_AUTO_3_AGCGAINCEIL_2X           0x0
#define OV2643_AUTO_3_AGCGAINCEIL_4X           0x1
#define OV2643_AUTO_3_AGCGAINCEIL_8X           0x2
#define OV2643_AUTO_3_AGCGAINCEIL_16X          0x3
#define OV2643_AUTO_3_AGCGAINCEIL_32X          0x4
#define OV2643_AUTO_3_AGCGAINCEIL_64X          0x5
#define OV2643_AUTO_3_AGCGAINCEIL_128X         0x6
#define OV2643_AUTO_3_AGCGAINCEIL_128X_2       0x7

#define OV2643_AUTO_5                          0x3017
#define OV2643_AUTO_5_MANBANDINGCNT_MASK       0x3F

#define OV2643_WPT_HISH                                0x3018
#define OV2643_BPT_HISL                                0x3019
#define OV2643_VPT                             0x301A
#define OV2643_YAVG                            0x301B
#define OV2643_AECG_MAX50                      0x301C
#define OV2643_AECG_MAX60                      0x301D
#define OV2643_RZM_H                           0x301E
#define OV2643_RZM_L                           0x301F

#define OV2643_HS_H                            0x3020
#define OV2643_HS_L                            0x3021
#define OV2643_VS_H                            0x3022
#define OV2643_VS_L                            0x3023
#define OV2643_HW_H                            0x3024
#define OV2643_HW_L                            0x3025
#define OV2643_VH_H                            0x3026
#define OV2643_VH_L                            0x3027
#define OV2643_HTS_H                           0x3028
#define OV2643_HTS_L                           0x3029
#define OV2643_VTS_H                           0x302A
#define OV2643_VTS_L                           0x302B
#define OV2643_EXHTS                           0x302C
#define OV2643_EXVTS_H                         0x302D
#define OV2643_EXVTS_L                         0x302E

#define OV2643_WEIGHT0                         0x3030
#define OV2643_WEIGHT1                         0x3031
#define OV2643_WEIGHT2                         0x3032
#define OV2643_WEIGHT3                         0x3033
#define OV2643_WEIGHT4                         0x3034
#define OV2643_WEIGHT5                         0x3035
#define OV2643_WEIGHT6                         0x3036
#define OV2643_WEIGHT7                         0x3037
#define OV2643_AHS_H                           0x3038
#define OV2643_AHS_L                           0x3039
#define OV2643_AVS_H                           0x303A
#define OV2643_AVS_L                           0x303B
#define OV2643_AHW_H                           0x303C
#define OV2643_AHW_L                           0x303D
#define OV2643_AVH_H                           0x303E
#define OV2643_AVH_L                           0x303F

#define OV2643_HISTO0                          0x3040
#define OV2643_HISTO1                          0x3041
#define OV2643_HISTO2                          0x3042
#define OV2643_HISTO3                          0x3043
#define OV2643_HISTO4                          0x3044
#define OV2643_HISTO5                          0x3045
#define OV2643_HISTO6                          0x3046
#define OV2643_HISTO7                          0x3047
#define OV2643_D56C1                           0x3048

#define OV2643_BLC9                            0x3069

#define OV2643_BD50_H                          0x3070
#define OV2643_BD50_L                          0x3071
#define OV2643_BD60_H                          0x3072
#define OV2643_BD60_L                          0x3073
#define OV2643_VSYNCOPT                                0x3075
#define OV2643_TMC1                            0x3077
#define OV2643_TMC1_CHSYNCSWAP                 (1 << 7)
#define OV2643_TMC1_HREFSWAP                   (1 << 6)
#define OV2643_TMC1_HREFPOL_NEG                        (1 << 3)
#define OV2643_TMC1_VSYNCPOL_NEG               (1 << 1)
#define OV2643_TMC1_HSYNCPOL_NEG               1

#define OV2643_TMC2                            0x3078
#define OV2643_TMC2_VSYNCDROP                  (1 << 1)
#define OV2643_TMC2_FRAMEDATADROP              1

#define OV2643_TMC3                            0x3079
#define OV2643_TMC3_VSLATCH                    (1 << 7)

#define OV2643_TMC4                            0x307A
#define OV2643_TMC5                            0x307B
#define OV2643_TMC5_AWB_GAINWRITE_DIS          (1 << 7)
#define OV2643_TMC5_DCOLORBAREN                        (1 << 3)
#define OV2643_TMC5_DCOLORBARPAT_MASK          0x7

#define OV2643_TMC6                            0x307C
#define OV2643_TMC6_DGAINEN                    (1 << 5)
#define OV2643_TMC6_HMIRROR                    (1 << 1)
#define OV2643_TMC6_VFLIP                      (1 << 0)

#define OV2643_TMC7                            0x307D
#define OV2643_TMC7_COLORBARTESTPATEN          (1 << 7)
#define OV2643_TMC7_AVGHIST_SENSOR             (1 << 5)

#define OV2643_TMC8                            0x307E

#define OV2643_TMCA                            0x3080
#define OV2643_TMCB                            0x3081
#define OV2643_TMCB_MIRROROPTEN                        (1 << 7)
#define OV2643_TMCB_OTPFASTMEMCLK              (1 << 6)
#define OV2643_TMCB_SWAPBYTESOUT               1

#define OV2643_TMCF                            0x3085
#define OV2643_TMC10                           0x3086
#define OV2643_TMC10_SYSRST                    (1 << 3)
#define OV2643_TMC10_REGSLEEPOPT               (1 << 2)
#define OV2643_TMC10_SLEEPOPT                  (1 << 1)
#define OV2643_TMC10_SLEEPEN                   1

#define OV2643_TMC11                           0x3087
#define OV2643_ISP_XOUT_H                      0x3088
#define OV2643_ISP_XOUT_L                      0x3089
#define OV2643_ISP_YOUT_H                      0x308A
#define OV2643_ISP_YOUT_L                      0x308B
#define OV2643_TMC13                           0x308D
#define OV2643_5060                            0x308E
#define OV2643_OTP                             0x308F

#define OV2643_IO_CTRL0                                0x30B0
#define OV2643_IO_CTRL1                                0x30B1
#define OV2643_IO_CTRL2                                0x30B2
#define OV2643_DVP0                            0x30B4
#define OV2643_DVP1                            0x30B5
#define OV2643_DVP2                            0x30B6
#define OV2643_DVP3                            0x30B7
#define OV2643_DSPC0                           0x30B8
#define OV2643_DSPC1                           0x30B9
#define OV2643_DSPC2                           0x30BA
#define OV2643_DSPC3                           0x30BB
#define OV2643_DSPC7                           0x30BF
/*
 * END - System Control Registers
 */

/*
 * SC Registers
 */
#define OV2643_SC_CTRL0                                0x3100
#define OV2643_SC_CTRL2                                0x3102
#define OV2643_SC_SYN_CTRL0                    0x3104
#define OV2643_SC_SYN_CTRL1                    0x3105
#define OV2643_SC_SYN_CTRL2                    0x3106
#define OV2643_SC_SYN_CTRL3                    0x3107
/*
 * END - SC Registers
 */

/*
 * CIF Registers
 */
#define OV2643_CIF_CTRL0                       0x3200
#define OV2643_CIF_CTRL4                       0x3204
/*
 * END - CIF Registers
 */

/*
 * DSP Registers
 */
#define OV2643_DSP_CTRL_0                      0x3300
#define OV2643_DSP_CTRL_1                      0x3301
#define OV2643_DSP_CTRL_2                      0x3302
#define OV2643_DSP_CTRL_4                      0x3304
#define OV2643_AWB_CTRL_3                      0x3308

#define OV2643_YST1                            0x331B
#define OV2643_YST2                            0x331C
#define OV2643_YST3                            0x331D
#define OV2643_YST4                            0x331E
#define OV2643_YST5                            0x331F

#define OV2643_YST6                            0x3320
#define OV2643_YST7                            0x3321
#define OV2643_YST8                            0x3322
#define OV2643_YST9                            0x3323
#define OV2643_YST10                           0x3324
#define OV2643_YST11                           0x3325
#define OV2643_YST12                           0x3326
#define OV2643_YST13                           0x3327
#define OV2643_YST14                           0x3328
#define OV2643_YST15                           0x3329
#define OV2643_YSLP15                          0x332A
#define OV2643_MISC_CTRL                       0x332B
#define OV2643_DNS_TH                          0x332C
#define OV2643_Y_EDGE_MT                       0x332D
#define OV2643_Y_EDGE_TH_TM                    0x332E
#define OV2643_BASE1                           0x332F

#define OV2643_BASE2                           0x3330
#define OV2643_OFFSET                          0x3331
#define OV2643_CMXSIGN_MISC                    0x333F

#define OV2643_CMX_1                           0x3340
#define OV2643_CMX_2                           0x3341
#define OV2643_CMX_3                           0x3342
#define OV2643_CMX_4                           0x3343
#define OV2643_CMX_5                           0x3344
#define OV2643_CMX_6                           0x3345
#define OV2643_CMX_7                           0x3346
#define OV2643_CMX_8                           0x3347
#define OV2643_CMX_9                           0x3348
#define OV2643_CMXSIGN                         0x3349

#define OV2643_SGNSET                          0x3354
#define OV2643_SDE_CTRL                                0x3355
#define OV2643_HUE_COS                         0x3356
#define OV2643_HUE_SIN                         0x3357
#define OV2643_SAT_U                           0x3358
#define OV2643_SAT_V                           0x3359
#define OV2643_UREG                            0x335A
#define OV2643_VREG                            0x335B
#define OV2643_YOFFSET                         0x335C
#define OV2643_YGAIN                           0x335D
#define OV2643_YBRIGHT                         0x335E
#define OV2643_SIZE_IN_MISC                    0x335F

#define OV2643_HSIZE_IN_L                      0x3360
#define OV2643_VSIZE_IN_L                      0x3361
#define OV2643_SIZE_OUT_MISC                   0x3362
#define OV2643_HSIZE_OUT_L                     0x3363
#define OV2643_VSIZE_OUT_L                     0x3364

#define OV2643_R_XY0                           0x3367
#define OV2643_R_X0                            0x3368
#define OV2643_R_Y0                            0x3369
#define OV2643_R_A1                            0x336A
#define OV2643_R_A2_B2                         0x336B
#define OV2643_R_B1                            0x336C
#define OV2643_G_XY0                           0x336D
#define OV2643_G_X0                            0x336E
#define OV2643_G_Y0                            0x336F

#define OV2643_G_A1                            0x3370
#define OV2643_G_A2_B2                         0x3371
#define OV2643_G_B1                            0x3372
#define OV2643_B_XY0                           0x3373
#define OV2643_B_X0                            0x3374
#define OV2643_B_Y0                            0x3375
#define OV2643_B_A1                            0x3376
#define OV2643_B_A2_B2                         0x3377
#define OV2643_B_B1                            0x3378

#define OV2643_MISC_DCW_SIZE                   0x33A4
#define OV2643_DCW_OH                          0x33A5
#define OV2643_DCW_OV                          0x33A6
#define OV2643_R_GAIN_M                                0x33A7
#define OV2643_G_GAIN_M                                0x33A8
#define OV2643_B_GAIN_M                                0x33A9
#define OV2643_OVLY_MISC1                      0x33AA
#define OV2643_OVLY_LEFT                       0x33AB
#define OV2643_OVLY_TOP                                0x33AC
#define OV2643_OVLY_MISC2                      0x33AD
#define OV2643_OVLY_RIGHT                      0x33AE
#define OV2643_OVLY_BOTTEM                     0x33AF

#define OV2643_OVLY_MISC3                      0x33B0
#define OV2643_OVLY_EXT_WIDTH_H                        0x33B1
#define OV2643_OVLY_EXT_WIDTH_L                        0x33B2
#define OV2643_OVLY_Y                          0x33B3
#define OV2643_OVLY_U                          0x33B4
#define OV2643_OVLY_V                          0x33B5
/*
 * END - DSP Registers
 */

/*
 * FMT MUX Registers
 */
#define OV2643_FMT_MUX_CTRL0                   0x3400
#define OV2643_ISP_PAD_CTR2                    0x3403
#define OV2643_FMT_CTRL00                      0x3404
#define OV2643_FMT_CTRL00_UV_sel_SHIFT         7
#define OV2643_FMT_CTRL00_UV_sel_MASK          (0x1 << \
                                               OV2643_FMT_CTRL00_UV_sel_SHIFT)
#define OV2643_FMT_CTRL00_UV_sel_USE_UV_avg_Y  (0x0 << \
                                               OV2643_FMT_CTRL00_UV_sel_SHIFT)
#define OV2643_FMT_CTRL00_UV_sel_USE_U0Y0_V0Y1 (0x1 << \
                                               OV2643_FMT_CTRL00_UV_sel_SHIFT)

#define OV2643_FMT_CTRL00_YUV422_in_SHIFT      6
#define OV2643_FMT_CTRL00_YUV422_in_MASK       (0x1 << \
                                       OV2643_FMT_CTRL00_YUV422_in_SHIFT)
#define OV2643_FMT_CTRL00_YUV422_in_DISABLE    (0x0 << \
                                       OV2643_FMT_CTRL00_YUV422_in_SHIFT)
#define OV2643_FMT_CTRL00_YUV422_in_ENABLE     (0x1 << \
                                       OV2643_FMT_CTRL00_YUV422_in_SHIFT)

#define OV2643_FMT_CTRL00_FMT_SHIFT            0
#define OV2643_FMT_CTRL00_FMT_MASK             (0x3F << \
                                               OV2643_FMT_CTRL00_FMT_SHIFT)
#define OV2643_DITHER_CTRL0                    0x3405
/*
 * END - FMT MUX Registers
 */

/*
 * OUT_TOP Registers
 */
#define OV2643_OUT_CTRL00                      0x3600
#define OV2643_OUT_CTRL00_VSYNCSEL2            (1 << 7)
#define OV2643_OUT_CTRL00_VSYNCGATE            (1 << 6)
#define OV2643_OUT_CTRL00_PCLKPOL_NEG          (1 << 4)
#define OV2643_OUT_CTRL00_HREFPOL_NEG          (1 << 3)
#define OV2643_OUT_CTRL00_VSYNCPOL_NEG         (1 << 2)
#define OV2643_OUT_CTRL00_VSYNCSEL             (1 << 1)
#define OV2643_OUT_CTRL00_DVPOUTDATAORDERINV   1

#define OV2643_OUT_CTRL01                      0x3601
#define OV2643_OUT_CTRL01_PCLKGATEEN           (1 << 7)
#define OV2643_OUT_CTRL01_CCIR656EN            (1 << 4)
#define OV2643_OUT_CTRL01_MIPIBIT8             1

#define OV2643_MIPI_CTRL02                     0x3602
#define OV2643_MIPI_CTRL02_DVPDISABLE          (1 << 4)
#define OV2643_MIPI_CTRL02_MIPILINESYNCEN      (1 << 2)
#define OV2643_MIPI_CTRL02_MIPIGATESCEN                (1 << 1)

#define OV2643_MIPI_CTRL03                     0x3603
#define OV2643_MIPI_CTRL03_ECC_PHBYTEORDER     (1 << 2)
#define OV2643_MIPI_CTRL03_ECC_PHBITORDER      (1 << 1)

#define OV2643_OUT_CTRL08                      0x3608
#define OV2643_OUT_CTRL08_HREF_DLY_SHIFT       4
#define OV2643_OUT_CTRL08_HREF_DLY_MASK                (0xF << \
                                       OV2643_OUT_CTRL08_HREF_DLY_SHIFT)


#define OV2643_OUT_CTRL09                      0x3609
#define OV2643_OUT_CTRL0A                      0x360A
#define OV2643_OUT_CTRL0B                      0x360B
#define OV2643_MIPI_CTRL0C                     0x360C
#define OV2643_MIPI_CTRL0C_VIRTUALCH_ID_MASK   (0x3 << 6)

#define OV2643_OUT_CTRL0D                      0x360D
#define OV2643_MIPI_CTRL0E                     0x360E
#define OV2643_MIPI_CTRL0E_WKUPDELAY_MASK      0x3F


#define OV2643_MIPI_CTRL10                     0x3610
#define OV2643_MIPI_CTRL10_WIDTH_MAN_L_MASK    0xFF

#define OV2643_MIPI_CTRL11                     0x3611
#define OV2643_MIPI_CTRL11_WIDTH_MAN_H_MASK    (0x7 << 5)

#define OV2643_CLIP_MIN                                0x3614
#define OV2643_CLIP_MAX                                0x3615
#define OV2643_OUT_CTRL16                      0x3616
#define OV2643_OUT_CTRL1D                      0x361D
#define OV2643_OUT_CTRL1E                      0x361E
#define OV2643_MIPI_CTRL1F                     0x361F
#define OV2643_MIPI_CTRL1F_PCLK_PERIOD_MASK    0xFF

#define OV2643_MIPI_CTRL22                     0x3622
#define OV2643_MIPI_CTRL22_MIN_HS_ZERO_NUI_SHIFT       2
#define OV2643_MIPI_CTRL22_MIN_HS_ZERO_NUI_MASK                (0x3F << \
                               OV2643_MIPI_CTRL22_MIN_HS_ZERO_NUI_SHIFT)
#define OV2643_MIPI_CTRL22_MIN_HS_ZERO_H_MASK  0x3

#define OV2643_MIPI_CTRL23                     0x3623
#define OV2643_MIPI_CTRL23_MIN_HS_ZERO_L_MASK  0xFF

#define OV2643_MIPI_CTRL24                     0x3624
#define OV2643_MIPI_CTRL24_MIN_HS_TRAIL_NUI_SHIFT      2
#define OV2643_MIPI_CTRL24_MIN_HS_TRAIL_NUI_MASK       (0x3F << \
                               OV2643_MIPI_CTRL24_MIN_HS_TRAIL_NUI_SHIFT)
#define OV2643_MIPI_CTRL24_MIN_HS_TRAIL_H_MASK 0x3

#define OV2643_MIPI_CTRL25                     0x3625
#define OV2643_MIPI_CTRL25_MIN_HS_TRAIL_L_MASK 0xFF

#define OV2643_MIPI_CTRL26                     0x3626
#define OV2643_MIPI_CTRL26_MIN_CLK_ZERO_NUI_SHIFT      2
#define OV2643_MIPI_CTRL26_MIN_CLK_ZERO_NUI_MASK       (0x3F << \
                               OV2643_MIPI_CTRL26_MIN_CLK_ZERO_NUI_SHIFT)
#define OV2643_MIPI_CTRL26_MIN_CLK_ZERO_H_MASK 0x3

#define OV2643_MIPI_CTRL27                     0x3627
#define OV2643_MIPI_CTRL27_MIN_CLK_ZERO_L_MASK 0xFF

#define OV2643_MIPI_CTRL28                     0x3628
#define OV2643_MIPI_CTRL28_MIN_CLK_PREPARE_NUI_SHIFT   2
#define OV2643_MIPI_CTRL28_MIN_CLK_PREPARE_NUI_MASK            (0x3F << \
                               OV2643_MIPI_CTRL28_MIN_CLK_PREPARE_NUI_SHIFT)
#define OV2643_MIPI_CTRL28_MIN_CLK_PREPARE_H_MASK      0x3

#define OV2643_MIPI_CTRL29                     0x3629
#define OV2643_MIPI_CTRL29_MIN_CLK_PREPARE_L_MASK      0xFF

#define OV2643_MIPI_CTRL2A                     0x362A
#define OV2643_MIPI_CTRL2A_MAX_CLK_PREPARE_NUI_SHIFT   2
#define OV2643_MIPI_CTRL2A_MAX_CLK_PREPARE_NUI_MASK            (0x3F << \
                               OV2643_MIPI_CTRL2A_MAX_CLK_PREPARE_NUI_SHIFT)
#define OV2643_MIPI_CTRL2A_MAX_CLK_PREPARE_H_MASK      0x3

#define OV2643_MIPI_CTRL2B                     0x362B
#define OV2643_MIPI_CTRL2B_MAX_CLK_PREPARE_L_MASK      0xFF

#define OV2643_MIPI_CTRL2C                     0x362C
#define OV2643_MIPI_CTRL2C_MIN_CLK_POST_NUI_SHIFT      2
#define OV2643_MIPI_CTRL2C_MIN_CLK_POST_NUI_MASK       (0x3F << \
                               OV2643_MIPI_CTRL2C_MIN_CLK_POST_NUI_SHIFT)
#define OV2643_MIPI_CTRL2C_MIN_CLK_POST_H_MASK 0x3

#define OV2643_MIPI_CTRL2D                     0x362D
#define OV2643_MIPI_CTRL2D_MIN_CLK_POST_L_MASK 0xFF

#define OV2643_MIPI_CTRL2E                     0x362E
#define OV2643_MIPI_CTRL2E_MIN_CLK_TRAIL_NUI_SHIFT     2
#define OV2643_MIPI_CTRL2E_MIN_CLK_TRAIL_NUI_MASK      (0x3F << \
                               OV2643_MIPI_CTRL2E_MIN_CLK_TRAIL_NUI_SHIFT)
#define OV2643_MIPI_CTRL2E_MIN_CLK_TRAIL_H_MASK        0x3

#define OV2643_MIPI_CTRL2F                     0x362F
#define OV2643_MIPI_CTRL2F_MIN_CLK_TRAIL_L_MASK        0xFF

#define OV2643_MIPI_CTRL30                     0x3630
#define OV2643_MIPI_CTRL30_MIN_LPX_P_NUI_SHIFT 2
#define OV2643_MIPI_CTRL30_MIN_LPX_P_NUI_MASK  (0x3F << \
                                       OV2643_MIPI_CTRL30_MIN_LPX_P_NUI_SHIFT)
#define OV2643_MIPI_CTRL30_MIN_LPX_P_H_MASK    0x3

#define OV2643_MIPI_CTRL31                     0x3631
#define OV2643_MIPI_CTRL31_MIN_LPX_P_L_MASK    0xFF

#define OV2643_MIPI_CTRL32                     0x3632
#define OV2643_MIPI_CTRL32_MIN_HS_PREPARE_NUI_SHIFT    2
#define OV2643_MIPI_CTRL32_MIN_HS_PREPARE_NUI_MASK     (0x3F << \
                               OV2643_MIPI_CTRL32_MIN_HS_PREPARE_NUI_SHIFT)
#define OV2643_MIPI_CTRL32_MIN_HS_PREPARE_H_MASK       0x3

#define OV2643_MIPI_CTRL33                     0x3633
#define OV2643_MIPI_CTRL33_MIN_HS_PREPARE_L_MASK       0xFF

#define OV2643_MIPI_CTRL34                     0x3634
#define OV2643_MIPI_CTRL34_MAX_HS_PREPARE_NUI_SHIFT    2
#define OV2643_MIPI_CTRL34_MAX_HS_PREPARE_NUI_MASK     (0x3F << \
                               OV2643_MIPI_CTRL34_MAX_HS_PREPARE_NUI_SHIFT)
#define OV2643_MIPI_CTRL34_MAX_HS_PREPARE_H_MASK       0x3

#define OV2643_MIPI_CTRL35                     0x3635
#define OV2643_MIPI_CTRL35_MAX_HS_PREPARE_L_MASK       0xFF

#define OV2643_MIPI_CTRL36                     0x3636
#define OV2643_MIPI_CTRL36_MIN_HS_EXIT_NUI_SHIFT       2
#define OV2643_MIPI_CTRL36_MIN_HS_EXIT_NUI_MASK        (0x3F << \
                               OV2643_MIPI_CTRL36_MIN_HS_EXIT_NUI_SHIFT)
#define OV2643_MIPI_CTRL36_MIN_HS_EXIT_H_MASK  0x3

#define OV2643_MIPI_CTRL37                     0x3637
#define OV2643_MIPI_CTRL37_MIN_HS_EXIT_L_MASK  0xFF

#define OV2643_OUT_CTRL3C                      0x363C
#define OV2643_MIPI_CTRL3D                     0x363D
#define OV2643_MIPI_CTRL3D_JPGPADEN            (1 << 6)
#define OV2643_OUT_CTRL3E                      0x363E
#define OV2643_OUT_CTRL3F                      0x363F

#define OV2643_OUT_CTRL40                      0x3640
#define OV2643_OUT_CTRL43                      0x3643
#define OV2643_OUT_CTRL44                      0x3644
#define OV2643_OUT_CTRL46                      0x3646
#define OV2643_MIPI_CTRL4C                     0x364C
#define OV2643_MIPI_CTRL4C_ECC_PHBYTEORDER2    (1 << 2)
/*
 * END - OUT_TOP Registers
 */
/*
 * MC Registers
 */
#define OV2643_INTR_MASK0                      0x3700
#define OV2643_INTR_MASK1                      0x3701
#define OV2643_INTR0                           0x3708
#define OV2643_INTR1                           0x3709
/*
 * END - MC Registers
 */

#endif /* ifndef OV2643_REGS_H */


