/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.ExtSequence;
import gnu.lists.LListPosition;
import gnu.lists.Pair;
import gnu.lists.PositionManager;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Iterator;
import java.util.List;

public class LList
extends ExtSequence
implements Sequence,
Externalizable,
Comparable {
    public static final LList Empty = new LList();

    public static int listLength(Object object2, boolean bl) {
        int n = 0;
        Object object3 = object2;
        Object object4 = object2;
        while (object4 != Empty) {
            if (!(object4 instanceof Pair)) {
                if (object4 instanceof Sequence && bl) {
                    int n2 = ((Sequence)object4).size();
                    return n2 >= 0 ? n + n2 : n2;
                }
                return -2;
            }
            Pair pair = (Pair)object4;
            if (pair.cdr == Empty) {
                return n + 1;
            }
            if (object4 == object3 && n > 0) {
                return -1;
            }
            if (!(pair.cdr instanceof Pair)) {
                ++n;
                object4 = pair.cdr;
                continue;
            }
            if (!(object3 instanceof Pair)) {
                return -2;
            }
            object3 = ((Pair)object3).cdr;
            object4 = ((Pair)pair.cdr).cdr;
            n += 2;
        }
        return n;
    }

    public boolean equals(Object object2) {
        return this == object2;
    }

    public int compareTo(Object object2) {
        return object2 == Empty ? 0 : -1;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public SeqPosition getIterator(int n) {
        return new LListPosition(this, n, false);
    }

    public int createPos(int n, boolean bl) {
        LListPosition lListPosition = new LListPosition(this, n, bl);
        return PositionManager.manager.register(lListPosition);
    }

    public int createRelativePos(int n, int n2, boolean bl) {
        boolean bl2 = this.isAfterPos(n);
        if (n2 < 0 || n == 0) {
            return super.createRelativePos(n, n2, bl);
        }
        if (n2 == 0) {
            if (bl == bl2) {
                return this.copyPos(n);
            }
            if (bl && !bl2) {
                return super.createRelativePos(n, n2, bl);
            }
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        LListPosition lListPosition = (LListPosition)PositionManager.getPositionObject(n);
        if (lListPosition.xpos == null) {
            return super.createRelativePos(n, n2, bl);
        }
        LListPosition lListPosition2 = new LListPosition(lListPosition);
        Object object2 = lListPosition2.xpos;
        int n3 = lListPosition2.ipos;
        if (bl && !bl2) {
            --n2;
            n3 += 3;
        }
        if (!bl && bl2) {
            ++n2;
            n3 -= 3;
        }
        while (true) {
            if (!(object2 instanceof Pair)) {
                throw new IndexOutOfBoundsException();
            }
            if (--n2 < 0) break;
            Pair pair = (Pair)object2;
            n3 += 2;
            object2 = pair.cdr;
        }
        lListPosition2.ipos = n3;
        lListPosition2.xpos = object2;
        return PositionManager.manager.register(lListPosition2);
    }

    public boolean hasNext(int n) {
        return false;
    }

    public int nextPos(int n) {
        return 0;
    }

    public Object getPosNext(int n) {
        return eofValue;
    }

    public Object getPosPrevious(int n) {
        return eofValue;
    }

    protected void setPosNext(int n, Object object2) {
        if (n <= 0) {
            if (n == -1 || !(this instanceof Pair)) {
                throw new IndexOutOfBoundsException();
            }
            ((Pair)this).car = object2;
        } else {
            PositionManager.getPositionObject(n).setNext(object2);
        }
    }

    protected void setPosPrevious(int n, Object object2) {
        if (n <= 0) {
            if (n == 0 || !(this instanceof Pair)) {
                throw new IndexOutOfBoundsException();
            }
            ((Pair)this).lastPair().car = object2;
        } else {
            PositionManager.getPositionObject(n).setPrevious(object2);
        }
    }

    public Object get(int n) {
        throw new IndexOutOfBoundsException();
    }

    public static final int length(Object object2) {
        int n = 0;
        while (object2 instanceof Pair) {
            ++n;
            object2 = ((Pair)object2).cdr;
        }
        return n;
    }

    public static LList makeList(List list) {
        Iterator iterator = list.iterator();
        LList lList = Empty;
        Pair pair = null;
        while (iterator.hasNext()) {
            Pair pair2 = new Pair(iterator.next(), Empty);
            if (pair == null) {
                lList = pair2;
            } else {
                pair.cdr = pair2;
            }
            pair = pair2;
        }
        return lList;
    }

    public static LList makeList(Object[] objectArray, int n, int n2) {
        LList lList = Empty;
        int n3 = n2;
        while (--n3 >= 0) {
            lList = new Pair(objectArray[n + n3], lList);
        }
        return lList;
    }

    public static LList makeList(Object[] objectArray, int n) {
        LList lList = Empty;
        int n2 = objectArray.length - n;
        while (--n2 >= 0) {
            lList = new Pair(objectArray[n + n2], lList);
        }
        return lList;
    }

    public void consume(Consumer consumer) {
        Object object2 = this;
        consumer.startElement("list");
        while (object2 instanceof Pair) {
            if (object2 != this) {
                consumer.write(32);
            }
            Pair pair = (Pair)object2;
            consumer.writeObject(pair.car);
            object2 = pair.cdr;
        }
        if (object2 != Empty) {
            consumer.write(32);
            consumer.write(". ");
            consumer.writeObject(LList.checkNonList(object2));
        }
        consumer.endElement();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public Object readResolve() throws ObjectStreamException {
        return Empty;
    }

    public static Pair list1(Object object2) {
        return new Pair(object2, Empty);
    }

    public static Pair list2(Object object2, Object object3) {
        return new Pair(object2, new Pair(object3, Empty));
    }

    public static Pair list3(Object object2, Object object3, Object object4) {
        return new Pair(object2, new Pair(object3, new Pair(object4, Empty)));
    }

    public static Pair list4(Object object2, Object object3, Object object4, Object object5) {
        return new Pair(object2, new Pair(object3, new Pair(object4, new Pair(object5, Empty))));
    }

    public static Pair chain1(Pair pair, Object object2) {
        Pair pair2 = new Pair(object2, Empty);
        pair.cdr = pair2;
        return pair2;
    }

    public static Pair chain4(Pair pair, Object object2, Object object3, Object object4, Object object5) {
        Pair pair2 = new Pair(object5, Empty);
        pair.cdr = new Pair(object2, new Pair(object3, new Pair(object4, pair2)));
        return pair2;
    }

    public static LList reverseInPlace(Object object2) {
        LList lList = Empty;
        while (object2 != Empty) {
            Pair pair = (Pair)object2;
            object2 = pair.cdr;
            pair.cdr = lList;
            lList = pair;
        }
        return lList;
    }

    public static Object listTail(Object object2, int n) {
        while (--n >= 0) {
            if (!(object2 instanceof Pair)) {
                throw new IndexOutOfBoundsException("List is too short.");
            }
            Pair pair = (Pair)object2;
            object2 = pair.cdr;
        }
        return object2;
    }

    public static Object consX(Object[] objectArray) {
        Pair pair;
        Object object2 = objectArray[0];
        int n = objectArray.length - 1;
        if (n <= 0) {
            return object2;
        }
        Pair pair2 = pair = new Pair(object2, null);
        for (int i = 1; i < n; ++i) {
            Pair pair3 = new Pair(objectArray[i], null);
            pair2.cdr = pair3;
            pair2 = pair3;
        }
        pair2.cdr = objectArray[n];
        return pair;
    }

    public String toString() {
        Object object2 = this;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('(');
        while (object2 != Empty) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            if (n >= 10) {
                stringBuffer.append("...");
                break;
            }
            if (!(object2 instanceof Pair)) {
                stringBuffer.append(". ");
                stringBuffer.append(LList.checkNonList(object2));
                break;
            }
            Pair pair = (Pair)object2;
            stringBuffer.append(pair.car);
            object2 = pair.cdr;
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static Object checkNonList(Object object2) {
        return object2 instanceof LList ? "#<not a pair>" : object2;
    }
}

