# GNU Enterprise Forms - gtk2 UI Driver - Menu widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: menu.py 9956 2009-10-11 18:54:57Z reinhard $

import gtk

from gnue.forms.uidrivers.wx26.widgets._base import UIHelper


# =============================================================================
# Wrap an UI layer around a wxMenu widget
# =============================================================================

class UIMenu(UIHelper):
    """
    Implements a menu object.
    """

    # -------------------------------------------------------------------------
    # Create a menu widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new Menu widget.
        """

        label = self._gfObject.label or ""

        if self._gfObject.name == '__main_menu__' \
                and not self._form._features['GUI:MENUBAR:SUPPRESS']:
            # Menu bar of the form
            handle_box = gtk.HandleBox()
            widget = gtk.MenuBar()
            handle_box.add(widget)
            widget.show()
            self._uiForm.content_table.attach(handle_box,
                  # X direction             Y direction
                    0, 1,                   0, 1,
                    gtk.EXPAND | gtk.FILL,  0,
                    0,                      0)
        else:
            # Submenu or popup menu
            menuitem = gtk.MenuItem(label.replace("&", "_"))
            widget = gtk.Menu()
            menuitem.set_submenu(widget)
            if isinstance(event.container, gtk.Menu) \
                    or isinstance(event.container, gtk.MenuBar):
                event.container.add(menuitem)

        self._container = widget

        return widget


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIMenu,
  'provides' : 'GFMenu',
  'container': 1,
}
