#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# RadioButton.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from FocusedLabel import FocusedLabel

class RadioButton(FocusedLabel):
  """
  """
  def __init__(self,Root, Name, Y, X, Caption, Id, **properties):
    Caption = ' o ' + Caption
    FocusedLabel.__init__(self,Root,Name,Y,X,Caption,**properties)
    self.ID = Id
    self.SetMethod("PAINT",self.Paint)
    self.X = X
    self.Y = Y
    self.W = len(Caption)
    self.H = 1
    self._active = 'x'
    self._inactive = 'o'

  def Paint(self, v1,v2,v3):
    cap = self.CAPTION
    bullet = self._inactive
    if self.ACTIVE:
      bullet = self._active # chr(tiBULL)
    cap = cap[:1] + bullet + cap[2:]
    self.CAPTION = cap
    FocusedLabel.Paint(self,v1,v2,v3)
  

