/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.CompileVHDL;
import com.sun.electric.util.TextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateVHDL
extends Topology {
    private static final int BLOCKNORMAL = 0;
    private static final int BLOCKMOSTRAN = 1;
    private static final int BLOCKBUFFER = 2;
    private static final int BLOCKPOSLOGIC = 3;
    private static final int BLOCKINVERTER = 4;
    private static final int BLOCKNAND = 5;
    private static final int BLOCKNOR = 6;
    private static final int BLOCKXNOR = 7;
    private static final int BLOCKFLOPDS = 8;
    private static final int BLOCKFLOPDR = 9;
    private static final int BLOCKFLOPTS = 10;
    private static final int BLOCKFLOPTR = 11;
    private static final int BLOCKFLOP = 12;
    private static final String NORMALCONTINUATIONSTRING = "    ";
    private static final String COMMENTCONTINUATIONSTRING = "-- ";
    private final VHDLPreferences vp;

    private GenerateVHDL(VHDLPreferences vp) {
        this.vp = vp;
    }

    public static List<String> convertCell(Cell cell, VHDLPreferences vp) {
        if (cell.getNumPorts() == 0) {
            System.out.println("Cannot convert " + cell.describe(false) + " to VHDL: it has no ports");
            return null;
        }
        GenerateVHDL out = new GenerateVHDL(vp);
        out.openStringsOutputStream();
        out.setOutputWidth(80, false);
        out.setContinuationString(NORMALCONTINUATIONSTRING);
        if (out.writeCell(cell, null)) {
            return null;
        }
        return out.closeStringsOutputStream();
    }

    @Override
    protected void start() {
        this.setContinuationString(COMMENTCONTINUATIONSTRING);
        this.writeWidthLimited("-- VHDL automatically generated by the Electric VLSI Design System, version " + Version.getVersion() + "\n");
        this.setContinuationString(NORMALCONTINUATIONSTRING);
    }

    @Override
    protected void done() {
    }

    @Override
    protected void writeCellTopology(Cell cell, String cellName, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        String compName;
        this.writeWidthLimited("\n");
        this.setContinuationString(COMMENTCONTINUATIONSTRING);
        this.writeWidthLimited("-------------------- Cell " + cell.describe(false) + " --------------------\n");
        this.setContinuationString(NORMALCONTINUATIONSTRING);
        Netlist nl = cni.getNetList();
        String properCellName = this.getSafeCellName(cell.getName());
        this.writeWidthLimited("entity " + this.addString(properCellName, null) + " is port(" + this.addPortList(cni) + ");\n");
        this.writeWidthLimited("  end " + this.addString(properCellName, null) + ";\n");
        this.writeWidthLimited("\n");
        this.writeWidthLimited("architecture " + this.addString(properCellName, null) + "_BODY of " + this.addString(properCellName, null) + " is\n");
        int instNum = 1;
        HashMap<ArcInst, Integer> negatedHeads = new HashMap<ArcInst, Integer>();
        HashMap<ArcInst, Integer> negatedTails = new HashMap<ArcInst, Integer>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            if (ai.getHead().isNegated()) {
                negatedHeads.put(ai, new Integer(instNum++));
            }
            if (!ai.getTail().isNegated()) continue;
            negatedTails.put(ai, new Integer(instNum++));
        }
        HashSet<Integer> multiInputNAND = new HashSet<Integer>();
        HashSet<Integer> multiInputNOR = new HashSet<Integer>();
        HashSet<Integer> multiInputNXOR = new HashSet<Integer>();
        boolean gotInverters = false;
        HashSet<String> cellNamesWritten = new HashSet<String>();
        Iterator<Nodable> it2 = nl.getNodables();
        while (it2.hasNext()) {
            Nodable no = it2.next();
            AnalyzePrimitive ap = new AnalyzePrimitive(no, negatedHeads, negatedTails, this.vp);
            String pt = ap.getPrimName();
            if (pt == null) continue;
            int special = ap.getSpecial();
            if (special == 4) {
                gotInverters = true;
                continue;
            }
            if (special == 5) {
                multiInputNAND.add(new Integer(TextUtils.atoi(pt.substring(4))));
                continue;
            }
            if (special == 6) {
                multiInputNOR.add(new Integer(TextUtils.atoi(pt.substring(3))));
                continue;
            }
            if (special == 7) {
                multiInputNXOR.add(new Integer(TextUtils.atoi(pt.substring(4))));
                continue;
            }
            if (no.getProto().getNumPorts() == 0 || cellNamesWritten.contains(pt = this.getSafeCellName(pt))) continue;
            cellNamesWritten.add(pt);
            if (no.isCellInstance()) {
                String parameterizedName = this.parameterizedName(no, context);
                Topology.CellNetInfo subCni = this.getCellNetInfo(parameterizedName);
                if (subCni == null) {
                    System.out.println("ERROR: no subcell information for: " + parameterizedName);
                    continue;
                }
                this.writeWidthLimited("  component " + this.addString(pt, null) + " port(" + this.addPortList(subCni) + ");\n");
            } else {
                this.writeWidthLimited("  component " + this.addString(pt, null) + " port(" + this.addPortListPrim(no, special) + ");\n");
            }
            this.writeWidthLimited("    end component;\n");
        }
        for (Integer i : multiInputNAND) {
            compName = "nand" + i;
            cellNamesWritten.add(compName);
            this.writeWidthLimited("  component " + compName + " port(");
            for (int j = 1; j <= i; ++j) {
                if (j > 1) {
                    this.writeWidthLimited(", ");
                }
                this.writeWidthLimited("a" + j);
            }
            this.writeWidthLimited(": in BIT; y: out BIT);\n");
            this.writeWidthLimited("    end component;\n");
        }
        for (Integer i : multiInputNOR) {
            compName = "nor" + i;
            cellNamesWritten.add(compName);
            this.writeWidthLimited("  component " + compName + " port(");
            for (int j = 1; j <= i; ++j) {
                if (j > 1) {
                    this.writeWidthLimited(", ");
                }
                this.writeWidthLimited("a" + j);
            }
            this.writeWidthLimited(": in BIT; y: out BIT);\n");
            this.writeWidthLimited("    end component;\n");
        }
        for (Integer i : multiInputNXOR) {
            compName = "xnor" + i;
            cellNamesWritten.add(compName);
            this.writeWidthLimited("  component " + compName + " port(");
            for (int j = 1; j <= i; ++j) {
                if (j > 1) {
                    this.writeWidthLimited(", ");
                }
                this.writeWidthLimited("a" + j);
            }
            this.writeWidthLimited(": in BIT; y: out BIT);\n");
            this.writeWidthLimited("    end component;\n");
        }
        if (negatedHeads.size() > 0 || negatedTails.size() > 0) {
            gotInverters = true;
        }
        if (gotInverters) {
            cellNamesWritten.add("inverter");
            this.writeWidthLimited("  component inverter port(a: in BIT; y: out BIT);\n");
            this.writeWidthLimited("    end component;\n");
        }
        SignalNameLine snl = new SignalNameLine();
        Iterator<Object> it3 = cni.getCellSignals();
        while (it3.hasNext()) {
            Topology.CellSignal cs = it3.next();
            if (cs.getExport() != null || !cs.getNetwork().getArcs().hasNext()) continue;
            String sigName = this.addString(cs.getName(), cell);
            snl.addSignalName(sigName);
        }
        for (ArcInst ai : negatedHeads.keySet()) {
            Integer index2 = (Integer)negatedHeads.get(ai);
            String sigName = "PINV" + index2;
            snl.addSignalName(sigName);
        }
        for (ArcInst ai : negatedTails.keySet()) {
            Integer index3 = (Integer)negatedTails.get(ai);
            String sigName = "PINV" + index3;
            snl.addSignalName(sigName);
        }
        snl.finish();
        this.writeWidthLimited("\n");
        this.writeWidthLimited("begin\n");
        it3 = nl.getNodables();
        while (it3.hasNext()) {
            Nodable no = (Nodable)it3.next();
            if (no.getProto().getNumPorts() == 0) continue;
            int special = 0;
            String pt = no.getProto().getName();
            if (!no.isCellInstance()) {
                AnalyzePrimitive ap = new AnalyzePrimitive(no, negatedHeads, negatedTails, this.vp);
                pt = ap.getPrimName();
                if (pt == null) continue;
                special = ap.getSpecial();
            }
            String instname = this.getSafeCellName(no.getName());
            this.writeWidthLimited("  " + this.addString(instname, null));
            if (cellNamesWritten.contains(instname)) {
                this.writeWidthLimited("NV");
            }
            if (no.isCellInstance()) {
                String parameterizedName = this.parameterizedName(no, context);
                Topology.CellNetInfo subCni = this.getCellNetInfo(parameterizedName);
                if (subCni == null) {
                    System.out.println("STILL NO SUBCELL INFORMATION FOR " + parameterizedName);
                    continue;
                }
                this.writeWidthLimited(": " + this.addString(this.getSafeCellName(pt), null) + " port map(" + this.addRealPortsCell(subCni, no, negatedHeads, negatedTails, nl) + ");\n");
                continue;
            }
            this.writeWidthLimited(": " + this.addString(this.getSafeCellName(pt), null) + " port map(" + this.addRealPortsPrim(no, special, negatedHeads, negatedTails, nl) + ");\n");
        }
        for (ArcInst ai : negatedHeads.keySet()) {
            Integer index4 = (Integer)negatedHeads.get(ai);
            this.writeWidthLimited("  PSEUDO_INVERT" + index4 + ": inverter port map(");
            Network net = nl.getNetwork(ai, 0);
            if (ai.getHeadPortInst().getPortProto().getBasePort().getCharacteristic() == PortCharacteristic.OUT) {
                this.writeWidthLimited("PINV" + index4 + ", " + this.addString(net.describe(false), cell));
            } else {
                this.writeWidthLimited(this.addString(net.describe(false), cell) + ", PINV" + index4);
            }
            this.writeWidthLimited(");\n");
        }
        for (ArcInst ai : negatedTails.keySet()) {
            Integer index5 = (Integer)negatedTails.get(ai);
            this.writeWidthLimited("  PSEUDO_INVERT" + index5 + ": inverter port map(");
            Network net = nl.getNetwork(ai, 0);
            if (ai.getTailPortInst().getPortProto().getBasePort().getCharacteristic() == PortCharacteristic.OUT) {
                this.writeWidthLimited("PINV" + index5 + ", " + this.addString(net.describe(false), cell));
            } else {
                this.writeWidthLimited(this.addString(net.describe(false), cell) + ", PINV" + index5);
            }
            this.writeWidthLimited(");\n");
        }
        this.writeWidthLimited("end " + this.addString(properCellName, null) + "_BODY;\n");
    }

    private String addRealPortsCell(Topology.CellNetInfo cni, Nodable no, Map<ArcInst, Integer> negatedHeads, Map<ArcInst, Integer> negatedTails, Netlist nl) {
        Cell subCell = (Cell)no.getProto();
        Netlist subNL = cni.getNetList();
        boolean first = false;
        StringBuffer infstr = new StringBuffer();
        for (int pass = 0; pass < 5; ++pass) {
            Iterator<Export> it = subCell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (!this.matchesPass(e.getCharacteristic(), pass)) continue;
                int exportWidth = subNL.getBusWidth(e);
                for (int i = 0; i < exportWidth; ++i) {
                    Network net = nl.getNetwork(no, e, i);
                    boolean portNamed = false;
                    Iterator<Connection> cIt = no.getNodeInst().getConnections();
                    while (cIt.hasNext()) {
                        Integer index2;
                        Connection con = cIt.next();
                        PortProto otherPP = con.getPortInst().getPortProto();
                        if (otherPP instanceof Export) {
                            Export otherE = (Export)otherPP;
                            Cell equiv = otherE.getParent().getEquivalent();
                            otherPP = otherE.findEquivalent(equiv);
                        }
                        if (otherPP != e) continue;
                        ArcInst ai = con.getArc();
                        if (ai.getProto().getFunction() == ArcProto.Function.NONELEC || !con.isNegated() || (index2 = con.getEndIndex() == 1 ? negatedHeads.get(ai) : negatedTails.get(ai)) == null) break;
                        if (first) {
                            infstr.append(", ");
                        }
                        first = true;
                        String sigName = "PINV" + index2;
                        infstr.append(sigName);
                    }
                    if (portNamed) continue;
                    String sigName = this.addString(net.getName(), null);
                    if (!net.isExported() && !net.getArcs().hasNext()) {
                        sigName = "open";
                    }
                    if (first) {
                        infstr.append(", ");
                    }
                    first = true;
                    infstr.append(sigName);
                }
            }
        }
        return infstr.toString();
    }

    private boolean isBiasPort(PrimitivePort pp) {
        ArcProto[] connections = pp.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            ArcProto ap = connections[i];
            if (ap.getTechnology() == Generic.tech() || ap.getFunction() != ArcProto.Function.WELL) continue;
            return true;
        }
        return false;
    }

    private String addRealPortsPrim(Nodable no, int special, Map<ArcInst, Integer> negatedHeads, Map<ArcInst, Integer> negatedTails, Netlist nl) {
        NodeProto np = no.getProto();
        boolean first = false;
        StringBuffer infstr = new StringBuffer();
        for (int pass = 0; pass < 5; ++pass) {
            Iterator<PortProto> it = np.getPorts();
            while (it.hasNext()) {
                PortProto otherPP;
                PortProto pp = it.next();
                if (np == Schematics.tech().transistor4Node && pp.getName().equals("b") || np.getFunction().isTransistor() && this.isBiasPort((PrimitivePort)pp) || !this.matchesPass(pp.getCharacteristic(), pass)) continue;
                if (special == 1) {
                    PrimitivePort oPp;
                    boolean connected = false;
                    Iterator<PortProto> oIt = np.getPorts();
                    while (oIt.hasNext() && (oPp = (PrimitivePort)oIt.next()) != pp) {
                        if (oPp.getTopology() != ((PrimitivePort)pp).getTopology()) continue;
                        connected = true;
                        break;
                    }
                    if (connected) continue;
                }
                if ((special == 3 || special == 2 || special == 4 || special == 5 || special == 6 || special == 7) && !pp.getName().equals("a") && !pp.getName().equals("y") || (special == 10 || special == 8) && !pp.getName().equals("i1") && !pp.getName().equals("ck") && !pp.getName().equals("preset") && !pp.getName().equals("q") || (special == 11 || special == 9) && !pp.getName().equals("i1") && !pp.getName().equals("ck") && !pp.getName().equals("clear") && !pp.getName().equals("q")) continue;
                if (pp.getBasePort().isIsolated()) {
                    Iterator<Connection> cIt = no.getNodeInst().getConnections();
                    while (cIt.hasNext()) {
                        Integer index2;
                        ArcInst ai;
                        ArcProto.Function fun;
                        Connection con = cIt.next();
                        if (con.getPortInst().getPortProto() != pp || (fun = (ai = con.getArc()).getProto().getFunction()) == ArcProto.Function.NONELEC) continue;
                        String sigName = "open";
                        Network net = nl.getNetwork(ai, 0);
                        if (net != null) {
                            sigName = this.addString(net.describe(false), no.getParent());
                        }
                        if (con.isNegated() && (index2 = con.getEndIndex() == 1 ? negatedHeads.get(ai) : negatedTails.get(ai)) != null) {
                            sigName = "PINV" + index2;
                        }
                        if (first) {
                            infstr.append(", ");
                        }
                        first = true;
                        infstr.append(sigName);
                    }
                    continue;
                }
                boolean portNamed = false;
                Iterator<Connection> cIt = no.getNodeInst().getConnections();
                while (cIt.hasNext()) {
                    Integer index3;
                    Connection con = cIt.next();
                    otherPP = con.getPortInst().getPortProto();
                    boolean aka = false;
                    if (otherPP instanceof PrimitivePort && pp instanceof PrimitivePort && ((PrimitivePort)otherPP).getTopology() == ((PrimitivePort)pp).getTopology()) {
                        aka = true;
                    }
                    if (otherPP != pp && !aka) continue;
                    ArcInst ai = con.getArc();
                    if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) break;
                    if (con.isNegated() && (index3 = con.getEndIndex() == 1 ? negatedHeads.get(ai) : negatedTails.get(ai)) != null) {
                        if (first) {
                            infstr.append(", ");
                        }
                        first = true;
                        String sigName = "PINV" + index3;
                        infstr.append(sigName);
                        continue;
                    }
                    int wid = nl.getBusWidth(ai);
                    for (int i = 0; i < wid; ++i) {
                        if (first) {
                            infstr.append(", ");
                        }
                        first = true;
                        Network subNet = nl.getNetwork(ai, i);
                        String subNetName = this.getOneNetworkName(subNet);
                        String sigName = this.addString(subNetName, no.getParent());
                        infstr.append(sigName);
                    }
                    portNamed = true;
                    break;
                }
                if (portNamed) continue;
                Iterator<Export> eIt = no.getNodeInst().getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    otherPP = e.getOriginalPort().getPortProto();
                    if (otherPP instanceof Export) {
                        Export otherE = (Export)otherPP;
                        Cell equiv = otherE.getParent().getEquivalent();
                        otherPP = otherE.findEquivalent(equiv);
                    }
                    if (otherPP != pp) continue;
                    int wid = nl.getBusWidth(e);
                    for (int i = 0; i < wid; ++i) {
                        if (first) {
                            infstr.append(", ");
                        }
                        first = true;
                        Network subNet = nl.getNetwork(e, i);
                        String subNetName = this.getOneNetworkName(subNet);
                        infstr.append(this.addString(subNetName, no.getParent()));
                    }
                    portNamed = true;
                    break;
                }
                if (portNamed) continue;
                if (first) {
                    infstr.append(", ");
                }
                first = true;
                infstr.append("open");
            }
        }
        return infstr.toString();
    }

    private String addPortListPrim(Nodable no, int special) {
        if (special == 10 || special == 8) {
            return "i1, ck, preset: in BIT; q: out BIT";
        }
        if (special == 11 || special == 9) {
            return "i1, ck, clear: in BIT; q: out BIT";
        }
        String before = "";
        StringBuffer infstr = new StringBuffer();
        PrimitiveNode pnp = (PrimitiveNode)no.getProto();
        for (int pass = 0; pass < 5; ++pass) {
            boolean didsome = false;
            Iterator<PrimitivePort> it = pnp.getPrimitivePorts();
            while (it.hasNext()) {
                PrimitivePort pp = it.next();
                if (!this.matchesPass(pp.getCharacteristic(), pass)) continue;
                String portName = pp.getName();
                if ((special == 3 || special == 2 || special == 4) && !portName.equals("a") && !portName.equals("y") || pnp.getFunction().isTransistor() && this.isBiasPort(pp)) continue;
                if (pp.getBasePort().isIsolated()) {
                    int inst = 1;
                    Iterator<Connection> cIt = no.getNodeInst().getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        infstr.append(before);
                        before = ", ";
                        String exportName = this.addString(portName, null) + inst++;
                        infstr.append(exportName);
                    }
                } else {
                    PrimitivePort ePp;
                    boolean seen = false;
                    Iterator<PrimitivePort> eIt = pnp.getPrimitivePorts();
                    while (eIt.hasNext() && (ePp = eIt.next()) != pp) {
                        if (ePp.getTopology() != pp.getTopology()) continue;
                        seen = true;
                    }
                    if (seen) continue;
                    infstr.append(before);
                    before = ", ";
                    infstr.append(this.addString(portName, null));
                }
                didsome = true;
            }
            if (!didsome) continue;
            if (pass == 0) {
                infstr.append(": in BIT");
            } else if (pass == 1 || pass == 2 || pass == 3) {
                infstr.append(": out BIT");
            } else {
                infstr.append(": inout BIT");
            }
            before = "; ";
        }
        return infstr.toString();
    }

    private String addPortList(Topology.CellNetInfo cni) {
        String before = "";
        StringBuffer infstr = new StringBuffer();
        for (int pass = 0; pass < 5; ++pass) {
            boolean didsome = false;
            Iterator<Topology.CellSignal> it = cni.getCellSignals();
            while (it.hasNext()) {
                Topology.CellSignal cs = it.next();
                Export e = cs.getExport();
                if (e == null || !this.matchesPass(e.getCharacteristic(), pass)) continue;
                infstr.append(before);
                before = ", ";
                infstr.append(this.addString(cs.getName(), null));
                didsome = true;
            }
            if (!didsome) continue;
            if (pass == 0) {
                infstr.append(": in BIT");
            } else if (pass == 1 || pass == 2 || pass == 3) {
                infstr.append(": out BIT");
            } else {
                infstr.append(": inout BIT");
            }
            before = "; ";
        }
        return infstr.toString();
    }

    private boolean matchesPass(PortCharacteristic ch, int pass) {
        switch (pass) {
            case 0: {
                return ch == PortCharacteristic.IN;
            }
            case 1: {
                return ch == PortCharacteristic.OUT;
            }
            case 2: {
                return ch == PortCharacteristic.PWR;
            }
            case 3: {
                return ch == PortCharacteristic.GND;
            }
        }
        return ch != PortCharacteristic.IN && ch != PortCharacteristic.OUT && ch != PortCharacteristic.PWR && ch != PortCharacteristic.GND;
    }

    private String getOneNetworkName(Network net) {
        Iterator<String> nIt = net.getNames();
        if (nIt.hasNext()) {
            return nIt.next();
        }
        return net.describe(false);
    }

    @Override
    protected String getSafeCellName(String name) {
        if (name.length() == 0) {
            return name;
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first)) {
            name = "E_" + name;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            name = name.substring(0, i) + "_" + name.substring(i + 1);
        }
        return name;
    }

    @Override
    protected boolean skipCellAndSubcells(Cell cell) {
        return false;
    }

    @Override
    protected String getPowerName(Network net) {
        return net.getName();
    }

    @Override
    protected String getGroundName(Network net) {
        return net.getName();
    }

    @Override
    protected String getGlobalName(Global glob) {
        return "glbl." + glob.getName();
    }

    @Override
    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    @Override
    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    @Override
    protected boolean isAggregateNamesSupported() {
        return false;
    }

    @Override
    protected boolean isAggregateNameGapsSupported() {
        return false;
    }

    @Override
    protected boolean isSeparateInputAndOutput() {
        return false;
    }

    @Override
    protected boolean isCaseSensitive() {
        return true;
    }

    @Override
    protected Netlist.ShortResistors getShortResistors() {
        return Netlist.ShortResistors.ALL;
    }

    @Override
    protected boolean canParameterizeNames() {
        return true;
    }

    @Override
    protected String getSafeNetName(String name, boolean bus) {
        return this.addString(name, null);
    }

    private String addString(String orig, Cell environment) {
        StringBuffer sb = new StringBuffer();
        boolean nonAlnum = false;
        for (int i = 0; i < orig.length(); ++i) {
            char chr = orig.charAt(i);
            if (Character.isLetterOrDigit(chr)) {
                sb.append(chr);
                continue;
            }
            sb.append('_');
            nonAlnum = true;
        }
        if (!nonAlnum) {
            if (CompileVHDL.isKeyword(orig) != null) {
                sb.append('_');
                return sb.toString();
            }
            if (orig.equalsIgnoreCase("bit")) {
                sb.append('_');
                return sb.toString();
            }
        }
        if (environment != null) {
            Iterator<NodeInst> it = environment.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance() || !orig.equals(ni.getProto().getName())) continue;
                sb.append('_');
                break;
            }
        }
        return sb.toString();
    }

    private class SignalNameLine {
        private boolean hasContent = false;

        private SignalNameLine() {
        }

        public void addSignalName(String sigName) {
            if (!this.hasContent) {
                GenerateVHDL.this.writeWidthLimited("\n");
                GenerateVHDL.this.writeWidthLimited("  signal ");
            } else {
                GenerateVHDL.this.writeWidthLimited(", ");
            }
            this.hasContent = true;
            GenerateVHDL.this.writeWidthLimited(sigName);
        }

        public void finish() {
            if (this.hasContent) {
                GenerateVHDL.this.writeWidthLimited(": BIT;\n");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnalyzePrimitive {
        private String primName;
        private int special = 0;

        private String getPrimName() {
            return this.primName;
        }

        private int getSpecial() {
            return this.special;
        }

        private AnalyzePrimitive(Nodable no, Map<ArcInst, Integer> negatedHeads, Map<ArcInst, Integer> negatedTails, VHDLPreferences vp) {
            Connection con;
            Iterator<Connection> it;
            Connection isNeg;
            Connection con2;
            if (no.isCellInstance()) {
                this.primName = no.getProto().getName();
                return;
            }
            NodeInst ni = no.getNodeInst();
            PrimitiveNode.Function k = ni.getFunction();
            this.primName = null;
            if (k == PrimitiveNode.Function.TRADMOS || k == PrimitiveNode.Function.TRA4DMOS) {
                this.primName = "DMOStran";
                this.special = 1;
            } else if (k.isNTypeTransistor()) {
                this.primName = "nMOStran";
                Variable var = no.getVar(SimulationTool.WEAK_NODE_KEY);
                if (var != null) {
                    this.primName = "nMOStranWeak";
                }
                this.special = 1;
            } else if (k.isPTypeTransistor()) {
                this.primName = "PMOStran";
                Variable var = no.getVar(SimulationTool.WEAK_NODE_KEY);
                if (var != null) {
                    this.primName = "PMOStranWeak";
                }
                this.special = 1;
            } else if (k == PrimitiveNode.Function.TRANPN || k == PrimitiveNode.Function.TRA4NPN) {
                this.primName = "NPNtran";
            } else if (k == PrimitiveNode.Function.TRAPNP || k == PrimitiveNode.Function.TRA4PNP) {
                this.primName = "PNPtran";
            } else if (k == PrimitiveNode.Function.TRANJFET || k == PrimitiveNode.Function.TRA4NJFET) {
                this.primName = "NJFET";
            } else if (k == PrimitiveNode.Function.TRAPJFET || k == PrimitiveNode.Function.TRA4PJFET) {
                this.primName = "PJFET";
            } else if (k == PrimitiveNode.Function.TRADMES || k == PrimitiveNode.Function.TRA4DMES) {
                this.primName = "DMEStran";
            } else if (k == PrimitiveNode.Function.TRAEMES || k == PrimitiveNode.Function.TRA4EMES) {
                this.primName = "EMEStran";
            } else if (k == PrimitiveNode.Function.FLIPFLOPRSMS || k == PrimitiveNode.Function.FLIPFLOPRSN || k == PrimitiveNode.Function.FLIPFLOPRSP) {
                this.primName = "rsff";
                this.special = 12;
            } else if (k == PrimitiveNode.Function.FLIPFLOPJKMS || k == PrimitiveNode.Function.FLIPFLOPJKN || k == PrimitiveNode.Function.FLIPFLOPJKP) {
                this.primName = "jkff";
                this.special = 12;
            } else if (k == PrimitiveNode.Function.FLIPFLOPDMS || k == PrimitiveNode.Function.FLIPFLOPDN || k == PrimitiveNode.Function.FLIPFLOPDP) {
                this.primName = "dsff";
                this.special = 8;
                Iterator<Connection> it2 = ni.getConnections();
                while (it2.hasNext()) {
                    Connection con3 = it2.next();
                    if (!con3.getPortInst().getPortProto().getName().equals("clear")) continue;
                    this.primName = "drff";
                    this.special = 9;
                    break;
                }
            } else if (k == PrimitiveNode.Function.FLIPFLOPTMS || k == PrimitiveNode.Function.FLIPFLOPTN || k == PrimitiveNode.Function.FLIPFLOPTP) {
                this.primName = "tsff";
                this.special = 10;
                Iterator<Connection> it3 = ni.getConnections();
                while (it3.hasNext()) {
                    Connection con4 = it3.next();
                    if (!con4.getPortInst().getPortProto().getName().equals("clear")) continue;
                    this.primName = "trff";
                    this.special = 11;
                    break;
                }
            } else if (k == PrimitiveNode.Function.BUFFER) {
                this.primName = vp.vhdlNames.get(Schematics.tech().bufferNode);
                int slashPos = this.primName.indexOf(47);
                this.special = 2;
                Iterator<Connection> it4 = ni.getConnections();
                while (it4.hasNext()) {
                    con2 = it4.next();
                    if (!con2.getPortInst().getPortProto().getName().equals("y") || !con2.isNegated()) continue;
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 4;
                    if (con2.getEndIndex() == 1) {
                        negatedHeads.remove(con2.getArc());
                        break;
                    }
                    negatedTails.remove(con2.getArc());
                    break;
                }
                if (this.special == 2 && slashPos >= 0) {
                    this.primName = this.primName.substring(0, slashPos);
                }
            } else if (k == PrimitiveNode.Function.GATEAND) {
                this.primName = vp.vhdlNames.get(Schematics.tech().andNode);
                int slashPos = this.primName.indexOf(47);
                int inPort = 0;
                isNeg = null;
                it = ni.getConnections();
                while (it.hasNext()) {
                    con = it.next();
                    if (con.getPortInst().getPortProto().getName().equals("a")) {
                        ++inPort;
                    }
                    if (!con.getPortInst().getPortProto().getName().equals("y") || !con.isNegated()) continue;
                    isNeg = con;
                }
                if (isNeg != null) {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 5;
                    if (isNeg.getEndIndex() == 1) {
                        negatedHeads.remove(isNeg.getArc());
                    } else {
                        negatedTails.remove(isNeg.getArc());
                    }
                } else {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(0, slashPos);
                    }
                    this.special = 3;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.GATEOR) {
                this.primName = vp.vhdlNames.get(Schematics.tech().orNode);
                int slashPos = this.primName.indexOf(47);
                int inPort = 0;
                isNeg = null;
                it = ni.getConnections();
                while (it.hasNext()) {
                    con = it.next();
                    if (con.getPortInst().getPortProto().getName().equals("a")) {
                        ++inPort;
                    }
                    if (!con.getPortInst().getPortProto().getName().equals("y") || !con.isNegated()) continue;
                    isNeg = con;
                }
                if (isNeg != null) {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 6;
                    if (isNeg.getEndIndex() == 1) {
                        negatedHeads.remove(isNeg.getArc());
                    } else {
                        negatedTails.remove(isNeg.getArc());
                    }
                } else {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(0, slashPos);
                    }
                    this.special = 3;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.GATEXOR) {
                this.primName = vp.vhdlNames.get(Schematics.tech().xorNode);
                int slashPos = this.primName.indexOf(47);
                int inPort = 0;
                isNeg = null;
                it = ni.getConnections();
                while (it.hasNext()) {
                    con = it.next();
                    if (con.getPortInst().getPortProto().getName().equals("a")) {
                        ++inPort;
                    }
                    if (!con.getPortInst().getPortProto().getName().equals("y") || !con.isNegated()) continue;
                    isNeg = con;
                }
                if (isNeg != null) {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 7;
                    if (isNeg.getEndIndex() == 1) {
                        negatedHeads.remove(isNeg.getArc());
                    } else {
                        negatedTails.remove(isNeg.getArc());
                    }
                } else {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(0, slashPos);
                    }
                    this.special = 3;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.MUX) {
                this.primName = vp.vhdlNames.get(Schematics.tech().muxNode);
                int inPort = 0;
                Iterator<Connection> it5 = ni.getConnections();
                while (it5.hasNext()) {
                    con2 = it5.next();
                    if (!con2.getPortInst().getPortProto().getName().equals("a")) continue;
                    ++inPort;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.CONPOWER) {
                this.primName = "power";
            } else if (k == PrimitiveNode.Function.CONGROUND) {
                this.primName = "ground";
            }
            if (this.primName == null) {
                Iterator<Export> it6 = ni.getExports();
                while (it6.hasNext()) {
                    Export e = it6.next();
                    if (e.isPower()) {
                        this.primName = "power";
                        break;
                    }
                    if (!e.isGround()) continue;
                    this.primName = "ground";
                    break;
                }
            }
        }
    }

    public static class VHDLPreferences
    extends PrefPackage {
        private static final String KEY_VHDL = "SchematicVHDLStringFor";
        public Map<PrimitiveNode, String> vhdlNames = new HashMap<PrimitiveNode, String>();

        public VHDLPreferences(boolean factory) {
            super(factory);
            Preferences techPrefs = VHDLPreferences.getPrefRoot().node("technology/technologies");
            Schematics schTech = Schematics.tech();
            Iterator<PrimitiveNode> it = schTech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pn = it.next();
                String key = KEY_VHDL + pn.getName();
                String factoryVhdl = schTech.getFactoryVHDLNames(pn);
                String vhdl = techPrefs.get(key, factoryVhdl);
                this.vhdlNames.put(pn, vhdl);
            }
        }

        public void putPrefs(Preferences prefRoot, boolean removeDefaults) {
            super.putPrefs(prefRoot, removeDefaults);
            Preferences techPrefs = prefRoot.node("technology/technologies");
            Schematics schTech = Schematics.tech();
            for (Map.Entry<PrimitiveNode, String> e : this.vhdlNames.entrySet()) {
                PrimitiveNode pn = e.getKey();
                String key = KEY_VHDL + pn.getName();
                String factoryVhdl = schTech.getFactoryVHDLNames(pn);
                String vhdl = e.getValue();
                if (removeDefaults && vhdl.equals(factoryVhdl)) {
                    techPrefs.remove(key);
                    continue;
                }
                techPrefs.put(key, vhdl);
            }
        }
    }
}

