/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExecProcess {
    public static final OutputStream devNull = new OutputStream(){

        public void write(int b) {
        }

        public void write(byte[] b, int ofs, int len) {
        }
    };
    public static final InputStream eofInputStream = new InputStream(){

        public int read() {
            return -1;
        }

        public int read(byte[] buf, int ofs, int len) {
            return -1;
        }

        public long skip(long ofs) {
            return 0L;
        }

        public int available() {
            return 0;
        }
    };
    private Process proc;
    private InputStream redirectStdin;
    private OutputStream redirectStdout;
    private OutputStream redirectStderr;
    private String[] command;
    private File workingDirectory;

    public ExecProcess(String[] command, File workingDirectory) {
        this.command = command;
        if (workingDirectory == null) {
            workingDirectory = new File(System.getProperty("java.io.tmpdir"));
        }
        this.workingDirectory = workingDirectory;
    }

    public synchronized void setRemote(String host, String user, File remoteWorkingDirectory, boolean syncBefore, boolean syncAfter) {
        if (this.proc != null) {
            throw new RuntimeException("you cannot invoke ExecProcess.setRemote() after ExecProcess.start()");
        }
        throw new RuntimeException("not implemented");
    }

    public synchronized void setLocal() {
    }

    public synchronized void redirectStdin(InputStream in) {
        if (this.proc != null) {
            throw new RuntimeException("you cannot invoke ExecProcess.redirectStdin() after ExecProcess.start()");
        }
        this.redirectStdin = in;
    }

    public synchronized void redirectStdout(OutputStream os) {
        if (this.proc != null) {
            throw new RuntimeException("you cannot invoke ExecProcess.redirectStdout() after ExecProcess.start()");
        }
        this.redirectStdout = os;
    }

    public synchronized void redirectStderr(OutputStream os) {
        if (this.proc != null) {
            throw new RuntimeException("you cannot invoke ExecProcess.redirectStderr() after ExecProcess.start()");
        }
        this.redirectStderr = os;
    }

    public synchronized void start() throws IOException {
        if (this.proc != null) {
            throw new RuntimeException("you cannot invoke ExecProcess.start() twice");
        }
        this.proc = Runtime.getRuntime().exec(this.command, null, this.workingDirectory);
        if (this.redirectStdin != null) {
            new StreamCopier(this.redirectStdin, this.proc.getOutputStream()).start();
        }
        if (this.redirectStdout != null) {
            new StreamCopier(this.proc.getInputStream(), this.redirectStdout).start();
        }
        if (this.redirectStderr != null) {
            new StreamCopier(this.proc.getErrorStream(), this.redirectStderr).start();
        }
    }

    public synchronized void destroy() throws IOException {
        if (this.proc == null) {
            throw new RuntimeException("you must invoke ExecProcess.start() first");
        }
        this.proc.destroy();
    }

    public int waitFor() throws IOException {
        if (this.proc == null) {
            throw new RuntimeException("you must invoke ExecProcess.start() first");
        }
        try {
            return this.proc.waitFor();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public synchronized OutputStream getStdin() {
        if (this.proc == null) {
            throw new RuntimeException("you must invoke ExecProcess.start() first");
        }
        if (this.redirectStdin != null) {
            throw new RuntimeException("you cannot invoke getStdin() after redirectStdin()");
        }
        return this.proc.getOutputStream();
    }

    public synchronized InputStream getStdout() {
        if (this.proc == null) {
            throw new RuntimeException("you must invoke ExecProcess.start() first");
        }
        if (this.redirectStdout != null) {
            throw new RuntimeException("you cannot invoke getStdout() after redirectStdout()");
        }
        return this.proc.getInputStream();
    }

    public synchronized InputStream getStderr() {
        if (this.proc == null) {
            throw new RuntimeException("you must invoke ExecProcess.start() first");
        }
        if (this.redirectStderr != null) {
            throw new RuntimeException("you cannot invoke getStderr() after redirectStderr()");
        }
        return this.proc.getErrorStream();
    }

    private static class StreamCopier
    extends Thread {
        private final byte[] buf = new byte[16384];
        private final InputStream is;
        private final OutputStream os;

        public StreamCopier(InputStream is, OutputStream os) {
            this.setDaemon(true);
            this.is = is;
            this.os = os;
        }

        public void run() {
            try {
                int numread;
                while ((numread = this.is.read(this.buf, 0, this.buf.length)) != -1) {
                    this.os.write(this.buf, 0, numread);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

