/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.UserInterfaceMain;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.swing.SwingUtilities;

class ClientJobManager {
    private final IdReader reader;
    private final DataOutputStream clientOutputStream;
    private final Process process;
    private EditingPreferences currentEp = new EditingPreferences(true, IdManager.stdIdManager.getInitialTechPool());
    private boolean skipOneLine;

    public ClientJobManager(String serverMachineName, int serverPort) throws IOException {
        this.process = null;
        System.out.println("Attempting to connect to port " + serverPort + " ...");
        Socket socket = new Socket(serverMachineName, serverPort);
        this.reader = new IdReader(new DataInputStream(new BufferedInputStream(socket.getInputStream())), IdManager.stdIdManager);
        this.clientOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public ClientJobManager(Process process, boolean skipOneLine) throws IOException {
        this.process = process;
        this.skipOneLine = skipOneLine;
        System.out.println("Attempting to connect to server subprocess ...");
        this.reader = new IdReader(new DataInputStream(new BufferedInputStream(process.getInputStream())), IdManager.stdIdManager);
        this.clientOutputStream = new DataOutputStream(new BufferedOutputStream(process.getOutputStream()));
    }

    void writeEJob(EJob ejob) throws IOException {
        this.writeEditingPreferences();
        this.clientOutputStream.writeByte(1);
        this.clientOutputStream.writeInt(ejob.jobKey.jobId);
        this.clientOutputStream.writeUTF(ejob.jobType.toString());
        this.clientOutputStream.writeUTF(ejob.jobName);
        this.clientOutputStream.writeInt(ejob.serializedJob.length);
        this.clientOutputStream.write(ejob.serializedJob);
        this.clientOutputStream.flush();
    }

    private void writeEditingPreferences() throws IOException {
        byte[] serializedEp;
        EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
        if (ep == this.currentEp) {
            return;
        }
        this.currentEp = ep;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, EDatabase.clientDatabase());
            out.writeObject(ep);
            out.flush();
            serializedEp = byteStream.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        this.clientOutputStream.writeByte(2);
        this.clientOutputStream.writeInt(serializedEp.length);
        this.clientOutputStream.write(serializedEp);
    }

    public void runLoop(final Job initialJob) {
        Snapshot oldSnapshot = EDatabase.clientDatabase().getInitialSnapshot();
        Snapshot currentSnapshot = EDatabase.clientDatabase().backup();
        assert (currentSnapshot == oldSnapshot);
        try {
            int protocolVersion;
            if (this.skipOneLine) {
                char ch;
                for (int i = 0; i < 150 && (ch = (char)this.reader.readByte()) != '\n'; ++i) {
                    System.err.print(ch);
                }
                System.err.println();
            }
            if ((protocolVersion = this.reader.readInt()) != 19) {
                System.err.println("Client's protocol version 19 is incompatible with Server's protocol version " + protocolVersion);
                System.exit(1);
            }
            int connectionId = this.reader.readInt();
            Job.currentUI.patchConnectionId(connectionId);
            System.out.println("Connected id=" + connectionId);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Job.currentUI.startDispatcher();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                initialJob.startJob();
            }
        });
        try {
            while (true) {
                byte tag = this.reader.readByte();
                long timeStamp = this.reader.readLong();
                if (tag == 1) {
                    currentSnapshot = Snapshot.readSnapshot(this.reader, currentSnapshot);
                    continue;
                }
                Client.ServerEvent serverEvent = Client.read(this.reader, tag, timeStamp, Job.currentUI, currentSnapshot);
                Client.putEvent(serverEvent);
            }
        }
        catch (IOException e) {
            System.out.println("END OF FILE reading from server");
            if (this.process != null) {
                ClientJobManager.printErrorStream(this.process);
            }
            return;
        }
    }

    private static void printErrorStream(Process process) {
        try {
            int c;
            process.getOutputStream().close();
            BufferedInputStream errStream = new BufferedInputStream(process.getErrorStream());
            System.err.println("StdErr:");
            while (((InputStream)errStream).available() != 0 && (c = ((InputStream)errStream).read()) >= 0) {
                System.err.print((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

