/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.CellId;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.tecEdit.TechConversionResult;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibToTech {
    private TechConversionResult error;
    private static final int TOEDGELEFT = 1;
    private static final int TOEDGERIGHT = 2;
    private static final int TOEDGETOP = 4;
    private static final int TOEDGEBOT = 8;
    private static final int FROMCENTX = 16;
    private static final int FROMCENTY = 32;
    private static final int RATIOCENTX = 64;
    private static final int RATIOCENTY = 128;

    public static void makeTechFromLib() {
        new GenerateTechnology();
    }

    public Technology makeTech(String newName, String fileName, TechConversionResult error) {
        this.error = error;
        Library lib = Library.getCurrent();
        String newTechName = newName;
        boolean modified = false;
        while (Technology.findTechnology(newTechName) != null) {
            newTechName = newTechName + "X";
            modified = true;
        }
        if (modified) {
            System.out.println("Warning: already a technology called " + newName + ".  Naming this " + newTechName);
        }
        Library[] dependentLibs = Info.getDependentLibraries(lib);
        Cell np = null;
        for (int i = dependentLibs.length - 1; i >= 0 && (np = dependentLibs[i].findNodeProto("factors")) == null; --i) {
        }
        if (np == null) {
            error.markError(null, null, "Cell with general information, called 'factors', is missing");
            return null;
        }
        GeneralInfo gi = this.parseCell(np);
        LayerInfo[] lList = this.extractLayers(dependentLibs);
        if (lList == null) {
            return null;
        }
        ArcInfo[] aList = this.extractArcs(dependentLibs, lList);
        if (aList == null) {
            return null;
        }
        NodeInfo[] nList = this.extractNodes(dependentLibs, lList, aList);
        if (nList == null) {
            return null;
        }
        for (NodeInfo ni : nList) {
            ni.arcsShrink = ni.func == PrimitiveNode.Function.PIN && !ni.wipes;
        }
        block3: for (int i = 0; i < lList.length; ++i) {
            if (lList[i].pseudo) continue;
            for (int j = 0; j < nList.length; ++j) {
                if (nList[j].func != PrimitiveNode.Function.NODE) continue;
                NodeInfo.LayerDetails nld = nList[j].nodeLayers[0];
                if (nld.layer != lList[i]) continue;
                lList[i].pureLayerNode = nList[j];
                continue block3;
            }
        }
        Variable var = Library.getCurrent().getVar(Info.COMPMENU_KEY);
        if (var != null) {
            String compMenuXML = (String)var.getObject();
            ArrayList<Xml.PrimitiveNode> nodes = new ArrayList<Xml.PrimitiveNode>();
            for (int i = 0; i < nList.length; ++i) {
                Xml.PrimitiveNode xnp = new Xml.PrimitiveNode();
                xnp.name = nList[i].name;
                xnp.function = nList[i].func;
                nodes.add(xnp);
            }
            ArrayList<Xml.ArcProto> arcs = new ArrayList<Xml.ArcProto>();
            for (int i = 0; i < aList.length; ++i) {
                Xml.ArcProto xap = new Xml.ArcProto();
                xap.name = aList[i].name;
                arcs.add(xap);
            }
            Xml.MenuPalette xmp = Xml.parseComponentMenuXMLTechEdit(compMenuXML, nodes, arcs);
            int menuWid = xmp.numColumns;
            int menuHei = xmp.menuBoxes.size() / menuWid;
            gi.menuPalette = new Object[menuHei][menuWid];
            int i = 0;
            for (int y = 0; y < menuHei; ++y) {
                for (int x = 0; x < menuWid; ++x) {
                    List<Object> items = xmp.menuBoxes.get(i++);
                    ArrayList<Object> item = null;
                    if (items.size() == 1) {
                        item = items.get(0);
                    } else if (items.size() > 1) {
                        ArrayList<Object> convItems = new ArrayList<Object>();
                        for (Object obj : items) {
                            convItems.add(obj);
                        }
                        item = convItems;
                    }
                    gi.menuPalette[y][x] = item;
                }
            }
        }
        Xml.Technology t = this.makeXml(newTechName, gi, lList, nList, aList);
        if (fileName != null) {
            t.writeXml(fileName);
        }
        Technology tech = new Technology(t);
        tech.setup();
        System.out.println("Technology " + tech.getTechName() + " built.");
        WindowFrame.updateTechnologyLists();
        return tech;
    }

    private GeneralInfo parseCell(Cell np) {
        GeneralInfo gi = new GeneralInfo();
        Iterator<NodeInst> it = np.getNodes();
        block15: while (it.hasNext()) {
            NodeInst ni = it.next();
            int opt = Manipulate.getOptionOnNode(ni);
            String str = Info.getValueOnNode(ni);
            switch (opt) {
                case 46: {
                    gi.shortName = str;
                    continue block15;
                }
                case 14: {
                    gi.scale = TextUtils.atof(str);
                    gi.scaleRelevant = true;
                    continue block15;
                }
                case 47: {
                    gi.defaultFoundry = str;
                    continue block15;
                }
                case 48: {
                    gi.defaultNumMetals = TextUtils.atoi(str);
                    continue block15;
                }
                case 15: {
                    gi.description = str;
                    continue block15;
                }
                case 38: {
                    gi.minRes = TextUtils.atof(str);
                    continue block15;
                }
                case 39: {
                    gi.minCap = TextUtils.atof(str);
                    continue block15;
                }
                case 49: {
                    gi.maxSeriesResistance = TextUtils.atof(str);
                    continue block15;
                }
                case 42: {
                    gi.gateShrinkage = TextUtils.atof(str);
                    continue block15;
                }
                case 43: {
                    gi.includeGateInResistance = str.equalsIgnoreCase("yes");
                    continue block15;
                }
                case 44: {
                    gi.includeGround = str.equalsIgnoreCase("yes");
                    continue block15;
                }
                case 45: {
                    Color[] colors = GeneralInfo.getTransparentColors(ni);
                    if (colors == null) continue block15;
                    gi.transparentColors = colors;
                    continue block15;
                }
                case 26: {
                    continue block15;
                }
            }
            this.error.markError(ni, np, "Unknown node in miscellaneous-information cell");
        }
        return gi;
    }

    private LayerInfo[] extractLayers(Library[] dependentLibs) {
        Cell[] layerCells = Info.findCellSequence(dependentLibs, "layer-", Info.LAYERSEQUENCE_KEY);
        if (layerCells.length <= 0) {
            System.out.println("No layers found");
            return null;
        }
        LayerInfo[] lis = new LayerInfo[layerCells.length];
        for (int i = 0; i < layerCells.length; ++i) {
            lis[i] = LayerInfo.parseCell(layerCells[i]);
            if (lis[i] != null) continue;
            this.error.markError(null, layerCells[i], "Error parsing layer information");
        }
        return lis;
    }

    private ArcInfo[] extractArcs(Library[] dependentLibs, LayerInfo[] lList) {
        Cell[] arcCells = Info.findCellSequence(dependentLibs, "arc-", Info.ARCSEQUENCE_KEY);
        if (arcCells.length <= 0) {
            System.out.println("No arcs found");
            return null;
        }
        ArcInfo[] allArcs = new ArcInfo[arcCells.length];
        for (int i = 0; i < arcCells.length; ++i) {
            Cell np = arcCells[i];
            allArcs[i] = ArcInfo.parseCell(np);
            List<Example> neList = Example.getExamples(np, false, this.error);
            if (neList == null) {
                return null;
            }
            if (neList.size() > 1) {
                this.error.markError(null, np, "Can only be one drawing of an arc, but more were found");
                return null;
            }
            Example arcEx = neList.get(0);
            Collections.sort(arcEx.samples, new SamplesByLayerOrder(lList));
            double maxWid = -1.0;
            double hWid = -1.0;
            int count = 0;
            for (Sample ns : arcEx.samples) {
                double wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                if (wid > maxWid) {
                    maxWid = wid;
                }
                if (ns.layer == null) {
                    hWid = wid;
                    continue;
                }
                ++count;
            }
            allArcs[i].widthOffset = maxWid - hWid;
            allArcs[i].maxWidth = maxWid;
            if (hWid < 0.0) {
                this.error.markError(null, np, "No highlight layer found");
                return null;
            }
            allArcs[i].arcDetails = new ArcInfo.LayerDetails[count];
            int layerIndex = 0;
            for (int k = 0; k < 2; ++k) {
                for (Sample ns : arcEx.samples) {
                    if (ns.layer == null) continue;
                    String sampleLayer = ns.layer.getName().substring(6);
                    LayerInfo li = null;
                    for (int j = 0; j < lList.length; ++j) {
                        if (!sampleLayer.equals(lList[j].name)) continue;
                        li = lList[j];
                        break;
                    }
                    if (li == null) {
                        this.error.markError(ns.node, np, "Unknown layer: " + sampleLayer);
                        return null;
                    }
                    if (k == 0 ? li.desc.getTransparentLayer() == 0 : li.desc.getTransparentLayer() != 0) continue;
                    allArcs[i].arcDetails[layerIndex] = new ArcInfo.LayerDetails();
                    allArcs[i].arcDetails[layerIndex].layer = li;
                    Poly.Type style = Poly.Type.CLOSED;
                    if (ns.node.getProto() == Artwork.tech.filledBoxNode) {
                        style = Poly.Type.FILLED;
                    }
                    allArcs[i].arcDetails[layerIndex].style = style;
                    double wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                    allArcs[i].arcDetails[layerIndex].width = maxWid - wid;
                    ++layerIndex;
                }
            }
        }
        return allArcs;
    }

    private NodeInfo[] extractNodes(Library[] dependentLibs, LayerInfo[] lList, ArcInfo[] aList) {
        Cell[] nodeCells = Info.findCellSequence(dependentLibs, "node-", Info.NODESEQUENCE_KEY);
        if (nodeCells.length <= 0) {
            System.out.println("No nodes found");
            return null;
        }
        NodeInfo[] nList = new NodeInfo[nodeCells.length];
        int nodeIndex = 0;
        for (int pass = 0; pass < 3; ++pass) {
            for (int m = 0; m < nodeCells.length; ++m) {
                Sample ns;
                NodeInfo.PortDetails nipd;
                int i;
                Cell np = nodeCells[m];
                NodeInfo nIn = NodeInfo.parseCell(np);
                Netlist netList = np.acquireUserNetlist();
                if (netList == null) {
                    System.out.println("Sorry, a deadlock technology generation (network information unavailable).  Please try again");
                    return null;
                }
                if (pass == 0 && nIn.func != PrimitiveNode.Function.PIN || pass == 1 && (nIn.func == PrimitiveNode.Function.PIN || nIn.func == PrimitiveNode.Function.NODE) || pass == 2 && nIn.func != PrimitiveNode.Function.NODE) continue;
                if (nIn.func == PrimitiveNode.Function.NODE) {
                    if (nIn.serp) {
                        this.error.markError(null, np, "Pure layer " + nIn.name + " can not be serpentine");
                        return null;
                    }
                    nIn.specialType = 2;
                }
                nList[nodeIndex] = nIn;
                nIn.name = np.getName().substring(5);
                List<Example> neList = Example.getExamples(np, true, this.error);
                if (neList == null || neList.size() == 0) {
                    System.out.println("Cannot analyze " + np);
                    return null;
                }
                Example firstEx = neList.get(0);
                nIn.xSize = firstEx.hx - firstEx.lx;
                nIn.ySize = firstEx.hy - firstEx.ly;
                Collections.sort(firstEx.samples, new SamplesByLayerOrder(lList));
                if (this.associateExamples(neList, np)) {
                    return null;
                }
                nIn.nodeLayers = this.makePrimitiveNodeLayers(neList, np, lList);
                if (nIn.nodeLayers == null) {
                    return null;
                }
                int portCount = 0;
                for (Sample ns2 : firstEx.samples) {
                    if (ns2.layer != Generic.tech.portNode) continue;
                    ++portCount;
                }
                if (portCount == 0) {
                    this.error.markError(null, np, "No ports found");
                    return null;
                }
                ArrayList<NodeInfo.PortDetails> ports = new ArrayList<NodeInfo.PortDetails>();
                HashMap<NodeInfo.PortDetails, Sample> portSamples = new HashMap<NodeInfo.PortDetails, Sample>();
                for (Sample ns3 : firstEx.samples) {
                    if (ns3.layer != Generic.tech.portNode) continue;
                    NodeInfo.PortDetails nipd2 = new NodeInfo.PortDetails();
                    portSamples.put(nipd2, ns3);
                    nipd2.name = Info.getPortName(ns3.node);
                    if (nipd2.name == null) {
                        this.error.markError(ns3.node, np, "Port does not have a name");
                        return null;
                    }
                    for (int c = 0; c < nipd2.name.length(); ++c) {
                        char str = nipd2.name.charAt(c);
                        if (str > ' ' && str < '\u007f') continue;
                        this.error.markError(ns3.node, np, "Invalid port name");
                        return null;
                    }
                    nipd2.angle = 0;
                    Variable varAngle = ns3.node.getVar(Info.PORTANGLE_KEY);
                    if (varAngle != null) {
                        nipd2.angle = (Integer)varAngle.getObject();
                    }
                    nipd2.range = 180;
                    Variable varRange = ns3.node.getVar(Info.PORTRANGE_KEY);
                    if (varRange != null) {
                        nipd2.range = (Integer)varRange.getObject();
                    }
                    nipd2.values = ns3.values;
                    ports.add(nipd2);
                }
                Collections.sort(ports, new PortsByAngleAndName());
                int pol1Port = -1;
                int pol2Port = -1;
                int dif1Port = -1;
                int dif2Port = -1;
                block5: for (i = 0; i < ports.size(); ++i) {
                    int j;
                    nipd = (NodeInfo.PortDetails)ports.get(i);
                    ns = (Sample)portSamples.get(nipd);
                    nipd.connections = new ArcInfo[0];
                    Variable var = ns.node.getVar(Info.CONNECTION_KEY);
                    if (var == null) continue;
                    CellId[] arcCells = (CellId[])var.getObject();
                    ArrayList<ArcInfo> validArcCells = new ArrayList<ArcInfo>();
                    block6: for (int j2 = 0; j2 < arcCells.length; ++j2) {
                        Cell arcCell;
                        if (arcCells[j2] == null || (arcCell = EDatabase.serverDatabase().getCell(arcCells[j2])) == null) continue;
                        String cellName = arcCell.getName().substring(4);
                        for (int k = 0; k < aList.length; ++k) {
                            if (!aList[k].name.equalsIgnoreCase(cellName)) continue;
                            validArcCells.add(aList[k]);
                            continue block6;
                        }
                    }
                    ArcInfo[] connections = new ArcInfo[validArcCells.size()];
                    nipd.connections = connections;
                    for (j = 0; j < validArcCells.size(); ++j) {
                        connections[j] = (ArcInfo)validArcCells.get(j);
                    }
                    for (j = 0; j < connections.length; ++j) {
                        Variable meaningVar = ns.node.getVar(Info.PORTMEANING_KEY);
                        int meaning = 0;
                        if (meaningVar != null) {
                            meaning = (Integer)meaningVar.getObject();
                        }
                        if (connections[j].func.isPoly() || meaning == 1) {
                            if (pol1Port < 0) {
                                pol1Port = i;
                                continue block5;
                            }
                            if (pol2Port >= 0) continue;
                            pol2Port = i;
                            continue block5;
                        }
                        if (!connections[j].func.isDiffusion() && meaning != 2) continue;
                        if (dif1Port < 0) {
                            dif1Port = i;
                            continue block5;
                        }
                        if (dif2Port >= 0) continue;
                        dif2Port = i;
                        continue block5;
                    }
                }
                nIn.nodePortDetails = new NodeInfo.PortDetails[ports.size()];
                for (int j = 0; j < ports.size(); ++j) {
                    nIn.nodePortDetails[j] = (NodeInfo.PortDetails)ports.get(j);
                }
                block11: for (i = 0; i < nIn.nodePortDetails.length; ++i) {
                    nipd = nIn.nodePortDetails[i];
                    ns = (Sample)portSamples.get(nipd);
                    nipd.netIndex = i;
                    if (!ns.node.hasConnections()) continue;
                    ArcInst ai1 = ns.node.getConnections().next().getArc();
                    Network net1 = netList.getNetwork(ai1, 0);
                    for (int j = 0; j < i; ++j) {
                        ArcInst ai2;
                        Network net2;
                        NodeInfo.PortDetails onipd = nIn.nodePortDetails[j];
                        Sample oNs = (Sample)portSamples.get(onipd);
                        if (!oNs.node.hasConnections() || net1 != (net2 = netList.getNetwork(ai2 = oNs.node.getConnections().next().getArc(), 0))) continue;
                        nipd.netIndex = j;
                        continue block11;
                    }
                }
                if (nIn.func == PrimitiveNode.Function.TRANMOS || nIn.func == PrimitiveNode.Function.TRADMOS || nIn.func == PrimitiveNode.Function.TRAPMOS || nIn.func == PrimitiveNode.Function.TRADMES || nIn.func == PrimitiveNode.Function.TRAEMES) {
                    if (pol1Port < 0 || pol2Port < 0 || dif1Port < 0 || dif2Port < 0) {
                        this.error.markError(null, np, "Need 2 gate (poly) and 2 gated (active) ports on field-effect transistor");
                        return null;
                    }
                    double x1Pos = (nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() + nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder()) / 2.0;
                    double x2Pos = (nIn.nodePortDetails[dif2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[0].getX().getAdder() + nIn.nodePortDetails[dif2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[1].getX().getAdder()) / 2.0;
                    double y1Pos = (nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() + nIn.nodePortDetails[dif1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[1].getY().getAdder()) / 2.0;
                    double y2Pos = (nIn.nodePortDetails[dif2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[0].getY().getAdder() + nIn.nodePortDetails[dif2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[1].getY().getAdder()) / 2.0;
                    if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                        if (x1Pos < x2Pos) {
                            int k = dif1Port;
                            dif1Port = dif2Port;
                            dif2Port = k;
                        }
                    } else if (y1Pos < y2Pos) {
                        int k = dif1Port;
                        dif1Port = dif2Port;
                        dif2Port = k;
                    }
                    x1Pos = (nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder() + nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder()) / 2.0;
                    x2Pos = (nIn.nodePortDetails[pol2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[0].getX().getAdder() + nIn.nodePortDetails[pol2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[1].getX().getAdder()) / 2.0;
                    y1Pos = (nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder() + nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder()) / 2.0;
                    y2Pos = (nIn.nodePortDetails[pol2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[0].getY().getAdder() + nIn.nodePortDetails[pol2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[1].getY().getAdder()) / 2.0;
                    if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                        if (x1Pos > x2Pos) {
                            int k = pol1Port;
                            pol1Port = pol2Port;
                            pol2Port = k;
                        }
                    } else if (y1Pos > y2Pos) {
                        int k = pol1Port;
                        pol1Port = pol2Port;
                        pol2Port = k;
                    }
                    ArrayList extras = new ArrayList();
                    for (int j = 0; j < ports.size(); ++j) {
                        if (j == pol1Port || j == dif1Port || j == pol2Port || j == dif2Port) continue;
                        extras.add(ports.get(j));
                    }
                    NodeInfo.PortDetails port0 = nIn.nodePortDetails[pol1Port];
                    NodeInfo.PortDetails port1 = nIn.nodePortDetails[dif1Port];
                    NodeInfo.PortDetails port2 = nIn.nodePortDetails[pol2Port];
                    NodeInfo.PortDetails port3 = nIn.nodePortDetails[dif2Port];
                    pol1Port = 0;
                    nIn.nodePortDetails[0] = port0;
                    dif1Port = 1;
                    nIn.nodePortDetails[1] = port1;
                    pol2Port = 2;
                    nIn.nodePortDetails[2] = port2;
                    dif2Port = 3;
                    nIn.nodePortDetails[3] = port3;
                    for (int j = 0; j < extras.size(); ++j) {
                        nIn.nodePortDetails[j + 4] = (NodeInfo.PortDetails)extras.get(j);
                    }
                    for (int k = 0; k < nIn.nodeLayers.length; ++k) {
                        NodeInfo.LayerDetails nld = nIn.nodeLayers[k];
                        if (!nld.layer.fun.isSubstrate()) continue;
                        nld.portIndex = -1;
                    }
                }
                if (nIn.serp) {
                    nIn.specialType = 1;
                    int polIndex = -1;
                    int difIndex = -1;
                    for (int k = 0; k < nIn.nodeLayers.length; ++k) {
                        int funExtraNew;
                        int funExtraOld;
                        NodeInfo.LayerDetails nld = nIn.nodeLayers[k];
                        if (nld.layer.fun.isPoly()) {
                            polIndex = k;
                            continue;
                        }
                        if (!nld.layer.fun.isDiff() || difIndex >= 0 && ((funExtraOld = nIn.nodeLayers[difIndex].layer.funExtra) == (funExtraNew = nld.layer.funExtra) || funExtraOld == 0)) continue;
                        difIndex = k;
                    }
                    if (difIndex < 0 || polIndex < 0) {
                        this.error.markError(null, np, "No diffusion and polysilicon layers in serpentine transistor");
                        return null;
                    }
                    Sample polNs = nIn.nodeLayers[polIndex].ns;
                    Rectangle2D polNodeBounds = polNs.node.getBounds();
                    Sample difNs = nIn.nodeLayers[difIndex].ns;
                    Rectangle2D difNodeBounds = difNs.node.getBounds();
                    for (int k = 0; k < nIn.nodeLayers.length; ++k) {
                        NodeInfo.LayerDetails nld = nIn.nodeLayers[k];
                        Sample ns4 = nld.ns;
                        Rectangle2D nodeBounds = ns4.node.getBounds();
                        if (polNodeBounds.getWidth() > polNodeBounds.getHeight()) {
                            nld.lWidth = nodeBounds.getMaxY() - (ns4.parent.ly + ns4.parent.hy) / 2.0;
                            nld.rWidth = (ns4.parent.ly + ns4.parent.hy) / 2.0 - nodeBounds.getMinY();
                            nld.extendT = difNodeBounds.getMinX() - nodeBounds.getMinX();
                        } else {
                            nld.lWidth = nodeBounds.getMaxX() - (ns4.parent.lx + ns4.parent.hx) / 2.0;
                            nld.rWidth = (ns4.parent.lx + ns4.parent.hx) / 2.0 - nodeBounds.getMinX();
                            nld.extendT = difNodeBounds.getMinY() - nodeBounds.getMinY();
                        }
                        nld.extendB = nld.extendT;
                    }
                    NodeInfo.LayerDetails[] addedLayers = new NodeInfo.LayerDetails[nIn.nodeLayers.length + 2];
                    for (int k = 0; k < nIn.nodeLayers.length; ++k) {
                        addedLayers[k] = nIn.nodeLayers[k];
                    }
                    NodeInfo.LayerDetails diff1 = nIn.nodeLayers[difIndex].duplicate();
                    NodeInfo.LayerDetails diff2 = nIn.nodeLayers[difIndex].duplicate();
                    addedLayers[nIn.nodeLayers.length] = diff1;
                    addedLayers[nIn.nodeLayers.length + 1] = diff2;
                    nIn.nodeLayers = addedLayers;
                    diff2.inLayers = false;
                    diff1.inLayers = false;
                    nIn.nodeLayers[difIndex].inElectricalLayers = false;
                    diff1.portIndex = dif1Port;
                    diff2.portIndex = dif2Port;
                    nIn.specialValues = new double[6];
                    int layerCount = 0;
                    for (Sample ns5 : firstEx.samples) {
                        if (ns5.values == null || ns5.layer == Generic.tech.portNode || ns5.layer == Generic.tech.cellCenterNode || ns5.layer == null) continue;
                        ++layerCount;
                    }
                    nIn.specialValues[0] = layerCount + 1;
                    if (nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() > nIn.nodePortDetails[dif1Port].values[0].getY().getAdder()) {
                        nIn.specialValues[3] = nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder());
                        nIn.specialValues[1] = nIn.xSize * nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder());
                        nIn.specialValues[2] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder());
                        nIn.specialValues[4] = nIn.ySize * nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder());
                        nIn.specialValues[5] = nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder() - (nIn.xSize * nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder());
                        diff1.values[0].getY().setMultiplier(0.0);
                        diff1.values[0].getY().setAdder(0.0);
                        diff1.rWidth = 0.0;
                        diff2.values[1].getY().setMultiplier(0.0);
                        diff2.values[1].getY().setAdder(0.0);
                        diff2.lWidth = 0.0;
                    } else {
                        nIn.specialValues[3] = nIn.xSize * nIn.nodeLayers[polIndex].values[1].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder());
                        nIn.specialValues[1] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder());
                        nIn.specialValues[2] = nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder() - (nIn.xSize * nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder());
                        nIn.specialValues[4] = nIn.xSize * nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder());
                        nIn.specialValues[5] = nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder() - (nIn.ySize * nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder());
                        diff1.values[0].getX().setMultiplier(0.0);
                        diff1.values[0].getX().setAdder(0.0);
                        diff1.rWidth = 0.0;
                        diff2.values[1].getX().setMultiplier(0.0);
                        diff2.values[1].getX().setAdder(0.0);
                        diff2.lWidth = 0.0;
                    }
                }
                double lX = 0.0;
                double hX = 0.0;
                double lY = 0.0;
                double hY = 0.0;
                boolean found = false;
                for (Sample ns6 : firstEx.samples) {
                    if (ns6.layer != null) continue;
                    found = true;
                    if (ns6.values != null) {
                        boolean err = false;
                        if (ns6.values[0].getX().getMultiplier() == -0.5) {
                            lX = ns6.values[0].getX().getAdder();
                        } else if (ns6.values[0].getX().getMultiplier() == 0.5) {
                            lX = nIn.xSize + ns6.values[0].getX().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns6.values[0].getY().getMultiplier() == -0.5) {
                            lY = ns6.values[0].getY().getAdder();
                        } else if (ns6.values[0].getY().getMultiplier() == 0.5) {
                            lY = nIn.ySize + ns6.values[0].getY().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns6.values[1].getX().getMultiplier() == 0.5) {
                            hX = -ns6.values[1].getX().getAdder();
                        } else if (ns6.values[1].getX().getMultiplier() == -0.5) {
                            hX = nIn.xSize - ns6.values[1].getX().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns6.values[1].getY().getMultiplier() == 0.5) {
                            hY = -ns6.values[1].getY().getAdder();
                        } else if (ns6.values[1].getY().getMultiplier() == -0.5) {
                            hY = nIn.ySize - ns6.values[1].getY().getAdder();
                        } else {
                            err = true;
                        }
                        if (!err) continue;
                        this.error.markError(ns6.node, np, "Highlighting cannot scale from center");
                        return null;
                    }
                    this.error.markError(ns6.node, np, "No rule found for highlight");
                    return null;
                }
                if (!found) {
                    this.error.markError(null, np, "No highlight found");
                    return null;
                }
                if (lX != 0.0 || hX != 0.0 || lY != 0.0 || hY != 0.0) {
                    nList[nodeIndex].so = new SizeOffset(lX, hX, lY, hY);
                }
                ++nodeIndex;
            }
        }
        return nList;
    }

    private NodeInfo.LayerDetails[] makePrimitiveNodeLayers(List<Example> neList, Cell np, LayerInfo[] lis) {
        Example firstEx = neList.get(0);
        if (neList.size() <= 1) {
            return this.makeNodeScaledUniformly(neList, np, lis);
        }
        int count = 0;
        for (Sample ns : firstEx.samples) {
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            ++count;
        }
        NodeInfo.LayerDetails[] nodeLayers = new NodeInfo.LayerDetails[count];
        count = 0;
        for (Sample ns : firstEx.samples) {
            Technology.TechPoint[] newRule;
            if (ns.layer == Generic.tech.cellCenterNode) continue;
            AffineTransform trans = ns.node.rotateOut();
            Rectangle2D nodeBounds = this.getBoundingBox(ns.node);
            LayerInfo giLayer = null;
            if (ns.layer != null && ns.layer != Generic.tech.portNode) {
                String desiredLayer = ns.layer.getName().substring(6);
                for (int i = 0; i < lis.length; ++i) {
                    if (!desiredLayer.equals(lis[i].name)) continue;
                    giLayer = lis[i];
                    break;
                }
                if (giLayer == null) {
                    System.out.println("Cannot find layer " + desiredLayer);
                    return null;
                }
            }
            firstEx.studySample = ns;
            NodeInfo.LayerDetails multiRule = null;
            for (int n = 1; n < neList.size(); ++n) {
                Example ne = neList.get(n);
                int total = 0;
                for (Sample nso : ne.samples) {
                    if (nso.assoc != ns) continue;
                    ne.studySample = nso;
                    ++total;
                }
                if (total == 0) {
                    this.error.markError(ns.node, np, "Still unassociated sample (shouldn't happen)");
                    return null;
                }
                if (total <= true) continue;
                if (ns.layer == null || ns.layer == Generic.tech.portNode) {
                    this.error.markError(ns.node, np, "Only contact layers may be iterated in examples");
                    return null;
                }
                multiRule = this.getMultiCutRule(ns, neList, np);
                if (multiRule != null) break;
            }
            if (multiRule != null) {
                multiRule.layer = giLayer;
                nodeLayers[count] = multiRule;
                ++count;
                continue;
            }
            Point2D[] pointList = null;
            int[] pointFactor = null;
            Point2D[] points = null;
            if (ns.node.getProto() == Artwork.tech.filledPolygonNode || ns.node.getProto() == Artwork.tech.closedPolygonNode || ns.node.getProto() == Artwork.tech.openedPolygonNode || ns.node.getProto() == Artwork.tech.openedDottedPolygonNode || ns.node.getProto() == Artwork.tech.openedDashedPolygonNode || ns.node.getProto() == Artwork.tech.openedThickerPolygonNode) {
                points = ns.node.getTrace();
            }
            int trueCount = 0;
            int minFactor = 0;
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i = 0; i < points.length; ++i) {
                    pointList[i] = new Point2D.Double(nodeBounds.getCenterX() + points[i].getX(), nodeBounds.getCenterY() + points[i].getY());
                    trans.transform(pointList[i], pointList[i]);
                }
                trueCount = points.length;
            } else {
                double[] angles = null;
                if ((ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode) && (angles = ns.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    trueCount = 3;
                } else if (ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode || ns.node.getProto() == Artwork.tech.filledCircleNode) {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    trueCount = 2;
                } else {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    trueCount = 2;
                }
            }
            double[] pointLeftDist = new double[pointFactor.length];
            double[] pointRightDist = new double[pointFactor.length];
            double[] pointBottomDist = new double[pointFactor.length];
            double[] pointTopDist = new double[pointFactor.length];
            double[] centerXDist = new double[pointFactor.length];
            double[] centerYDist = new double[pointFactor.length];
            double[] pointXRatio = new double[pointFactor.length];
            double[] pointYRatio = new double[pointFactor.length];
            for (int i = 0; i < pointFactor.length; ++i) {
                pointLeftDist[i] = pointList[i].getX() - firstEx.lx;
                pointRightDist[i] = firstEx.hx - pointList[i].getX();
                pointBottomDist[i] = pointList[i].getY() - firstEx.ly;
                pointTopDist[i] = firstEx.hy - pointList[i].getY();
                centerXDist[i] = pointList[i].getX() - (firstEx.lx + firstEx.hx) / 2.0;
                centerYDist[i] = pointList[i].getY() - (firstEx.ly + firstEx.hy) / 2.0;
                pointXRatio[i] = firstEx.hx == firstEx.lx ? 0.0 : (pointList[i].getX() - (firstEx.lx + firstEx.hx) / 2.0) / (firstEx.hx - firstEx.lx);
                pointYRatio[i] = firstEx.hy == firstEx.ly ? 0.0 : (pointList[i].getY() - (firstEx.ly + firstEx.hy) / 2.0) / (firstEx.hy - firstEx.ly);
                pointFactor[i] = i < trueCount ? 255 : 48;
            }
            Point2D[] pointCoords = new Point2D[pointFactor.length];
            for (int n = 1; n < neList.size(); ++n) {
                Example ne = neList.get(n);
                NodeInst ni = ne.studySample.node;
                AffineTransform oTrans = ni.rotateOut();
                Rectangle2D oNodeBounds = this.getBoundingBox(ni);
                Point2D[] oPoints = null;
                if (ni.getProto() == Artwork.tech.filledPolygonNode || ni.getProto() == Artwork.tech.closedPolygonNode || ni.getProto() == Artwork.tech.openedPolygonNode || ni.getProto() == Artwork.tech.openedDottedPolygonNode || ni.getProto() == Artwork.tech.openedDashedPolygonNode || ni.getProto() == Artwork.tech.openedThickerPolygonNode) {
                    oPoints = ni.getTrace();
                }
                int newCount = 2;
                if (oPoints != null) {
                    newCount = oPoints.length;
                    int numPoints = Math.min(trueCount, newCount);
                    int bestOffset = 0;
                    double bestDist = Double.MAX_VALUE;
                    for (int offset = 0; offset < numPoints; ++offset) {
                        double dist = 0.0;
                        for (int i = 0; i < numPoints; ++i) {
                            double dX = points[i].getX() - oPoints[(i + offset) % numPoints].getX();
                            double dY = points[i].getY() - oPoints[(i + offset) % numPoints].getY();
                            dist += Math.hypot(dX, dY);
                        }
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestOffset = offset;
                    }
                    for (int i = 0; i < numPoints; ++i) {
                        pointCoords[i] = new Point2D.Double(oNodeBounds.getCenterX() + oPoints[(i + bestOffset) % numPoints].getX(), oNodeBounds.getCenterY() + oPoints[(i + bestOffset) % numPoints].getY());
                        oTrans.transform(pointCoords[i], pointCoords[i]);
                    }
                } else {
                    double[] angles = null;
                    if ((ni.getProto() == Artwork.tech.circleNode || ni.getProto() == Artwork.tech.thickCircleNode) && (angles = ni.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                        angles = null;
                    }
                    if (angles != null) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        double dist = oNodeBounds.getMaxX() - oNodeBounds.getCenterX();
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getCenterX() + dist * Math.cos(angles[0]), oNodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                        oTrans.transform(pointCoords[1], pointCoords[1]);
                    } else if (ni.getProto() == Artwork.tech.circleNode || ni.getProto() == Artwork.tech.thickCircleNode || ni.getProto() == Artwork.tech.filledCircleNode) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getCenterY());
                    } else {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getMinX(), oNodeBounds.getMinY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getMaxY());
                    }
                }
                if (newCount != trueCount) {
                    this.error.markError(ni, np, "Main example of layer " + Info.getSampleName(ne.studySample.layer) + " has " + trueCount + " points but this has " + newCount);
                    return null;
                }
                for (int i = 0; i < trueCount; ++i) {
                    if (!DBMath.areEquals(pointLeftDist[i], pointCoords[i].getX() - ne.lx)) {
                        int n2 = i;
                        pointFactor[n2] = pointFactor[n2] & 0xFFFFFFFE;
                    }
                    if (!DBMath.areEquals(pointRightDist[i], ne.hx - pointCoords[i].getX())) {
                        int n3 = i;
                        pointFactor[n3] = pointFactor[n3] & 0xFFFFFFFD;
                    }
                    if (!DBMath.areEquals(pointBottomDist[i], pointCoords[i].getY() - ne.ly)) {
                        int n4 = i;
                        pointFactor[n4] = pointFactor[n4] & 0xFFFFFFF7;
                    }
                    if (!DBMath.areEquals(pointTopDist[i], ne.hy - pointCoords[i].getY())) {
                        int n5 = i;
                        pointFactor[n5] = pointFactor[n5] & 0xFFFFFFFB;
                    }
                    if (!DBMath.areEquals(centerXDist[i], pointCoords[i].getX() - (ne.lx + ne.hx) / 2.0)) {
                        int n6 = i;
                        pointFactor[n6] = pointFactor[n6] & 0xFFFFFFEF;
                    }
                    if (!DBMath.areEquals(centerYDist[i], pointCoords[i].getY() - (ne.ly + ne.hy) / 2.0)) {
                        int n7 = i;
                        pointFactor[n7] = pointFactor[n7] & 0xFFFFFFDF;
                    }
                    double r = 0.0;
                    if (ne.hx != ne.lx) {
                        r = (pointCoords[i].getX() - (ne.lx + ne.hx) / 2.0) / (ne.hx - ne.lx);
                    }
                    if (!DBMath.areEquals(r, pointXRatio[i])) {
                        int n8 = i;
                        pointFactor[n8] = pointFactor[n8] & 0xFFFFFFBF;
                    }
                    if (DBMath.areEquals(r = ne.hy == ne.ly ? 0.0 : (pointCoords[i].getY() - (ne.ly + ne.hy) / 2.0) / (ne.hy - ne.ly), pointYRatio[i])) continue;
                    int n9 = i;
                    pointFactor[n9] = pointFactor[n9] & 0xFFFFFF7F;
                }
                if (ns.layer != Generic.tech.portNode) continue;
                Variable var = ns.node.getVar(Info.PORTANGLE_KEY);
                Variable var2 = ni.getVar(Info.PORTANGLE_KEY);
                if (var == null && var2 != null) {
                    System.out.println("Warning: moving port angle to main example of " + np);
                    ns.node.newVar(Info.PORTANGLE_KEY, var2.getObject());
                }
                var = ns.node.getVar(Info.PORTRANGE_KEY);
                var2 = ni.getVar(Info.PORTRANGE_KEY);
                if (var == null && var2 != null) {
                    System.out.println("Warning: moving port range to main example of " + np);
                    ns.node.newVar(Info.PORTRANGE_KEY, var2.getObject());
                }
                var = ns.node.getVar(Info.CONNECTION_KEY);
                var2 = ni.getVar(Info.CONNECTION_KEY);
                if (var != null || var2 == null) continue;
                System.out.println("Warning: moving port connections to main example of " + np);
                ns.node.newVar(Info.CONNECTION_KEY, var2.getObject());
            }
            if (ns.layer == null) {
                for (int i = 0; i < trueCount; ++i) {
                    if ((pointFactor[i] & 3) != 0 && (pointFactor[i] & 0xC) != 0) continue;
                    this.error.markError(ns.node, np, "Highlight must be constant distance from edge");
                    return null;
                }
            }
            if ((newRule = this.stretchPoints(pointList, pointFactor, ns, np, neList)) == null) {
                return null;
            }
            ns.msg = Info.getValueOnNode(ns.node);
            if (ns.msg != null && ns.msg.length() == 0) {
                ns.msg = null;
            }
            ns.values = newRule;
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            nodeLayers[count] = new NodeInfo.LayerDetails();
            nodeLayers[count].layer = giLayer;
            nodeLayers[count].ns = ns;
            nodeLayers[count].style = this.getStyle(ns.node);
            nodeLayers[count].representation = 0;
            nodeLayers[count].values = this.fixValues(np, ns.values);
            if (nodeLayers[count].values.length == 2 && (nodeLayers[count].style == Poly.Type.CROSSED || nodeLayers[count].style == Poly.Type.FILLED || nodeLayers[count].style == Poly.Type.CLOSED)) {
                nodeLayers[count].representation = 1;
            }
            ++count;
        }
        if (count != nodeLayers.length) {
            System.out.println("Warning: Generated only " + count + " of " + nodeLayers.length + " layers for " + np);
        }
        return nodeLayers;
    }

    private NodeInfo.LayerDetails[] makeNodeScaledUniformly(List<Example> neList, Cell np, LayerInfo[] lis) {
        Example firstEx = neList.get(0);
        int count = 0;
        for (Sample ns : firstEx.samples) {
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            ++count;
        }
        NodeInfo.LayerDetails[] nodeLayers = new NodeInfo.LayerDetails[count];
        count = 0;
        for (Sample ns : firstEx.samples) {
            Rectangle2D nodeBounds = this.getBoundingBox(ns.node);
            AffineTransform trans = ns.node.rotateOut();
            Point2D[] pointList = null;
            int[] pointFactor = null;
            Point2D[] points = null;
            if (ns.node.getProto() == Artwork.tech.filledPolygonNode || ns.node.getProto() == Artwork.tech.closedPolygonNode || ns.node.getProto() == Artwork.tech.openedPolygonNode || ns.node.getProto() == Artwork.tech.openedDottedPolygonNode || ns.node.getProto() == Artwork.tech.openedDashedPolygonNode || ns.node.getProto() == Artwork.tech.openedThickerPolygonNode) {
                points = ns.node.getTrace();
            }
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i = 0; i < points.length; ++i) {
                    pointList[i] = new Point2D.Double(nodeBounds.getCenterX() + points[i].getX(), nodeBounds.getCenterY() + points[i].getY());
                    trans.transform(pointList[i], pointList[i]);
                    pointFactor[i] = 192;
                }
            } else {
                double[] angles = null;
                if ((ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode) && (angles = ns.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    pointFactor[0] = 48;
                    pointFactor[1] = 192;
                    pointFactor[2] = 192;
                } else if (ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode || ns.node.getProto() == Artwork.tech.filledCircleNode) {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    pointFactor[0] = 48;
                    pointFactor[1] = 34;
                } else {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    pointFactor[0] = 9;
                    pointFactor[1] = 6;
                }
            }
            Technology.TechPoint[] newRule = this.stretchPoints(pointList, pointFactor, ns, np, neList);
            if (newRule == null) {
                return null;
            }
            ns.msg = Info.getValueOnNode(ns.node);
            if (ns.msg != null && ns.msg.length() == 0) {
                ns.msg = null;
            }
            ns.values = newRule;
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            LayerInfo layer = null;
            String desiredLayer = ns.layer.getName().substring(6);
            for (int i = 0; i < lis.length; ++i) {
                if (!desiredLayer.equals(lis[i].name)) continue;
                layer = lis[i];
                break;
            }
            if (layer == null) {
                this.error.markError(ns.node, np, "Unknown layer: " + desiredLayer);
                return null;
            }
            nodeLayers[count] = new NodeInfo.LayerDetails();
            nodeLayers[count].layer = layer;
            nodeLayers[count].ns = ns;
            nodeLayers[count].style = this.getStyle(ns.node);
            nodeLayers[count].representation = 0;
            nodeLayers[count].values = this.fixValues(np, ns.values);
            if (nodeLayers[count].values.length == 2 && (nodeLayers[count].style == Poly.Type.CROSSED || nodeLayers[count].style == Poly.Type.FILLED || nodeLayers[count].style == Poly.Type.CLOSED)) {
                nodeLayers[count].representation = 1;
            }
            ++count;
        }
        return nodeLayers;
    }

    private NodeInfo.LayerDetails getMultiCutRule(Sample ns, List<Example> neList, Cell np) {
        Example firstEx = neList.get(0);
        Sample hs = this.needHighlightLayer(firstEx, np);
        if (hs == null) {
            return null;
        }
        Rectangle2D highlightBounds = hs.node.getBounds();
        Rectangle2D nodeBounds = ns.node.getBounds();
        double multiXS = nodeBounds.getWidth();
        double multiYS = nodeBounds.getHeight();
        double multiIndent = nodeBounds.getMinX() - highlightBounds.getMinX();
        double realIndentX = nodeBounds.getMinX() - firstEx.lx + multiXS / 2.0;
        double realIndentY = nodeBounds.getMinY() - firstEx.ly + multiYS / 2.0;
        if (highlightBounds.getMaxX() - nodeBounds.getMaxX() != multiIndent || nodeBounds.getMinY() - highlightBounds.getMinY() != multiIndent || highlightBounds.getMaxY() - nodeBounds.getMaxY() != multiIndent) {
            this.error.markError(ns.node, np, "Multiple contact cuts must be indented uniformly");
            return null;
        }
        double xSep = -1.0;
        double ySep = -1.0;
        for (int n = 1; n < neList.size(); ++n) {
            double sepY;
            double sepX;
            Rectangle2D lastNodeBounds;
            Rectangle2D thisNodeBounds;
            int i;
            Example ne = neList.get(n);
            int total = 0;
            for (Sample nso : ne.samples) {
                if (nso.assoc != ns) continue;
                Rectangle2D oNodeBounds = nso.node.getBounds();
                if (multiXS != oNodeBounds.getWidth() || multiYS != oNodeBounds.getHeight()) {
                    this.error.markError(nso.node, np, "Multiple contact cuts must not differ in size");
                    return null;
                }
                ++total;
            }
            Sample[] nsList = new Sample[total];
            int fill = 0;
            for (Sample nso : ne.samples) {
                if (nso.assoc != ns) continue;
                nsList[fill++] = nso;
            }
            for (i = 1; i < total; ++i) {
                thisNodeBounds = nsList[i].node.getBounds();
                lastNodeBounds = nsList[i - 1].node.getBounds();
                sepX = Math.abs(lastNodeBounds.getCenterX() - thisNodeBounds.getCenterX());
                sepY = Math.abs(lastNodeBounds.getCenterY() - thisNodeBounds.getCenterY());
                if (sepX < multiXS && sepY < multiYS) {
                    this.error.markError(nsList[i].node, np, "Multiple contact cuts must not overlap");
                    return null;
                }
                if (sepX >= multiXS) {
                    if (xSep < 0.0) {
                        xSep = sepX;
                    } else if (xSep > sepX) {
                        xSep = sepX;
                    }
                }
                if (!(sepY >= multiYS)) continue;
                if (ySep < 0.0) {
                    ySep = sepY;
                    continue;
                }
                if (!(ySep > sepY)) continue;
                ySep = sepY;
            }
            for (i = 1; i < total; ++i) {
                thisNodeBounds = nsList[i].node.getBounds();
                lastNodeBounds = nsList[i - 1].node.getBounds();
                sepX = Math.abs(lastNodeBounds.getCenterX() - thisNodeBounds.getCenterX());
                sepY = Math.abs(lastNodeBounds.getCenterY() - thisNodeBounds.getCenterY());
                if (sepX / xSep * xSep != sepX) {
                    this.error.markError(nsList[i].node, np, "Multiple contact cut X spacing must be uniform");
                    return null;
                }
                if (sepY / ySep * ySep == sepY) continue;
                this.error.markError(nsList[i].node, np, "Multiple contact cut Y spacing must be uniform");
                return null;
            }
        }
        double multiSepX = xSep - multiXS;
        double multiSepY = ySep - multiYS;
        if (multiSepX != multiSepY) {
            this.error.markError(null, np, "Multiple contact cut X and Y spacing must be the same");
            return null;
        }
        ns.values = new Technology.TechPoint[2];
        ns.values[0] = new Technology.TechPoint(EdgeH.fromLeft(realIndentX), EdgeV.fromBottom(realIndentY));
        ns.values[1] = new Technology.TechPoint(EdgeH.fromRight(realIndentX), EdgeV.fromTop(realIndentY));
        NodeInfo.LayerDetails multiDetails = new NodeInfo.LayerDetails();
        multiDetails.style = this.getStyle(ns.node);
        multiDetails.representation = 0;
        if (multiDetails.style == Poly.Type.CROSSED || multiDetails.style == Poly.Type.FILLED || multiDetails.style == Poly.Type.CLOSED) {
            multiDetails.representation = 1;
        }
        multiDetails.values = ns.values;
        multiDetails.ns = ns;
        multiDetails.multiCut = true;
        multiDetails.representation = 3;
        multiDetails.multiXS = multiXS;
        multiDetails.multiYS = multiYS;
        multiDetails.multiIndent = multiIndent;
        multiDetails.multiSep = multiSepX;
        multiDetails.multiSep2D = multiSepX;
        return multiDetails;
    }

    private Technology.TechPoint[] stretchPoints(Point2D[] pts, int[] factor, Sample ns, Cell np, List<Example> neList) {
        Example firstEx = neList.get(0);
        Technology.TechPoint[] newRule = new Technology.TechPoint[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            EdgeH horiz = null;
            if ((factor[i] & 1) != 0) {
                horiz = EdgeH.fromLeft(pts[i].getX() - firstEx.lx);
            } else if ((factor[i] & 2) != 0) {
                horiz = EdgeH.fromRight(firstEx.hx - pts[i].getX());
            } else if ((factor[i] & 0x10) != 0) {
                horiz = EdgeH.fromCenter(pts[i].getX() - (firstEx.lx + firstEx.hx) / 2.0);
            } else if ((factor[i] & 0x40) != 0) {
                horiz = firstEx.hx == firstEx.lx ? EdgeH.makeCenter() : new EdgeH((pts[i].getX() - (firstEx.lx + firstEx.hx) / 2.0) / (firstEx.hx - firstEx.lx), 0.0);
            } else {
                this.error.markStretchProblem(neList, ns, np, pts[i].getX(), true);
                return null;
            }
            EdgeV vert = null;
            if ((factor[i] & 8) != 0) {
                vert = EdgeV.fromBottom(pts[i].getY() - firstEx.ly);
            } else if ((factor[i] & 4) != 0) {
                vert = EdgeV.fromTop(firstEx.hy - pts[i].getY());
            } else if ((factor[i] & 0x20) != 0) {
                vert = EdgeV.fromCenter(pts[i].getY() - (firstEx.ly + firstEx.hy) / 2.0);
            } else if ((factor[i] & 0x80) != 0) {
                vert = firstEx.hy == firstEx.ly ? EdgeV.makeCenter() : new EdgeV((pts[i].getY() - (firstEx.ly + firstEx.hy) / 2.0) / (firstEx.hy - firstEx.ly), 0.0);
            } else {
                this.error.markStretchProblem(neList, ns, np, pts[i].getY(), false);
                return null;
            }
            newRule[i] = new Technology.TechPoint(horiz, vert);
        }
        return newRule;
    }

    private Technology.TechPoint[] fixValues(NodeProto np, Technology.TechPoint[] currentList) {
        EdgeH h1 = null;
        EdgeH h2 = null;
        EdgeH h3 = null;
        EdgeV v1 = null;
        EdgeV v2 = null;
        EdgeV v3 = null;
        for (int p = 0; p < currentList.length; ++p) {
            EdgeH h = currentList[p].getX();
            if (h.equals(h1) || h.equals(h2) || h.equals(h3)) continue;
            if (h1 == null) {
                h1 = h;
            } else if (h2 == null) {
                h2 = h;
            } else {
                h3 = h;
            }
            EdgeV v = currentList[p].getY();
            if (v.equals(v1) || v.equals(v2) || v.equals(v3)) continue;
            if (v1 == null) {
                v1 = v;
                continue;
            }
            if (v2 == null) {
                v2 = v;
                continue;
            }
            v3 = v;
        }
        if (h1 != null && h2 != null && h3 == null && v1 != null && v2 != null && v3 == null) {
            currentList = new Technology.TechPoint[]{new Technology.TechPoint(h1, v1), new Technology.TechPoint(h2, v2)};
        }
        return currentList;
    }

    private boolean associateExamples(List<Example> neList, Cell np) {
        if (neList.size() <= 1) {
            return false;
        }
        Example firstEx = neList.get(0);
        for (int n = 1; n < neList.size(); ++n) {
            Example ne = neList.get(n);
            for (Sample ns : ne.samples) {
                ns.assoc = null;
            }
            for (Sample ns : ne.samples) {
                Sample thisSample;
                if (ns.assoc != null) continue;
                if (ns.layer == Generic.tech.cellCenterNode) {
                    this.error.markError(ns.node, np, "Grab point should only be in main example");
                    return true;
                }
                int total = 0;
                Sample nsFound = null;
                for (Sample nsList : firstEx.samples) {
                    if (nsList.layer != ns.layer) continue;
                    ++total;
                    nsFound = nsList;
                }
                if (total == 0) {
                    this.error.markError(ns.node, np, "Layer " + Info.getSampleName(ns.layer) + " not found in main example");
                    return true;
                }
                if (total == 1) {
                    ns.assoc = nsFound;
                    continue;
                }
                if (ns.layer == Generic.tech.portNode) {
                    String name = Info.getPortName(ns.node);
                    if (name == null) {
                        this.error.markError(ns.node, np, "Port does not have a name");
                        return true;
                    }
                    boolean found = false;
                    for (Sample nsList : firstEx.samples) {
                        if (nsList.layer != Generic.tech.portNode) continue;
                        String otherName = Info.getPortName(nsList.node);
                        if (otherName == null) {
                            this.error.markError(nsList.node, np, "Port does not have a name");
                            return true;
                        }
                        if (!name.equalsIgnoreCase(otherName)) continue;
                        ns.assoc = nsList;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.error.markError(null, np, "Could not find port " + name + " in all examples");
                    return true;
                }
                int i = 0;
                for (Sample nsList : ne.samples) {
                    if (nsList.layer != ns.layer) continue;
                    ++i;
                }
                if (total != i) {
                    this.error.markError(ns.node, np, "Layer " + Info.getSampleName(ns.layer) + " found " + total + " times in main example, " + i + " in others");
                    return true;
                }
                ArrayList<Sample> mainList = new ArrayList<Sample>();
                i = 0;
                for (Sample nsList : firstEx.samples) {
                    if (nsList.layer != ns.layer) continue;
                    mainList.add(nsList);
                }
                ArrayList<Sample> thisList = new ArrayList<Sample>();
                i = 0;
                for (Sample nsList : ne.samples) {
                    if (nsList.layer != ns.layer) continue;
                    thisList.add(nsList);
                }
                Collections.sort(mainList, new SampleCoordAscending());
                Collections.sort(thisList, new SampleCoordAscending());
                for (i = 1; i < total; ++i) {
                    thisSample = (Sample)thisList.get(i);
                    Sample lastSample = (Sample)thisList.get(i - 1);
                    Sample thisMainSample = (Sample)mainList.get(i);
                    Sample lastMainSample = (Sample)mainList.get(i - 1);
                    if (thisSample.xPos == lastSample.xPos && thisSample.yPos == lastSample.yPos && thisSample.node.getProto() == lastSample.node.getProto() || thisMainSample.xPos == lastMainSample.xPos && thisMainSample.yPos == lastMainSample.yPos && thisMainSample.node.getProto() == lastMainSample.node.getProto()) break;
                }
                if (i >= total) {
                    for (i = 0; i < total; ++i) {
                        thisSample = (Sample)thisList.get(i);
                        thisSample.assoc = (Sample)mainList.get(i);
                    }
                    continue;
                }
                thisSample = (Sample)thisList.get(i);
                this.error.markError(thisSample.node, np, "Sample " + Info.getSampleName(thisSample.layer) + " is unassociated");
                return true;
            }
            for (Sample nsList : firstEx.samples) {
                nsList.assoc = null;
            }
            Iterator<Sample> i$ = ne.samples.iterator();
            while (i$.hasNext()) {
                Sample ns;
                ns.assoc.assoc = ns = i$.next();
            }
            for (Sample nsList : firstEx.samples) {
                if (nsList.assoc != null || nsList.layer == Generic.tech.cellCenterNode) continue;
                this.error.markError(nsList.node, np, "Layer " + Info.getSampleName(nsList.layer) + " found in main example, but not others");
                return true;
            }
        }
        return false;
    }

    private Poly.Type getStyle(NodeInst ni) {
        Variable var;
        Poly.Type sty = null;
        if (ni.getProto() == Artwork.tech.filledBoxNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech.boxNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech.crossedBoxNode) {
            sty = Poly.Type.CROSSED;
        } else if (ni.getProto() == Artwork.tech.filledPolygonNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech.closedPolygonNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech.openedPolygonNode) {
            sty = Poly.Type.OPENED;
        } else if (ni.getProto() == Artwork.tech.openedDottedPolygonNode) {
            sty = Poly.Type.OPENEDT1;
        } else if (ni.getProto() == Artwork.tech.openedDashedPolygonNode) {
            sty = Poly.Type.OPENEDT2;
        } else if (ni.getProto() == Artwork.tech.openedThickerPolygonNode) {
            sty = Poly.Type.OPENEDT3;
        } else if (ni.getProto() == Artwork.tech.filledCircleNode) {
            sty = Poly.Type.DISC;
        } else if (ni.getProto() == Artwork.tech.circleNode) {
            sty = Poly.Type.CIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.CIRCLEARC;
            }
        } else if (ni.getProto() == Artwork.tech.thickCircleNode) {
            sty = Poly.Type.THICKCIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.THICKCIRCLEARC;
            }
        } else if (ni.getProto() == Generic.tech.invisiblePinNode && (var = ni.getVar(Artwork.ART_MESSAGE)) != null) {
            AbstractTextDescriptor.Position pos = var.getTextDescriptor().getPos();
            if (pos == AbstractTextDescriptor.Position.BOXED) {
                sty = Poly.Type.TEXTBOX;
            } else if (pos == AbstractTextDescriptor.Position.CENT) {
                sty = Poly.Type.TEXTCENT;
            } else if (pos == AbstractTextDescriptor.Position.UP) {
                sty = Poly.Type.TEXTBOT;
            } else if (pos == AbstractTextDescriptor.Position.DOWN) {
                sty = Poly.Type.TEXTTOP;
            } else if (pos == AbstractTextDescriptor.Position.LEFT) {
                sty = Poly.Type.TEXTRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.RIGHT) {
                sty = Poly.Type.TEXTLEFT;
            } else if (pos == AbstractTextDescriptor.Position.UPLEFT) {
                sty = Poly.Type.TEXTBOTRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.UPRIGHT) {
                sty = Poly.Type.TEXTBOTLEFT;
            } else if (pos == AbstractTextDescriptor.Position.DOWNLEFT) {
                sty = Poly.Type.TEXTTOPRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.DOWNRIGHT) {
                sty = Poly.Type.TEXTTOPLEFT;
            }
        }
        if (sty == null) {
            System.out.println("Warning: Cannot determine style to use for " + ni.describe(false) + " node in " + ni.getParent() + ", assuming FILLED");
            sty = Poly.Type.FILLED;
        }
        return sty;
    }

    private Rectangle2D getBoundingBox(NodeInst ni) {
        Rectangle2D bounds = ni.getBounds();
        if (ni.getProto() == Generic.tech.portNode) {
            double portShrink = 2.0;
            bounds.setRect(bounds.getMinX() + portShrink, bounds.getMinY() + portShrink, bounds.getWidth() - portShrink * 2.0, bounds.getHeight() - portShrink * 2.0);
        }
        bounds.setRect(DBMath.round(bounds.getMinX()), DBMath.round(bounds.getMinY()), DBMath.round(bounds.getWidth()), DBMath.round(bounds.getHeight()));
        return bounds;
    }

    private Sample needHighlightLayer(Example neList, Cell np) {
        for (Sample ns : neList.samples) {
            if (ns.layer != null) continue;
            return ns;
        }
        this.error.markError(null, np, "No highlight layer on contact");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Xml.Technology makeXml(String newTechName, GeneralInfo gi, LayerInfo[] lList, NodeInfo[] nList, ArcInfo[] aList) {
        void var11_25;
        int len$;
        Xml.Technology t = new Xml.Technology();
        t.techName = newTechName;
        t.shortTechName = gi.shortName;
        t.description = gi.description;
        Xml.Version version = new Xml.Version();
        version.techVersion = 1;
        version.electricVersion = Version.parseVersion("8.05g");
        t.versions.add(version);
        version = new Xml.Version();
        version.techVersion = 2;
        version.electricVersion = Version.parseVersion("8.05o");
        t.versions.add(version);
        t.maxNumMetals = t.defaultNumMetals = gi.defaultNumMetals;
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = gi.scale;
        t.scaleRelevant = gi.scaleRelevant;
        t.defaultFoundry = gi.defaultFoundry;
        t.minResistance = gi.minRes;
        t.minCapacitance = gi.minCap;
        if (gi.transparentColors != null) {
            for (int i = 0; i < gi.transparentColors.length; ++i) {
                t.transparentLayers.add(gi.transparentColors[i]);
            }
        }
        for (LayerInfo layerInfo : lList) {
            if (layerInfo.pseudo) continue;
            Xml.Layer layer = new Xml.Layer();
            layer.name = layerInfo.name;
            layer.function = layerInfo.fun;
            layer.extraFunction = layerInfo.funExtra;
            layer.desc = layerInfo.desc;
            layer.thick3D = layerInfo.thick3d;
            layer.height3D = layerInfo.height3d;
            layer.mode3D = layerInfo.mode3d;
            layer.factor3D = layerInfo.factor3d;
            layer.cif = layerInfo.cif;
            layer.resistance = layerInfo.spiRes;
            layer.capacitance = layerInfo.spiCap;
            layer.edgeCapacitance = layerInfo.spiECap;
            if (layerInfo.pureLayerNode != null) {
                layer.pureLayerNode = new Xml.PureLayerNode();
                layer.pureLayerNode.name = layerInfo.pureLayerNode.name;
                layer.pureLayerNode.style = layerInfo.pureLayerNode.nodeLayers[0].style;
                layer.pureLayerNode.port = layerInfo.pureLayerNode.nodePortDetails[0].name;
                layer.pureLayerNode.size.value = DBMath.round(layerInfo.pureLayerNode.xSize);
                for (ArcInfo a : layerInfo.pureLayerNode.nodePortDetails[0].connections) {
                    layer.pureLayerNode.portArcs.add(a.name);
                }
            }
            t.layers.add(layer);
        }
        for (Info info : aList) {
            Xml.ArcProto ap = new Xml.ArcProto();
            ap.name = ((ArcInfo)info).name;
            ap.function = ((ArcInfo)info).func;
            ap.wipable = ((ArcInfo)info).wipes;
            ap.curvable = ((ArcInfo)info).curvable;
            ap.special = ((ArcInfo)info).special;
            ap.notUsed = ((ArcInfo)info).notUsed;
            ap.skipSizeInPalette = ((ArcInfo)info).skipSizeInPalette;
            ap.extended = !((ArcInfo)info).noExtend;
            ap.fixedAngle = ((ArcInfo)info).fixAng;
            ap.angleIncrement = ((ArcInfo)info).angInc;
            ap.antennaRatio = ((ArcInfo)info).antennaRatio;
            if (((ArcInfo)info).widthOffset != 0.0) {
                ap.diskOffset.put(1, new Double(DBMath.round(0.5 * ((ArcInfo)info).maxWidth)));
                ap.diskOffset.put(2, new Double(DBMath.round(0.5 * (((ArcInfo)info).maxWidth - ((ArcInfo)info).widthOffset))));
            } else {
                ap.diskOffset.put(2, new Double(DBMath.round(0.5 * ((ArcInfo)info).maxWidth)));
            }
            ap.defaultWidth.value = 0.0;
            for (ArcInfo.LayerDetails al : ((ArcInfo)info).arcDetails) {
                Xml.ArcLayer l = new Xml.ArcLayer();
                l.layer = al.layer.name;
                l.style = al.style == Poly.Type.FILLED ? Poly.Type.FILLED : Poly.Type.CLOSED;
                l.extend.value = DBMath.round((((ArcInfo)info).maxWidth - al.width) / 2.0);
                ap.arcLayers.add(l);
            }
            t.arcs.add(ap);
        }
        for (Info info : nList) {
            int j;
            if (((NodeInfo)info).func == PrimitiveNode.Function.NODE && ((NodeInfo)info).nodeLayers[0].layer.pureLayerNode == info) continue;
            Xml.PrimitiveNode pn = new Xml.PrimitiveNode();
            pn.name = ((NodeInfo)info).name;
            pn.function = ((NodeInfo)info).func;
            pn.shrinkArcs = ((NodeInfo)info).arcsShrink;
            pn.square = ((NodeInfo)info).square;
            pn.canBeZeroSize = ((NodeInfo)info).canBeZeroSize;
            pn.wipes = ((NodeInfo)info).wipes;
            pn.lockable = ((NodeInfo)info).lockable;
            pn.edgeSelect = ((NodeInfo)info).edgeSelect;
            pn.skipSizeInPalette = ((NodeInfo)info).skipSizeInPalette;
            pn.notUsed = ((NodeInfo)info).notUsed;
            pn.lowVt = ((NodeInfo)info).lowVt;
            pn.highVt = ((NodeInfo)info).highVt;
            pn.nativeBit = ((NodeInfo)info).nativeBit;
            pn.od18 = ((NodeInfo)info).od18;
            pn.od25 = ((NodeInfo)info).od25;
            pn.od33 = ((NodeInfo)info).od33;
            EPoint minFullSize = EPoint.fromLambda(0.5 * ((NodeInfo)info).xSize, 0.5 * ((NodeInfo)info).ySize);
            SizeOffset so = ((NodeInfo)info).so;
            if (so != null && so.getLowXOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighYOffset() == 0.0) {
                so = null;
            }
            if (so != null) {
                EPoint p2 = EPoint.fromGrid(minFullSize.getGridX() - (so.getLowXGridOffset() + so.getHighXGridOffset() >> 1), minFullSize.getGridY() - (so.getLowYGridOffset() + so.getHighYGridOffset() >> 1));
                pn.diskOffset.put(1, minFullSize);
                pn.diskOffset.put(2, p2);
            } else {
                pn.diskOffset.put(2, minFullSize);
            }
            pn.sizeOffset = so;
            pn.spiceTemplate = ((NodeInfo)info).spiceTemplate;
            for (j = 0; j < ((NodeInfo)info).nodeLayers.length; ++j) {
                NodeInfo.LayerDetails nl = ((NodeInfo)info).nodeLayers[j];
                pn.nodeLayers.add(this.makeNodeLayerDetails(nl, ((NodeInfo)info).serp, minFullSize));
            }
            for (j = 0; j < ((NodeInfo)info).nodePortDetails.length; ++j) {
                NodeInfo.PortDetails pd = ((NodeInfo)info).nodePortDetails[j];
                Xml.PrimitivePort pp = new Xml.PrimitivePort();
                pp.name = pd.name;
                pp.portAngle = pd.angle;
                pp.portRange = pd.range;
                pp.portTopology = pd.netIndex;
                EdgeH left = pd.values[0].getX();
                EdgeH right = pd.values[1].getX();
                EdgeV bottom = pd.values[0].getY();
                EdgeV top = pd.values[1].getY();
                pp.lx.k = left.getMultiplier() * 2.0;
                pp.lx.value = left.getAdder() + minFullSize.getLambdaX() * left.getMultiplier() * 2.0;
                pp.hx.k = right.getMultiplier() * 2.0;
                pp.hx.value = right.getAdder() + minFullSize.getLambdaX() * right.getMultiplier() * 2.0;
                pp.ly.k = bottom.getMultiplier() * 2.0;
                pp.ly.value = bottom.getAdder() + minFullSize.getLambdaY() * bottom.getMultiplier() * 2.0;
                pp.hy.k = top.getMultiplier() * 2.0;
                pp.hy.value = top.getAdder() + minFullSize.getLambdaY() * top.getMultiplier() * 2.0;
                for (ArcInfo a : pd.connections) {
                    pp.portArcs.add(a.name);
                }
                pn.ports.add(pp);
            }
            pn.specialType = ((NodeInfo)info).specialType;
            if (pn.specialType == 1) {
                pn.specialValues = new double[6];
                for (int i = 0; i < 6; ++i) {
                    pn.specialValues[i] = ((NodeInfo)info).specialValues[i];
                }
            }
            pn.nodeSizeRule = ((NodeInfo)info).nodeSizeRule;
            t.nodes.add(pn);
        }
        this.addSpiceHeader(t, 1, gi.spiceLevel1Header);
        this.addSpiceHeader(t, 2, gi.spiceLevel2Header);
        this.addSpiceHeader(t, 3, gi.spiceLevel3Header);
        if (gi.menuPalette != null) {
            void var11_23;
            int numColumns;
            t.menuPalette = new Xml.MenuPalette();
            t.menuPalette.numColumns = numColumns = gi.menuPalette[0].length;
            Object[][] arr$ = gi.menuPalette;
            len$ = arr$.length;
            boolean bl = false;
            while (var11_23 < len$) {
                Object[] menuLine = arr$[var11_23];
                for (int i = 0; i < numColumns; ++i) {
                    t.menuPalette.menuBoxes.add(this.makeMenuBoxXml(t, menuLine[i]));
                }
                ++var11_23;
            }
        }
        Xml.Foundry foundry = new Xml.Foundry();
        foundry.name = gi.defaultFoundry;
        LayerInfo[] arr$ = lList;
        len$ = arr$.length;
        boolean bl = false;
        while (var11_25 < len$) {
            LayerInfo li = arr$[var11_25];
            if (li.gds != null && li.gds.length() > 0) {
                foundry.layerGds.put(li.name, li.gds);
            }
            ++var11_25;
        }
        if (gi.conDist != null && gi.unConDist != null) {
            void var11_27;
            int layerTotal = lList.length;
            int ruleIndex = 0;
            boolean bl2 = false;
            while (var11_27 < layerTotal) {
                LayerInfo l1 = lList[var11_27];
                for (void i2 = var11_27; i2 < layerTotal; ++i2) {
                    LayerInfo l2 = lList[i2];
                    double conSpa = gi.conDist[ruleIndex];
                    double uConSpa = gi.unConDist[ruleIndex];
                    if (conSpa > -1.0) {
                        foundry.rules.add(this.makeDesignRule("C" + ruleIndex, l1, l2, DRCTemplate.DRCRuleType.CONSPA, conSpa));
                    }
                    if (uConSpa > -1.0) {
                        foundry.rules.add(this.makeDesignRule("U" + ruleIndex, l1, l2, DRCTemplate.DRCRuleType.UCONSPA, uConSpa));
                    }
                    ++ruleIndex;
                }
                ++var11_27;
            }
        }
        t.foundries.add(foundry);
        return t;
    }

    private Xml.NodeLayer makeNodeLayerDetails(NodeInfo.LayerDetails nl, boolean isSerp, EPoint correction) {
        Xml.NodeLayer nld = new Xml.NodeLayer();
        nld.layer = nl.layer.name;
        nld.style = nl.style;
        nld.portNum = nl.portIndex;
        nld.inLayers = nl.inLayers;
        nld.inElectricalLayers = nl.inElectricalLayers;
        nld.representation = nl.representation;
        Technology.TechPoint[] points = nl.values;
        if (nld.representation == 1 || nld.representation == 3) {
            nld.lx.k = points[0].getX().getMultiplier() * 2.0;
            nld.lx.value = DBMath.round(points[0].getX().getAdder() + correction.getLambdaX() * points[0].getX().getMultiplier() * 2.0);
            nld.hx.k = points[1].getX().getMultiplier() * 2.0;
            nld.hx.value = DBMath.round(points[1].getX().getAdder() + correction.getLambdaX() * points[1].getX().getMultiplier() * 2.0);
            nld.ly.k = points[0].getY().getMultiplier() * 2.0;
            nld.ly.value = DBMath.round(points[0].getY().getAdder() + correction.getLambdaY() * points[0].getY().getMultiplier() * 2.0);
            nld.hy.k = points[1].getY().getMultiplier() * 2.0;
            nld.hy.value = DBMath.round(points[1].getY().getAdder() + correction.getLambdaY() * points[1].getY().getMultiplier() * 2.0);
        } else {
            for (Technology.TechPoint p : points) {
                nld.techPoints.add(this.correction(p, correction));
            }
        }
        nld.sizex = DBMath.round(nl.multiXS);
        nld.sizey = DBMath.round(nl.multiYS);
        nld.sep1d = DBMath.round(nl.multiSep);
        nld.sep2d = DBMath.round(nl.multiSep2D);
        if (isSerp) {
            nld.lWidth = DBMath.round(nl.lWidth);
            nld.rWidth = DBMath.round(nl.rWidth);
            nld.tExtent = DBMath.round(nl.extendT);
            nld.bExtent = DBMath.round(nl.extendB);
        }
        return nld;
    }

    private Technology.TechPoint correction(Technology.TechPoint p, EPoint correction) {
        EdgeH h = p.getX();
        EdgeV v = p.getY();
        h = new EdgeH(h.getMultiplier(), h.getAdder() + correction.getLambdaX() * h.getMultiplier() * 2.0);
        v = new EdgeV(v.getMultiplier(), v.getAdder() + correction.getLambdaY() * v.getMultiplier() * 2.0);
        return new Technology.TechPoint(h, v);
    }

    private void addSpiceHeader(Xml.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml.SpiceHeader spiceHeader = new Xml.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    private ArrayList<Object> makeMenuBoxXml(Xml.Technology t, Object o) {
        ArrayList<Object> menuBox = new ArrayList<Object>();
        if (o != null) {
            if (o instanceof List) {
                for (Object subO : (List)o) {
                    menuBox.add(subO);
                }
            } else {
                menuBox.add(o);
            }
        }
        return menuBox;
    }

    private DRCTemplate makeDesignRule(String ruleName, LayerInfo l1, LayerInfo l2, DRCTemplate.DRCRuleType type, double value) {
        return new DRCTemplate(ruleName, DRCTemplate.DRCMode.ALL.mode(), type, l1.name, l2.name, new double[]{value}, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SampleCoordAscending
    implements Comparator<Sample> {
        private SampleCoordAscending() {
        }

        @Override
        public int compare(Sample s1, Sample s2) {
            if (s1.xPos != s2.xPos) {
                return (int)(s1.xPos - s2.xPos);
            }
            if (s1.yPos != s2.yPos) {
                return (int)(s1.yPos - s2.yPos);
            }
            return s1.node.getName().compareTo(s2.node.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PortsByAngleAndName
    implements Comparator<NodeInfo.PortDetails> {
        private PortsByAngleAndName() {
        }

        @Override
        public int compare(NodeInfo.PortDetails s1, NodeInfo.PortDetails s2) {
            if (s1.angle != s2.angle) {
                return s1.angle - s2.angle;
            }
            return s1.name.compareTo(s2.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SamplesByLayerOrder
    implements Comparator<Sample> {
        private LayerInfo[] lList;

        SamplesByLayerOrder(LayerInfo[] lList) {
            this.lList = lList;
        }

        @Override
        public int compare(Sample s1, Sample s2) {
            int i1 = -1;
            if (s1.layer != null && s1.layer != Generic.tech.portNode) {
                String s1Name = s1.layer.getName().substring(6);
                for (int i = 0; i < this.lList.length; ++i) {
                    if (!this.lList[i].name.equals(s1Name)) continue;
                    i1 = i;
                    break;
                }
            }
            int i2 = -1;
            if (s2.layer != null && s2.layer != Generic.tech.portNode) {
                String s2Name = s2.layer.getName().substring(6);
                for (int i = 0; i < this.lList.length; ++i) {
                    if (!this.lList[i].name.equals(s2Name)) continue;
                    i2 = i;
                    break;
                }
            }
            return i1 - i2;
        }
    }

    private static class TechFromLibJob
    extends Job {
        private String newName;
        private String fileName;
        private TechConversionResult tcr;

        private TechFromLibJob(String newName, boolean alsoXML) {
            super("Make Technology from Technolog Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newName = newName;
            if (alsoXML) {
                this.fileName = OpenFile.chooseOutputFile(FileType.XML, "File for Technology's XML Code", newName + ".xml");
            }
            this.startJob();
        }

        public boolean doIt() {
            LibToTech ltt = new LibToTech();
            this.tcr = new TechConversionResult();
            ltt.makeTech(this.newName, this.fileName, this.tcr);
            this.fieldVariableChanged("tcr");
            return true;
        }

        public void terminateOK() {
            if (this.tcr.failed()) {
                this.tcr.showError();
                System.out.println("Failed to convert the library to a technology");
            }
        }
    }

    private static class GenerateTechnology
    extends EDialog {
        private JLabel lab2;
        private JLabel lab3;
        private JTextField renameName;
        private JTextField newName;
        private JCheckBox alsoXML;

        private GenerateTechnology() {
            super((Frame)null, true);
            this.initComponents();
            this.setVisible(true);
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                new TechFromLibJob(this.newName.getText(), this.alsoXML.isSelected());
            }
            this.dispose();
        }

        private void nameChanged() {
            String techName = this.newName.getText();
            if (Technology.findTechnology(techName) != null) {
                this.lab2.setEnabled(true);
                this.lab3.setEnabled(true);
                this.renameName.setEnabled(true);
                this.renameName.setEditable(true);
            } else {
                this.lab2.setEnabled(false);
                this.lab3.setEnabled(false);
                this.renameName.setEnabled(false);
                this.renameName.setEditable(false);
            }
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Convert Library to Technology");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    GenerateTechnology.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Creating new technology:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.newName = new JTextField(Library.getCurrent().getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.newName, gbc);
            this.newName.getDocument().addDocumentListener(new TechNameDocumentListener());
            this.lab2 = new JLabel("Already a technology with this name");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab2, gbc);
            this.lab3 = new JLabel("Rename existing technology to:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab3, gbc);
            this.renameName = new JTextField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.renameName, gbc);
            this.alsoXML = new JCheckBox("Also write XML code");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.alsoXML, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GenerateTechnology.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GenerateTechnology.this.exit(true);
                }
            });
            this.pack();
        }

        private class TechNameDocumentListener
        implements DocumentListener {
            private TechNameDocumentListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                GenerateTechnology.this.nameChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                GenerateTechnology.this.nameChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                GenerateTechnology.this.nameChanged();
            }
        }
    }
}

