/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EditKeyBindings;
import com.sun.electric.tool.user.dialogs.options.AntennaRulesTab;
import com.sun.electric.tool.user.dialogs.options.CDLTab;
import com.sun.electric.tool.user.dialogs.options.CIFTab;
import com.sun.electric.tool.user.dialogs.options.CVSTab;
import com.sun.electric.tool.user.dialogs.options.CellModelTab;
import com.sun.electric.tool.user.dialogs.options.CompactionTab;
import com.sun.electric.tool.user.dialogs.options.CoverageTab;
import com.sun.electric.tool.user.dialogs.options.DEFTab;
import com.sun.electric.tool.user.dialogs.options.DRCTab;
import com.sun.electric.tool.user.dialogs.options.DXFTab;
import com.sun.electric.tool.user.dialogs.options.DaisTab;
import com.sun.electric.tool.user.dialogs.options.DesignRulesTab;
import com.sun.electric.tool.user.dialogs.options.DisplayControlTab;
import com.sun.electric.tool.user.dialogs.options.EDIFTab;
import com.sun.electric.tool.user.dialogs.options.FastHenryTab;
import com.sun.electric.tool.user.dialogs.options.FrameTab;
import com.sun.electric.tool.user.dialogs.options.GDSTab;
import com.sun.electric.tool.user.dialogs.options.GeneralTab;
import com.sun.electric.tool.user.dialogs.options.GridAndAlignmentTab;
import com.sun.electric.tool.user.dialogs.options.IconTab;
import com.sun.electric.tool.user.dialogs.options.LayersTab;
import com.sun.electric.tool.user.dialogs.options.LibraryTab;
import com.sun.electric.tool.user.dialogs.options.NCCTab;
import com.sun.electric.tool.user.dialogs.options.NetworkTab;
import com.sun.electric.tool.user.dialogs.options.NewArcsTab;
import com.sun.electric.tool.user.dialogs.options.NewNodesTab;
import com.sun.electric.tool.user.dialogs.options.ParasiticTab;
import com.sun.electric.tool.user.dialogs.options.PortsAndExportsTab;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.dialogs.options.PrintingTab;
import com.sun.electric.tool.user.dialogs.options.ProjectManagementTab;
import com.sun.electric.tool.user.dialogs.options.RoutingTab;
import com.sun.electric.tool.user.dialogs.options.SUETab;
import com.sun.electric.tool.user.dialogs.options.SelectionTab;
import com.sun.electric.tool.user.dialogs.options.SiliconCompilerTab;
import com.sun.electric.tool.user.dialogs.options.SimulatorsTab;
import com.sun.electric.tool.user.dialogs.options.SkillTab;
import com.sun.electric.tool.user.dialogs.options.SmartTextTab;
import com.sun.electric.tool.user.dialogs.options.SpiceTab;
import com.sun.electric.tool.user.dialogs.options.SunRouterTab;
import com.sun.electric.tool.user.dialogs.options.TechnologyTab;
import com.sun.electric.tool.user.dialogs.options.TextTab;
import com.sun.electric.tool.user.dialogs.options.ThreeDTab;
import com.sun.electric.tool.user.dialogs.options.UnitsTab;
import com.sun.electric.tool.user.dialogs.options.WellCheckTab;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PreferencesFrame
extends EDialog {
    private JSplitPane splitPane;
    private JTree optionTree;
    JButton cancel;
    JButton ok;
    List<PreferencePanel> optionPanes = new ArrayList<PreferencePanel>();
    private static String currentTabName = "General";
    private static String currentSectionName = "General ";

    public static void preferencesCommand() {
        PreferencesFrame dialog = new PreferencesFrame((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public PreferencesFrame(Frame parent, boolean modal) {
        super(parent, modal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PreferencesFrame.this.closeDialog(evt);
            }
        });
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Preferences");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.optionTree = new JTree(treeModel);
        TreeHandler handler = new TreeHandler(this);
        this.optionTree.addMouseListener(handler);
        this.optionTree.addTreeExpansionListener(handler);
        DefaultMutableTreeNode generalSet = new DefaultMutableTreeNode("General ");
        rootNode.add(generalSet);
        GeneralTab gt = new GeneralTab(parent, modal);
        this.optionPanes.add(gt);
        generalSet.add(new DefaultMutableTreeNode(gt.getName()));
        SelectionTab st = new SelectionTab(parent, modal);
        this.optionPanes.add(st);
        generalSet.add(new DefaultMutableTreeNode(st.getName()));
        TopLevel top = TopLevel.getCurrentJFrame();
        if (top != null && top.getEMenuBar() != null) {
            EditKeyBindings keys = new EditKeyBindings(top.getEMenuBar(), parent, modal);
            this.optionPanes.add(keys);
            generalSet.add(new DefaultMutableTreeNode(keys.getName()));
        }
        NewNodesTab nnt = new NewNodesTab(parent, modal);
        this.optionPanes.add(nnt);
        generalSet.add(new DefaultMutableTreeNode(nnt.getName()));
        NewArcsTab nat = new NewArcsTab(parent, modal);
        this.optionPanes.add(nat);
        generalSet.add(new DefaultMutableTreeNode(nat.getName()));
        ProjectManagementTab pmt = new ProjectManagementTab(parent, modal);
        this.optionPanes.add(pmt);
        generalSet.add(new DefaultMutableTreeNode(pmt.getName()));
        CVSTab cvst = new CVSTab(parent, modal);
        this.optionPanes.add(cvst);
        generalSet.add(new DefaultMutableTreeNode(cvst.getName()));
        PrintingTab prt = new PrintingTab(parent, modal);
        this.optionPanes.add(prt);
        generalSet.add(new DefaultMutableTreeNode(prt.getName()));
        if (Job.getDebug()) {
            try {
                Class<?> testTab = Class.forName("com.sun.electric.plugins.tests.TestTab");
                Constructor<?> tab = testTab.getDeclaredConstructor(Frame.class, Boolean.class);
                PreferencePanel tesT = (PreferencePanel)tab.newInstance(parent, new Boolean(modal));
                this.optionPanes.add(tesT);
                generalSet.add(new DefaultMutableTreeNode(tesT.getName()));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        DefaultMutableTreeNode displaySet = new DefaultMutableTreeNode("Display ");
        rootNode.add(displaySet);
        DisplayControlTab dct = new DisplayControlTab(parent, modal);
        this.optionPanes.add(dct);
        displaySet.add(new DefaultMutableTreeNode(dct.getName()));
        LayersTab lt = new LayersTab(parent, modal);
        this.optionPanes.add(lt);
        displaySet.add(new DefaultMutableTreeNode(lt.getName()));
        TextTab txtt = new TextTab(parent, modal);
        this.optionPanes.add(txtt);
        displaySet.add(new DefaultMutableTreeNode(txtt.getName()));
        SmartTextTab stxtt = new SmartTextTab(parent, modal);
        this.optionPanes.add(stxtt);
        displaySet.add(new DefaultMutableTreeNode(stxtt.getName()));
        GridAndAlignmentTab gat = new GridAndAlignmentTab(parent, modal);
        this.optionPanes.add(gat);
        displaySet.add(new DefaultMutableTreeNode(gat.getName()));
        PortsAndExportsTab pet = new PortsAndExportsTab(parent, modal);
        this.optionPanes.add(pet);
        displaySet.add(new DefaultMutableTreeNode(pet.getName()));
        FrameTab ft = new FrameTab(parent, modal);
        this.optionPanes.add(ft);
        displaySet.add(new DefaultMutableTreeNode(ft.getName()));
        ThreeDTab tdt = ThreeDTab.create3DTab(parent, modal);
        this.optionPanes.add(tdt);
        displaySet.add(new DefaultMutableTreeNode(tdt.getName()));
        DefaultMutableTreeNode ioSet = new DefaultMutableTreeNode("I/O ");
        rootNode.add(ioSet);
        CIFTab cit = new CIFTab(parent, modal);
        this.optionPanes.add(cit);
        ioSet.add(new DefaultMutableTreeNode(cit.getName()));
        GDSTab gdt = new GDSTab(parent, modal);
        this.optionPanes.add(gdt);
        ioSet.add(new DefaultMutableTreeNode(gdt.getName()));
        EDIFTab edt = new EDIFTab(parent, modal);
        this.optionPanes.add(edt);
        ioSet.add(new DefaultMutableTreeNode(edt.getName()));
        DEFTab det = new DEFTab(parent, modal);
        this.optionPanes.add(det);
        ioSet.add(new DefaultMutableTreeNode(det.getName()));
        CDLTab cdt = new CDLTab(parent, modal);
        this.optionPanes.add(cdt);
        ioSet.add(new DefaultMutableTreeNode(cdt.getName()));
        DXFTab dxt = new DXFTab(parent, modal);
        this.optionPanes.add(dxt);
        ioSet.add(new DefaultMutableTreeNode(dxt.getName()));
        SUETab sut = new SUETab(parent, modal);
        this.optionPanes.add(sut);
        ioSet.add(new DefaultMutableTreeNode(sut.getName()));
        if (IOTool.hasDais()) {
            DaisTab dat = new DaisTab(parent, modal);
            this.optionPanes.add(dat);
            ioSet.add(new DefaultMutableTreeNode(dat.getName()));
        }
        if (IOTool.hasSkill()) {
            SkillTab skt = new SkillTab(parent, modal);
            this.optionPanes.add(skt);
            ioSet.add(new DefaultMutableTreeNode(skt.getName()));
        }
        LibraryTab lit = new LibraryTab(parent, modal);
        this.optionPanes.add(lit);
        ioSet.add(new DefaultMutableTreeNode(lit.getName()));
        DefaultMutableTreeNode toolSet = new DefaultMutableTreeNode("Tools ");
        rootNode.add(toolSet);
        AntennaRulesTab art = new AntennaRulesTab(parent, modal);
        this.optionPanes.add(art);
        toolSet.add(new DefaultMutableTreeNode(art.getName()));
        CompactionTab comt = new CompactionTab(parent, modal);
        this.optionPanes.add(comt);
        toolSet.add(new DefaultMutableTreeNode(comt.getName()));
        CoverageTab covt = new CoverageTab(parent, modal);
        this.optionPanes.add(covt);
        toolSet.add(new DefaultMutableTreeNode(covt.getName()));
        DRCTab drct = new DRCTab(parent, modal);
        this.optionPanes.add(drct);
        toolSet.add(new DefaultMutableTreeNode(drct.getName()));
        FastHenryTab fht = new FastHenryTab(parent, modal);
        this.optionPanes.add(fht);
        toolSet.add(new DefaultMutableTreeNode(fht.getName()));
        NCCTab nct = new NCCTab(parent, modal);
        this.optionPanes.add(nct);
        toolSet.add(new DefaultMutableTreeNode(nct.getName()));
        NetworkTab net = new NetworkTab(parent, modal);
        this.optionPanes.add(net);
        toolSet.add(new DefaultMutableTreeNode(net.getName()));
        ParasiticTab parat = new ParasiticTab(parent, modal);
        this.optionPanes.add(parat);
        toolSet.add(new DefaultMutableTreeNode(parat.getName()));
        RoutingTab rot = new RoutingTab(parent, modal);
        this.optionPanes.add(rot);
        toolSet.add(new DefaultMutableTreeNode(rot.getName()));
        SiliconCompilerTab sct = new SiliconCompilerTab(parent, modal);
        this.optionPanes.add(sct);
        toolSet.add(new DefaultMutableTreeNode(sct.getName()));
        SimulatorsTab smt = new SimulatorsTab(parent, modal);
        this.optionPanes.add(smt);
        toolSet.add(new DefaultMutableTreeNode(smt.getName()));
        SpiceTab spt = new SpiceTab(parent, modal);
        this.optionPanes.add(spt);
        toolSet.add(new DefaultMutableTreeNode(spt.getName()));
        CellModelTab spt2 = new CellModelTab(parent, modal, CellModelPrefs.spiceModelPrefs);
        this.optionPanes.add(spt2);
        toolSet.add(new DefaultMutableTreeNode(spt2.getName()));
        if (Routing.hasSunRouter()) {
            SunRouterTab srt = new SunRouterTab(parent, modal);
            this.optionPanes.add(srt);
            toolSet.add(new DefaultMutableTreeNode(srt.getName()));
        }
        CellModelTab vet = new CellModelTab(parent, modal, CellModelPrefs.verilogModelPrefs);
        this.optionPanes.add(vet);
        toolSet.add(new DefaultMutableTreeNode(vet.getName()));
        WellCheckTab wct = new WellCheckTab(parent, modal);
        this.optionPanes.add(wct);
        toolSet.add(new DefaultMutableTreeNode(wct.getName()));
        DefaultMutableTreeNode techSet = new DefaultMutableTreeNode("Technology ");
        rootNode.add(techSet);
        TechnologyTab tect = new TechnologyTab(parent, modal);
        this.optionPanes.add(tect);
        techSet.add(new DefaultMutableTreeNode(tect.getName()));
        DesignRulesTab drt = new DesignRulesTab(parent, modal);
        this.optionPanes.add(drt);
        techSet.add(new DefaultMutableTreeNode(drt.getName()));
        UnitsTab ut = new UnitsTab(parent, modal);
        this.optionPanes.add(ut);
        techSet.add(new DefaultMutableTreeNode(ut.getName()));
        IconTab ict = new IconTab(parent, modal);
        this.optionPanes.add(ict);
        techSet.add(new DefaultMutableTreeNode(ict.getName()));
        TreePath topPath = this.optionTree.getPathForRow(0);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getPathForRow(1);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getNextMatch(currentSectionName, 0, null);
        this.optionTree.expandPath(topPath);
        this.openSelectedPath(rootNode);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        JScrollPane scrolledTree = new JScrollPane(this.optionTree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        leftPanel.add((Component)scrolledTree, gbc);
        JButton save = new JButton("Export");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.exportActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)save, gbc);
        JButton restore = new JButton("Import");
        restore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.importActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)restore, gbc);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.helpActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)help, gbc);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.cancelActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.cancel, gbc);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.okActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.ok, gbc);
        this.getRootPane().setDefaultButton(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.splitPane = new JSplitPane(1);
        this.loadOptionPanel();
        this.splitPane.setLeftComponent(leftPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gbc);
        this.pack();
        this.finishInitialization();
    }

    private boolean openSelectedPath(DefaultMutableTreeNode rootNode) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            Object o = node.getUserObject();
            if (o.toString().equals(currentTabName)) {
                this.optionTree.scrollPathToVisible(new TreePath(node.getPath()));
                return true;
            }
            if (!this.openSelectedPath(node)) continue;
            return true;
        }
        return false;
    }

    private void cancelActionPerformed() {
        this.closeDialog(null);
    }

    private void okActionPerformed() {
        new OKUpdate(this);
    }

    private void helpActionPerformed() {
        ManualViewer.showPreferenceHelp(currentSectionName.trim() + "/" + currentTabName);
        this.closeDialog(null);
    }

    private void exportActionPerformed() {
        Job.getUserInterface().exportPrefs();
    }

    private void importActionPerformed() {
        Job.getUserInterface().importPrefs();
        TopLevel top = TopLevel.getCurrentJFrame();
        top.getEMenuBar().restoreSavedBindings(false);
        Technology.cacheTransparentLayerColors();
        this.closeDialog(null);
        EditWindow.repaintAllContents();
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.loadComponentMenuForTechnology();
        }
    }

    private void loadOptionPanel() {
        for (PreferencePanel ti : this.optionPanes) {
            if (!ti.getName().equals(currentTabName)) continue;
            if (!ti.isInited()) {
                ti.init();
                ti.setInited();
            }
            this.splitPane.setRightComponent(ti.getPanel());
            return;
        }
    }

    protected void escapePressed() {
        this.cancelActionPerformed();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TreeHandler
    implements MouseListener,
    TreeExpansionListener {
        private PreferencesFrame dialog;

        TreeHandler(PreferencesFrame dialog) {
            this.dialog = dialog;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TreePath currentPath = this.dialog.optionTree.getPathForLocation(e.getX(), e.getY());
            if (currentPath == null) {
                return;
            }
            this.dialog.optionTree.setSelectionPath(currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            currentTabName = (String)node.getUserObject();
            this.dialog.optionTree.expandPath(currentPath);
            if (currentTabName.endsWith(" ")) {
                currentSectionName = currentTabName;
            } else {
                this.dialog.loadOptionPanel();
            }
            this.dialog.pack();
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            this.dialog.pack();
        }

        public void treeExpanded(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            if (tp.getPathCount() == 2) {
                TreePath topPath = this.dialog.optionTree.getPathForRow(0);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)topPath.getLastPathComponent();
                int numChildren = node.getChildCount();
                for (int i = 0; i < numChildren; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    TreePath descentPath = topPath.pathByAddingChild(child);
                    if (descentPath.getLastPathComponent().equals(tp.getLastPathComponent())) {
                        DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)descentPath.getLastPathComponent();
                        currentSectionName = (String)subNode.getUserObject();
                        continue;
                    }
                    this.dialog.optionTree.collapsePath(descentPath);
                }
            }
            this.dialog.pack();
        }
    }

    private static class OKUpdate
    extends Job {
        private transient PreferencesFrame dialog;
        private Pref.PrefChangeBatch changeBatch;

        private OKUpdate(PreferencesFrame dialog) {
            super("Update Preferences", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            Pref.gatherPrefChanges();
            for (PreferencePanel ti : dialog.optionPanes) {
                if (!ti.isInited()) continue;
                ti.term();
            }
            this.changeBatch = Pref.getPrefChanges();
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Pref.implementPrefChanges(this.changeBatch);
            return true;
        }

        public void terminateOK() {
            this.dialog.closeDialog(null);
        }
    }
}

