/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FastHenryTab
extends PreferencePanel {
    private JPanel fastHenry;
    private JTextField fhDefaultHeightSubs;
    private JTextField fhDefaultThickness;
    private JTextField fhDefaultWidthSubs;
    private JLabel fhFreqEndLabel;
    private JTextField fhFrequencyEnd;
    private JTextField fhFrequencyStart;
    private JCheckBox fhMakeMultipole;
    private JTextField fhMaxSegmentLength;
    private JLabel fhNumPolesLabel;
    private JTextField fhNumberOfPoles;
    private JTextField fhRunsPerDecade;
    private JLabel fhRunsPerDecadeLabel;
    private JCheckBox fhUseSingleFrequency;
    private JLabel jLabel55;
    private JLabel jLabel59;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;

    public FastHenryTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.fastHenry;
    }

    public String getName() {
        return "Fast Henry";
    }

    public void init() {
        this.fhUseSingleFrequency.setSelected(Simulation.isFastHenryUseSingleFrequency());
        this.fhUseSingleFrequency.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryTab.this.updateWhatIsEnabled();
            }
        });
        this.fhFrequencyStart.setText(TextUtils.formatDouble(Simulation.getFastHenryStartFrequency()));
        this.fhFrequencyEnd.setText(TextUtils.formatDouble(Simulation.getFastHenryEndFrequency()));
        this.fhRunsPerDecade.setText(Integer.toString(Simulation.getFastHenryRunsPerDecade()));
        this.fhMakeMultipole.setSelected(Simulation.isFastHenryMultiPole());
        this.fhMakeMultipole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryTab.this.updateWhatIsEnabled();
            }
        });
        this.fhNumberOfPoles.setText(Integer.toString(Simulation.getFastHenryNumPoles()));
        this.fhDefaultThickness.setText(TextUtils.formatDouble(Simulation.getFastHenryDefThickness()));
        this.fhDefaultWidthSubs.setText(Integer.toString(Simulation.getFastHenryWidthSubdivisions()));
        this.fhDefaultHeightSubs.setText(Integer.toString(Simulation.getFastHenryHeightSubdivisions()));
        this.fhMaxSegmentLength.setText(TextUtils.formatDouble(Simulation.getFastHenryMaxSegLength()));
        this.updateWhatIsEnabled();
    }

    private void updateWhatIsEnabled() {
        this.fhFrequencyEnd.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhFreqEndLabel.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhRunsPerDecade.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhRunsPerDecadeLabel.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhNumberOfPoles.setEnabled(this.fhMakeMultipole.isSelected());
        this.fhNumPolesLabel.setEnabled(this.fhMakeMultipole.isSelected());
    }

    public void term() {
        int currInt;
        double currDouble;
        boolean currBoolean = this.fhUseSingleFrequency.isSelected();
        if (currBoolean != Simulation.isFastHenryUseSingleFrequency()) {
            Simulation.setFastHenryUseSingleFrequency(currBoolean);
        }
        if ((currDouble = TextUtils.atof(this.fhFrequencyStart.getText())) != Simulation.getFastHenryStartFrequency()) {
            Simulation.setFastHenryStartFrequency(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.fhFrequencyEnd.getText())) != Simulation.getFastHenryEndFrequency()) {
            Simulation.setFastHenryEndFrequency(currDouble);
        }
        if ((currInt = TextUtils.atoi(this.fhRunsPerDecade.getText())) != Simulation.getFastHenryRunsPerDecade()) {
            Simulation.setFastHenryRunsPerDecade(currInt);
        }
        if ((currBoolean = this.fhMakeMultipole.isSelected()) != Simulation.isFastHenryMultiPole()) {
            Simulation.setFastHenryMultiPole(currBoolean);
        }
        if ((currInt = TextUtils.atoi(this.fhNumberOfPoles.getText())) != Simulation.getFastHenryNumPoles()) {
            Simulation.setFastHenryNumPoles(currInt);
        }
        if ((currDouble = TextUtils.atof(this.fhDefaultThickness.getText())) != Simulation.getFastHenryDefThickness()) {
            Simulation.setFastHenryDefThickness(currDouble);
        }
        if ((currInt = TextUtils.atoi(this.fhDefaultWidthSubs.getText())) != Simulation.getFastHenryWidthSubdivisions()) {
            Simulation.setFastHenryWidthSubdivisions(currInt);
        }
        if ((currInt = TextUtils.atoi(this.fhDefaultHeightSubs.getText())) != Simulation.getFastHenryHeightSubdivisions()) {
            Simulation.setFastHenryHeightSubdivisions(currInt);
        }
        if ((currDouble = TextUtils.atof(this.fhMaxSegmentLength.getText())) != Simulation.getFastHenryMaxSegLength()) {
            Simulation.setFastHenryMaxSegLength(currDouble);
        }
    }

    private void initComponents() {
        this.fastHenry = new JPanel();
        this.fhUseSingleFrequency = new JCheckBox();
        this.jLabel55 = new JLabel();
        this.fhFreqEndLabel = new JLabel();
        this.fhRunsPerDecadeLabel = new JLabel();
        this.fhMakeMultipole = new JCheckBox();
        this.fhNumPolesLabel = new JLabel();
        this.fhFrequencyStart = new JTextField();
        this.fhFrequencyEnd = new JTextField();
        this.fhRunsPerDecade = new JTextField();
        this.fhNumberOfPoles = new JTextField();
        this.jLabel59 = new JLabel();
        this.jLabel60 = new JLabel();
        this.jLabel61 = new JLabel();
        this.jLabel62 = new JLabel();
        this.fhDefaultThickness = new JTextField();
        this.fhDefaultWidthSubs = new JTextField();
        this.fhDefaultHeightSubs = new JTextField();
        this.fhMaxSegmentLength = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FastHenryTab.this.closeDialog(evt);
            }
        });
        this.fastHenry.setLayout(new GridBagLayout());
        this.fhUseSingleFrequency.setText("Use single frequency");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhUseSingleFrequency, gridBagConstraints);
        this.jLabel55.setText("Frequency start:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.jLabel55, gridBagConstraints);
        this.fhFreqEndLabel.setText("Frequency end:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.fhFreqEndLabel, gridBagConstraints);
        this.fhRunsPerDecadeLabel.setText("Runs per decade:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.fhRunsPerDecadeLabel, gridBagConstraints);
        this.fhMakeMultipole.setText("Make multipole subcircuit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhMakeMultipole, gridBagConstraints);
        this.fhNumPolesLabel.setText("Number of poles:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.fhNumPolesLabel, gridBagConstraints);
        this.fhFrequencyStart.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhFrequencyStart, gridBagConstraints);
        this.fhFrequencyEnd.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhFrequencyEnd, gridBagConstraints);
        this.fhRunsPerDecade.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhRunsPerDecade, gridBagConstraints);
        this.fhNumberOfPoles.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhNumberOfPoles, gridBagConstraints);
        this.jLabel59.setText("Default thickness:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel59, gridBagConstraints);
        this.jLabel60.setText("Default width subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel60, gridBagConstraints);
        this.jLabel61.setText("Default height subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel61, gridBagConstraints);
        this.jLabel62.setText("Maximum segment length:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel62, gridBagConstraints);
        this.fhDefaultThickness.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhDefaultThickness, gridBagConstraints);
        this.fhDefaultWidthSubs.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhDefaultWidthSubs, gridBagConstraints);
        this.fhDefaultHeightSubs.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhDefaultHeightSubs, gridBagConstraints);
        this.fhMaxSegmentLength.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhMaxSegmentLength, gridBagConstraints);
        this.getContentPane().add((Component)this.fastHenry, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

