/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LENetwork;
import com.sun.electric.tool.logicaleffort.LEPin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LENodable {
    private List pins;
    private Nodable no;
    private Type type;
    private Network outputNet;
    private Variable mfactorVar;
    private Variable suVar;
    private Variable parallelGroupVar;
    protected VarContext context;
    protected LENetwork outputNetwork;
    protected float mfactor;
    protected float su;
    protected float leX;
    protected int parallelGroup;

    public LENodable(Nodable no, Type type, Variable mfactorVar, Variable suVar, Variable parallelGroupVar) {
        this.no = no;
        this.type = type;
        this.pins = new ArrayList();
        this.outputNet = null;
        this.mfactorVar = mfactorVar;
        this.suVar = suVar;
        this.parallelGroupVar = parallelGroupVar;
        this.context = VarContext.globalContext;
    }

    protected LENodable copy() {
        LENodable copy = new LENodable(this.no, this.type, this.mfactorVar, this.suVar, this.parallelGroupVar);
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            LEPin pin = (LEPin)it.next();
            copy.addPort(pin.getName(), pin.getDir(), pin.getLE(), pin.getNetwork());
        }
        return copy;
    }

    protected void addPort(String name, LEPin.Dir dir, float le, Network jnet) {
        LEPin pin = new LEPin(name, dir, le, jnet, this);
        this.pins.add(pin);
    }

    protected void setOutputNet(Network jnet) {
        this.outputNet = jnet;
    }

    protected Network getOutputNet() {
        return this.outputNet;
    }

    protected Nodable getNodable() {
        return this.no;
    }

    protected Type getType() {
        return this.type;
    }

    protected List getPins() {
        return this.pins;
    }

    protected boolean isLeGate() {
        return this.type == Type.LEKEEPER || this.type == Type.LEGATE;
    }

    protected boolean isGate() {
        return this.type == Type.LEGATE || this.type == Type.LEKEEPER || this.type == Type.STATICGATE;
    }

    protected boolean setOnlyContext(VarContext context, LENetwork outputNetwork, float mfactor, float su, LENetlister.NetlisterConstants constants) {
        boolean evalOk = this.instantiate(this, context, outputNetwork, mfactor, su, constants, true);
        return evalOk;
    }

    protected LENodable createUniqueInstance(VarContext context, LENetwork outputNetwork, float mfactor, float su, LENetlister.NetlisterConstants constants) {
        LENodable instance = new LENodable(this.no, this.type, this.mfactorVar, this.suVar, this.parallelGroupVar);
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            LEPin pin = (LEPin)it.next();
            instance.addPort(pin.getName(), pin.getDir(), pin.getLE(), pin.getNetwork());
        }
        this.instantiate(instance, context, outputNetwork, mfactor, su, constants, false);
        return instance;
    }

    private boolean instantiate(LENodable instance, VarContext context, LENetwork outputNetwork, float mfactor, float su, LENetlister.NetlisterConstants constants, boolean testCachebility) {
        Object retVal;
        instance.outputNetwork = outputNetwork;
        boolean evalOk = true;
        instance.context = context;
        instance.leX = this.getLeX(context, constants, testCachebility);
        if (instance.leX == -1.0f) {
            evalOk = false;
        }
        instance.mfactor = mfactor;
        instance.su = su;
        instance.parallelGroup = 0;
        if (this.parallelGroupVar != null) {
            retVal = context.evalVar(this.parallelGroupVar);
            if (retVal == null) {
                evalOk = false;
            } else {
                instance.parallelGroup = VarContext.objectToInt(retVal, instance.parallelGroup);
            }
        }
        if (this.suVar != null) {
            retVal = context.evalVar(this.suVar);
            if (retVal == null) {
                evalOk = false;
            } else {
                float localsu = VarContext.objectToFloat(retVal, -1.0f);
                float f = instance.su = localsu == -1.0f ? instance.su : localsu;
            }
        }
        if (this.mfactorVar != null) {
            retVal = context.evalVar(this.mfactorVar);
            if (retVal == null) {
                evalOk = false;
            } else {
                instance.mfactor *= VarContext.objectToFloat(retVal, 1.0f);
            }
        }
        return evalOk;
    }

    private float getLeX(VarContext context, LENetlister.NetlisterConstants constants, boolean testCachebility) {
        float leX = 0.0f;
        Variable var = null;
        Object retVal = null;
        if (this.type == Type.WIRE) {
            var = this.no.getVar("ATTR_LEWIRECAP");
            float cap = 0.0f;
            if (var != null) {
                retVal = context.evalVar(var);
                if (testCachebility && retVal == null) {
                    return -1.0f;
                }
                cap = VarContext.objectToFloat(retVal, 0.0f);
            } else {
                var = this.no.getVar("ATTR_L");
                if (var == null) {
                    System.out.println("Error, no L attribute found on LEWIRE " + this.no.getName() + " in Cell " + this.no.getParent());
                    if (testCachebility) {
                        return -1.0f;
                    }
                }
                retVal = context.evalVar(var);
                if (testCachebility && retVal == null) {
                    return -1.0f;
                }
                float len = VarContext.objectToFloat(retVal, 0.0f);
                var = this.no.getVar(Schematics.ATTR_WIDTH);
                if (var == null) {
                    System.out.println("Warning, no width attribute found on LEWIRE " + this.no.getName() + " in Cell " + this.no.getParent());
                    if (testCachebility) {
                        return -1.0f;
                    }
                }
                retVal = context.evalVar(var);
                if (testCachebility && retVal == null) {
                    return -1.0f;
                }
                float width = VarContext.objectToFloat(retVal, 3.0f);
                cap = 0.95f * len + 0.05f * len * (width / 3.0f);
            }
            leX = cap * constants.wireRatio;
            leX /= 9.0f;
        } else if (this.type == Type.TRANSISTOR) {
            var = this.no.getVar(Schematics.ATTR_WIDTH);
            if (var == null) {
                System.out.println("Error: transistor " + this.no.getName() + " has no width in Cell " + this.no.getParent());
                return -1.0f;
            }
            retVal = context.evalVar(var);
            if (retVal == null) {
                return -1.0f;
            }
            float width = VarContext.objectToFloat(retVal, 3.0f);
            leX = width / 9.0f;
        } else if (this.type == Type.CAPACITOR) {
            var = this.no.getVar(Schematics.SCHEM_CAPACITANCE);
            if (var == null) {
                System.out.println("Error: capacitor " + this.no.getName() + " has no capacitance in Cell " + this.no.getParent());
                return -1.0f;
            }
            retVal = context.evalVar(var);
            if (testCachebility && retVal == null) {
                return -1.0f;
            }
            float cap = VarContext.objectToFloat(retVal, 0.0f);
            leX = (float)((double)(cap / constants.gateCap) / 1.0E-15 / 9.0);
        }
        return leX;
    }

    protected String getName() {
        if (this.context == null) {
            return this.no.getName();
        }
        return this.context.push(this.getNodable()).getInstPath(".");
    }

    protected void print() {
        System.out.println(this.getType().toString() + ": " + this.getName());
        System.out.println("    Size    \t= " + this.leX);
        System.out.println("    Step-up \t= " + this.su);
        System.out.println("    Parallel Group\t= " + this.parallelGroup);
        System.out.println("    M Factor\t= " + this.mfactor);
    }

    protected String printOneLine(String indent) {
        StringBuffer buf = new StringBuffer(indent);
        buf.append(this.getType().toString());
        buf.append(": Size=" + TextUtils.formatDouble(this.leX, 2));
        buf.append(" M=" + TextUtils.formatDouble(this.mfactor, 2));
        buf.append(" tPG=" + this.parallelGroup);
        buf.append(" " + this.getName());
        return buf.toString();
    }

    protected void printPins() {
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            LEPin pin = (LEPin)it.next();
            System.out.println("Pin " + pin.getName() + ", le=" + pin.getLE() + ", dir=" + pin.getDir() + " on network " + pin.getNetwork());
        }
    }

    protected float printLoadInfo(LEPin pin, float alpha) {
        float load;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getType().toString());
        buf.append("\tSize=" + TextUtils.formatDouble(this.leX, 2));
        buf.append("\tLE=" + TextUtils.formatDouble(pin.getLE(), 2));
        buf.append("\tM=" + TextUtils.formatDouble(this.mfactor, 2));
        if (pin.getDir() == LEPin.Dir.OUTPUT) {
            load = this.leX * pin.getLE() * this.mfactor * alpha;
            buf.append("\tAlpha=" + alpha);
            buf.append("\tLoad=" + TextUtils.formatDouble(load, 2));
        } else {
            load = this.leX * pin.getLE() * this.mfactor;
            buf.append("\tLoad=" + TextUtils.formatDouble(load, 2));
        }
        buf.append("\t" + this.getName());
        System.out.println(buf.toString());
        return load;
    }

    protected static class Type {
        private final String name;
        protected static final Type STATICGATE = new Type("Static Gate");
        protected static final Type LOAD = new Type("Load");
        protected static final Type WIRE = new Type("Wire");
        protected static final Type LEGATE = new Type("LE Gate");
        protected static final Type LEKEEPER = new Type("LE Keeper");
        protected static final Type TRANSISTOR = new Type("Transistor");
        protected static final Type CAPACITOR = new Type("Capacitor");
        protected static final Type CACHEDCELL = new Type("Cached Cell");
        protected static final Type IGNORE = new Type("LE Ingore");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

