/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.tool.user.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

public abstract class TextDescriptor
implements Serializable {
    static final long VTPOSITION = 15L;
    static final int VTPOSITIONSH = 0;
    static final int VTPOSCENT = 0;
    static final int VTPOSUP = 1;
    static final int VTPOSDOWN = 2;
    static final int VTPOSLEFT = 3;
    static final int VTPOSRIGHT = 4;
    static final int VTPOSUPLEFT = 5;
    static final int VTPOSUPRIGHT = 6;
    static final int VTPOSDOWNLEFT = 7;
    static final int VTPOSDOWNRIGHT = 8;
    static final int VTPOSBOXED = 9;
    static final long VTDISPLAYPART = 48L;
    static final int VTDISPLAYPARTSH = 4;
    static final int VTDISPLAYVALUE = 0;
    static final int VTDISPLAYNAMEVALUE = 2;
    static final int VTDISPLAYNAMEVALINH = 1;
    static final int VTDISPLAYNAMEVALINHALL = 3;
    static final long VTITALIC = 64L;
    static final long VTBOLD = 128L;
    static final long VTUNDERLINE = 256L;
    static final long VTISPARAMETER = 512L;
    static final long VTINTERIOR = 1024L;
    static final long VTINHERIT = 2048L;
    static final long VTXOFF = 0x1FF000L;
    static final int VTXOFFSH = 12;
    static final long VTXOFFNEG = 0x200000L;
    static final long VTYOFF = 2143289344L;
    static final int VTYOFFSH = 22;
    static final long VTYOFFNEG = 0x80000000L;
    static final int VTOFFMASKWID = 9;
    static final long VTSIZE = 0x7FFF00000000L;
    static final int VTSIZESH = 32;
    static final long VTFACE = 17873661021126656L;
    static final int VTFACESH = 47;
    static final int VTMAXFACE = 127;
    static final long VTROTATION = 0xC0000000000000L;
    static final int VTROTATIONSH = 54;
    static final long VTOFFSCALE = 0x1F00000000000000L;
    static final int VTOFFSCALESH = 56;
    static final long VTUNITS = -2305843009213693952L;
    static final int VTUNITSHMASK = 7;
    static final int VTUNITSSH = 61;
    static final int VTUNITSNONE = 0;
    static final int VTUNITSRES = 1;
    static final int VTUNITSCAP = 2;
    static final int VTUNITSIND = 3;
    static final int VTUNITSCUR = 4;
    static final int VTUNITSVOLT = 5;
    static final int VTUNITSDIST = 6;
    static final int VTUNITSTIME = 7;
    static final int VTOFFMAX = 511;
    static long VTSEMANTIC = -2305843009213690368L;
    private static final int VCODE1 = 32;
    static final int VDISPLAY = 64;
    private static final int VCODE2 = 0x20000000;
    private static final int VLISP = 32;
    private static final int VTCL = 0x20000000;
    private static final int VJAVA = 0x20000020;
    private static final Preferences prefs = Preferences.userNodeForPackage(TextDescriptor.class);
    static final DescriptorPref cacheNodeDescriptor = new DescriptorPref("Node", 4);
    static final DescriptorPref cacheArcDescriptor = new DescriptorPref("Arc", 4);
    static final DescriptorPref cacheExportDescriptor = new DescriptorPref("Export", 8);
    static final DescriptorPref cacheAnnotationDescriptor = new DescriptorPref("Annotation", 4);
    static final DescriptorPref cacheInstanceDescriptor = new DescriptorPref("Instance", 16);
    static final DescriptorPref cacheCellDescriptor = new DescriptorPref("Cell", 4);

    TextDescriptor() {
    }

    public static void setNodeTextDescriptor(TextDescriptor td) {
        cacheNodeDescriptor.setTextDescriptor(td);
    }

    public static void setArcTextDescriptor(TextDescriptor td) {
        cacheArcDescriptor.setTextDescriptor(td);
    }

    public static void setExportTextDescriptor(TextDescriptor td) {
        cacheExportDescriptor.setTextDescriptor(td);
    }

    public static void setAnnotationTextDescriptor(TextDescriptor td) {
        cacheAnnotationDescriptor.setTextDescriptor(td);
    }

    public static void setInstanceTextDescriptor(TextDescriptor td) {
        cacheInstanceDescriptor.setTextDescriptor(td);
    }

    public static void setCellTextDescriptor(TextDescriptor td) {
        cacheCellDescriptor.setTextDescriptor(td);
    }

    public int hashCode() {
        int hash = this.lowLevelGet0() ^ this.lowLevelGet1() ^ this.getColorIndex() ^ this.getCode().hashCode();
        if (this.isDisplay()) {
            hash ^= 0x75BCD15;
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof TextDescriptor) {
            boolean display;
            Code code;
            int ci;
            long bits;
            Object object = anObject;
            synchronized (object) {
                TextDescriptor td = (TextDescriptor)anObject;
                bits = td.lowLevelGet();
                ci = td.getColorIndex();
                code = td.getCode();
                display = this.isDisplay();
            }
            object = this;
            synchronized (object) {
                return this.lowLevelGet() == bits && this.getColorIndex() == ci && this.getCode() == code && this.isDisplay() == display;
            }
        }
        return false;
    }

    public abstract long lowLevelGet();

    public int lowLevelGet0() {
        return (int)this.lowLevelGet();
    }

    public int lowLevelGet1() {
        return (int)(this.lowLevelGet() >> 32);
    }

    private int getField(long mask, int shift) {
        return (int)((this.lowLevelGet() & mask) >> shift);
    }

    private boolean isFlag(long mask) {
        return (this.lowLevelGet() & mask) != 0L;
    }

    public abstract boolean isDisplay();

    public Position getPos() {
        int pos = this.getField(15L, 0);
        if (pos >= Position.getNumPositions()) {
            pos = 0;
        }
        return Position.getPositionAt(pos);
    }

    public synchronized Size getSize() {
        int textSize = this.getField(0x7FFF00000000L, 32);
        if (textSize == 0) {
            return Size.newRelSize(1.0);
        }
        if (textSize <= 63) {
            return Size.newAbsSize(textSize);
        }
        int sizeValue = textSize >> 6;
        double size = (double)sizeValue / 4.0;
        return Size.newRelSize(size);
    }

    public double getTrueSize(EditWindow_ wnd) {
        double scale = 14.0;
        Size s = this.getSize();
        if (s != null) {
            if (s.isAbsolute()) {
                scale = s.getSize();
            } else if (wnd != null) {
                double height = s.getSize();
                scale = wnd.getTextScreenSize(height);
            }
        }
        return scale *= User.getGlobalTextScale();
    }

    public int getFace() {
        return this.getField(17873661021126656L, 47);
    }

    public Rotation getRotation() {
        return Rotation.getRotationAt(this.getField(0xC0000000000000L, 54));
    }

    public DispPos getDispPart() {
        return DispPos.getShowStylesAt(this.getField(48L, 4));
    }

    public boolean isItalic() {
        return this.isFlag(64L);
    }

    public boolean isBold() {
        return this.isFlag(128L);
    }

    public boolean isUnderline() {
        return this.isFlag(256L);
    }

    public boolean isInterior() {
        return this.isFlag(1024L);
    }

    public boolean isInherit() {
        return this.isFlag(2048L);
    }

    public boolean isParam() {
        return this.isFlag(512L);
    }

    public synchronized double getXOff() {
        int offset = this.getField(0x1FF000L, 12);
        if (this.isFlag(0x200000L)) {
            offset = -offset;
        }
        int scale = this.getOffScale() + 1;
        return (double)offset * (double)scale / 4.0;
    }

    public synchronized double getYOff() {
        int offset = this.getField(2143289344L, 22);
        if (this.isFlag(0x80000000L)) {
            offset = -offset;
        }
        int scale = this.getOffScale() + 1;
        return (double)offset * (double)scale / 4.0;
    }

    private int getOffScale() {
        return this.getField(0x1F00000000000000L, 56);
    }

    public Unit getUnit() {
        return Unit.getUnitAt(this.getField(-2305843009213693952L, 61) & 7);
    }

    public abstract int getColorIndex();

    public abstract Code getCode();

    public boolean isJava() {
        return this.getCode() == Code.JAVA;
    }

    public boolean isCode() {
        return this.getCode() != Code.NONE;
    }

    public int getCFlags() {
        int flags = this.getCode().getCFlags();
        if (this.isDisplay()) {
            flags |= 0x40;
        }
        return flags;
    }

    static class DescriptorPref {
        final Pref cacheBits;
        final Pref cacheColor;
        final Pref cacheFont;
        long oldBits;
        int oldColor;
        String oldFontName;
        ImmutableTextDescriptor tdF;
        ImmutableTextDescriptor tdT;

        DescriptorPref(String purpose, int initialSize) {
            this.cacheBits = Pref.makeLongPref("TextDescriptorFor" + purpose, prefs, this.swap((long)initialSize << 6 << 32));
            this.cacheColor = Pref.makeIntPref("TextDescriptorColorFor" + purpose, prefs, 0);
            this.cacheFont = Pref.makeStringPref("TextDescriptorFontFor" + purpose, prefs, "");
        }

        private long swap(long value) {
            int v0 = (int)value;
            return value >>> 32 | (long)v0 << 32;
        }

        synchronized ImmutableTextDescriptor newTextDescriptor(boolean display) {
            ActiveFont af;
            long bits = this.swap(this.cacheBits.getLong());
            int color = this.cacheColor.getInt();
            String fontName = this.cacheFont.getString();
            if (this.oldFontName != null && bits == this.oldBits && color == this.oldColor && fontName.equals(this.oldFontName)) {
                return display ? this.tdT : this.tdF;
            }
            this.oldBits = bits;
            this.oldColor = color;
            this.oldFontName = fontName;
            int face = 0;
            if (fontName.length() > 0 && (af = ActiveFont.findActiveFont(fontName)) != null) {
                face = af.getIndex();
            }
            bits = bits & 0xFFC07FFFFFFFFFFFL | (long)(face << 47);
            this.tdF = ImmutableTextDescriptor.newImmutableTextDescriptor(new MutableTextDescriptor(bits, color, false, Code.NONE));
            this.tdT = ImmutableTextDescriptor.newImmutableTextDescriptor(new MutableTextDescriptor(bits, color, true, Code.NONE));
            return display ? this.tdT : this.tdF;
        }

        MutableTextDescriptor newMutableTextDescriptor() {
            return new MutableTextDescriptor(this.newTextDescriptor(true));
        }

        synchronized void setTextDescriptor(TextDescriptor td) {
            MutableTextDescriptor mtd = new MutableTextDescriptor(td);
            mtd.setFace(0);
            this.cacheBits.setLong(this.swap(mtd.lowLevelGet()));
            this.cacheColor.setInt(mtd.getColorIndex());
            ActiveFont af = ActiveFont.findActiveFont(td.getFace());
            this.cacheFont.setString(af != null ? af.getName() : "");
        }
    }

    public static class Code {
        private final String name;
        private final int cFlags;
        private static final ArrayList allCodes = new ArrayList();
        public static final Code JAVA = new Code("Java", 0x20000020);
        public static final Code LISP = new Code("Lisp (not avail.)", 32);
        public static final Code TCL = new Code("TCL (not avail.)", 0x20000000);
        public static final Code NONE = new Code("Not Code", 0);

        private Code(String name, int cFlags) {
            this.name = name;
            this.cFlags = cFlags;
            allCodes.add(this);
        }

        public int getCFlags() {
            return this.cFlags;
        }

        public String toString() {
            return this.name;
        }

        public static Iterator getCodes() {
            return Collections.unmodifiableList(allCodes).iterator();
        }

        public static Code getByCBits(int cBits) {
            switch (cBits & 0x20000020) {
                case 0x20000020: {
                    return JAVA;
                }
                case 32: {
                    return LISP;
                }
                case 0x20000000: {
                    return TCL;
                }
            }
            return NONE;
        }
    }

    public static class ActiveFont {
        private String fontName;
        private int index = ++indexCount;
        private static int indexCount = 0;
        private static final HashMap fontMap = new HashMap();
        private static final List fontList = new ArrayList();

        private ActiveFont(String fontName) {
            this.fontName = fontName;
            fontMap.put(fontName, this);
            fontList.add(this);
        }

        public static int getMaxIndex() {
            return indexCount;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.fontName;
        }

        public static ActiveFont findActiveFont(String fontName) {
            ActiveFont af = (ActiveFont)fontMap.get(fontName);
            if (af != null) {
                return af;
            }
            if (indexCount >= 127) {
                System.out.println("Too many fonts. Using default instead of " + fontName);
                return null;
            }
            return new ActiveFont(fontName);
        }

        public static ActiveFont findActiveFont(int index) {
            if (index <= 0) {
                return null;
            }
            if (index > fontList.size()) {
                return null;
            }
            ActiveFont af = (ActiveFont)fontList.get(index - 1);
            return af;
        }

        public String toString() {
            return this.fontName;
        }
    }

    public static class Unit {
        private final String name;
        private final int index;
        private static final List units = new ArrayList();
        public static final Unit NONE = new Unit("none", 0);
        public static final Unit RESISTANCE = new Unit("resistance", 1);
        public static final Unit CAPACITANCE = new Unit("capacitance", 2);
        public static final Unit INDUCTANCE = new Unit("inductance", 3);
        public static final Unit CURRENT = new Unit("current", 4);
        public static final Unit VOLTAGE = new Unit("voltage", 5);
        public static final Unit DISTANCE = new Unit("distance", 6);
        public static final Unit TIME = new Unit("time", 7);

        private Unit(String name, int index) {
            this.name = name;
            this.index = index;
            units.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.name;
        }

        public static int getNumUnits() {
            return units.size();
        }

        public static Unit getUnitAt(int index) {
            return (Unit)units.get(index);
        }

        public static Iterator getUnits() {
            return Collections.unmodifiableList(units).iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Rotation {
        private final int angle;
        private final int index;
        private final String name;
        private static final List rotations = new ArrayList();
        public static final Rotation ROT0 = new Rotation(0, 0, "None");
        public static final Rotation ROT90 = new Rotation(90, 1, "90 degrees counterclockwise");
        public static final Rotation ROT180 = new Rotation(180, 2, "180 degrees");
        public static final Rotation ROT270 = new Rotation(270, 3, "90 degrees clockwise");

        private Rotation(int angle, int index, String name) {
            this.angle = angle;
            this.index = index;
            this.name = name;
            rotations.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.name;
        }

        public int getAngle() {
            return this.angle;
        }

        public static Rotation getRotation(int angle) {
            Iterator it = rotations.iterator();
            while (it.hasNext()) {
                Rotation rot = (Rotation)it.next();
                if (rot.getAngle() != angle) continue;
                return rot;
            }
            return null;
        }

        public static int getNumRotations() {
            return rotations.size();
        }

        public static Rotation getRotationAt(int index) {
            return (Rotation)rotations.get(index);
        }

        public static Iterator getRotations() {
            return Collections.unmodifiableList(rotations).iterator();
        }

        public String toString() {
            return "Text Rotation " + this.angle;
        }
    }

    public static class Size {
        public static final int TXTMAXPOINTS = 63;
        public static final double TXTMAXQGRID = 127.75;
        static final int TXTQGRIDSH = 6;
        private final boolean absolute;
        private final double size;
        private final int bits;

        private Size(double size, boolean absolute) {
            this.size = size;
            this.absolute = absolute;
            this.bits = absolute ? (int)size : (int)(size * 4.0) << 6;
        }

        int getBits() {
            return this.bits;
        }

        public static Size newAbsSize(int size) {
            if (size <= 0 || size > 63) {
                return null;
            }
            return new Size(size, true);
        }

        public static Size newRelSize(double size) {
            if (size <= 0.0 || size > 127.75) {
                return null;
            }
            return new Size(size, false);
        }

        public double getSize() {
            return this.size;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public boolean equals(Size other) {
            if (this.absolute != other.absolute) {
                return false;
            }
            return DBMath.doublesEqual(this.size, other.size);
        }

        public String toString() {
            return "Text Size";
        }
    }

    public static class DispPos {
        private final String name;
        private final int index;
        private static final List positions = new ArrayList();
        public static final DispPos VALUE = new DispPos("value", 0);
        public static final DispPos NAMEVALUE = new DispPos("name=value", 2);

        private DispPos(String name, int index) {
            this.name = name;
            this.index = index;
            positions.add(this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static int getNumShowStyles() {
            return positions.size();
        }

        public static DispPos getShowStylesAt(int index) {
            Iterator it = positions.iterator();
            while (it.hasNext()) {
                DispPos d = (DispPos)it.next();
                if (d.index != index) continue;
                return d;
            }
            return NAMEVALUE;
        }

        public static Iterator getShowStyles() {
            return Collections.unmodifiableList(positions).iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Position {
        private final String name;
        private final int index;
        private final Poly.Type pt;
        private static final List positions = new ArrayList();
        public static final Position CENT = new Position("centered", 0, Poly.Type.TEXTCENT);
        public static final Position UP = new Position("bottom", 1, Poly.Type.TEXTBOT);
        public static final Position DOWN = new Position("top", 2, Poly.Type.TEXTTOP);
        public static final Position LEFT = new Position("right", 3, Poly.Type.TEXTRIGHT);
        public static final Position RIGHT = new Position("left", 4, Poly.Type.TEXTLEFT);
        public static final Position UPLEFT = new Position("lower-right", 5, Poly.Type.TEXTBOTRIGHT);
        public static final Position UPRIGHT = new Position("lower-left", 6, Poly.Type.TEXTBOTLEFT);
        public static final Position DOWNLEFT = new Position("upper-right", 7, Poly.Type.TEXTTOPRIGHT);
        public static final Position DOWNRIGHT = new Position("upper-left", 8, Poly.Type.TEXTTOPLEFT);
        public static final Position BOXED = new Position("boxed", 9, Poly.Type.TEXTBOX);

        private Position(String name, int index, Poly.Type pt) {
            this.name = name;
            this.index = index;
            this.pt = pt;
            positions.add(index, this);
        }

        int getIndex() {
            return this.index;
        }

        public Poly.Type getPolyType() {
            return this.pt;
        }

        public Position align(int dx, int dy) {
            Position p = this;
            if (dx > 0) {
                if (p == CENT || p == RIGHT || p == LEFT) {
                    p = RIGHT;
                } else if (p == UP || p == UPRIGHT || p == UPLEFT) {
                    p = UPRIGHT;
                } else if (p == DOWN || p == DOWNRIGHT || p == DOWNLEFT) {
                    p = DOWNRIGHT;
                }
            } else if (dx < 0) {
                if (p == CENT || p == RIGHT || p == LEFT) {
                    p = LEFT;
                } else if (p == UP || p == UPRIGHT || p == UPLEFT) {
                    p = UPLEFT;
                } else if (p == DOWN || p == DOWNRIGHT || p == DOWNLEFT) {
                    p = DOWNLEFT;
                }
            }
            if (dy > 0) {
                if (p == CENT || p == UP || p == DOWN) {
                    p = UP;
                } else if (p == RIGHT || p == UPRIGHT || p == DOWNRIGHT) {
                    p = UPRIGHT;
                } else if (p == LEFT || p == UPLEFT || p == DOWNLEFT) {
                    p = UPLEFT;
                }
            } else if (dy < 0) {
                if (p == CENT || p == UP || p == DOWN) {
                    p = DOWN;
                } else if (p == RIGHT || p == UPRIGHT || p == DOWNRIGHT) {
                    p = DOWNRIGHT;
                } else if (p == LEFT || p == UPLEFT || p == DOWNLEFT) {
                    p = DOWNLEFT;
                }
            }
            return p;
        }

        public static Position getPosition(Poly.Type type) {
            Iterator it = positions.iterator();
            while (it.hasNext()) {
                Position pos = (Position)it.next();
                if (type != pos.pt) continue;
                return pos;
            }
            return CENT;
        }

        public static int getNumPositions() {
            return positions.size();
        }

        public static Position getPositionAt(int index) {
            return (Position)positions.get(index);
        }

        public static Iterator getPositions() {
            return Collections.unmodifiableList(positions).iterator();
        }

        public String toString() {
            return this.name;
        }
    }
}

