#if !defined (DEBUG)
#define DEBUG 1
#endif

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Debug.h>

#include <stdio.h>
#include <stdlib.h>
#include "gtk/gtk.h"
#include "libgimp/gimp.h"
#include "libgimp/gimpui.h"
#include "libgimp/gimpprotocol.h"

#include "IEWindow.h"
#include "GimpStub.h"
#include "FilterViews.h"

typedef struct
{
  gint    independent;
  gdouble noise[4];     /*  per channel  */
} NoisifyVals;

extern "C" NoisifyVals		nvals;

typedef struct ReturnValue {
	BMessage	*msg;
	bool		done;
};

class GIMPDlog : public IEWindow {
public:
	GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms);
	~GIMPDlog(void);

virtual	void		MessageReceived(BMessage *message);
virtual	bool		QuitRequested (void);
		void		DoPreview (void);
//public:
protected:
	FILTER_NAME			*fFilter;
	TFilterParams		*fParms;
	BSliderTextHelper	*fHelper1, *fHelper2, *fHelper3, *fHelper4;
	ReturnValue			*fReturn;
	bool				fPreview;
	NoisifyVals			fVals;
};

GIMPDlog::GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms) : IEWindow("noisify") {
	ASSERT (!ret->done); fReturn = ret; fReturn->msg = NULL;
	AddTemporaryBPath (NULL); fParms = parms; fFilter = filter;

	fPreview = true; fVals = nvals;
	Lock ();
	fHelper1 = new BSliderTextHelper ("Sl1", "TE1", this); fHelper1->SetValue (100 * fVals.noise[0]);
	fHelper2 = new BSliderTextHelper ("Sl2", "TE2", this); fHelper2->SetValue (100 * fVals.noise[1]);
	fHelper3 = new BSliderTextHelper ("Sl3", "TE3", this); fHelper3->SetValue (100 * fVals.noise[2]);
	fHelper4 = new BSliderTextHelper ("Sl4", "TE4", this); fHelper4->SetValue (100 * fVals.noise[3]);
	BControl	*ctl;
	if (fVals.independent) {
		ctl = (BControl *) FindView ("All"); ASSERT (typeid(*ctl)==typeid(BCheckBox)); ctl->SetValue (1);
		fHelper1->SetEnabled (false);
	} else {
		fHelper2->SetEnabled (false); fHelper3->SetEnabled (false); fHelper4->SetEnabled (false);
	}
	gProgressView = new TDlogProgressView (FindView ("Progress"));
	Unlock ();
	Show();
	DoPreview ();
}

GIMPDlog::~GIMPDlog(void) {
	if (!fReturn->msg) {
		fParms->fDst->Copy (*fParms->fSrc);
		FilterUpdate (fParms);
	} else  {
		if (!fPreview) {
			fPreview = true;
			DoPreview ();	//	We do the action if it was not previewed.
		}
		VERIFY (B_OK == fFilter->Archive (fReturn->msg, true));
	}
	delete fHelper1; delete fHelper2; delete fHelper3; delete fHelper4;
	fReturn->done = true;
}

bool GIMPDlog::QuitRequested (void) {
	gProgressView = NULL;
	return true;
}

void GIMPDlog::DoPreview (void) {
	if (fPreview) {
		fFilter->SetValue (&fVals);
	}
}

// Handling of user interface and other events
void GIMPDlog::MessageReceived (BMessage *message) {
	int32			value;

	switch(message->what){
		case '_xPr':	//	DoMiniPreview (); break;
		case 'Sl1 ':	value = message->FindInt32 ("be:value"); if (value != fVals.noise[0] * 100) { fVals.noise[0] = float(value) / 100; DoPreview (); }	break;
		case 'Sl2 ':	value = message->FindInt32 ("be:value"); if (value != fVals.noise[1] * 100) { fVals.noise[1] = float(value) / 100; DoPreview (); }	break;
		case 'Sl3 ':	value = message->FindInt32 ("be:value"); if (value != fVals.noise[2] * 100) { fVals.noise[2] = float(value) / 100; DoPreview (); }	break;
		case 'Sl4 ':	value = message->FindInt32 ("be:value"); if (value != fVals.noise[3] * 100) { fVals.noise[3] = float(value) / 100; DoPreview (); }	break;
		case 'All ':	fVals.independent = !fVals.independent; fHelper1->SetEnabled (!fVals.independent);
						fHelper2->SetEnabled (fVals.independent); fHelper3->SetEnabled (fVals.independent); fHelper4->SetEnabled (fVals.independent);
						DoPreview ();
						break;
		case 'View':	fPreview = !fPreview;
						if (fPreview) {
							DoPreview ();
						} else {
							//	Removes the preview by restoring the original image.
							fParms->fDst->Copy (*fParms->fSrc);
							FilterUpdate (fParms);
						}
						break;
		case 'Abut':	fFilter->DoAbout (); break;
		case 'OK  ':	fReturn->msg = new BMessage ('Parm'); nvals = fVals;
		case 'Esc ':	gProgressView = NULL; Quit (); break;
		default:		inherited::MessageReceived(message); break;
	}

}

void FILTER_NAME::DoIt (TFilterParams *parms, const void *values) {
	GParam	inputParms[8], *outputParms;
	gint	cntOutput;

	inputParms[0].type = PARAM_INT32; inputParms[0].data.d_int32 = RUN_NONINTERACTIVE;	//	TBD, determined by the message
	inputParms[2].type = PARAM_DRAWABLE; inputParms[2].data.d_drawable = gint32(parms);
	inputParms[3].type = PARAM_INT32; inputParms[3].data.d_int32 = ((const NoisifyVals *)values)->independent;
	inputParms[4].type = PARAM_FLOAT; inputParms[4].data.d_float = ((const NoisifyVals *)values)->noise[0];
	inputParms[5].type = PARAM_FLOAT; inputParms[5].data.d_float = ((const NoisifyVals *)values)->noise[1];
	inputParms[6].type = PARAM_FLOAT; inputParms[6].data.d_float = ((const NoisifyVals *)values)->noise[2];
	inputParms[7].type = PARAM_FLOAT; inputParms[7].data.d_float = ((const NoisifyVals *)values)->noise[3];
	(*PLUG_IN_INFO.run_proc) (fName, 8, inputParms, &cntOutput, &outputParms);
}

BMessage *FILTER_NAME::ApplyFilter (TFilterParams *parms) {
	BMessage	*result = NULL;

	if (fInited) {
		ASSERT (fLock == NULL);
		DoIt (parms, fData);
	} else {
		ReturnValue	returnVal;

		fLock = new Benaphore ("Synchro Dialog");
		returnVal.done = fChanged = false; fInited = true;
		AddTemporaryBPath (filterFile);
		new GIMPDlog (&returnVal, this, parms);
		do {
			if (fChanged) {
				fLock->Lock ();
				NoisifyVals	tmpValues;
				memcpy (&tmpValues, fData, sizeof (NoisifyVals));
				fChanged = false;
				fLock->Unlock ();
				DoIt (parms, &tmpValues);
				FilterUpdate (parms);
			} else {
				snooze (250000);
			}
		} while (!returnVal.done);
		result = returnVal.msg;
	}
	return result;
}

void FILTER_NAME::PrepareData (void) {
	fData = (void *) new char [sizeof(NoisifyVals)]; fDataSize = sizeof (NoisifyVals);
	ASSERT (fData);
}

void FILTER_NAME::DisposeData (void) {
	delete (NoisifyVals *)fData;
}

void FILTER_NAME::SetValue (void *value) {
	ASSERT (fLock);
	fLock->Lock ();

	memcpy (fData, value, sizeof(NoisifyVals));
	fChanged = true;
	fLock->Unlock ();
}

void gimp_get_data (gchar *id, gpointer data) {
	ASSERT (gCurFilter); gCurFilter->GetData (id, data);
}

void gimp_set_data (gchar *id, gpointer data, guint32 length) {
	ASSERT (gCurFilter); gCurFilter->SetData (id, data, length);
}

