#if !defined (DEBUG)
#define DEBUG 1
#endif

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Debug.h>

#include <stdio.h>
#include <stdlib.h>
#include "gtk/gtk.h"
#include "libgimp/gimp.h"
#include "libgimp/gimpui.h"
#include "libgimp/gimpprotocol.h"

#include "IEWindow.h"
#include "GimpStub.h"
#include "FilterViews.h"

typedef struct
{
  gdouble refraction;
  gint keep_surr, use_bkgr, set_transparent;
} LensValues;


extern "C" LensValues		lvals;

typedef struct ReturnValue {
	BMessage	*msg;
	bool		done;
};

class GIMPDlog : public IEWindow {
public:
	GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms);
	~GIMPDlog(void);

virtual	void		MessageReceived(BMessage *message);
		void		DoPreview (void);
//public:
protected:
	FILTER_NAME			*fFilter;
	TFilterParams		*fParms;
	BSliderTextHelperFloat *fHelper;
	ReturnValue			*fReturn;
	LensValues			fVals;
	bool				fPreview;
};

GIMPDlog::GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms) : IEWindow("apply_lens") {
	ASSERT (!ret->done); fReturn = ret; fReturn->msg = NULL;
	AddTemporaryBPath (NULL); fParms = parms; fFilter = filter;

	fVals = lvals;
	fPreview = true;
	Lock ();
	char	radioName[2] = { 48, 0 };
	if (lvals.keep_surr) *radioName = '0';
	else if (lvals.use_bkgr) *radioName = '1';
	BControl	*ctl = (BControl *) FindView (radioName);
	if (ctl) ctl->SetValue (1);
	fHelper = new BSliderTextHelperFloat ("Sl1", "TE1", this, 10); fHelper->SetValue (fVals.refraction * 10);
	gProgressView = new TDlogProgressView (FindView ("Progress"));
	Unlock ();
	Show();
	DoPreview ();
}

GIMPDlog::~GIMPDlog(void) {
	gProgressView = NULL;
	if (!fReturn->msg) {
		fParms->fDst->Copy (*fParms->fSrc);
		FilterUpdate (fParms);
	} else  {
		if (!fPreview) {
			fPreview = true;
			DoPreview ();	//	We do the action if it was not previewed.
		}
		VERIFY (B_OK == fFilter->Archive (fReturn->msg, true));
	}
	delete fHelper;
	fReturn->done = true;
}

void GIMPDlog::DoPreview (void) {
	if (fPreview) {
		fFilter->SetValue (&fVals);
	}
}

// Handling of user interface and other events
void GIMPDlog::MessageReceived (BMessage *message) {
	int32			value;

	switch(message->what){
		case '_xPr':	//	DoMiniPreview (); break;
		case 'Sl1 ':	value = message->FindInt32 ("be:value"); if (value != 10 * fVals.refraction) { fVals.refraction = float(value)/10; DoPreview (); } break;
		case 'View':	fPreview = !fPreview;
						if (fPreview) {
							DoPreview ();
						} else {
							//	Removes the preview by restoring the original image.
							fParms->fDst->Copy (*fParms->fSrc);
							FilterUpdate (fParms);
						}
						break;
		case 'OrgS':	fVals.keep_surr = 1; fVals.use_bkgr = fVals.set_transparent = 0; DoPreview (); break;
		case 'BgS ':	fVals.keep_surr = 0; fVals.use_bkgr = 1; fVals.set_transparent = 0; DoPreview (); break;
		case 'Abut':	fFilter->DoAbout (); break;
		case 'OK  ':	fReturn->msg = new BMessage ('Parm'); lvals = fVals;
		case 'Esc ':	Quit (); break;
		default:		inherited::MessageReceived(message); break;
	}

}

void FILTER_NAME::DoIt (TFilterParams *parms, const void *values) {
	GParam	inputParms[7], *outputParms;
	gint	cntOutput;

	inputParms[0].type = PARAM_INT32; inputParms[0].data.d_int32 = RUN_NONINTERACTIVE;	//	TBD, determined by the message
	inputParms[2].type = PARAM_DRAWABLE; inputParms[2].data.d_drawable = gint32(parms);
	inputParms[3].type = PARAM_FLOAT; inputParms[3].data.d_float = ((const LensValues *)values)->refraction;
	inputParms[4].type = PARAM_INT32; inputParms[4].data.d_int32 = ((const LensValues *)values)->keep_surr;
	inputParms[5].type = PARAM_INT32; inputParms[5].data.d_int32 = ((const LensValues *)values)->use_bkgr;
	inputParms[6].type = PARAM_INT32; inputParms[6].data.d_int32 = ((const LensValues *)values)->set_transparent;
	(*PLUG_IN_INFO.run_proc) (fName, 7, inputParms, &cntOutput, &outputParms);
}

BMessage *FILTER_NAME::ApplyFilter (TFilterParams *parms) {
	BMessage	*result = NULL;

	if (fInited) {
		ASSERT (fLock == NULL);
		DoIt (parms, fData);
	} else {
		ReturnValue	returnVal;

		fLock = new Benaphore ("Synchro Dialog");
		returnVal.done = fChanged = false; fInited = true;
		AddTemporaryBPath (filterFile);
		new GIMPDlog (&returnVal, this, parms);
		do {
			if (fChanged) {
				fLock->Lock ();
				LensValues	tmpValues;
				memcpy (&tmpValues, fData, sizeof (LensValues));
				fChanged = false;
				fLock->Unlock ();
				DoIt (parms, &tmpValues);
				FilterUpdate (parms);
			} else {
				snooze (250000);
			}
		} while (!returnVal.done || fChanged);
		result = returnVal.msg;
	}
	return result;
}

void FILTER_NAME::PrepareData (void) {
	fData = (void *) new char [sizeof(LensValues)]; fDataSize = sizeof (LensValues);
	ASSERT (fData);
}

void FILTER_NAME::DisposeData (void) {
	delete (LensValues *)fData;
}

void FILTER_NAME::SetValue (void *value) {
	ASSERT (fLock);
	fLock->Lock ();

	memcpy (fData, value, sizeof(LensValues));
	fChanged = true;
	fLock->Unlock ();
}

void gimp_get_data (gchar *id, gpointer data) {
	ASSERT (gCurFilter); gCurFilter->GetData (id, data);
}

void gimp_set_data (gchar *id, gpointer data, guint32 length) {
	ASSERT (gCurFilter); gCurFilter->SetData (id, data, length);
}

