/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mapshot;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.service.BendPointsFeedback;
import org.xmind.gef.service.CompositeFeedback;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IRectangleProvider;
import org.xmind.gef.service.RectangleFeedback;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.mapshot.Button;
import org.xmind.ui.internal.mapshot.MapShotTemporaryStorage;
import org.xmind.ui.internal.mapshot.TransparentCornerLabel;
import org.xmind.ui.mindmap.IHighlightService;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;

public class CopyAreaFeedback
extends CompositeFeedback
implements IBendPointsFeedback {
    private RectangleFeedback border;
    private BendPointsFeedback points;
    private IHighlightService highlightService;
    private Rectangle oldSkylight;
    private boolean isMoving = false;
    private static final int BUTTON_TOP_MARGIN = 5;
    private MapShotTemporaryStorage mapshotTemporaryStorage;

    public CopyAreaFeedback(MapShotTemporaryStorage mapshotTool) {
        this.mapshotTemporaryStorage = mapshotTool;
        this.border = new RectangleFeedback();
        this.border.setBorderColor(ColorUtils.getColor((String)"#0040f0"));
        this.border.setFillColor(ColorUtils.getColor((String)"#0040f0"));
        this.border.setBorderAlpha(255);
        this.border.setFillAlpha(64);
        this.points = new BendPointsFeedback();
        this.points.setBorderColor(ColorUtils.getColor((String)"#0040ff"));
        this.points.setFillColor(ColorUtils.getColor((String)"#30a0f0"));
        this.points.setAlpha(255);
        this.points.setHidePointLength(28);
        this.points.setPointHeight(7);
        this.addFeedback((IFeedback)this.border);
        this.addFeedback((IFeedback)this.points);
    }

    public void setHighlightService(IHighlightService service) {
        if (service == this.highlightService) {
            return;
        }
        IHighlightService oldService = this.highlightService;
        if (oldService != null) {
            oldService.setHighlightArea(this.oldSkylight);
        }
        this.oldSkylight = null;
        this.highlightService = service;
        if (service != null) {
            this.oldSkylight = service.getHighlightArea();
            this.border.setFillAlpha(0);
        }
        this.update();
    }

    public RectangleFeedback getBorder() {
        return this.border;
    }

    public BendPointsFeedback getPoints() {
        return this.points;
    }

    public IRectangleProvider getBoundsProvider() {
        return this.border.getBoundsProvider();
    }

    public int getOrientation(Point point) {
        return this.points.getOrientation(point);
    }

    public void setBoundsProvider(IRectangleProvider boundsProvider) {
        this.border.setBoundsProvider(boundsProvider);
        this.points.setBoundsProvider(boundsProvider);
    }

    public void update() {
        Rectangle area;
        super.update();
        if (this.getBoundsProvider() != null && (area = this.getBoundsProvider().getRectangle()) != null) {
            if (this.isMoving()) {
                this.updateButtons();
            }
            this.updateAreaSizeLabel(area);
            area = this.getZoomManager().getScaled(area).expand(1, 1);
            if (this.highlightService != null) {
                this.highlightService.setHighlightArea(area, 128);
            }
        }
    }

    private void updateAreaSizeLabel(Rectangle area) {
        Layer feedbackLayer = this.getLayer(MindMapUI.LAYER_SKYLIGHT);
        if (feedbackLayer == null) {
            return;
        }
        TransparentCornerLabel sizeLabel = this.mapshotTemporaryStorage.getSizeLabel();
        if (sizeLabel == null) {
            sizeLabel = new TransparentCornerLabel();
            sizeLabel.setSize(74, 20);
            sizeLabel.setLabelAlignment(2);
            sizeLabel.setOpaque(true);
            sizeLabel.setBackgroundColor(ColorUtils.getColor((String)"#D8D8D8"));
            sizeLabel.setAlpha(242);
            sizeLabel.setCornerDimensions(4);
            feedbackLayer.add((IFigure)sizeLabel);
        }
        double scale = 1.0;
        ScalableFigure scalableLayer = (ScalableFigure)this.getLayer(GEF.LAYERS_SCALABLE);
        if (scalableLayer != null) {
            scale = scalableLayer.getScale();
        }
        Point topLeft = area.getLocation();
        int x = (int)((double)topLeft.x * scale);
        int y = (int)((double)topLeft.y * scale);
        Viewport viewport = this.getGraphicalViewer().getCanvas().getViewport();
        if (viewport != null) {
            Rectangle clientArea = viewport.getClientArea();
            if (y - clientArea.y >= sizeLabel.getSize().height + 3) {
                y -= sizeLabel.getSize().height + 3;
            }
        }
        sizeLabel.setLocation(new Point(x, y));
        sizeLabel.setText(String.valueOf(area.getSize().width) + " x " + area.getSize().height);
        this.mapshotTemporaryStorage.setSizeLabel(sizeLabel);
        sizeLabel.revalidate();
    }

    public void updateButtons() {
        Rectangle area = this.getBoundsProvider().getRectangle();
        if (area != null) {
            double scale = 1.0;
            ScalableFigure scalableLayer = (ScalableFigure)this.getLayer(GEF.LAYERS_SCALABLE);
            if (scalableLayer != null) {
                scale = scalableLayer.getScale();
            }
            Point bottomRight = area.getBottomRight();
            Button btnCancel = this.mapshotTemporaryStorage.getEnsureButton("Cancel");
            int x = (int)((double)bottomRight.x * scale - (double)(3 * btnCancel.getSize().width));
            int y = (int)((double)bottomRight.y * scale) + 5;
            btnCancel.setLocation(new Point(x, y));
            btnCancel.setVisible(true);
            Button btnSave = this.mapshotTemporaryStorage.getEnsureButton("Save");
            btnSave.setLocation(new Point(x += btnSave.getSize().width, y));
            Button btnCopy = this.mapshotTemporaryStorage.getEnsureButton("Copy");
            btnCopy.setLocation(new Point(x += btnCopy.getSize().width, y));
            btnCopy.setVisible(true);
        }
    }

    public void removeFromLayer(IFigure layer) {
        super.removeFromLayer(layer);
        if (this.highlightService != null) {
            this.highlightService.setHighlightArea(this.oldSkylight);
        }
    }

    private Layer getLayer(Object key) {
        IGraphicalViewer viewer = this.getGraphicalViewer();
        return viewer == null ? null : viewer.getLayer(key);
    }

    private IGraphicalViewer getGraphicalViewer() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof MindMapEditor) {
            return ((MindMapEditor)editor).getActivePageInstance().getViewer();
        }
        return null;
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }
}

