/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.FreeMindExporter;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class FreeMindExportWizard
extends AbstractMindMapExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.export.freemindeExportWizard";
    private static final String SELECTION_NAME = "org.xmind.ui.export.freemind";
    private static final String FILE_EXT = ".mm";
    private FreeMindExportWizardPage page;

    public FreeMindExportWizard() {
        this.setWindowTitle(WizardMessages.FreeMindWizard_windowTitle);
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(SELECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    @Override
    protected void addValidPages() {
        this.page = new FreeMindExportWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    @Override
    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ExportToFreeMindCount");
        IMindMap mindMap = this.getSourceMindMap();
        FreeMindExporter exporter = new FreeMindExporter(mindMap.getSheet(), this.getTargetPath());
        monitor.beginTask(null, 100);
        exporter.setMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 99));
        exporter.build();
        this.launchTargetFile(true, monitor, display, parentShell);
    }

    @Override
    protected String getFormatName() {
        return WizardMessages.FreeMindWizard_formatName;
    }

    @Override
    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && FILE_EXT.equalsIgnoreCase(extension);
    }

    @Override
    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    @Override
    protected String getSuggestedFileName() {
        String fileName = super.getSuggestedFileName();
        return String.valueOf(fileName) + FILE_EXT;
    }

    private class FreeMindExportWizardPage
    extends AbstractMindMapExportPage {
        protected FreeMindExportWizardPage() {
            super(FreeMindExportWizard.PAGE_NAME, WizardMessages.FreeMindPage_title);
            this.setDescription(WizardMessages.FreeMindPage_description);
        }

        @Override
        protected FreeMindExportWizard getCastedWizard() {
            return (FreeMindExportWizard)super.getCastedWizard();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        @Override
        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, WizardMessages.FreeMindPage_filterName);
            filterExtensions.add(0, "*.mm");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

