/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.xmind.ui.dialogs.IDialogConstants;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.protocols.FilePathParser;

public class WorkbookHistoryItem {
    static final String FILE_PROTOCOL = "file:";
    private IEditorInput input;
    private String uri;
    private long time;

    public WorkbookHistoryItem(IEditorInput input, String uri, long time) {
        this.input = input;
        this.uri = uri;
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public String getURI() {
        return this.uri;
    }

    public String getPath() {
        if (FilePathParser.isFileURI(this.uri)) {
            return FilePathParser.toPath(this.uri);
        }
        return this.uri;
    }

    void setInput(IEditorInput input) {
        this.input = input;
    }

    public IEditorInput getExistingEditorInput() {
        return this.input;
    }

    public IEditorInput createNewEditorInput() throws CoreException {
        return MME.createFileEditorInput(this.getPath());
    }

    public void reopen(IWorkbenchPage page) throws CoreException {
        if (!new File(this.getPath()).exists()) {
            MessageDialog.openWarning((Shell)new Shell(), (String)IDialogConstants.COMMON_TITLE, (String)MindMapMessages.WorkbookHistoryItem_FileMissingMessage);
            return;
        }
        page.openEditor(this.createNewEditorInput(), "org.xmind.ui.MindMapEditor", true);
    }

    public String toString() {
        return "{time=" + this.time + ",uri=" + this.uri + "}";
    }

    static String toURI(String filePath) {
        return FilePathParser.toURI(filePath, false);
    }
}

