/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.event.NullCoreEventSupport;
import org.xmind.ui.internal.taskinfo.TaskMessages;

public class Dependency
implements ICoreEventSource {
    public static final String FS = "FS";
    public static final String SF = "SF";
    public static final String SS = "SS";
    public static final String FF = "FF";
    public static final String[] TYPES = new String[]{"FS", "SF", "SS", "FF"};
    private static Map<ITopicExtensionElement, Dependency> cache = new HashMap<ITopicExtensionElement, Dependency>();
    private ITopicExtensionElement element;

    private Dependency(ITopicExtensionElement element) {
        Assert.isNotNull((Object)element);
        this.element = element;
    }

    public ITopic getSuccessor() {
        return this.element == null ? null : this.element.getTopic();
    }

    public String getTaskId() {
        return this.element == null ? null : this.element.getAttribute("task-id");
    }

    public String getType() {
        return this.element == null ? FS : this.element.getAttribute("type");
    }

    public String getTypeName() {
        return Dependency.typeName(this.getType());
    }

    public int getTypeIndex() {
        return Dependency.typeIndex(this.getType());
    }

    public ITopic getPredecessor() {
        return this.getTask(this.getSuccessor().getOwnedWorkbook());
    }

    public ITopic getTask(IWorkbook workbook) {
        if (workbook == null) {
            return null;
        }
        String taskId = this.getTaskId();
        return taskId == null ? null : workbook.findTopic(taskId);
    }

    public ITopicExtensionElement getElement() {
        return this.element;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Dependency)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Dependency that = (Dependency)obj;
        return this.element == that.element || this.element != null && this.element.equals(that.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        return String.format("Task(%s) %s", this.getTaskId(), this.getType());
    }

    public static String typeName(String type) {
        if (FS.equals(type)) {
            return TaskMessages.Dependency_FS_label;
        }
        if (SF.equals(type)) {
            return TaskMessages.Dependency_SF_label;
        }
        if (SS.equals(type)) {
            return TaskMessages.Dependency_SS_label;
        }
        if (FF.equals(type)) {
            return TaskMessages.Dependency_FF_label;
        }
        return TaskMessages.Dependency_UnknownType;
    }

    public static int typeIndex(String type) {
        int index = 0;
        while (index < TYPES.length) {
            if (TYPES[index].equals(type)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public ICoreEventSupport getCoreEventSupport() {
        ITopic topic = this.getSuccessor();
        if (topic instanceof ICoreEventSource) {
            return ((ICoreEventSource)topic).getCoreEventSupport();
        }
        return NullCoreEventSupport.getInstance();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public static Dependency getInstance(ITopicExtensionElement element) {
        Dependency instance = cache.get(element);
        if (instance == null) {
            instance = new Dependency(element);
            cache.put(element, instance);
        }
        return instance;
    }
}

