/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.workbench.ui.internal;

import net.xmind.signin.XMindNet;
import net.xmind.workbench.internal.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewsletterSubscriptionDialog
extends TitleAreaDialog {
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private Text text;

    public NewsletterSubscriptionDialog(Shell parentShell, IInputValidator validator) {
        super(parentShell);
        this.validator = validator;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.NewsletterSubscriptionReminder_DialogTitle);
    }

    public void create() {
        super.create();
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getShell());
        ImageDescriptor logoImage = XMindNet.getBannerLogoImage();
        if (logoImage != null) {
            this.setTitleImage((Image)resources.get((DeviceResourceDescriptor)logoImage));
        }
        this.setTitle(Messages.NewsletterSubscriptionReminder_DialogTitle);
        this.setMessage(Messages.NewsletterSubscriptionReminder_TitleMessage);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite area = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 15;
        layout.marginWidth = 9;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        this.createDetailArea(area);
        NewsletterSubscriptionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Composite createDetailArea(Composite parent) {
        Composite composite = new Composite(parent, 0x1000000);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createMessageLabel(composite);
        this.createTextArea(composite);
        return composite;
    }

    private void createMessageLabel(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(Messages.NewsletterSubscriptionReminder_DialogMessage);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
    }

    private void createTextArea(Composite composite) {
        this.text = new Text(composite, this.getInputTextStyle());
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewsletterSubscriptionDialog.this.validateInput();
            }
        });
    }

    protected Label getErrorMessageLabel() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        Button button;
        String message = null;
        if (this.validator != null) {
            message = this.validator.isValid(this.text.getText());
        }
        if ((button = this.getButton(0)) != null) {
            button.setEnabled(message == null);
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

