# rnaGene.sql was originally generated by the autoSql program, which also 
# generated rnaGene.c and rnaGene.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Describes functional RNA genes.
CREATE TABLE rnaGene (
    chrom varchar(255) not null,	# Chromosome gene is on
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Name of gene
    score int unsigned not null,	# Score from 0 to 1000
    strand char(1) not null,	        # Strand + or -
    source varchar(255) not null,	# Source as in Sean Eddys files.
    type varchar(255) not null,	# Type - snRNA, rRNA, tRNA, etc.
    fullScore float not null,	# Score as in Sean Eddys files.
    isPsuedo tinyint unsigned not null,	# TRUE(1) if psuedo, FALSE(0) otherwise
              #Indices
    INDEX(name(20)),
    INDEX(chrom(12),chromStart)
);
