/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.net.URI;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.provider.Provider;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryInternal;

public class RealizedJavaToolchainRepository {
    private final Provider<? extends JavaToolchainResolver> resolverProvider;
    private final JavaToolchainRepositoryInternal repository;

    @Inject
    public RealizedJavaToolchainRepository(Provider<? extends JavaToolchainResolver> resolverProvider, JavaToolchainRepositoryInternal repository) {
        this.resolverProvider = resolverProvider;
        this.repository = repository;
    }

    public JavaToolchainResolver getResolver() {
        return (JavaToolchainResolver)this.resolverProvider.get();
    }

    public Collection<Authentication> getAuthentications(URI uri) {
        Collection<Authentication> configuredAuthentication = this.repository.getConfiguredAuthentication();
        for (Authentication authentication : configuredAuthentication) {
            AuthenticationInternal authenticationInternal = (AuthenticationInternal)authentication;
            if (!uri.getScheme().startsWith("http")) continue;
            authenticationInternal.addHost(uri.getHost(), uri.getPort());
        }
        return configuredAuthentication;
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }
}

