/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class MenuFactory
extends ResourceManager {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String TYPE_SUFFIX = ".type";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACCELERATOR_SUFFIX = ".accelerator";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String ENABLED_SUFFIX = ".enabled";
    private static final String ICON_SUFFIX = ".icon";
    private ActionMap actions;
    private ButtonGroup buttonGroup;

    public MenuFactory(ResourceBundle resourceBundle, ActionMap actionMap) {
        super(resourceBundle);
        this.actions = actionMap;
        this.buttonGroup = null;
    }

    public JMenuBar createJMenuBar(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuBar jMenuBar = new JMenuBar();
        List list = this.getStringList(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jMenuBar.add(this.createJMenuComponent((String)iterator.next()));
        }
        return jMenuBar;
    }

    protected JComponent createJMenuComponent(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        if (string.equals(SEPARATOR)) {
            this.buttonGroup = null;
            return new JSeparator();
        }
        String string2 = this.getString(string + TYPE_SUFFIX);
        JMenuItem jMenuItem = null;
        if (string2.equals(TYPE_RADIO)) {
            if (this.buttonGroup == null) {
                this.buttonGroup = new ButtonGroup();
            }
        } else {
            this.buttonGroup = null;
        }
        if (string2.equals(TYPE_MENU)) {
            jMenuItem = this.createJMenu(string);
        } else if (string2.equals(TYPE_ITEM)) {
            jMenuItem = this.createJMenuItem(string);
        } else if (string2.equals(TYPE_RADIO)) {
            jMenuItem = this.createJRadioButtonMenuItem(string);
            this.buttonGroup.add(jMenuItem);
        } else if (string2.equals(TYPE_CHECK)) {
            jMenuItem = this.createJCheckBoxMenuItem(string);
        } else {
            throw new ResourceFormatException("Malformed resource", this.bundle.getClass().getName(), string + TYPE_SUFFIX);
        }
        return jMenuItem;
    }

    public JMenu createJMenu(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenu jMenu = new JMenu(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jMenu, string);
        List list = this.getStringList(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jMenu.add(this.createJMenuComponent((String)iterator.next()));
        }
        return jMenu;
    }

    public JMenuItem createJMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuItem jMenuItem = new JMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jMenuItem, string);
        return jMenuItem;
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jRadioButtonMenuItem, string);
        try {
            jRadioButtonMenuItem.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jRadioButtonMenuItem;
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jCheckBoxMenuItem, string);
        try {
            jCheckBoxMenuItem.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jCheckBoxMenuItem;
    }

    protected void initializeJMenuItem(JMenuItem jMenuItem, String string) throws ResourceFormatException, MissingListenerException {
        block15: {
            Serializable serializable;
            Object object;
            try {
                object = this.actions.getAction(this.getString(string + ACTION_SUFFIX));
                if (object == null) {
                    throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
                }
                jMenuItem.setAction((Action)object);
                jMenuItem.setText(this.getString(string + TEXT_SUFFIX));
                if (object instanceof JComponentModifier) {
                    ((JComponentModifier)object).addJComponent(jMenuItem);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                object = this.getString(string + ICON_SUFFIX);
                serializable = this.actions.getClass().getResource((String)object);
                if (serializable != null) {
                    jMenuItem.setIcon(new ImageIcon((URL)serializable));
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                object = this.getString(string + MNEMONIC_SUFFIX);
                if (((String)object).length() != 1) {
                    throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), string + MNEMONIC_SUFFIX);
                }
                jMenuItem.setMnemonic(((String)object).charAt(0));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                if (jMenuItem instanceof JMenu) break block15;
                object = this.getString(string + ACCELERATOR_SUFFIX);
                serializable = this.toKeyStroke((String)object);
                if (serializable != null) {
                    jMenuItem.setAccelerator((KeyStroke)serializable);
                    break block15;
                }
                throw new ResourceFormatException("Malformed accelerator", this.bundle.getClass().getName(), string + ACCELERATOR_SUFFIX);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            jMenuItem.setEnabled(this.getBoolean(string + ENABLED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected KeyStroke toKeyStroke(String string) {
        char c;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n != 100 && n4 < string.length()) {
            c = Character.toUpperCase(string.charAt(n4));
            block0 : switch (n) {
                case 0: {
                    n2 = c;
                    switch (c) {
                        case 'C': {
                            n = 1;
                            break block0;
                        }
                        case 'A': {
                            n = 5;
                            break block0;
                        }
                        case 'M': {
                            n = 8;
                            break block0;
                        }
                        case 'S': {
                            n = 12;
                            break block0;
                        }
                    }
                    n = 100;
                    break;
                }
                case 1: {
                    n = c == 'T' ? 2 : 100;
                    break;
                }
                case 2: {
                    n = c == 'R' ? 3 : 100;
                    break;
                }
                case 3: {
                    n = c == 'L' ? 4 : 100;
                    break;
                }
                case 4: {
                    int n5 = n = c == '+' ? 0 : 100;
                    if (n != 0) break;
                    n3 |= 2;
                    break;
                }
                case 5: {
                    n = c == 'L' ? 6 : 100;
                    break;
                }
                case 6: {
                    n = c == 'T' ? 7 : 100;
                    break;
                }
                case 7: {
                    int n6 = n = c == '+' ? 0 : 100;
                    if (n != 0) break;
                    n3 |= 8;
                    break;
                }
                case 8: {
                    n = c == 'E' ? 9 : 100;
                    break;
                }
                case 9: {
                    n = c == 'T' ? 10 : 100;
                    break;
                }
                case 10: {
                    n = c == 'A' ? 11 : 100;
                    break;
                }
                case 11: {
                    int n7 = n = c == '+' ? 0 : 100;
                    if (n != 0) break;
                    n3 |= 4;
                    break;
                }
                case 12: {
                    n = c == 'H' ? 13 : 100;
                    break;
                }
                case 13: {
                    n = c == 'I' ? 14 : 100;
                    break;
                }
                case 14: {
                    n = c == 'F' ? 15 : 100;
                    break;
                }
                case 15: {
                    n = c == 'T' ? 16 : 100;
                    break;
                }
                case 16: {
                    int n8 = n = c == '+' ? 0 : 100;
                    if (n != 0) break;
                    n3 |= 1;
                }
            }
            ++n4;
        }
        if (n2 > 0 && n3 > 0) {
            if (n4 < string.length()) {
                c = Character.toUpperCase(string.charAt(n4));
                switch (n2) {
                    case 85: {
                        if (string.length() - n4 != 1 || c != 'P') break;
                        n2 = 38;
                        break;
                    }
                    case 76: {
                        if (string.length() - n4 != 3 || c != 'E' || Character.toUpperCase(string.charAt(n4 + 1)) != 'F' || Character.toUpperCase(string.charAt(n4 + 2)) != 'T') break;
                        n2 = 37;
                        break;
                    }
                    case 68: {
                        if (string.length() - n4 != 3 || c != 'O' || Character.toUpperCase(string.charAt(n4 + 1)) != 'W' || Character.toUpperCase(string.charAt(n4 + 2)) != 'N') break;
                        n2 = 40;
                        break;
                    }
                    case 82: {
                        if (string.length() - n4 != 4 || c != 'I' || Character.toUpperCase(string.charAt(n4 + 1)) != 'G' || Character.toUpperCase(string.charAt(n4 + 2)) != 'H' || Character.toUpperCase(string.charAt(n4 + 3)) != 'T') break;
                        n2 = 39;
                    }
                }
            }
            return KeyStroke.getKeyStroke(n2, n3);
        }
        return null;
    }
}

