/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package javax.servlet.jsp.el;

import java.text.MessageFormat;

/**
 * Represents any of the exception conditions that arise during the
 * operation evaluation of the evaluator.
 *
 * @since 2.0
 */
public class ELException
  extends Exception
{
  //-------------------------------------
  // Member variables
  //-------------------------------------

  private Throwable mRootCause;

  //-------------------------------------
  /**
   * Creates an ELException with no detail message.
   **/
  public ELException ()
  {
    super ();
  }

  //-------------------------------------
  /**
   * Creates an ELException with the provided detail message.
   *
   * @param pMessage the detail message
   **/
  public ELException (String pMessage)
  {
    super (pMessage);
  }

  //-------------------------------------
  /**
   * Creates an ELException with the given root cause.
   *
   * @param pRootCause the originating cause of this exception
   **/
  public ELException (Throwable pRootCause)
  {
    super( pRootCause.getLocalizedMessage() );
    mRootCause = pRootCause;
  }

  //-------------------------------------
  /**
   * Creates an ELException with the given detail message and root cause.
   *
   * @param pMessage the detail message
   * @param pRootCause the originating cause of this exception
   **/
  public ELException (String pMessage,
		      Throwable pRootCause)
  {
    super (pMessage);
    mRootCause = pRootCause;
  }

  //-------------------------------------
  /**
   * Returns the root cause.
   *
   * @return the root cause of this exception
   */
  public Throwable getRootCause ()
  {
    return mRootCause;
  }
}
