/* ex: set tabstop=8 noet: */
/**
 * os classification
 */

#ifndef CLASSIFY_H
#define CLASSIFY_H

#ifdef __cplusplus
extern "C" {
#endif

#define OS_BUFLEN	64

/**
 * each type of operating system we claim to be able to detect
 * used for the os tree in classify.c
 * @note UNKNOWN must be 0, and each entry must be declared AFTER its parent
 */
enum {
	OS_UNKNOWN = 0,
#define OS_NONE			(OS_UNKNOWN)
	OS_UNIX,
	/* BSD Family */
	OS_BSD,
	OS_NETBSD,
	OS_NETBSD_1X,
	OS_NETBSD_13,
	OS_NETBSD_2X,
	OS_FREEBSD,
	OS_FREEBSD_2X,
	OS_FREEBSD_3X,
	OS_FREEBSD_4X,
	OS_FREEBSD_40,
	OS_FREEBSD_42,
	OS_FREEBSD_44,
	OS_FREEBSD_46,
	OS_FREEBSD_47,
	OS_FREEBSD_48,
	OS_FREEBSD_49,
	OS_FREEBSD_410,
	OS_FREEBSD_411,
	OS_FREEBSD_5X,
	OS_FREEBSD_50,
	OS_FREEBSD_51,
	OS_FREEBSD_52,
	OS_FREEBSD_53,
	OS_FREEBSD_6X,
	OS_OPENBSD,
	OS_OPENBSD_2X,
	OS_OPENBSD_26,
	OS_OPENBSD_3X,
	OS_OPENBSD_30,
	OS_OPENBSD_33,
	OS_OPENBSD_35,
	OS_OPENBSD_37,
	OS_DFLYBSD,
	OS_DFLYBSD_1X,
	OS_DFLYBSD_10X,
	OS_DFLYBSD_12,
	/* Apple */
	OS_MACOS,
	OS_MACOS_8X,
	OS_MACOS_9X,
	OS_MACOS_92X,
	OS_MACOS_92,
	OS_MACOS_922,
	OS_OSX,
	OS_OSX_0,
	OS_OSX_1,
	OS_OSX_2,
	OS_OSX_3,
	OS_OSX_4,
	OS_OSX_5,
	/* Windows */
	OS_WIN,
	OS_WIN_311,
	OS_WIN_95,
	OS_WIN_98,
	OS_WIN_ME,
	OS_WIN_NT,
	OS_WIN_NT_3X,
	OS_WIN_NT_4X,
	OS_WIN_NT_40,
	OS_WIN_NT_40_SP1,
	OS_WIN_NT_40_SP2,
	OS_WIN_NT_40_SP3,
	OS_WIN_NT_40_SP4,
	OS_WIN_NT_40_SP5,
	OS_WIN_NT_40_SP6,
	OS_WIN_NT_40_SP6A,
	OS_WIN_NT_50_X,
	OS_WIN_NT_50,
	OS_WIN_NT_50_SVR,
	OS_WIN_NT_50_SP1,
	OS_WIN_NT_50_SP2,
	OS_WIN_NT_50_SP3,
	OS_WIN_NT_50_SP4,
	OS_WIN_NT_51_X,
	OS_WIN_NT_51,
	OS_WIN_NT_51_SP1,
	OS_WIN_NT_51_SP2,
	OS_WIN_NT_52_X,
	OS_WIN_NT_52,
	OS_WIN_NT_52_SP1,
	/* Linux */
	OS_LINUX,
	OS_LINUX_1X,
	OS_LINUX_2X,
	OS_LINUX_20X,
	OS_LINUX_22X,
	OS_LINUX_24X,
	OS_LINUX_2418,
	OS_LINUX_25X,
	OS_LINUX_26X,
	OS_LINUX_267,
	OS_LINUX_268,
	/* Sun Solaris */
	/* SunOS??? */
	OS_SOLARIS,
	OS_SOLARIS_25,
	OS_SOLARIS_251,
	OS_SOLARIS_26,
	OS_SOLARIS_7,
	OS_SOLARIS_8,
	OS_SOLARIS_9,
	OS_SOLARIS_10,
	/* Cisco IOS */
	OS_IOS,
	OS_IOS_11X,
	OS_IOS_12X,
	OS_IOS_PIX,
	OS_IOS_PIX_5X,
	OS_IOS_PIX_6X,
	/* Novell Netware */
	OS_NETWARE,
	OS_NETWARE_5X,
	OS_NETWARE_50,
	OS_NETWARE_6X,
	OS_NETWARE_60,
	OS_NETWARE_60_SP5,
	/* * * * * * Embedded OSes * * * * */
	/* Moxa Technologies NPort Express Serial<->Ethernet Bridges */
	/* Models: DE-311 */
	OS_MOXA_NPORT_EXP,
	/* Symbol Technologies Spectrum24 Client Bridge CB-1000-0000-US */
	OS_SYMBOL_SPEC24,
	/* Atop Technologies Serial<->Ethernet Gateways */
	/* http://www.atop.com.tw/e/product/serial-ethernet-server.htm */
	OS_ATOP_GW,
	OS_ATOP_GW21SW_MAXI,
	/* Perle IOLan : http://perle.com/  */
	OS_PERLE_IOLAN,
	OS_3COM_WWB, /* 3Com Wireless Workgroup Bridge */
	/* VMWare: software virtual machine */
	OS_VMWARE,
	OS_VMWARE_5X,

	OS_DEBUG_HIGHLIGHT /* used for highlighting various results */
	/* fin */
};

#define OS_TREE_MAXCHILD		3
#define OS_TREE_MAXPARENTS		3

int os_tree_init(void);
void os_tree_reset(void);
void os_tree_apply(int os, int weight, int os_stop);
void os_calculate(char *buf, size_t buflen);

#ifdef __cplusplus
}
#endif

#endif /* CLASSIFY_H */

